// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/settings/v1beta1/settings.proto

package settings

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Defines the onboarding states for SCC
//
// Potentially is just an indicator that a user has reviewed some subset of
// our configuration surface, even if it's still currently set to its
// API-default state.
type Settings_OnboardingState int32

const (
	// No onboarding state has been set. Should not be seen in practice, but
	// should be functionally equivalent to DISABLED.
	Settings_ONBOARDING_STATE_UNSPECIFIED Settings_OnboardingState = 0
	// SCC is fully on boarded
	Settings_ENABLED Settings_OnboardingState = 1
	// SCC has been disabled after being on boarded
	Settings_DISABLED Settings_OnboardingState = 2
	// SCC's onboarding tier has been explicitly set
	Settings_BILLING_SELECTED Settings_OnboardingState = 3
	// SCC's CTD FindingsProviders have been chosen
	Settings_PROVIDERS_SELECTED Settings_OnboardingState = 4
	// SCC's Service-Resource mappings have been set
	Settings_RESOURCES_SELECTED Settings_OnboardingState = 5
	// SCC's core Service Account was created
	Settings_ORG_SERVICE_ACCOUNT_CREATED Settings_OnboardingState = 6
)

var Settings_OnboardingState_name = map[int32]string{
	0: "ONBOARDING_STATE_UNSPECIFIED",
	1: "ENABLED",
	2: "DISABLED",
	3: "BILLING_SELECTED",
	4: "PROVIDERS_SELECTED",
	5: "RESOURCES_SELECTED",
	6: "ORG_SERVICE_ACCOUNT_CREATED",
}

var Settings_OnboardingState_value = map[string]int32{
	"ONBOARDING_STATE_UNSPECIFIED": 0,
	"ENABLED":                      1,
	"DISABLED":                     2,
	"BILLING_SELECTED":             3,
	"PROVIDERS_SELECTED":           4,
	"RESOURCES_SELECTED":           5,
	"ORG_SERVICE_ACCOUNT_CREATED":  6,
}

func (x Settings_OnboardingState) String() string {
	return proto.EnumName(Settings_OnboardingState_name, int32(x))
}

func (Settings_OnboardingState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c7ed44b5fe59445, []int{0, 0}
}

// Common configuration settings for all of Security Center.
type Settings struct {
	// The relative resource name of the settings resource.
	// Formats:
	//  * `organizations/{organization}/settings`
	//  * `folders/{folder}/settings`
	//  * `projects/{project}/settings`
	//  * `projects/{project}/locations/{location}/clusters/{cluster}/settings`
	//  * `projects/{project}/regions/{region}/clusters/{cluster}/settings`
	//  * `projects/{project}/zones/{zone}/clusters/{cluster}/settings`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Billing settings
	BillingSettings *BillingSettings `protobuf:"bytes,2,opt,name=billing_settings,json=billingSettings,proto3" json:"billing_settings,omitempty"`
	// An enum representing the current on boarding state of SCC.
	State Settings_OnboardingState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.securitycenter.settings.v1beta1.Settings_OnboardingState" json:"state,omitempty"`
	// Output only. The organization-level service account to be used for security center
	// components. The component must have permission to "act as" the service
	// account.
	OrgServiceAccount string `protobuf:"bytes,5,opt,name=org_service_account,json=orgServiceAccount,proto3" json:"org_service_account,omitempty"`
	// Sink settings.
	SinkSettings *SinkSettings `protobuf:"bytes,6,opt,name=sink_settings,json=sinkSettings,proto3" json:"sink_settings,omitempty"`
	// The settings for detectors and/or scanners.
	ComponentSettings map[string]*ComponentSettings `protobuf:"bytes,7,rep,name=component_settings,json=componentSettings,proto3" json:"component_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Detector group settings for all Security Center components.
	// The key is the name of the detector group and the value is the settings for
	// that group.
	DetectorGroupSettings map[string]*Settings_DetectorGroupSettings `protobuf:"bytes,8,rep,name=detector_group_settings,json=detectorGroupSettings,proto3" json:"detector_group_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A fingerprint used for optimistic concurrency. If none is provided
	// on updates then the existing metadata will be blindly overwritten.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. The time these settings were last updated.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Settings) Reset()         { *m = Settings{} }
func (m *Settings) String() string { return proto.CompactTextString(m) }
func (*Settings) ProtoMessage()    {}
func (*Settings) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7ed44b5fe59445, []int{0}
}

func (m *Settings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Settings.Unmarshal(m, b)
}
func (m *Settings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Settings.Marshal(b, m, deterministic)
}
func (m *Settings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Settings.Merge(m, src)
}
func (m *Settings) XXX_Size() int {
	return xxx_messageInfo_Settings.Size(m)
}
func (m *Settings) XXX_DiscardUnknown() {
	xxx_messageInfo_Settings.DiscardUnknown(m)
}

var xxx_messageInfo_Settings proto.InternalMessageInfo

func (m *Settings) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Settings) GetBillingSettings() *BillingSettings {
	if m != nil {
		return m.BillingSettings
	}
	return nil
}

func (m *Settings) GetState() Settings_OnboardingState {
	if m != nil {
		return m.State
	}
	return Settings_ONBOARDING_STATE_UNSPECIFIED
}

func (m *Settings) GetOrgServiceAccount() string {
	if m != nil {
		return m.OrgServiceAccount
	}
	return ""
}

func (m *Settings) GetSinkSettings() *SinkSettings {
	if m != nil {
		return m.SinkSettings
	}
	return nil
}

func (m *Settings) GetComponentSettings() map[string]*ComponentSettings {
	if m != nil {
		return m.ComponentSettings
	}
	return nil
}

func (m *Settings) GetDetectorGroupSettings() map[string]*Settings_DetectorGroupSettings {
	if m != nil {
		return m.DetectorGroupSettings
	}
	return nil
}

func (m *Settings) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Settings) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// The DetectorGroupSettings define the configuration for a detector group.
type Settings_DetectorGroupSettings struct {
	// The state determines if the group is enabled or not.
	State                ComponentEnablementState `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.securitycenter.settings.v1beta1.ComponentEnablementState" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Settings_DetectorGroupSettings) Reset()         { *m = Settings_DetectorGroupSettings{} }
func (m *Settings_DetectorGroupSettings) String() string { return proto.CompactTextString(m) }
func (*Settings_DetectorGroupSettings) ProtoMessage()    {}
func (*Settings_DetectorGroupSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7ed44b5fe59445, []int{0, 0}
}

func (m *Settings_DetectorGroupSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Settings_DetectorGroupSettings.Unmarshal(m, b)
}
func (m *Settings_DetectorGroupSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Settings_DetectorGroupSettings.Marshal(b, m, deterministic)
}
func (m *Settings_DetectorGroupSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Settings_DetectorGroupSettings.Merge(m, src)
}
func (m *Settings_DetectorGroupSettings) XXX_Size() int {
	return xxx_messageInfo_Settings_DetectorGroupSettings.Size(m)
}
func (m *Settings_DetectorGroupSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_Settings_DetectorGroupSettings.DiscardUnknown(m)
}

var xxx_messageInfo_Settings_DetectorGroupSettings proto.InternalMessageInfo

func (m *Settings_DetectorGroupSettings) GetState() ComponentEnablementState {
	if m != nil {
		return m.State
	}
	return ComponentEnablementState_COMPONENT_ENABLEMENT_STATE_UNSPECIFIED
}

func init() {
	proto.RegisterEnum("google.cloud.securitycenter.settings.v1beta1.Settings_OnboardingState", Settings_OnboardingState_name, Settings_OnboardingState_value)
	proto.RegisterType((*Settings)(nil), "google.cloud.securitycenter.settings.v1beta1.Settings")
	proto.RegisterMapType((map[string]*ComponentSettings)(nil), "google.cloud.securitycenter.settings.v1beta1.Settings.ComponentSettingsEntry")
	proto.RegisterMapType((map[string]*Settings_DetectorGroupSettings)(nil), "google.cloud.securitycenter.settings.v1beta1.Settings.DetectorGroupSettingsEntry")
	proto.RegisterType((*Settings_DetectorGroupSettings)(nil), "google.cloud.securitycenter.settings.v1beta1.Settings.DetectorGroupSettings")
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/settings/v1beta1/settings.proto", fileDescriptor_1c7ed44b5fe59445)
}

var fileDescriptor_1c7ed44b5fe59445 = []byte{
	// 891 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xc1, 0x6e, 0xdb, 0x36,
	0x18, 0x9e, 0xec, 0x26, 0x4d, 0x99, 0x74, 0x75, 0xb9, 0xb5, 0x73, 0xdd, 0x02, 0x35, 0x0a, 0x6c,
	0xc8, 0xa1, 0x90, 0x9a, 0xf4, 0x32, 0x28, 0x18, 0x5a, 0x5b, 0x66, 0x03, 0x03, 0x9e, 0x9d, 0x49,
	0x4e, 0x0e, 0x83, 0x01, 0x81, 0x92, 0x19, 0x55, 0x8b, 0x4c, 0x0a, 0x14, 0x15, 0x20, 0xcd, 0x7a,
	0xdc, 0x61, 0x2f, 0xb0, 0x87, 0x18, 0xb0, 0xe3, 0x5e, 0xa2, 0x87, 0x3d, 0xc3, 0xce, 0x7d, 0x82,
	0x5d, 0x06, 0x0c, 0x14, 0x25, 0x45, 0xf2, 0xbc, 0x62, 0x0e, 0x7a, 0xf2, 0xcf, 0xff, 0xff, 0xbf,
	0x8f, 0x1f, 0x7f, 0x7e, 0xa2, 0xc1, 0x41, 0xc0, 0x58, 0x10, 0x11, 0xc3, 0x8f, 0x58, 0x3a, 0x37,
	0x12, 0xe2, 0xa7, 0x3c, 0x14, 0x17, 0x3e, 0xa1, 0x82, 0x70, 0x23, 0x21, 0x42, 0x84, 0x34, 0x48,
	0x8c, 0xf3, 0x3d, 0x8f, 0x08, 0xbc, 0x57, 0x26, 0xf4, 0x98, 0x33, 0xc1, 0xe0, 0x53, 0x05, 0xd6,
	0x33, 0xb0, 0x5e, 0x07, 0xeb, 0x65, 0x6f, 0x0e, 0xee, 0x3c, 0xce, 0xb7, 0xc2, 0x71, 0x68, 0x9c,
	0x86, 0x24, 0x9a, 0xbb, 0x1e, 0x79, 0x8d, 0xcf, 0x43, 0xc6, 0x15, 0x5d, 0xe7, 0x41, 0xa5, 0x81,
	0x93, 0x84, 0xa5, 0xdc, 0x27, 0x79, 0xc9, 0x5a, 0x4b, 0xa6, 0x17, 0x46, 0x51, 0x48, 0x03, 0xb7,
	0x2e, 0xb7, 0x83, 0xd6, 0x22, 0xf1, 0xd9, 0x22, 0x66, 0x94, 0x50, 0xb1, 0x4c, 0xf3, 0x72, 0xbd,
	0x91, 0x85, 0xf4, 0x6c, 0x99, 0xa1, 0x98, 0x44, 0xb6, 0xf2, 0xd2, 0x53, 0x43, 0x84, 0x0b, 0x92,
	0x08, 0xbc, 0x88, 0xf3, 0x86, 0x47, 0x95, 0x49, 0x60, 0x4a, 0x99, 0xc0, 0x22, 0x64, 0x34, 0x87,
	0x3f, 0xf9, 0x7b, 0x07, 0x6c, 0x39, 0x39, 0x23, 0x84, 0xe0, 0x06, 0xc5, 0x0b, 0xd2, 0xd6, 0xba,
	0xda, 0xee, 0x2d, 0x3b, 0x8b, 0xe1, 0x6b, 0xd0, 0x5a, 0x1e, 0x41, 0xbb, 0xd1, 0xd5, 0x76, 0xb7,
	0xf7, 0xbf, 0xd1, 0xd7, 0xb9, 0x32, 0xbd, 0xaf, 0x58, 0x8a, 0xcd, 0xec, 0x3b, 0x5e, 0x3d, 0x01,
	0x67, 0x60, 0x23, 0x11, 0x58, 0x90, 0x76, 0xb3, 0xab, 0xed, 0x7e, 0xba, 0xff, 0x6a, 0x3d, 0xfa,
	0x82, 0x46, 0x9f, 0x50, 0x8f, 0x61, 0x3e, 0x97, 0xcc, 0x92, 0xcd, 0x56, 0xa4, 0xf0, 0x39, 0xf8,
	0x8c, 0x71, 0x79, 0x06, 0x7e, 0x1e, 0xfa, 0xc4, 0xc5, 0xbe, 0xcf, 0x52, 0x2a, 0xda, 0x1b, 0xf2,
	0xa8, 0xfd, 0xe6, 0x9f, 0xbd, 0xa6, 0x7d, 0x97, 0xf1, 0xc0, 0x51, 0xe5, 0x9e, 0xaa, 0x42, 0x17,
	0xdc, 0xae, 0xcd, 0xbc, 0xbd, 0x99, 0x9d, 0xdc, 0x5c, 0x53, 0x5a, 0x48, 0xcf, 0xca, 0x63, 0xef,
	0x24, 0x95, 0x15, 0xfc, 0x11, 0xc0, 0x7f, 0x7b, 0xa3, 0x7d, 0xb3, 0xdb, 0xdc, 0xdd, 0xde, 0xff,
	0xf6, 0x9a, 0x03, 0xb0, 0x0a, 0xc2, 0x22, 0x83, 0xa8, 0xe0, 0x17, 0xf6, 0x5d, 0x7f, 0x39, 0x0f,
	0x7f, 0xd6, 0xc0, 0x17, 0x73, 0x22, 0x88, 0x2f, 0x18, 0x77, 0x03, 0xce, 0xd2, 0xf8, 0x4a, 0xc3,
	0x56, 0xa6, 0xe1, 0xbb, 0x6b, 0x6a, 0x18, 0xe4, 0xac, 0x87, 0x92, 0xb4, 0xae, 0xe3, 0xde, 0x7c,
	0x55, 0x4d, 0x7a, 0x8f, 0x08, 0x1c, 0xb4, 0x6f, 0x29, 0xef, 0xc9, 0x18, 0xbe, 0x04, 0xdb, 0x69,
	0x3c, 0xc7, 0x82, 0xb8, 0xd2, 0xd4, 0x6d, 0x90, 0x0d, 0xbf, 0x53, 0x48, 0x2a, 0x1c, 0xaf, 0x4f,
	0x0b, 0xc7, 0xab, 0x7b, 0x04, 0x0a, 0x23, 0xb3, 0x9d, 0x14, 0xdc, 0x5b, 0x29, 0xe5, 0xca, 0x6c,
	0xda, 0x75, 0xcc, 0x56, 0x8e, 0x18, 0x51, 0xec, 0x45, 0x64, 0x21, 0x87, 0x5a, 0x31, 0x5b, 0xe7,
	0x27, 0x0d, 0xdc, 0x5f, 0x7d, 0x0d, 0xb0, 0x05, 0x9a, 0x67, 0xe4, 0x22, 0xff, 0xc4, 0x64, 0x08,
	0x8f, 0xc1, 0xc6, 0x39, 0x8e, 0x52, 0x92, 0x7f, 0x56, 0x2f, 0xae, 0x29, 0xa5, 0x74, 0x98, 0x62,
	0x33, 0x1b, 0x5f, 0x6b, 0x9d, 0x5f, 0x34, 0xd0, 0xf9, 0xef, 0xab, 0x58, 0xa1, 0xc5, 0xab, 0x6b,
	0x19, 0x7d, 0xcc, 0xeb, 0xaf, 0x08, 0x7b, 0xf2, 0xbb, 0x06, 0xee, 0x2c, 0x7d, 0xa8, 0xb0, 0x0b,
	0x1e, 0x4d, 0xc6, 0xfd, 0x49, 0xcf, 0x1e, 0x0c, 0xc7, 0x87, 0xae, 0x33, 0xed, 0x4d, 0x91, 0x7b,
	0x3c, 0x76, 0x8e, 0x90, 0x35, 0x7c, 0x35, 0x44, 0x83, 0xd6, 0x27, 0x70, 0x1b, 0xdc, 0x44, 0xe3,
	0x5e, 0x7f, 0x84, 0x06, 0x2d, 0x0d, 0xee, 0x80, 0xad, 0xc1, 0xd0, 0x51, 0xab, 0x06, 0xfc, 0x1c,
	0xb4, 0xfa, 0xc3, 0xd1, 0x28, 0x43, 0xa2, 0x11, 0xb2, 0xa6, 0x68, 0xd0, 0x6a, 0xc2, 0xfb, 0x00,
	0x1e, 0xd9, 0x93, 0x93, 0xe1, 0x00, 0xd9, 0xce, 0x55, 0xfe, 0x86, 0xcc, 0xdb, 0xc8, 0x99, 0x1c,
	0xdb, 0x16, 0xaa, 0xe4, 0x37, 0xe0, 0x63, 0xf0, 0x70, 0x62, 0x4b, 0x06, 0xfb, 0x64, 0x68, 0x21,
	0xb7, 0x67, 0x59, 0x93, 0xe3, 0xf1, 0xd4, 0xb5, 0x6c, 0xd4, 0x93, 0x0d, 0x9b, 0xe6, 0x1f, 0x8d,
	0xf7, 0xbd, 0x77, 0x0d, 0xf0, 0xd5, 0xd2, 0x24, 0xd4, 0x94, 0x70, 0x1c, 0x26, 0xba, 0xcf, 0x16,
	0x46, 0xe9, 0xb2, 0x2f, 0x19, 0x0f, 0x30, 0x0d, 0xdf, 0xa8, 0x27, 0xd7, 0xb8, 0xac, 0x2e, 0xdf,
	0x96, 0xef, 0x3b, 0x7c, 0x70, 0xca, 0xa2, 0x39, 0xe1, 0x89, 0x71, 0xa9, 0x82, 0x4a, 0xe9, 0x61,
	0xcc, 0xd9, 0x0f, 0xc4, 0x17, 0x89, 0x71, 0x99, 0x47, 0x95, 0xa2, 0xb5, 0xa2, 0x18, 0x31, 0xbf,
	0xd8, 0xad, 0x08, 0xdf, 0x1a, 0x7e, 0x94, 0x26, 0x22, 0xdb, 0x20, 0x8f, 0x2a, 0x24, 0x2f, 0x56,
	0x90, 0x70, 0x12, 0x28, 0x0a, 0x15, 0x7c, 0x98, 0xe0, 0x60, 0x05, 0xc1, 0x1b, 0x46, 0x49, 0x62,
	0x5c, 0xca, 0x9f, 0x0f, 0x82, 0xfb, 0xbf, 0x35, 0xc0, 0x33, 0x9f, 0x2d, 0xd6, 0xf2, 0x59, 0xff,
	0x76, 0x31, 0xe0, 0x23, 0xf9, 0x04, 0x1c, 0x69, 0xdf, 0x4f, 0x73, 0x78, 0xc0, 0x22, 0x4c, 0x03,
	0x9d, 0xf1, 0xc0, 0x08, 0x08, 0xcd, 0x1e, 0x08, 0xe3, 0xea, 0x6e, 0xfe, 0xdf, 0xbf, 0xec, 0x41,
	0x91, 0xf8, 0x4b, 0xd3, 0x7e, 0x6d, 0x3c, 0x3d, 0x54, 0xcc, 0x56, 0x26, 0xcc, 0xc9, 0xa1, 0x96,
	0x12, 0x56, 0xfa, 0xfd, 0x64, 0xaf, 0x2f, 0xa1, 0xef, 0x8a, 0xf6, 0x59, 0xd6, 0x3e, 0xab, 0xb7,
	0xcf, 0x8a, 0xf6, 0xd9, 0x89, 0xda, 0xe9, 0x7d, 0xe3, 0x99, 0x6a, 0x37, 0xcd, 0xac, 0xdf, 0x34,
	0xeb, 0x00, 0xb9, 0x56, 0x08, 0xd3, 0xcc, 0x21, 0xde, 0x66, 0x76, 0xa8, 0xe7, 0xff, 0x04, 0x00,
	0x00, 0xff, 0xff, 0xfc, 0x78, 0xd7, 0xa5, 0x6c, 0x09, 0x00, 0x00,
}
