// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/environment.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents an environment state. When a environment is pointed to a new
// agent version, the environment is temporarily set to the `LOADING` state.
// During that time, the environment keeps on serving the previous version of
// the agent. After the new agent version is done loading, the environment is
// set back to the `RUNNING` state.
type Environment_State int32

const (
	// Not specified. This value is not used.
	Environment_STATE_UNSPECIFIED Environment_State = 0
	// Stopped.
	Environment_STOPPED Environment_State = 1
	// Loading.
	Environment_LOADING Environment_State = 2
	// Running.
	Environment_RUNNING Environment_State = 3
)

var Environment_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "STOPPED",
	2: "LOADING",
	3: "RUNNING",
}

var Environment_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"STOPPED":           1,
	"LOADING":           2,
	"RUNNING":           3,
}

func (x Environment_State) String() string {
	return proto.EnumName(Environment_State_name, int32(x))
}

func (Environment_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e1eda8d735fabace, []int{0, 0}
}

// Represents an agent environment.
type Environment struct {
	// Output only. The unique identifier of this agent environment.
	// Format: `projects/<Project ID>/agent/environments/<Environment ID>`.
	// For Environment ID, "-" is reserved for 'draft' environment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The developer-provided description for this environment.
	// The maximum length is 500 characters. If exceeded, the request is rejected.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The agent version loaded into this environment.
	// Format: `projects/<Project ID>/agent/versions/<Version ID>`.
	AgentVersion string `protobuf:"bytes,3,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	// Output only. The state of this environment. This field is read-only, i.e., it cannot be
	// set by create and update methods.
	State Environment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.dialogflow.v2.Environment_State" json:"state,omitempty"`
	// Output only. The last update time of this environment. This field is read-only, i.e., it
	// cannot be set by create and update methods.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Environment) Reset()         { *m = Environment{} }
func (m *Environment) String() string { return proto.CompactTextString(m) }
func (*Environment) ProtoMessage()    {}
func (*Environment) Descriptor() ([]byte, []int) {
	return fileDescriptor_e1eda8d735fabace, []int{0}
}

func (m *Environment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Environment.Unmarshal(m, b)
}
func (m *Environment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Environment.Marshal(b, m, deterministic)
}
func (m *Environment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Environment.Merge(m, src)
}
func (m *Environment) XXX_Size() int {
	return xxx_messageInfo_Environment.Size(m)
}
func (m *Environment) XXX_DiscardUnknown() {
	xxx_messageInfo_Environment.DiscardUnknown(m)
}

var xxx_messageInfo_Environment proto.InternalMessageInfo

func (m *Environment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Environment) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Environment) GetAgentVersion() string {
	if m != nil {
		return m.AgentVersion
	}
	return ""
}

func (m *Environment) GetState() Environment_State {
	if m != nil {
		return m.State
	}
	return Environment_STATE_UNSPECIFIED
}

func (m *Environment) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// The request message for [Environments.ListEnvironments][google.cloud.dialogflow.v2.Environments.ListEnvironments].
type ListEnvironmentsRequest struct {
	// Required. The agent to list all environments from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEnvironmentsRequest) Reset()         { *m = ListEnvironmentsRequest{} }
func (m *ListEnvironmentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListEnvironmentsRequest) ProtoMessage()    {}
func (*ListEnvironmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e1eda8d735fabace, []int{1}
}

func (m *ListEnvironmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEnvironmentsRequest.Unmarshal(m, b)
}
func (m *ListEnvironmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEnvironmentsRequest.Marshal(b, m, deterministic)
}
func (m *ListEnvironmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEnvironmentsRequest.Merge(m, src)
}
func (m *ListEnvironmentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListEnvironmentsRequest.Size(m)
}
func (m *ListEnvironmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEnvironmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEnvironmentsRequest proto.InternalMessageInfo

func (m *ListEnvironmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEnvironmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEnvironmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Environments.ListEnvironments][google.cloud.dialogflow.v2.Environments.ListEnvironments].
type ListEnvironmentsResponse struct {
	// The list of agent environments. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Environments []*Environment `protobuf:"bytes,1,rep,name=environments,proto3" json:"environments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEnvironmentsResponse) Reset()         { *m = ListEnvironmentsResponse{} }
func (m *ListEnvironmentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEnvironmentsResponse) ProtoMessage()    {}
func (*ListEnvironmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e1eda8d735fabace, []int{2}
}

func (m *ListEnvironmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEnvironmentsResponse.Unmarshal(m, b)
}
func (m *ListEnvironmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEnvironmentsResponse.Marshal(b, m, deterministic)
}
func (m *ListEnvironmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEnvironmentsResponse.Merge(m, src)
}
func (m *ListEnvironmentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEnvironmentsResponse.Size(m)
}
func (m *ListEnvironmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEnvironmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEnvironmentsResponse proto.InternalMessageInfo

func (m *ListEnvironmentsResponse) GetEnvironments() []*Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

func (m *ListEnvironmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2.Environment_State", Environment_State_name, Environment_State_value)
	proto.RegisterType((*Environment)(nil), "google.cloud.dialogflow.v2.Environment")
	proto.RegisterType((*ListEnvironmentsRequest)(nil), "google.cloud.dialogflow.v2.ListEnvironmentsRequest")
	proto.RegisterType((*ListEnvironmentsResponse)(nil), "google.cloud.dialogflow.v2.ListEnvironmentsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/environment.proto", fileDescriptor_e1eda8d735fabace)
}

var fileDescriptor_e1eda8d735fabace = []byte{
	// 727 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x41, 0x4f, 0x13, 0x5b,
	0x14, 0x7e, 0x77, 0x4a, 0x79, 0x8f, 0x5b, 0x78, 0xaf, 0xef, 0x26, 0x86, 0x52, 0x8d, 0x36, 0x4d,
	0x90, 0x86, 0xc0, 0xdc, 0x64, 0x70, 0x85, 0x31, 0x71, 0xa0, 0x05, 0x89, 0xa4, 0x34, 0x6d, 0x21,
	0xd1, 0x98, 0x34, 0x97, 0xe9, 0xed, 0x30, 0x32, 0x33, 0x77, 0x9c, 0x7b, 0x5b, 0x10, 0xc2, 0xc6,
	0x3f, 0xe0, 0xc2, 0x1f, 0x60, 0xe2, 0xc2, 0x85, 0xae, 0xdc, 0xfb, 0x0b, 0x5c, 0xea, 0x1f, 0x60,
	0xe1, 0xca, 0x5f, 0x60, 0x5c, 0x99, 0x99, 0x3b, 0x65, 0x2e, 0x20, 0x88, 0xbb, 0x39, 0xe7, 0x7c,
	0xe7, 0x9c, 0xef, 0x7c, 0xe7, 0xcc, 0x85, 0x73, 0x36, 0x63, 0xb6, 0x4b, 0xb1, 0xe5, 0xb2, 0x7e,
	0x17, 0x77, 0x1d, 0xe2, 0x32, 0xbb, 0xe7, 0xb2, 0x3d, 0x3c, 0x30, 0x30, 0xf5, 0x07, 0x4e, 0xc8,
	0x7c, 0x8f, 0xfa, 0x42, 0x0f, 0x42, 0x26, 0x18, 0x2a, 0x4a, 0xb4, 0x1e, 0xa3, 0xf5, 0x14, 0xad,
	0x0f, 0x8c, 0xe2, 0x8d, 0xa4, 0x12, 0x09, 0x1c, 0x4c, 0x7c, 0x9f, 0x09, 0x22, 0x1c, 0xe6, 0x73,
	0x99, 0x59, 0xbc, 0xa5, 0x44, 0x7b, 0x0e, 0x75, 0xbb, 0x9d, 0x6d, 0xba, 0x43, 0x06, 0x0e, 0x0b,
	0x13, 0xc0, 0x94, 0x02, 0x08, 0x29, 0x67, 0xfd, 0xd0, 0xa2, 0x49, 0xe8, 0x7a, 0x12, 0x8a, 0xad,
	0xed, 0x7e, 0x0f, 0x53, 0x2f, 0x10, 0xcf, 0x93, 0x60, 0xe9, 0x6c, 0x50, 0x56, 0xf7, 0x08, 0xdf,
	0x3d, 0xd3, 0xfa, 0x04, 0x21, 0x1c, 0x8f, 0x72, 0x41, 0xbc, 0x20, 0x01, 0x4c, 0x2a, 0xad, 0x2d,
	0xd7, 0x39, 0x19, 0xb7, 0xfc, 0x3e, 0x03, 0x73, 0xb5, 0x54, 0x04, 0x34, 0x09, 0x47, 0x7c, 0xe2,
	0xd1, 0x02, 0x28, 0x81, 0xca, 0xd8, 0x52, 0xe6, 0xd8, 0xcc, 0x34, 0x63, 0x07, 0x9a, 0x86, 0xb9,
	0x2e, 0xe5, 0x56, 0xe8, 0x04, 0xd1, 0xcc, 0x05, 0x6d, 0x18, 0x07, 0x4d, 0xd5, 0x8f, 0x2a, 0x70,
	0x82, 0xd8, 0xd4, 0x17, 0x9d, 0x01, 0x0d, 0x79, 0x04, 0xcc, 0xa4, 0xc0, 0xf1, 0x38, 0xb2, 0x25,
	0x03, 0xe8, 0x01, 0xcc, 0x72, 0x41, 0x04, 0x2d, 0x8c, 0x94, 0x40, 0xe5, 0x5f, 0x63, 0x5e, 0xbf,
	0x58, 0x78, 0x5d, 0x61, 0xa8, 0xb7, 0xa2, 0x24, 0xc9, 0x4c, 0x16, 0x40, 0xf7, 0x61, 0xae, 0x1f,
	0x74, 0x89, 0xa0, 0x9d, 0x68, 0xec, 0x42, 0xb6, 0x04, 0x2a, 0x39, 0xa3, 0x38, 0xac, 0x37, 0xd4,
	0x44, 0x6f, 0x0f, 0x35, 0x91, 0xc9, 0x50, 0xe6, 0x44, 0xde, 0x72, 0x0d, 0x66, 0xe3, 0xb2, 0xe8,
	0x1a, 0xfc, 0xbf, 0xd5, 0x36, 0xdb, 0xb5, 0xce, 0x66, 0xbd, 0xd5, 0xa8, 0x2d, 0xaf, 0xad, 0xac,
	0xd5, 0xaa, 0xf9, 0xbf, 0x50, 0x0e, 0xfe, 0xdd, 0x6a, 0x6f, 0x34, 0x1a, 0xb5, 0x6a, 0x1e, 0x44,
	0xc6, 0xfa, 0x86, 0x59, 0x5d, 0xab, 0xaf, 0xe6, 0xb5, 0xc8, 0x68, 0x6e, 0xd6, 0xeb, 0x91, 0x91,
	0x59, 0xec, 0x7c, 0x33, 0x9f, 0xc0, 0x69, 0x85, 0xba, 0xa4, 0x40, 0x02, 0x87, 0xeb, 0x16, 0xf3,
	0xb0, 0x2a, 0xf4, 0x42, 0x10, 0xb2, 0xa7, 0xd4, 0x12, 0x1c, 0x1f, 0x26, 0x5f, 0x47, 0x38, 0xd6,
	0x47, 0xbd, 0x49, 0x8e, 0x0f, 0x15, 0xeb, 0xa8, 0xfc, 0x16, 0xc0, 0xc9, 0x75, 0x87, 0x0b, 0xa5,
	0x10, 0x6f, 0xd2, 0x67, 0x7d, 0xca, 0x05, 0xaa, 0xc1, 0xd1, 0x80, 0x84, 0xd4, 0x17, 0xc9, 0xee,
	0xe6, 0x8f, 0x4d, 0xed, 0x87, 0x39, 0x83, 0xae, 0xc6, 0xa7, 0x99, 0x24, 0xa3, 0x12, 0x1c, 0x0b,
	0x88, 0x4d, 0x3b, 0xdc, 0x39, 0xa0, 0xf1, 0x96, 0xb3, 0x72, 0x79, 0xff, 0x44, 0xde, 0x96, 0x73,
	0x40, 0x51, 0x19, 0xc2, 0x18, 0x21, 0xd8, 0x2e, 0x3d, 0xb5, 0xdf, 0x38, 0xb1, 0x1d, 0x79, 0xcb,
	0x2f, 0x01, 0x2c, 0x9c, 0x27, 0xca, 0x03, 0xe6, 0x73, 0x8a, 0x1e, 0xc2, 0x71, 0x75, 0xc6, 0x02,
	0x28, 0x65, 0x2a, 0x39, 0x63, 0xe6, 0x8a, 0x07, 0xd0, 0x3c, 0x95, 0x8c, 0x6e, 0xc3, 0xff, 0x7c,
	0xba, 0x2f, 0x3a, 0x0a, 0xa5, 0xf8, 0x36, 0x9b, 0x13, 0x91, 0xbb, 0x31, 0x64, 0x64, 0x7c, 0xd4,
	0xe0, 0xb8, 0xca, 0x06, 0x7d, 0x00, 0x30, 0x7f, 0x96, 0x22, 0x5a, 0xb8, 0x8c, 0xc4, 0x05, 0xca,
	0x17, 0xef, 0xfc, 0x59, 0x92, 0x54, 0xa1, 0x6c, 0xbc, 0xf8, 0xf2, 0xf5, 0x95, 0x36, 0x87, 0x66,
	0xa3, 0x77, 0xe8, 0x50, 0xaa, 0x7f, 0xef, 0xe4, 0x28, 0x66, 0xe5, 0x31, 0x1c, 0x9d, 0xba, 0x86,
	0xe2, 0xfe, 0x27, 0x73, 0xea, 0xc2, 0x75, 0x7e, 0x36, 0x1f, 0xed, 0x08, 0x11, 0xf0, 0x45, 0x8c,
	0xf7, 0xf6, 0xce, 0xed, 0x9a, 0xf4, 0xc5, 0x8e, 0x7c, 0x02, 0xe7, 0x03, 0x97, 0x88, 0x1e, 0x0b,
	0xbd, 0xb9, 0xdf, 0xc1, 0xd3, 0x56, 0x4b, 0xaf, 0x01, 0xbc, 0x69, 0x31, 0xef, 0x92, 0x49, 0x97,
	0xf2, 0xca, 0x98, 0x8d, 0xe8, 0xa7, 0x6b, 0x80, 0xc7, 0xd5, 0x04, 0x6f, 0x33, 0x97, 0xf8, 0xb6,
	0xce, 0x42, 0x1b, 0xdb, 0xd4, 0x8f, 0x7f, 0x49, 0x9c, 0x76, 0xfc, 0xd5, 0xd3, 0x7c, 0x37, 0xb5,
	0xbe, 0x03, 0xf0, 0x46, 0xd3, 0xaa, 0x2b, 0xef, 0xb4, 0xe2, 0xaa, 0x2c, 0xb7, 0x1c, 0xb7, 0xaf,
	0xa6, 0xed, 0xb7, 0x8c, 0xed, 0xd1, 0xb8, 0xea, 0xc2, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd8,
	0x27, 0xcc, 0xe4, 0xef, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EnvironmentsClient is the client API for Environments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EnvironmentsClient interface {
	// Returns the list of all non-draft environments of the specified agent.
	ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error)
}

type environmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewEnvironmentsClient(cc grpc.ClientConnInterface) EnvironmentsClient {
	return &environmentsClient{cc}
}

func (c *environmentsClient) ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error) {
	out := new(ListEnvironmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Environments/ListEnvironments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EnvironmentsServer is the server API for Environments service.
type EnvironmentsServer interface {
	// Returns the list of all non-draft environments of the specified agent.
	ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error)
}

// UnimplementedEnvironmentsServer can be embedded to have forward compatible implementations.
type UnimplementedEnvironmentsServer struct {
}

func (*UnimplementedEnvironmentsServer) ListEnvironments(ctx context.Context, req *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironments not implemented")
}

func RegisterEnvironmentsServer(s *grpc.Server, srv EnvironmentsServer) {
	s.RegisterService(&_Environments_serviceDesc, srv)
}

func _Environments_ListEnvironments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnvironmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Environments/ListEnvironments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, req.(*ListEnvironmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Environments_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Environments",
	HandlerType: (*EnvironmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEnvironments",
			Handler:    _Environments_ListEnvironments_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/environment.proto",
}
