// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/reservation/v1beta1/reservation.proto

package reservation

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Commitment plan defines the current committed period. Capacity commitment
// cannot be deleted during it's committed period.
type CapacityCommitment_CommitmentPlan int32

const (
	// Invalid plan value. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED CapacityCommitment_CommitmentPlan = 0
	// Flex commitments have committed period of 1 minute after becoming ACTIVE.
	// After that, they are not in a committed period anymore and can be removed
	// any time.
	CapacityCommitment_FLEX CapacityCommitment_CommitmentPlan = 3
	// Monthly commitments have a committed period of 30 days after becoming
	// ACTIVE.
	CapacityCommitment_MONTHLY CapacityCommitment_CommitmentPlan = 2
	// Annual commitments have a committed period of 365 days after becoming
	// ACTIVE.
	CapacityCommitment_ANNUAL CapacityCommitment_CommitmentPlan = 4
)

var CapacityCommitment_CommitmentPlan_name = map[int32]string{
	0: "COMMITMENT_PLAN_UNSPECIFIED",
	3: "FLEX",
	2: "MONTHLY",
	4: "ANNUAL",
}

var CapacityCommitment_CommitmentPlan_value = map[string]int32{
	"COMMITMENT_PLAN_UNSPECIFIED": 0,
	"FLEX":                        3,
	"MONTHLY":                     2,
	"ANNUAL":                      4,
}

func (x CapacityCommitment_CommitmentPlan) String() string {
	return proto.EnumName(CapacityCommitment_CommitmentPlan_name, int32(x))
}

func (CapacityCommitment_CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{1, 0}
}

// Capacity commitment can either become ACTIVE right away or transition
// from PENDING to ACTIVE or FAILED.
type CapacityCommitment_State int32

const (
	// Invalid state value.
	CapacityCommitment_STATE_UNSPECIFIED CapacityCommitment_State = 0
	// Capacity commitment is pending provisioning. Pending capacity commitment
	// does not contribute to the parent's slot_capacity.
	CapacityCommitment_PENDING CapacityCommitment_State = 1
	// Once slots are provisioned, capacity commitment becomes active.
	// slot_count is added to the parent's slot_capacity.
	CapacityCommitment_ACTIVE CapacityCommitment_State = 2
	// Capacity commitment is failed to be activated by the backend.
	CapacityCommitment_FAILED CapacityCommitment_State = 3
)

var CapacityCommitment_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	2: "ACTIVE",
	3: "FAILED",
}

var CapacityCommitment_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"ACTIVE":            2,
	"FAILED":            3,
}

func (x CapacityCommitment_State) String() string {
	return proto.EnumName(CapacityCommitment_State_name, int32(x))
}

func (CapacityCommitment_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{1, 1}
}

// Types of job, which could be specified when using the reservation.
type Assignment_JobType int32

const (
	// Invalid type. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	Assignment_JOB_TYPE_UNSPECIFIED Assignment_JobType = 0
	// Pipeline (load/export) jobs from the project will use the reservation.
	Assignment_PIPELINE Assignment_JobType = 1
	// Query jobs from the project will use the reservation.
	Assignment_QUERY Assignment_JobType = 2
)

var Assignment_JobType_name = map[int32]string{
	0: "JOB_TYPE_UNSPECIFIED",
	1: "PIPELINE",
	2: "QUERY",
}

var Assignment_JobType_value = map[string]int32{
	"JOB_TYPE_UNSPECIFIED": 0,
	"PIPELINE":             1,
	"QUERY":                2,
}

func (x Assignment_JobType) String() string {
	return proto.EnumName(Assignment_JobType_name, int32(x))
}

func (Assignment_JobType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{16, 0}
}

// Assignment will remain in PENDING state if no active capacity commitment is
// present. It will become ACTIVE when some capacity commitment becomes
// active.
type Assignment_State int32

const (
	// Invalid state value.
	Assignment_STATE_UNSPECIFIED Assignment_State = 0
	// Queries from assignee will be executed as on-demand, if related
	// assignment is pending.
	Assignment_PENDING Assignment_State = 1
	// Assignment is ready.
	Assignment_ACTIVE Assignment_State = 2
)

var Assignment_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	2: "ACTIVE",
}

var Assignment_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"ACTIVE":            2,
}

func (x Assignment_State) String() string {
	return proto.EnumName(Assignment_State_name, int32(x))
}

func (Assignment_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{16, 1}
}

// A reservation is a mechanism used to guarantee slots to users.
type Reservation struct {
	// The resource name of the reservation, e.g.,
	// "projects/*/locations/*/reservations/team1-prod".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Minimum slots available to this reservation. A slot is a unit of
	// computational power in BigQuery, and serves as the unit of parallelism.
	// Queries using this reservation might use more slots during runtime if
	// ignore_idle_slots is set to false.
	// If the new reservation's slot capacity exceed the parent's slot capacity or
	// if total slot capacity of the new reservation and its siblings exceeds the
	// parent's slot capacity, the request will fail with
	// `google.rpc.Code.RESOURCE_EXHAUSTED`.
	SlotCapacity int64 `protobuf:"varint,2,opt,name=slot_capacity,json=slotCapacity,proto3" json:"slot_capacity,omitempty"`
	// If false, any query using this reservation will use idle slots from other
	// reservations within the same admin project. If true, a query using this
	// reservation will execute with the slot capacity specified above at most.
	IgnoreIdleSlots      bool     `protobuf:"varint,4,opt,name=ignore_idle_slots,json=ignoreIdleSlots,proto3" json:"ignore_idle_slots,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Reservation) Reset()         { *m = Reservation{} }
func (m *Reservation) String() string { return proto.CompactTextString(m) }
func (*Reservation) ProtoMessage()    {}
func (*Reservation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{0}
}

func (m *Reservation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Reservation.Unmarshal(m, b)
}
func (m *Reservation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Reservation.Marshal(b, m, deterministic)
}
func (m *Reservation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Reservation.Merge(m, src)
}
func (m *Reservation) XXX_Size() int {
	return xxx_messageInfo_Reservation.Size(m)
}
func (m *Reservation) XXX_DiscardUnknown() {
	xxx_messageInfo_Reservation.DiscardUnknown(m)
}

var xxx_messageInfo_Reservation proto.InternalMessageInfo

func (m *Reservation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Reservation) GetSlotCapacity() int64 {
	if m != nil {
		return m.SlotCapacity
	}
	return 0
}

func (m *Reservation) GetIgnoreIdleSlots() bool {
	if m != nil {
		return m.IgnoreIdleSlots
	}
	return false
}

// Capacity commitment is a way to purchase compute capacity for BigQuery jobs
// (in the form of slots) with some committed period of usage. Monthly and
// annual commitments renew by default. Only flex commitments can be removed. In
// order to remove monthly or annual commitments, their plan needs to be changed
// to flex first.
//
// A capacity commitment resource exists as a child resource of the admin
// project.
type CapacityCommitment struct {
	// Output only. The resource name of the capacity commitment, e.g.,
	//    projects/myproject/locations/US/capacityCommitments/123
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of slots in this commitment.
	SlotCount int64 `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
	// Capacity commitment commitment plan.
	Plan CapacityCommitment_CommitmentPlan `protobuf:"varint,3,opt,name=plan,proto3,enum=google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_CommitmentPlan" json:"plan,omitempty"`
	// Output only. State of the commitment.
	State CapacityCommitment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_State" json:"state,omitempty"`
	// Output only. The end of the current commitment period. It is applicable
	// only for ACTIVE capacity commitments.
	CommitmentEndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=commitment_end_time,json=commitmentEndTime,proto3" json:"commitment_end_time,omitempty"`
	// Output only. For FAILED commitment plan, provides the reason of failure.
	FailureStatus *status.Status `protobuf:"bytes,7,opt,name=failure_status,json=failureStatus,proto3" json:"failure_status,omitempty"`
	// The plan this capacity commitment is converted to after commitment_end_time
	// passes. Once the plan is changed, committed period is extended according to
	// commitment plan. Only applicable for MONTHLY and ANNUAL commitments.
	RenewalPlan          CapacityCommitment_CommitmentPlan `protobuf:"varint,8,opt,name=renewal_plan,json=renewalPlan,proto3,enum=google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_CommitmentPlan" json:"renewal_plan,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CapacityCommitment) Reset()         { *m = CapacityCommitment{} }
func (m *CapacityCommitment) String() string { return proto.CompactTextString(m) }
func (*CapacityCommitment) ProtoMessage()    {}
func (*CapacityCommitment) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{1}
}

func (m *CapacityCommitment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CapacityCommitment.Unmarshal(m, b)
}
func (m *CapacityCommitment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CapacityCommitment.Marshal(b, m, deterministic)
}
func (m *CapacityCommitment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CapacityCommitment.Merge(m, src)
}
func (m *CapacityCommitment) XXX_Size() int {
	return xxx_messageInfo_CapacityCommitment.Size(m)
}
func (m *CapacityCommitment) XXX_DiscardUnknown() {
	xxx_messageInfo_CapacityCommitment.DiscardUnknown(m)
}

var xxx_messageInfo_CapacityCommitment proto.InternalMessageInfo

func (m *CapacityCommitment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CapacityCommitment) GetSlotCount() int64 {
	if m != nil {
		return m.SlotCount
	}
	return 0
}

func (m *CapacityCommitment) GetPlan() CapacityCommitment_CommitmentPlan {
	if m != nil {
		return m.Plan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

func (m *CapacityCommitment) GetState() CapacityCommitment_State {
	if m != nil {
		return m.State
	}
	return CapacityCommitment_STATE_UNSPECIFIED
}

func (m *CapacityCommitment) GetCommitmentEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.CommitmentEndTime
	}
	return nil
}

func (m *CapacityCommitment) GetFailureStatus() *status.Status {
	if m != nil {
		return m.FailureStatus
	}
	return nil
}

func (m *CapacityCommitment) GetRenewalPlan() CapacityCommitment_CommitmentPlan {
	if m != nil {
		return m.RenewalPlan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

// The request for
// [ReservationService.CreateReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateReservation].
type CreateReservationRequest struct {
	// Required. Project, location. E.g.,
	//    projects/myproject/locations/US
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The reservation ID. This field must only contain lower case alphanumeric
	// characters or dash. Max length is 64 characters.
	ReservationId string `protobuf:"bytes,2,opt,name=reservation_id,json=reservationId,proto3" json:"reservation_id,omitempty"`
	// Content of the new reservation to create.
	Reservation          *Reservation `protobuf:"bytes,3,opt,name=reservation,proto3" json:"reservation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateReservationRequest) Reset()         { *m = CreateReservationRequest{} }
func (m *CreateReservationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateReservationRequest) ProtoMessage()    {}
func (*CreateReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{2}
}

func (m *CreateReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateReservationRequest.Unmarshal(m, b)
}
func (m *CreateReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateReservationRequest.Marshal(b, m, deterministic)
}
func (m *CreateReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateReservationRequest.Merge(m, src)
}
func (m *CreateReservationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateReservationRequest.Size(m)
}
func (m *CreateReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateReservationRequest proto.InternalMessageInfo

func (m *CreateReservationRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateReservationRequest) GetReservationId() string {
	if m != nil {
		return m.ReservationId
	}
	return ""
}

func (m *CreateReservationRequest) GetReservation() *Reservation {
	if m != nil {
		return m.Reservation
	}
	return nil
}

// The request for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListReservations].
type ListReservationsRequest struct {
	// Required. The parent resource name containing project and location, e.g.:
	//   "projects/myproject/locations/US"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Can be used to filter out reservations based on names, capacity, etc, e.g.:
	// filter="reservation.slot_capacity > 200"
	// filter="reservation.name = \"*dev/*\""
	// Advanced filtering syntax can be
	// [here](https://cloud.google.com/logging/docs/view/advanced-filters).
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReservationsRequest) Reset()         { *m = ListReservationsRequest{} }
func (m *ListReservationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListReservationsRequest) ProtoMessage()    {}
func (*ListReservationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{3}
}

func (m *ListReservationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReservationsRequest.Unmarshal(m, b)
}
func (m *ListReservationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReservationsRequest.Marshal(b, m, deterministic)
}
func (m *ListReservationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReservationsRequest.Merge(m, src)
}
func (m *ListReservationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListReservationsRequest.Size(m)
}
func (m *ListReservationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReservationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListReservationsRequest proto.InternalMessageInfo

func (m *ListReservationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListReservationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListReservationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListReservationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// The response for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListReservations].
type ListReservationsResponse struct {
	// List of reservations visible to the user.
	Reservations []*Reservation `protobuf:"bytes,1,rep,name=reservations,proto3" json:"reservations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReservationsResponse) Reset()         { *m = ListReservationsResponse{} }
func (m *ListReservationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListReservationsResponse) ProtoMessage()    {}
func (*ListReservationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{4}
}

func (m *ListReservationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReservationsResponse.Unmarshal(m, b)
}
func (m *ListReservationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReservationsResponse.Marshal(b, m, deterministic)
}
func (m *ListReservationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReservationsResponse.Merge(m, src)
}
func (m *ListReservationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListReservationsResponse.Size(m)
}
func (m *ListReservationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReservationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListReservationsResponse proto.InternalMessageInfo

func (m *ListReservationsResponse) GetReservations() []*Reservation {
	if m != nil {
		return m.Reservations
	}
	return nil
}

func (m *ListReservationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.GetReservation].
type GetReservationRequest struct {
	// Required. Resource name of the reservation to retrieve. E.g.,
	//    projects/myproject/locations/US/reservations/team1-prod
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReservationRequest) Reset()         { *m = GetReservationRequest{} }
func (m *GetReservationRequest) String() string { return proto.CompactTextString(m) }
func (*GetReservationRequest) ProtoMessage()    {}
func (*GetReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{5}
}

func (m *GetReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReservationRequest.Unmarshal(m, b)
}
func (m *GetReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReservationRequest.Marshal(b, m, deterministic)
}
func (m *GetReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReservationRequest.Merge(m, src)
}
func (m *GetReservationRequest) XXX_Size() int {
	return xxx_messageInfo_GetReservationRequest.Size(m)
}
func (m *GetReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReservationRequest proto.InternalMessageInfo

func (m *GetReservationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteReservation].
type DeleteReservationRequest struct {
	// Required. Resource name of the reservation to retrieve. E.g.,
	//    projects/myproject/locations/US/reservations/team1-prod
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteReservationRequest) Reset()         { *m = DeleteReservationRequest{} }
func (m *DeleteReservationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteReservationRequest) ProtoMessage()    {}
func (*DeleteReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{6}
}

func (m *DeleteReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteReservationRequest.Unmarshal(m, b)
}
func (m *DeleteReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteReservationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteReservationRequest.Merge(m, src)
}
func (m *DeleteReservationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteReservationRequest.Size(m)
}
func (m *DeleteReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteReservationRequest proto.InternalMessageInfo

func (m *DeleteReservationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.UpdateReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateReservation].
type UpdateReservationRequest struct {
	// Content of the reservation to update.
	Reservation *Reservation `protobuf:"bytes,1,opt,name=reservation,proto3" json:"reservation,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateReservationRequest) Reset()         { *m = UpdateReservationRequest{} }
func (m *UpdateReservationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateReservationRequest) ProtoMessage()    {}
func (*UpdateReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{7}
}

func (m *UpdateReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateReservationRequest.Unmarshal(m, b)
}
func (m *UpdateReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateReservationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateReservationRequest.Merge(m, src)
}
func (m *UpdateReservationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateReservationRequest.Size(m)
}
func (m *UpdateReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateReservationRequest proto.InternalMessageInfo

func (m *UpdateReservationRequest) GetReservation() *Reservation {
	if m != nil {
		return m.Reservation
	}
	return nil
}

func (m *UpdateReservationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsRequest struct {
	// Required. Resource name of the parent reservation. E.g.,
	//    projects/myproject/locations/US
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCapacityCommitmentsRequest) Reset()         { *m = ListCapacityCommitmentsRequest{} }
func (m *ListCapacityCommitmentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListCapacityCommitmentsRequest) ProtoMessage()    {}
func (*ListCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{8}
}

func (m *ListCapacityCommitmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCapacityCommitmentsRequest.Unmarshal(m, b)
}
func (m *ListCapacityCommitmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCapacityCommitmentsRequest.Marshal(b, m, deterministic)
}
func (m *ListCapacityCommitmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCapacityCommitmentsRequest.Merge(m, src)
}
func (m *ListCapacityCommitmentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListCapacityCommitmentsRequest.Size(m)
}
func (m *ListCapacityCommitmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCapacityCommitmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCapacityCommitmentsRequest proto.InternalMessageInfo

func (m *ListCapacityCommitmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCapacityCommitmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCapacityCommitmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsResponse struct {
	// List of capacity commitments visible to the user.
	CapacityCommitments []*CapacityCommitment `protobuf:"bytes,1,rep,name=capacity_commitments,json=capacityCommitments,proto3" json:"capacity_commitments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCapacityCommitmentsResponse) Reset()         { *m = ListCapacityCommitmentsResponse{} }
func (m *ListCapacityCommitmentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListCapacityCommitmentsResponse) ProtoMessage()    {}
func (*ListCapacityCommitmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{9}
}

func (m *ListCapacityCommitmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCapacityCommitmentsResponse.Unmarshal(m, b)
}
func (m *ListCapacityCommitmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCapacityCommitmentsResponse.Marshal(b, m, deterministic)
}
func (m *ListCapacityCommitmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCapacityCommitmentsResponse.Merge(m, src)
}
func (m *ListCapacityCommitmentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListCapacityCommitmentsResponse.Size(m)
}
func (m *ListCapacityCommitmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCapacityCommitmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCapacityCommitmentsResponse proto.InternalMessageInfo

func (m *ListCapacityCommitmentsResponse) GetCapacityCommitments() []*CapacityCommitment {
	if m != nil {
		return m.CapacityCommitments
	}
	return nil
}

func (m *ListCapacityCommitmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.GetCapacityCommitment].
type GetCapacityCommitmentRequest struct {
	// Required. Resource name of the capacity commitment to retrieve. E.g.,
	//    projects/myproject/locations/US/capacityCommitments/123
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCapacityCommitmentRequest) Reset()         { *m = GetCapacityCommitmentRequest{} }
func (m *GetCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*GetCapacityCommitmentRequest) ProtoMessage()    {}
func (*GetCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{10}
}

func (m *GetCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *GetCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *GetCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCapacityCommitmentRequest.Merge(m, src)
}
func (m *GetCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_GetCapacityCommitmentRequest.Size(m)
}
func (m *GetCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCapacityCommitmentRequest proto.InternalMessageInfo

func (m *GetCapacityCommitmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteCapacityCommitment].
type DeleteCapacityCommitmentRequest struct {
	// Required. Resource name of the capacity commitment to delete. E.g.,
	//    projects/myproject/locations/US/capacityCommitments/123
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteCapacityCommitmentRequest) Reset()         { *m = DeleteCapacityCommitmentRequest{} }
func (m *DeleteCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteCapacityCommitmentRequest) ProtoMessage()    {}
func (*DeleteCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{11}
}

func (m *DeleteCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *DeleteCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteCapacityCommitmentRequest.Merge(m, src)
}
func (m *DeleteCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteCapacityCommitmentRequest.Size(m)
}
func (m *DeleteCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteCapacityCommitmentRequest proto.InternalMessageInfo

func (m *DeleteCapacityCommitmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.UpdateCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateCapacityCommitment].
type UpdateCapacityCommitmentRequest struct {
	// Content of the capacity commitment to update.
	CapacityCommitment *CapacityCommitment `protobuf:"bytes,1,opt,name=capacity_commitment,json=capacityCommitment,proto3" json:"capacity_commitment,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCapacityCommitmentRequest) Reset()         { *m = UpdateCapacityCommitmentRequest{} }
func (m *UpdateCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCapacityCommitmentRequest) ProtoMessage()    {}
func (*UpdateCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{12}
}

func (m *UpdateCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *UpdateCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCapacityCommitmentRequest.Merge(m, src)
}
func (m *UpdateCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCapacityCommitmentRequest.Size(m)
}
func (m *UpdateCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCapacityCommitmentRequest proto.InternalMessageInfo

func (m *UpdateCapacityCommitmentRequest) GetCapacityCommitment() *CapacityCommitment {
	if m != nil {
		return m.CapacityCommitment
	}
	return nil
}

func (m *UpdateCapacityCommitmentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentRequest struct {
	// Required. The resource name e.g.,:
	//   projects/myproject/locations/US/capacityCommitments/123
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of slots in the capacity commitment after the split.
	SlotCount            int64    `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplitCapacityCommitmentRequest) Reset()         { *m = SplitCapacityCommitmentRequest{} }
func (m *SplitCapacityCommitmentRequest) String() string { return proto.CompactTextString(m) }
func (*SplitCapacityCommitmentRequest) ProtoMessage()    {}
func (*SplitCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{13}
}

func (m *SplitCapacityCommitmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitCapacityCommitmentRequest.Unmarshal(m, b)
}
func (m *SplitCapacityCommitmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitCapacityCommitmentRequest.Marshal(b, m, deterministic)
}
func (m *SplitCapacityCommitmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitCapacityCommitmentRequest.Merge(m, src)
}
func (m *SplitCapacityCommitmentRequest) XXX_Size() int {
	return xxx_messageInfo_SplitCapacityCommitmentRequest.Size(m)
}
func (m *SplitCapacityCommitmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitCapacityCommitmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SplitCapacityCommitmentRequest proto.InternalMessageInfo

func (m *SplitCapacityCommitmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SplitCapacityCommitmentRequest) GetSlotCount() int64 {
	if m != nil {
		return m.SlotCount
	}
	return 0
}

// The response for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentResponse struct {
	// First capacity commitment, result of a split.
	First *CapacityCommitment `protobuf:"bytes,1,opt,name=first,proto3" json:"first,omitempty"`
	// Second capacity commitment, result of a split.
	Second               *CapacityCommitment `protobuf:"bytes,2,opt,name=second,proto3" json:"second,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SplitCapacityCommitmentResponse) Reset()         { *m = SplitCapacityCommitmentResponse{} }
func (m *SplitCapacityCommitmentResponse) String() string { return proto.CompactTextString(m) }
func (*SplitCapacityCommitmentResponse) ProtoMessage()    {}
func (*SplitCapacityCommitmentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{14}
}

func (m *SplitCapacityCommitmentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitCapacityCommitmentResponse.Unmarshal(m, b)
}
func (m *SplitCapacityCommitmentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitCapacityCommitmentResponse.Marshal(b, m, deterministic)
}
func (m *SplitCapacityCommitmentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitCapacityCommitmentResponse.Merge(m, src)
}
func (m *SplitCapacityCommitmentResponse) XXX_Size() int {
	return xxx_messageInfo_SplitCapacityCommitmentResponse.Size(m)
}
func (m *SplitCapacityCommitmentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitCapacityCommitmentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SplitCapacityCommitmentResponse proto.InternalMessageInfo

func (m *SplitCapacityCommitmentResponse) GetFirst() *CapacityCommitment {
	if m != nil {
		return m.First
	}
	return nil
}

func (m *SplitCapacityCommitmentResponse) GetSecond() *CapacityCommitment {
	if m != nil {
		return m.Second
	}
	return nil
}

// The request for
// [ReservationService.MergeCapacityCommitments][google.cloud.bigquery.reservation.v1beta1.ReservationService.MergeCapacityCommitments].
type MergeCapacityCommitmentsRequest struct {
	// Parent resource that identifies admin project and location e.g.,
	// projects/myproject/locations/us
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Ids of capacity commitments to merge.
	// These capacity commitments must exist under admin project and location
	// specified in the parent.
	CapacityCommitmentIds []string `protobuf:"bytes,2,rep,name=capacity_commitment_ids,json=capacityCommitmentIds,proto3" json:"capacity_commitment_ids,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *MergeCapacityCommitmentsRequest) Reset()         { *m = MergeCapacityCommitmentsRequest{} }
func (m *MergeCapacityCommitmentsRequest) String() string { return proto.CompactTextString(m) }
func (*MergeCapacityCommitmentsRequest) ProtoMessage()    {}
func (*MergeCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{15}
}

func (m *MergeCapacityCommitmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeCapacityCommitmentsRequest.Unmarshal(m, b)
}
func (m *MergeCapacityCommitmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeCapacityCommitmentsRequest.Marshal(b, m, deterministic)
}
func (m *MergeCapacityCommitmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeCapacityCommitmentsRequest.Merge(m, src)
}
func (m *MergeCapacityCommitmentsRequest) XXX_Size() int {
	return xxx_messageInfo_MergeCapacityCommitmentsRequest.Size(m)
}
func (m *MergeCapacityCommitmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeCapacityCommitmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeCapacityCommitmentsRequest proto.InternalMessageInfo

func (m *MergeCapacityCommitmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *MergeCapacityCommitmentsRequest) GetCapacityCommitmentIds() []string {
	if m != nil {
		return m.CapacityCommitmentIds
	}
	return nil
}

// A Assignment allows a project to submit jobs
// of a certain type using slots from the specified reservation.
type Assignment struct {
	// Output only. Name of the resource. E.g.:
	// projects/myproject/locations/US/reservations/team1-prod/assignments/123.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource which will use the reservation. E.g.
	// projects/myproject, folders/123, organizations/456.
	Assignee string `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// Which type of jobs will use the reservation.
	JobType Assignment_JobType `protobuf:"varint,3,opt,name=job_type,json=jobType,proto3,enum=google.cloud.bigquery.reservation.v1beta1.Assignment_JobType" json:"job_type,omitempty"`
	// Output only. State of the assignment.
	State                Assignment_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1beta1.Assignment_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Assignment) Reset()         { *m = Assignment{} }
func (m *Assignment) String() string { return proto.CompactTextString(m) }
func (*Assignment) ProtoMessage()    {}
func (*Assignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{16}
}

func (m *Assignment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assignment.Unmarshal(m, b)
}
func (m *Assignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assignment.Marshal(b, m, deterministic)
}
func (m *Assignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assignment.Merge(m, src)
}
func (m *Assignment) XXX_Size() int {
	return xxx_messageInfo_Assignment.Size(m)
}
func (m *Assignment) XXX_DiscardUnknown() {
	xxx_messageInfo_Assignment.DiscardUnknown(m)
}

var xxx_messageInfo_Assignment proto.InternalMessageInfo

func (m *Assignment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Assignment) GetAssignee() string {
	if m != nil {
		return m.Assignee
	}
	return ""
}

func (m *Assignment) GetJobType() Assignment_JobType {
	if m != nil {
		return m.JobType
	}
	return Assignment_JOB_TYPE_UNSPECIFIED
}

func (m *Assignment) GetState() Assignment_State {
	if m != nil {
		return m.State
	}
	return Assignment_STATE_UNSPECIFIED
}

// The request for
// [ReservationService.CreateAssignment][google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateAssignment].
// Note: "bigquery.reservationAssignments.create" permission is required on the
// related assignee.
type CreateAssignmentRequest struct {
	// Required. The parent resource name of the assignment
	// E.g.: projects/myproject/locations/US/reservations/team1-prod
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Assignment resource to create.
	Assignment           *Assignment `protobuf:"bytes,2,opt,name=assignment,proto3" json:"assignment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateAssignmentRequest) Reset()         { *m = CreateAssignmentRequest{} }
func (m *CreateAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAssignmentRequest) ProtoMessage()    {}
func (*CreateAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{17}
}

func (m *CreateAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAssignmentRequest.Unmarshal(m, b)
}
func (m *CreateAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAssignmentRequest.Marshal(b, m, deterministic)
}
func (m *CreateAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAssignmentRequest.Merge(m, src)
}
func (m *CreateAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAssignmentRequest.Size(m)
}
func (m *CreateAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAssignmentRequest proto.InternalMessageInfo

func (m *CreateAssignmentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAssignmentRequest) GetAssignment() *Assignment {
	if m != nil {
		return m.Assignment
	}
	return nil
}

// The request for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListAssignments].
type ListAssignmentsRequest struct {
	// Required. The parent resource name e.g.:
	// projects/myproject/locations/US/reservations/team1-prod
	// Or:
	// projects/myproject/locations/US/reservations/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssignmentsRequest) Reset()         { *m = ListAssignmentsRequest{} }
func (m *ListAssignmentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAssignmentsRequest) ProtoMessage()    {}
func (*ListAssignmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{18}
}

func (m *ListAssignmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssignmentsRequest.Unmarshal(m, b)
}
func (m *ListAssignmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssignmentsRequest.Marshal(b, m, deterministic)
}
func (m *ListAssignmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssignmentsRequest.Merge(m, src)
}
func (m *ListAssignmentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAssignmentsRequest.Size(m)
}
func (m *ListAssignmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssignmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssignmentsRequest proto.InternalMessageInfo

func (m *ListAssignmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAssignmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAssignmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListAssignments].
type ListAssignmentsResponse struct {
	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssignmentsResponse) Reset()         { *m = ListAssignmentsResponse{} }
func (m *ListAssignmentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAssignmentsResponse) ProtoMessage()    {}
func (*ListAssignmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{19}
}

func (m *ListAssignmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssignmentsResponse.Unmarshal(m, b)
}
func (m *ListAssignmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssignmentsResponse.Marshal(b, m, deterministic)
}
func (m *ListAssignmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssignmentsResponse.Merge(m, src)
}
func (m *ListAssignmentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAssignmentsResponse.Size(m)
}
func (m *ListAssignmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssignmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssignmentsResponse proto.InternalMessageInfo

func (m *ListAssignmentsResponse) GetAssignments() []*Assignment {
	if m != nil {
		return m.Assignments
	}
	return nil
}

func (m *ListAssignmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.DeleteAssignment][google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteAssignment].
// Note: "bigquery.reservationAssignments.delete" permission is required on the
// related assignee.
type DeleteAssignmentRequest struct {
	// Required. Name of the resource, e.g.:
	//   projects/myproject/locations/US/reservations/team1-prod/assignments/123
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAssignmentRequest) Reset()         { *m = DeleteAssignmentRequest{} }
func (m *DeleteAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAssignmentRequest) ProtoMessage()    {}
func (*DeleteAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{20}
}

func (m *DeleteAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAssignmentRequest.Unmarshal(m, b)
}
func (m *DeleteAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAssignmentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAssignmentRequest.Merge(m, src)
}
func (m *DeleteAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAssignmentRequest.Size(m)
}
func (m *DeleteAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAssignmentRequest proto.InternalMessageInfo

func (m *DeleteAssignmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.SearchAssignments].
// Note: "bigquery.reservationAssignments.search" permission is required on the
// related assignee.
type SearchAssignmentsRequest struct {
	// Required. The resource name of the admin project(containing project and
	// location), e.g.:
	//   "projects/myproject/locations/US".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Please specify resource name as assignee in the query.
	// e.g., "assignee=projects/myproject"
	//       "assignee=folders/123"
	//       "assignee=organizations/456"
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAssignmentsRequest) Reset()         { *m = SearchAssignmentsRequest{} }
func (m *SearchAssignmentsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchAssignmentsRequest) ProtoMessage()    {}
func (*SearchAssignmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{21}
}

func (m *SearchAssignmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAssignmentsRequest.Unmarshal(m, b)
}
func (m *SearchAssignmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAssignmentsRequest.Marshal(b, m, deterministic)
}
func (m *SearchAssignmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAssignmentsRequest.Merge(m, src)
}
func (m *SearchAssignmentsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchAssignmentsRequest.Size(m)
}
func (m *SearchAssignmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAssignmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAssignmentsRequest proto.InternalMessageInfo

func (m *SearchAssignmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchAssignmentsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchAssignmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchAssignmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.SearchAssignments].
type SearchAssignmentsResponse struct {
	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAssignmentsResponse) Reset()         { *m = SearchAssignmentsResponse{} }
func (m *SearchAssignmentsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchAssignmentsResponse) ProtoMessage()    {}
func (*SearchAssignmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{22}
}

func (m *SearchAssignmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAssignmentsResponse.Unmarshal(m, b)
}
func (m *SearchAssignmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAssignmentsResponse.Marshal(b, m, deterministic)
}
func (m *SearchAssignmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAssignmentsResponse.Merge(m, src)
}
func (m *SearchAssignmentsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchAssignmentsResponse.Size(m)
}
func (m *SearchAssignmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAssignmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAssignmentsResponse proto.InternalMessageInfo

func (m *SearchAssignmentsResponse) GetAssignments() []*Assignment {
	if m != nil {
		return m.Assignments
	}
	return nil
}

func (m *SearchAssignmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.MoveAssignment][google.cloud.bigquery.reservation.v1beta1.ReservationService.MoveAssignment].
// Note: "bigquery.reservationAssignments.create" permission is required on the
// destination_id. Note: "bigquery.reservationAssignments.create" and
// "bigquery.reservationAssignments.delete" permission is required on the
// related assignee.
type MoveAssignmentRequest struct {
	// Required. The resource name of the assignment,
	// e.g.:
	//   projects/myproject/locations/US/reservations/team1-prod/assignments/123
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new reservation ID, e.g.:
	//   projects/myotherproject/locations/US/reservations/team2-prod
	DestinationId        string   `protobuf:"bytes,3,opt,name=destination_id,json=destinationId,proto3" json:"destination_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveAssignmentRequest) Reset()         { *m = MoveAssignmentRequest{} }
func (m *MoveAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*MoveAssignmentRequest) ProtoMessage()    {}
func (*MoveAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{23}
}

func (m *MoveAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveAssignmentRequest.Unmarshal(m, b)
}
func (m *MoveAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveAssignmentRequest.Marshal(b, m, deterministic)
}
func (m *MoveAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveAssignmentRequest.Merge(m, src)
}
func (m *MoveAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_MoveAssignmentRequest.Size(m)
}
func (m *MoveAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveAssignmentRequest proto.InternalMessageInfo

func (m *MoveAssignmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MoveAssignmentRequest) GetDestinationId() string {
	if m != nil {
		return m.DestinationId
	}
	return ""
}

// Represents a BI Reservation.
type BiReservation struct {
	// The resource name of the singleton BI reservation.
	// Reservation names have the form
	// `projects/{project_id}/locations/{location_id}/bireservation`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The last update timestamp of a reservation.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Size of a reservation, in bytes.
	Size                 int64    `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BiReservation) Reset()         { *m = BiReservation{} }
func (m *BiReservation) String() string { return proto.CompactTextString(m) }
func (*BiReservation) ProtoMessage()    {}
func (*BiReservation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{24}
}

func (m *BiReservation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BiReservation.Unmarshal(m, b)
}
func (m *BiReservation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BiReservation.Marshal(b, m, deterministic)
}
func (m *BiReservation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BiReservation.Merge(m, src)
}
func (m *BiReservation) XXX_Size() int {
	return xxx_messageInfo_BiReservation.Size(m)
}
func (m *BiReservation) XXX_DiscardUnknown() {
	xxx_messageInfo_BiReservation.DiscardUnknown(m)
}

var xxx_messageInfo_BiReservation proto.InternalMessageInfo

func (m *BiReservation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BiReservation) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *BiReservation) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

// A request to get a singleton BI reservation.
type GetBiReservationRequest struct {
	// Required. Name of the requested reservation, for example:
	// `projects/{project_id}/locations/{location_id}/bireservation`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBiReservationRequest) Reset()         { *m = GetBiReservationRequest{} }
func (m *GetBiReservationRequest) String() string { return proto.CompactTextString(m) }
func (*GetBiReservationRequest) ProtoMessage()    {}
func (*GetBiReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{25}
}

func (m *GetBiReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBiReservationRequest.Unmarshal(m, b)
}
func (m *GetBiReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBiReservationRequest.Marshal(b, m, deterministic)
}
func (m *GetBiReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBiReservationRequest.Merge(m, src)
}
func (m *GetBiReservationRequest) XXX_Size() int {
	return xxx_messageInfo_GetBiReservationRequest.Size(m)
}
func (m *GetBiReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBiReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBiReservationRequest proto.InternalMessageInfo

func (m *GetBiReservationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to update a BI reservation.
type UpdateBiReservationRequest struct {
	// A reservation to update.
	BiReservation *BiReservation `protobuf:"bytes,1,opt,name=bi_reservation,json=biReservation,proto3" json:"bi_reservation,omitempty"`
	// A list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateBiReservationRequest) Reset()         { *m = UpdateBiReservationRequest{} }
func (m *UpdateBiReservationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBiReservationRequest) ProtoMessage()    {}
func (*UpdateBiReservationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8b47fa8b6617477f, []int{26}
}

func (m *UpdateBiReservationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBiReservationRequest.Unmarshal(m, b)
}
func (m *UpdateBiReservationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBiReservationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBiReservationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBiReservationRequest.Merge(m, src)
}
func (m *UpdateBiReservationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBiReservationRequest.Size(m)
}
func (m *UpdateBiReservationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBiReservationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBiReservationRequest proto.InternalMessageInfo

func (m *UpdateBiReservationRequest) GetBiReservation() *BiReservation {
	if m != nil {
		return m.BiReservation
	}
	return nil
}

func (m *UpdateBiReservationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_CommitmentPlan", CapacityCommitment_CommitmentPlan_name, CapacityCommitment_CommitmentPlan_value)
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_State", CapacityCommitment_State_name, CapacityCommitment_State_value)
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1beta1.Assignment_JobType", Assignment_JobType_name, Assignment_JobType_value)
	proto.RegisterEnum("google.cloud.bigquery.reservation.v1beta1.Assignment_State", Assignment_State_name, Assignment_State_value)
	proto.RegisterType((*Reservation)(nil), "google.cloud.bigquery.reservation.v1beta1.Reservation")
	proto.RegisterType((*CapacityCommitment)(nil), "google.cloud.bigquery.reservation.v1beta1.CapacityCommitment")
	proto.RegisterType((*CreateReservationRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.CreateReservationRequest")
	proto.RegisterType((*ListReservationsRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.ListReservationsRequest")
	proto.RegisterType((*ListReservationsResponse)(nil), "google.cloud.bigquery.reservation.v1beta1.ListReservationsResponse")
	proto.RegisterType((*GetReservationRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.GetReservationRequest")
	proto.RegisterType((*DeleteReservationRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.DeleteReservationRequest")
	proto.RegisterType((*UpdateReservationRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.UpdateReservationRequest")
	proto.RegisterType((*ListCapacityCommitmentsRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.ListCapacityCommitmentsRequest")
	proto.RegisterType((*ListCapacityCommitmentsResponse)(nil), "google.cloud.bigquery.reservation.v1beta1.ListCapacityCommitmentsResponse")
	proto.RegisterType((*GetCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.GetCapacityCommitmentRequest")
	proto.RegisterType((*DeleteCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.DeleteCapacityCommitmentRequest")
	proto.RegisterType((*UpdateCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.UpdateCapacityCommitmentRequest")
	proto.RegisterType((*SplitCapacityCommitmentRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentRequest")
	proto.RegisterType((*SplitCapacityCommitmentResponse)(nil), "google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentResponse")
	proto.RegisterType((*MergeCapacityCommitmentsRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.MergeCapacityCommitmentsRequest")
	proto.RegisterType((*Assignment)(nil), "google.cloud.bigquery.reservation.v1beta1.Assignment")
	proto.RegisterType((*CreateAssignmentRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.CreateAssignmentRequest")
	proto.RegisterType((*ListAssignmentsRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.ListAssignmentsRequest")
	proto.RegisterType((*ListAssignmentsResponse)(nil), "google.cloud.bigquery.reservation.v1beta1.ListAssignmentsResponse")
	proto.RegisterType((*DeleteAssignmentRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.DeleteAssignmentRequest")
	proto.RegisterType((*SearchAssignmentsRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.SearchAssignmentsRequest")
	proto.RegisterType((*SearchAssignmentsResponse)(nil), "google.cloud.bigquery.reservation.v1beta1.SearchAssignmentsResponse")
	proto.RegisterType((*MoveAssignmentRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.MoveAssignmentRequest")
	proto.RegisterType((*BiReservation)(nil), "google.cloud.bigquery.reservation.v1beta1.BiReservation")
	proto.RegisterType((*GetBiReservationRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.GetBiReservationRequest")
	proto.RegisterType((*UpdateBiReservationRequest)(nil), "google.cloud.bigquery.reservation.v1beta1.UpdateBiReservationRequest")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/reservation/v1beta1/reservation.proto", fileDescriptor_8b47fa8b6617477f)
}

var fileDescriptor_8b47fa8b6617477f = []byte{
	// 2291 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xdd, 0x6f, 0x1b, 0x59,
	0x15, 0xe7, 0xda, 0x49, 0x9a, 0x9c, 0x34, 0xa9, 0x73, 0xfb, 0x11, 0xaf, 0xbb, 0x34, 0xd9, 0xa9,
	0x40, 0x59, 0xab, 0xf5, 0xec, 0x06, 0xda, 0xae, 0xdc, 0x76, 0xb5, 0x13, 0xc7, 0xcd, 0xba, 0xc4,
	0xae, 0xeb, 0x38, 0xbb, 0xed, 0x22, 0x31, 0x8c, 0xed, 0x1b, 0x77, 0x5a, 0x7b, 0x66, 0x3a, 0x33,
	0x4e, 0x37, 0x1b, 0x45, 0xa0, 0x95, 0x10, 0x12, 0x42, 0xb0, 0x80, 0x78, 0x41, 0x88, 0x17, 0xfe,
	0x00, 0x40, 0x48, 0x20, 0x01, 0x15, 0x12, 0x8f, 0x20, 0x10, 0x02, 0xf1, 0xe2, 0xa7, 0x95, 0x40,
	0x42, 0x2a, 0x08, 0x09, 0x89, 0xa7, 0xbe, 0x80, 0xe6, 0xce, 0xb5, 0x3d, 0x9f, 0x8d, 0xc7, 0x4e,
	0x2b, 0xde, 0xc6, 0xf7, 0xe3, 0xdc, 0xf3, 0xf1, 0x3b, 0xe7, 0x9e, 0xfb, 0x4b, 0xe0, 0x6a, 0x53,
	0x55, 0x9b, 0x2d, 0xc2, 0xd7, 0x5b, 0x6a, 0xa7, 0xc1, 0xd7, 0xe4, 0xe6, 0xc3, 0x0e, 0xd1, 0xf7,
	0x78, 0x9d, 0x18, 0x44, 0xdf, 0x95, 0x4c, 0x59, 0x55, 0xf8, 0xdd, 0xd7, 0x6b, 0xc4, 0x94, 0x5e,
	0x77, 0x8e, 0x65, 0x34, 0x5d, 0x35, 0x55, 0xfc, 0xaa, 0xbd, 0x39, 0x43, 0x37, 0x67, 0x7a, 0x9b,
	0x33, 0xce, 0x85, 0x6c, 0x73, 0xea, 0x65, 0x76, 0x8e, 0xa4, 0xc9, 0xbc, 0xa4, 0x28, 0xaa, 0x49,
	0xa7, 0x0d, 0x5b, 0x50, 0x6a, 0xd1, 0x31, 0x5b, 0x6f, 0xc9, 0x44, 0x31, 0xd9, 0xc4, 0x92, 0x63,
	0x62, 0x47, 0x26, 0xad, 0x86, 0x58, 0x23, 0xf7, 0xa4, 0x5d, 0x59, 0xd5, 0xd9, 0x82, 0x97, 0x1c,
	0x0b, 0x74, 0x62, 0xa8, 0x1d, 0xbd, 0x4e, 0xd8, 0xd4, 0x59, 0x36, 0x45, 0x7f, 0xd5, 0x3a, 0x3b,
	0x3c, 0x69, 0x6b, 0xe6, 0x1e, 0x9b, 0x5c, 0xf6, 0x4e, 0xda, 0xd2, 0xdb, 0x92, 0xf1, 0xc0, 0x73,
	0x74, 0x7f, 0x85, 0x29, 0xb7, 0x89, 0x61, 0x4a, 0x6d, 0xcd, 0xa3, 0xb4, 0xae, 0xd5, 0x79, 0xc3,
	0x94, 0xcc, 0x0e, 0xb3, 0x86, 0xfb, 0x07, 0x82, 0xd9, 0xca, 0xc0, 0x07, 0x18, 0xc3, 0x84, 0x22,
	0xb5, 0x49, 0x12, 0x2d, 0xa3, 0x95, 0x99, 0x0a, 0xfd, 0xc6, 0xe7, 0x61, 0xce, 0x68, 0xa9, 0xa6,
	0x58, 0x97, 0x34, 0xa9, 0x2e, 0x9b, 0x7b, 0xc9, 0xd8, 0x32, 0x5a, 0x89, 0x57, 0x8e, 0x5b, 0x83,
	0x39, 0x36, 0x86, 0xd3, 0xb0, 0x20, 0x37, 0x15, 0x55, 0x27, 0xa2, 0xdc, 0x68, 0x11, 0xd1, 0x9a,
	0x33, 0x92, 0x13, 0xcb, 0x68, 0x65, 0xba, 0x72, 0xc2, 0x9e, 0x28, 0x34, 0x5a, 0x64, 0xcb, 0x1a,
	0xce, 0x3e, 0x7a, 0x22, 0x98, 0xd0, 0x8f, 0x81, 0x33, 0x04, 0xb6, 0x9a, 0x92, 0x26, 0x1b, 0x99,
	0xba, 0xda, 0xe6, 0x9d, 0x9a, 0xad, 0x69, 0xba, 0x7a, 0x9f, 0xd4, 0x4d, 0x83, 0xdf, 0x67, 0x5f,
	0x07, 0x7c, 0x4b, 0xad, 0xdb, 0xb1, 0xe1, 0xf7, 0x7b, 0x9f, 0x07, 0xce, 0xd8, 0x1b, 0xfc, 0xbe,
	0xe3, 0xd7, 0x01, 0xf7, 0xab, 0x29, 0xc0, 0x3d, 0x8d, 0x73, 0x6a, 0xbb, 0x2d, 0x9b, 0x6d, 0xa2,
	0x98, 0x78, 0xd1, 0x69, 0xf4, 0x5a, 0xfc, 0x63, 0x21, 0xce, 0x2c, 0xff, 0x24, 0x80, 0x6d, 0xb9,
	0xda, 0x51, 0x4c, 0x66, 0xf6, 0x0c, 0x35, 0xdb, 0x1a, 0xc0, 0x5f, 0x84, 0x09, 0xad, 0x25, 0x29,
	0xc9, 0xf8, 0x32, 0x5a, 0x99, 0x5f, 0xdd, 0xcc, 0x0c, 0x0d, 0xb1, 0x8c, 0x5f, 0x89, 0xcc, 0xe0,
	0xb3, 0xdc, 0x92, 0x94, 0x0a, 0x95, 0x8c, 0xbf, 0x00, 0x93, 0x56, 0xb8, 0x08, 0xf5, 0xe4, 0xfc,
	0x6a, 0x6e, 0xbc, 0x23, 0xb6, 0x2c, 0x51, 0xb6, 0x7d, 0xb6, 0x58, 0x7c, 0x0b, 0x4e, 0xd6, 0xfb,
	0xf3, 0x22, 0x51, 0x1a, 0xa2, 0x85, 0x9c, 0xe4, 0xe4, 0x32, 0x5a, 0x99, 0x5d, 0x4d, 0xf5, 0x4e,
	0xeb, 0xc1, 0x2a, 0x53, 0xed, 0xc1, 0xca, 0x16, 0xb2, 0x30, 0xd8, 0x9b, 0x57, 0x1a, 0xd6, 0x24,
	0x7e, 0x13, 0xe6, 0x77, 0x24, 0xb9, 0xd5, 0xd1, 0x89, 0x68, 0xe3, 0x2c, 0x79, 0x8c, 0xca, 0xc2,
	0x3d, 0x59, 0xba, 0x56, 0xa7, 0x7a, 0x74, 0x0c, 0x5b, 0xc6, 0x1c, 0x5b, 0x6e, 0x8f, 0x61, 0x15,
	0x8e, 0xeb, 0x44, 0x21, 0x8f, 0xa4, 0x96, 0x48, 0x5d, 0x3b, 0xfd, 0x1c, 0x5c, 0x3b, 0xcb, 0x4e,
	0xb0, 0x7e, 0x70, 0x55, 0x98, 0x77, 0x4f, 0xe3, 0x25, 0x38, 0x9b, 0xbb, 0x55, 0x2c, 0x16, 0xaa,
	0xc5, 0x7c, 0xa9, 0x2a, 0x96, 0x37, 0x85, 0x92, 0xb8, 0x5d, 0xda, 0x2a, 0xe7, 0x73, 0x85, 0x1b,
	0x85, 0xfc, 0x7a, 0xe2, 0x13, 0x78, 0x1a, 0x26, 0x6e, 0x6c, 0xe6, 0xef, 0x24, 0xe2, 0x78, 0x16,
	0x8e, 0x15, 0x6f, 0x95, 0xaa, 0x6f, 0x6f, 0xde, 0x4d, 0xc4, 0x30, 0xc0, 0x94, 0x50, 0x2a, 0x6d,
	0x0b, 0x9b, 0x89, 0x09, 0x2e, 0x07, 0x93, 0xd4, 0xd9, 0xf8, 0x34, 0x2c, 0x6c, 0x55, 0x85, 0x6a,
	0xde, 0x23, 0x62, 0x16, 0x8e, 0x95, 0xf3, 0xa5, 0xf5, 0x42, 0x69, 0x23, 0x81, 0xe8, 0xc6, 0x5c,
	0xb5, 0xf0, 0x4e, 0xde, 0x16, 0x72, 0x43, 0x28, 0x6c, 0xe6, 0xd7, 0x13, 0xf1, 0xec, 0x37, 0xd0,
	0x13, 0xe1, 0x6b, 0x08, 0x2e, 0x0d, 0x91, 0x28, 0x01, 0xa0, 0xbe, 0x3d, 0x6c, 0xbe, 0xd4, 0x7d,
	0x7b, 0x0d, 0x7e, 0xbf, 0x37, 0x28, 0x0e, 0x42, 0x7c, 0x60, 0x15, 0x8b, 0x64, 0x4e, 0x27, 0x92,
	0x49, 0x1c, 0x89, 0x59, 0x21, 0x0f, 0x3b, 0xc4, 0x30, 0x71, 0x09, 0xa6, 0x34, 0x49, 0x27, 0x8a,
	0xc9, 0xd2, 0xe8, 0xf2, 0xc7, 0x42, 0xec, 0xa9, 0xf0, 0x1a, 0x8e, 0x98, 0xe7, 0x15, 0x26, 0x05,
	0x7f, 0x0a, 0xe6, 0x1d, 0x3b, 0x44, 0xb9, 0x41, 0xf3, 0x6f, 0xa6, 0x32, 0xe7, 0x18, 0x2d, 0x34,
	0xf0, 0x1d, 0x98, 0x75, 0x0c, 0xd0, 0x54, 0x9c, 0x5d, 0xbd, 0x1c, 0x01, 0x2f, 0xce, 0xb3, 0x9d,
	0xa2, 0xb8, 0xc7, 0x08, 0x16, 0x37, 0x65, 0xc3, 0x74, 0x2c, 0x30, 0x9e, 0x97, 0xb1, 0x67, 0x61,
	0x46, 0x93, 0x9a, 0x44, 0x34, 0xe4, 0x0f, 0x08, 0xb5, 0x73, 0xb2, 0x32, 0x6d, 0x0d, 0x6c, 0xc9,
	0x1f, 0xd0, 0x2a, 0x44, 0x27, 0x4d, 0xf5, 0x01, 0xb1, 0x2d, 0x9c, 0xa9, 0xd0, 0xe5, 0x55, 0x6b,
	0x00, 0x9f, 0x81, 0xa9, 0x1d, 0xb9, 0x65, 0x12, 0x9d, 0x16, 0x89, 0x99, 0x0a, 0xfb, 0xc5, 0xfd,
	0x00, 0x41, 0xd2, 0xaf, 0xbf, 0xa1, 0xa9, 0x8a, 0x41, 0xf0, 0x7b, 0x56, 0x9e, 0x0d, 0xc6, 0x93,
	0x68, 0x39, 0x3e, 0x86, 0xdf, 0x5c, 0xb2, 0xf0, 0xa7, 0xe1, 0x84, 0x42, 0xde, 0x37, 0x45, 0x87,
	0xd2, 0x2c, 0x74, 0xd6, 0x70, 0xb9, 0xa7, 0x38, 0x57, 0x87, 0xd3, 0x1b, 0xc4, 0x0c, 0x80, 0xd2,
	0x4d, 0x57, 0x3d, 0x66, 0xbe, 0x8d, 0x7a, 0x61, 0xd8, 0x25, 0x9c, 0xdb, 0x81, 0xe4, 0x3a, 0x69,
	0x91, 0x40, 0xc8, 0x1e, 0xe5, 0x39, 0x3f, 0x41, 0x90, 0xdc, 0xd6, 0x1a, 0xc1, 0xb9, 0xe1, 0x01,
	0x29, 0x3a, 0x32, 0x90, 0xe2, 0xab, 0x30, 0xdb, 0xa1, 0xa7, 0xd2, 0x76, 0x80, 0xfa, 0x39, 0xa8,
	0x70, 0xdf, 0xb0, 0x3a, 0x86, 0xa2, 0x64, 0x3c, 0xa8, 0x80, 0xbd, 0xdc, 0xfa, 0xe6, 0x7e, 0x8a,
	0xe0, 0x9c, 0x85, 0x10, 0x7f, 0xf5, 0xe8, 0x03, 0x7d, 0xdb, 0x03, 0xf4, 0xeb, 0xd4, 0x49, 0x57,
	0xf0, 0x68, 0x45, 0xe9, 0x28, 0xf0, 0xce, 0xfd, 0x12, 0xc1, 0x52, 0xa8, 0xd6, 0x0c, 0xde, 0x1a,
	0x9c, 0x0a, 0xa8, 0x60, 0x3d, 0x98, 0x5f, 0x1f, 0xeb, 0x3a, 0xa9, 0x9c, 0x0c, 0xa8, 0x98, 0x43,
	0x83, 0xfe, 0x21, 0xbc, 0xbc, 0x41, 0x02, 0x74, 0xef, 0x39, 0xfc, 0xb6, 0x0b, 0x93, 0xcc, 0xdd,
	0x23, 0xde, 0x01, 0x0c, 0x9a, 0x26, 0x2c, 0xd9, 0x29, 0xf0, 0x42, 0x4f, 0xfd, 0x03, 0x82, 0x25,
	0x3b, 0x21, 0xc2, 0x8f, 0x55, 0xe0, 0x64, 0x40, 0x98, 0x58, 0x7e, 0x8c, 0x19, 0x25, 0xec, 0x8f,
	0xd2, 0x78, 0xd9, 0xf2, 0x6d, 0x04, 0xe7, 0xb6, 0xb4, 0x96, 0xfc, 0x42, 0x83, 0x77, 0x48, 0x0b,
	0xca, 0xfd, 0x1e, 0xc1, 0x52, 0xa8, 0x52, 0x2c, 0x19, 0xb6, 0x60, 0x72, 0x47, 0xd6, 0x8d, 0x23,
	0xf2, 0xab, 0x2d, 0xcb, 0x2a, 0x0c, 0x06, 0xa9, 0xab, 0x4a, 0x83, 0x79, 0x71, 0x4c, 0xa9, 0x4c,
	0x18, 0xf7, 0x63, 0x04, 0x4b, 0x45, 0xa2, 0x37, 0xc9, 0x8b, 0xaf, 0x49, 0x97, 0x61, 0x31, 0x00,
	0x8c, 0xa2, 0xdc, 0x30, 0x92, 0xb1, 0xe5, 0xf8, 0xca, 0x4c, 0xe5, 0xb4, 0x1f, 0x51, 0x85, 0x86,
	0xc1, 0x7d, 0x65, 0x02, 0x40, 0x30, 0x0c, 0xb9, 0xa9, 0x3c, 0xfb, 0x31, 0xc1, 0xc1, 0xb4, 0x44,
	0x97, 0x11, 0xbb, 0x9d, 0x9f, 0x59, 0x9b, 0x7a, 0x2a, 0xc4, 0x01, 0xa5, 0x2b, 0xfd, 0x71, 0x7c,
	0x07, 0xa6, 0xef, 0xab, 0x35, 0xd1, 0xdc, 0xd3, 0x08, 0x7b, 0x55, 0x44, 0xf1, 0xeb, 0x40, 0x8b,
	0xcc, 0x4d, 0xb5, 0x56, 0xdd, 0xd3, 0x48, 0xe5, 0xd8, 0x7d, 0xfb, 0x03, 0xbf, 0xd3, 0x7b, 0x49,
	0x4c, 0x51, 0xb1, 0x57, 0x47, 0x13, 0xeb, 0x7b, 0x41, 0x70, 0xd7, 0xe0, 0x18, 0x3b, 0x0b, 0x27,
	0xe1, 0xd4, 0xcd, 0x5b, 0x6b, 0x62, 0xf5, 0x6e, 0xd9, 0xdb, 0xee, 0x1e, 0x87, 0xe9, 0x72, 0xa1,
	0x9c, 0xdf, 0x2c, 0x94, 0xf2, 0x09, 0x84, 0x67, 0x60, 0xf2, 0xf6, 0x76, 0xbe, 0x72, 0x37, 0x11,
	0xe3, 0xae, 0x8c, 0xd8, 0x27, 0x67, 0x3f, 0x42, 0x4f, 0x84, 0xaf, 0x23, 0xb8, 0x38, 0x44, 0xc8,
	0x1d, 0xb1, 0xf9, 0xfc, 0xf8, 0x6f, 0x48, 0x5e, 0xea, 0x8b, 0x33, 0xf8, 0xfd, 0xc1, 0x8f, 0x03,
	0xee, 0xd7, 0x08, 0x16, 0xed, 0xee, 0x78, 0x70, 0x62, 0x0f, 0xb2, 0x45, 0x0f, 0x64, 0x2f, 0x51,
	0xc8, 0xf2, 0x38, 0x9a, 0xfe, 0x7d, 0xa8, 0x6e, 0x03, 0x0c, 0x4e, 0x66, 0x09, 0x78, 0x69, 0xa4,
	0x88, 0x56, 0x1c, 0x82, 0xb8, 0x1f, 0x22, 0x38, 0x63, 0xdd, 0xac, 0x83, 0x69, 0xe3, 0x39, 0x19,
	0x30, 0xce, 0xfd, 0xff, 0x3d, 0xd6, 0x97, 0xbb, 0xb4, 0x64, 0xa5, 0xee, 0x5d, 0x98, 0x75, 0xc4,
	0x87, 0x5d, 0xf7, 0x23, 0x7a, 0xc6, 0x29, 0x69, 0xe8, 0xeb, 0xbd, 0x01, 0x8b, 0xf6, 0x5d, 0xeb,
	0xc7, 0x40, 0xc1, 0x55, 0x18, 0x98, 0x03, 0x23, 0x22, 0x98, 0xdd, 0xad, 0x3f, 0x42, 0x90, 0xdc,
	0x22, 0x92, 0x5e, 0xbf, 0x17, 0x10, 0x2a, 0xc1, 0x13, 0xaa, 0x57, 0xe9, 0x49, 0xe7, 0xe1, 0x95,
	0x3e, 0xd2, 0xbd, 0xf2, 0x37, 0xd9, 0x44, 0x3f, 0x3c, 0xa7, 0x60, 0x92, 0xea, 0xc4, 0x6c, 0xb4,
	0x7f, 0xb8, 0x83, 0x16, 0x7f, 0x66, 0xd0, 0x26, 0xbc, 0x41, 0xfb, 0x3e, 0x82, 0x97, 0x02, 0x34,
	0xfe, 0x7f, 0x09, 0xdb, 0x63, 0x04, 0xa7, 0x8b, 0xea, 0xee, 0x73, 0x8d, 0x1a, 0xbe, 0x0b, 0xf3,
	0x0d, 0x62, 0x98, 0xb2, 0xd2, 0x7f, 0xd1, 0x52, 0x6c, 0xaf, 0xad, 0x8e, 0x90, 0x48, 0x73, 0x0e,
	0x49, 0x85, 0x06, 0xf7, 0x77, 0x04, 0x73, 0x6b, 0xf2, 0x61, 0x44, 0xde, 0x5b, 0xfd, 0xf6, 0x87,
	0xb2, 0x3c, 0xf1, 0xe1, 0x58, 0x1e, 0xd6, 0x03, 0x51, 0x7a, 0x07, 0xc3, 0x04, 0x8d, 0xfe, 0x04,
	0xed, 0x43, 0xe8, 0x77, 0xb6, 0xf5, 0x44, 0x90, 0xe1, 0xb5, 0x21, 0xd4, 0x77, 0x2b, 0x78, 0x69,
	0xd8, 0x5a, 0x5c, 0x93, 0x9d, 0xaf, 0xf2, 0x26, 0x2c, 0x6e, 0x10, 0xd3, 0x25, 0xaa, 0x17, 0xaa,
	0x4d, 0x57, 0xa8, 0xde, 0xa0, 0xa1, 0x5a, 0x8d, 0xae, 0x19, 0xcb, 0xb1, 0x5f, 0x20, 0x48, 0xd9,
	0xfd, 0x6b, 0xe0, 0x61, 0x22, 0xcc, 0xd7, 0x64, 0xd1, 0xff, 0xaa, 0x7b, 0x23, 0x02, 0x6a, 0xdd,
	0x82, 0xe7, 0x6a, 0x2e, 0xff, 0x8c, 0xd3, 0xab, 0xae, 0x3e, 0x3e, 0x0f, 0xd8, 0x21, 0x6c, 0x8b,
	0xe8, 0xbb, 0x72, 0x9d, 0xe0, 0x2f, 0xc7, 0x60, 0xc1, 0x47, 0xe0, 0xe0, 0x48, 0xac, 0x62, 0x08,
	0xfd, 0x93, 0x1a, 0xf1, 0x35, 0xcb, 0x29, 0x5d, 0xe1, 0x15, 0xbb, 0xea, 0x5c, 0x70, 0x2c, 0xbd,
	0xe0, 0xa6, 0x7e, 0x3e, 0xfc, 0xf3, 0xdf, 0xbe, 0x13, 0x5b, 0xe7, 0x2e, 0xf5, 0xf9, 0xfd, 0x7d,
	0x7b, 0xcb, 0xf5, 0x3e, 0x86, 0xd2, 0x0e, 0xec, 0xa4, 0xdd, 0xf7, 0x77, 0xd6, 0xf5, 0x60, 0xfe,
	0x2b, 0x82, 0x84, 0x97, 0x15, 0xc1, 0x6b, 0x11, 0x94, 0x0f, 0xa1, 0x84, 0x52, 0xb9, 0xb1, 0x64,
	0xd8, 0x85, 0x90, 0xbb, 0xd1, 0x15, 0x58, 0x0d, 0xa6, 0x26, 0x5f, 0xc1, 0xa3, 0x99, 0x8c, 0xff,
	0x88, 0x60, 0xde, 0xcd, 0xad, 0xe0, 0xb7, 0x22, 0xe8, 0x17, 0x48, 0xcb, 0x8c, 0x1c, 0xe2, 0xf5,
	0xae, 0x40, 0x53, 0xca, 0x6f, 0x92, 0x35, 0x1a, 0x62, 0x90, 0xbb, 0x05, 0x4b, 0x1f, 0xe0, 0x9f,
	0x21, 0x58, 0xf0, 0x31, 0x39, 0x91, 0xb0, 0x1b, 0xc6, 0x03, 0xa5, 0xce, 0xf8, 0xb2, 0x2a, 0xdf,
	0xd6, 0xcc, 0x3d, 0x8f, 0xe2, 0xe9, 0x11, 0x15, 0xff, 0x30, 0x06, 0x0b, 0x3e, 0x66, 0x28, 0x92,
	0xe2, 0x61, 0xbc, 0xd2, 0xc8, 0x11, 0xd1, 0xba, 0xc2, 0xa2, 0x33, 0xdb, 0x1c, 0x85, 0x86, 0xda,
	0x5a, 0x5e, 0x15, 0x06, 0xb6, 0x3a, 0x85, 0x45, 0xb0, 0xdb, 0x9d, 0x76, 0xff, 0x65, 0x4d, 0x5b,
	0xc0, 0xb3, 0x0e, 0x17, 0x22, 0x66, 0x4e, 0xf8, 0xd3, 0x30, 0x75, 0xf3, 0x28, 0x44, 0xb1, 0x5c,
	0x2c, 0xba, 0x73, 0xf1, 0x4d, 0x7c, 0x6d, 0xe8, 0x5c, 0x0c, 0x22, 0x88, 0xfe, 0x89, 0x28, 0xdd,
	0x19, 0xc0, 0xd4, 0x6f, 0x44, 0xcb, 0xcc, 0x50, 0xfa, 0x21, 0x35, 0xde, 0x1b, 0x9c, 0xfb, 0x9c,
	0x13, 0xee, 0x2e, 0x73, 0x9f, 0x15, 0xf6, 0xa0, 0x3f, 0x1f, 0xa4, 0x0f, 0xf0, 0xef, 0x50, 0x8f,
	0x78, 0x0d, 0xb0, 0xf8, 0x66, 0xe4, 0xac, 0x0d, 0x37, 0x3a, 0x2c, 0x79, 0xdd, 0xd6, 0xa4, 0xc7,
	0xb3, 0xe6, 0xe7, 0xb1, 0x1e, 0xbb, 0x3b, 0xa6, 0x35, 0x87, 0x30, 0x62, 0xe3, 0x86, 0xf0, 0x9b,
	0xa8, 0x2b, 0x2c, 0x05, 0xb0, 0x18, 0xbe, 0x0c, 0x6f, 0xae, 0x96, 0x07, 0x0e, 0x09, 0xd8, 0x90,
	0x89, 0xee, 0xa4, 0x6c, 0x10, 0x97, 0x87, 0xbf, 0x15, 0x83, 0xc5, 0x10, 0x82, 0x2a, 0x52, 0xe2,
	0x3f, 0x9b, 0x79, 0x8b, 0x94, 0xf8, 0x87, 0xf0, 0x65, 0x9c, 0xd8, 0x15, 0x4e, 0x58, 0xe6, 0x5f,
	0x18, 0x10, 0x6f, 0xd4, 0x67, 0x1b, 0xdc, 0xda, 0x38, 0x20, 0xca, 0x1a, 0xd6, 0xb9, 0x59, 0x94,
	0xc6, 0xdf, 0x8d, 0x41, 0x32, 0x8c, 0xe4, 0x8a, 0x84, 0xa6, 0x43, 0x98, 0xb2, 0x71, 0xd1, 0xa4,
	0x74, 0x85, 0x73, 0xac, 0x37, 0x0b, 0x61, 0xc6, 0xfc, 0x7e, 0x89, 0x5e, 0x19, 0xb3, 0x6d, 0xcb,
	0x0a, 0xcb, 0x2f, 0x4f, 0x11, 0x24, 0xbc, 0x0c, 0x4a, 0xa4, 0xde, 0x2c, 0x84, 0x7e, 0x49, 0x8d,
	0xf6, 0x94, 0xe4, 0x1e, 0x74, 0x85, 0x05, 0x66, 0xff, 0xe0, 0x51, 0x49, 0x4d, 0xbe, 0xcd, 0xe5,
	0x86, 0x34, 0xd9, 0x7b, 0x2d, 0x3a, 0xf9, 0xa3, 0xac, 0x83, 0x7c, 0xc1, 0xff, 0x42, 0x70, 0xc2,
	0x43, 0x6b, 0x60, 0x21, 0xe2, 0x75, 0xe6, 0x67, 0x03, 0x52, 0x6b, 0xe3, 0x88, 0x60, 0x09, 0x51,
	0x75, 0xdf, 0x84, 0x79, 0x7c, 0x14, 0xc6, 0xe3, 0xdf, 0x20, 0x48, 0x78, 0xb9, 0x92, 0x48, 0xd1,
	0x0e, 0x21, 0x5a, 0x42, 0x6f, 0x84, 0x8a, 0xf3, 0x46, 0xc8, 0xa7, 0x73, 0xa3, 0xb4, 0x73, 0x2e,
	0xfa, 0x2f, 0x7d, 0x80, 0xff, 0x8d, 0x60, 0xc1, 0xc7, 0x6b, 0x44, 0x6a, 0xee, 0xc2, 0x78, 0x9c,
	0xd4, 0xfa, 0x78, 0x42, 0x58, 0xec, 0x6e, 0x77, 0x85, 0xe3, 0x0c, 0xc3, 0x74, 0x3b, 0x35, 0xfe,
	0x1a, 0xce, 0x0e, 0x9b, 0xb1, 0x59, 0xc3, 0x67, 0xdd, 0x7f, 0x10, 0xcc, 0xbb, 0xc9, 0x92, 0x48,
	0x8f, 0x8b, 0x40, 0x9e, 0x65, 0xd4, 0x14, 0x95, 0xbb, 0xc2, 0x49, 0x5a, 0xab, 0xdd, 0xcc, 0x0a,
	0xb5, 0xb2, 0xc8, 0xbd, 0x7d, 0x04, 0x21, 0xce, 0xb6, 0xd5, 0x5d, 0x5a, 0x9d, 0xfe, 0x82, 0x20,
	0xe1, 0xa5, 0x1e, 0x22, 0xe1, 0x35, 0x84, 0xb7, 0x48, 0x8d, 0x4c, 0x19, 0x70, 0x39, 0x27, 0xa2,
	0x2f, 0xe3, 0xcf, 0x0e, 0x67, 0xae, 0x8b, 0x67, 0x38, 0xc0, 0x1f, 0xc5, 0xe0, 0x64, 0x00, 0xd1,
	0x81, 0xf3, 0x91, 0xdb, 0x9a, 0x23, 0xb6, 0xee, 0xfd, 0xae, 0x90, 0x72, 0x73, 0x2c, 0xbe, 0x36,
	0x66, 0x7b, 0xd5, 0x91, 0xc5, 0xee, 0xb5, 0x99, 0xe1, 0x5d, 0x90, 0xf5, 0x50, 0x39, 0xa9, 0x2f,
	0xfd, 0x56, 0xe0, 0x0e, 0xa7, 0x8d, 0xfe, 0x24, 0xbc, 0x7b, 0xcf, 0x34, 0x35, 0x23, 0xcb, 0xf3,
	0x8f, 0x1e, 0x3d, 0xf2, 0x72, 0x4a, 0x52, 0xc7, 0xbc, 0xd7, 0xff, 0x27, 0xc5, 0x0b, 0x87, 0x2d,
	0xa4, 0xce, 0xb9, 0xa8, 0xb5, 0x24, 0x73, 0x47, 0xd5, 0xdb, 0x6b, 0x5f, 0x45, 0x70, 0xb1, 0xae,
	0xb6, 0x87, 0x77, 0x5d, 0x19, 0xbd, 0x57, 0x65, 0x8b, 0x9b, 0x6a, 0x4b, 0x52, 0x9a, 0x19, 0x55,
	0x6f, 0xf2, 0x4d, 0xa2, 0xd0, 0x1a, 0xc8, 0x0f, 0x8e, 0x1c, 0xe2, 0xbf, 0x27, 0xaf, 0x3a, 0xc6,
	0x6a, 0x53, 0x54, 0xc0, 0x67, 0xfe, 0x17, 0x00, 0x00, 0xff, 0xff, 0x0c, 0xca, 0xad, 0x71, 0x7d,
	0x29, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReservationServiceClient is the client API for ReservationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReservationServiceClient interface {
	// Creates a new reservation resource.
	CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only renewal_plan field can be updated.
	UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// commitment_end_time. A common use case to do that is to perform a downgrade
	// e.g., in order to downgrade from 10000 slots to 8000, one might split 10000
	// capacity commitment to 2000 and 8000, change the plan of the first one to
	// flex and then delete it.
	SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into one. Resulting capacity
	// commitment has the longer commitment_end_time out of the two. Attempting to
	// merge capacity commitments of different plan will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Lists assignments.
	// Only explicitly created assignments will be returned. E.g:
	// organizationA contains project1 and project2. Reservation res1 exists.
	// CreateAssignment was invoked previously and following assignments were
	// created explicitly:
	//   <organizationA, res1>
	//   <project1, res1>
	// Then this API will just return the above two assignments for reservation
	// res1, and no expansion/merge will happen. Wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed. Note
	// "-" cannot be used for projects nor locations.
	ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	// E.g:
	// organizationA contains project1 and project2. Reservation res1 exists.
	// CreateAssignment was invoked previously and following assignments were
	// created explicitly:
	//   <organizationA, res1>
	//   <project1, res1>
	// Then deletion of <organizationA, res1> won't affect <project1, res1>. After
	// deletion of <organizationA, res1>, queries from project1 will still use
	// res1, while queries from project2 will use on-demand mode.
	DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//   1) Assignments created on the project will be returned if they exist.
	//   2) Otherwise assignments created on the closest ancestor will be
	//   returned. 3) Assignments for different JobTypes will all be returned.
	// Same logic applies if the request is about a folder.
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//   1) permission on the assignee will be verified in this API.
	//   2) Hierarchy lookup (project->folder->organization) happens in this API.
	//   3) Parent here is projects/*/locations/*, instead of
	//   projects/*/locations/*reservations/*.
	// Note "-" cannot be used for projects
	// nor locations.
	SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error)
	// Moves a assignment under a new reservation. Customers can do this by
	// deleting the existing assignment followed by creating another assignment
	// under the new reservation, but this method provides a transactional way to
	// do so, to make sure the assignee always has an associated reservation.
	// Without the method customers might see some queries run on-demand which
	// might be unexpected.
	MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
	// Updates a BI reservation.
	// Only fields specified in the field_mask are updated.
	// Singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
}

type reservationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReservationServiceClient(cc grpc.ClientConnInterface) ReservationServiceClient {
	return &reservationServiceClient{cc}
}

func (c *reservationServiceClient) CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error) {
	out := new(ListReservationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListReservations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error) {
	out := new(ListCapacityCommitmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListCapacityCommitments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error) {
	out := new(SplitCapacityCommitmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SplitCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MergeCapacityCommitments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error) {
	out := new(ListAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error) {
	out := new(SearchAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SearchAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MoveAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetBiReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateBiReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReservationServiceServer is the server API for ReservationService service.
type ReservationServiceServer interface {
	// Creates a new reservation resource.
	CreateReservation(context.Context, *CreateReservationRequest) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(context.Context, *ListReservationsRequest) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(context.Context, *GetReservationRequest) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(context.Context, *DeleteReservationRequest) (*empty.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(context.Context, *UpdateReservationRequest) (*Reservation, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(context.Context, *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(context.Context, *GetCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(context.Context, *DeleteCapacityCommitmentRequest) (*empty.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only renewal_plan field can be updated.
	UpdateCapacityCommitment(context.Context, *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// commitment_end_time. A common use case to do that is to perform a downgrade
	// e.g., in order to downgrade from 10000 slots to 8000, one might split 10000
	// capacity commitment to 2000 and 8000, change the plan of the first one to
	// flex and then delete it.
	SplitCapacityCommitment(context.Context, *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into one. Resulting capacity
	// commitment has the longer commitment_end_time out of the two. Attempting to
	// merge capacity commitments of different plan will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(context.Context, *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error)
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(context.Context, *CreateAssignmentRequest) (*Assignment, error)
	// Lists assignments.
	// Only explicitly created assignments will be returned. E.g:
	// organizationA contains project1 and project2. Reservation res1 exists.
	// CreateAssignment was invoked previously and following assignments were
	// created explicitly:
	//   <organizationA, res1>
	//   <project1, res1>
	// Then this API will just return the above two assignments for reservation
	// res1, and no expansion/merge will happen. Wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed. Note
	// "-" cannot be used for projects nor locations.
	ListAssignments(context.Context, *ListAssignmentsRequest) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	// E.g:
	// organizationA contains project1 and project2. Reservation res1 exists.
	// CreateAssignment was invoked previously and following assignments were
	// created explicitly:
	//   <organizationA, res1>
	//   <project1, res1>
	// Then deletion of <organizationA, res1> won't affect <project1, res1>. After
	// deletion of <organizationA, res1>, queries from project1 will still use
	// res1, while queries from project2 will use on-demand mode.
	DeleteAssignment(context.Context, *DeleteAssignmentRequest) (*empty.Empty, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//   1) Assignments created on the project will be returned if they exist.
	//   2) Otherwise assignments created on the closest ancestor will be
	//   returned. 3) Assignments for different JobTypes will all be returned.
	// Same logic applies if the request is about a folder.
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//   1) permission on the assignee will be verified in this API.
	//   2) Hierarchy lookup (project->folder->organization) happens in this API.
	//   3) Parent here is projects/*/locations/*, instead of
	//   projects/*/locations/*reservations/*.
	// Note "-" cannot be used for projects
	// nor locations.
	SearchAssignments(context.Context, *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error)
	// Moves a assignment under a new reservation. Customers can do this by
	// deleting the existing assignment followed by creating another assignment
	// under the new reservation, but this method provides a transactional way to
	// do so, to make sure the assignee always has an associated reservation.
	// Without the method customers might see some queries run on-demand which
	// might be unexpected.
	MoveAssignment(context.Context, *MoveAssignmentRequest) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(context.Context, *GetBiReservationRequest) (*BiReservation, error)
	// Updates a BI reservation.
	// Only fields specified in the field_mask are updated.
	// Singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(context.Context, *UpdateBiReservationRequest) (*BiReservation, error)
}

// UnimplementedReservationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReservationServiceServer struct {
}

func (*UnimplementedReservationServiceServer) CreateReservation(ctx context.Context, req *CreateReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReservation not implemented")
}
func (*UnimplementedReservationServiceServer) ListReservations(ctx context.Context, req *ListReservationsRequest) (*ListReservationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReservations not implemented")
}
func (*UnimplementedReservationServiceServer) GetReservation(ctx context.Context, req *GetReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReservation not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteReservation(ctx context.Context, req *DeleteReservationRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteReservation not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateReservation(ctx context.Context, req *UpdateReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateReservation not implemented")
}
func (*UnimplementedReservationServiceServer) ListCapacityCommitments(ctx context.Context, req *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCapacityCommitments not implemented")
}
func (*UnimplementedReservationServiceServer) GetCapacityCommitment(ctx context.Context, req *GetCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteCapacityCommitment(ctx context.Context, req *DeleteCapacityCommitmentRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateCapacityCommitment(ctx context.Context, req *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) SplitCapacityCommitment(ctx context.Context, req *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SplitCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) MergeCapacityCommitments(ctx context.Context, req *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MergeCapacityCommitments not implemented")
}
func (*UnimplementedReservationServiceServer) CreateAssignment(ctx context.Context, req *CreateAssignmentRequest) (*Assignment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) ListAssignments(ctx context.Context, req *ListAssignmentsRequest) (*ListAssignmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssignments not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteAssignment(ctx context.Context, req *DeleteAssignmentRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) SearchAssignments(ctx context.Context, req *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAssignments not implemented")
}
func (*UnimplementedReservationServiceServer) MoveAssignment(ctx context.Context, req *MoveAssignmentRequest) (*Assignment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MoveAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) GetBiReservation(ctx context.Context, req *GetBiReservationRequest) (*BiReservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetBiReservation not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateBiReservation(ctx context.Context, req *UpdateBiReservationRequest) (*BiReservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateBiReservation not implemented")
}

func RegisterReservationServiceServer(s *grpc.Server, srv ReservationServiceServer) {
	s.RegisterService(&_ReservationService_serviceDesc, srv)
}

func _ReservationService_CreateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateReservation(ctx, req.(*CreateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListReservations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReservationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListReservations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListReservations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListReservations(ctx, req.(*ListReservationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetReservation(ctx, req.(*GetReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, req.(*DeleteReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, req.(*UpdateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListCapacityCommitments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, req.(*ListCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, req.(*GetCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, req.(*DeleteCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, req.(*UpdateCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SplitCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SplitCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, req.(*SplitCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MergeCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MergeCapacityCommitments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, req.(*MergeCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, req.(*CreateAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListAssignments(ctx, req.(*ListAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, req.(*DeleteAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SearchAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SearchAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, req.(*SearchAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MoveAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MoveAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, req.(*MoveAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetBiReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, req.(*GetBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateBiReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, req.(*UpdateBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReservationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.reservation.v1beta1.ReservationService",
	HandlerType: (*ReservationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReservation",
			Handler:    _ReservationService_CreateReservation_Handler,
		},
		{
			MethodName: "ListReservations",
			Handler:    _ReservationService_ListReservations_Handler,
		},
		{
			MethodName: "GetReservation",
			Handler:    _ReservationService_GetReservation_Handler,
		},
		{
			MethodName: "DeleteReservation",
			Handler:    _ReservationService_DeleteReservation_Handler,
		},
		{
			MethodName: "UpdateReservation",
			Handler:    _ReservationService_UpdateReservation_Handler,
		},
		{
			MethodName: "ListCapacityCommitments",
			Handler:    _ReservationService_ListCapacityCommitments_Handler,
		},
		{
			MethodName: "GetCapacityCommitment",
			Handler:    _ReservationService_GetCapacityCommitment_Handler,
		},
		{
			MethodName: "DeleteCapacityCommitment",
			Handler:    _ReservationService_DeleteCapacityCommitment_Handler,
		},
		{
			MethodName: "UpdateCapacityCommitment",
			Handler:    _ReservationService_UpdateCapacityCommitment_Handler,
		},
		{
			MethodName: "SplitCapacityCommitment",
			Handler:    _ReservationService_SplitCapacityCommitment_Handler,
		},
		{
			MethodName: "MergeCapacityCommitments",
			Handler:    _ReservationService_MergeCapacityCommitments_Handler,
		},
		{
			MethodName: "CreateAssignment",
			Handler:    _ReservationService_CreateAssignment_Handler,
		},
		{
			MethodName: "ListAssignments",
			Handler:    _ReservationService_ListAssignments_Handler,
		},
		{
			MethodName: "DeleteAssignment",
			Handler:    _ReservationService_DeleteAssignment_Handler,
		},
		{
			MethodName: "SearchAssignments",
			Handler:    _ReservationService_SearchAssignments_Handler,
		},
		{
			MethodName: "MoveAssignment",
			Handler:    _ReservationService_MoveAssignment_Handler,
		},
		{
			MethodName: "GetBiReservation",
			Handler:    _ReservationService_GetBiReservation_Handler,
		},
		{
			MethodName: "UpdateBiReservation",
			Handler:    _ReservationService_UpdateBiReservation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/reservation/v1beta1/reservation.proto",
}
