// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/expr/v1alpha1/conformance_service.proto

package confpb

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	v1alpha1 "google.golang.org/genproto/googleapis/api/expr/v1alpha1"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Severities of issues.
type IssueDetails_Severity int32

const (
	// An unspecified severity.
	IssueDetails_SEVERITY_UNSPECIFIED IssueDetails_Severity = 0
	// Deprecation issue for statements and method that may no longer be
	// supported or maintained.
	IssueDetails_DEPRECATION IssueDetails_Severity = 1
	// Warnings such as: unused variables.
	IssueDetails_WARNING IssueDetails_Severity = 2
	// Errors such as: unmatched curly braces or variable redefinition.
	IssueDetails_ERROR IssueDetails_Severity = 3
)

var IssueDetails_Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "DEPRECATION",
	2: "WARNING",
	3: "ERROR",
}

var IssueDetails_Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"DEPRECATION":          1,
	"WARNING":              2,
	"ERROR":                3,
}

func (x IssueDetails_Severity) String() string {
	return proto.EnumName(IssueDetails_Severity_name, int32(x))
}

func (IssueDetails_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{6, 0}
}

// Request message for the Parse method.
type ParseRequest struct {
	// Required. Source text in CEL syntax.
	CelSource string `protobuf:"bytes,1,opt,name=cel_source,json=celSource,proto3" json:"cel_source,omitempty"`
	// Tag for version of CEL syntax, for future use.
	SyntaxVersion string `protobuf:"bytes,2,opt,name=syntax_version,json=syntaxVersion,proto3" json:"syntax_version,omitempty"`
	// File or resource for source text, used in [SourceInfo][google.api.expr.v1alpha1.SourceInfo].
	SourceLocation string `protobuf:"bytes,3,opt,name=source_location,json=sourceLocation,proto3" json:"source_location,omitempty"`
	// Prevent macro expansion.  See "Macros" in Language Defiinition.
	DisableMacros        bool     `protobuf:"varint,4,opt,name=disable_macros,json=disableMacros,proto3" json:"disable_macros,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ParseRequest) Reset()         { *m = ParseRequest{} }
func (m *ParseRequest) String() string { return proto.CompactTextString(m) }
func (*ParseRequest) ProtoMessage()    {}
func (*ParseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{0}
}

func (m *ParseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParseRequest.Unmarshal(m, b)
}
func (m *ParseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParseRequest.Marshal(b, m, deterministic)
}
func (m *ParseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParseRequest.Merge(m, src)
}
func (m *ParseRequest) XXX_Size() int {
	return xxx_messageInfo_ParseRequest.Size(m)
}
func (m *ParseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ParseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ParseRequest proto.InternalMessageInfo

func (m *ParseRequest) GetCelSource() string {
	if m != nil {
		return m.CelSource
	}
	return ""
}

func (m *ParseRequest) GetSyntaxVersion() string {
	if m != nil {
		return m.SyntaxVersion
	}
	return ""
}

func (m *ParseRequest) GetSourceLocation() string {
	if m != nil {
		return m.SourceLocation
	}
	return ""
}

func (m *ParseRequest) GetDisableMacros() bool {
	if m != nil {
		return m.DisableMacros
	}
	return false
}

// Response message for the Parse method.
type ParseResponse struct {
	// The parsed representation, or unset if parsing failed.
	ParsedExpr *v1alpha1.ParsedExpr `protobuf:"bytes,1,opt,name=parsed_expr,json=parsedExpr,proto3" json:"parsed_expr,omitempty"`
	// Any number of issues with [StatusDetails][] as the details.
	Issues               []*status.Status `protobuf:"bytes,2,rep,name=issues,proto3" json:"issues,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ParseResponse) Reset()         { *m = ParseResponse{} }
func (m *ParseResponse) String() string { return proto.CompactTextString(m) }
func (*ParseResponse) ProtoMessage()    {}
func (*ParseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{1}
}

func (m *ParseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParseResponse.Unmarshal(m, b)
}
func (m *ParseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParseResponse.Marshal(b, m, deterministic)
}
func (m *ParseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParseResponse.Merge(m, src)
}
func (m *ParseResponse) XXX_Size() int {
	return xxx_messageInfo_ParseResponse.Size(m)
}
func (m *ParseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ParseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ParseResponse proto.InternalMessageInfo

func (m *ParseResponse) GetParsedExpr() *v1alpha1.ParsedExpr {
	if m != nil {
		return m.ParsedExpr
	}
	return nil
}

func (m *ParseResponse) GetIssues() []*status.Status {
	if m != nil {
		return m.Issues
	}
	return nil
}

// Request message for the Check method.
type CheckRequest struct {
	// Required. The parsed representation of the CEL program.
	ParsedExpr *v1alpha1.ParsedExpr `protobuf:"bytes,1,opt,name=parsed_expr,json=parsedExpr,proto3" json:"parsed_expr,omitempty"`
	// Declarations of types for external variables and functions.
	// Required if program uses external variables or functions
	// not in the default environment.
	TypeEnv []*v1alpha1.Decl `protobuf:"bytes,2,rep,name=type_env,json=typeEnv,proto3" json:"type_env,omitempty"`
	// The protocol buffer context.  See "Name Resolution" in the
	// Language Definition.
	Container string `protobuf:"bytes,3,opt,name=container,proto3" json:"container,omitempty"`
	// If true, use only the declarations in [type_env][google.api.expr.v1alpha1.CheckRequest.type_env].  If false (default),
	// add declarations for the standard definitions to the type environment.  See
	// "Standard Definitions" in the Language Definition.
	NoStdEnv             bool     `protobuf:"varint,4,opt,name=no_std_env,json=noStdEnv,proto3" json:"no_std_env,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckRequest) Reset()         { *m = CheckRequest{} }
func (m *CheckRequest) String() string { return proto.CompactTextString(m) }
func (*CheckRequest) ProtoMessage()    {}
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{2}
}

func (m *CheckRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckRequest.Unmarshal(m, b)
}
func (m *CheckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckRequest.Marshal(b, m, deterministic)
}
func (m *CheckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckRequest.Merge(m, src)
}
func (m *CheckRequest) XXX_Size() int {
	return xxx_messageInfo_CheckRequest.Size(m)
}
func (m *CheckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckRequest proto.InternalMessageInfo

func (m *CheckRequest) GetParsedExpr() *v1alpha1.ParsedExpr {
	if m != nil {
		return m.ParsedExpr
	}
	return nil
}

func (m *CheckRequest) GetTypeEnv() []*v1alpha1.Decl {
	if m != nil {
		return m.TypeEnv
	}
	return nil
}

func (m *CheckRequest) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

func (m *CheckRequest) GetNoStdEnv() bool {
	if m != nil {
		return m.NoStdEnv
	}
	return false
}

// Response message for the Check method.
type CheckResponse struct {
	// The annotated representation, or unset if checking failed.
	CheckedExpr *v1alpha1.CheckedExpr `protobuf:"bytes,1,opt,name=checked_expr,json=checkedExpr,proto3" json:"checked_expr,omitempty"`
	// Any number of issues with [StatusDetails][] as the details.
	Issues               []*status.Status `protobuf:"bytes,2,rep,name=issues,proto3" json:"issues,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CheckResponse) Reset()         { *m = CheckResponse{} }
func (m *CheckResponse) String() string { return proto.CompactTextString(m) }
func (*CheckResponse) ProtoMessage()    {}
func (*CheckResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{3}
}

func (m *CheckResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckResponse.Unmarshal(m, b)
}
func (m *CheckResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckResponse.Marshal(b, m, deterministic)
}
func (m *CheckResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse.Merge(m, src)
}
func (m *CheckResponse) XXX_Size() int {
	return xxx_messageInfo_CheckResponse.Size(m)
}
func (m *CheckResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse proto.InternalMessageInfo

func (m *CheckResponse) GetCheckedExpr() *v1alpha1.CheckedExpr {
	if m != nil {
		return m.CheckedExpr
	}
	return nil
}

func (m *CheckResponse) GetIssues() []*status.Status {
	if m != nil {
		return m.Issues
	}
	return nil
}

// Request message for the Eval method.
type EvalRequest struct {
	// Required. Either the parsed or annotated representation of the CEL program.
	//
	// Types that are valid to be assigned to ExprKind:
	//	*EvalRequest_ParsedExpr
	//	*EvalRequest_CheckedExpr
	ExprKind isEvalRequest_ExprKind `protobuf_oneof:"expr_kind"`
	// Bindings for the external variables.  The types SHOULD be compatible
	// with the type environment in [CheckRequest][google.api.expr.v1alpha1.CheckRequest], if checked.
	Bindings map[string]*v1alpha1.ExprValue `protobuf:"bytes,3,rep,name=bindings,proto3" json:"bindings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// SHOULD be the same container as used in [CheckRequest][google.api.expr.v1alpha1.CheckRequest], if checked.
	Container            string   `protobuf:"bytes,4,opt,name=container,proto3" json:"container,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EvalRequest) Reset()         { *m = EvalRequest{} }
func (m *EvalRequest) String() string { return proto.CompactTextString(m) }
func (*EvalRequest) ProtoMessage()    {}
func (*EvalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{4}
}

func (m *EvalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EvalRequest.Unmarshal(m, b)
}
func (m *EvalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EvalRequest.Marshal(b, m, deterministic)
}
func (m *EvalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvalRequest.Merge(m, src)
}
func (m *EvalRequest) XXX_Size() int {
	return xxx_messageInfo_EvalRequest.Size(m)
}
func (m *EvalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EvalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EvalRequest proto.InternalMessageInfo

type isEvalRequest_ExprKind interface {
	isEvalRequest_ExprKind()
}

type EvalRequest_ParsedExpr struct {
	ParsedExpr *v1alpha1.ParsedExpr `protobuf:"bytes,1,opt,name=parsed_expr,json=parsedExpr,proto3,oneof"`
}

type EvalRequest_CheckedExpr struct {
	CheckedExpr *v1alpha1.CheckedExpr `protobuf:"bytes,2,opt,name=checked_expr,json=checkedExpr,proto3,oneof"`
}

func (*EvalRequest_ParsedExpr) isEvalRequest_ExprKind() {}

func (*EvalRequest_CheckedExpr) isEvalRequest_ExprKind() {}

func (m *EvalRequest) GetExprKind() isEvalRequest_ExprKind {
	if m != nil {
		return m.ExprKind
	}
	return nil
}

func (m *EvalRequest) GetParsedExpr() *v1alpha1.ParsedExpr {
	if x, ok := m.GetExprKind().(*EvalRequest_ParsedExpr); ok {
		return x.ParsedExpr
	}
	return nil
}

func (m *EvalRequest) GetCheckedExpr() *v1alpha1.CheckedExpr {
	if x, ok := m.GetExprKind().(*EvalRequest_CheckedExpr); ok {
		return x.CheckedExpr
	}
	return nil
}

func (m *EvalRequest) GetBindings() map[string]*v1alpha1.ExprValue {
	if m != nil {
		return m.Bindings
	}
	return nil
}

func (m *EvalRequest) GetContainer() string {
	if m != nil {
		return m.Container
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EvalRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EvalRequest_ParsedExpr)(nil),
		(*EvalRequest_CheckedExpr)(nil),
	}
}

// Response message for the Eval method.
type EvalResponse struct {
	// The execution result, or unset if execution couldn't start.
	Result *v1alpha1.ExprValue `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	// Any number of issues with [StatusDetails][] as the details.
	// Note that CEL execution errors are reified into [ExprValue][google.api.expr.v1alpha1.ExprValue].
	// Nevertheless, we'll allow out-of-band issues to be raised,
	// which also makes the replies more regular.
	Issues               []*status.Status `protobuf:"bytes,2,rep,name=issues,proto3" json:"issues,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *EvalResponse) Reset()         { *m = EvalResponse{} }
func (m *EvalResponse) String() string { return proto.CompactTextString(m) }
func (*EvalResponse) ProtoMessage()    {}
func (*EvalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{5}
}

func (m *EvalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EvalResponse.Unmarshal(m, b)
}
func (m *EvalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EvalResponse.Marshal(b, m, deterministic)
}
func (m *EvalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvalResponse.Merge(m, src)
}
func (m *EvalResponse) XXX_Size() int {
	return xxx_messageInfo_EvalResponse.Size(m)
}
func (m *EvalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EvalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EvalResponse proto.InternalMessageInfo

func (m *EvalResponse) GetResult() *v1alpha1.ExprValue {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *EvalResponse) GetIssues() []*status.Status {
	if m != nil {
		return m.Issues
	}
	return nil
}

// Warnings or errors in service execution are represented by
// [google.rpc.Status][google.rpc.Status] messages, with the following message
// in the details field.
type IssueDetails struct {
	// The severity of the issue.
	Severity IssueDetails_Severity `protobuf:"varint,1,opt,name=severity,proto3,enum=google.api.expr.v1alpha1.IssueDetails_Severity" json:"severity,omitempty"`
	// Position in the source, if known.
	Position *v1alpha1.SourcePosition `protobuf:"bytes,2,opt,name=position,proto3" json:"position,omitempty"`
	// Expression ID from [Expr][google.api.expr.v1alpha1.Expr], 0 if unknown.
	Id                   int64    `protobuf:"varint,3,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IssueDetails) Reset()         { *m = IssueDetails{} }
func (m *IssueDetails) String() string { return proto.CompactTextString(m) }
func (*IssueDetails) ProtoMessage()    {}
func (*IssueDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3ca1183e6ceae83, []int{6}
}

func (m *IssueDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssueDetails.Unmarshal(m, b)
}
func (m *IssueDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssueDetails.Marshal(b, m, deterministic)
}
func (m *IssueDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssueDetails.Merge(m, src)
}
func (m *IssueDetails) XXX_Size() int {
	return xxx_messageInfo_IssueDetails.Size(m)
}
func (m *IssueDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_IssueDetails.DiscardUnknown(m)
}

var xxx_messageInfo_IssueDetails proto.InternalMessageInfo

func (m *IssueDetails) GetSeverity() IssueDetails_Severity {
	if m != nil {
		return m.Severity
	}
	return IssueDetails_SEVERITY_UNSPECIFIED
}

func (m *IssueDetails) GetPosition() *v1alpha1.SourcePosition {
	if m != nil {
		return m.Position
	}
	return nil
}

func (m *IssueDetails) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.api.expr.v1alpha1.IssueDetails_Severity", IssueDetails_Severity_name, IssueDetails_Severity_value)
	proto.RegisterType((*ParseRequest)(nil), "google.api.expr.v1alpha1.ParseRequest")
	proto.RegisterType((*ParseResponse)(nil), "google.api.expr.v1alpha1.ParseResponse")
	proto.RegisterType((*CheckRequest)(nil), "google.api.expr.v1alpha1.CheckRequest")
	proto.RegisterType((*CheckResponse)(nil), "google.api.expr.v1alpha1.CheckResponse")
	proto.RegisterType((*EvalRequest)(nil), "google.api.expr.v1alpha1.EvalRequest")
	proto.RegisterMapType((map[string]*v1alpha1.ExprValue)(nil), "google.api.expr.v1alpha1.EvalRequest.BindingsEntry")
	proto.RegisterType((*EvalResponse)(nil), "google.api.expr.v1alpha1.EvalResponse")
	proto.RegisterType((*IssueDetails)(nil), "google.api.expr.v1alpha1.IssueDetails")
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/conformance_service.proto", fileDescriptor_b3ca1183e6ceae83)
}

var fileDescriptor_b3ca1183e6ceae83 = []byte{
	// 815 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0x5d, 0x6f, 0xdb, 0x36,
	0x14, 0xb5, 0xe4, 0x24, 0xb5, 0xaf, 0xec, 0xd4, 0x20, 0x06, 0xd4, 0x30, 0xb2, 0x21, 0x70, 0x97,
	0x34, 0xd8, 0x83, 0x84, 0xba, 0x2f, 0xeb, 0xfa, 0xd4, 0xd8, 0x5a, 0xe3, 0x6e, 0x4d, 0x0c, 0xba,
	0x4b, 0xb1, 0xbe, 0x68, 0x8c, 0xc4, 0xb9, 0x44, 0x14, 0x92, 0x23, 0x65, 0x2d, 0x79, 0x1b, 0x06,
	0x0c, 0xd8, 0x0f, 0xd9, 0xfe, 0xcd, 0x7e, 0xd0, 0x1e, 0x07, 0x89, 0xb4, 0x63, 0x77, 0x50, 0x3e,
	0x86, 0xbd, 0xc9, 0xd7, 0xe7, 0x1c, 0xdd, 0x73, 0x78, 0xc5, 0x0b, 0x83, 0x99, 0x10, 0xb3, 0x94,
	0x06, 0x44, 0xb2, 0x80, 0x5e, 0x4a, 0x15, 0xe4, 0x4f, 0x49, 0x2a, 0x3f, 0x90, 0xa7, 0x41, 0x2c,
	0xf8, 0x8f, 0x42, 0x5d, 0x10, 0x1e, 0xd3, 0x48, 0x53, 0x95, 0xb3, 0x98, 0xfa, 0x52, 0x89, 0x4c,
	0xa0, 0xae, 0xe1, 0xf8, 0x44, 0x32, 0xbf, 0xe0, 0xf8, 0x0b, 0x4e, 0x6f, 0xbf, 0x5a, 0xed, 0x03,
	0x8d, 0xcf, 0x69, 0x62, 0x14, 0x7a, 0x8f, 0x2b, 0x71, 0x34, 0x27, 0xa9, 0x05, 0xed, 0x55, 0x82,
	0xf4, 0x15, 0xcf, 0xc8, 0xa5, 0x85, 0x3d, 0xb2, 0x30, 0x25, 0xe3, 0x40, 0x67, 0x24, 0x9b, 0x6b,
	0xf3, 0x47, 0xff, 0x0f, 0x07, 0x5a, 0x13, 0xa2, 0x34, 0xc5, 0xf4, 0xa7, 0x39, 0xd5, 0x19, 0xfa,
	0x14, 0x20, 0xa6, 0x69, 0xa4, 0xc5, 0x5c, 0xc5, 0xb4, 0xeb, 0xec, 0x3a, 0x07, 0x4d, 0xdc, 0x8c,
	0x69, 0x3a, 0x2d, 0x0b, 0x68, 0x0f, 0xb6, 0x8d, 0x70, 0x94, 0x53, 0xa5, 0x99, 0xe0, 0x5d, 0xb7,
	0x84, 0xb4, 0x4d, 0xf5, 0xd4, 0x14, 0xd1, 0x13, 0x78, 0x68, 0x14, 0xa2, 0x54, 0xc4, 0x24, 0x2b,
	0x70, 0xf5, 0x12, 0xb7, 0x6d, 0xca, 0xdf, 0xda, 0x6a, 0xa1, 0x97, 0x30, 0x4d, 0xce, 0x52, 0x1a,
	0x5d, 0x90, 0x58, 0x09, 0xdd, 0xdd, 0xd8, 0x75, 0x0e, 0x1a, 0xb8, 0x6d, 0xab, 0x6f, 0xca, 0x62,
	0xff, 0x57, 0x07, 0xda, 0xb6, 0x4d, 0x2d, 0x05, 0xd7, 0x14, 0x85, 0xe0, 0xc9, 0xa2, 0x90, 0x44,
	0x85, 0xed, 0xb2, 0x51, 0x6f, 0xf0, 0xb9, 0x5f, 0x95, 0xba, 0x5f, 0xb2, 0x93, 0xf0, 0x52, 0x2a,
	0x0c, 0x72, 0xf9, 0x8c, 0xbe, 0x80, 0x2d, 0xa6, 0xf5, 0x9c, 0xea, 0xae, 0xbb, 0x5b, 0x3f, 0xf0,
	0x06, 0x68, 0xa1, 0xa0, 0x64, 0xec, 0x4f, 0xcb, 0xa4, 0xb0, 0x45, 0xf4, 0xff, 0x72, 0xa0, 0x35,
	0x2c, 0x8e, 0x68, 0x91, 0xd5, 0xff, 0xd4, 0xc3, 0x73, 0x68, 0x64, 0x57, 0x92, 0x46, 0x94, 0xe7,
	0xb6, 0x8b, 0xcf, 0xaa, 0x35, 0x46, 0x34, 0x4e, 0xf1, 0x83, 0x02, 0x1f, 0xf2, 0x1c, 0xed, 0x40,
	0x33, 0x16, 0x3c, 0x23, 0x8c, 0x53, 0x65, 0x13, 0xbe, 0x2e, 0xa0, 0x1d, 0x00, 0x2e, 0x22, 0x9d,
	0x25, 0xa5, 0xb4, 0x09, 0xb6, 0xc1, 0xc5, 0x34, 0x4b, 0x42, 0x9e, 0xf7, 0x7f, 0x73, 0xa0, 0x6d,
	0xed, 0xd8, 0x4c, 0x8f, 0xa0, 0x65, 0x47, 0x70, 0xd5, 0xd0, 0x5e, 0x75, 0x33, 0x43, 0x83, 0x2e,
	0x1d, 0x79, 0xf1, 0xf5, 0x8f, 0x7b, 0xc5, 0xfa, 0x4b, 0x1d, 0xbc, 0x30, 0x27, 0xe9, 0x22, 0xd5,
	0x57, 0xff, 0x39, 0xd5, 0xa3, 0xda, 0x5a, 0xae, 0xaf, 0x3f, 0xb2, 0xe3, 0xde, 0xc3, 0xce, 0x51,
	0x6d, 0xdd, 0xd0, 0x09, 0x34, 0xce, 0x18, 0x4f, 0x18, 0x9f, 0xe9, 0x6e, 0xbd, 0xb4, 0xf4, 0xac,
	0x5a, 0x67, 0xc5, 0x8d, 0x7f, 0x68, 0x59, 0x21, 0xcf, 0xd4, 0x15, 0x5e, 0x8a, 0xac, 0x9f, 0xdc,
	0xc6, 0x47, 0x27, 0xd7, 0xfb, 0x01, 0xda, 0x6b, 0x44, 0xd4, 0x81, 0xfa, 0x39, 0xbd, 0xb2, 0xdf,
	0x63, 0xf1, 0x88, 0x9e, 0xc3, 0x66, 0x4e, 0xd2, 0x39, 0xb5, 0xb6, 0x1e, 0xdf, 0xd0, 0xce, 0xa5,
	0x54, 0xa7, 0x05, 0x14, 0x1b, 0xc6, 0x57, 0xee, 0x97, 0xce, 0xa1, 0x07, 0xcd, 0x02, 0x15, 0x9d,
	0x33, 0x9e, 0xf4, 0x7f, 0x86, 0x96, 0xe9, 0xd9, 0x0e, 0xc2, 0x0b, 0xd8, 0x52, 0x54, 0xcf, 0xd3,
	0xcc, 0xa6, 0x7f, 0x27, 0x71, 0x4b, 0xb9, 0xdf, 0xd9, 0xbb, 0xd0, 0x1a, 0x17, 0x8f, 0x23, 0x9a,
	0x11, 0x96, 0x6a, 0xf4, 0x0d, 0x34, 0x34, 0xcd, 0xa9, 0x62, 0x99, 0x31, 0xbb, 0x3d, 0x08, 0xaa,
	0xdf, 0xbd, 0xca, 0xf4, 0xa7, 0x96, 0x86, 0x97, 0x02, 0x68, 0x04, 0x0d, 0x29, 0x34, 0xcb, 0x16,
	0xd7, 0x94, 0x37, 0x38, 0xa8, 0x16, 0x33, 0x17, 0xdc, 0xc4, 0xe2, 0xf1, 0x92, 0x89, 0xb6, 0xc1,
	0x65, 0x49, 0xf9, 0x71, 0xd5, 0xb1, 0xcb, 0x92, 0xfe, 0x1b, 0x68, 0x2c, 0xde, 0x85, 0xba, 0xf0,
	0xc9, 0x34, 0x3c, 0x0d, 0xf1, 0xf8, 0xed, 0xf7, 0xd1, 0x77, 0xc7, 0xd3, 0x49, 0x38, 0x1c, 0x7f,
	0x3d, 0x0e, 0x47, 0x9d, 0x1a, 0x7a, 0x08, 0xde, 0x28, 0x9c, 0xe0, 0x70, 0xf8, 0xf2, 0xed, 0xf8,
	0xe4, 0xb8, 0xe3, 0x20, 0x0f, 0x1e, 0xbc, 0x7b, 0x89, 0x8f, 0xc7, 0xc7, 0xaf, 0x3a, 0x2e, 0x6a,
	0xc2, 0x66, 0x88, 0xf1, 0x09, 0xee, 0xd4, 0x07, 0x7f, 0xba, 0x80, 0x86, 0xd7, 0x6b, 0x64, 0x6a,
	0xb6, 0x08, 0x7a, 0x0f, 0x9b, 0xe5, 0x60, 0xa3, 0xfd, 0x5b, 0x26, 0xdf, 0x0e, 0x5a, 0xef, 0xc9,
	0xad, 0x38, 0x73, 0xb8, 0xfd, 0x5a, 0xa1, 0x5d, 0x8e, 0xfa, 0x4d, 0xda, 0xab, 0x17, 0xdd, 0x4d,
	0xda, 0x6b, 0x37, 0x48, 0xbf, 0x86, 0xde, 0xc1, 0x46, 0x31, 0x4a, 0x68, 0xef, 0x4e, 0x9f, 0x47,
	0x6f, 0xff, 0x36, 0xd8, 0x42, 0xf8, 0xf0, 0x77, 0x07, 0x76, 0x62, 0x71, 0x51, 0x89, 0x3f, 0x7c,
	0xf4, 0xef, 0x14, 0x27, 0xc5, 0x8e, 0x9b, 0x38, 0xef, 0x5f, 0x5b, 0xd2, 0x4c, 0xa4, 0x84, 0xcf,
	0x7c, 0xa1, 0x66, 0xc1, 0x8c, 0xf2, 0x72, 0x03, 0x06, 0xe6, 0x2f, 0x22, 0x99, 0xbe, 0x5e, 0xa2,
	0x2b, 0x6b, 0x7d, 0xb9, 0x50, 0x5f, 0x14, 0x45, 0x79, 0xf6, 0xb7, 0xe3, 0x9c, 0x6d, 0x95, 0xcc,
	0x67, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0xd3, 0x1d, 0x1f, 0x52, 0x18, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConformanceServiceClient is the client API for ConformanceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConformanceServiceClient interface {
	// Transforms CEL source text into a parsed representation.
	Parse(ctx context.Context, in *ParseRequest, opts ...grpc.CallOption) (*ParseResponse, error)
	// Runs static checks on a parsed CEL representation and return
	// an annotated representation, or a set of issues.
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
	// Evaluates a parsed or annotation CEL representation given
	// values of external bindings.
	Eval(ctx context.Context, in *EvalRequest, opts ...grpc.CallOption) (*EvalResponse, error)
}

type conformanceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConformanceServiceClient(cc grpc.ClientConnInterface) ConformanceServiceClient {
	return &conformanceServiceClient{cc}
}

func (c *conformanceServiceClient) Parse(ctx context.Context, in *ParseRequest, opts ...grpc.CallOption) (*ParseResponse, error) {
	out := new(ParseResponse)
	err := c.cc.Invoke(ctx, "/google.api.expr.v1alpha1.ConformanceService/Parse", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conformanceServiceClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := c.cc.Invoke(ctx, "/google.api.expr.v1alpha1.ConformanceService/Check", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conformanceServiceClient) Eval(ctx context.Context, in *EvalRequest, opts ...grpc.CallOption) (*EvalResponse, error) {
	out := new(EvalResponse)
	err := c.cc.Invoke(ctx, "/google.api.expr.v1alpha1.ConformanceService/Eval", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConformanceServiceServer is the server API for ConformanceService service.
type ConformanceServiceServer interface {
	// Transforms CEL source text into a parsed representation.
	Parse(context.Context, *ParseRequest) (*ParseResponse, error)
	// Runs static checks on a parsed CEL representation and return
	// an annotated representation, or a set of issues.
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	// Evaluates a parsed or annotation CEL representation given
	// values of external bindings.
	Eval(context.Context, *EvalRequest) (*EvalResponse, error)
}

// UnimplementedConformanceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConformanceServiceServer struct {
}

func (*UnimplementedConformanceServiceServer) Parse(ctx context.Context, req *ParseRequest) (*ParseResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Parse not implemented")
}
func (*UnimplementedConformanceServiceServer) Check(ctx context.Context, req *CheckRequest) (*CheckResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Check not implemented")
}
func (*UnimplementedConformanceServiceServer) Eval(ctx context.Context, req *EvalRequest) (*EvalResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Eval not implemented")
}

func RegisterConformanceServiceServer(s *grpc.Server, srv ConformanceServiceServer) {
	s.RegisterService(&_ConformanceService_serviceDesc, srv)
}

func _ConformanceService_Parse_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ParseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConformanceServiceServer).Parse(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.expr.v1alpha1.ConformanceService/Parse",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConformanceServiceServer).Parse(ctx, req.(*ParseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConformanceService_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConformanceServiceServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.expr.v1alpha1.ConformanceService/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConformanceServiceServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConformanceService_Eval_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConformanceServiceServer).Eval(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.expr.v1alpha1.ConformanceService/Eval",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConformanceServiceServer).Eval(ctx, req.(*EvalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConformanceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.expr.v1alpha1.ConformanceService",
	HandlerType: (*ConformanceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Parse",
			Handler:    _ConformanceService_Parse_Handler,
		},
		{
			MethodName: "Check",
			Handler:    _ConformanceService_Check_Handler,
		},
		{
			MethodName: "Eval",
			Handler:    _ConformanceService_Eval_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/expr/v1alpha1/conformance_service.proto",
}
