// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/api/config_change.proto

package configchange

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Classifies set of possible modifications to an object in the service
// configuration.
type ChangeType int32

const (
	// No value was provided.
	ChangeType_CHANGE_TYPE_UNSPECIFIED ChangeType = 0
	// The changed object exists in the 'new' service configuration, but not
	// in the 'old' service configuration.
	ChangeType_ADDED ChangeType = 1
	// The changed object exists in the 'old' service configuration, but not
	// in the 'new' service configuration.
	ChangeType_REMOVED ChangeType = 2
	// The changed object exists in both service configurations, but its value
	// is different.
	ChangeType_MODIFIED ChangeType = 3
)

// Enum value maps for ChangeType.
var (
	ChangeType_name = map[int32]string{
		0: "CHANGE_TYPE_UNSPECIFIED",
		1: "ADDED",
		2: "REMOVED",
		3: "MODIFIED",
	}
	ChangeType_value = map[string]int32{
		"CHANGE_TYPE_UNSPECIFIED": 0,
		"ADDED":                   1,
		"REMOVED":                 2,
		"MODIFIED":                3,
	}
)

func (x ChangeType) Enum() *ChangeType {
	p := new(ChangeType)
	*p = x
	return p
}

func (x ChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_config_change_proto_enumTypes[0].Descriptor()
}

func (ChangeType) Type() protoreflect.EnumType {
	return &file_google_api_config_change_proto_enumTypes[0]
}

func (x ChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeType.Descriptor instead.
func (ChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_api_config_change_proto_rawDescGZIP(), []int{0}
}

// Output generated from semantically comparing two versions of a service
// configuration.
//
// Includes detailed information about a field that have changed with
// applicable advice about potential consequences for the change, such as
// backwards-incompatibility.
type ConfigChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Object hierarchy path to the change, with levels separated by a '.'
	// character. For repeated fields, an applicable unique identifier field is
	// used for the index (usually selector, name, or id). For maps, the term
	// 'key' is used. If the field has no unique identifier, the numeric index
	// is used.
	// Examples:
	// - visibility.rules[selector=="google.LibraryService.ListBooks"].restriction
	// - quota.metric_rules[selector=="google"].metric_costs[key=="reads"].value
	// - logging.producer_destinations[0]
	Element string `protobuf:"bytes,1,opt,name=element,proto3" json:"element,omitempty"`
	// Value of the changed object in the old Service configuration,
	// in JSON format. This field will not be populated if ChangeType == ADDED.
	OldValue string `protobuf:"bytes,2,opt,name=old_value,json=oldValue,proto3" json:"old_value,omitempty"`
	// Value of the changed object in the new Service configuration,
	// in JSON format. This field will not be populated if ChangeType == REMOVED.
	NewValue string `protobuf:"bytes,3,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
	// The type for this change, either ADDED, REMOVED, or MODIFIED.
	ChangeType ChangeType `protobuf:"varint,4,opt,name=change_type,json=changeType,proto3,enum=google.api.ChangeType" json:"change_type,omitempty"`
	// Collection of advice provided for this change, useful for determining the
	// possible impact of this change.
	Advices []*Advice `protobuf:"bytes,5,rep,name=advices,proto3" json:"advices,omitempty"`
}

func (x *ConfigChange) Reset() {
	*x = ConfigChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_config_change_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigChange) ProtoMessage() {}

func (x *ConfigChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_config_change_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigChange.ProtoReflect.Descriptor instead.
func (*ConfigChange) Descriptor() ([]byte, []int) {
	return file_google_api_config_change_proto_rawDescGZIP(), []int{0}
}

func (x *ConfigChange) GetElement() string {
	if x != nil {
		return x.Element
	}
	return ""
}

func (x *ConfigChange) GetOldValue() string {
	if x != nil {
		return x.OldValue
	}
	return ""
}

func (x *ConfigChange) GetNewValue() string {
	if x != nil {
		return x.NewValue
	}
	return ""
}

func (x *ConfigChange) GetChangeType() ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return ChangeType_CHANGE_TYPE_UNSPECIFIED
}

func (x *ConfigChange) GetAdvices() []*Advice {
	if x != nil {
		return x.Advices
	}
	return nil
}

// Generated advice about this change, used for providing more
// information about how a change will affect the existing service.
type Advice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Useful description for why this advice was applied and what actions should
	// be taken to mitigate any implied risks.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Advice) Reset() {
	*x = Advice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_config_change_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Advice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Advice) ProtoMessage() {}

func (x *Advice) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_config_change_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Advice.ProtoReflect.Descriptor instead.
func (*Advice) Descriptor() ([]byte, []int) {
	return file_google_api_config_change_proto_rawDescGZIP(), []int{1}
}

func (x *Advice) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

var File_google_api_config_change_proto protoreflect.FileDescriptor

var file_google_api_config_change_proto_rawDesc = []byte{
	0x0a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x0a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x22, 0xc9, 0x01, 0x0a,
	0x0c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6f, 0x6c, 0x64, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6f, 0x6c, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x37, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x61, 0x64,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x41, 0x64, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x07, 0x61, 0x64, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x2a, 0x0a, 0x06, 0x41, 0x64, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2a, 0x4f, 0x0a, 0x0a, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45,
	0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x4f, 0x44, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x03, 0x42, 0x71, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x42, 0x11, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x3b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0xa2, 0x02, 0x04, 0x47, 0x41, 0x50, 0x49, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_config_change_proto_rawDescOnce sync.Once
	file_google_api_config_change_proto_rawDescData = file_google_api_config_change_proto_rawDesc
)

func file_google_api_config_change_proto_rawDescGZIP() []byte {
	file_google_api_config_change_proto_rawDescOnce.Do(func() {
		file_google_api_config_change_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_config_change_proto_rawDescData)
	})
	return file_google_api_config_change_proto_rawDescData
}

var file_google_api_config_change_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_api_config_change_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_api_config_change_proto_goTypes = []interface{}{
	(ChangeType)(0),      // 0: google.api.ChangeType
	(*ConfigChange)(nil), // 1: google.api.ConfigChange
	(*Advice)(nil),       // 2: google.api.Advice
}
var file_google_api_config_change_proto_depIdxs = []int32{
	0, // 0: google.api.ConfigChange.change_type:type_name -> google.api.ChangeType
	2, // 1: google.api.ConfigChange.advices:type_name -> google.api.Advice
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_api_config_change_proto_init() }
func file_google_api_config_change_proto_init() {
	if File_google_api_config_change_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_api_config_change_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_config_change_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Advice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_config_change_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_api_config_change_proto_goTypes,
		DependencyIndexes: file_google_api_config_change_proto_depIdxs,
		EnumInfos:         file_google_api_config_change_proto_enumTypes,
		MessageInfos:      file_google_api_config_change_proto_msgTypes,
	}.Build()
	File_google_api_config_change_proto = out.File
	file_google_api_config_change_proto_rawDesc = nil
	file_google_api_config_change_proto_goTypes = nil
	file_google_api_config_change_proto_depIdxs = nil
}
