// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/pubsublite/v1/common.proto

package pubsublite

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// When this subscription should send messages to subscribers relative to
// messages persistence in storage. For details, see [Creating Lite
// subscriptions](https://cloud.google.com/pubsub/lite/docs/subscriptions#creating_lite_subscriptions).
type Subscription_DeliveryConfig_DeliveryRequirement int32

const (
	// Default value. This value is unused.
	Subscription_DeliveryConfig_DELIVERY_REQUIREMENT_UNSPECIFIED Subscription_DeliveryConfig_DeliveryRequirement = 0
	// The server does not wait for a published message to be successfully
	// written to storage before delivering it to subscribers.
	Subscription_DeliveryConfig_DELIVER_IMMEDIATELY Subscription_DeliveryConfig_DeliveryRequirement = 1
	// The server will not deliver a published message to subscribers until
	// the message has been successfully written to storage. This will result
	// in higher end-to-end latency, but consistent delivery.
	Subscription_DeliveryConfig_DELIVER_AFTER_STORED Subscription_DeliveryConfig_DeliveryRequirement = 2
)

// Enum value maps for Subscription_DeliveryConfig_DeliveryRequirement.
var (
	Subscription_DeliveryConfig_DeliveryRequirement_name = map[int32]string{
		0: "DELIVERY_REQUIREMENT_UNSPECIFIED",
		1: "DELIVER_IMMEDIATELY",
		2: "DELIVER_AFTER_STORED",
	}
	Subscription_DeliveryConfig_DeliveryRequirement_value = map[string]int32{
		"DELIVERY_REQUIREMENT_UNSPECIFIED": 0,
		"DELIVER_IMMEDIATELY":              1,
		"DELIVER_AFTER_STORED":             2,
	}
)

func (x Subscription_DeliveryConfig_DeliveryRequirement) Enum() *Subscription_DeliveryConfig_DeliveryRequirement {
	p := new(Subscription_DeliveryConfig_DeliveryRequirement)
	*p = x
	return p
}

func (x Subscription_DeliveryConfig_DeliveryRequirement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subscription_DeliveryConfig_DeliveryRequirement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_pubsublite_v1_common_proto_enumTypes[0].Descriptor()
}

func (Subscription_DeliveryConfig_DeliveryRequirement) Type() protoreflect.EnumType {
	return &file_google_cloud_pubsublite_v1_common_proto_enumTypes[0]
}

func (x Subscription_DeliveryConfig_DeliveryRequirement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subscription_DeliveryConfig_DeliveryRequirement.Descriptor instead.
func (Subscription_DeliveryConfig_DeliveryRequirement) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5, 0, 0}
}

// The values associated with a key of an attribute.
type AttributeValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of values associated with a key.
	Values [][]byte `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *AttributeValues) Reset() {
	*x = AttributeValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValues) ProtoMessage() {}

func (x *AttributeValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValues.ProtoReflect.Descriptor instead.
func (*AttributeValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *AttributeValues) GetValues() [][]byte {
	if x != nil {
		return x.Values
	}
	return nil
}

// A message that is published by publishers and delivered to subscribers.
type PubSubMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key used for routing messages to partitions or for compaction (e.g.,
	// keep the last N messages per key). If the key is empty, the message is
	// routed to an arbitrary partition.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The payload of the message.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes that can be used for message metadata/headers.
	Attributes map[string]*AttributeValues `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An optional, user-specified event time.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
}

func (x *PubSubMessage) Reset() {
	*x = PubSubMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubSubMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubSubMessage) ProtoMessage() {}

func (x *PubSubMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubSubMessage.ProtoReflect.Descriptor instead.
func (*PubSubMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{1}
}

func (x *PubSubMessage) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PubSubMessage) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *PubSubMessage) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *PubSubMessage) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

// A cursor that describes the position of a message within a topic partition.
type Cursor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The offset of a message within a topic partition. Must be greater than or
	// equal 0.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *Cursor) Reset() {
	*x = Cursor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cursor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cursor) ProtoMessage() {}

func (x *Cursor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cursor.ProtoReflect.Descriptor instead.
func (*Cursor) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *Cursor) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// A message that has been stored and sequenced by the Pub/Sub Lite system.
type SequencedMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The position of a message within the partition where it is stored.
	Cursor *Cursor `protobuf:"bytes,1,opt,name=cursor,proto3" json:"cursor,omitempty"`
	// The time when the message was received by the server when it was first
	// published.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// The user message.
	Message *PubSubMessage `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// The size in bytes of this message for flow control and quota purposes.
	SizeBytes int64 `protobuf:"varint,4,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
}

func (x *SequencedMessage) Reset() {
	*x = SequencedMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SequencedMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SequencedMessage) ProtoMessage() {}

func (x *SequencedMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SequencedMessage.ProtoReflect.Descriptor instead.
func (*SequencedMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{3}
}

func (x *SequencedMessage) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

func (x *SequencedMessage) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *SequencedMessage) GetMessage() *PubSubMessage {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *SequencedMessage) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

// Metadata about a topic resource.
type Topic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the topic.
	// Structured like:
	// projects/{project_number}/locations/{location}/topics/{topic_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The settings for this topic's partitions.
	PartitionConfig *Topic_PartitionConfig `protobuf:"bytes,2,opt,name=partition_config,json=partitionConfig,proto3" json:"partition_config,omitempty"`
	// The settings for this topic's message retention.
	RetentionConfig *Topic_RetentionConfig `protobuf:"bytes,3,opt,name=retention_config,json=retentionConfig,proto3" json:"retention_config,omitempty"`
}

func (x *Topic) Reset() {
	*x = Topic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic) ProtoMessage() {}

func (x *Topic) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic.ProtoReflect.Descriptor instead.
func (*Topic) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{4}
}

func (x *Topic) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Topic) GetPartitionConfig() *Topic_PartitionConfig {
	if x != nil {
		return x.PartitionConfig
	}
	return nil
}

func (x *Topic) GetRetentionConfig() *Topic_RetentionConfig {
	if x != nil {
		return x.RetentionConfig
	}
	return nil
}

// Metadata about a subscription resource.
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the subscription.
	// Structured like:
	// projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the topic this subscription is attached to.
	// Structured like:
	// projects/{project_number}/locations/{location}/topics/{topic_id}
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// The settings for this subscription's message delivery.
	DeliveryConfig *Subscription_DeliveryConfig `protobuf:"bytes,3,opt,name=delivery_config,json=deliveryConfig,proto3" json:"delivery_config,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5}
}

func (x *Subscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subscription) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *Subscription) GetDeliveryConfig() *Subscription_DeliveryConfig {
	if x != nil {
		return x.DeliveryConfig
	}
	return nil
}

// The settings for a topic's partitions.
type Topic_PartitionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of partitions in the topic. Must be at least 1.
	//
	// Once a topic has been created the number of partitions can be increased
	// but not decreased. Message ordering is not guaranteed across a topic
	// resize. For more information see
	// https://cloud.google.com/pubsub/lite/docs/topics#scaling_capacity
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// The throughput dimension of this topic.
	//
	// Types that are assignable to Dimension:
	//	*Topic_PartitionConfig_Scale
	//	*Topic_PartitionConfig_Capacity_
	Dimension isTopic_PartitionConfig_Dimension `protobuf_oneof:"dimension"`
}

func (x *Topic_PartitionConfig) Reset() {
	*x = Topic_PartitionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic_PartitionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic_PartitionConfig) ProtoMessage() {}

func (x *Topic_PartitionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic_PartitionConfig.ProtoReflect.Descriptor instead.
func (*Topic_PartitionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Topic_PartitionConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (m *Topic_PartitionConfig) GetDimension() isTopic_PartitionConfig_Dimension {
	if m != nil {
		return m.Dimension
	}
	return nil
}

// Deprecated: Do not use.
func (x *Topic_PartitionConfig) GetScale() int32 {
	if x, ok := x.GetDimension().(*Topic_PartitionConfig_Scale); ok {
		return x.Scale
	}
	return 0
}

func (x *Topic_PartitionConfig) GetCapacity() *Topic_PartitionConfig_Capacity {
	if x, ok := x.GetDimension().(*Topic_PartitionConfig_Capacity_); ok {
		return x.Capacity
	}
	return nil
}

type isTopic_PartitionConfig_Dimension interface {
	isTopic_PartitionConfig_Dimension()
}

type Topic_PartitionConfig_Scale struct {
	// DEPRECATED: Use capacity instead which can express a superset of
	// configurations.
	//
	// Every partition in the topic is allocated throughput equivalent to
	// `scale` times the standard partition throughput (4 MiB/s). This is also
	// reflected in the cost of this topic; a topic with `scale` of 2 and
	// count of 10 is charged for 20 partitions. This value must be in the
	// range [1,4].
	//
	// Deprecated: Do not use.
	Scale int32 `protobuf:"varint,2,opt,name=scale,proto3,oneof"`
}

type Topic_PartitionConfig_Capacity_ struct {
	// The capacity configuration.
	Capacity *Topic_PartitionConfig_Capacity `protobuf:"bytes,3,opt,name=capacity,proto3,oneof"`
}

func (*Topic_PartitionConfig_Scale) isTopic_PartitionConfig_Dimension() {}

func (*Topic_PartitionConfig_Capacity_) isTopic_PartitionConfig_Dimension() {}

// The settings for a topic's message retention.
type Topic_RetentionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The provisioned storage, in bytes, per partition. If the number of bytes
	// stored in any of the topic's partitions grows beyond this value, older
	// messages will be dropped to make room for newer ones, regardless of the
	// value of `period`.
	PerPartitionBytes int64 `protobuf:"varint,1,opt,name=per_partition_bytes,json=perPartitionBytes,proto3" json:"per_partition_bytes,omitempty"`
	// How long a published message is retained. If unset, messages will be
	// retained as long as the bytes retained for each partition is below
	// `per_partition_bytes`.
	Period *durationpb.Duration `protobuf:"bytes,2,opt,name=period,proto3" json:"period,omitempty"`
}

func (x *Topic_RetentionConfig) Reset() {
	*x = Topic_RetentionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic_RetentionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic_RetentionConfig) ProtoMessage() {}

func (x *Topic_RetentionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic_RetentionConfig.ProtoReflect.Descriptor instead.
func (*Topic_RetentionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Topic_RetentionConfig) GetPerPartitionBytes() int64 {
	if x != nil {
		return x.PerPartitionBytes
	}
	return 0
}

func (x *Topic_RetentionConfig) GetPeriod() *durationpb.Duration {
	if x != nil {
		return x.Period
	}
	return nil
}

// The throughput capacity configuration for each partition.
type Topic_PartitionConfig_Capacity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Publish throughput capacity per partition in MiB/s.
	// Must be >= 4 and <= 16.
	PublishMibPerSec int32 `protobuf:"varint,1,opt,name=publish_mib_per_sec,json=publishMibPerSec,proto3" json:"publish_mib_per_sec,omitempty"`
	// Subscribe throughput capacity per partition in MiB/s.
	// Must be >= 4 and <= 32.
	SubscribeMibPerSec int32 `protobuf:"varint,2,opt,name=subscribe_mib_per_sec,json=subscribeMibPerSec,proto3" json:"subscribe_mib_per_sec,omitempty"`
}

func (x *Topic_PartitionConfig_Capacity) Reset() {
	*x = Topic_PartitionConfig_Capacity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic_PartitionConfig_Capacity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic_PartitionConfig_Capacity) ProtoMessage() {}

func (x *Topic_PartitionConfig_Capacity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic_PartitionConfig_Capacity.ProtoReflect.Descriptor instead.
func (*Topic_PartitionConfig_Capacity) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *Topic_PartitionConfig_Capacity) GetPublishMibPerSec() int32 {
	if x != nil {
		return x.PublishMibPerSec
	}
	return 0
}

func (x *Topic_PartitionConfig_Capacity) GetSubscribeMibPerSec() int32 {
	if x != nil {
		return x.SubscribeMibPerSec
	}
	return 0
}

// The settings for a subscription's message delivery.
type Subscription_DeliveryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DeliveryRequirement for this subscription.
	DeliveryRequirement Subscription_DeliveryConfig_DeliveryRequirement `protobuf:"varint,3,opt,name=delivery_requirement,json=deliveryRequirement,proto3,enum=google.cloud.pubsublite.v1.Subscription_DeliveryConfig_DeliveryRequirement" json:"delivery_requirement,omitempty"`
}

func (x *Subscription_DeliveryConfig) Reset() {
	*x = Subscription_DeliveryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription_DeliveryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription_DeliveryConfig) ProtoMessage() {}

func (x *Subscription_DeliveryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription_DeliveryConfig.ProtoReflect.Descriptor instead.
func (*Subscription_DeliveryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Subscription_DeliveryConfig) GetDeliveryRequirement() Subscription_DeliveryConfig_DeliveryRequirement {
	if x != nil {
		return x.DeliveryRequirement
	}
	return Subscription_DeliveryConfig_DELIVERY_REQUIREMENT_UNSPECIFIED
}

var File_google_cloud_pubsublite_v1_common_proto protoreflect.FileDescriptor

var file_google_cloud_pubsublite_v1_common_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x29, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0c, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xb7, 0x02, 0x0a,
	0x0d, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x6a, 0x0a, 0x0f, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x20, 0x0a, 0x06, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72,
	0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0xf1, 0x01, 0x0a, 0x10, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a,
	0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c,
	0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0xc6, 0x05, 0x0a,
	0x05, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x2e, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x98, 0x02, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x1a, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x58, 0x0a, 0x08,
	0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x08, 0x63, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x1a, 0x6c, 0x0a, 0x08, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x12, 0x2d, 0x0a, 0x13, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x6d, 0x69,
	0x62, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x4d, 0x69, 0x62, 0x50, 0x65, 0x72, 0x53, 0x65,
	0x63, 0x12, 0x31, 0x0a, 0x15, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x5f, 0x6d,
	0x69, 0x62, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x69, 0x62, 0x50, 0x65,
	0x72, 0x53, 0x65, 0x63, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x1a, 0x74, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x11, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x36, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x7d, 0x22, 0xb6, 0x04, 0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x60, 0x0a, 0x0f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x80, 0x02, 0x0a, 0x0e, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7e, 0x0a, 0x14, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c,
	0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6e, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x24, 0x0a, 0x20, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x45, 0x4c, 0x49,
	0x56, 0x45, 0x52, 0x5f, 0x49, 0x4d, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x4c, 0x59, 0x10,
	0x01, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x46, 0x54,
	0x45, 0x52, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x71, 0xea, 0x41, 0x6e,
	0x0a, 0x26, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0xd5,
	0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x75, 0x62, 0x53,
	0x75, 0x62, 0x4c, 0x69, 0x74, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4c,
	0x69, 0x74, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4c, 0x69,
	0x74, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_pubsublite_v1_common_proto_rawDescOnce sync.Once
	file_google_cloud_pubsublite_v1_common_proto_rawDescData = file_google_cloud_pubsublite_v1_common_proto_rawDesc
)

func file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP() []byte {
	file_google_cloud_pubsublite_v1_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_pubsublite_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_pubsublite_v1_common_proto_rawDescData)
	})
	return file_google_cloud_pubsublite_v1_common_proto_rawDescData
}

var file_google_cloud_pubsublite_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_pubsublite_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_pubsublite_v1_common_proto_goTypes = []interface{}{
	(Subscription_DeliveryConfig_DeliveryRequirement)(0), // 0: google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement
	(*AttributeValues)(nil),                              // 1: google.cloud.pubsublite.v1.AttributeValues
	(*PubSubMessage)(nil),                                // 2: google.cloud.pubsublite.v1.PubSubMessage
	(*Cursor)(nil),                                       // 3: google.cloud.pubsublite.v1.Cursor
	(*SequencedMessage)(nil),                             // 4: google.cloud.pubsublite.v1.SequencedMessage
	(*Topic)(nil),                                        // 5: google.cloud.pubsublite.v1.Topic
	(*Subscription)(nil),                                 // 6: google.cloud.pubsublite.v1.Subscription
	nil,                                                  // 7: google.cloud.pubsublite.v1.PubSubMessage.AttributesEntry
	(*Topic_PartitionConfig)(nil),                        // 8: google.cloud.pubsublite.v1.Topic.PartitionConfig
	(*Topic_RetentionConfig)(nil),                        // 9: google.cloud.pubsublite.v1.Topic.RetentionConfig
	(*Topic_PartitionConfig_Capacity)(nil),               // 10: google.cloud.pubsublite.v1.Topic.PartitionConfig.Capacity
	(*Subscription_DeliveryConfig)(nil),                  // 11: google.cloud.pubsublite.v1.Subscription.DeliveryConfig
	(*timestamppb.Timestamp)(nil),                        // 12: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                          // 13: google.protobuf.Duration
}
var file_google_cloud_pubsublite_v1_common_proto_depIdxs = []int32{
	7,  // 0: google.cloud.pubsublite.v1.PubSubMessage.attributes:type_name -> google.cloud.pubsublite.v1.PubSubMessage.AttributesEntry
	12, // 1: google.cloud.pubsublite.v1.PubSubMessage.event_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.pubsublite.v1.SequencedMessage.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	12, // 3: google.cloud.pubsublite.v1.SequencedMessage.publish_time:type_name -> google.protobuf.Timestamp
	2,  // 4: google.cloud.pubsublite.v1.SequencedMessage.message:type_name -> google.cloud.pubsublite.v1.PubSubMessage
	8,  // 5: google.cloud.pubsublite.v1.Topic.partition_config:type_name -> google.cloud.pubsublite.v1.Topic.PartitionConfig
	9,  // 6: google.cloud.pubsublite.v1.Topic.retention_config:type_name -> google.cloud.pubsublite.v1.Topic.RetentionConfig
	11, // 7: google.cloud.pubsublite.v1.Subscription.delivery_config:type_name -> google.cloud.pubsublite.v1.Subscription.DeliveryConfig
	1,  // 8: google.cloud.pubsublite.v1.PubSubMessage.AttributesEntry.value:type_name -> google.cloud.pubsublite.v1.AttributeValues
	10, // 9: google.cloud.pubsublite.v1.Topic.PartitionConfig.capacity:type_name -> google.cloud.pubsublite.v1.Topic.PartitionConfig.Capacity
	13, // 10: google.cloud.pubsublite.v1.Topic.RetentionConfig.period:type_name -> google.protobuf.Duration
	0,  // 11: google.cloud.pubsublite.v1.Subscription.DeliveryConfig.delivery_requirement:type_name -> google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_pubsublite_v1_common_proto_init() }
func file_google_cloud_pubsublite_v1_common_proto_init() {
	if File_google_cloud_pubsublite_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubSubMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cursor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SequencedMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic_PartitionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic_RetentionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic_PartitionConfig_Capacity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription_DeliveryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_pubsublite_v1_common_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Topic_PartitionConfig_Scale)(nil),
		(*Topic_PartitionConfig_Capacity_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_pubsublite_v1_common_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_pubsublite_v1_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_pubsublite_v1_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_pubsublite_v1_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_pubsublite_v1_common_proto_msgTypes,
	}.Build()
	File_google_cloud_pubsublite_v1_common_proto = out.File
	file_google_cloud_pubsublite_v1_common_proto_rawDesc = nil
	file_google_cloud_pubsublite_v1_common_proto_goTypes = nil
	file_google_cloud_pubsublite_v1_common_proto_depIdxs = nil
}
