// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1beta4/cloud_sql_connect.proto

package sql

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Connect settings retrieval request.
type GetConnectSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Optional. Optional snapshot read timestamp to trade freshness for performance.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
}

func (x *GetConnectSettingsRequest) Reset() {
	*x = GetConnectSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectSettingsRequest) ProtoMessage() {}

func (x *GetConnectSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetConnectSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescGZIP(), []int{0}
}

func (x *GetConnectSettingsRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *GetConnectSettingsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *GetConnectSettingsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

// Connect settings retrieval response.
type ConnectSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#connectSettings`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// SSL configuration.
	ServerCaCert *SslCert `protobuf:"bytes,2,opt,name=server_ca_cert,json=serverCaCert,proto3" json:"server_ca_cert,omitempty"`
	// The assigned IP addresses for the instance.
	IpAddresses []*IpMapping `protobuf:"bytes,3,rep,name=ip_addresses,json=ipAddresses,proto3" json:"ip_addresses,omitempty"`
	// The cloud region for the instance. e.g. `us-central1`, `europe-west1`.
	// The region cannot be changed after instance creation.
	Region string `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	// The database engine type and version. The `databaseVersion`
	// field cannot be changed after instance creation.
	//   MySQL instances: `MYSQL_8_0`, `MYSQL_5_7` (default),
	// or `MYSQL_5_6`.
	//   PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`,
	// `POSTGRES_11` or `POSTGRES_12` (default), `POSTGRES_13`, or `POSTGRES_14`.
	//   SQL Server instances: `SQLSERVER_2017_STANDARD` (default),
	// `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`,
	// `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`,
	// `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or
	// `SQLSERVER_2019_WEB`.
	DatabaseVersion SqlDatabaseVersion `protobuf:"varint,31,opt,name=database_version,json=databaseVersion,proto3,enum=google.cloud.sql.v1beta4.SqlDatabaseVersion" json:"database_version,omitempty"`
	// `SECOND_GEN`: Cloud SQL database instance.
	// `EXTERNAL`: A database server that is not managed by Google.
	// This property is read-only; use the `tier` property in the `settings`
	// object to determine the database type.
	BackendType SqlBackendType `protobuf:"varint,32,opt,name=backend_type,json=backendType,proto3,enum=google.cloud.sql.v1beta4.SqlBackendType" json:"backend_type,omitempty"`
}

func (x *ConnectSettings) Reset() {
	*x = ConnectSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectSettings) ProtoMessage() {}

func (x *ConnectSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectSettings.ProtoReflect.Descriptor instead.
func (*ConnectSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescGZIP(), []int{1}
}

func (x *ConnectSettings) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ConnectSettings) GetServerCaCert() *SslCert {
	if x != nil {
		return x.ServerCaCert
	}
	return nil
}

func (x *ConnectSettings) GetIpAddresses() []*IpMapping {
	if x != nil {
		return x.IpAddresses
	}
	return nil
}

func (x *ConnectSettings) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *ConnectSettings) GetDatabaseVersion() SqlDatabaseVersion {
	if x != nil {
		return x.DatabaseVersion
	}
	return SqlDatabaseVersion_SQL_DATABASE_VERSION_UNSPECIFIED
}

func (x *ConnectSettings) GetBackendType() SqlBackendType {
	if x != nil {
		return x.BackendType
	}
	return SqlBackendType_SQL_BACKEND_TYPE_UNSPECIFIED
}

// Ephemeral certificate creation request.
type GenerateEphemeralCertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// PEM encoded public key to include in the signed certificate.
	PublicKey string `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Optional. Access token to include in the signed certificate.
	AccessToken string `protobuf:"bytes,4,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Optional. Optional snapshot read timestamp to trade freshness for performance.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Optional. If set, it will contain the cert valid duration.
	ValidDuration *durationpb.Duration `protobuf:"bytes,12,opt,name=valid_duration,json=validDuration,proto3" json:"valid_duration,omitempty"`
}

func (x *GenerateEphemeralCertRequest) Reset() {
	*x = GenerateEphemeralCertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateEphemeralCertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateEphemeralCertRequest) ProtoMessage() {}

func (x *GenerateEphemeralCertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateEphemeralCertRequest.ProtoReflect.Descriptor instead.
func (*GenerateEphemeralCertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescGZIP(), []int{2}
}

func (x *GenerateEphemeralCertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *GenerateEphemeralCertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *GenerateEphemeralCertRequest) GetPublicKey() string {
	if x != nil {
		return x.PublicKey
	}
	return ""
}

func (x *GenerateEphemeralCertRequest) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateEphemeralCertRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GenerateEphemeralCertRequest) GetValidDuration() *durationpb.Duration {
	if x != nil {
		return x.ValidDuration
	}
	return nil
}

// Ephemeral certificate creation request.
type GenerateEphemeralCertResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generated cert
	EphemeralCert *SslCert `protobuf:"bytes,1,opt,name=ephemeral_cert,json=ephemeralCert,proto3" json:"ephemeral_cert,omitempty"`
}

func (x *GenerateEphemeralCertResponse) Reset() {
	*x = GenerateEphemeralCertResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateEphemeralCertResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateEphemeralCertResponse) ProtoMessage() {}

func (x *GenerateEphemeralCertResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateEphemeralCertResponse.ProtoReflect.Descriptor instead.
func (*GenerateEphemeralCertResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescGZIP(), []int{3}
}

func (x *GenerateEphemeralCertResponse) GetEphemeralCert() *SslCert {
	if x != nil {
		return x.EphemeralCert
	}
	return nil
}

var File_google_cloud_sql_v1beta4_cloud_sql_connect_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8f, 0x01, 0x0a, 0x19, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3c, 0x0a,
	0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xf4, 0x02, 0x0a, 0x0f,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x12, 0x47, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x0c,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x12, 0x46, 0x0a, 0x0c,
	0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x70,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x10,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79,
	0x70, 0x65, 0x22, 0xa0, 0x02, 0x0a, 0x1c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x45,
	0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x3c, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45,
	0x0a, 0x0e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0x0a, 0x1d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0e, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65,
	0x72, 0x61, 0x6c, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72,
	0x74, 0x52, 0x0d, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74,
	0x32, 0xb8, 0x04, 0x0a, 0x11, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc2, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x4c, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xdf, 0x01, 0x0a, 0x15,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61,
	0x6c, 0x43, 0x65, 0x72, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72,
	0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x22, 0x4a,
	0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68,
	0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x1a, 0x7c, 0xca,
	0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x42, 0x73, 0x0a, 0x1c, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x42, 0x14, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x3b, 0x73, 0x71, 0x6c,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescData = file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDesc
)

func file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescData)
	})
	return file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDescData
}

var file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_goTypes = []interface{}{
	(*GetConnectSettingsRequest)(nil),     // 0: google.cloud.sql.v1beta4.GetConnectSettingsRequest
	(*ConnectSettings)(nil),               // 1: google.cloud.sql.v1beta4.ConnectSettings
	(*GenerateEphemeralCertRequest)(nil),  // 2: google.cloud.sql.v1beta4.GenerateEphemeralCertRequest
	(*GenerateEphemeralCertResponse)(nil), // 3: google.cloud.sql.v1beta4.GenerateEphemeralCertResponse
	(*timestamppb.Timestamp)(nil),         // 4: google.protobuf.Timestamp
	(*SslCert)(nil),                       // 5: google.cloud.sql.v1beta4.SslCert
	(*IpMapping)(nil),                     // 6: google.cloud.sql.v1beta4.IpMapping
	(SqlDatabaseVersion)(0),               // 7: google.cloud.sql.v1beta4.SqlDatabaseVersion
	(SqlBackendType)(0),                   // 8: google.cloud.sql.v1beta4.SqlBackendType
	(*durationpb.Duration)(nil),           // 9: google.protobuf.Duration
}
var file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_depIdxs = []int32{
	4,  // 0: google.cloud.sql.v1beta4.GetConnectSettingsRequest.read_time:type_name -> google.protobuf.Timestamp
	5,  // 1: google.cloud.sql.v1beta4.ConnectSettings.server_ca_cert:type_name -> google.cloud.sql.v1beta4.SslCert
	6,  // 2: google.cloud.sql.v1beta4.ConnectSettings.ip_addresses:type_name -> google.cloud.sql.v1beta4.IpMapping
	7,  // 3: google.cloud.sql.v1beta4.ConnectSettings.database_version:type_name -> google.cloud.sql.v1beta4.SqlDatabaseVersion
	8,  // 4: google.cloud.sql.v1beta4.ConnectSettings.backend_type:type_name -> google.cloud.sql.v1beta4.SqlBackendType
	4,  // 5: google.cloud.sql.v1beta4.GenerateEphemeralCertRequest.read_time:type_name -> google.protobuf.Timestamp
	9,  // 6: google.cloud.sql.v1beta4.GenerateEphemeralCertRequest.valid_duration:type_name -> google.protobuf.Duration
	5,  // 7: google.cloud.sql.v1beta4.GenerateEphemeralCertResponse.ephemeral_cert:type_name -> google.cloud.sql.v1beta4.SslCert
	0,  // 8: google.cloud.sql.v1beta4.SqlConnectService.GetConnectSettings:input_type -> google.cloud.sql.v1beta4.GetConnectSettingsRequest
	2,  // 9: google.cloud.sql.v1beta4.SqlConnectService.GenerateEphemeralCert:input_type -> google.cloud.sql.v1beta4.GenerateEphemeralCertRequest
	1,  // 10: google.cloud.sql.v1beta4.SqlConnectService.GetConnectSettings:output_type -> google.cloud.sql.v1beta4.ConnectSettings
	3,  // 11: google.cloud.sql.v1beta4.SqlConnectService.GenerateEphemeralCert:output_type -> google.cloud.sql.v1beta4.GenerateEphemeralCertResponse
	10, // [10:12] is the sub-list for method output_type
	8,  // [8:10] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_init() }
func file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_init() {
	if File_google_cloud_sql_v1beta4_cloud_sql_connect_proto != nil {
		return
	}
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateEphemeralCertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateEphemeralCertResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_depIdxs,
		MessageInfos:      file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1beta4_cloud_sql_connect_proto = out.File
	file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_rawDesc = nil
	file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_goTypes = nil
	file_google_cloud_sql_v1beta4_cloud_sql_connect_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SqlConnectServiceClient is the client API for SqlConnectService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlConnectServiceClient interface {
	// Retrieves connect settings about a Cloud SQL instance.
	GetConnectSettings(ctx context.Context, in *GetConnectSettingsRequest, opts ...grpc.CallOption) (*ConnectSettings, error)
	// Generates a short-lived X509 certificate containing the provided public key
	// and signed by a private key specific to the target instance. Users may use
	// the certificate to authenticate as themselves when connecting to the
	// database.
	GenerateEphemeralCert(ctx context.Context, in *GenerateEphemeralCertRequest, opts ...grpc.CallOption) (*GenerateEphemeralCertResponse, error)
}

type sqlConnectServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlConnectServiceClient(cc grpc.ClientConnInterface) SqlConnectServiceClient {
	return &sqlConnectServiceClient{cc}
}

func (c *sqlConnectServiceClient) GetConnectSettings(ctx context.Context, in *GetConnectSettingsRequest, opts ...grpc.CallOption) (*ConnectSettings, error) {
	out := new(ConnectSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlConnectService/GetConnectSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlConnectServiceClient) GenerateEphemeralCert(ctx context.Context, in *GenerateEphemeralCertRequest, opts ...grpc.CallOption) (*GenerateEphemeralCertResponse, error) {
	out := new(GenerateEphemeralCertResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlConnectService/GenerateEphemeralCert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlConnectServiceServer is the server API for SqlConnectService service.
type SqlConnectServiceServer interface {
	// Retrieves connect settings about a Cloud SQL instance.
	GetConnectSettings(context.Context, *GetConnectSettingsRequest) (*ConnectSettings, error)
	// Generates a short-lived X509 certificate containing the provided public key
	// and signed by a private key specific to the target instance. Users may use
	// the certificate to authenticate as themselves when connecting to the
	// database.
	GenerateEphemeralCert(context.Context, *GenerateEphemeralCertRequest) (*GenerateEphemeralCertResponse, error)
}

// UnimplementedSqlConnectServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlConnectServiceServer struct {
}

func (*UnimplementedSqlConnectServiceServer) GetConnectSettings(context.Context, *GetConnectSettingsRequest) (*ConnectSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectSettings not implemented")
}
func (*UnimplementedSqlConnectServiceServer) GenerateEphemeralCert(context.Context, *GenerateEphemeralCertRequest) (*GenerateEphemeralCertResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateEphemeralCert not implemented")
}

func RegisterSqlConnectServiceServer(s *grpc.Server, srv SqlConnectServiceServer) {
	s.RegisterService(&_SqlConnectService_serviceDesc, srv)
}

func _SqlConnectService_GetConnectSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlConnectServiceServer).GetConnectSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlConnectService/GetConnectSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlConnectServiceServer).GetConnectSettings(ctx, req.(*GetConnectSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlConnectService_GenerateEphemeralCert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateEphemeralCertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlConnectServiceServer).GenerateEphemeralCert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlConnectService/GenerateEphemeralCert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlConnectServiceServer).GenerateEphemeralCert(ctx, req.(*GenerateEphemeralCertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlConnectService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlConnectService",
	HandlerType: (*SqlConnectServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetConnectSettings",
			Handler:    _SqlConnectService_GetConnectSettings_Handler,
		},
		{
			MethodName: "GenerateEphemeralCert",
			Handler:    _SqlConnectService_GenerateEphemeralCert_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql_connect.proto",
}
