// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1beta1/featurestore_monitoring.proto

package aiplatform

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Configuration of how features in Featurestore are monitored.
type FeaturestoreMonitoringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The config for Snapshot Analysis Based Feature Monitoring.
	SnapshotAnalysis *FeaturestoreMonitoringConfig_SnapshotAnalysis `protobuf:"bytes,1,opt,name=snapshot_analysis,json=snapshotAnalysis,proto3" json:"snapshot_analysis,omitempty"`
}

func (x *FeaturestoreMonitoringConfig) Reset() {
	*x = FeaturestoreMonitoringConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeaturestoreMonitoringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeaturestoreMonitoringConfig) ProtoMessage() {}

func (x *FeaturestoreMonitoringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeaturestoreMonitoringConfig.ProtoReflect.Descriptor instead.
func (*FeaturestoreMonitoringConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescGZIP(), []int{0}
}

func (x *FeaturestoreMonitoringConfig) GetSnapshotAnalysis() *FeaturestoreMonitoringConfig_SnapshotAnalysis {
	if x != nil {
		return x.SnapshotAnalysis
	}
	return nil
}

// Configuration of the Featurestore's Snapshot Analysis Based Monitoring.
// This type of analysis generates statistics for each Feature based on a
// snapshot of the latest feature value of each entities every
// monitoring_interval.
type FeaturestoreMonitoringConfig_SnapshotAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The monitoring schedule for snapshot analysis.
	// For EntityType-level config:
	//   unset / disabled = true indicates disabled by
	//   default for Features under it; otherwise by default enable snapshot
	//   analysis monitoring with monitoring_interval for Features under it.
	// Feature-level config:
	//   disabled = true indicates disabled regardless of the EntityType-level
	//   config; unset monitoring_interval indicates going with EntityType-level
	//   config; otherwise run snapshot analysis monitoring with
	//   monitoring_interval regardless of the EntityType-level config.
	// Explicitly Disable the snapshot analysis based monitoring.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Configuration of the snapshot analysis based monitoring pipeline running
	// interval. The value is rolled up to full day.
	//
	// Deprecated: Do not use.
	MonitoringInterval *durationpb.Duration `protobuf:"bytes,2,opt,name=monitoring_interval,json=monitoringInterval,proto3" json:"monitoring_interval,omitempty"`
	// Configuration of the snapshot analysis based monitoring pipeline
	// running interval. The value indicates number of days.
	// If both
	// [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
	// and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval]
	// are set when creating/updating EntityTypes/Features,
	// [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days][google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days]
	// will be used.
	MonitoringIntervalDays int32 `protobuf:"varint,3,opt,name=monitoring_interval_days,json=monitoringIntervalDays,proto3" json:"monitoring_interval_days,omitempty"`
}

func (x *FeaturestoreMonitoringConfig_SnapshotAnalysis) Reset() {
	*x = FeaturestoreMonitoringConfig_SnapshotAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeaturestoreMonitoringConfig_SnapshotAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeaturestoreMonitoringConfig_SnapshotAnalysis) ProtoMessage() {}

func (x *FeaturestoreMonitoringConfig_SnapshotAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeaturestoreMonitoringConfig_SnapshotAnalysis.ProtoReflect.Descriptor instead.
func (*FeaturestoreMonitoringConfig_SnapshotAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FeaturestoreMonitoringConfig_SnapshotAnalysis) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Deprecated: Do not use.
func (x *FeaturestoreMonitoringConfig_SnapshotAnalysis) GetMonitoringInterval() *durationpb.Duration {
	if x != nil {
		return x.MonitoringInterval
	}
	return nil
}

func (x *FeaturestoreMonitoringConfig_SnapshotAnalysis) GetMonitoringIntervalDays() int32 {
	if x != nil {
		return x.MonitoringIntervalDays
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd6,
	0x02, 0x0a, 0x1c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x7b, 0x0a, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x10, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x1a, 0xb8, 0x01, 0x0a,
	0x10, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4e, 0x0a,
	0x13, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x38, 0x0a,
	0x18, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x16, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x44, 0x61, 0x79, 0x73, 0x42, 0xf8, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42,
	0x1b, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_goTypes = []interface{}{
	(*FeaturestoreMonitoringConfig)(nil),                  // 0: google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig
	(*FeaturestoreMonitoringConfig_SnapshotAnalysis)(nil), // 1: google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
	(*durationpb.Duration)(nil),                           // 2: google.protobuf.Duration
}
var file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_depIdxs = []int32{
	1, // 0: google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.snapshot_analysis:type_name -> google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis
	2, // 1: google.cloud.aiplatform.v1beta1.FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval:type_name -> google.protobuf.Duration
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_init() }
func file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeaturestoreMonitoringConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeaturestoreMonitoringConfig_SnapshotAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto = out.File
	file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_featurestore_monitoring_proto_depIdxs = nil
}
