# Configuration Changes

- The `fieldalignment` analyzer, previously disabled by default, has
  been removed: it is redundant with the hover size/offset information
  displayed by v0.16.0 and its diagnostics were confusing.
- The kind (identifiers) of all of gopls' code actions have changed
  to use more specific hierarchical names. For example, "Inline call"
  has changed from `refactor.inline` to `refactor.inline.call`.
  This allows clients to request particular code actions more precisely.
  The user manual now includes the identifier in the documentation for each code action.
- The experimental `allowImplicitNetworkAccess` setting is removed, following
  its deprecation in gopls@v0.16.0. See golang/go#66861 for details.

# New features

## Extract declarations to new file

Gopls now offers another code action,
"Extract declarations to new file" (`refactor.extract.toNewFile`),
which moves selected code sections to a newly created file within the
same package. The created filename is chosen as the first {function, type,
const, var} name encountered. In addition, import declarations are added or
removed as needed.

The user can invoke this code action by selecting a function name, the keywords
`func`, `const`, `var`, `type`, or by placing the caret on them without selecting,
or by selecting a whole declaration or multiple declrations.

In order to avoid ambiguity and surprise about what to extract, some kinds
of paritial selection of a declration cannot invoke this code action.

## Pull diagnostics

When initialized with the option `"pullDiagnostics": true`, gopls will advertise support for the
`textDocument.diagnostic`
[client capability](https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#textDocument_pullDiagnostics),
which allows editors to request diagnostics directly from gopls using a
`textDocument/diagnostic` request, rather than wait for a
`textDocument/publishDiagnostics` notification. This feature is off by default
until the performance of pull diagnostics is comparable to push diagnostics.

## Hover improvements

The `textDocument/hover` response has slightly tweaked markdown rendering, and
includes the following additional information:

- Hovering over a standard library symbol now displays information about the
  first Go release containing the symbol. For example, hovering over
  `errors.As` shows "Added in go1.13".
- Hovering over the package name in a package declaration includes additional
  package metadata.

## Semantic token modifiers of top-level constructor of types

The semantic tokens response now includes additional modifiers for the top-level
constructor of the type of each symbol:
`interface`, `struct`, `signature`, `pointer`, `array`, `map`, `slice`, `chan`, `string`, `number`, `bool`, and `invalid`.
Editors may use this for syntax coloring.

## SignatureHelp for ident and values.

Now, function signature help can be used on any identifier with a function
signature, not just within the parentheses of a function being called.

## Jump to assembly definition

A Definition query on a reference to a function jumps to the
function's Go `func` declaration. If the function is implemented in C
or assembly, the function has no body. Executing a second Definition
query (while already at the Go declaration) will navigate you to the
assembly implementation.

## Generate missing method from function call

When you attempt to call a method on a type that does not have that method,
the compiler will report an error like “type X has no field or method Y”.
Gopls now offers a new code action, “Declare missing method of T.f”,
where T is the concrete type and f is the undefined method.
The stub method's signature is inferred
from the context of the call.
