# How to contribute

The entire point of us making this available is so that we can get input and contributions, so we are really glad you're thinking about contributing. 
A good place to start thinking about places we need help is our [Issues](issues) page.

Before you begin:
- Check to see if you're on the must up to date master branch of GoKart
- Have you read the [code of conduct](CODE_OF_CONDUCT.md)?

If you want to reach out to us to chat, you can email the GoKart team at <GoKart@praetorian.com>.

## Testing

Make sure your code submission runs well against some test repos. Consider testing both positive and negative use cases - that is, if you update a signature
to find more vulnerabilities, that's great. However, **please** make sure it doesn't find vulnerabilities where there are none.

## Submitting changes

Please send a [GitHub Pull Request to GoKart](pull/new/master) with a clear list of what you've done 
(read more about [pull requests](http://help.github.com/pull-requests/)). When you send a pull request, you'll be forever adored if you help us also add
to our tests so we can make sure this feature or bug fix stays working. Please make sure all of your commits are atomic (one feature per commit).

Always write a clear log message for your commits. One-line messages are fine for small changes, but bigger changes should look like this:

    $ git commit -m "A brief summary of the commit
    > 
    > A paragraph describing what changed and its impact."

## Coding conventions

Start reading our code and things should be pretty clear. We optimize for readability and simplicity, wherever possible. Clear beats out clever every time :)
                                                                                                                 
## Attribution

These guidelines are very loosely adapted from <https://github.com/opengovernment/opengovernment>.
