# Contributing to gocovsh

Contributions are welcome. Below are a few ways to contribute to this project.

## Bug reports

This project, just like every other one, has bugs. If you happen to notice one,
please submit a [bug
report](https://github.com/orlangure/gocovsh/issues/new?assignees=&labels=&template=bug_report.md&title=Bug%3A+).
It would be nice if you could go over other open issues and make sure that
there isn't one similar to yours before creating a new one.

When reporting bugs, please try to provide an example that anybody can clone
and see the bug for themselves. It should be possible to clone the repository,
run tests, generate a coverage report, and view it with `gocovsh`. The bug
should be present when following the above steps. If you see a bug in a private
repository, please try to replicate the problem using some fake code that can
be made public.

## Feature requests

Feature requests will be considered and probably even implemented. No
guarantees. It's always better to submit a feature request that you yourself
are willing to tackle.

## Pull requests

In general, pull requests are encouraged. There are a few things to keep in
mind:

- Please avoid working on something that you are not entirely sure can be
  merged. For example, a big new feature that wasn't discussed publicly
  probably won't be merged as-is, if at all. A small typo fix, on the other
  hand, does not require a separate discussion. If unsure, please ask.

- This project follows some particular, and probably opinionated code style
  guidelines. They are automatically enforced using `golangci-lint` with a set
  linters that can be found in
  [`.golangci.yml`](https://github.com/orlangure/gocovsh/blob/master/.golangci.yml).
  If you choose to contribute some code, please try to follow these guidelines.

- Since this is a code coverage tool, most of the features/fixes require tests.
  If you struggle to add some, maybe somebody else will help you after you open
  a pull request.

Please head to [open issues](https://github.com/orlangure/gocovsh/issues) and
feel free to help on any of them if you wish. It would be nice if you could let
everybody know that you are willing to work on some of them, so that the others
won't work on the same things at the same time.

## Feedback

If your feedback is not one of the above, head to the
[discussions](https://github.com/orlangure/gocovsh/discussions) and find/create
one to give your feedback or share your experience.

## Spread the word

If you find this project worth mentioning to your friends and colleagues, feel
free to spread the word.
