---
title: Staticcheck 2023.1 release notes
linkTitle: "2023.1 (v0.4.0)"
weight: -8
---

Staticcheck 2023.1 adds support for Go 1.20, brings minor improvements to various checks, and replaces U1000
with a new implementation.

## Checks {#checks}

### Changed checks {#checks-changed}

The following checks have been improved:

- The wording of {{< check "S1001" >}} has been made clearer for cases involving arrays. Furthermore, it no longer
  suggests using `copy` when the function has been shadowed.
- {{< check "S1011" >}} now recognizes index-based loops ({{< issue "881" >}}).
- {{< check "SA1019" >}} no longer flags tests (internal or external) that use deprecated API from the package under
  test ({{< issue "1285" >}}). Furthermore, entire declaration groups (such as groups of constants) can now be marked as
  deprecated ({{< issue "1313" >}}).
- {{< check "SA4017" >}} now detects more functions, including those in the `time` package ({{< issue "1353" >}}). 
  Additionally, its wording has been made clearer.
- {{< check "SA5010" >}} no longer gets confused by type assertions involving generic types ({{< issue "1354" >}}).
- {{< check "ST1005" >}} no longer flags errors that start with alpha-numeric acronyms such as `P384`.
- Improvements to our intermediate representation may allow various checks to find more problems.

Staticcheck now knows about version 2 of the `k8s.io/klog` package, in particular which functions abort control flow
({{< issue "1307" >}}).

In addition to these minor improvements, U1000 has been rewritten from the ground up, operating on a
program representation more suited to the task. In practice this means that there will be fewer false positives and more
true positives.

Overall, the rewrite fixes at least eight known bugs, both ones that have been a nuisance for a while,
as well as ones newly introduced by generics
({{< issue "507" >}}, {{< issue "633" >}}, {{< issue "810" >}}, {{< issue "812" >}}, {{< issue "1199" >}}, {{< issue
"1249" >}}, {{< issue "1282" >}}, {{< issue "1333" >}}).

## Staticcheck 2023.1.1 release notes {#2023.1.1}

This release fixes a crash, a false positive in U1000 ({{< issue "1360" >}}) and improves the way deprecated API is
flagged ({{< issue "1318" >}}).

When targeting a Go version that is older than the version that deprecated an API, {{< check "SA1019" >}} will no longer
flag the use even if there is already an alternative available in the targeted Go version.

For example, `math/rand.Seed` has been deprecated in Go 1.20, but an alternative has existed since Go 1.0. In the past,
we would flag uses of `Seed` even if targeting e.g. Go 1.19, to encourage better forwards compatibility. This can lead
to unnecessary churn, however, because the correct change may depend on the Go version in use. For example, for `Seed`
before Go 1.20, the alternative is to use a separate instance of `math/rand.Rand`, whereas in Go 1.20, a possible
alternative is to simply drop the call to `Seed`.
