// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

Runtime

Runtime domain exposes JavaScript runtime by means of remote evaluation and mirror objects.
Evaluation results are returned as mirror object that expose object type, string representation
and unique identifier that can be used for further object reference. Original objects are
maintained in memory unless they are either explicitly released or are released along with the
other objects in their object group.

*/

// RuntimeScriptID Unique script identifier.
type RuntimeScriptID string

// RuntimeWebDriverValueType enum
type RuntimeWebDriverValueType string

const (
	// RuntimeWebDriverValueTypeUndefined enum const
	RuntimeWebDriverValueTypeUndefined RuntimeWebDriverValueType = "undefined"

	// RuntimeWebDriverValueTypeNull enum const
	RuntimeWebDriverValueTypeNull RuntimeWebDriverValueType = "null"

	// RuntimeWebDriverValueTypeString enum const
	RuntimeWebDriverValueTypeString RuntimeWebDriverValueType = "string"

	// RuntimeWebDriverValueTypeNumber enum const
	RuntimeWebDriverValueTypeNumber RuntimeWebDriverValueType = "number"

	// RuntimeWebDriverValueTypeBoolean enum const
	RuntimeWebDriverValueTypeBoolean RuntimeWebDriverValueType = "boolean"

	// RuntimeWebDriverValueTypeBigint enum const
	RuntimeWebDriverValueTypeBigint RuntimeWebDriverValueType = "bigint"

	// RuntimeWebDriverValueTypeRegexp enum const
	RuntimeWebDriverValueTypeRegexp RuntimeWebDriverValueType = "regexp"

	// RuntimeWebDriverValueTypeDate enum const
	RuntimeWebDriverValueTypeDate RuntimeWebDriverValueType = "date"

	// RuntimeWebDriverValueTypeSymbol enum const
	RuntimeWebDriverValueTypeSymbol RuntimeWebDriverValueType = "symbol"

	// RuntimeWebDriverValueTypeArray enum const
	RuntimeWebDriverValueTypeArray RuntimeWebDriverValueType = "array"

	// RuntimeWebDriverValueTypeObject enum const
	RuntimeWebDriverValueTypeObject RuntimeWebDriverValueType = "object"

	// RuntimeWebDriverValueTypeFunction enum const
	RuntimeWebDriverValueTypeFunction RuntimeWebDriverValueType = "function"

	// RuntimeWebDriverValueTypeMap enum const
	RuntimeWebDriverValueTypeMap RuntimeWebDriverValueType = "map"

	// RuntimeWebDriverValueTypeSet enum const
	RuntimeWebDriverValueTypeSet RuntimeWebDriverValueType = "set"

	// RuntimeWebDriverValueTypeWeakmap enum const
	RuntimeWebDriverValueTypeWeakmap RuntimeWebDriverValueType = "weakmap"

	// RuntimeWebDriverValueTypeWeakset enum const
	RuntimeWebDriverValueTypeWeakset RuntimeWebDriverValueType = "weakset"

	// RuntimeWebDriverValueTypeError enum const
	RuntimeWebDriverValueTypeError RuntimeWebDriverValueType = "error"

	// RuntimeWebDriverValueTypeProxy enum const
	RuntimeWebDriverValueTypeProxy RuntimeWebDriverValueType = "proxy"

	// RuntimeWebDriverValueTypePromise enum const
	RuntimeWebDriverValueTypePromise RuntimeWebDriverValueType = "promise"

	// RuntimeWebDriverValueTypeTypedarray enum const
	RuntimeWebDriverValueTypeTypedarray RuntimeWebDriverValueType = "typedarray"

	// RuntimeWebDriverValueTypeArraybuffer enum const
	RuntimeWebDriverValueTypeArraybuffer RuntimeWebDriverValueType = "arraybuffer"

	// RuntimeWebDriverValueTypeNode enum const
	RuntimeWebDriverValueTypeNode RuntimeWebDriverValueType = "node"

	// RuntimeWebDriverValueTypeWindow enum const
	RuntimeWebDriverValueTypeWindow RuntimeWebDriverValueType = "window"
)

// RuntimeWebDriverValue Represents the value serialiazed by the WebDriver BiDi specification
// https://w3c.github.io/webdriver-bidi.
type RuntimeWebDriverValue struct {

	// Type ...
	Type RuntimeWebDriverValueType `json:"type"`

	// Value (optional) ...
	Value gson.JSON `json:"value,omitempty"`

	// ObjectID (optional) ...
	ObjectID string `json:"objectId,omitempty"`
}

// RuntimeRemoteObjectID Unique object identifier.
type RuntimeRemoteObjectID string

// RuntimeUnserializableValue Primitive value which cannot be JSON-stringified. Includes values `-0`, `NaN`, `Infinity`,
// `-Infinity`, and bigint literals.
type RuntimeUnserializableValue string

// RuntimeRemoteObjectType enum
type RuntimeRemoteObjectType string

const (
	// RuntimeRemoteObjectTypeObject enum const
	RuntimeRemoteObjectTypeObject RuntimeRemoteObjectType = "object"

	// RuntimeRemoteObjectTypeFunction enum const
	RuntimeRemoteObjectTypeFunction RuntimeRemoteObjectType = "function"

	// RuntimeRemoteObjectTypeUndefined enum const
	RuntimeRemoteObjectTypeUndefined RuntimeRemoteObjectType = "undefined"

	// RuntimeRemoteObjectTypeString enum const
	RuntimeRemoteObjectTypeString RuntimeRemoteObjectType = "string"

	// RuntimeRemoteObjectTypeNumber enum const
	RuntimeRemoteObjectTypeNumber RuntimeRemoteObjectType = "number"

	// RuntimeRemoteObjectTypeBoolean enum const
	RuntimeRemoteObjectTypeBoolean RuntimeRemoteObjectType = "boolean"

	// RuntimeRemoteObjectTypeSymbol enum const
	RuntimeRemoteObjectTypeSymbol RuntimeRemoteObjectType = "symbol"

	// RuntimeRemoteObjectTypeBigint enum const
	RuntimeRemoteObjectTypeBigint RuntimeRemoteObjectType = "bigint"
)

// RuntimeRemoteObjectSubtype enum
type RuntimeRemoteObjectSubtype string

const (
	// RuntimeRemoteObjectSubtypeArray enum const
	RuntimeRemoteObjectSubtypeArray RuntimeRemoteObjectSubtype = "array"

	// RuntimeRemoteObjectSubtypeNull enum const
	RuntimeRemoteObjectSubtypeNull RuntimeRemoteObjectSubtype = "null"

	// RuntimeRemoteObjectSubtypeNode enum const
	RuntimeRemoteObjectSubtypeNode RuntimeRemoteObjectSubtype = "node"

	// RuntimeRemoteObjectSubtypeRegexp enum const
	RuntimeRemoteObjectSubtypeRegexp RuntimeRemoteObjectSubtype = "regexp"

	// RuntimeRemoteObjectSubtypeDate enum const
	RuntimeRemoteObjectSubtypeDate RuntimeRemoteObjectSubtype = "date"

	// RuntimeRemoteObjectSubtypeMap enum const
	RuntimeRemoteObjectSubtypeMap RuntimeRemoteObjectSubtype = "map"

	// RuntimeRemoteObjectSubtypeSet enum const
	RuntimeRemoteObjectSubtypeSet RuntimeRemoteObjectSubtype = "set"

	// RuntimeRemoteObjectSubtypeWeakmap enum const
	RuntimeRemoteObjectSubtypeWeakmap RuntimeRemoteObjectSubtype = "weakmap"

	// RuntimeRemoteObjectSubtypeWeakset enum const
	RuntimeRemoteObjectSubtypeWeakset RuntimeRemoteObjectSubtype = "weakset"

	// RuntimeRemoteObjectSubtypeIterator enum const
	RuntimeRemoteObjectSubtypeIterator RuntimeRemoteObjectSubtype = "iterator"

	// RuntimeRemoteObjectSubtypeGenerator enum const
	RuntimeRemoteObjectSubtypeGenerator RuntimeRemoteObjectSubtype = "generator"

	// RuntimeRemoteObjectSubtypeError enum const
	RuntimeRemoteObjectSubtypeError RuntimeRemoteObjectSubtype = "error"

	// RuntimeRemoteObjectSubtypeProxy enum const
	RuntimeRemoteObjectSubtypeProxy RuntimeRemoteObjectSubtype = "proxy"

	// RuntimeRemoteObjectSubtypePromise enum const
	RuntimeRemoteObjectSubtypePromise RuntimeRemoteObjectSubtype = "promise"

	// RuntimeRemoteObjectSubtypeTypedarray enum const
	RuntimeRemoteObjectSubtypeTypedarray RuntimeRemoteObjectSubtype = "typedarray"

	// RuntimeRemoteObjectSubtypeArraybuffer enum const
	RuntimeRemoteObjectSubtypeArraybuffer RuntimeRemoteObjectSubtype = "arraybuffer"

	// RuntimeRemoteObjectSubtypeDataview enum const
	RuntimeRemoteObjectSubtypeDataview RuntimeRemoteObjectSubtype = "dataview"

	// RuntimeRemoteObjectSubtypeWebassemblymemory enum const
	RuntimeRemoteObjectSubtypeWebassemblymemory RuntimeRemoteObjectSubtype = "webassemblymemory"

	// RuntimeRemoteObjectSubtypeWasmvalue enum const
	RuntimeRemoteObjectSubtypeWasmvalue RuntimeRemoteObjectSubtype = "wasmvalue"
)

// RuntimeRemoteObject Mirror object referencing original JavaScript object.
type RuntimeRemoteObject struct {

	// Type Object type.
	Type RuntimeRemoteObjectType `json:"type"`

	// Subtype (optional) Object subtype hint. Specified for `object` type values only.
	// NOTE: If you change anything here, make sure to also update
	// `subtype` in `ObjectPreview` and `PropertyPreview` below.
	Subtype RuntimeRemoteObjectSubtype `json:"subtype,omitempty"`

	// ClassName (optional) Object class (constructor) name. Specified for `object` type values only.
	ClassName string `json:"className,omitempty"`

	// Value (optional) Remote object value in case of primitive values or JSON values (if it was requested).
	Value gson.JSON `json:"value,omitempty"`

	// UnserializableValue (optional) Primitive value which can not be JSON-stringified does not have `value`, but gets this
	// property.
	UnserializableValue RuntimeUnserializableValue `json:"unserializableValue,omitempty"`

	// Description (optional) String representation of the object.
	Description string `json:"description,omitempty"`

	// WebDriverValue (experimental) (optional) WebDriver BiDi representation of the value.
	WebDriverValue *RuntimeWebDriverValue `json:"webDriverValue,omitempty"`

	// ObjectID (optional) Unique object identifier (for non-primitive values).
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`

	// Preview (experimental) (optional) Preview containing abbreviated property values. Specified for `object` type values only.
	Preview *RuntimeObjectPreview `json:"preview,omitempty"`

	// CustomPreview (experimental) (optional) ...
	CustomPreview *RuntimeCustomPreview `json:"customPreview,omitempty"`
}

// RuntimeCustomPreview (experimental) ...
type RuntimeCustomPreview struct {

	// Header The JSON-stringified result of formatter.header(object, config) call.
	// It contains json ML array that represents RemoteObject.
	Header string `json:"header"`

	// BodyGetterID (optional) If formatter returns true as a result of formatter.hasBody call then bodyGetterId will
	// contain RemoteObjectId for the function that returns result of formatter.body(object, config) call.
	// The result value is json ML array.
	BodyGetterID RuntimeRemoteObjectID `json:"bodyGetterId,omitempty"`
}

// RuntimeObjectPreviewType enum
type RuntimeObjectPreviewType string

const (
	// RuntimeObjectPreviewTypeObject enum const
	RuntimeObjectPreviewTypeObject RuntimeObjectPreviewType = "object"

	// RuntimeObjectPreviewTypeFunction enum const
	RuntimeObjectPreviewTypeFunction RuntimeObjectPreviewType = "function"

	// RuntimeObjectPreviewTypeUndefined enum const
	RuntimeObjectPreviewTypeUndefined RuntimeObjectPreviewType = "undefined"

	// RuntimeObjectPreviewTypeString enum const
	RuntimeObjectPreviewTypeString RuntimeObjectPreviewType = "string"

	// RuntimeObjectPreviewTypeNumber enum const
	RuntimeObjectPreviewTypeNumber RuntimeObjectPreviewType = "number"

	// RuntimeObjectPreviewTypeBoolean enum const
	RuntimeObjectPreviewTypeBoolean RuntimeObjectPreviewType = "boolean"

	// RuntimeObjectPreviewTypeSymbol enum const
	RuntimeObjectPreviewTypeSymbol RuntimeObjectPreviewType = "symbol"

	// RuntimeObjectPreviewTypeBigint enum const
	RuntimeObjectPreviewTypeBigint RuntimeObjectPreviewType = "bigint"
)

// RuntimeObjectPreviewSubtype enum
type RuntimeObjectPreviewSubtype string

const (
	// RuntimeObjectPreviewSubtypeArray enum const
	RuntimeObjectPreviewSubtypeArray RuntimeObjectPreviewSubtype = "array"

	// RuntimeObjectPreviewSubtypeNull enum const
	RuntimeObjectPreviewSubtypeNull RuntimeObjectPreviewSubtype = "null"

	// RuntimeObjectPreviewSubtypeNode enum const
	RuntimeObjectPreviewSubtypeNode RuntimeObjectPreviewSubtype = "node"

	// RuntimeObjectPreviewSubtypeRegexp enum const
	RuntimeObjectPreviewSubtypeRegexp RuntimeObjectPreviewSubtype = "regexp"

	// RuntimeObjectPreviewSubtypeDate enum const
	RuntimeObjectPreviewSubtypeDate RuntimeObjectPreviewSubtype = "date"

	// RuntimeObjectPreviewSubtypeMap enum const
	RuntimeObjectPreviewSubtypeMap RuntimeObjectPreviewSubtype = "map"

	// RuntimeObjectPreviewSubtypeSet enum const
	RuntimeObjectPreviewSubtypeSet RuntimeObjectPreviewSubtype = "set"

	// RuntimeObjectPreviewSubtypeWeakmap enum const
	RuntimeObjectPreviewSubtypeWeakmap RuntimeObjectPreviewSubtype = "weakmap"

	// RuntimeObjectPreviewSubtypeWeakset enum const
	RuntimeObjectPreviewSubtypeWeakset RuntimeObjectPreviewSubtype = "weakset"

	// RuntimeObjectPreviewSubtypeIterator enum const
	RuntimeObjectPreviewSubtypeIterator RuntimeObjectPreviewSubtype = "iterator"

	// RuntimeObjectPreviewSubtypeGenerator enum const
	RuntimeObjectPreviewSubtypeGenerator RuntimeObjectPreviewSubtype = "generator"

	// RuntimeObjectPreviewSubtypeError enum const
	RuntimeObjectPreviewSubtypeError RuntimeObjectPreviewSubtype = "error"

	// RuntimeObjectPreviewSubtypeProxy enum const
	RuntimeObjectPreviewSubtypeProxy RuntimeObjectPreviewSubtype = "proxy"

	// RuntimeObjectPreviewSubtypePromise enum const
	RuntimeObjectPreviewSubtypePromise RuntimeObjectPreviewSubtype = "promise"

	// RuntimeObjectPreviewSubtypeTypedarray enum const
	RuntimeObjectPreviewSubtypeTypedarray RuntimeObjectPreviewSubtype = "typedarray"

	// RuntimeObjectPreviewSubtypeArraybuffer enum const
	RuntimeObjectPreviewSubtypeArraybuffer RuntimeObjectPreviewSubtype = "arraybuffer"

	// RuntimeObjectPreviewSubtypeDataview enum const
	RuntimeObjectPreviewSubtypeDataview RuntimeObjectPreviewSubtype = "dataview"

	// RuntimeObjectPreviewSubtypeWebassemblymemory enum const
	RuntimeObjectPreviewSubtypeWebassemblymemory RuntimeObjectPreviewSubtype = "webassemblymemory"

	// RuntimeObjectPreviewSubtypeWasmvalue enum const
	RuntimeObjectPreviewSubtypeWasmvalue RuntimeObjectPreviewSubtype = "wasmvalue"
)

// RuntimeObjectPreview (experimental) Object containing abbreviated remote object value.
type RuntimeObjectPreview struct {

	// Type Object type.
	Type RuntimeObjectPreviewType `json:"type"`

	// Subtype (optional) Object subtype hint. Specified for `object` type values only.
	Subtype RuntimeObjectPreviewSubtype `json:"subtype,omitempty"`

	// Description (optional) String representation of the object.
	Description string `json:"description,omitempty"`

	// Overflow True iff some of the properties or entries of the original object did not fit.
	Overflow bool `json:"overflow"`

	// Properties List of the properties.
	Properties []*RuntimePropertyPreview `json:"properties"`

	// Entries (optional) List of the entries. Specified for `map` and `set` subtype values only.
	Entries []*RuntimeEntryPreview `json:"entries,omitempty"`
}

// RuntimePropertyPreviewType enum
type RuntimePropertyPreviewType string

const (
	// RuntimePropertyPreviewTypeObject enum const
	RuntimePropertyPreviewTypeObject RuntimePropertyPreviewType = "object"

	// RuntimePropertyPreviewTypeFunction enum const
	RuntimePropertyPreviewTypeFunction RuntimePropertyPreviewType = "function"

	// RuntimePropertyPreviewTypeUndefined enum const
	RuntimePropertyPreviewTypeUndefined RuntimePropertyPreviewType = "undefined"

	// RuntimePropertyPreviewTypeString enum const
	RuntimePropertyPreviewTypeString RuntimePropertyPreviewType = "string"

	// RuntimePropertyPreviewTypeNumber enum const
	RuntimePropertyPreviewTypeNumber RuntimePropertyPreviewType = "number"

	// RuntimePropertyPreviewTypeBoolean enum const
	RuntimePropertyPreviewTypeBoolean RuntimePropertyPreviewType = "boolean"

	// RuntimePropertyPreviewTypeSymbol enum const
	RuntimePropertyPreviewTypeSymbol RuntimePropertyPreviewType = "symbol"

	// RuntimePropertyPreviewTypeAccessor enum const
	RuntimePropertyPreviewTypeAccessor RuntimePropertyPreviewType = "accessor"

	// RuntimePropertyPreviewTypeBigint enum const
	RuntimePropertyPreviewTypeBigint RuntimePropertyPreviewType = "bigint"
)

// RuntimePropertyPreviewSubtype enum
type RuntimePropertyPreviewSubtype string

const (
	// RuntimePropertyPreviewSubtypeArray enum const
	RuntimePropertyPreviewSubtypeArray RuntimePropertyPreviewSubtype = "array"

	// RuntimePropertyPreviewSubtypeNull enum const
	RuntimePropertyPreviewSubtypeNull RuntimePropertyPreviewSubtype = "null"

	// RuntimePropertyPreviewSubtypeNode enum const
	RuntimePropertyPreviewSubtypeNode RuntimePropertyPreviewSubtype = "node"

	// RuntimePropertyPreviewSubtypeRegexp enum const
	RuntimePropertyPreviewSubtypeRegexp RuntimePropertyPreviewSubtype = "regexp"

	// RuntimePropertyPreviewSubtypeDate enum const
	RuntimePropertyPreviewSubtypeDate RuntimePropertyPreviewSubtype = "date"

	// RuntimePropertyPreviewSubtypeMap enum const
	RuntimePropertyPreviewSubtypeMap RuntimePropertyPreviewSubtype = "map"

	// RuntimePropertyPreviewSubtypeSet enum const
	RuntimePropertyPreviewSubtypeSet RuntimePropertyPreviewSubtype = "set"

	// RuntimePropertyPreviewSubtypeWeakmap enum const
	RuntimePropertyPreviewSubtypeWeakmap RuntimePropertyPreviewSubtype = "weakmap"

	// RuntimePropertyPreviewSubtypeWeakset enum const
	RuntimePropertyPreviewSubtypeWeakset RuntimePropertyPreviewSubtype = "weakset"

	// RuntimePropertyPreviewSubtypeIterator enum const
	RuntimePropertyPreviewSubtypeIterator RuntimePropertyPreviewSubtype = "iterator"

	// RuntimePropertyPreviewSubtypeGenerator enum const
	RuntimePropertyPreviewSubtypeGenerator RuntimePropertyPreviewSubtype = "generator"

	// RuntimePropertyPreviewSubtypeError enum const
	RuntimePropertyPreviewSubtypeError RuntimePropertyPreviewSubtype = "error"

	// RuntimePropertyPreviewSubtypeProxy enum const
	RuntimePropertyPreviewSubtypeProxy RuntimePropertyPreviewSubtype = "proxy"

	// RuntimePropertyPreviewSubtypePromise enum const
	RuntimePropertyPreviewSubtypePromise RuntimePropertyPreviewSubtype = "promise"

	// RuntimePropertyPreviewSubtypeTypedarray enum const
	RuntimePropertyPreviewSubtypeTypedarray RuntimePropertyPreviewSubtype = "typedarray"

	// RuntimePropertyPreviewSubtypeArraybuffer enum const
	RuntimePropertyPreviewSubtypeArraybuffer RuntimePropertyPreviewSubtype = "arraybuffer"

	// RuntimePropertyPreviewSubtypeDataview enum const
	RuntimePropertyPreviewSubtypeDataview RuntimePropertyPreviewSubtype = "dataview"

	// RuntimePropertyPreviewSubtypeWebassemblymemory enum const
	RuntimePropertyPreviewSubtypeWebassemblymemory RuntimePropertyPreviewSubtype = "webassemblymemory"

	// RuntimePropertyPreviewSubtypeWasmvalue enum const
	RuntimePropertyPreviewSubtypeWasmvalue RuntimePropertyPreviewSubtype = "wasmvalue"
)

// RuntimePropertyPreview (experimental) ...
type RuntimePropertyPreview struct {

	// Name Property name.
	Name string `json:"name"`

	// Type Object type. Accessor means that the property itself is an accessor property.
	Type RuntimePropertyPreviewType `json:"type"`

	// Value (optional) User-friendly property value string.
	Value string `json:"value,omitempty"`

	// ValuePreview (optional) Nested value preview.
	ValuePreview *RuntimeObjectPreview `json:"valuePreview,omitempty"`

	// Subtype (optional) Object subtype hint. Specified for `object` type values only.
	Subtype RuntimePropertyPreviewSubtype `json:"subtype,omitempty"`
}

// RuntimeEntryPreview (experimental) ...
type RuntimeEntryPreview struct {

	// Key (optional) Preview of the key. Specified for map-like collection entries.
	Key *RuntimeObjectPreview `json:"key,omitempty"`

	// Value Preview of the value.
	Value *RuntimeObjectPreview `json:"value"`
}

// RuntimePropertyDescriptor Object property descriptor.
type RuntimePropertyDescriptor struct {

	// Name Property name or symbol description.
	Name string `json:"name"`

	// Value (optional) The value associated with the property.
	Value *RuntimeRemoteObject `json:"value,omitempty"`

	// Writable (optional) True if the value associated with the property may be changed (data descriptors only).
	Writable bool `json:"writable,omitempty"`

	// Get (optional) A function which serves as a getter for the property, or `undefined` if there is no getter
	// (accessor descriptors only).
	Get *RuntimeRemoteObject `json:"get,omitempty"`

	// Set (optional) A function which serves as a setter for the property, or `undefined` if there is no setter
	// (accessor descriptors only).
	Set *RuntimeRemoteObject `json:"set,omitempty"`

	// Configurable True if the type of this property descriptor may be changed and if the property may be
	// deleted from the corresponding object.
	Configurable bool `json:"configurable"`

	// Enumerable True if this property shows up during enumeration of the properties on the corresponding
	// object.
	Enumerable bool `json:"enumerable"`

	// WasThrown (optional) True if the result was thrown during the evaluation.
	WasThrown bool `json:"wasThrown,omitempty"`

	// IsOwn (optional) True if the property is owned for the object.
	IsOwn bool `json:"isOwn,omitempty"`

	// Symbol (optional) Property symbol object, if the property is of the `symbol` type.
	Symbol *RuntimeRemoteObject `json:"symbol,omitempty"`
}

// RuntimeInternalPropertyDescriptor Object internal property descriptor. This property isn't normally visible in JavaScript code.
type RuntimeInternalPropertyDescriptor struct {

	// Name Conventional property name.
	Name string `json:"name"`

	// Value (optional) The value associated with the property.
	Value *RuntimeRemoteObject `json:"value,omitempty"`
}

// RuntimePrivatePropertyDescriptor (experimental) Object private field descriptor.
type RuntimePrivatePropertyDescriptor struct {

	// Name Private property name.
	Name string `json:"name"`

	// Value (optional) The value associated with the private property.
	Value *RuntimeRemoteObject `json:"value,omitempty"`

	// Get (optional) A function which serves as a getter for the private property,
	// or `undefined` if there is no getter (accessor descriptors only).
	Get *RuntimeRemoteObject `json:"get,omitempty"`

	// Set (optional) A function which serves as a setter for the private property,
	// or `undefined` if there is no setter (accessor descriptors only).
	Set *RuntimeRemoteObject `json:"set,omitempty"`
}

// RuntimeCallArgument Represents function call argument. Either remote object id `objectId`, primitive `value`,
// unserializable primitive value or neither of (for undefined) them should be specified.
type RuntimeCallArgument struct {

	// Value (optional) Primitive value or serializable javascript object.
	Value gson.JSON `json:"value,omitempty"`

	// UnserializableValue (optional) Primitive value which can not be JSON-stringified.
	UnserializableValue RuntimeUnserializableValue `json:"unserializableValue,omitempty"`

	// ObjectID (optional) Remote object handle.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`
}

// RuntimeExecutionContextID Id of an execution context.
type RuntimeExecutionContextID int

// RuntimeExecutionContextDescription Description of an isolated world.
type RuntimeExecutionContextDescription struct {

	// ID Unique id of the execution context. It can be used to specify in which execution context
	// script evaluation should be performed.
	ID RuntimeExecutionContextID `json:"id"`

	// Origin Execution context origin.
	Origin string `json:"origin"`

	// Name Human readable name describing given context.
	Name string `json:"name"`

	// UniqueID (experimental) A system-unique execution context identifier. Unlike the id, this is unique across
	// multiple processes, so can be reliably used to identify specific context while backend
	// performs a cross-process navigation.
	UniqueID string `json:"uniqueId"`

	// AuxData (optional) Embedder-specific auxiliary data.
	AuxData map[string]gson.JSON `json:"auxData,omitempty"`
}

// RuntimeExceptionDetails Detailed information about exception (or error) that was thrown during script compilation or
// execution.
type RuntimeExceptionDetails struct {

	// ExceptionID Exception id.
	ExceptionID int `json:"exceptionId"`

	// Text Exception text, which should be used together with exception object when available.
	Text string `json:"text"`

	// LineNumber Line number of the exception location (0-based).
	LineNumber int `json:"lineNumber"`

	// ColumnNumber Column number of the exception location (0-based).
	ColumnNumber int `json:"columnNumber"`

	// ScriptID (optional) Script ID of the exception location.
	ScriptID RuntimeScriptID `json:"scriptId,omitempty"`

	// URL (optional) URL of the exception location, to be used when the script was not reported.
	URL string `json:"url,omitempty"`

	// StackTrace (optional) JavaScript stack trace if available.
	StackTrace *RuntimeStackTrace `json:"stackTrace,omitempty"`

	// Exception (optional) Exception object if available.
	Exception *RuntimeRemoteObject `json:"exception,omitempty"`

	// ExecutionContextID (optional) Identifier of the context where exception happened.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`

	// ExceptionMetaData (experimental) (optional) Dictionary with entries of meta data that the client associated
	// with this exception, such as information about associated network
	// requests, etc.
	ExceptionMetaData map[string]gson.JSON `json:"exceptionMetaData,omitempty"`
}

// RuntimeTimestamp Number of milliseconds since epoch.
type RuntimeTimestamp float64

// RuntimeTimeDelta Number of milliseconds.
type RuntimeTimeDelta float64

// RuntimeCallFrame Stack entry for runtime errors and assertions.
type RuntimeCallFrame struct {

	// FunctionName JavaScript function name.
	FunctionName string `json:"functionName"`

	// ScriptID JavaScript script id.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// URL JavaScript script name or url.
	URL string `json:"url"`

	// LineNumber JavaScript script line number (0-based).
	LineNumber int `json:"lineNumber"`

	// ColumnNumber JavaScript script column number (0-based).
	ColumnNumber int `json:"columnNumber"`
}

// RuntimeStackTrace Call frames for assertions or error messages.
type RuntimeStackTrace struct {

	// Description (optional) String label of this stack trace. For async traces this may be a name of the function that
	// initiated the async call.
	Description string `json:"description,omitempty"`

	// CallFrames JavaScript function name.
	CallFrames []*RuntimeCallFrame `json:"callFrames"`

	// Parent (optional) Asynchronous JavaScript stack trace that preceded this stack, if available.
	Parent *RuntimeStackTrace `json:"parent,omitempty"`

	// ParentID (experimental) (optional) Asynchronous JavaScript stack trace that preceded this stack, if available.
	ParentID *RuntimeStackTraceID `json:"parentId,omitempty"`
}

// RuntimeUniqueDebuggerID (experimental) Unique identifier of current debugger.
type RuntimeUniqueDebuggerID string

// RuntimeStackTraceID (experimental) If `debuggerId` is set stack trace comes from another debugger and can be resolved there. This
// allows to track cross-debugger calls. See `Runtime.StackTrace` and `Debugger.paused` for usages.
type RuntimeStackTraceID struct {

	// ID ...
	ID string `json:"id"`

	// DebuggerID (optional) ...
	DebuggerID RuntimeUniqueDebuggerID `json:"debuggerId,omitempty"`
}

// RuntimeAwaitPromise Add handler to promise with given promise object id.
type RuntimeAwaitPromise struct {

	// PromiseObjectID Identifier of the promise.
	PromiseObjectID RuntimeRemoteObjectID `json:"promiseObjectId"`

	// ReturnByValue (optional) Whether the result is expected to be a JSON object that should be sent by value.
	ReturnByValue bool `json:"returnByValue,omitempty"`

	// GeneratePreview (optional) Whether preview should be generated for the result.
	GeneratePreview bool `json:"generatePreview,omitempty"`
}

// ProtoReq name
func (m RuntimeAwaitPromise) ProtoReq() string { return "Runtime.awaitPromise" }

// Call the request
func (m RuntimeAwaitPromise) Call(c Client) (*RuntimeAwaitPromiseResult, error) {
	var res RuntimeAwaitPromiseResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeAwaitPromiseResult ...
type RuntimeAwaitPromiseResult struct {

	// Result Promise result. Will contain rejected value if promise was rejected.
	Result *RuntimeRemoteObject `json:"result"`

	// ExceptionDetails (optional) Exception details if stack strace is available.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// RuntimeCallFunctionOn Calls function with given declaration on the given object. Object group of the result is
// inherited from the target object.
type RuntimeCallFunctionOn struct {

	// FunctionDeclaration Declaration of the function to call.
	FunctionDeclaration string `json:"functionDeclaration"`

	// ObjectID (optional) Identifier of the object to call function on. Either objectId or executionContextId should
	// be specified.
	ObjectID RuntimeRemoteObjectID `json:"objectId,omitempty"`

	// Arguments (optional) Call arguments. All call arguments must belong to the same JavaScript world as the target
	// object.
	Arguments []*RuntimeCallArgument `json:"arguments,omitempty"`

	// Silent (optional) In silent mode exceptions thrown during evaluation are not reported and do not pause
	// execution. Overrides `setPauseOnException` state.
	Silent bool `json:"silent,omitempty"`

	// ReturnByValue (optional) Whether the result is expected to be a JSON object which should be sent by value.
	ReturnByValue bool `json:"returnByValue,omitempty"`

	// GeneratePreview (experimental) (optional) Whether preview should be generated for the result.
	GeneratePreview bool `json:"generatePreview,omitempty"`

	// UserGesture (optional) Whether execution should be treated as initiated by user in the UI.
	UserGesture bool `json:"userGesture,omitempty"`

	// AwaitPromise (optional) Whether execution should `await` for resulting value and return once awaited promise is
	// resolved.
	AwaitPromise bool `json:"awaitPromise,omitempty"`

	// ExecutionContextID (optional) Specifies execution context which global object will be used to call function on. Either
	// executionContextId or objectId should be specified.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`

	// ObjectGroup (optional) Symbolic group name that can be used to release multiple objects. If objectGroup is not
	// specified and objectId is, objectGroup will be inherited from object.
	ObjectGroup string `json:"objectGroup,omitempty"`

	// ThrowOnSideEffect (experimental) (optional) Whether to throw an exception if side effect cannot be ruled out during evaluation.
	ThrowOnSideEffect bool `json:"throwOnSideEffect,omitempty"`

	// UniqueContextID (experimental) (optional) An alternative way to specify the execution context to call function on.
	// Compared to contextId that may be reused across processes, this is guaranteed to be
	// system-unique, so it can be used to prevent accidental function call
	// in context different than intended (e.g. as a result of navigation across process
	// boundaries).
	// This is mutually exclusive with `executionContextId`.
	UniqueContextID string `json:"uniqueContextId,omitempty"`

	// GenerateWebDriverValue (experimental) (optional) Whether the result should contain `webDriverValue`, serialized according to
	// https://w3c.github.io/webdriver-bidi. This is mutually exclusive with `returnByValue`, but
	// resulting `objectId` is still provided.
	GenerateWebDriverValue bool `json:"generateWebDriverValue,omitempty"`
}

// ProtoReq name
func (m RuntimeCallFunctionOn) ProtoReq() string { return "Runtime.callFunctionOn" }

// Call the request
func (m RuntimeCallFunctionOn) Call(c Client) (*RuntimeCallFunctionOnResult, error) {
	var res RuntimeCallFunctionOnResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeCallFunctionOnResult ...
type RuntimeCallFunctionOnResult struct {

	// Result Call result.
	Result *RuntimeRemoteObject `json:"result"`

	// ExceptionDetails (optional) Exception details.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// RuntimeCompileScript Compiles expression.
type RuntimeCompileScript struct {

	// Expression Expression to compile.
	Expression string `json:"expression"`

	// SourceURL Source url to be set for the script.
	SourceURL string `json:"sourceURL"`

	// PersistScript Specifies whether the compiled script should be persisted.
	PersistScript bool `json:"persistScript"`

	// ExecutionContextID (optional) Specifies in which execution context to perform script run. If the parameter is omitted the
	// evaluation will be performed in the context of the inspected page.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`
}

// ProtoReq name
func (m RuntimeCompileScript) ProtoReq() string { return "Runtime.compileScript" }

// Call the request
func (m RuntimeCompileScript) Call(c Client) (*RuntimeCompileScriptResult, error) {
	var res RuntimeCompileScriptResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeCompileScriptResult ...
type RuntimeCompileScriptResult struct {

	// ScriptID (optional) Id of the script.
	ScriptID RuntimeScriptID `json:"scriptId,omitempty"`

	// ExceptionDetails (optional) Exception details.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// RuntimeDisable Disables reporting of execution contexts creation.
type RuntimeDisable struct {
}

// ProtoReq name
func (m RuntimeDisable) ProtoReq() string { return "Runtime.disable" }

// Call sends the request
func (m RuntimeDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeDiscardConsoleEntries Discards collected exceptions and console API calls.
type RuntimeDiscardConsoleEntries struct {
}

// ProtoReq name
func (m RuntimeDiscardConsoleEntries) ProtoReq() string { return "Runtime.discardConsoleEntries" }

// Call sends the request
func (m RuntimeDiscardConsoleEntries) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeEnable Enables reporting of execution contexts creation by means of `executionContextCreated` event.
// When the reporting gets enabled the event will be sent immediately for each existing execution
// context.
type RuntimeEnable struct {
}

// ProtoReq name
func (m RuntimeEnable) ProtoReq() string { return "Runtime.enable" }

// Call sends the request
func (m RuntimeEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeEvaluate Evaluates expression on global object.
type RuntimeEvaluate struct {

	// Expression Expression to evaluate.
	Expression string `json:"expression"`

	// ObjectGroup (optional) Symbolic group name that can be used to release multiple objects.
	ObjectGroup string `json:"objectGroup,omitempty"`

	// IncludeCommandLineAPI (optional) Determines whether Command Line API should be available during the evaluation.
	IncludeCommandLineAPI bool `json:"includeCommandLineAPI,omitempty"`

	// Silent (optional) In silent mode exceptions thrown during evaluation are not reported and do not pause
	// execution. Overrides `setPauseOnException` state.
	Silent bool `json:"silent,omitempty"`

	// ContextID (optional) Specifies in which execution context to perform evaluation. If the parameter is omitted the
	// evaluation will be performed in the context of the inspected page.
	// This is mutually exclusive with `uniqueContextId`, which offers an
	// alternative way to identify the execution context that is more reliable
	// in a multi-process environment.
	ContextID RuntimeExecutionContextID `json:"contextId,omitempty"`

	// ReturnByValue (optional) Whether the result is expected to be a JSON object that should be sent by value.
	ReturnByValue bool `json:"returnByValue,omitempty"`

	// GeneratePreview (experimental) (optional) Whether preview should be generated for the result.
	GeneratePreview bool `json:"generatePreview,omitempty"`

	// UserGesture (optional) Whether execution should be treated as initiated by user in the UI.
	UserGesture bool `json:"userGesture,omitempty"`

	// AwaitPromise (optional) Whether execution should `await` for resulting value and return once awaited promise is
	// resolved.
	AwaitPromise bool `json:"awaitPromise,omitempty"`

	// ThrowOnSideEffect (experimental) (optional) Whether to throw an exception if side effect cannot be ruled out during evaluation.
	// This implies `disableBreaks` below.
	ThrowOnSideEffect bool `json:"throwOnSideEffect,omitempty"`

	// Timeout (experimental) (optional) Terminate execution after timing out (number of milliseconds).
	Timeout RuntimeTimeDelta `json:"timeout,omitempty"`

	// DisableBreaks (experimental) (optional) Disable breakpoints during execution.
	DisableBreaks bool `json:"disableBreaks,omitempty"`

	// ReplMode (experimental) (optional) Setting this flag to true enables `let` re-declaration and top-level `await`.
	// Note that `let` variables can only be re-declared if they originate from
	// `replMode` themselves.
	ReplMode bool `json:"replMode,omitempty"`

	// AllowUnsafeEvalBlockedByCSP (experimental) (optional) The Content Security Policy (CSP) for the target might block 'unsafe-eval'
	// which includes eval(), Function(), setTimeout() and setInterval()
	// when called with non-callable arguments. This flag bypasses CSP for this
	// evaluation and allows unsafe-eval. Defaults to true.
	AllowUnsafeEvalBlockedByCSP bool `json:"allowUnsafeEvalBlockedByCSP,omitempty"`

	// UniqueContextID (experimental) (optional) An alternative way to specify the execution context to evaluate in.
	// Compared to contextId that may be reused across processes, this is guaranteed to be
	// system-unique, so it can be used to prevent accidental evaluation of the expression
	// in context different than intended (e.g. as a result of navigation across process
	// boundaries).
	// This is mutually exclusive with `contextId`.
	UniqueContextID string `json:"uniqueContextId,omitempty"`

	// GenerateWebDriverValue (experimental) (optional) Whether the result should be serialized according to https://w3c.github.io/webdriver-bidi.
	GenerateWebDriverValue bool `json:"generateWebDriverValue,omitempty"`
}

// ProtoReq name
func (m RuntimeEvaluate) ProtoReq() string { return "Runtime.evaluate" }

// Call the request
func (m RuntimeEvaluate) Call(c Client) (*RuntimeEvaluateResult, error) {
	var res RuntimeEvaluateResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeEvaluateResult ...
type RuntimeEvaluateResult struct {

	// Result Evaluation result.
	Result *RuntimeRemoteObject `json:"result"`

	// ExceptionDetails (optional) Exception details.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// RuntimeGetIsolateID (experimental) Returns the isolate id.
type RuntimeGetIsolateID struct {
}

// ProtoReq name
func (m RuntimeGetIsolateID) ProtoReq() string { return "Runtime.getIsolateId" }

// Call the request
func (m RuntimeGetIsolateID) Call(c Client) (*RuntimeGetIsolateIDResult, error) {
	var res RuntimeGetIsolateIDResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeGetIsolateIDResult (experimental) ...
type RuntimeGetIsolateIDResult struct {

	// ID The isolate id.
	ID string `json:"id"`
}

// RuntimeGetHeapUsage (experimental) Returns the JavaScript heap usage.
// It is the total usage of the corresponding isolate not scoped to a particular Runtime.
type RuntimeGetHeapUsage struct {
}

// ProtoReq name
func (m RuntimeGetHeapUsage) ProtoReq() string { return "Runtime.getHeapUsage" }

// Call the request
func (m RuntimeGetHeapUsage) Call(c Client) (*RuntimeGetHeapUsageResult, error) {
	var res RuntimeGetHeapUsageResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeGetHeapUsageResult (experimental) ...
type RuntimeGetHeapUsageResult struct {

	// UsedSize Used heap size in bytes.
	UsedSize float64 `json:"usedSize"`

	// TotalSize Allocated heap size in bytes.
	TotalSize float64 `json:"totalSize"`
}

// RuntimeGetProperties Returns properties of a given object. Object group of the result is inherited from the target
// object.
type RuntimeGetProperties struct {

	// ObjectID Identifier of the object to return properties for.
	ObjectID RuntimeRemoteObjectID `json:"objectId"`

	// OwnProperties (optional) If true, returns properties belonging only to the element itself, not to its prototype
	// chain.
	OwnProperties bool `json:"ownProperties,omitempty"`

	// AccessorPropertiesOnly (experimental) (optional) If true, returns accessor properties (with getter/setter) only; internal properties are not
	// returned either.
	AccessorPropertiesOnly bool `json:"accessorPropertiesOnly,omitempty"`

	// GeneratePreview (experimental) (optional) Whether preview should be generated for the results.
	GeneratePreview bool `json:"generatePreview,omitempty"`

	// NonIndexedPropertiesOnly (experimental) (optional) If true, returns non-indexed properties only.
	NonIndexedPropertiesOnly bool `json:"nonIndexedPropertiesOnly,omitempty"`
}

// ProtoReq name
func (m RuntimeGetProperties) ProtoReq() string { return "Runtime.getProperties" }

// Call the request
func (m RuntimeGetProperties) Call(c Client) (*RuntimeGetPropertiesResult, error) {
	var res RuntimeGetPropertiesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeGetPropertiesResult ...
type RuntimeGetPropertiesResult struct {

	// Result Object properties.
	Result []*RuntimePropertyDescriptor `json:"result"`

	// InternalProperties (optional) Internal object properties (only of the element itself).
	InternalProperties []*RuntimeInternalPropertyDescriptor `json:"internalProperties,omitempty"`

	// PrivateProperties (experimental) (optional) Object private properties.
	PrivateProperties []*RuntimePrivatePropertyDescriptor `json:"privateProperties,omitempty"`

	// ExceptionDetails (optional) Exception details.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// RuntimeGlobalLexicalScopeNames Returns all let, const and class variables from global scope.
type RuntimeGlobalLexicalScopeNames struct {

	// ExecutionContextID (optional) Specifies in which execution context to lookup global scope variables.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`
}

// ProtoReq name
func (m RuntimeGlobalLexicalScopeNames) ProtoReq() string { return "Runtime.globalLexicalScopeNames" }

// Call the request
func (m RuntimeGlobalLexicalScopeNames) Call(c Client) (*RuntimeGlobalLexicalScopeNamesResult, error) {
	var res RuntimeGlobalLexicalScopeNamesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeGlobalLexicalScopeNamesResult ...
type RuntimeGlobalLexicalScopeNamesResult struct {

	// Names ...
	Names []string `json:"names"`
}

// RuntimeQueryObjects ...
type RuntimeQueryObjects struct {

	// PrototypeObjectID Identifier of the prototype to return objects for.
	PrototypeObjectID RuntimeRemoteObjectID `json:"prototypeObjectId"`

	// ObjectGroup (optional) Symbolic group name that can be used to release the results.
	ObjectGroup string `json:"objectGroup,omitempty"`
}

// ProtoReq name
func (m RuntimeQueryObjects) ProtoReq() string { return "Runtime.queryObjects" }

// Call the request
func (m RuntimeQueryObjects) Call(c Client) (*RuntimeQueryObjectsResult, error) {
	var res RuntimeQueryObjectsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeQueryObjectsResult ...
type RuntimeQueryObjectsResult struct {

	// Objects Array with objects.
	Objects *RuntimeRemoteObject `json:"objects"`
}

// RuntimeReleaseObject Releases remote object with given id.
type RuntimeReleaseObject struct {

	// ObjectID Identifier of the object to release.
	ObjectID RuntimeRemoteObjectID `json:"objectId"`
}

// ProtoReq name
func (m RuntimeReleaseObject) ProtoReq() string { return "Runtime.releaseObject" }

// Call sends the request
func (m RuntimeReleaseObject) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeReleaseObjectGroup Releases all remote objects that belong to a given group.
type RuntimeReleaseObjectGroup struct {

	// ObjectGroup Symbolic object group name.
	ObjectGroup string `json:"objectGroup"`
}

// ProtoReq name
func (m RuntimeReleaseObjectGroup) ProtoReq() string { return "Runtime.releaseObjectGroup" }

// Call sends the request
func (m RuntimeReleaseObjectGroup) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeRunIfWaitingForDebugger Tells inspected instance to run if it was waiting for debugger to attach.
type RuntimeRunIfWaitingForDebugger struct {
}

// ProtoReq name
func (m RuntimeRunIfWaitingForDebugger) ProtoReq() string { return "Runtime.runIfWaitingForDebugger" }

// Call sends the request
func (m RuntimeRunIfWaitingForDebugger) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeRunScript Runs script with given id in a given context.
type RuntimeRunScript struct {

	// ScriptID Id of the script to run.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// ExecutionContextID (optional) Specifies in which execution context to perform script run. If the parameter is omitted the
	// evaluation will be performed in the context of the inspected page.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`

	// ObjectGroup (optional) Symbolic group name that can be used to release multiple objects.
	ObjectGroup string `json:"objectGroup,omitempty"`

	// Silent (optional) In silent mode exceptions thrown during evaluation are not reported and do not pause
	// execution. Overrides `setPauseOnException` state.
	Silent bool `json:"silent,omitempty"`

	// IncludeCommandLineAPI (optional) Determines whether Command Line API should be available during the evaluation.
	IncludeCommandLineAPI bool `json:"includeCommandLineAPI,omitempty"`

	// ReturnByValue (optional) Whether the result is expected to be a JSON object which should be sent by value.
	ReturnByValue bool `json:"returnByValue,omitempty"`

	// GeneratePreview (optional) Whether preview should be generated for the result.
	GeneratePreview bool `json:"generatePreview,omitempty"`

	// AwaitPromise (optional) Whether execution should `await` for resulting value and return once awaited promise is
	// resolved.
	AwaitPromise bool `json:"awaitPromise,omitempty"`
}

// ProtoReq name
func (m RuntimeRunScript) ProtoReq() string { return "Runtime.runScript" }

// Call the request
func (m RuntimeRunScript) Call(c Client) (*RuntimeRunScriptResult, error) {
	var res RuntimeRunScriptResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeRunScriptResult ...
type RuntimeRunScriptResult struct {

	// Result Run result.
	Result *RuntimeRemoteObject `json:"result"`

	// ExceptionDetails (optional) Exception details.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// RuntimeSetAsyncCallStackDepth Enables or disables async call stacks tracking.
type RuntimeSetAsyncCallStackDepth struct {

	// MaxDepth Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async
	// call stacks (default).
	MaxDepth int `json:"maxDepth"`
}

// ProtoReq name
func (m RuntimeSetAsyncCallStackDepth) ProtoReq() string { return "Runtime.setAsyncCallStackDepth" }

// Call sends the request
func (m RuntimeSetAsyncCallStackDepth) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeSetCustomObjectFormatterEnabled (experimental) ...
type RuntimeSetCustomObjectFormatterEnabled struct {

	// Enabled ...
	Enabled bool `json:"enabled"`
}

// ProtoReq name
func (m RuntimeSetCustomObjectFormatterEnabled) ProtoReq() string {
	return "Runtime.setCustomObjectFormatterEnabled"
}

// Call sends the request
func (m RuntimeSetCustomObjectFormatterEnabled) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeSetMaxCallStackSizeToCapture (experimental) ...
type RuntimeSetMaxCallStackSizeToCapture struct {

	// Size ...
	Size int `json:"size"`
}

// ProtoReq name
func (m RuntimeSetMaxCallStackSizeToCapture) ProtoReq() string {
	return "Runtime.setMaxCallStackSizeToCapture"
}

// Call sends the request
func (m RuntimeSetMaxCallStackSizeToCapture) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeTerminateExecution (experimental) Terminate current or next JavaScript execution.
// Will cancel the termination when the outer-most script execution ends.
type RuntimeTerminateExecution struct {
}

// ProtoReq name
func (m RuntimeTerminateExecution) ProtoReq() string { return "Runtime.terminateExecution" }

// Call sends the request
func (m RuntimeTerminateExecution) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeAddBinding (experimental) If executionContextId is empty, adds binding with the given name on the
// global objects of all inspected contexts, including those created later,
// bindings survive reloads.
// Binding function takes exactly one argument, this argument should be string,
// in case of any other input, function throws an exception.
// Each binding function call produces Runtime.bindingCalled notification.
type RuntimeAddBinding struct {

	// Name ...
	Name string `json:"name"`

	// ExecutionContextID (deprecated) (optional) If specified, the binding would only be exposed to the specified
	// execution context. If omitted and `executionContextName` is not set,
	// the binding is exposed to all execution contexts of the target.
	// This parameter is mutually exclusive with `executionContextName`.
	// Deprecated in favor of `executionContextName` due to an unclear use case
	// and bugs in implementation (crbug.com/1169639). `executionContextId` will be
	// removed in the future.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`

	// ExecutionContextName (experimental) (optional) If specified, the binding is exposed to the executionContext with
	// matching name, even for contexts created after the binding is added.
	// See also `ExecutionContext.name` and `worldName` parameter to
	// `Page.addScriptToEvaluateOnNewDocument`.
	// This parameter is mutually exclusive with `executionContextId`.
	ExecutionContextName string `json:"executionContextName,omitempty"`
}

// ProtoReq name
func (m RuntimeAddBinding) ProtoReq() string { return "Runtime.addBinding" }

// Call sends the request
func (m RuntimeAddBinding) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeRemoveBinding (experimental) This method does not remove binding function from global object but
// unsubscribes current runtime agent from Runtime.bindingCalled notifications.
type RuntimeRemoveBinding struct {

	// Name ...
	Name string `json:"name"`
}

// ProtoReq name
func (m RuntimeRemoveBinding) ProtoReq() string { return "Runtime.removeBinding" }

// Call sends the request
func (m RuntimeRemoveBinding) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// RuntimeGetExceptionDetails (experimental) This method tries to lookup and populate exception details for a
// JavaScript Error object.
// Note that the stackTrace portion of the resulting exceptionDetails will
// only be populated if the Runtime domain was enabled at the time when the
// Error was thrown.
type RuntimeGetExceptionDetails struct {

	// ErrorObjectID The error object for which to resolve the exception details.
	ErrorObjectID RuntimeRemoteObjectID `json:"errorObjectId"`
}

// ProtoReq name
func (m RuntimeGetExceptionDetails) ProtoReq() string { return "Runtime.getExceptionDetails" }

// Call the request
func (m RuntimeGetExceptionDetails) Call(c Client) (*RuntimeGetExceptionDetailsResult, error) {
	var res RuntimeGetExceptionDetailsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// RuntimeGetExceptionDetailsResult (experimental) ...
type RuntimeGetExceptionDetailsResult struct {

	// ExceptionDetails (optional) ...
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// RuntimeBindingCalled (experimental) Notification is issued every time when binding is called.
type RuntimeBindingCalled struct {

	// Name ...
	Name string `json:"name"`

	// Payload ...
	Payload string `json:"payload"`

	// ExecutionContextID Identifier of the context where the call was made.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId"`
}

// ProtoEvent name
func (evt RuntimeBindingCalled) ProtoEvent() string {
	return "Runtime.bindingCalled"
}

// RuntimeConsoleAPICalledType enum
type RuntimeConsoleAPICalledType string

const (
	// RuntimeConsoleAPICalledTypeLog enum const
	RuntimeConsoleAPICalledTypeLog RuntimeConsoleAPICalledType = "log"

	// RuntimeConsoleAPICalledTypeDebug enum const
	RuntimeConsoleAPICalledTypeDebug RuntimeConsoleAPICalledType = "debug"

	// RuntimeConsoleAPICalledTypeInfo enum const
	RuntimeConsoleAPICalledTypeInfo RuntimeConsoleAPICalledType = "info"

	// RuntimeConsoleAPICalledTypeError enum const
	RuntimeConsoleAPICalledTypeError RuntimeConsoleAPICalledType = "error"

	// RuntimeConsoleAPICalledTypeWarning enum const
	RuntimeConsoleAPICalledTypeWarning RuntimeConsoleAPICalledType = "warning"

	// RuntimeConsoleAPICalledTypeDir enum const
	RuntimeConsoleAPICalledTypeDir RuntimeConsoleAPICalledType = "dir"

	// RuntimeConsoleAPICalledTypeDirxml enum const
	RuntimeConsoleAPICalledTypeDirxml RuntimeConsoleAPICalledType = "dirxml"

	// RuntimeConsoleAPICalledTypeTable enum const
	RuntimeConsoleAPICalledTypeTable RuntimeConsoleAPICalledType = "table"

	// RuntimeConsoleAPICalledTypeTrace enum const
	RuntimeConsoleAPICalledTypeTrace RuntimeConsoleAPICalledType = "trace"

	// RuntimeConsoleAPICalledTypeClear enum const
	RuntimeConsoleAPICalledTypeClear RuntimeConsoleAPICalledType = "clear"

	// RuntimeConsoleAPICalledTypeStartGroup enum const
	RuntimeConsoleAPICalledTypeStartGroup RuntimeConsoleAPICalledType = "startGroup"

	// RuntimeConsoleAPICalledTypeStartGroupCollapsed enum const
	RuntimeConsoleAPICalledTypeStartGroupCollapsed RuntimeConsoleAPICalledType = "startGroupCollapsed"

	// RuntimeConsoleAPICalledTypeEndGroup enum const
	RuntimeConsoleAPICalledTypeEndGroup RuntimeConsoleAPICalledType = "endGroup"

	// RuntimeConsoleAPICalledTypeAssert enum const
	RuntimeConsoleAPICalledTypeAssert RuntimeConsoleAPICalledType = "assert"

	// RuntimeConsoleAPICalledTypeProfile enum const
	RuntimeConsoleAPICalledTypeProfile RuntimeConsoleAPICalledType = "profile"

	// RuntimeConsoleAPICalledTypeProfileEnd enum const
	RuntimeConsoleAPICalledTypeProfileEnd RuntimeConsoleAPICalledType = "profileEnd"

	// RuntimeConsoleAPICalledTypeCount enum const
	RuntimeConsoleAPICalledTypeCount RuntimeConsoleAPICalledType = "count"

	// RuntimeConsoleAPICalledTypeTimeEnd enum const
	RuntimeConsoleAPICalledTypeTimeEnd RuntimeConsoleAPICalledType = "timeEnd"
)

// RuntimeConsoleAPICalled Issued when console API was called.
type RuntimeConsoleAPICalled struct {

	// Type Type of the call.
	Type RuntimeConsoleAPICalledType `json:"type"`

	// Args Call arguments.
	Args []*RuntimeRemoteObject `json:"args"`

	// ExecutionContextID Identifier of the context where the call was made.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId"`

	// Timestamp Call timestamp.
	Timestamp RuntimeTimestamp `json:"timestamp"`

	// StackTrace (optional) Stack trace captured when the call was made. The async stack chain is automatically reported for
	// the following call types: `assert`, `error`, `trace`, `warning`. For other types the async call
	// chain can be retrieved using `Debugger.getStackTrace` and `stackTrace.parentId` field.
	StackTrace *RuntimeStackTrace `json:"stackTrace,omitempty"`

	// Context (experimental) (optional) Console context descriptor for calls on non-default console context (not console.*):
	// 'anonymous#unique-logger-id' for call on unnamed context, 'name#unique-logger-id' for call
	// on named context.
	Context string `json:"context,omitempty"`
}

// ProtoEvent name
func (evt RuntimeConsoleAPICalled) ProtoEvent() string {
	return "Runtime.consoleAPICalled"
}

// RuntimeExceptionRevoked Issued when unhandled exception was revoked.
type RuntimeExceptionRevoked struct {

	// Reason Reason describing why exception was revoked.
	Reason string `json:"reason"`

	// ExceptionID The id of revoked exception, as reported in `exceptionThrown`.
	ExceptionID int `json:"exceptionId"`
}

// ProtoEvent name
func (evt RuntimeExceptionRevoked) ProtoEvent() string {
	return "Runtime.exceptionRevoked"
}

// RuntimeExceptionThrown Issued when exception was thrown and unhandled.
type RuntimeExceptionThrown struct {

	// Timestamp Timestamp of the exception.
	Timestamp RuntimeTimestamp `json:"timestamp"`

	// ExceptionDetails ...
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails"`
}

// ProtoEvent name
func (evt RuntimeExceptionThrown) ProtoEvent() string {
	return "Runtime.exceptionThrown"
}

// RuntimeExecutionContextCreated Issued when new execution context is created.
type RuntimeExecutionContextCreated struct {

	// Context A newly created execution context.
	Context *RuntimeExecutionContextDescription `json:"context"`
}

// ProtoEvent name
func (evt RuntimeExecutionContextCreated) ProtoEvent() string {
	return "Runtime.executionContextCreated"
}

// RuntimeExecutionContextDestroyed Issued when execution context is destroyed.
type RuntimeExecutionContextDestroyed struct {

	// ExecutionContextID (deprecated) Id of the destroyed context
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId"`

	// ExecutionContextUniqueID (experimental) Unique Id of the destroyed context
	ExecutionContextUniqueID string `json:"executionContextUniqueId"`
}

// ProtoEvent name
func (evt RuntimeExecutionContextDestroyed) ProtoEvent() string {
	return "Runtime.executionContextDestroyed"
}

// RuntimeExecutionContextsCleared Issued when all executionContexts were cleared in browser
type RuntimeExecutionContextsCleared struct {
}

// ProtoEvent name
func (evt RuntimeExecutionContextsCleared) ProtoEvent() string {
	return "Runtime.executionContextsCleared"
}

// RuntimeInspectRequested Issued when object should be inspected (for example, as a result of inspect() command line API
// call).
type RuntimeInspectRequested struct {

	// Object ...
	Object *RuntimeRemoteObject `json:"object"`

	// Hints ...
	Hints map[string]gson.JSON `json:"hints"`

	// ExecutionContextID (experimental) (optional) Identifier of the context where the call was made.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId,omitempty"`
}

// ProtoEvent name
func (evt RuntimeInspectRequested) ProtoEvent() string {
	return "Runtime.inspectRequested"
}
