// This file is generated by "./lib/proto/generate"

package proto

/*

CacheStorage

*/

// CacheStorageCacheID Unique identifier of the Cache object.
type CacheStorageCacheID string

// CacheStorageCachedResponseType type of HTTP response cached
type CacheStorageCachedResponseType string

const (
	// CacheStorageCachedResponseTypeBasic enum const
	CacheStorageCachedResponseTypeBasic CacheStorageCachedResponseType = "basic"

	// CacheStorageCachedResponseTypeCors enum const
	CacheStorageCachedResponseTypeCors CacheStorageCachedResponseType = "cors"

	// CacheStorageCachedResponseTypeDefault enum const
	CacheStorageCachedResponseTypeDefault CacheStorageCachedResponseType = "default"

	// CacheStorageCachedResponseTypeError enum const
	CacheStorageCachedResponseTypeError CacheStorageCachedResponseType = "error"

	// CacheStorageCachedResponseTypeOpaqueResponse enum const
	CacheStorageCachedResponseTypeOpaqueResponse CacheStorageCachedResponseType = "opaqueResponse"

	// CacheStorageCachedResponseTypeOpaqueRedirect enum const
	CacheStorageCachedResponseTypeOpaqueRedirect CacheStorageCachedResponseType = "opaqueRedirect"
)

// CacheStorageDataEntry Data entry.
type CacheStorageDataEntry struct {

	// RequestURL Request URL.
	RequestURL string `json:"requestURL"`

	// RequestMethod Request method.
	RequestMethod string `json:"requestMethod"`

	// RequestHeaders Request headers
	RequestHeaders []*CacheStorageHeader `json:"requestHeaders"`

	// ResponseTime Number of seconds since epoch.
	ResponseTime float64 `json:"responseTime"`

	// ResponseStatus HTTP response status code.
	ResponseStatus int `json:"responseStatus"`

	// ResponseStatusText HTTP response status text.
	ResponseStatusText string `json:"responseStatusText"`

	// ResponseType HTTP response type
	ResponseType CacheStorageCachedResponseType `json:"responseType"`

	// ResponseHeaders Response headers
	ResponseHeaders []*CacheStorageHeader `json:"responseHeaders"`
}

// CacheStorageCache Cache identifier.
type CacheStorageCache struct {

	// CacheID An opaque unique id of the cache.
	CacheID CacheStorageCacheID `json:"cacheId"`

	// SecurityOrigin Security origin of the cache.
	SecurityOrigin string `json:"securityOrigin"`

	// StorageKey Storage key of the cache.
	StorageKey string `json:"storageKey"`

	// CacheName The name of the cache.
	CacheName string `json:"cacheName"`
}

// CacheStorageHeader ...
type CacheStorageHeader struct {

	// Name ...
	Name string `json:"name"`

	// Value ...
	Value string `json:"value"`
}

// CacheStorageCachedResponse Cached response
type CacheStorageCachedResponse struct {

	// Body Entry content, base64-encoded.
	Body []byte `json:"body"`
}

// CacheStorageDeleteCache Deletes a cache.
type CacheStorageDeleteCache struct {

	// CacheID Id of cache for deletion.
	CacheID CacheStorageCacheID `json:"cacheId"`
}

// ProtoReq name
func (m CacheStorageDeleteCache) ProtoReq() string { return "CacheStorage.deleteCache" }

// Call sends the request
func (m CacheStorageDeleteCache) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CacheStorageDeleteEntry Deletes a cache entry.
type CacheStorageDeleteEntry struct {

	// CacheID Id of cache where the entry will be deleted.
	CacheID CacheStorageCacheID `json:"cacheId"`

	// Request URL spec of the request.
	Request string `json:"request"`
}

// ProtoReq name
func (m CacheStorageDeleteEntry) ProtoReq() string { return "CacheStorage.deleteEntry" }

// Call sends the request
func (m CacheStorageDeleteEntry) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// CacheStorageRequestCacheNames Requests cache names.
type CacheStorageRequestCacheNames struct {

	// SecurityOrigin (optional) At least and at most one of securityOrigin, storageKey must be specified.
	// Security origin.
	SecurityOrigin string `json:"securityOrigin,omitempty"`

	// StorageKey (optional) Storage key.
	StorageKey string `json:"storageKey,omitempty"`
}

// ProtoReq name
func (m CacheStorageRequestCacheNames) ProtoReq() string { return "CacheStorage.requestCacheNames" }

// Call the request
func (m CacheStorageRequestCacheNames) Call(c Client) (*CacheStorageRequestCacheNamesResult, error) {
	var res CacheStorageRequestCacheNamesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CacheStorageRequestCacheNamesResult ...
type CacheStorageRequestCacheNamesResult struct {

	// Caches Caches for the security origin.
	Caches []*CacheStorageCache `json:"caches"`
}

// CacheStorageRequestCachedResponse Fetches cache entry.
type CacheStorageRequestCachedResponse struct {

	// CacheID Id of cache that contains the entry.
	CacheID CacheStorageCacheID `json:"cacheId"`

	// RequestURL URL spec of the request.
	RequestURL string `json:"requestURL"`

	// RequestHeaders headers of the request.
	RequestHeaders []*CacheStorageHeader `json:"requestHeaders"`
}

// ProtoReq name
func (m CacheStorageRequestCachedResponse) ProtoReq() string {
	return "CacheStorage.requestCachedResponse"
}

// Call the request
func (m CacheStorageRequestCachedResponse) Call(c Client) (*CacheStorageRequestCachedResponseResult, error) {
	var res CacheStorageRequestCachedResponseResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CacheStorageRequestCachedResponseResult ...
type CacheStorageRequestCachedResponseResult struct {

	// Response Response read from the cache.
	Response *CacheStorageCachedResponse `json:"response"`
}

// CacheStorageRequestEntries Requests data from cache.
type CacheStorageRequestEntries struct {

	// CacheID ID of cache to get entries from.
	CacheID CacheStorageCacheID `json:"cacheId"`

	// SkipCount (optional) Number of records to skip.
	SkipCount *int `json:"skipCount,omitempty"`

	// PageSize (optional) Number of records to fetch.
	PageSize *int `json:"pageSize,omitempty"`

	// PathFilter (optional) If present, only return the entries containing this substring in the path
	PathFilter string `json:"pathFilter,omitempty"`
}

// ProtoReq name
func (m CacheStorageRequestEntries) ProtoReq() string { return "CacheStorage.requestEntries" }

// Call the request
func (m CacheStorageRequestEntries) Call(c Client) (*CacheStorageRequestEntriesResult, error) {
	var res CacheStorageRequestEntriesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// CacheStorageRequestEntriesResult ...
type CacheStorageRequestEntriesResult struct {

	// CacheDataEntries Array of object store data entries.
	CacheDataEntries []*CacheStorageDataEntry `json:"cacheDataEntries"`

	// ReturnCount Count of returned entries from this storage. If pathFilter is empty, it
	// is the count of all entries from this storage.
	ReturnCount float64 `json:"returnCount"`
}
