# Documentation and Guides

If you’re experiencing an issue with IPFS, **please follow [our issue guide](github-issue-guide.md) when filing an issue!**

Otherwise, check out the following guides to using and developing IPFS:


## General Usage

- [Transferring a File Over IPFS](file-transfer.md)
- [Configuration reference](config.md)
    - [Datastore configuration](datastores.md)
    - [Experimental features](experimental-features.md)
- [Installing command completion](command-completion.md)
- [Mounting IPFS with FUSE](fuse.md)
- [Installing plugins](plugins.md)


## API Support

- [How to Implement an API Client](implement-api-bindings.md)
- [Connecting with Websockets](transports.md) — if you want `js-ipfs` nodes in web browsers to connect to your `go-ipfs` node, you will need to turn on websocket support in your `go-ipfs` node.


## Developing `go-ipfs`

- Building on…
    - [Windows](windows.md)
    - [OpenBSD](openbsd.md)
- [Performance Debugging Guidelines](debug-guide.md)
- [Release Checklist](releases.md)


## Other

- [Thanks to all our contributors ❤️](AUTHORS) (We use the `generate-authors.sh` script to regenerate this list.)
- [How to file a GitHub Issue](github-issue-guide.md)
