// borrowed from https://github.com/hashicorp/serf/blob/master/command/agent/flag_slice_value.go

package main

import "strings"

// AppendSliceValue implements the flag.Value interface and allows multiple
// calls to the same variable to append a list.
type AppendSliceValue []string

func (s *AppendSliceValue) String() string {
	return strings.Join(*s, ",")
}

//
// Set will add another argument value to slice.
//
func (s *AppendSliceValue) Set(value string) error {
	if *s == nil {
		*s = make([]string, 0, 1)
	}

	*s = append(*s, value)
	return nil
}
