package api

/************************************************
  generated by IDE. for [ProductPrivateHostAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *ProductPrivateHostAPI) Reset() *ProductPrivateHostAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *ProductPrivateHostAPI) Offset(offset int) *ProductPrivateHostAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *ProductPrivateHostAPI) Limit(limit int) *ProductPrivateHostAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *ProductPrivateHostAPI) Include(key string) *ProductPrivateHostAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *ProductPrivateHostAPI) Exclude(key string) *ProductPrivateHostAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *ProductPrivateHostAPI) FilterBy(key string, value interface{}) *ProductPrivateHostAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ProductPrivateHostAPI) FilterMultiBy(key string, value interface{}) *ProductPrivateHostAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *ProductPrivateHostAPI) WithNameLike(name string) *ProductPrivateHostAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *ProductPrivateHostAPI) WithTag(tag string) *ProductPrivateHostAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *ProductPrivateHostAPI) WithTags(tags []string) *ProductPrivateHostAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ProductPrivateHostAPI) WithSizeGib(size int) *ProductPrivateHostAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *ProductPrivateHostAPI) WithSharedScope() *ProductPrivateHostAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *ProductPrivateHostAPI) WithUserScope() *ProductPrivateHostAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *ProductPrivateHostAPI) SortBy(key string, reverse bool) *ProductPrivateHostAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *ProductPrivateHostAPI) SortByName(reverse bool) *ProductPrivateHostAPI {
	api.sortByName(reverse)
	return api
}

// func (api *ProductPrivateHostAPI) SortBySize(reverse bool) *ProductPrivateHostAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *ProductPrivateHostAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *ProductPrivateHostAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *ProductPrivateHostAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *ProductPrivateHostAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *ProductPrivateHostAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *ProductPrivateHostAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ProductPrivateHostAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *ProductPrivateHostAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *ProductPrivateHostAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *ProductPrivateHostAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ProductPrivateHostAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *ProductPrivateHostAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *ProductPrivateHostAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *ProductPrivateHostAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *ProductPrivateHostAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *ProductPrivateHostAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

//func (api *ProductPrivateHostAPI) New() *sacloud.ProductPrivateHost {
//	return &sacloud.ProductPrivateHost{}
//}

// func (api *ProductPrivateHostAPI) Create(value *sacloud.ProductPrivateHost) (*sacloud.ProductPrivateHost, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.create(api.createRequest(value), res)
// 	})
// }

// Read 読み取り
func (api *ProductPrivateHostAPI) Read(id int64) (*sacloud.ProductPrivateHost, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// func (api *ProductPrivateHostAPI) Update(id int64, value *sacloud.ProductPrivateHost) (*sacloud.ProductPrivateHost, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.update(id, api.createRequest(value), res)
// 	})
// }

// func (api *ProductPrivateHostAPI) Delete(id int64) (*sacloud.ProductPrivateHost, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.delete(id, nil, res)
// 	})
// }

/************************************************
  Inner functions
************************************************/

func (api *ProductPrivateHostAPI) setStateValue(setFunc func(*sacloud.Request)) *ProductPrivateHostAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *ProductPrivateHostAPI) request(f func(*sacloud.Response) error) (*sacloud.ProductPrivateHost, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.PrivateHostPlan, nil
}

func (api *ProductPrivateHostAPI) createRequest(value *sacloud.ProductPrivateHost) *sacloud.Request {
	req := &sacloud.Request{}
	req.PrivateHostPlan = value
	return req
}
