import type {SidebarsConfig} from '@docusaurus/plugin-content-docs';

/**
 * Creating a sidebar enables you to:
 - create an ordered group of docs
 - render a sidebar for each doc of that group
 - provide next/previous navigation

 The sidebars can be generated from the filesystem, or explicitly defined here.

 Create as many sidebars as you want.
 */
const sidebars: SidebarsConfig = {
  // By default, Docusaurus generates a sidebar from the docs folder structure
  docs: [
    'index',
    {
      type: 'category',
      label: 'Getting started',
      items: [
        {
          type: 'autogenerated',
          dirName: '02_getting-started',
        },
      ],
    },
    {
      type: 'category',
      label: 'Components',
      items: [
        {
          type: 'autogenerated',
          dirName: '03_components',
        },
      ],
    },
    {
      type: 'category',
      label: 'Integration',
      items: [
        {
          type: 'autogenerated',
          dirName: '04_integration',
        },
      ],
    },
    {
      type: 'category',
      label: 'Design',
      items: [
        {
          type: 'autogenerated',
          dirName: '05_design',
        },
      ],
    },
    {
      type: 'category',
      label: 'Comparisons',
      items: [
        {
          type: 'autogenerated',
          dirName: '06_comparisons',
        },
      ],
    },
    // {type: 'autogenerated', dirName: '.'}
  ],

  // But you can create a sidebar manually
  /*
  tutorialSidebar: [
    'intro',
    'hello',
    {
      type: 'category',
      label: 'Tutorial',
      items: ['tutorial-basics/create-a-document'],
    },
  ],
   */
};

export default sidebars;
