// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

package videointelligence // import "google.golang.org/genproto/googleapis/cloud/videointelligence/v1p1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	6: "SPEECH_TRANSCRIPTION",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"SPEECH_TRANSCRIPTION":       6,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1p1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{0}
}
func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(dst, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                   `json:"-"`
	XXX_unrecognized          []byte                     `json:"-"`
	XXX_sizecache             int32                      `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{1}
}
func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (dst *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(dst, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1p1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{2}
}
func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(dst, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{3}
}
func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(dst, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{4}
}
func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(dst, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{5}
}
func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (dst *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(dst, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{6}
}
func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (dst *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(dst, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{7}
}
func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (dst *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(dst, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{8}
}
func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (dst *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(dst, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{9}
}
func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (dst *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(dst, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1p1beta1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{10}
}
func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(dst, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{11}
}
func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(dst, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Output only. Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// Output only. If set, indicates an error. Note that for a single
	// `AnnotateVideoRequest` some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{12}
}
func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(dst, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{13}
}
func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(dst, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Output only. Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Output only. Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{14}
}
func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(dst, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{15}
}
func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(dst, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// *Optional* Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// *Optional* If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// *Optional* A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// *Optional* If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// *Optional* For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks          []int32  `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscriptionConfig) Reset()         { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()    {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{16}
}
func (m *SpeechTranscriptionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscriptionConfig.Unmarshal(m, b)
}
func (m *SpeechTranscriptionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscriptionConfig.Marshal(b, m, deterministic)
}
func (dst *SpeechTranscriptionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscriptionConfig.Merge(dst, src)
}
func (m *SpeechTranscriptionConfig) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscriptionConfig.Size(m)
}
func (m *SpeechTranscriptionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscriptionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscriptionConfig proto.InternalMessageInfo

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if m != nil {
		return m.EnableAutomaticPunctuation
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// *Optional* A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{17}
}
func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (dst *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(dst, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// Output only. May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives         []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SpeechTranscription) Reset()         { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()    {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{18}
}
func (m *SpeechTranscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscription.Unmarshal(m, b)
}
func (m *SpeechTranscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscription.Marshal(b, m, deterministic)
}
func (dst *SpeechTranscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscription.Merge(dst, src)
}
func (m *SpeechTranscription) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscription.Size(m)
}
func (m *SpeechTranscription) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscription.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscription proto.InternalMessageInfo

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Output only. Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is typically provided only for the top hypothesis, and
	// only for `is_final=true` results. Clients should not rely on the
	// `confidence` field as it is not guaranteed to be accurate or consistent.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{19}
}
func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (dst *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(dst, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The word corresponding to this set of information.
	Word                 string   `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_de2dfee67bcd43cb, []int{20}
}
func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (dst *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(dst, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p1beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p1beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p1beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p1beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p1beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1p1beta1.WordInfo")
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Likelihood", Likelihood_name, Likelihood_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p1beta1/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p1beta1/video_intelligence.proto", fileDescriptor_video_intelligence_de2dfee67bcd43cb)
}

var fileDescriptor_video_intelligence_de2dfee67bcd43cb = []byte{
	// 1807 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xcd, 0x6f, 0x23, 0x49,
	0x15, 0xa7, 0xed, 0xc4, 0x89, 0x9f, 0x9d, 0xd8, 0x53, 0x71, 0x12, 0x27, 0x3b, 0x93, 0xc9, 0xf6,
	0x82, 0x94, 0x1d, 0x90, 0x4d, 0xc2, 0x6a, 0x61, 0x67, 0x61, 0xb5, 0x8e, 0xd3, 0xd9, 0x58, 0x64,
	0x62, 0xab, 0xec, 0x09, 0x0c, 0x0c, 0x6a, 0x3a, 0xdd, 0xe5, 0x4e, 0x33, 0xed, 0xae, 0xde, 0xee,
	0xea, 0x30, 0x73, 0x5b, 0x3e, 0x24, 0x90, 0x40, 0x5c, 0x46, 0x48, 0xfc, 0x09, 0x88, 0x23, 0xff,
	0x00, 0x17, 0x2e, 0x70, 0xe5, 0x84, 0x04, 0x37, 0xfe, 0x0b, 0x2e, 0xab, 0xae, 0xaa, 0xb6, 0xdb,
	0x76, 0xbe, 0x9c, 0xdc, 0xdc, 0xef, 0xe3, 0xf7, 0x3e, 0xea, 0xd5, 0x7b, 0xaf, 0x0c, 0x0d, 0x9b,
	0x52, 0xdb, 0x25, 0x75, 0xd3, 0xa5, 0x91, 0x55, 0xbf, 0x70, 0x2c, 0x42, 0x1d, 0x8f, 0x11, 0xd7,
	0x75, 0x6c, 0xe2, 0x99, 0xa4, 0x7e, 0xb1, 0xeb, 0xef, 0x9e, 0x11, 0x66, 0xec, 0x0a, 0x9e, 0x9e,
	0x66, 0xd6, 0xfc, 0x80, 0x32, 0x8a, 0x76, 0x04, 0x44, 0x8d, 0x43, 0xd4, 0xa6, 0x20, 0x6a, 0x43,
	0x88, 0xcd, 0x87, 0xd2, 0x98, 0xe1, 0x3b, 0x75, 0xc3, 0xf3, 0x28, 0x33, 0x98, 0x43, 0xbd, 0x50,
	0xe0, 0x6c, 0xbe, 0x27, 0xb9, 0x2e, 0xf5, 0xec, 0x20, 0xf2, 0x3c, 0xc7, 0xb3, 0xeb, 0xd4, 0x27,
	0xc1, 0x98, 0xd0, 0x96, 0x14, 0xe2, 0x5f, 0x67, 0x51, 0xbf, 0x6e, 0x45, 0x42, 0x40, 0xf2, 0x1f,
	0x4f, 0xf2, 0x99, 0x33, 0x20, 0x21, 0x33, 0x06, 0xbe, 0x14, 0x58, 0x97, 0x02, 0x81, 0x6f, 0xd6,
	0x43, 0x66, 0xb0, 0x48, 0x22, 0xab, 0x7f, 0xcf, 0x40, 0xa5, 0x21, 0x9c, 0x22, 0xa7, 0x71, 0x10,
	0x98, 0x7c, 0x1e, 0x91, 0x90, 0xa1, 0x77, 0x20, 0xef, 0x78, 0x7e, 0xc4, 0xf4, 0x28, 0x70, 0xaa,
	0xca, 0xb6, 0xb2, 0x93, 0xc7, 0x8b, 0x9c, 0xf0, 0x3c, 0x70, 0xd0, 0x7b, 0xb0, 0x24, 0x98, 0x26,
	0xf5, 0x18, 0xf1, 0x58, 0x35, 0xb7, 0xad, 0xec, 0x14, 0x71, 0x91, 0x13, 0x9b, 0x82, 0x86, 0x9e,
	0xc1, 0x62, 0x9f, 0x18, 0x2c, 0x0a, 0x48, 0x58, 0xcd, 0x6c, 0x67, 0x77, 0x96, 0xf7, 0x76, 0x6b,
	0xb7, 0x4d, 0x5a, 0xed, 0x50, 0x68, 0xe2, 0x21, 0x04, 0xfa, 0x31, 0x2c, 0x89, 0xc3, 0xe0, 0x36,
	0x5f, 0xb3, 0x6a, 0x76, 0x5b, 0xd9, 0x29, 0xec, 0x7d, 0x78, 0x7b, 0x4c, 0x1e, 0x5f, 0x53, 0x68,
	0xe3, 0xe2, 0x45, 0xea, 0x0b, 0x3d, 0x02, 0xa0, 0x11, 0x4b, 0xc2, 0x9d, 0xe3, 0xe1, 0xe6, 0x05,
	0x25, 0x8e, 0xf7, 0x31, 0x14, 0x5c, 0x6a, 0xf2, 0x8c, 0xeb, 0x8e, 0x55, 0x9d, 0xe7, 0x7c, 0x48,
	0x48, 0x2d, 0x4b, 0xfd, 0xff, 0x1c, 0x14, 0xd3, 0xf0, 0x08, 0xc3, 0x62, 0x48, 0xec, 0x01, 0xf1,
	0x58, 0x58, 0x55, 0xb6, 0xb3, 0x77, 0x70, 0xb4, 0x2b, 0xd4, 0xf1, 0x10, 0x07, 0x31, 0x58, 0x73,
	0x8d, 0x33, 0xe2, 0xea, 0x16, 0x61, 0xc4, 0xe4, 0xce, 0x98, 0xd4, 0xeb, 0x3b, 0x76, 0x35, 0xc3,
	0x53, 0xf1, 0xc9, 0xed, 0x2d, 0x1c, 0xc7, 0x38, 0x07, 0x09, 0x4c, 0x93, 0xa3, 0xe0, 0x8a, 0x7b,
	0x09, 0x15, 0xfd, 0x5a, 0x81, 0x87, 0xe1, 0x39, 0x65, 0xba, 0x79, 0x6e, 0x78, 0x36, 0x99, 0x36,
	0x2e, 0xce, 0xa1, 0x79, 0x7b, 0xe3, 0xdd, 0x73, 0xca, 0x9a, 0x1c, 0x6c, 0xd2, 0x83, 0x8d, 0xf0,
	0x2a, 0x16, 0x7a, 0xab, 0xc0, 0xbb, 0xe4, 0xb5, 0xef, 0x3a, 0xa6, 0x33, 0x2c, 0xbb, 0x69, 0x5f,
	0xe6, 0xb8, 0x2f, 0x47, 0xb7, 0xf7, 0x45, 0x93, 0x90, 0xb2, 0x68, 0x27, 0x1d, 0xda, 0x22, 0xd7,
	0xf2, 0xd1, 0xaf, 0x14, 0x78, 0x27, 0xf4, 0x09, 0x31, 0xcf, 0x75, 0x16, 0x18, 0x5e, 0x68, 0x06,
	0x8e, 0x9f, 0xf6, 0x27, 0x37, 0x73, 0x6e, 0x38, 0x58, 0x2f, 0x8d, 0x35, 0xcc, 0xcd, 0x55, 0x2c,
	0xf5, 0x1f, 0x0a, 0x54, 0x2e, 0x3b, 0x51, 0xe4, 0x41, 0x65, 0xb2, 0x62, 0x06, 0xd4, 0x22, 0xfc,
	0x3e, 0x2f, 0xef, 0x7d, 0xf7, 0xae, 0xf5, 0xf2, 0x8c, 0x5a, 0x04, 0x23, 0x77, 0x8a, 0x86, 0xbe,
	0x0e, 0x0f, 0x42, 0xd1, 0xde, 0x8c, 0xe0, 0x8d, 0x6e, 0x1a, 0x03, 0x12, 0x18, 0xbc, 0x38, 0x17,
	0x71, 0x79, 0xc4, 0x68, 0x72, 0x3a, 0xaa, 0xc0, 0x7c, 0xec, 0x8c, 0xcb, 0x0b, 0x28, 0x8f, 0xc5,
	0x87, 0xba, 0x0b, 0x1b, 0x57, 0xd6, 0xc7, 0x48, 0x45, 0x49, 0xab, 0x7c, 0x08, 0x5b, 0xd7, 0x1f,
	0xe3, 0x15, 0x7a, 0x7f, 0x52, 0xe4, 0xa5, 0x95, 0x57, 0x0d, 0x69, 0xdc, 0xfd, 0x80, 0xe9, 0x71,
	0xfb, 0xd4, 0x69, 0xbf, 0x1f, 0x12, 0xc6, 0x55, 0x0a, 0x7b, 0x1b, 0x49, 0xae, 0x92, 0x16, 0x5b,
	0x3b, 0x90, 0x2d, 0x18, 0x97, 0xb8, 0x4e, 0xcf, 0x19, 0x90, 0x36, 0xd7, 0x40, 0x0d, 0x28, 0x11,
	0xcf, 0x1a, 0x03, 0xc9, 0xdc, 0x04, 0xb2, 0x44, 0x3c, 0x6b, 0x04, 0xa1, 0x7e, 0xa1, 0x40, 0x91,
	0xe7, 0x3c, 0x71, 0xad, 0x03, 0x0b, 0xb2, 0x0f, 0x48, 0x87, 0xee, 0xda, 0x4e, 0x12, 0x18, 0xb4,
	0x05, 0xc0, 0x8b, 0xd4, 0x8a, 0xa5, 0xb9, 0x83, 0x19, 0x9c, 0xa2, 0xa8, 0xe7, 0x00, 0xdc, 0x83,
	0xc3, 0xc0, 0x18, 0x10, 0xf4, 0x14, 0x0a, 0x33, 0x25, 0x05, 0xd8, 0x28, 0x1f, 0x37, 0x59, 0x72,
	0x21, 0xa7, 0x79, 0xcc, 0x61, 0x6f, 0xe2, 0xa1, 0x43, 0xf8, 0xaf, 0xb8, 0xcb, 0xca, 0xa1, 0x23,
	0x08, 0x2d, 0x0b, 0x6d, 0x43, 0xc1, 0x22, 0xc3, 0xd2, 0xe7, 0x38, 0x79, 0x9c, 0x26, 0xc5, 0x63,
	0xc9, 0x35, 0x3c, 0x3b, 0x32, 0x6c, 0xa2, 0x9b, 0x71, 0x9d, 0x8b, 0xca, 0x2a, 0x26, 0xc4, 0x26,
	0xb5, 0x88, 0xfa, 0x9f, 0x0c, 0x94, 0x78, 0x60, 0x8d, 0xe1, 0x2c, 0x46, 0x47, 0x90, 0x13, 0x66,
	0x64, 0x60, 0xdf, 0x9c, 0xa1, 0x81, 0x70, 0x3d, 0x2c, 0xf5, 0xd1, 0x4f, 0xe0, 0x81, 0x69, 0x30,
	0x62, 0xd3, 0xe0, 0x8d, 0xce, 0x49, 0x8e, 0x9c, 0x7e, 0x77, 0x01, 0x2d, 0x27, 0x50, 0x9a, 0x44,
	0x1a, 0x1b, 0x2b, 0xd9, 0x59, 0xc7, 0x4a, 0xba, 0xa0, 0x52, 0x63, 0xe5, 0x18, 0x72, 0xfd, 0xf8,
	0x8c, 0xc3, 0xea, 0x1c, 0x47, 0xfc, 0x60, 0x46, 0x44, 0x5e, 0x20, 0x58, 0x62, 0xa8, 0x7f, 0x53,
	0xa0, 0x32, 0x71, 0x1b, 0xef, 0x5f, 0x41, 0xaf, 0x60, 0xcd, 0xa7, 0x81, 0x47, 0xed, 0xc0, 0xf0,
	0xcf, 0xdf, 0xe8, 0xae, 0xf3, 0x8a, 0xb8, 0xce, 0x39, 0xa5, 0x16, 0xaf, 0x82, 0xe5, 0x99, 0x5c,
	0x1e, 0xea, 0xe2, 0xd5, 0x14, 0xe6, 0x88, 0xac, 0x86, 0xb0, 0x31, 0x11, 0x40, 0xaa, 0x52, 0x4e,
	0x87, 0xc9, 0x12, 0x53, 0xfd, 0x93, 0x3b, 0x8f, 0x9a, 0xf1, 0xb4, 0xfd, 0x26, 0x07, 0x6b, 0xfc,
	0x9e, 0x8e, 0x6c, 0x61, 0x12, 0x46, 0x2e, 0x0b, 0xaf, 0xdf, 0xc4, 0x22, 0xd8, 0x90, 0x07, 0xa9,
	0x8b, 0x4e, 0x9f, 0xda, 0x30, 0x65, 0xdd, 0x7d, 0x34, 0xe3, 0x79, 0xa6, 0x3c, 0x58, 0x97, 0xd8,
	0x13, 0xf4, 0x10, 0x51, 0x58, 0xe3, 0x3b, 0xc1, 0xb4, 0xcd, 0xec, 0x7d, 0x6d, 0x56, 0x62, 0xe0,
	0x29, 0x83, 0x9f, 0xc3, 0x3a, 0xcf, 0xd4, 0x25, 0x16, 0xe7, 0xee, 0x6b, 0x71, 0x95, 0x23, 0x4f,
	0x99, 0x34, 0xa0, 0xcc, 0x63, 0x4c, 0xdb, 0xca, 0xdd, 0x6b, 0x95, 0x2b, 0xc5, 0x78, 0x69, 0x13,
	0x0c, 0x56, 0x86, 0x3b, 0xcd, 0xc8, 0x4c, 0x75, 0x61, 0xd6, 0xad, 0xe1, 0xca, 0x7a, 0xc5, 0x28,
	0xc1, 0x4f, 0xd5, 0x70, 0x00, 0xab, 0x97, 0xed, 0x2c, 0x61, 0xb5, 0xc0, 0xa3, 0xfb, 0xde, 0xbd,
	0xb6, 0x15, 0x5c, 0xb9, 0x64, 0x4f, 0x09, 0xd1, 0x0e, 0xcc, 0x93, 0x20, 0xa0, 0x41, 0x35, 0xcf,
	0x63, 0x43, 0x89, 0x8d, 0xc0, 0x37, 0x6b, 0x5d, 0xfe, 0x20, 0xc1, 0x42, 0x40, 0xfd, 0xad, 0x02,
	0xab, 0x13, 0x2f, 0x92, 0xd0, 0xa7, 0x5e, 0x48, 0x10, 0x05, 0x34, 0x4a, 0x92, 0x1e, 0x88, 0xeb,
	0x21, 0xef, 0xe1, 0xa7, 0x33, 0x1e, 0xc9, 0xd4, 0x35, 0xc3, 0x0f, 0x8c, 0x49, 0x92, 0xfa, 0x6f,
	0x05, 0xd6, 0x27, 0xa4, 0x3b, 0x01, 0xb5, 0x03, 0x12, 0xde, 0x70, 0x2b, 0xdf, 0x87, 0xb2, 0x2f,
	0x05, 0x75, 0x9f, 0x04, 0x66, 0x3c, 0xb6, 0xe3, 0x4e, 0x35, 0x8f, 0x4b, 0x09, 0xbd, 0x23, 0xc8,
	0xe8, 0x23, 0x80, 0xd1, 0xce, 0x21, 0x77, 0xe9, 0xcd, 0xa9, 0xae, 0xd8, 0x4b, 0xde, 0x73, 0x38,
	0x3f, 0xdc, 0x36, 0xd0, 0xc7, 0x50, 0x88, 0x7c, 0xcb, 0x60, 0x44, 0xe8, 0xce, 0xdd, 0xa8, 0x0b,
	0x42, 0x3c, 0x26, 0xa8, 0xbf, 0x9b, 0x4c, 0xf3, 0x30, 0xb2, 0x00, 0x56, 0x52, 0x69, 0x4e, 0xfc,
	0x95, 0x79, 0x6e, 0xdc, 0x39, 0xcf, 0x09, 0x3e, 0x4e, 0x1d, 0x62, 0x42, 0x53, 0xff, 0x9b, 0x81,
	0x8d, 0x2b, 0x57, 0xdf, 0xe9, 0xb9, 0xae, 0x4c, 0xcf, 0xf5, 0x38, 0xe7, 0x03, 0xe3, 0xb5, 0x6e,
	0xb8, 0x8c, 0x04, 0x9e, 0xc1, 0x9c, 0x0b, 0x3e, 0x78, 0x79, 0xce, 0x07, 0xc6, 0xeb, 0x46, 0x8a,
	0x1c, 0x8b, 0xf6, 0x9d, 0x98, 0x10, 0x47, 0xd7, 0x37, 0xbc, 0x78, 0xf0, 0x67, 0xf9, 0x96, 0x5a,
	0x12, 0xf4, 0x4e, 0x42, 0x46, 0x3f, 0x85, 0x92, 0xbc, 0x2b, 0xf2, 0xd9, 0x99, 0xf4, 0x9b, 0x6f,
	0xcf, 0x7a, 0x4b, 0x92, 0x87, 0xe7, 0x72, 0x98, 0xfe, 0x0c, 0xd1, 0xa7, 0xf0, 0x90, 0x78, 0xc6,
	0x99, 0x4b, 0x74, 0x23, 0x62, 0x74, 0x60, 0x30, 0xc7, 0xd4, 0xfd, 0xc8, 0x33, 0x59, 0x24, 0x9a,
	0xc1, 0x3c, 0x77, 0x6c, 0x53, 0xc8, 0x34, 0x12, 0x91, 0xce, 0x48, 0x02, 0xbd, 0x0b, 0x45, 0x23,
	0xb2, 0x1c, 0x1a, 0x5f, 0x67, 0xf3, 0x95, 0x68, 0x52, 0xf3, 0xb8, 0xc0, 0x69, 0x3d, 0x4e, 0x52,
	0xdf, 0x87, 0xa5, 0x31, 0x2f, 0x50, 0x15, 0x16, 0xfc, 0xf3, 0xc0, 0x08, 0xe5, 0x20, 0xcb, 0xe3,
	0xe4, 0x53, 0xfd, 0x85, 0x02, 0x2b, 0x97, 0x1c, 0x05, 0xfa, 0x19, 0x14, 0xc7, 0x72, 0x2b, 0xea,
	0xe1, 0x70, 0xd6, 0x34, 0x60, 0x62, 0x52, 0xdb, 0x73, 0x62, 0xc8, 0xd4, 0x99, 0xe0, 0x31, 0x6c,
	0xf5, 0xcf, 0x0a, 0x3c, 0xbc, 0x4e, 0x3c, 0x5e, 0x29, 0x47, 0xbd, 0x4b, 0x96, 0x43, 0x8a, 0x72,
	0xd3, 0xca, 0x89, 0x8e, 0x60, 0xfe, 0xe7, 0x34, 0xb0, 0x92, 0x71, 0xb5, 0x77, 0xfb, 0x28, 0x7e,
	0x40, 0x03, 0xab, 0xe5, 0xf5, 0x29, 0x16, 0x00, 0xea, 0x1f, 0x14, 0x58, 0x4c, 0x68, 0xe8, 0x3b,
	0x63, 0x97, 0xf9, 0xc6, 0x15, 0x27, 0x75, 0x97, 0x3f, 0x80, 0xc5, 0xe4, 0xcd, 0x70, 0xf3, 0x63,
	0x61, 0x41, 0x3e, 0x16, 0x10, 0x82, 0xb9, 0xd8, 0x0b, 0xb9, 0xe7, 0xf2, 0xdf, 0x4f, 0x7e, 0xaf,
	0xc0, 0x82, 0xfc, 0xf7, 0x04, 0xad, 0xc3, 0xca, 0xa1, 0xd6, 0xe8, 0x3d, 0xc7, 0x9a, 0xfe, 0xfc,
	0xa4, 0xdb, 0xd1, 0x9a, 0xad, 0xc3, 0x96, 0x76, 0x50, 0xfe, 0x0a, 0x5a, 0x81, 0xd2, 0x71, 0x63,
	0x5f, 0x3b, 0xd6, 0x0f, 0xb4, 0x9e, 0xd6, 0xec, 0xb5, 0xda, 0x27, 0x65, 0x05, 0x6d, 0xc0, 0x6a,
	0xf7, 0xa8, 0xdd, 0xd3, 0x9b, 0x47, 0x8d, 0x93, 0xcf, 0xb4, 0x14, 0x2b, 0x83, 0xb6, 0x60, 0x53,
	0xfb, 0x61, 0xe7, 0xb8, 0xd5, 0x6c, 0xf5, 0xf4, 0x66, 0xfb, 0xa4, 0xa7, 0x9d, 0xf4, 0x52, 0xfc,
	0x2c, 0xaa, 0x42, 0xa5, 0xdb, 0xd1, 0xb4, 0xe6, 0x91, 0xde, 0xc3, 0x8d, 0x93, 0x6e, 0x13, 0xb7,
	0x3a, 0x9c, 0x93, 0x7b, 0x12, 0x00, 0x9a, 0x7e, 0x3c, 0xa2, 0xaf, 0xc2, 0xf6, 0x84, 0x7d, 0xfd,
	0x59, 0xfb, 0x60, 0xd2, 0xcb, 0x25, 0xc8, 0x73, 0x87, 0x62, 0x56, 0x59, 0x41, 0xcb, 0x00, 0x87,
	0xb8, 0xf1, 0x4c, 0x13, 0xdf, 0x99, 0x38, 0x3a, 0xce, 0x6e, 0x9c, 0x1c, 0xe8, 0x29, 0x46, 0xf6,
	0x09, 0x03, 0x18, 0xed, 0x73, 0x68, 0x13, 0xd6, 0x8e, 0x5b, 0xdf, 0xd7, 0x8e, 0x5b, 0x47, 0xed,
	0xf6, 0xc1, 0x84, 0x85, 0x07, 0xb0, 0x74, 0xaa, 0xe1, 0x17, 0xfa, 0xf3, 0x13, 0x2e, 0xf2, 0xa2,
	0xac, 0xa0, 0x22, 0x2c, 0x0e, 0xbf, 0x32, 0xf1, 0x57, 0xa7, 0xdd, 0xed, 0xb6, 0xf6, 0x8f, 0xb5,
	0x72, 0x16, 0x01, 0xe4, 0x24, 0x67, 0x0e, 0x95, 0xa0, 0xc0, 0x55, 0x25, 0x61, 0x7e, 0xef, 0xaf,
	0x0a, 0x54, 0x79, 0xcf, 0x6b, 0xa5, 0x2a, 0xa7, 0x4b, 0x82, 0x0b, 0xc7, 0x24, 0xe8, 0x8f, 0x0a,
	0x2c, 0x8d, 0xb5, 0x5b, 0x34, 0xc3, 0xe6, 0x78, 0xd9, 0x1f, 0x74, 0x9b, 0x8f, 0x12, 0xfd, 0xd4,
	0x3f, 0x87, 0xb5, 0x76, 0xf2, 0xcf, 0xa1, 0xfa, 0xb5, 0x5f, 0xfe, 0xeb, 0x7f, 0x6f, 0x33, 0x8f,
	0xd5, 0xcd, 0xc9, 0x3f, 0x33, 0xc3, 0xa7, 0xb2, 0xff, 0x92, 0xa7, 0xca, 0x93, 0xfd, 0x2f, 0x32,
	0xf0, 0x0d, 0x93, 0x0e, 0x6e, 0xed, 0xcb, 0xfe, 0xa3, 0xab, 0x42, 0xec, 0xc4, 0x65, 0xda, 0x51,
	0x7e, 0xf4, 0x42, 0x42, 0xd9, 0x34, 0x6e, 0xcf, 0x35, 0x1a, 0xd8, 0x75, 0x9b, 0x78, 0xbc, 0x88,
	0xeb, 0x82, 0x65, 0xf8, 0x4e, 0x78, 0xf3, 0x5f, 0xaf, 0x1f, 0x4f, 0xf1, 0xfe, 0x92, 0xd9, 0xf9,
	0x4c, 0x60, 0x37, 0xb9, 0x9b, 0x53, 0x9e, 0xd4, 0x4e, 0x77, 0x3b, 0xbb, 0xfb, 0xb1, 0xf2, 0x3f,
	0x13, 0xd1, 0x97, 0x5c, 0xf4, 0xe5, 0x94, 0xe8, 0xcb, 0xd3, 0xc4, 0xce, 0x59, 0x8e, 0xfb, 0xf6,
	0xad, 0x2f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x82, 0x99, 0xe4, 0x9b, 0x15, 0x16, 0x00, 0x00,
}
