package helpers_test

import (
	"strings"
	"testing"

	"github.com/git-town/git-town/v7/test/helpers"
	"github.com/stretchr/testify/assert"
)

func TestLongestStringLength(t *testing.T) {
	t.Parallel()
	tests := map[int][]string{
		5: {"one", "two", "three"},
		0: {""},
	}
	for expected, input := range tests { //nolint:paralleltest
		t.Run(strings.Join(input, "-"), func(t *testing.T) {
			t.Parallel()
			assert.Equal(t, expected, helpers.LongestStringLength(input))
		})
	}
}
