# Contribution regex

Branches matching this regular expression are treated as
[contribution branches](../branch-types.md#contribution-branches).

## configure in config file

Setting the contribution regex in the [config file](../configuration-file.md) is
only useful when the matching branches should be considered contribution by all
team members. This is typically the case for branches generated by external
services, like Renovate or Dependabot.

```toml
[branches]
contribution-regex = "^renovate/"
```

## configure in Git metadata

To manually set the contribution regex, run this command:

```wrap
git config [--global] git-town.contribution-regex '^renovate/'
```

The optional `--global` flag applies this setting to all Git repositories on
your local machine. When not present, the setting applies to the current repo.
