/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/gardener/pkg/apis/settings/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterOpenIDConnectPresetLister helps list ClusterOpenIDConnectPresets.
type ClusterOpenIDConnectPresetLister interface {
	// List lists all ClusterOpenIDConnectPresets in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ClusterOpenIDConnectPreset, err error)
	// Get retrieves the ClusterOpenIDConnectPreset from the index for a given name.
	Get(name string) (*v1alpha1.ClusterOpenIDConnectPreset, error)
	ClusterOpenIDConnectPresetListerExpansion
}

// clusterOpenIDConnectPresetLister implements the ClusterOpenIDConnectPresetLister interface.
type clusterOpenIDConnectPresetLister struct {
	indexer cache.Indexer
}

// NewClusterOpenIDConnectPresetLister returns a new ClusterOpenIDConnectPresetLister.
func NewClusterOpenIDConnectPresetLister(indexer cache.Indexer) ClusterOpenIDConnectPresetLister {
	return &clusterOpenIDConnectPresetLister{indexer: indexer}
}

// List lists all ClusterOpenIDConnectPresets in the indexer.
func (s *clusterOpenIDConnectPresetLister) List(selector labels.Selector) (ret []*v1alpha1.ClusterOpenIDConnectPreset, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ClusterOpenIDConnectPreset))
	})
	return ret, err
}

// Get retrieves the ClusterOpenIDConnectPreset from the index for a given name.
func (s *clusterOpenIDConnectPresetLister) Get(name string) (*v1alpha1.ClusterOpenIDConnectPreset, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("clusteropenidconnectpreset"), name)
	}
	return obj.(*v1alpha1.ClusterOpenIDConnectPreset), nil
}
