/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/gardener/gardener/pkg/apis/extensions/v1alpha1"
	scheme "github.com/gardener/gardener/pkg/client/extensions/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ContainerRuntimesGetter has a method to return a ContainerRuntimeInterface.
// A group's client should implement this interface.
type ContainerRuntimesGetter interface {
	ContainerRuntimes(namespace string) ContainerRuntimeInterface
}

// ContainerRuntimeInterface has methods to work with ContainerRuntime resources.
type ContainerRuntimeInterface interface {
	Create(ctx context.Context, containerRuntime *v1alpha1.ContainerRuntime, opts v1.CreateOptions) (*v1alpha1.ContainerRuntime, error)
	Update(ctx context.Context, containerRuntime *v1alpha1.ContainerRuntime, opts v1.UpdateOptions) (*v1alpha1.ContainerRuntime, error)
	UpdateStatus(ctx context.Context, containerRuntime *v1alpha1.ContainerRuntime, opts v1.UpdateOptions) (*v1alpha1.ContainerRuntime, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ContainerRuntime, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ContainerRuntimeList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ContainerRuntime, err error)
	ContainerRuntimeExpansion
}

// containerRuntimes implements ContainerRuntimeInterface
type containerRuntimes struct {
	client rest.Interface
	ns     string
}

// newContainerRuntimes returns a ContainerRuntimes
func newContainerRuntimes(c *ExtensionsV1alpha1Client, namespace string) *containerRuntimes {
	return &containerRuntimes{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the containerRuntime, and returns the corresponding containerRuntime object, and an error if there is any.
func (c *containerRuntimes) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ContainerRuntime, err error) {
	result = &v1alpha1.ContainerRuntime{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("containerruntimes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ContainerRuntimes that match those selectors.
func (c *containerRuntimes) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ContainerRuntimeList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ContainerRuntimeList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("containerruntimes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested containerRuntimes.
func (c *containerRuntimes) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("containerruntimes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a containerRuntime and creates it.  Returns the server's representation of the containerRuntime, and an error, if there is any.
func (c *containerRuntimes) Create(ctx context.Context, containerRuntime *v1alpha1.ContainerRuntime, opts v1.CreateOptions) (result *v1alpha1.ContainerRuntime, err error) {
	result = &v1alpha1.ContainerRuntime{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("containerruntimes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(containerRuntime).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a containerRuntime and updates it. Returns the server's representation of the containerRuntime, and an error, if there is any.
func (c *containerRuntimes) Update(ctx context.Context, containerRuntime *v1alpha1.ContainerRuntime, opts v1.UpdateOptions) (result *v1alpha1.ContainerRuntime, err error) {
	result = &v1alpha1.ContainerRuntime{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("containerruntimes").
		Name(containerRuntime.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(containerRuntime).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *containerRuntimes) UpdateStatus(ctx context.Context, containerRuntime *v1alpha1.ContainerRuntime, opts v1.UpdateOptions) (result *v1alpha1.ContainerRuntime, err error) {
	result = &v1alpha1.ContainerRuntime{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("containerruntimes").
		Name(containerRuntime.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(containerRuntime).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the containerRuntime and deletes it. Returns an error if one occurs.
func (c *containerRuntimes) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("containerruntimes").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *containerRuntimes) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("containerruntimes").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched containerRuntime.
func (c *containerRuntimes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ContainerRuntime, err error) {
	result = &v1alpha1.ContainerRuntime{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("containerruntimes").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
