/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/gardener/pkg/apis/core/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ShootStateLister helps list ShootStates.
type ShootStateLister interface {
	// List lists all ShootStates in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ShootState, err error)
	// ShootStates returns an object that can list and get ShootStates.
	ShootStates(namespace string) ShootStateNamespaceLister
	ShootStateListerExpansion
}

// shootStateLister implements the ShootStateLister interface.
type shootStateLister struct {
	indexer cache.Indexer
}

// NewShootStateLister returns a new ShootStateLister.
func NewShootStateLister(indexer cache.Indexer) ShootStateLister {
	return &shootStateLister{indexer: indexer}
}

// List lists all ShootStates in the indexer.
func (s *shootStateLister) List(selector labels.Selector) (ret []*v1alpha1.ShootState, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ShootState))
	})
	return ret, err
}

// ShootStates returns an object that can list and get ShootStates.
func (s *shootStateLister) ShootStates(namespace string) ShootStateNamespaceLister {
	return shootStateNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ShootStateNamespaceLister helps list and get ShootStates.
type ShootStateNamespaceLister interface {
	// List lists all ShootStates in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.ShootState, err error)
	// Get retrieves the ShootState from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.ShootState, error)
	ShootStateNamespaceListerExpansion
}

// shootStateNamespaceLister implements the ShootStateNamespaceLister
// interface.
type shootStateNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ShootStates in the indexer for a given namespace.
func (s shootStateNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ShootState, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ShootState))
	})
	return ret, err
}

// Get retrieves the ShootState from the indexer for a given namespace and name.
func (s shootStateNamespaceLister) Get(name string) (*v1alpha1.ShootState, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("shootstate"), name)
	}
	return obj.(*v1alpha1.ShootState), nil
}
