/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"time"

	v1beta1 "github.com/gardener/gardener/pkg/apis/core/v1beta1"
	scheme "github.com/gardener/gardener/pkg/client/core/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ControllerInstallationsGetter has a method to return a ControllerInstallationInterface.
// A group's client should implement this interface.
type ControllerInstallationsGetter interface {
	ControllerInstallations() ControllerInstallationInterface
}

// ControllerInstallationInterface has methods to work with ControllerInstallation resources.
type ControllerInstallationInterface interface {
	Create(*v1beta1.ControllerInstallation) (*v1beta1.ControllerInstallation, error)
	Update(*v1beta1.ControllerInstallation) (*v1beta1.ControllerInstallation, error)
	UpdateStatus(*v1beta1.ControllerInstallation) (*v1beta1.ControllerInstallation, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta1.ControllerInstallation, error)
	List(opts v1.ListOptions) (*v1beta1.ControllerInstallationList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.ControllerInstallation, err error)
	ControllerInstallationExpansion
}

// controllerInstallations implements ControllerInstallationInterface
type controllerInstallations struct {
	client rest.Interface
}

// newControllerInstallations returns a ControllerInstallations
func newControllerInstallations(c *CoreV1beta1Client) *controllerInstallations {
	return &controllerInstallations{
		client: c.RESTClient(),
	}
}

// Get takes name of the controllerInstallation, and returns the corresponding controllerInstallation object, and an error if there is any.
func (c *controllerInstallations) Get(name string, options v1.GetOptions) (result *v1beta1.ControllerInstallation, err error) {
	result = &v1beta1.ControllerInstallation{}
	err = c.client.Get().
		Resource("controllerinstallations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ControllerInstallations that match those selectors.
func (c *controllerInstallations) List(opts v1.ListOptions) (result *v1beta1.ControllerInstallationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.ControllerInstallationList{}
	err = c.client.Get().
		Resource("controllerinstallations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested controllerInstallations.
func (c *controllerInstallations) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("controllerinstallations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a controllerInstallation and creates it.  Returns the server's representation of the controllerInstallation, and an error, if there is any.
func (c *controllerInstallations) Create(controllerInstallation *v1beta1.ControllerInstallation) (result *v1beta1.ControllerInstallation, err error) {
	result = &v1beta1.ControllerInstallation{}
	err = c.client.Post().
		Resource("controllerinstallations").
		Body(controllerInstallation).
		Do().
		Into(result)
	return
}

// Update takes the representation of a controllerInstallation and updates it. Returns the server's representation of the controllerInstallation, and an error, if there is any.
func (c *controllerInstallations) Update(controllerInstallation *v1beta1.ControllerInstallation) (result *v1beta1.ControllerInstallation, err error) {
	result = &v1beta1.ControllerInstallation{}
	err = c.client.Put().
		Resource("controllerinstallations").
		Name(controllerInstallation.Name).
		Body(controllerInstallation).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *controllerInstallations) UpdateStatus(controllerInstallation *v1beta1.ControllerInstallation) (result *v1beta1.ControllerInstallation, err error) {
	result = &v1beta1.ControllerInstallation{}
	err = c.client.Put().
		Resource("controllerinstallations").
		Name(controllerInstallation.Name).
		SubResource("status").
		Body(controllerInstallation).
		Do().
		Into(result)
	return
}

// Delete takes name of the controllerInstallation and deletes it. Returns an error if one occurs.
func (c *controllerInstallations) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("controllerinstallations").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *controllerInstallations) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("controllerinstallations").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched controllerInstallation.
func (c *controllerInstallations) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.ControllerInstallation, err error) {
	result = &v1beta1.ControllerInstallation{}
	err = c.client.Patch(pt).
		Resource("controllerinstallations").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
