// Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package error

import (
	"fmt"
	"time"
)

// RequeueAfterError is an error that indicates that an actuator wants a reconcile operation
// to be requeued again after RequeueAfter has passed.
type RequeueAfterError struct {
	// Cause is an optional cause that may be returned together with a time for requeueing.
	Cause error
	// RequeueAfter is the duration after which the request should be enqueued again.
	RequeueAfter time.Duration
}

func (e *RequeueAfterError) Error() string {
	if e.Cause == nil {
		return fmt.Sprintf("requeue in %s", e.RequeueAfter)
	}

	return fmt.Sprintf("requeue in %s due to %+v", e.RequeueAfter, e.Cause)
}
