/*
 * Copyright 2019 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 *
 */

package resources

import (
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"

	"github.com/gardener/controller-manager-library/pkg/resources/abstract"
)

func DeclareDefaultVersion(gv schema.GroupVersion) {
	abstract.DeclareDefaultVersion(gv)
}

func DefaultVersion(g string) string {
	return abstract.DefaultVersion(g)
}

func Register(builders ...runtime.SchemeBuilder) {
	abstract.Register(builders...)
}

func DefaultScheme() *runtime.Scheme {
	return abstract.DefaultScheme()
}
