/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	internalinterfaces "github.com/gardener/external-dns-management/pkg/client/dns/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// DNSAnnotations returns a DNSAnnotationInformer.
	DNSAnnotations() DNSAnnotationInformer
	// DNSEntries returns a DNSEntryInformer.
	DNSEntries() DNSEntryInformer
	// DNSOwners returns a DNSOwnerInformer.
	DNSOwners() DNSOwnerInformer
	// DNSProviders returns a DNSProviderInformer.
	DNSProviders() DNSProviderInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// DNSAnnotations returns a DNSAnnotationInformer.
func (v *version) DNSAnnotations() DNSAnnotationInformer {
	return &dNSAnnotationInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// DNSEntries returns a DNSEntryInformer.
func (v *version) DNSEntries() DNSEntryInformer {
	return &dNSEntryInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// DNSOwners returns a DNSOwnerInformer.
func (v *version) DNSOwners() DNSOwnerInformer {
	return &dNSOwnerInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// DNSProviders returns a DNSProviderInformer.
func (v *version) DNSProviders() DNSProviderInformer {
	return &dNSProviderInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
