//go:build !ci && android

package app

import (
	"os"
	"testing"

	"github.com/stretchr/testify/assert"
)

func Test_RootConfigDir(t *testing.T) {
	oldEnv := os.Getenv("FILESPATH")
	os.Setenv("FILESPATH", "/tmp")

	assert.Equal(t, "/tmp", rootConfigDir())
	os.Setenv("FILESPATH", oldEnv)
}

func Test_StoragePath(t *testing.T) {
	oldEnv := os.Getenv("FILESPATH")
	os.Setenv("FILESPATH", "/tmp")
	defer os.Setenv("FILESPATH", oldEnv)

	p := &preferences{}
	expected := "/tmp/storage/preferences.json"
	assert.Equal(t, expected, p.storagePath())
}
