package auth

import (
	"context"
	"fmt"

	"github.com/spf13/cobra"

	"github.com/superfly/flyctl/iostreams"

	"github.com/superfly/flyctl/internal/command"
	"github.com/superfly/flyctl/internal/config"
	"github.com/superfly/flyctl/internal/flag"
	"github.com/superfly/flyctl/internal/render"
)

func newToken() *cobra.Command {
	const (
		long = `Shows the authentication token that is currently in use.
This can be used as an authentication token with API services,
independent of flyctl.
`
		short = "Show the current auth token"
	)

	cmd := command.New("token", short, long, runAuthToken,
		command.ExcludeFromMetrics,
		command.RequireSession,
	)

	flag.Add(cmd, flag.JSONOutput())
	return cmd
}

func runAuthToken(ctx context.Context) error {
	cfg := config.FromContext(ctx)
	token := cfg.AccessToken

	if io := iostreams.FromContext(ctx); cfg.JSONOutput {
		render.JSON(io.Out, map[string]string{"token": token})
	} else {
		fmt.Fprintln(io.Out, token)
	}

	return nil
}
