This is the draft release notes for 0.16.0. It is scheduled to be released on
2020-07-01.

# Breaking changes

-   Exceptions caused by a command trying to write to a closed pipe are now
    suppressed if the command is part of a pipeline and not the last command of
    the pipeline.

-   The `builtin:` namespace, useful for referring to builtin variables and
    commmands explicitly, now requires `use builtin` before use, consistent with
    other standard library modules.

-   As a side effect of support for a integer numbers, contexts that require
    integers no longer accept floating point numbers with a zero fraction part
    (e.g. `$li[1.0]` is now illegal; `$li[1]` is required).

-   The following commands are now replaced by `edit:close-mode`:
    `edit:close-listing`, `edit:completion:close`, `edit:history:close`,
    `edit:listing:close`.

-   The `edit:histlist:toggle-case-sensitivity` command has been removed.
    Instead, the history listing mode now applies smart-case matching by
    default.

-   Declaring a variable with a `~` suffix, without an explicit initial value,
    now initializes its value to the builtin `nop` function rather than `$nil`
    ([#1248](https://b.elv.sh/1248)).

# Deprecated features

Deprecated features will be removed in 0.17.0.

The following deprecated features trigger a warning whenever the code is parsed
or compiled, even if it is not executed:

-   The `fopen` and `fclose` commands are deprecated. Use `file:open` and
    `file:close` instead.

-   The `prclose` and `pwclose` commands are deprecated. Use `file:close`
    instead.

The following deprecated features unfortunately doesn't trigger any warnings:

-   The `math:pow10` command is deprecated. Use `math:pow 10 $exponent` instead.

# Notable bugfixes

-   Iterating over certain list slices no longer crash Elvish
    ([#1287](https://b.elv.sh/1287)).

-   Globbing no longer crashes when there are files whose names contain invalid
    UTF-8 sequences ([#1220](https://b.elv.sh/1220)).

-   The `path:is-dir` and `path:is-regular` commands default behavior no longer
    follows a final symlink as advertised in the original documentation. A
    `&follow-symlink` option has been added to get the old, undocumented,
    behavior since it can be useful and avoids the need to use
    `path:eval-symlinks` to transform the path in common use cases.

*   Evaluating `~username` no longer appends a slash
    ([#1246](https://b.elv.sh/1246)).

# Notable new features

New features in the language:

-   Elvish's number type has been extended with support for arbitrary-precision
    integers and rationals. Many numerical commands in the builtin module and
    the `math:` module have been extended with support for them.

-   Experimental support for importing modules written in Go with `use`.

New features in the standard library:

-   A new `file:` module contains utilities for manipulating files.

-   Commands for creating temporary files and directories, `path:temp-file` and
    `path:temp-dir` ([#1255](https://b.elv.sh/1255)).

-   New options to the `edit:command-history` command: `&dedup`,
    `&newest-first`, and `&cmd-only` ([#1053](https://b.elv.sh/1053)).

-   New `from-terminated` and `to-terminated` commands to allow efficient
    streaming of byte sequences terminated by ASCII NUL or any other terminator
    ([#1070](https://b.elv.sh/1070)).

New features in the interactive editor:

-   The editor now supports setting global bindings via `$edit:global-binding`.
    Global bindings are consulted for keys not present in mode-specific
    bindings.

-   A new `edit:clear` builtin to clear the screen has been added.

-   The editor now uses a DSL for filtering items in completion, history
    listing, location and navigation modes.

-   A new `edit:after-command` hook that is invoked after each interactive
    command line is run ([#1029](https://b.elv.sh/1029)).

-   A new `edit:command-duration` variable that is the number of seconds to
    execute the most recent interactive command line
    ([#1029](https://b.elv.sh/1029)).

New features in the command behavior:

-   Elvish now follows the XDG directory spec for placing the database and
    searching for `rc.elv` and libraries ([#383](https://b.elv.sh/383)). The
    legacy directory `~/.elvish` is still respected for now, but may issue
    deprecation warnings in a future version. The exact paths are documented in
    the page for [the Elvish command](https://elv.sh/ref/command.html).
