// Copyright 2019 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v6.31.1
// source: dolt/services/remotesapi/v1alpha1/chunkstore.proto

package remotesapi

import (
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A ChunkStore can request a client to implement a specific concurrency
// control mechanism when updating a branch HEAD.
//
// This exists because passive remotes, like DoltHub, typically do not have
// meaningful workingSets. When a client requests to push a branch HEAD to a
// DoltHub remote, they have no visibility into the workingSet/ value for the
// corresponding branch. It has historically been the case that clients ignore
// it and just push the branch HEAD.
//
// On the other hand, when pushing to a running sql-server, not stomping
// concurrent transaction is important, and the remote endpoint will want the
// pushing client to ensure that it both checks that the branch's working set
// is clean and that it updates the branch's working set appropriately if the
// push is successful.
//
// Servers advertise which concurrency control mechanism they want in their
// GetRepoMetadataResponse.
type PushConcurrencyControl int32

const (
	PushConcurrencyControl_PUSH_CONCURRENCY_CONTROL_UNSPECIFIED        PushConcurrencyControl = 0
	PushConcurrencyControl_PUSH_CONCURRENCY_CONTROL_IGNORE_WORKING_SET PushConcurrencyControl = 1
	PushConcurrencyControl_PUSH_CONCURRENCY_CONTROL_ASSERT_WORKING_SET PushConcurrencyControl = 2
)

// Enum value maps for PushConcurrencyControl.
var (
	PushConcurrencyControl_name = map[int32]string{
		0: "PUSH_CONCURRENCY_CONTROL_UNSPECIFIED",
		1: "PUSH_CONCURRENCY_CONTROL_IGNORE_WORKING_SET",
		2: "PUSH_CONCURRENCY_CONTROL_ASSERT_WORKING_SET",
	}
	PushConcurrencyControl_value = map[string]int32{
		"PUSH_CONCURRENCY_CONTROL_UNSPECIFIED":        0,
		"PUSH_CONCURRENCY_CONTROL_IGNORE_WORKING_SET": 1,
		"PUSH_CONCURRENCY_CONTROL_ASSERT_WORKING_SET": 2,
	}
)

func (x PushConcurrencyControl) Enum() *PushConcurrencyControl {
	p := new(PushConcurrencyControl)
	*p = x
	return p
}

func (x PushConcurrencyControl) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PushConcurrencyControl) Descriptor() protoreflect.EnumDescriptor {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_enumTypes[0].Descriptor()
}

func (PushConcurrencyControl) Type() protoreflect.EnumType {
	return &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_enumTypes[0]
}

func (x PushConcurrencyControl) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PushConcurrencyControl.Descriptor instead.
func (PushConcurrencyControl) EnumDescriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{0}
}

type ManifestAppendixOption int32

const (
	ManifestAppendixOption_MANIFEST_APPENDIX_OPTION_UNSPECIFIED ManifestAppendixOption = 0
	ManifestAppendixOption_MANIFEST_APPENDIX_OPTION_SET         ManifestAppendixOption = 1
	ManifestAppendixOption_MANIFEST_APPENDIX_OPTION_APPEND      ManifestAppendixOption = 2
)

// Enum value maps for ManifestAppendixOption.
var (
	ManifestAppendixOption_name = map[int32]string{
		0: "MANIFEST_APPENDIX_OPTION_UNSPECIFIED",
		1: "MANIFEST_APPENDIX_OPTION_SET",
		2: "MANIFEST_APPENDIX_OPTION_APPEND",
	}
	ManifestAppendixOption_value = map[string]int32{
		"MANIFEST_APPENDIX_OPTION_UNSPECIFIED": 0,
		"MANIFEST_APPENDIX_OPTION_SET":         1,
		"MANIFEST_APPENDIX_OPTION_APPEND":      2,
	}
)

func (x ManifestAppendixOption) Enum() *ManifestAppendixOption {
	p := new(ManifestAppendixOption)
	*p = x
	return p
}

func (x ManifestAppendixOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManifestAppendixOption) Descriptor() protoreflect.EnumDescriptor {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_enumTypes[1].Descriptor()
}

func (ManifestAppendixOption) Type() protoreflect.EnumType {
	return &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_enumTypes[1]
}

func (x ManifestAppendixOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManifestAppendixOption.Descriptor instead.
func (ManifestAppendixOption) EnumDescriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{1}
}

// RepoId is how repositories are represented on dolthub, for example
// `dolthub/us-housing-prices-v2` has org = dolthub, repo_name =
// us-housing-prices-v2.
//
// All methods of ChunkStoreService targeting a repository take a RepoId. Many
// will also take a `repo_token`, which can be provided in addition to a
// RepoId. `repo_token`s can be returned from repository-accessing RPCs on
// ChunkStoreService, and providing them instead of RepoId for future calls to
// ChunkStoreService can be more efficient than providing RepoId itself.
// `repo_token`s are fully opaque to the client.
type RepoId struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Org           string                 `protobuf:"bytes,1,opt,name=org,proto3" json:"org,omitempty"`
	RepoName      string                 `protobuf:"bytes,2,opt,name=repo_name,json=repoName,proto3" json:"repo_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RepoId) Reset() {
	*x = RepoId{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepoId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepoId) ProtoMessage() {}

func (x *RepoId) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepoId.ProtoReflect.Descriptor instead.
func (*RepoId) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{0}
}

func (x *RepoId) GetOrg() string {
	if x != nil {
		return x.Org
	}
	return ""
}

func (x *RepoId) GetRepoName() string {
	if x != nil {
		return x.RepoName
	}
	return ""
}

type HasChunksRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RepoId        *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	Hashes        [][]byte               `protobuf:"bytes,2,rep,name=hashes,proto3" json:"hashes,omitempty"`
	RepoToken     string                 `protobuf:"bytes,3,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath      string                 `protobuf:"bytes,4,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HasChunksRequest) Reset() {
	*x = HasChunksRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HasChunksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HasChunksRequest) ProtoMessage() {}

func (x *HasChunksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HasChunksRequest.ProtoReflect.Descriptor instead.
func (*HasChunksRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{1}
}

func (x *HasChunksRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *HasChunksRequest) GetHashes() [][]byte {
	if x != nil {
		return x.Hashes
	}
	return nil
}

func (x *HasChunksRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *HasChunksRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type HasChunksResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Absent        []int32                `protobuf:"varint,1,rep,packed,name=absent,proto3" json:"absent,omitempty"`
	RepoToken     string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HasChunksResponse) Reset() {
	*x = HasChunksResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HasChunksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HasChunksResponse) ProtoMessage() {}

func (x *HasChunksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HasChunksResponse.ProtoReflect.Descriptor instead.
func (*HasChunksResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{2}
}

func (x *HasChunksResponse) GetAbsent() []int32 {
	if x != nil {
		return x.Absent
	}
	return nil
}

func (x *HasChunksResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

type HttpGetChunk struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Url           string                 `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	Hashes        [][]byte               `protobuf:"bytes,2,rep,name=hashes,proto3" json:"hashes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HttpGetChunk) Reset() {
	*x = HttpGetChunk{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpGetChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpGetChunk) ProtoMessage() {}

func (x *HttpGetChunk) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpGetChunk.ProtoReflect.Descriptor instead.
func (*HttpGetChunk) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{3}
}

func (x *HttpGetChunk) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *HttpGetChunk) GetHashes() [][]byte {
	if x != nil {
		return x.Hashes
	}
	return nil
}

type RangeChunk struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Hash   []byte                 `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	Offset uint64                 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	Length uint32                 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	// Archive zStd dictionary spans are indicated with these fields. On the consumer side, the existence
	// of a non-zero dictionary length indicates that the chunk is compressed using zStd. This implies that
	// the chunkSource is an archive source. If the dictionary length is zero, the chunk is compressed using snappy
	// compression (classic NOMS table file or journal chunk use snappy compression).
	DictionaryOffset uint64 `protobuf:"varint,4,opt,name=dictionary_offset,json=dictionaryOffset,proto3" json:"dictionary_offset,omitempty"`
	DictionaryLength uint32 `protobuf:"varint,5,opt,name=dictionary_length,json=dictionaryLength,proto3" json:"dictionary_length,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *RangeChunk) Reset() {
	*x = RangeChunk{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RangeChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RangeChunk) ProtoMessage() {}

func (x *RangeChunk) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RangeChunk.ProtoReflect.Descriptor instead.
func (*RangeChunk) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{4}
}

func (x *RangeChunk) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

func (x *RangeChunk) GetOffset() uint64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *RangeChunk) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *RangeChunk) GetDictionaryOffset() uint64 {
	if x != nil {
		return x.DictionaryOffset
	}
	return 0
}

func (x *RangeChunk) GetDictionaryLength() uint32 {
	if x != nil {
		return x.DictionaryLength
	}
	return 0
}

type HttpGetRange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Url           string                 `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	Ranges        []*RangeChunk          `protobuf:"bytes,2,rep,name=ranges,proto3" json:"ranges,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HttpGetRange) Reset() {
	*x = HttpGetRange{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpGetRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpGetRange) ProtoMessage() {}

func (x *HttpGetRange) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpGetRange.ProtoReflect.Descriptor instead.
func (*HttpGetRange) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{5}
}

func (x *HttpGetRange) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *HttpGetRange) GetRanges() []*RangeChunk {
	if x != nil {
		return x.Ranges
	}
	return nil
}

type DownloadLoc struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Location:
	//
	//	*DownloadLoc_HttpGet
	//	*DownloadLoc_HttpGetRange
	Location       isDownloadLoc_Location      `protobuf_oneof:"location"`
	RefreshAfter   *timestamppb.Timestamp      `protobuf:"bytes,3,opt,name=refresh_after,json=refreshAfter,proto3" json:"refresh_after,omitempty"`
	RefreshRequest *RefreshTableFileUrlRequest `protobuf:"bytes,4,opt,name=refresh_request,json=refreshRequest,proto3" json:"refresh_request,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *DownloadLoc) Reset() {
	*x = DownloadLoc{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownloadLoc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadLoc) ProtoMessage() {}

func (x *DownloadLoc) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadLoc.ProtoReflect.Descriptor instead.
func (*DownloadLoc) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{6}
}

func (x *DownloadLoc) GetLocation() isDownloadLoc_Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *DownloadLoc) GetHttpGet() *HttpGetChunk {
	if x != nil {
		if x, ok := x.Location.(*DownloadLoc_HttpGet); ok {
			return x.HttpGet
		}
	}
	return nil
}

func (x *DownloadLoc) GetHttpGetRange() *HttpGetRange {
	if x != nil {
		if x, ok := x.Location.(*DownloadLoc_HttpGetRange); ok {
			return x.HttpGetRange
		}
	}
	return nil
}

func (x *DownloadLoc) GetRefreshAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.RefreshAfter
	}
	return nil
}

func (x *DownloadLoc) GetRefreshRequest() *RefreshTableFileUrlRequest {
	if x != nil {
		return x.RefreshRequest
	}
	return nil
}

type isDownloadLoc_Location interface {
	isDownloadLoc_Location()
}

type DownloadLoc_HttpGet struct {
	HttpGet *HttpGetChunk `protobuf:"bytes,1,opt,name=http_get,json=httpGet,proto3,oneof"`
}

type DownloadLoc_HttpGetRange struct {
	HttpGetRange *HttpGetRange `protobuf:"bytes,2,opt,name=http_get_range,json=httpGetRange,proto3,oneof"`
}

func (*DownloadLoc_HttpGet) isDownloadLoc_Location() {}

func (*DownloadLoc_HttpGetRange) isDownloadLoc_Location() {}

type HttpPostTableFile struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Url           string                 `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HttpPostTableFile) Reset() {
	*x = HttpPostTableFile{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpPostTableFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpPostTableFile) ProtoMessage() {}

func (x *HttpPostTableFile) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpPostTableFile.ProtoReflect.Descriptor instead.
func (*HttpPostTableFile) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{7}
}

func (x *HttpPostTableFile) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type UploadLoc struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TableFileHash []byte                 `protobuf:"bytes,1,opt,name=table_file_hash,json=tableFileHash,proto3" json:"table_file_hash,omitempty"`
	// Types that are valid to be assigned to Location:
	//
	//	*UploadLoc_HttpPost
	Location      isUploadLoc_Location `protobuf_oneof:"location"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UploadLoc) Reset() {
	*x = UploadLoc{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadLoc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadLoc) ProtoMessage() {}

func (x *UploadLoc) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadLoc.ProtoReflect.Descriptor instead.
func (*UploadLoc) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{8}
}

func (x *UploadLoc) GetTableFileHash() []byte {
	if x != nil {
		return x.TableFileHash
	}
	return nil
}

func (x *UploadLoc) GetLocation() isUploadLoc_Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *UploadLoc) GetHttpPost() *HttpPostTableFile {
	if x != nil {
		if x, ok := x.Location.(*UploadLoc_HttpPost); ok {
			return x.HttpPost
		}
	}
	return nil
}

type isUploadLoc_Location interface {
	isUploadLoc_Location()
}

type UploadLoc_HttpPost struct {
	HttpPost *HttpPostTableFile `protobuf:"bytes,2,opt,name=http_post,json=httpPost,proto3,oneof"`
}

func (*UploadLoc_HttpPost) isUploadLoc_Location() {}

type GetDownloadLocsRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RepoId        *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	ChunkHashes   [][]byte               `protobuf:"bytes,2,rep,name=chunk_hashes,json=chunkHashes,proto3" json:"chunk_hashes,omitempty"`
	RepoToken     string                 `protobuf:"bytes,3,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath      string                 `protobuf:"bytes,4,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetDownloadLocsRequest) Reset() {
	*x = GetDownloadLocsRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDownloadLocsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDownloadLocsRequest) ProtoMessage() {}

func (x *GetDownloadLocsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDownloadLocsRequest.ProtoReflect.Descriptor instead.
func (*GetDownloadLocsRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{9}
}

func (x *GetDownloadLocsRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *GetDownloadLocsRequest) GetChunkHashes() [][]byte {
	if x != nil {
		return x.ChunkHashes
	}
	return nil
}

func (x *GetDownloadLocsRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *GetDownloadLocsRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type GetDownloadLocsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Locs          []*DownloadLoc         `protobuf:"bytes,1,rep,name=locs,proto3" json:"locs,omitempty"`
	RepoToken     string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetDownloadLocsResponse) Reset() {
	*x = GetDownloadLocsResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDownloadLocsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDownloadLocsResponse) ProtoMessage() {}

func (x *GetDownloadLocsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDownloadLocsResponse.ProtoReflect.Descriptor instead.
func (*GetDownloadLocsResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{10}
}

func (x *GetDownloadLocsResponse) GetLocs() []*DownloadLoc {
	if x != nil {
		return x.Locs
	}
	return nil
}

func (x *GetDownloadLocsResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

type TableFileDetails struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            []byte                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	ContentLength uint64                 `protobuf:"varint,2,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
	ContentHash   []byte                 `protobuf:"bytes,3,opt,name=content_hash,json=contentHash,proto3" json:"content_hash,omitempty"`
	NumChunks     uint64                 `protobuf:"varint,4,opt,name=num_chunks,json=numChunks,proto3" json:"num_chunks,omitempty"`
	Suffix        string                 `protobuf:"bytes,5,opt,name=suffix,proto3" json:"suffix,omitempty"`
	SplitOffset   uint64                 `protobuf:"varint,6,opt,name=split_offset,json=splitOffset,proto3" json:"split_offset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TableFileDetails) Reset() {
	*x = TableFileDetails{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TableFileDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableFileDetails) ProtoMessage() {}

func (x *TableFileDetails) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableFileDetails.ProtoReflect.Descriptor instead.
func (*TableFileDetails) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{11}
}

func (x *TableFileDetails) GetId() []byte {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *TableFileDetails) GetContentLength() uint64 {
	if x != nil {
		return x.ContentLength
	}
	return 0
}

func (x *TableFileDetails) GetContentHash() []byte {
	if x != nil {
		return x.ContentHash
	}
	return nil
}

func (x *TableFileDetails) GetNumChunks() uint64 {
	if x != nil {
		return x.NumChunks
	}
	return 0
}

func (x *TableFileDetails) GetSuffix() string {
	if x != nil {
		return x.Suffix
	}
	return ""
}

func (x *TableFileDetails) GetSplitOffset() uint64 {
	if x != nil {
		return x.SplitOffset
	}
	return 0
}

type GetUploadLocsRequest struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	RepoId *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	// Deprecated: Marked as deprecated in dolt/services/remotesapi/v1alpha1/chunkstore.proto.
	TableFileHashes  [][]byte            `protobuf:"bytes,2,rep,name=table_file_hashes,json=tableFileHashes,proto3" json:"table_file_hashes,omitempty"`
	TableFileDetails []*TableFileDetails `protobuf:"bytes,3,rep,name=table_file_details,json=tableFileDetails,proto3" json:"table_file_details,omitempty"`
	RepoToken        string              `protobuf:"bytes,4,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath         string              `protobuf:"bytes,5,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GetUploadLocsRequest) Reset() {
	*x = GetUploadLocsRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUploadLocsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUploadLocsRequest) ProtoMessage() {}

func (x *GetUploadLocsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUploadLocsRequest.ProtoReflect.Descriptor instead.
func (*GetUploadLocsRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{12}
}

func (x *GetUploadLocsRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

// Deprecated: Marked as deprecated in dolt/services/remotesapi/v1alpha1/chunkstore.proto.
func (x *GetUploadLocsRequest) GetTableFileHashes() [][]byte {
	if x != nil {
		return x.TableFileHashes
	}
	return nil
}

func (x *GetUploadLocsRequest) GetTableFileDetails() []*TableFileDetails {
	if x != nil {
		return x.TableFileDetails
	}
	return nil
}

func (x *GetUploadLocsRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *GetUploadLocsRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type GetUploadLocsResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Locs          []*UploadLoc           `protobuf:"bytes,1,rep,name=locs,proto3" json:"locs,omitempty"`
	RepoToken     string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUploadLocsResponse) Reset() {
	*x = GetUploadLocsResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUploadLocsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUploadLocsResponse) ProtoMessage() {}

func (x *GetUploadLocsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUploadLocsResponse.ProtoReflect.Descriptor instead.
func (*GetUploadLocsResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{13}
}

func (x *GetUploadLocsResponse) GetLocs() []*UploadLoc {
	if x != nil {
		return x.Locs
	}
	return nil
}

func (x *GetUploadLocsResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

type RebaseRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RepoId        *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	RepoToken     string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath      string                 `protobuf:"bytes,3,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RebaseRequest) Reset() {
	*x = RebaseRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RebaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RebaseRequest) ProtoMessage() {}

func (x *RebaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RebaseRequest.ProtoReflect.Descriptor instead.
func (*RebaseRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{14}
}

func (x *RebaseRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *RebaseRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *RebaseRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type RebaseResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RepoToken     string                 `protobuf:"bytes,1,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RebaseResponse) Reset() {
	*x = RebaseResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RebaseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RebaseResponse) ProtoMessage() {}

func (x *RebaseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RebaseResponse.ProtoReflect.Descriptor instead.
func (*RebaseResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{15}
}

func (x *RebaseResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

type RootRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RepoId        *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	RepoToken     string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath      string                 `protobuf:"bytes,3,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RootRequest) Reset() {
	*x = RootRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RootRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RootRequest) ProtoMessage() {}

func (x *RootRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RootRequest.ProtoReflect.Descriptor instead.
func (*RootRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{16}
}

func (x *RootRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *RootRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *RootRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type RootResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RootHash      []byte                 `protobuf:"bytes,1,opt,name=root_hash,json=rootHash,proto3" json:"root_hash,omitempty"`
	RepoToken     string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RootResponse) Reset() {
	*x = RootResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RootResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RootResponse) ProtoMessage() {}

func (x *RootResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RootResponse.ProtoReflect.Descriptor instead.
func (*RootResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{17}
}

func (x *RootResponse) GetRootHash() []byte {
	if x != nil {
		return x.RootHash
	}
	return nil
}

func (x *RootResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

type ChunkTableInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Hash          []byte                 `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	ChunkCount    uint32                 `protobuf:"varint,2,opt,name=chunk_count,json=chunkCount,proto3" json:"chunk_count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChunkTableInfo) Reset() {
	*x = ChunkTableInfo{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChunkTableInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChunkTableInfo) ProtoMessage() {}

func (x *ChunkTableInfo) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChunkTableInfo.ProtoReflect.Descriptor instead.
func (*ChunkTableInfo) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{18}
}

func (x *ChunkTableInfo) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

func (x *ChunkTableInfo) GetChunkCount() uint32 {
	if x != nil {
		return x.ChunkCount
	}
	return 0
}

type CommitRequest struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	RepoId           *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	Current          []byte                 `protobuf:"bytes,2,opt,name=current,proto3" json:"current,omitempty"`
	Last             []byte                 `protobuf:"bytes,3,opt,name=last,proto3" json:"last,omitempty"`
	ChunkTableInfo   []*ChunkTableInfo      `protobuf:"bytes,4,rep,name=chunk_table_info,json=chunkTableInfo,proto3" json:"chunk_table_info,omitempty"`
	ClientRepoFormat *ClientRepoFormat      `protobuf:"bytes,14,opt,name=client_repo_format,json=clientRepoFormat,proto3" json:"client_repo_format,omitempty"`
	RepoPath         string                 `protobuf:"bytes,5,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{19}
}

func (x *CommitRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *CommitRequest) GetCurrent() []byte {
	if x != nil {
		return x.Current
	}
	return nil
}

func (x *CommitRequest) GetLast() []byte {
	if x != nil {
		return x.Last
	}
	return nil
}

func (x *CommitRequest) GetChunkTableInfo() []*ChunkTableInfo {
	if x != nil {
		return x.ChunkTableInfo
	}
	return nil
}

func (x *CommitRequest) GetClientRepoFormat() *ClientRepoFormat {
	if x != nil {
		return x.ClientRepoFormat
	}
	return nil
}

func (x *CommitRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type CommitResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Success       bool                   `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse.ProtoReflect.Descriptor instead.
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{20}
}

func (x *CommitResponse) GetSuccess() bool {
	if x != nil {
		return x.Success
	}
	return false
}

type GetRepoMetadataRequest struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	RepoId           *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	ClientRepoFormat *ClientRepoFormat      `protobuf:"bytes,14,opt,name=client_repo_format,json=clientRepoFormat,proto3" json:"client_repo_format,omitempty"`
	RepoToken        string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath         string                 `protobuf:"bytes,3,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GetRepoMetadataRequest) Reset() {
	*x = GetRepoMetadataRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepoMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepoMetadataRequest) ProtoMessage() {}

func (x *GetRepoMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRepoMetadataRequest.ProtoReflect.Descriptor instead.
func (*GetRepoMetadataRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{21}
}

func (x *GetRepoMetadataRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *GetRepoMetadataRequest) GetClientRepoFormat() *ClientRepoFormat {
	if x != nil {
		return x.ClientRepoFormat
	}
	return nil
}

func (x *GetRepoMetadataRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *GetRepoMetadataRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type GetRepoMetadataResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version string of the noms binary format for this repository.
	// See types.NomsBinFormat.
	NbfVersion string `protobuf:"bytes,1,opt,name=nbf_version,json=nbfVersion,proto3" json:"nbf_version,omitempty"`
	// Version string of the nbs format of this repository.
	// See nbs.StorageVersion.
	NbsVersion string `protobuf:"bytes,2,opt,name=nbs_version,json=nbsVersion,proto3" json:"nbs_version,omitempty"`
	// Approximate number of bytes required for storage of all
	// currently-referenced repository table files.
	StorageSize            uint64                 `protobuf:"varint,3,opt,name=storage_size,json=storageSize,proto3" json:"storage_size,omitempty"`
	RepoToken              string                 `protobuf:"bytes,4,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	PushConcurrencyControl PushConcurrencyControl `protobuf:"varint,5,opt,name=push_concurrency_control,json=pushConcurrencyControl,proto3,enum=dolt.services.remotesapi.v1alpha1.PushConcurrencyControl" json:"push_concurrency_control,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *GetRepoMetadataResponse) Reset() {
	*x = GetRepoMetadataResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepoMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepoMetadataResponse) ProtoMessage() {}

func (x *GetRepoMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRepoMetadataResponse.ProtoReflect.Descriptor instead.
func (*GetRepoMetadataResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{22}
}

func (x *GetRepoMetadataResponse) GetNbfVersion() string {
	if x != nil {
		return x.NbfVersion
	}
	return ""
}

func (x *GetRepoMetadataResponse) GetNbsVersion() string {
	if x != nil {
		return x.NbsVersion
	}
	return ""
}

func (x *GetRepoMetadataResponse) GetStorageSize() uint64 {
	if x != nil {
		return x.StorageSize
	}
	return 0
}

func (x *GetRepoMetadataResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *GetRepoMetadataResponse) GetPushConcurrencyControl() PushConcurrencyControl {
	if x != nil {
		return x.PushConcurrencyControl
	}
	return PushConcurrencyControl_PUSH_CONCURRENCY_CONTROL_UNSPECIFIED
}

type ClientRepoFormat struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NbfVersion    string                 `protobuf:"bytes,1,opt,name=nbf_version,json=nbfVersion,proto3" json:"nbf_version,omitempty"`
	NbsVersion    string                 `protobuf:"bytes,2,opt,name=nbs_version,json=nbsVersion,proto3" json:"nbs_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClientRepoFormat) Reset() {
	*x = ClientRepoFormat{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientRepoFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientRepoFormat) ProtoMessage() {}

func (x *ClientRepoFormat) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientRepoFormat.ProtoReflect.Descriptor instead.
func (*ClientRepoFormat) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{23}
}

func (x *ClientRepoFormat) GetNbfVersion() string {
	if x != nil {
		return x.NbfVersion
	}
	return ""
}

func (x *ClientRepoFormat) GetNbsVersion() string {
	if x != nil {
		return x.NbsVersion
	}
	return ""
}

type ListTableFilesRequest struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	RepoId *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	// Deprecated: Marked as deprecated in dolt/services/remotesapi/v1alpha1/chunkstore.proto.
	AppendixOnly  bool   `protobuf:"varint,2,opt,name=appendix_only,json=appendixOnly,proto3" json:"appendix_only,omitempty"`
	RepoToken     string `protobuf:"bytes,3,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath      string `protobuf:"bytes,4,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTableFilesRequest) Reset() {
	*x = ListTableFilesRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTableFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTableFilesRequest) ProtoMessage() {}

func (x *ListTableFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTableFilesRequest.ProtoReflect.Descriptor instead.
func (*ListTableFilesRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{24}
}

func (x *ListTableFilesRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

// Deprecated: Marked as deprecated in dolt/services/remotesapi/v1alpha1/chunkstore.proto.
func (x *ListTableFilesRequest) GetAppendixOnly() bool {
	if x != nil {
		return x.AppendixOnly
	}
	return false
}

func (x *ListTableFilesRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *ListTableFilesRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type TableFileInfo struct {
	state          protoimpl.MessageState      `protogen:"open.v1"`
	FileId         string                      `protobuf:"bytes,1,opt,name=file_id,json=fileId,proto3" json:"file_id,omitempty"`
	NumChunks      uint32                      `protobuf:"varint,2,opt,name=num_chunks,json=numChunks,proto3" json:"num_chunks,omitempty"`
	Url            string                      `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	RefreshAfter   *timestamppb.Timestamp      `protobuf:"bytes,4,opt,name=refresh_after,json=refreshAfter,proto3" json:"refresh_after,omitempty"`
	RefreshRequest *RefreshTableFileUrlRequest `protobuf:"bytes,5,opt,name=refresh_request,json=refreshRequest,proto3" json:"refresh_request,omitempty"`
	SplitOffset    uint64                      `protobuf:"varint,6,opt,name=split_offset,json=splitOffset,proto3" json:"split_offset,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *TableFileInfo) Reset() {
	*x = TableFileInfo{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TableFileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableFileInfo) ProtoMessage() {}

func (x *TableFileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableFileInfo.ProtoReflect.Descriptor instead.
func (*TableFileInfo) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{25}
}

func (x *TableFileInfo) GetFileId() string {
	if x != nil {
		return x.FileId
	}
	return ""
}

func (x *TableFileInfo) GetNumChunks() uint32 {
	if x != nil {
		return x.NumChunks
	}
	return 0
}

func (x *TableFileInfo) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *TableFileInfo) GetRefreshAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.RefreshAfter
	}
	return nil
}

func (x *TableFileInfo) GetRefreshRequest() *RefreshTableFileUrlRequest {
	if x != nil {
		return x.RefreshRequest
	}
	return nil
}

func (x *TableFileInfo) GetSplitOffset() uint64 {
	if x != nil {
		return x.SplitOffset
	}
	return 0
}

type RefreshTableFileUrlRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RepoId        *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	FileId        string                 `protobuf:"bytes,2,opt,name=file_id,json=fileId,proto3" json:"file_id,omitempty"`
	RepoToken     string                 `protobuf:"bytes,3,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath      string                 `protobuf:"bytes,4,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RefreshTableFileUrlRequest) Reset() {
	*x = RefreshTableFileUrlRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RefreshTableFileUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshTableFileUrlRequest) ProtoMessage() {}

func (x *RefreshTableFileUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshTableFileUrlRequest.ProtoReflect.Descriptor instead.
func (*RefreshTableFileUrlRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{26}
}

func (x *RefreshTableFileUrlRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *RefreshTableFileUrlRequest) GetFileId() string {
	if x != nil {
		return x.FileId
	}
	return ""
}

func (x *RefreshTableFileUrlRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *RefreshTableFileUrlRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type RefreshTableFileUrlResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Url           string                 `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	RefreshAfter  *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=refresh_after,json=refreshAfter,proto3" json:"refresh_after,omitempty"`
	RepoToken     string                 `protobuf:"bytes,3,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RefreshTableFileUrlResponse) Reset() {
	*x = RefreshTableFileUrlResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RefreshTableFileUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefreshTableFileUrlResponse) ProtoMessage() {}

func (x *RefreshTableFileUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefreshTableFileUrlResponse.ProtoReflect.Descriptor instead.
func (*RefreshTableFileUrlResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{27}
}

func (x *RefreshTableFileUrlResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *RefreshTableFileUrlResponse) GetRefreshAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.RefreshAfter
	}
	return nil
}

func (x *RefreshTableFileUrlResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

type ListTableFilesResponse struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	RootHash              []byte                 `protobuf:"bytes,1,opt,name=root_hash,json=rootHash,proto3" json:"root_hash,omitempty"`
	TableFileInfo         []*TableFileInfo       `protobuf:"bytes,2,rep,name=table_file_info,json=tableFileInfo,proto3" json:"table_file_info,omitempty"`
	AppendixTableFileInfo []*TableFileInfo       `protobuf:"bytes,3,rep,name=appendix_table_file_info,json=appendixTableFileInfo,proto3" json:"appendix_table_file_info,omitempty"`
	RepoToken             string                 `protobuf:"bytes,4,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ListTableFilesResponse) Reset() {
	*x = ListTableFilesResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTableFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTableFilesResponse) ProtoMessage() {}

func (x *ListTableFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTableFilesResponse.ProtoReflect.Descriptor instead.
func (*ListTableFilesResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{28}
}

func (x *ListTableFilesResponse) GetRootHash() []byte {
	if x != nil {
		return x.RootHash
	}
	return nil
}

func (x *ListTableFilesResponse) GetTableFileInfo() []*TableFileInfo {
	if x != nil {
		return x.TableFileInfo
	}
	return nil
}

func (x *ListTableFilesResponse) GetAppendixTableFileInfo() []*TableFileInfo {
	if x != nil {
		return x.AppendixTableFileInfo
	}
	return nil
}

func (x *ListTableFilesResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

type AddTableFilesRequest struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	RepoId           *RepoId                `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	ClientRepoFormat *ClientRepoFormat      `protobuf:"bytes,2,opt,name=client_repo_format,json=clientRepoFormat,proto3" json:"client_repo_format,omitempty"`
	ChunkTableInfo   []*ChunkTableInfo      `protobuf:"bytes,3,rep,name=chunk_table_info,json=chunkTableInfo,proto3" json:"chunk_table_info,omitempty"`
	// If set, this is a write for the manifest appendix, not just the manifest table file specs.
	// The table files appearing in `chunk_table_info` are added to `specs` and are also set
	// in the manifest appendix. If `appendix_option` is `SET`, then the value of the appendix
	// becomes the full list provided in `chunk_table_info` and any prior specs in the appendix
	// are removed from the manifest specs. If `append_option` is `APPEND`, then the
	// supplied table files are added to the appendix and to specs.
	AppendixOption ManifestAppendixOption `protobuf:"varint,4,opt,name=appendix_option,json=appendixOption,proto3,enum=dolt.services.remotesapi.v1alpha1.ManifestAppendixOption" json:"appendix_option,omitempty"`
	RepoToken      string                 `protobuf:"bytes,5,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	RepoPath       string                 `protobuf:"bytes,6,opt,name=repo_path,json=repoPath,proto3" json:"repo_path,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *AddTableFilesRequest) Reset() {
	*x = AddTableFilesRequest{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddTableFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTableFilesRequest) ProtoMessage() {}

func (x *AddTableFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTableFilesRequest.ProtoReflect.Descriptor instead.
func (*AddTableFilesRequest) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{29}
}

func (x *AddTableFilesRequest) GetRepoId() *RepoId {
	if x != nil {
		return x.RepoId
	}
	return nil
}

func (x *AddTableFilesRequest) GetClientRepoFormat() *ClientRepoFormat {
	if x != nil {
		return x.ClientRepoFormat
	}
	return nil
}

func (x *AddTableFilesRequest) GetChunkTableInfo() []*ChunkTableInfo {
	if x != nil {
		return x.ChunkTableInfo
	}
	return nil
}

func (x *AddTableFilesRequest) GetAppendixOption() ManifestAppendixOption {
	if x != nil {
		return x.AppendixOption
	}
	return ManifestAppendixOption_MANIFEST_APPENDIX_OPTION_UNSPECIFIED
}

func (x *AddTableFilesRequest) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

func (x *AddTableFilesRequest) GetRepoPath() string {
	if x != nil {
		return x.RepoPath
	}
	return ""
}

type AddTableFilesResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Success       bool                   `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	RepoToken     string                 `protobuf:"bytes,2,opt,name=repo_token,json=repoToken,proto3" json:"repo_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddTableFilesResponse) Reset() {
	*x = AddTableFilesResponse{}
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddTableFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTableFilesResponse) ProtoMessage() {}

func (x *AddTableFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTableFilesResponse.ProtoReflect.Descriptor instead.
func (*AddTableFilesResponse) Descriptor() ([]byte, []int) {
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP(), []int{30}
}

func (x *AddTableFilesResponse) GetSuccess() bool {
	if x != nil {
		return x.Success
	}
	return false
}

func (x *AddTableFilesResponse) GetRepoToken() string {
	if x != nil {
		return x.RepoToken
	}
	return ""
}

var File_dolt_services_remotesapi_v1alpha1_chunkstore_proto protoreflect.FileDescriptor

const file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDesc = "" +
	"\n" +
	"2dolt/services/remotesapi/v1alpha1/chunkstore.proto\x12!dolt.services.remotesapi.v1alpha1\x1a\x1fgoogle/protobuf/timestamp.proto\"7\n" +
	"\x06RepoId\x12\x10\n" +
	"\x03org\x18\x01 \x01(\tR\x03org\x12\x1b\n" +
	"\trepo_name\x18\x02 \x01(\tR\brepoName\"\xaa\x01\n" +
	"\x10HasChunksRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12\x16\n" +
	"\x06hashes\x18\x02 \x03(\fR\x06hashes\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x03 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x04 \x01(\tR\brepoPath\"J\n" +
	"\x11HasChunksResponse\x12\x16\n" +
	"\x06absent\x18\x01 \x03(\x05R\x06absent\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken\"8\n" +
	"\fHttpGetChunk\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12\x16\n" +
	"\x06hashes\x18\x02 \x03(\fR\x06hashes\"\xaa\x01\n" +
	"\n" +
	"RangeChunk\x12\x12\n" +
	"\x04hash\x18\x01 \x01(\fR\x04hash\x12\x16\n" +
	"\x06offset\x18\x02 \x01(\x04R\x06offset\x12\x16\n" +
	"\x06length\x18\x03 \x01(\rR\x06length\x12+\n" +
	"\x11dictionary_offset\x18\x04 \x01(\x04R\x10dictionaryOffset\x12+\n" +
	"\x11dictionary_length\x18\x05 \x01(\rR\x10dictionaryLength\"g\n" +
	"\fHttpGetRange\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12E\n" +
	"\x06ranges\x18\x02 \x03(\v2-.dolt.services.remotesapi.v1alpha1.RangeChunkR\x06ranges\"\xe9\x02\n" +
	"\vDownloadLoc\x12L\n" +
	"\bhttp_get\x18\x01 \x01(\v2/.dolt.services.remotesapi.v1alpha1.HttpGetChunkH\x00R\ahttpGet\x12W\n" +
	"\x0ehttp_get_range\x18\x02 \x01(\v2/.dolt.services.remotesapi.v1alpha1.HttpGetRangeH\x00R\fhttpGetRange\x12?\n" +
	"\rrefresh_after\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\frefreshAfter\x12f\n" +
	"\x0frefresh_request\x18\x04 \x01(\v2=.dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequestR\x0erefreshRequestB\n" +
	"\n" +
	"\blocation\"%\n" +
	"\x11HttpPostTableFile\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\"\x94\x01\n" +
	"\tUploadLoc\x12&\n" +
	"\x0ftable_file_hash\x18\x01 \x01(\fR\rtableFileHash\x12S\n" +
	"\thttp_post\x18\x02 \x01(\v24.dolt.services.remotesapi.v1alpha1.HttpPostTableFileH\x00R\bhttpPostB\n" +
	"\n" +
	"\blocation\"\xbb\x01\n" +
	"\x16GetDownloadLocsRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12!\n" +
	"\fchunk_hashes\x18\x02 \x03(\fR\vchunkHashes\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x03 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x04 \x01(\tR\brepoPath\"|\n" +
	"\x17GetDownloadLocsResponse\x12B\n" +
	"\x04locs\x18\x01 \x03(\v2..dolt.services.remotesapi.v1alpha1.DownloadLocR\x04locs\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken\"\xc6\x01\n" +
	"\x10TableFileDetails\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\fR\x02id\x12%\n" +
	"\x0econtent_length\x18\x02 \x01(\x04R\rcontentLength\x12!\n" +
	"\fcontent_hash\x18\x03 \x01(\fR\vcontentHash\x12\x1d\n" +
	"\n" +
	"num_chunks\x18\x04 \x01(\x04R\tnumChunks\x12\x16\n" +
	"\x06suffix\x18\x05 \x01(\tR\x06suffix\x12!\n" +
	"\fsplit_offset\x18\x06 \x01(\x04R\vsplitOffset\"\xa9\x02\n" +
	"\x14GetUploadLocsRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12.\n" +
	"\x11table_file_hashes\x18\x02 \x03(\fB\x02\x18\x01R\x0ftableFileHashes\x12a\n" +
	"\x12table_file_details\x18\x03 \x03(\v23.dolt.services.remotesapi.v1alpha1.TableFileDetailsR\x10tableFileDetails\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x04 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x05 \x01(\tR\brepoPath\"x\n" +
	"\x15GetUploadLocsResponse\x12@\n" +
	"\x04locs\x18\x01 \x03(\v2,.dolt.services.remotesapi.v1alpha1.UploadLocR\x04locs\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken\"\x8f\x01\n" +
	"\rRebaseRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x03 \x01(\tR\brepoPath\"/\n" +
	"\x0eRebaseResponse\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x01 \x01(\tR\trepoToken\"\x8d\x01\n" +
	"\vRootRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x03 \x01(\tR\brepoPath\"J\n" +
	"\fRootResponse\x12\x1b\n" +
	"\troot_hash\x18\x01 \x01(\fR\brootHash\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken\"E\n" +
	"\x0eChunkTableInfo\x12\x12\n" +
	"\x04hash\x18\x01 \x01(\fR\x04hash\x12\x1f\n" +
	"\vchunk_count\x18\x02 \x01(\rR\n" +
	"chunkCount\"\xde\x02\n" +
	"\rCommitRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12\x18\n" +
	"\acurrent\x18\x02 \x01(\fR\acurrent\x12\x12\n" +
	"\x04last\x18\x03 \x01(\fR\x04last\x12[\n" +
	"\x10chunk_table_info\x18\x04 \x03(\v21.dolt.services.remotesapi.v1alpha1.ChunkTableInfoR\x0echunkTableInfo\x12a\n" +
	"\x12client_repo_format\x18\x0e \x01(\v23.dolt.services.remotesapi.v1alpha1.ClientRepoFormatR\x10clientRepoFormat\x12\x1b\n" +
	"\trepo_path\x18\x05 \x01(\tR\brepoPath\"*\n" +
	"\x0eCommitResponse\x12\x18\n" +
	"\asuccess\x18\x01 \x01(\bR\asuccess\"\xfb\x01\n" +
	"\x16GetRepoMetadataRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12a\n" +
	"\x12client_repo_format\x18\x0e \x01(\v23.dolt.services.remotesapi.v1alpha1.ClientRepoFormatR\x10clientRepoFormat\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x03 \x01(\tR\brepoPath\"\x92\x02\n" +
	"\x17GetRepoMetadataResponse\x12\x1f\n" +
	"\vnbf_version\x18\x01 \x01(\tR\n" +
	"nbfVersion\x12\x1f\n" +
	"\vnbs_version\x18\x02 \x01(\tR\n" +
	"nbsVersion\x12!\n" +
	"\fstorage_size\x18\x03 \x01(\x04R\vstorageSize\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x04 \x01(\tR\trepoToken\x12s\n" +
	"\x18push_concurrency_control\x18\x05 \x01(\x0e29.dolt.services.remotesapi.v1alpha1.PushConcurrencyControlR\x16pushConcurrencyControl\"T\n" +
	"\x10ClientRepoFormat\x12\x1f\n" +
	"\vnbf_version\x18\x01 \x01(\tR\n" +
	"nbfVersion\x12\x1f\n" +
	"\vnbs_version\x18\x02 \x01(\tR\n" +
	"nbsVersion\"\xc0\x01\n" +
	"\x15ListTableFilesRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12'\n" +
	"\rappendix_only\x18\x02 \x01(\bB\x02\x18\x01R\fappendixOnly\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x03 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x04 \x01(\tR\brepoPath\"\xa5\x02\n" +
	"\rTableFileInfo\x12\x17\n" +
	"\afile_id\x18\x01 \x01(\tR\x06fileId\x12\x1d\n" +
	"\n" +
	"num_chunks\x18\x02 \x01(\rR\tnumChunks\x12\x10\n" +
	"\x03url\x18\x03 \x01(\tR\x03url\x12?\n" +
	"\rrefresh_after\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\frefreshAfter\x12f\n" +
	"\x0frefresh_request\x18\x05 \x01(\v2=.dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequestR\x0erefreshRequest\x12!\n" +
	"\fsplit_offset\x18\x06 \x01(\x04R\vsplitOffset\"\xb5\x01\n" +
	"\x1aRefreshTableFileUrlRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12\x17\n" +
	"\afile_id\x18\x02 \x01(\tR\x06fileId\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x03 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x04 \x01(\tR\brepoPath\"\x8f\x01\n" +
	"\x1bRefreshTableFileUrlResponse\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12?\n" +
	"\rrefresh_after\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\frefreshAfter\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x03 \x01(\tR\trepoToken\"\x99\x02\n" +
	"\x16ListTableFilesResponse\x12\x1b\n" +
	"\troot_hash\x18\x01 \x01(\fR\brootHash\x12X\n" +
	"\x0ftable_file_info\x18\x02 \x03(\v20.dolt.services.remotesapi.v1alpha1.TableFileInfoR\rtableFileInfo\x12i\n" +
	"\x18appendix_table_file_info\x18\x03 \x03(\v20.dolt.services.remotesapi.v1alpha1.TableFileInfoR\x15appendixTableFileInfo\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x04 \x01(\tR\trepoToken\"\xba\x03\n" +
	"\x14AddTableFilesRequest\x12B\n" +
	"\arepo_id\x18\x01 \x01(\v2).dolt.services.remotesapi.v1alpha1.RepoIdR\x06repoId\x12a\n" +
	"\x12client_repo_format\x18\x02 \x01(\v23.dolt.services.remotesapi.v1alpha1.ClientRepoFormatR\x10clientRepoFormat\x12[\n" +
	"\x10chunk_table_info\x18\x03 \x03(\v21.dolt.services.remotesapi.v1alpha1.ChunkTableInfoR\x0echunkTableInfo\x12b\n" +
	"\x0fappendix_option\x18\x04 \x01(\x0e29.dolt.services.remotesapi.v1alpha1.ManifestAppendixOptionR\x0eappendixOption\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x05 \x01(\tR\trepoToken\x12\x1b\n" +
	"\trepo_path\x18\x06 \x01(\tR\brepoPath\"P\n" +
	"\x15AddTableFilesResponse\x12\x18\n" +
	"\asuccess\x18\x01 \x01(\bR\asuccess\x12\x1d\n" +
	"\n" +
	"repo_token\x18\x02 \x01(\tR\trepoToken*\xa4\x01\n" +
	"\x16PushConcurrencyControl\x12(\n" +
	"$PUSH_CONCURRENCY_CONTROL_UNSPECIFIED\x10\x00\x12/\n" +
	"+PUSH_CONCURRENCY_CONTROL_IGNORE_WORKING_SET\x10\x01\x12/\n" +
	"+PUSH_CONCURRENCY_CONTROL_ASSERT_WORKING_SET\x10\x02*\x89\x01\n" +
	"\x16ManifestAppendixOption\x12(\n" +
	"$MANIFEST_APPENDIX_OPTION_UNSPECIFIED\x10\x00\x12 \n" +
	"\x1cMANIFEST_APPENDIX_OPTION_SET\x10\x01\x12#\n" +
	"\x1fMANIFEST_APPENDIX_OPTION_APPEND\x10\x022\xb2\v\n" +
	"\x11ChunkStoreService\x12\x88\x01\n" +
	"\x0fGetRepoMetadata\x129.dolt.services.remotesapi.v1alpha1.GetRepoMetadataRequest\x1a:.dolt.services.remotesapi.v1alpha1.GetRepoMetadataResponse\x12v\n" +
	"\tHasChunks\x123.dolt.services.remotesapi.v1alpha1.HasChunksRequest\x1a4.dolt.services.remotesapi.v1alpha1.HasChunksResponse\x12\x8d\x01\n" +
	"\x14GetDownloadLocations\x129.dolt.services.remotesapi.v1alpha1.GetDownloadLocsRequest\x1a:.dolt.services.remotesapi.v1alpha1.GetDownloadLocsResponse\x12\x94\x01\n" +
	"\x17StreamDownloadLocations\x129.dolt.services.remotesapi.v1alpha1.GetDownloadLocsRequest\x1a:.dolt.services.remotesapi.v1alpha1.GetDownloadLocsResponse(\x010\x01\x12\x87\x01\n" +
	"\x12GetUploadLocations\x127.dolt.services.remotesapi.v1alpha1.GetUploadLocsRequest\x1a8.dolt.services.remotesapi.v1alpha1.GetUploadLocsResponse\x12m\n" +
	"\x06Rebase\x120.dolt.services.remotesapi.v1alpha1.RebaseRequest\x1a1.dolt.services.remotesapi.v1alpha1.RebaseResponse\x12g\n" +
	"\x04Root\x12..dolt.services.remotesapi.v1alpha1.RootRequest\x1a/.dolt.services.remotesapi.v1alpha1.RootResponse\x12m\n" +
	"\x06Commit\x120.dolt.services.remotesapi.v1alpha1.CommitRequest\x1a1.dolt.services.remotesapi.v1alpha1.CommitResponse\x12\x85\x01\n" +
	"\x0eListTableFiles\x128.dolt.services.remotesapi.v1alpha1.ListTableFilesRequest\x1a9.dolt.services.remotesapi.v1alpha1.ListTableFilesResponse\x12\x94\x01\n" +
	"\x13RefreshTableFileUrl\x12=.dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequest\x1a>.dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlResponse\x12\x82\x01\n" +
	"\rAddTableFiles\x127.dolt.services.remotesapi.v1alpha1.AddTableFilesRequest\x1a8.dolt.services.remotesapi.v1alpha1.AddTableFilesResponseBSZQgithub.com/dolthub/dolt/go/gen/proto/dolt/services/remotesapi/v1alpha1;remotesapib\x06proto3"

var (
	file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescOnce sync.Once
	file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescData []byte
)

func file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescGZIP() []byte {
	file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescOnce.Do(func() {
		file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDesc), len(file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDesc)))
	})
	return file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDescData
}

var file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_goTypes = []any{
	(PushConcurrencyControl)(0),         // 0: dolt.services.remotesapi.v1alpha1.PushConcurrencyControl
	(ManifestAppendixOption)(0),         // 1: dolt.services.remotesapi.v1alpha1.ManifestAppendixOption
	(*RepoId)(nil),                      // 2: dolt.services.remotesapi.v1alpha1.RepoId
	(*HasChunksRequest)(nil),            // 3: dolt.services.remotesapi.v1alpha1.HasChunksRequest
	(*HasChunksResponse)(nil),           // 4: dolt.services.remotesapi.v1alpha1.HasChunksResponse
	(*HttpGetChunk)(nil),                // 5: dolt.services.remotesapi.v1alpha1.HttpGetChunk
	(*RangeChunk)(nil),                  // 6: dolt.services.remotesapi.v1alpha1.RangeChunk
	(*HttpGetRange)(nil),                // 7: dolt.services.remotesapi.v1alpha1.HttpGetRange
	(*DownloadLoc)(nil),                 // 8: dolt.services.remotesapi.v1alpha1.DownloadLoc
	(*HttpPostTableFile)(nil),           // 9: dolt.services.remotesapi.v1alpha1.HttpPostTableFile
	(*UploadLoc)(nil),                   // 10: dolt.services.remotesapi.v1alpha1.UploadLoc
	(*GetDownloadLocsRequest)(nil),      // 11: dolt.services.remotesapi.v1alpha1.GetDownloadLocsRequest
	(*GetDownloadLocsResponse)(nil),     // 12: dolt.services.remotesapi.v1alpha1.GetDownloadLocsResponse
	(*TableFileDetails)(nil),            // 13: dolt.services.remotesapi.v1alpha1.TableFileDetails
	(*GetUploadLocsRequest)(nil),        // 14: dolt.services.remotesapi.v1alpha1.GetUploadLocsRequest
	(*GetUploadLocsResponse)(nil),       // 15: dolt.services.remotesapi.v1alpha1.GetUploadLocsResponse
	(*RebaseRequest)(nil),               // 16: dolt.services.remotesapi.v1alpha1.RebaseRequest
	(*RebaseResponse)(nil),              // 17: dolt.services.remotesapi.v1alpha1.RebaseResponse
	(*RootRequest)(nil),                 // 18: dolt.services.remotesapi.v1alpha1.RootRequest
	(*RootResponse)(nil),                // 19: dolt.services.remotesapi.v1alpha1.RootResponse
	(*ChunkTableInfo)(nil),              // 20: dolt.services.remotesapi.v1alpha1.ChunkTableInfo
	(*CommitRequest)(nil),               // 21: dolt.services.remotesapi.v1alpha1.CommitRequest
	(*CommitResponse)(nil),              // 22: dolt.services.remotesapi.v1alpha1.CommitResponse
	(*GetRepoMetadataRequest)(nil),      // 23: dolt.services.remotesapi.v1alpha1.GetRepoMetadataRequest
	(*GetRepoMetadataResponse)(nil),     // 24: dolt.services.remotesapi.v1alpha1.GetRepoMetadataResponse
	(*ClientRepoFormat)(nil),            // 25: dolt.services.remotesapi.v1alpha1.ClientRepoFormat
	(*ListTableFilesRequest)(nil),       // 26: dolt.services.remotesapi.v1alpha1.ListTableFilesRequest
	(*TableFileInfo)(nil),               // 27: dolt.services.remotesapi.v1alpha1.TableFileInfo
	(*RefreshTableFileUrlRequest)(nil),  // 28: dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequest
	(*RefreshTableFileUrlResponse)(nil), // 29: dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlResponse
	(*ListTableFilesResponse)(nil),      // 30: dolt.services.remotesapi.v1alpha1.ListTableFilesResponse
	(*AddTableFilesRequest)(nil),        // 31: dolt.services.remotesapi.v1alpha1.AddTableFilesRequest
	(*AddTableFilesResponse)(nil),       // 32: dolt.services.remotesapi.v1alpha1.AddTableFilesResponse
	(*timestamppb.Timestamp)(nil),       // 33: google.protobuf.Timestamp
}
var file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_depIdxs = []int32{
	2,  // 0: dolt.services.remotesapi.v1alpha1.HasChunksRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	6,  // 1: dolt.services.remotesapi.v1alpha1.HttpGetRange.ranges:type_name -> dolt.services.remotesapi.v1alpha1.RangeChunk
	5,  // 2: dolt.services.remotesapi.v1alpha1.DownloadLoc.http_get:type_name -> dolt.services.remotesapi.v1alpha1.HttpGetChunk
	7,  // 3: dolt.services.remotesapi.v1alpha1.DownloadLoc.http_get_range:type_name -> dolt.services.remotesapi.v1alpha1.HttpGetRange
	33, // 4: dolt.services.remotesapi.v1alpha1.DownloadLoc.refresh_after:type_name -> google.protobuf.Timestamp
	28, // 5: dolt.services.remotesapi.v1alpha1.DownloadLoc.refresh_request:type_name -> dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequest
	9,  // 6: dolt.services.remotesapi.v1alpha1.UploadLoc.http_post:type_name -> dolt.services.remotesapi.v1alpha1.HttpPostTableFile
	2,  // 7: dolt.services.remotesapi.v1alpha1.GetDownloadLocsRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	8,  // 8: dolt.services.remotesapi.v1alpha1.GetDownloadLocsResponse.locs:type_name -> dolt.services.remotesapi.v1alpha1.DownloadLoc
	2,  // 9: dolt.services.remotesapi.v1alpha1.GetUploadLocsRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	13, // 10: dolt.services.remotesapi.v1alpha1.GetUploadLocsRequest.table_file_details:type_name -> dolt.services.remotesapi.v1alpha1.TableFileDetails
	10, // 11: dolt.services.remotesapi.v1alpha1.GetUploadLocsResponse.locs:type_name -> dolt.services.remotesapi.v1alpha1.UploadLoc
	2,  // 12: dolt.services.remotesapi.v1alpha1.RebaseRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	2,  // 13: dolt.services.remotesapi.v1alpha1.RootRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	2,  // 14: dolt.services.remotesapi.v1alpha1.CommitRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	20, // 15: dolt.services.remotesapi.v1alpha1.CommitRequest.chunk_table_info:type_name -> dolt.services.remotesapi.v1alpha1.ChunkTableInfo
	25, // 16: dolt.services.remotesapi.v1alpha1.CommitRequest.client_repo_format:type_name -> dolt.services.remotesapi.v1alpha1.ClientRepoFormat
	2,  // 17: dolt.services.remotesapi.v1alpha1.GetRepoMetadataRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	25, // 18: dolt.services.remotesapi.v1alpha1.GetRepoMetadataRequest.client_repo_format:type_name -> dolt.services.remotesapi.v1alpha1.ClientRepoFormat
	0,  // 19: dolt.services.remotesapi.v1alpha1.GetRepoMetadataResponse.push_concurrency_control:type_name -> dolt.services.remotesapi.v1alpha1.PushConcurrencyControl
	2,  // 20: dolt.services.remotesapi.v1alpha1.ListTableFilesRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	33, // 21: dolt.services.remotesapi.v1alpha1.TableFileInfo.refresh_after:type_name -> google.protobuf.Timestamp
	28, // 22: dolt.services.remotesapi.v1alpha1.TableFileInfo.refresh_request:type_name -> dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequest
	2,  // 23: dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	33, // 24: dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlResponse.refresh_after:type_name -> google.protobuf.Timestamp
	27, // 25: dolt.services.remotesapi.v1alpha1.ListTableFilesResponse.table_file_info:type_name -> dolt.services.remotesapi.v1alpha1.TableFileInfo
	27, // 26: dolt.services.remotesapi.v1alpha1.ListTableFilesResponse.appendix_table_file_info:type_name -> dolt.services.remotesapi.v1alpha1.TableFileInfo
	2,  // 27: dolt.services.remotesapi.v1alpha1.AddTableFilesRequest.repo_id:type_name -> dolt.services.remotesapi.v1alpha1.RepoId
	25, // 28: dolt.services.remotesapi.v1alpha1.AddTableFilesRequest.client_repo_format:type_name -> dolt.services.remotesapi.v1alpha1.ClientRepoFormat
	20, // 29: dolt.services.remotesapi.v1alpha1.AddTableFilesRequest.chunk_table_info:type_name -> dolt.services.remotesapi.v1alpha1.ChunkTableInfo
	1,  // 30: dolt.services.remotesapi.v1alpha1.AddTableFilesRequest.appendix_option:type_name -> dolt.services.remotesapi.v1alpha1.ManifestAppendixOption
	23, // 31: dolt.services.remotesapi.v1alpha1.ChunkStoreService.GetRepoMetadata:input_type -> dolt.services.remotesapi.v1alpha1.GetRepoMetadataRequest
	3,  // 32: dolt.services.remotesapi.v1alpha1.ChunkStoreService.HasChunks:input_type -> dolt.services.remotesapi.v1alpha1.HasChunksRequest
	11, // 33: dolt.services.remotesapi.v1alpha1.ChunkStoreService.GetDownloadLocations:input_type -> dolt.services.remotesapi.v1alpha1.GetDownloadLocsRequest
	11, // 34: dolt.services.remotesapi.v1alpha1.ChunkStoreService.StreamDownloadLocations:input_type -> dolt.services.remotesapi.v1alpha1.GetDownloadLocsRequest
	14, // 35: dolt.services.remotesapi.v1alpha1.ChunkStoreService.GetUploadLocations:input_type -> dolt.services.remotesapi.v1alpha1.GetUploadLocsRequest
	16, // 36: dolt.services.remotesapi.v1alpha1.ChunkStoreService.Rebase:input_type -> dolt.services.remotesapi.v1alpha1.RebaseRequest
	18, // 37: dolt.services.remotesapi.v1alpha1.ChunkStoreService.Root:input_type -> dolt.services.remotesapi.v1alpha1.RootRequest
	21, // 38: dolt.services.remotesapi.v1alpha1.ChunkStoreService.Commit:input_type -> dolt.services.remotesapi.v1alpha1.CommitRequest
	26, // 39: dolt.services.remotesapi.v1alpha1.ChunkStoreService.ListTableFiles:input_type -> dolt.services.remotesapi.v1alpha1.ListTableFilesRequest
	28, // 40: dolt.services.remotesapi.v1alpha1.ChunkStoreService.RefreshTableFileUrl:input_type -> dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlRequest
	31, // 41: dolt.services.remotesapi.v1alpha1.ChunkStoreService.AddTableFiles:input_type -> dolt.services.remotesapi.v1alpha1.AddTableFilesRequest
	24, // 42: dolt.services.remotesapi.v1alpha1.ChunkStoreService.GetRepoMetadata:output_type -> dolt.services.remotesapi.v1alpha1.GetRepoMetadataResponse
	4,  // 43: dolt.services.remotesapi.v1alpha1.ChunkStoreService.HasChunks:output_type -> dolt.services.remotesapi.v1alpha1.HasChunksResponse
	12, // 44: dolt.services.remotesapi.v1alpha1.ChunkStoreService.GetDownloadLocations:output_type -> dolt.services.remotesapi.v1alpha1.GetDownloadLocsResponse
	12, // 45: dolt.services.remotesapi.v1alpha1.ChunkStoreService.StreamDownloadLocations:output_type -> dolt.services.remotesapi.v1alpha1.GetDownloadLocsResponse
	15, // 46: dolt.services.remotesapi.v1alpha1.ChunkStoreService.GetUploadLocations:output_type -> dolt.services.remotesapi.v1alpha1.GetUploadLocsResponse
	17, // 47: dolt.services.remotesapi.v1alpha1.ChunkStoreService.Rebase:output_type -> dolt.services.remotesapi.v1alpha1.RebaseResponse
	19, // 48: dolt.services.remotesapi.v1alpha1.ChunkStoreService.Root:output_type -> dolt.services.remotesapi.v1alpha1.RootResponse
	22, // 49: dolt.services.remotesapi.v1alpha1.ChunkStoreService.Commit:output_type -> dolt.services.remotesapi.v1alpha1.CommitResponse
	30, // 50: dolt.services.remotesapi.v1alpha1.ChunkStoreService.ListTableFiles:output_type -> dolt.services.remotesapi.v1alpha1.ListTableFilesResponse
	29, // 51: dolt.services.remotesapi.v1alpha1.ChunkStoreService.RefreshTableFileUrl:output_type -> dolt.services.remotesapi.v1alpha1.RefreshTableFileUrlResponse
	32, // 52: dolt.services.remotesapi.v1alpha1.ChunkStoreService.AddTableFiles:output_type -> dolt.services.remotesapi.v1alpha1.AddTableFilesResponse
	42, // [42:53] is the sub-list for method output_type
	31, // [31:42] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_init() }
func file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_init() {
	if File_dolt_services_remotesapi_v1alpha1_chunkstore_proto != nil {
		return
	}
	file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[6].OneofWrappers = []any{
		(*DownloadLoc_HttpGet)(nil),
		(*DownloadLoc_HttpGetRange)(nil),
	}
	file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes[8].OneofWrappers = []any{
		(*UploadLoc_HttpPost)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDesc), len(file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_goTypes,
		DependencyIndexes: file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_depIdxs,
		EnumInfos:         file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_enumTypes,
		MessageInfos:      file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_msgTypes,
	}.Build()
	File_dolt_services_remotesapi_v1alpha1_chunkstore_proto = out.File
	file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_goTypes = nil
	file_dolt_services_remotesapi_v1alpha1_chunkstore_proto_depIdxs = nil
}
