// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package serial

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

type Timestamp struct {
	_tab flatbuffers.Struct
}

func (rcv *Timestamp) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Timestamp) Table() flatbuffers.Table {
	return rcv._tab.Table
}

func (rcv *Timestamp) Time() uint64 {
	return rcv._tab.GetUint64(rcv._tab.Pos + flatbuffers.UOffsetT(0))
}
func (rcv *Timestamp) MutateTime(n uint64) bool {
	return rcv._tab.MutateUint64(rcv._tab.Pos+flatbuffers.UOffsetT(0), n)
}

func CreateTimestamp(builder *flatbuffers.Builder, time uint64) flatbuffers.UOffsetT {
	builder.Prep(8, 8)
	builder.PrependUint64(time)
	return builder.Offset()
}

type Ref struct {
	_tab flatbuffers.Table
}

func GetRootAsRef(buf []byte, offset flatbuffers.UOffsetT) *Ref {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Ref{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsRef(buf []byte, offset flatbuffers.UOffsetT) *Ref {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Ref{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Ref) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Ref) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Ref) Hash(j int) int8 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetInt8(a + flatbuffers.UOffsetT(j*1))
	}
	return 0
}

func (rcv *Ref) HashLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Ref) MutateHash(j int, n int8) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateInt8(a+flatbuffers.UOffsetT(j*1), n)
	}
	return false
}

func RefStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func RefAddHash(builder *flatbuffers.Builder, hash flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(hash), 0)
}
func RefStartHashVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(1, numElems, 1)
}
func RefEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type DatabaseRoot struct {
	_tab flatbuffers.Table
}

func GetRootAsDatabaseRoot(buf []byte, offset flatbuffers.UOffsetT) *DatabaseRoot {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &DatabaseRoot{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDatabaseRoot(buf []byte, offset flatbuffers.UOffsetT) *DatabaseRoot {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &DatabaseRoot{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *DatabaseRoot) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *DatabaseRoot) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *DatabaseRoot) Tables(obj *RefMap) *RefMap {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(RefMap)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *DatabaseRoot) ForeignKeys(obj *ForeignKey, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *DatabaseRoot) ForeignKeysLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func DatabaseRootStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func DatabaseRootAddTables(builder *flatbuffers.Builder, tables flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(tables), 0)
}
func DatabaseRootAddForeignKeys(builder *flatbuffers.Builder, foreignKeys flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(foreignKeys), 0)
}
func DatabaseRootStartForeignKeysVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func DatabaseRootEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type MergeState struct {
	_tab flatbuffers.Table
}

func GetRootAsMergeState(buf []byte, offset flatbuffers.UOffsetT) *MergeState {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &MergeState{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsMergeState(buf []byte, offset flatbuffers.UOffsetT) *MergeState {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &MergeState{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *MergeState) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *MergeState) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *MergeState) PreMergeRoot(obj *Ref) *Ref {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Ref)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *MergeState) CandidateMergeCommit(obj *Ref) *Ref {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Ref)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func MergeStateStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func MergeStateAddPreMergeRoot(builder *flatbuffers.Builder, preMergeRoot flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(preMergeRoot), 0)
}
func MergeStateAddCandidateMergeCommit(builder *flatbuffers.Builder, candidateMergeCommit flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(candidateMergeCommit), 0)
}
func MergeStateEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
