// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeTinyint(t *testing.T) {
	tests := []ModifyTypeTest{
		{
			"TINYINT",
			"SMALLINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT",
			"DATE",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,0)",
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"TINYINT",
			"DATE",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,0), (1,1)",
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-00:00:01", "00:00:00", "00:00:01"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"TINYINT",
			"DATE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(2001), int64(2002), int64(2015)},
			false,
		},
		{
			"TINYINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"MEDIUMINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"INT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"BIGINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT",
			"TINYINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SMALLINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"MEDIUMINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"INT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIGINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"FLOAT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"TINYINT",
			"DOUBLE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(1,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(15,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(15,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(30,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(65,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"TINYINT",
			"DECIMAL(30,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DECIMAL(65,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT",
			"BIT(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(8)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(16)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(24)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(32)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(48)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BIT(64)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT",
			"TINYBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"BLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"LONGBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"TINYTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"TEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"MEDIUMTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"LONGTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"CHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"CHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"CHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"CHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"BINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"BINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"BINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARCHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARCHAR(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"VARBINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"VARBINARY(16383)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT",
			"YEAR",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"TIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-00:01:28", "-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"TINYINT",
			"TIMESTAMP",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"DATETIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"ENUM('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT",
			"SET('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
