// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package remotesapi

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ChunkStoreServiceClient is the client API for ChunkStoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ChunkStoreServiceClient interface {
	GetRepoMetadata(ctx context.Context, in *GetRepoMetadataRequest, opts ...grpc.CallOption) (*GetRepoMetadataResponse, error)
	HasChunks(ctx context.Context, in *HasChunksRequest, opts ...grpc.CallOption) (*HasChunksResponse, error)
	// Get the download locations for a list of chunk hashes.
	// Deprecated. Use StreamDownloadLocations.
	GetDownloadLocations(ctx context.Context, in *GetDownloadLocsRequest, opts ...grpc.CallOption) (*GetDownloadLocsResponse, error)
	// Get the download locations for a list of chunk hashes. Streaming to
	// support large and incrementally available payloads. Results are generated
	// as requests come in.
	StreamDownloadLocations(ctx context.Context, opts ...grpc.CallOption) (ChunkStoreService_StreamDownloadLocationsClient, error)
	// Get upload locations for a list of table file hashes.
	// NOTE: We upload full table files but download individual chunks.
	GetUploadLocations(ctx context.Context, in *GetUploadLocsRequest, opts ...grpc.CallOption) (*GetUploadLocsResponse, error)
	Rebase(ctx context.Context, in *RebaseRequest, opts ...grpc.CallOption) (*RebaseResponse, error)
	Root(ctx context.Context, in *RootRequest, opts ...grpc.CallOption) (*RootResponse, error)
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	ListTableFiles(ctx context.Context, in *ListTableFilesRequest, opts ...grpc.CallOption) (*ListTableFilesResponse, error)
	AddTableFiles(ctx context.Context, in *AddTableFilesRequest, opts ...grpc.CallOption) (*AddTableFilesResponse, error)
}

type chunkStoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewChunkStoreServiceClient(cc grpc.ClientConnInterface) ChunkStoreServiceClient {
	return &chunkStoreServiceClient{cc}
}

func (c *chunkStoreServiceClient) GetRepoMetadata(ctx context.Context, in *GetRepoMetadataRequest, opts ...grpc.CallOption) (*GetRepoMetadataResponse, error) {
	out := new(GetRepoMetadataResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetRepoMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) HasChunks(ctx context.Context, in *HasChunksRequest, opts ...grpc.CallOption) (*HasChunksResponse, error) {
	out := new(HasChunksResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/HasChunks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) GetDownloadLocations(ctx context.Context, in *GetDownloadLocsRequest, opts ...grpc.CallOption) (*GetDownloadLocsResponse, error) {
	out := new(GetDownloadLocsResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetDownloadLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) StreamDownloadLocations(ctx context.Context, opts ...grpc.CallOption) (ChunkStoreService_StreamDownloadLocationsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ChunkStoreService_serviceDesc.Streams[0], "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/StreamDownloadLocations", opts...)
	if err != nil {
		return nil, err
	}
	x := &chunkStoreServiceStreamDownloadLocationsClient{stream}
	return x, nil
}

type ChunkStoreService_StreamDownloadLocationsClient interface {
	Send(*GetDownloadLocsRequest) error
	Recv() (*GetDownloadLocsResponse, error)
	grpc.ClientStream
}

type chunkStoreServiceStreamDownloadLocationsClient struct {
	grpc.ClientStream
}

func (x *chunkStoreServiceStreamDownloadLocationsClient) Send(m *GetDownloadLocsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *chunkStoreServiceStreamDownloadLocationsClient) Recv() (*GetDownloadLocsResponse, error) {
	m := new(GetDownloadLocsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *chunkStoreServiceClient) GetUploadLocations(ctx context.Context, in *GetUploadLocsRequest, opts ...grpc.CallOption) (*GetUploadLocsResponse, error) {
	out := new(GetUploadLocsResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetUploadLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) Rebase(ctx context.Context, in *RebaseRequest, opts ...grpc.CallOption) (*RebaseResponse, error) {
	out := new(RebaseResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Rebase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) Root(ctx context.Context, in *RootRequest, opts ...grpc.CallOption) (*RootResponse, error) {
	out := new(RootResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Root", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) ListTableFiles(ctx context.Context, in *ListTableFilesRequest, opts ...grpc.CallOption) (*ListTableFilesResponse, error) {
	out := new(ListTableFilesResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/ListTableFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *chunkStoreServiceClient) AddTableFiles(ctx context.Context, in *AddTableFilesRequest, opts ...grpc.CallOption) (*AddTableFilesResponse, error) {
	out := new(AddTableFilesResponse)
	err := c.cc.Invoke(ctx, "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/AddTableFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ChunkStoreServiceServer is the server API for ChunkStoreService service.
// All implementations must embed UnimplementedChunkStoreServiceServer
// for forward compatibility
type ChunkStoreServiceServer interface {
	GetRepoMetadata(context.Context, *GetRepoMetadataRequest) (*GetRepoMetadataResponse, error)
	HasChunks(context.Context, *HasChunksRequest) (*HasChunksResponse, error)
	// Get the download locations for a list of chunk hashes.
	// Deprecated. Use StreamDownloadLocations.
	GetDownloadLocations(context.Context, *GetDownloadLocsRequest) (*GetDownloadLocsResponse, error)
	// Get the download locations for a list of chunk hashes. Streaming to
	// support large and incrementally available payloads. Results are generated
	// as requests come in.
	StreamDownloadLocations(ChunkStoreService_StreamDownloadLocationsServer) error
	// Get upload locations for a list of table file hashes.
	// NOTE: We upload full table files but download individual chunks.
	GetUploadLocations(context.Context, *GetUploadLocsRequest) (*GetUploadLocsResponse, error)
	Rebase(context.Context, *RebaseRequest) (*RebaseResponse, error)
	Root(context.Context, *RootRequest) (*RootResponse, error)
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	ListTableFiles(context.Context, *ListTableFilesRequest) (*ListTableFilesResponse, error)
	AddTableFiles(context.Context, *AddTableFilesRequest) (*AddTableFilesResponse, error)
	mustEmbedUnimplementedChunkStoreServiceServer()
}

// UnimplementedChunkStoreServiceServer must be embedded to have forward compatible implementations.
type UnimplementedChunkStoreServiceServer struct {
}

func (*UnimplementedChunkStoreServiceServer) GetRepoMetadata(context.Context, *GetRepoMetadataRequest) (*GetRepoMetadataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepoMetadata not implemented")
}
func (*UnimplementedChunkStoreServiceServer) HasChunks(context.Context, *HasChunksRequest) (*HasChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HasChunks not implemented")
}
func (*UnimplementedChunkStoreServiceServer) GetDownloadLocations(context.Context, *GetDownloadLocsRequest) (*GetDownloadLocsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDownloadLocations not implemented")
}
func (*UnimplementedChunkStoreServiceServer) StreamDownloadLocations(ChunkStoreService_StreamDownloadLocationsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamDownloadLocations not implemented")
}
func (*UnimplementedChunkStoreServiceServer) GetUploadLocations(context.Context, *GetUploadLocsRequest) (*GetUploadLocsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUploadLocations not implemented")
}
func (*UnimplementedChunkStoreServiceServer) Rebase(context.Context, *RebaseRequest) (*RebaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rebase not implemented")
}
func (*UnimplementedChunkStoreServiceServer) Root(context.Context, *RootRequest) (*RootResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Root not implemented")
}
func (*UnimplementedChunkStoreServiceServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (*UnimplementedChunkStoreServiceServer) ListTableFiles(context.Context, *ListTableFilesRequest) (*ListTableFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTableFiles not implemented")
}
func (*UnimplementedChunkStoreServiceServer) AddTableFiles(context.Context, *AddTableFilesRequest) (*AddTableFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTableFiles not implemented")
}
func (*UnimplementedChunkStoreServiceServer) mustEmbedUnimplementedChunkStoreServiceServer() {}

func RegisterChunkStoreServiceServer(s *grpc.Server, srv ChunkStoreServiceServer) {
	s.RegisterService(&_ChunkStoreService_serviceDesc, srv)
}

func _ChunkStoreService_GetRepoMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepoMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).GetRepoMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetRepoMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).GetRepoMetadata(ctx, req.(*GetRepoMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_HasChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).HasChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/HasChunks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).HasChunks(ctx, req.(*HasChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_GetDownloadLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDownloadLocsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).GetDownloadLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetDownloadLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).GetDownloadLocations(ctx, req.(*GetDownloadLocsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_StreamDownloadLocations_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ChunkStoreServiceServer).StreamDownloadLocations(&chunkStoreServiceStreamDownloadLocationsServer{stream})
}

type ChunkStoreService_StreamDownloadLocationsServer interface {
	Send(*GetDownloadLocsResponse) error
	Recv() (*GetDownloadLocsRequest, error)
	grpc.ServerStream
}

type chunkStoreServiceStreamDownloadLocationsServer struct {
	grpc.ServerStream
}

func (x *chunkStoreServiceStreamDownloadLocationsServer) Send(m *GetDownloadLocsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *chunkStoreServiceStreamDownloadLocationsServer) Recv() (*GetDownloadLocsRequest, error) {
	m := new(GetDownloadLocsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ChunkStoreService_GetUploadLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUploadLocsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).GetUploadLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/GetUploadLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).GetUploadLocations(ctx, req.(*GetUploadLocsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_Rebase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RebaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).Rebase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Rebase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).Rebase(ctx, req.(*RebaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_Root_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RootRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).Root(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Root",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).Root(ctx, req.(*RootRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_ListTableFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTableFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).ListTableFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/ListTableFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).ListTableFiles(ctx, req.(*ListTableFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ChunkStoreService_AddTableFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTableFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChunkStoreServiceServer).AddTableFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dolt.services.remotesapi.v1alpha1.ChunkStoreService/AddTableFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChunkStoreServiceServer).AddTableFiles(ctx, req.(*AddTableFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ChunkStoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dolt.services.remotesapi.v1alpha1.ChunkStoreService",
	HandlerType: (*ChunkStoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRepoMetadata",
			Handler:    _ChunkStoreService_GetRepoMetadata_Handler,
		},
		{
			MethodName: "HasChunks",
			Handler:    _ChunkStoreService_HasChunks_Handler,
		},
		{
			MethodName: "GetDownloadLocations",
			Handler:    _ChunkStoreService_GetDownloadLocations_Handler,
		},
		{
			MethodName: "GetUploadLocations",
			Handler:    _ChunkStoreService_GetUploadLocations_Handler,
		},
		{
			MethodName: "Rebase",
			Handler:    _ChunkStoreService_Rebase_Handler,
		},
		{
			MethodName: "Root",
			Handler:    _ChunkStoreService_Root_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _ChunkStoreService_Commit_Handler,
		},
		{
			MethodName: "ListTableFiles",
			Handler:    _ChunkStoreService_ListTableFiles_Handler,
		},
		{
			MethodName: "AddTableFiles",
			Handler:    _ChunkStoreService_AddTableFiles_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamDownloadLocations",
			Handler:       _ChunkStoreService_StreamDownloadLocations_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "dolt/services/remotesapi/v1alpha1/chunkstore.proto",
}
