package main

import (
	"fmt"
	"net/http"
	"os"
	"os/signal"
	"strings"

	"github.com/fatih/color"
)

func fetchLatestVersion() chan string {
	latestVersionChannel := make(chan string, 1)
	go func() {
		r, e := http.Get("https://github.com/lucagrulla/cw/releases/latest")

		if e != nil {
			close(latestVersionChannel)
		} else {
			finalURL := r.Request.URL.String()
			tokens := strings.Split(finalURL, "/")
			latestVersionChannel <- tokens[len(tokens)-1]
		}
	}()
	return latestVersionChannel
}

func newVersionMsg(currentVersion string, latestVersionChannel chan string) {
	latestVersion, ok := <-latestVersionChannel
	//if the channel is closed we failed to fetch the latest version. Ignore version message.
	if !ok {
		if latestVersion != fmt.Sprintf("v%s", currentVersion) {
			msg := fmt.Sprintf("\n\n%s - %s -> %s", color.GreenString("A new version of cw is available!"), color.YellowString(currentVersion), color.GreenString(latestVersion))
			fmt.Fprintln(os.Stderr, msg)
		}
	}
}

func versionCheckOnSigterm() {
	//only way to avoid print of the signal: interrupt message
	c := make(chan os.Signal, 1)
	signal.Notify(c, os.Interrupt)
	<-c
	os.Exit(0)
}
