// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by injection-gen. DO NOT EDIT.

package client

import (
	context "context"
	json "encoding/json"
	errors "errors"
	fmt "fmt"

	v1alpha1 "github.com/sigstore/cosign/pkg/apis/policy/v1alpha1"
	v1beta1 "github.com/sigstore/cosign/pkg/apis/policy/v1beta1"
	versioned "github.com/sigstore/cosign/pkg/client/clientset/versioned"
	typedpolicyv1alpha1 "github.com/sigstore/cosign/pkg/client/clientset/versioned/typed/policy/v1alpha1"
	typedpolicyv1beta1 "github.com/sigstore/cosign/pkg/client/clientset/versioned/typed/policy/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	unstructured "k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	runtime "k8s.io/apimachinery/pkg/runtime"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	discovery "k8s.io/client-go/discovery"
	dynamic "k8s.io/client-go/dynamic"
	rest "k8s.io/client-go/rest"
	injection "knative.dev/pkg/injection"
	dynamicclient "knative.dev/pkg/injection/clients/dynamicclient"
	logging "knative.dev/pkg/logging"
)

func init() {
	injection.Default.RegisterClient(withClientFromConfig)
	injection.Default.RegisterClientFetcher(func(ctx context.Context) interface{} {
		return Get(ctx)
	})
	injection.Dynamic.RegisterDynamicClient(withClientFromDynamic)
}

// Key is used as the key for associating information with a context.Context.
type Key struct{}

func withClientFromConfig(ctx context.Context, cfg *rest.Config) context.Context {
	return context.WithValue(ctx, Key{}, versioned.NewForConfigOrDie(cfg))
}

func withClientFromDynamic(ctx context.Context) context.Context {
	return context.WithValue(ctx, Key{}, &wrapClient{dyn: dynamicclient.Get(ctx)})
}

// Get extracts the versioned.Interface client from the context.
func Get(ctx context.Context) versioned.Interface {
	untyped := ctx.Value(Key{})
	if untyped == nil {
		if injection.GetConfig(ctx) == nil {
			logging.FromContext(ctx).Panic(
				"Unable to fetch github.com/sigstore/cosign/pkg/client/clientset/versioned.Interface from context. This context is not the application context (which is typically given to constructors via sharedmain).")
		} else {
			logging.FromContext(ctx).Panic(
				"Unable to fetch github.com/sigstore/cosign/pkg/client/clientset/versioned.Interface from context.")
		}
	}
	return untyped.(versioned.Interface)
}

type wrapClient struct {
	dyn dynamic.Interface
}

var _ versioned.Interface = (*wrapClient)(nil)

func (w *wrapClient) Discovery() discovery.DiscoveryInterface {
	panic("Discovery called on dynamic client!")
}

func convert(from interface{}, to runtime.Object) error {
	bs, err := json.Marshal(from)
	if err != nil {
		return fmt.Errorf("Marshal() = %w", err)
	}
	if err := json.Unmarshal(bs, to); err != nil {
		return fmt.Errorf("Unmarshal() = %w", err)
	}
	return nil
}

// PolicyV1alpha1 retrieves the PolicyV1alpha1Client
func (w *wrapClient) PolicyV1alpha1() typedpolicyv1alpha1.PolicyV1alpha1Interface {
	return &wrapPolicyV1alpha1{
		dyn: w.dyn,
	}
}

type wrapPolicyV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapPolicyV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapPolicyV1alpha1) ClusterImagePolicies() typedpolicyv1alpha1.ClusterImagePolicyInterface {
	return &wrapPolicyV1alpha1ClusterImagePolicyImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "policy.sigstore.dev",
			Version:  "v1alpha1",
			Resource: "clusterimagepolicies",
		}),
	}
}

type wrapPolicyV1alpha1ClusterImagePolicyImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedpolicyv1alpha1.ClusterImagePolicyInterface = (*wrapPolicyV1alpha1ClusterImagePolicyImpl)(nil)

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) Create(ctx context.Context, in *v1alpha1.ClusterImagePolicy, opts v1.CreateOptions) (*v1alpha1.ClusterImagePolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy.sigstore.dev",
		Version: "v1alpha1",
		Kind:    "ClusterImagePolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterImagePolicy, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterImagePolicyList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterImagePolicyList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterImagePolicy, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) Update(ctx context.Context, in *v1alpha1.ClusterImagePolicy, opts v1.UpdateOptions) (*v1alpha1.ClusterImagePolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy.sigstore.dev",
		Version: "v1alpha1",
		Kind:    "ClusterImagePolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) UpdateStatus(ctx context.Context, in *v1alpha1.ClusterImagePolicy, opts v1.UpdateOptions) (*v1alpha1.ClusterImagePolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy.sigstore.dev",
		Version: "v1alpha1",
		Kind:    "ClusterImagePolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1alpha1ClusterImagePolicyImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// PolicyV1beta1 retrieves the PolicyV1beta1Client
func (w *wrapClient) PolicyV1beta1() typedpolicyv1beta1.PolicyV1beta1Interface {
	return &wrapPolicyV1beta1{
		dyn: w.dyn,
	}
}

type wrapPolicyV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapPolicyV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapPolicyV1beta1) ClusterImagePolicies() typedpolicyv1beta1.ClusterImagePolicyInterface {
	return &wrapPolicyV1beta1ClusterImagePolicyImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "policy.sigstore.dev",
			Version:  "v1beta1",
			Resource: "clusterimagepolicies",
		}),
	}
}

type wrapPolicyV1beta1ClusterImagePolicyImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedpolicyv1beta1.ClusterImagePolicyInterface = (*wrapPolicyV1beta1ClusterImagePolicyImpl)(nil)

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) Create(ctx context.Context, in *v1beta1.ClusterImagePolicy, opts v1.CreateOptions) (*v1beta1.ClusterImagePolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy.sigstore.dev",
		Version: "v1beta1",
		Kind:    "ClusterImagePolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.ClusterImagePolicy, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ClusterImagePolicyList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterImagePolicyList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ClusterImagePolicy, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) Update(ctx context.Context, in *v1beta1.ClusterImagePolicy, opts v1.UpdateOptions) (*v1beta1.ClusterImagePolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy.sigstore.dev",
		Version: "v1beta1",
		Kind:    "ClusterImagePolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) UpdateStatus(ctx context.Context, in *v1beta1.ClusterImagePolicy, opts v1.UpdateOptions) (*v1beta1.ClusterImagePolicy, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "policy.sigstore.dev",
		Version: "v1beta1",
		Kind:    "ClusterImagePolicy",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterImagePolicy{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapPolicyV1beta1ClusterImagePolicyImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}
