## cosign generate

Generates (unsigned) signature payloads from the supplied container image.

### Synopsis

Generates an unsigned payload from the supplied container image and flags.
This payload matches the one generated by the "cosign sign" command and can be used if you need
to sign payloads with your own tooling or algorithms.

```
cosign generate [flags]
```

### Examples

```
  cosign generate [--a key=value] <image uri>

  # Generate a simple payload for an image
  cosign generate <IMAGE>

  # Generate a payload with specific annotations
  cosign generate -a foo=bar <IMAGE>

  # Use this payload in another tool
  gpg --output image.sig --detach-sig <(cosign generate <IMAGE>)
```

### Options

```
      --allow-insecure-registry                                                                  whether to allow insecure connections to registries. Don't use this for anything but testing
  -a, --annotations strings                                                                      extra key=value pairs to sign
      --attachment-tag-prefix [AttachmentTagPrefix]sha256-[TargetImageDigest].[AttachmentName]   optional custom prefix to use for attached image tags. Attachment images are tagged as: [AttachmentTagPrefix]sha256-[TargetImageDigest].[AttachmentName]
  -h, --help                                                                                     help for generate
      --k8s-keychain                                                                             whether to use the kubernetes keychain instead of the default keychain (supports workload identity).
```

### Options inherited from parent commands

```
      --azure-container-registry-config string   Path to the file containing Azure container registry configuration information.
      --output-file string                       log output to a file
  -d, --verbose                                  log debug output
```

### SEE ALSO

* [cosign](cosign.md)	 - 

