name: Datacenter Policy
acronym: DP
satisfies:
  TSC:
    - CC6.4
majorRevisions:
  - date: Jun 1 2018
    comment: Initial document
---

# Purpose and Scope

a. The purpose of this policy is to define security procedures within the organization’s data centers and secure equipment areas.

a. This policy applies to any cloud hosted providers and facilities within the organization that are labeled as either a data center or a secure equipment area. Such facilities are explicitly called out within this document.

a. This policy applies to all management, employees and suppliers that conduct business operations within cloud host or data centers and secure equipment areas.

# Background

a. This policy defines the policies and rules governing data centers and secure equipment areas from both a physical and logical security perspective. The document lists all data centers and secure equipment areas in use by the organization, prescribes how access is controlled and enforced, and establishes procedures for any visitor or third party access. This policy also defines prohibited activities and requirements for periodic safety and security checks.

# Policy

a. The following locations are classified by the organization as secure areas and are governed by this policy:

    i. [list all data center locations and secure areas under the organization’s control]

a. Each data center and secure area must have a manager assigned. The manager’s name must be documented in the organization’s records. In the case of any on-prem data centers, the manager’s name must also be posted in and near the secure area.

a. Each secure area must be clearly marked. Access to the secure area must be controlled by at least a locked door. A visitor access log must be clearly marked and easily accessible just inside the door.

a. Persons who are not employed by the organization are considered to be visitors. Visitors accessing secure areas shall:

    i. Obtain access to secure areas in accordance with reference a.

    i. Only enter and remain in secure areas when escorted by a designated employee. The employee must stay with the visitor during their entire stay inside the secure area.

    i. Log the precise time of entry and exit in the visitor access log.

a. The following activities are prohibited inside secure areas:

    i. Photography, or video or audio recordings of any kind.

    i. Connection of any electrical device to a power supply, unless specifically authorized by the responsible person.

    i. Unauthorized usage of or tampering with any installed equipment.

    i. Connection of any device to the network, unless specifically authorized by the responsible person.

    i. Storage or archival of large amounts of paper materials.

    i. Storage of flammable materials or equipment.

    i. Use of portable heating devices.

    i. Smoking, eating, or drinking.

a. Secure areas must be checked for compliance with security and safety requirements on at least a quarterly basis.
