name: Data Classification Policy
acronym: DCP
satisfies:
  TSC:
    - CC9.9
majorRevisions:
  - date: Jun 1 2018
    comment: Initial document
---
# Appendices 

Appendix A: Handling of Classified Information

Appendix B: Form - Confidentiality Statement

# Purpose and Scope

a. This data classification policy defines the requirements to ensure that information within the organization is protected at an appropriate level.

a. This document applies to the entire scope of the organization’s information security program. It includes all types of information, regardless of its form, such as paper or electronic documents, applications and databases, and knowledge or information that is not written.

a. This policy applies to all individuals and systems that have access to information kept by the organization.

# Background

a. This policy defines the high level objectives and implementation instructions for the organization’s data classification scheme. This includes data classification levels, as well as procedures for the classification, labeling and handling of data within the organization. Confidentiality and non-disclosure agreements maintained by the organization must reference this policy.

# References

a. Risk Assessment Policy

a. Security Incident Management Policy

# Policy

a. If classified information is received from outside the organization, the person who receives the information must classify it in accordance with the rules prescribed in this policy. The person thereby will become the owner of the information.

a. If classified information is received from outside the organization and handled as part of business operations activities (e.g., customer data on provided cloud services), the information classification, as well as the owner of such information, must be made in accordance with the specifications of the respective customer service agreement and other legal requirements.

a. When classifying information, the level of confidentiality is determined by:

    i. The value of the information, based on impacts identified during the risk assessment process. More information on risk assessments is defined in the Risk Assessment Policy (reference (a)).

    i. Sensitivity and criticality of the information, based on the highest risk calculated for each information item during the risk assessment.

    i. Legal, regulatory and contractual obligations. 


+-------------------+------------------+---------------------------+---------------------------+
|**Confidentiality**| **Label**        |  **Classification**       |  **Access**               |
|     **Level**     |                  |   **Criteria**            | **Restrictions**          |
+===================+==================+===========================+============================+
| Public            | For Public       | Making the information    | Information is available  |   
|                   | Release          | public will not harm      | to the public.            |
|                   |                  | the organization in       |                           |        
|                   |                  | any way.                  |                           |
+-------------------+------------------+---------------------------+---------------------------+
|                   |                  |                           |                           |
+-------------------+------------------+---------------------------+---------------------------+
| Internal Use      | Internal Use     | Unauthorized access       | Information is available  |
|                   |                  | may cause minor damage    | to all employees and      |   
|                   |                  | and/or inconvenience      | authorized third parties. |        
|                   |                  | to the organization.      | 
+-------------------+------------------+---------------------------+---------------------------+
|                   |                  |                           |                           |
+-------------------+------------------+---------------------------+---------------------------+
| Restricted        | Restricted       | Unauthorized access to    | Information is available  |
|                   |                  | information may cause     | to a specific group of    |
|                   |                  | considerable damage to    | employees and authorized |
|                   |                  | the business and/or       | third parties.            |
|                   |                  | the organization's        |                           |
|                   |                  | reputation.               |                           |           
+-------------------+------------------+---------------------------+---------------------------+
|                   |                  |                           |                           |
+-------------------+------------------+---------------------------+---------------------------+
| Confidential      |Confidential      | Unauthorized access to    | Information is available  |           
|                   |                  | information may cause     | only to specific indivi-  |
|                   |                  | catastrophic damage to    | duals in the              |
|                   |                  | business and/or the       | organization.             |
|                   |                  | organization's reputation.|                           |
+-------------------+------------------+---------------------------+---------------------------+

Table 3: Information Confidentiality Levels

&nbsp;

d. Information must be classified based on confidentiality levels as defined in Table 3.

e. Information and information system owners should try to use the lowest confidentiality level that ensures an adequate level of protection, thereby avoiding unnecessary production costs.

f. Information classified as “Restricted” or “Confidential” must be accompanied by a list of authorized persons in which the information owner specifies the names or job functions of persons who have the right to access that information.

g. Information classified as “Internal Use” must be accompanied by a list of authorized persons only if individuals outside the organization will have access to the document.

h. Information and information system owners must review the confidentiality level of their information assets every five years and assess whether the confidentiality level should be changed. Wherever possible, confidentiality levels should be lowered.

a. For cloud-based software services provided to customers, system owners under the company’s control must also review the confidentiality level of their information systems after service agreement changes or after a customer’s formal notification. Where allowed by service agreements, confidentiality levels should be lowered.

a. Information must be labeled according to the following:

    i. Paper documents: the confidentiality level is indicated on the top and bottom of each document page; it is also indicated on the front of the cover or envelope carrying such a document as well as on the filing folder in which the document is stored. If a document is not labeled, its default classification is Internal Use.

    i. Electronic documents: the confidentiality level is indicated on the top and bottom of each document page. If a document is not labeled, its default classification is Internal Use.

    i. Information systems: the confidentiality level in applications and databases must be indicated on the system access screen, as well as on the screen when displaying such information.
    
    i. Electronic mail: the confidentiality level is indicated in the first line of the email body. If it is not labeled, its default classification is “Internal Use”.
    
    i. Electronic storage media (disks, memory cards, etc.): the confidentiality level must be indicated on the top surface of the media. If it is not labeled, its default classification is “Internal Use”.
    
    i. Information transmitted orally: the confidentiality level should be mentioned before discussing information during face-to-face communication, by telephone, or any other means of oral communication.
    
a. All persons accessing classified information must follow the guidelines listed in Appendix A, “Handling of Classified Information.”

a. All persons accessing classified information must complete and submit a Confidentiality Statement to their immediate supervisor or company point-of-contact. A sample Confidentiality Statement is in Appendix B.

a. Incidents related to the improper handling of classified information must be reported in accordance with the Security Incident Management Policy (reference (b)).
    
\pagebreak 

# Appendix A: Handling of Classified Information

Information and information systems must be handled according to the following guidelines*:

a. Paper Documents
    
    i. Internal Use

        1. Only authorized persons may have access.
        
        1. If sent outside the organization, the document must be sent as registered mail.

        1. Documents may only be kept in rooms without public access.

        1. Documents must be removed expeditiously from printers and fax machines.

    i. Restricted

        1. The document must be stored in a locked cabinet.

        1. Documents may be transferred within and outside the organization only in a closed envelope.

        1. If sent outside the organization, the document must be mailed with a return receipt service.

        1. Documents must immediately be removed from printers and fax machines.

        1. Only the document owner may copy the document.

        1. Only the document owner may destroy the document.

    i. Confidential
      
        1. The document must be stored in a safe.

        1. The document may be transferred within and outside the organization only by a trustworthy person in a closed and sealed envelope.

        1. Faxing the document is not permitted.

        1. The document may be printed only if the authorized person is standing next to the printer.

a. Electronic Documents

    i. Internal Use

        1. Only authorized persons may have access.

        1. When documents are exchanged via unencrypted file sharing services such as FTP, they must be password protected.

        1. Access to the information system where the document is stored must be protected by a strong password.

        1. The screen on which the document is displayed must be automatically locked after 10 minutes of inactivity.

    i. Restricted

        1. Only persons with authorization for this document may access the part of the information system where this document is stored.

        1. When documents are exchanged via file sharing services of any type, they must be encrypted.

        1. Only the document owner may erase the document.

    i. Confidential

        1. The document must be stored in encrypted form.

        1. The document may be stored only on servers which are controlled by the organization.

        1. The document may only be shared via file sharing services that are encrypted such as HTTPS and SSH. Further, the document must be encrypted and protected with a string password when transferred.

a. Information Systems

    i. Internal Use

        1. Only authorized persons may have access.

        1. Access to the information system must be protected by a strong password.

        1. The screen must be automatically locked after 10 minutes of inactivity.

        1. The information system may be only located in rooms with controlled physical access.

    i. Restricted

        1. Users must log out of the information system if they have temporarily or permanently left the workplace.

        1. Data must be erased only with an algorithm that ensures secure deletion.

    i. Confidential

        1. Access to the information system must be controlled through multi-factor authentication (MFA).

        1. The information system may only be installed on servers controlled by the organization.

        1. The information system may only be located in rooms with controlled physical access and identity control of people accessing the room.

a. Electronic Mail

    i. Internal Use

        1. Only authorized persons may have access.

        1. The sender must carefully check the recipient.

        1. All rules stated under “information systems” apply.

    i. Restricted

        1. Email must be encrypted if sent outside the organization.

    i. Confidential

        1. Email must be encrypted.

a. Electronic Storage Media

    i. Internal Use

        1. Only authorized persons may have access.

        1. Media or files must be password protected.

        1. If sent outside the organization, the medium must be sent as registered mail.

        1. The medium may only be kept in rooms with controlled physical access.

    i. Restricted

        1. Media and files must be encrypted.

        1. Media must be stored in a locked cabinet.

        1. If sent outside the organization, the medium must be mailed with a return receipt service.

        1. Only the medium owner may erase or destroy the medium.

    i. Confidential

        1. Media must be stored in a safe.

        1. Media may be transferred within and outside the organization only by a trustworthy person and in a closed and sealed envelope.

a. Information Transmitted Orally

    i. Internal Use

        1. Only authorized persons may have access to information.

        1. Unauthorized persons must not be present in the room when the information is communicated.

    i. Restricted

        1. The room must be sound-proof.

        1. The conversation must not be recorded.

    i. Confidential

        1. Conversation conducted through electronic means must be encrypted.

        1. No transcript of the conversation may be kept.

In this document, controls are implemented cumulatively, meaning that controls for any confidentiality level imply the implementation of controls defined for lower confidentiality levels - if stricted controls are prescribed for a higher confidentiality level, then only such controls are implemented.




