name: Access Onboarding and Termination Policy
acronym: AOTP
satisfies:
TSC:
- CC6.1
  - CC6.2
  - CC6.3 
majorRevisions:
- date: Jun 1 2018
   comment: Initial document
---
# Purpose and Scope

a. The purpose of this policy is to define procedures to onboard and offboard users to technical infrastructure in a manner that minimizes the risk of information loss or exposure.

a. This policy applies to all technical infrastructure within the organization.

a. This policy applies to all full-time and part-time employees and contractors.

# Background

a. In order to minimize the risk of information loss or exposure (from both inside and outside the organization), the organization is reliant on the principle of least privilege. Account creation and permission levels are restricted to only the resources absolutely needed to perform each person’s job duties. When a user’s role within the organization changes, those accounts and permission levels are changed/revoked to fit the new role and disabled when the user leaves the organization altogether.

# Policy

a. *During onboarding:*

    i. Hiring Manager informs HR upon hire of a new employee.

    i. HR emails IT to inform them of a new hire and their role. 

    i. IT creates a checklist of accounts and permission levels needed for that role. 

    i. The owner of each resource reviews and approves account creation and the 
associated permissions.

    i. IT works with the owner of each resource to set up the user. 

a. *During offboarding:*

    i. Hiring Manager notifies HR when an employee has been terminated. 

    i. HR sends a weekly email report to IT summarizing list of users terminated and instructs IT to disable their access. 

    i. IT terminates access within five business days from receipt of notification. 

a. *When an employee changes roles within the organization:*

    i. Hiring Manager will inform HR of a change in role.
    
    i. HR and IT will follow the same steps as outlined in the onboarding and offboarding procedures. 

a. *Review of accounts and permissions:*

    i. Each month, IT and HR will review accounts and permission levels for accuracy. 
