// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package config

var preCache = `{
  "api": [
    {
      "description": "Lists the resource icon for the specified resource(s)",
      "isasync": false,
      "name": "listResourceIcon",
      "params": [
        {
          "description": "type of the resource",
          "length": 255,
          "name": "resourcetype",
          "required": true,
          "type": "string"
        },
        {
          "description": "list of resources to upload the icon/image for",
          "length": 255,
          "name": "resourceids",
          "required": true,
          "type": "list"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "base64 representation of resource icon",
          "name": "base64image",
          "type": "string"
        },
        {
          "description": "resource type",
          "name": "resourcetype",
          "type": "resourceobjecttype"
        },
        {},
        {
          "description": "id of the resource",
          "name": "resourceid",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ],
      "since": "4.16.0.0"
    },
    {
      "description": "Creates VPC offering",
      "isasync": true,
      "name": "createVPCOffering",
      "params": [
        {
          "description": "the ID of the containing zone(s), null for public offerings",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "since": "4.13",
          "type": "list"
        },
        {
          "description": "services supported by the vpc offering",
          "length": 255,
          "name": "supportedservices",
          "required": true,
          "type": "list"
        },
        {
          "description": "provider to service mapping. If not specified, the provider for the service will be mapped to the default provider on the physical network",
          "length": 255,
          "name": "serviceproviderlist",
          "required": false,
          "type": "map"
        },
        {
          "description": "desired service capabilities as part of vpc offering",
          "length": 255,
          "name": "servicecapabilitylist",
          "required": false,
          "since": "4.4",
          "type": "map"
        },
        {
          "description": "The internet protocol of the offering. Options are ipv4 and dualstack. Default is ipv4. dualstack will create an offering that supports both IPv4 and IPv6",
          "length": 255,
          "name": "internetprotocol",
          "required": false,
          "since": "4.17.0",
          "type": "string"
        },
        {
          "description": "the name of the vpc offering",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "set to true if the offering is to be enabled during creation. Default is false",
          "length": 255,
          "name": "enable",
          "required": false,
          "since": "4.16",
          "type": "boolean"
        },
        {
          "description": "the display text of the vpc offering, defaults to the 'name'",
          "length": 255,
          "name": "displaytext",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the service offering for the VPC router appliance",
          "length": 255,
          "name": "serviceofferingid",
          "related": "createServiceOffering,updateServiceOffering,listServiceOfferings",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the containing domain(s), null for public offerings",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain,moveDomain",
          "required": false,
          "type": "list"
        }
      ],
      "related": "updateVPCOffering,listVPCOfferings",
      "response": [
        {
          "description": "the domain name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the date this vpc offering was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the list of supported services",
          "name": "service",
          "response": [
            {
              "description": "the service provider name",
              "name": "provider",
              "response": [
                {
                  "description": "state of the network provider",
                  "name": "state",
                  "type": "string"
                },
                {
                  "description": "the provider name",
                  "name": "name",
                  "type": "string"
                },
                {
                  "description": "services for this provider",
                  "name": "servicelist",
                  "type": "list"
                },
                {
                  "description": "the physical network this belongs to",
                  "name": "physicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "the destination physical network",
                  "name": "destinationphysicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "uuid of the network provider",
                  "name": "id",
                  "type": "string"
                },
                {
                  "description": "true if individual services can be enabled/disabled",
                  "name": "canenableindividualservice",
                  "type": "boolean"
                }
              ],
              "type": "list"
            },
            {
              "description": "the list of capabilities",
              "name": "capability",
              "response": [
                {
                  "description": "the capability value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "can this service capability value can be choosable while creatine network offerings",
                  "name": "canchooseservicecapability",
                  "type": "boolean"
                },
                {
                  "description": "the capability name",
                  "name": "name",
                  "type": "string"
                }
              ],
              "type": "list"
            },
            {
              "description": "the service name",
              "name": "name",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the zone ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "state of the vpc offering. Can be Disabled/Enabled",
          "name": "state",
          "type": "string"
        },
        {
          "description": " indicates if the vpc offering supports distributed router for one-hop forwarding",
          "name": "distributedvpcrouter",
          "type": "boolean"
        },
        {},
        {
          "description": "the id of the vpc offering",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the internet protocol of the vpc offering",
          "name": "internetprotocol",
          "type": "string"
        },
        {
          "description": "an alternate display text of the vpc offering.",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true if vpc offering is default, false otherwise",
          "name": "isdefault",
          "type": "boolean"
        },
        {
          "description": " indicated if the offering can support region level vpc",
          "name": "supportsregionLevelvpc",
          "type": "boolean"
        },
        {
          "description": "the domain ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the zone name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zone",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the name of the vpc offering",
          "name": "name",
          "type": "string"
        }
      ]
    },
    {
      "description": "Creates a new Pod.",
      "isasync": false,
      "name": "createPod",
      "params": [
        {
          "description": "Allocation state of this Pod for allocation of new resources",
          "length": 255,
          "name": "allocationstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "the Zone ID in which the Pod will be created",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the name of the Pod",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "the netmask for the Pod",
          "length": 255,
          "name": "netmask",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ending IP address for the Pod",
          "length": 255,
          "name": "endip",
          "required": false,
          "type": "string"
        },
        {
          "description": "the starting IP address for the Pod",
          "length": 255,
          "name": "startip",
          "required": false,
          "type": "string"
        },
        {
          "description": "the gateway for the Pod",
          "length": 255,
          "name": "gateway",
          "required": false,
          "type": "string"
        }
      ],
      "related": "listPods,updatePod,createManagementNetworkIpRange",
      "response": [
        {
          "description": "indicates Vlan ID for the range. This parameter is deprecated, please use 'vlanid' from ipranges parameter.",
          "name": "vlanid",
          "type": "list"
        },
        {
          "description": "the Zone ID of the Pod",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the IP ranges for the Pod",
          "name": "ipranges",
          "response": [
            {
              "description": "indicates Vlan ID for the range",
              "name": "vlanid",
              "type": "string"
            },
            {
              "description": "the starting IP for the range",
              "name": "startip",
              "type": "string"
            },
            {
              "description": "the ending IP for the range",
              "name": "endip",
              "type": "string"
            },
            {
              "description": "indicates if range is dedicated for CPVM and SSVM",
              "name": "forsystemvms",
              "type": "string"
            },
            {
              "description": "the gateway for the range",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the CIDR for the range",
              "name": "cidr",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the Zone name of the Pod",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "indicates if range is dedicated for CPVM and SSVM. This parameter is deprecated, please use 'forsystemvms' from ipranges parameter.",
          "name": "forsystemvms",
          "type": "list"
        },
        {
          "description": "the ending IP for the Pod. This parameter is deprecated, please use 'endip' from ipranges parameter.",
          "name": "endip",
          "type": "list"
        },
        {},
        {
          "description": "the netmask of the Pod",
          "name": "netmask",
          "type": "string"
        },
        {},
        {
          "description": "the capacity of the Pod",
          "name": "capacity",
          "response": [
            {
              "description": "the Zone name",
              "name": "zonename",
              "type": "string"
            },
            {
              "description": "the capacity currently in use",
              "name": "capacityused",
              "type": "long"
            },
            {
              "description": "the Cluster ID",
              "name": "clusterid",
              "type": "string"
            },
            {
              "description": "the capacity name",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the capacity currently in allocated",
              "name": "capacityallocated",
              "type": "long"
            },
            {
              "description": "the capacity type",
              "name": "type",
              "type": "short"
            },
            {
              "description": "the Pod name",
              "name": "podname",
              "type": "string"
            },
            {
              "description": "the total capacity available",
              "name": "capacitytotal",
              "type": "long"
            },
            {
              "description": "the percentage of capacity currently in use",
              "name": "percentused",
              "type": "string"
            },
            {
              "description": "the Zone ID",
              "name": "zoneid",
              "type": "string"
            },
            {
              "description": "the Pod ID",
              "name": "podid",
              "type": "string"
            },
            {
              "description": "the Cluster name",
              "name": "clustername",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the allocation state of the Pod",
          "name": "allocationstate",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the gateway of the Pod",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the starting IP for the Pod. This parameter is deprecated, please use 'startip' from ipranges parameter.",
          "name": "startip",
          "type": "list"
        },
        {
          "description": "the ID of the Pod",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the name of the Pod",
          "name": "name",
          "type": "string"
        }
      ]
    },
    {
      "description": "Creates an account from an LDAP user",
      "isasync": false,
      "name": "ldapCreateAccount",
      "params": [
        {
          "description": "Creates the account under the specified role.",
          "length": 255,
          "name": "roleid",
          "related": "createRole,importRole,listRoles,updateRole",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Type of the account. Specify 0 for user, 1 for root admin, and 2 for domain admin",
          "length": 255,
          "name": "accounttype",
          "required": false,
          "type": "integer"
        },
        {
          "description": "Network domain for the account's networks",
          "length": 255,
          "name": "networkdomain",
          "required": false,
          "type": "string"
        },
        {
          "description": "Account UUID, required for adding account from external provisioning system",
          "length": 255,
          "name": "accountid",
          "required": false,
          "type": "string"
        },
        {
          "description": "details for account used to store specific parameters",
          "length": 255,
          "name": "accountdetails",
          "required": false,
          "type": "map"
        },
        {
          "description": "User UUID, required for adding account from external provisioning system",
          "length": 255,
          "name": "userid",
          "required": false,
          "type": "string"
        },
        {
          "description": "Unique username.",
          "length": 255,
          "name": "username",
          "required": true,
          "type": "string"
        },
        {
          "description": "Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.",
          "length": 255,
          "name": "timezone",
          "required": false,
          "type": "string"
        },
        {
          "description": "Creates the user under the specified account. If no account is specified, the username will be used as the account name.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "Creates the user under the specified domain.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain,moveDomain",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createAccount,disableAccount,enableAccount,lockAccount,updateAccount,markDefaultZoneForAccount,listAccounts,listAccounts",
      "response": [
        {
          "description": "the total number of virtual machines deployed by this account",
          "name": "vmtotal",
          "type": "long"
        },
        {
          "description": "the total number of networks the account can own",
          "name": "networklimit",
          "type": "string"
        },
        {
          "description": "the name of the account",
          "name": "name",
          "type": "string"
        },
        {
          "description": "account type (admin, domain-admin, user)",
          "name": "accounttype",
          "type": "integer"
        },
        {
          "description": "the total number of public ip addresses allocated for this account",
          "name": "iptotal",
          "type": "long"
        },
        {
          "description": "the total number of virtual machines stopped for this account",
          "name": "vmstopped",
          "type": "integer"
        },
        {
          "description": "the total secondary storage space (in GiB) available to be used for this account",
          "name": "secondarystorageavailable",
          "type": "string"
        },
        {
          "description": "the total memory (in MB) the account can own",
          "name": "memorylimit",
          "type": "string"
        },
        {
          "description": "details for the account",
          "name": "accountdetails",
          "type": "map"
        },
        {
          "description": "the default zone of the account",
          "name": "defaultzoneid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the total number of projects the account can own",
          "name": "projectlimit",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines that can be deployed by this account",
          "name": "vmlimit",
          "type": "string"
        },
        {
          "description": "id of the Domain the account belongs to",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the date when this account was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the total number of public ip addresses available for this account to acquire",
          "name": "ipavailable",
          "type": "string"
        },
        {
          "description": "true if the account requires cleanup",
          "name": "iscleanuprequired",
          "type": "boolean"
        },
        {
          "description": "the ID of the role",
          "name": "roleid",
          "type": "string"
        },
        {
          "description": "the total number of templates available to be created by this account",
          "name": "templateavailable",
          "type": "string"
        },
        {
          "description": "the total number of templates which can be created by this account",
          "name": "templatelimit",
          "type": "string"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the total number of vpcs the account can own",
          "name": "vpclimit",
          "type": "string"
        },
        {
          "description": "the id of the account",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the total primary storage space (in GiB) the account can own",
          "name": "primarystoragelimit",
          "type": "string"
        },
        {
          "description": "path of the Domain the account belongs to",
          "name": "domainpath",
          "type": "string"
        },
        {
          "description": "the total number of templates which have been created by this account",
          "name": "templatetotal",
          "type": "long"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the total volume which can be used by this account",
          "name": "volumelimit",
          "type": "string"
        },
        {
          "description": "the total number of projects available for administration by this account",
          "name": "projectavailable",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "the total secondary storage space (in GiB) the account can own",
          "name": "secondarystoragelimit",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines running for this account",
          "name": "vmrunning",
          "type": "integer"
        },
        {
          "description": "the total memory (in MB) owned by account",
          "name": "memorytotal",
          "type": "long"
        },
        {
          "description": "the total number of snapshots which can be stored by this account",
          "name": "snapshotlimit",
          "type": "string"
        },
        {},
        {
          "description": "the total primary storage space (in GiB) available to be used for this account",
          "name": "primarystorageavailable",
          "type": "string"
        },
        {
          "description": "the total number of cpu cores the account can own",
          "name": "cpulimit",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines available for this account to acquire",
          "name": "vmavailable",
          "type": "string"
        },
        {
          "description": "the total number of vpcs available to be created for this account",
          "name": "vpcavailable",
          "type": "string"
        },
        {
          "description": "the total secondary storage space (in GiB) owned by account",
          "name": "secondarystoragetotal",
          "type": "float"
        },
        {
          "description": "the total number of cpu cores available to be created for this account",
          "name": "cpuavailable",
          "type": "string"
        },
        {},
        {
          "description": "name of the Domain the account belongs to",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the total volume available for this account",
          "name": "volumeavailable",
          "type": "string"
        },
        {
          "description": "the total number of networks owned by account",
          "name": "networktotal",
          "type": "long"
        },
        {
          "description": "the total memory (in MB) available to be created for this account",
          "name": "memoryavailable",
          "type": "string"
        },
        {
          "description": "the network domain",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the total number of cpu cores owned by account",
          "name": "cputotal",
          "type": "long"
        },
        {
          "description": "the total primary storage space (in GiB) owned by account",
          "name": "primarystoragetotal",
          "type": "long"
        },
        {
          "description": "the total number of snapshots available for this account",
          "name": "snapshotavailable",
          "type": "string"
        },
        {
          "description": "the name of the role",
          "name": "rolename",
          "type": "string"
        },
        {
          "description": "the total number of vpcs owned by account",
          "name": "vpctotal",
          "type": "long"
        },
        {
          "description": "the list of acl groups that account belongs to",
          "name": "groups",
          "type": "list"
        },
        {
          "description": "the type of the role (Admin, ResourceAdmin, DomainAdmin, User)",
          "name": "roletype",
          "type": "string"
        },
        {
          "description": "the total number of projects being administrated by this account",
          "name": "projecttotal",
          "type": "long"
        },
        {
          "description": "the state of the account",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the total number of public ip addresses this account can acquire",
          "name": "iplimit",
          "type": "string"
        },
        {
          "description": "the total volume being used by this account",
          "name": "volumetotal",
          "type": "long"
        },
        {
          "description": "true if account is default, false otherwise",
          "name": "isdefault",
          "type": "boolean"
        },
        {
          "description": "the total number of networks available to be created for this account",
          "name": "networkavailable",
          "type": "string"
        },
        {
          "description": "the total number of snapshots stored by this account",
          "name": "snapshottotal",
          "type": "long"
        },
        {
          "description": "the list of users associated with account",
          "name": "user",
          "response": [
            {
              "description": "the secret key of the user",
              "name": "secretkey",
              "type": "string"
            },
            {
              "description": "the user name",
              "name": "username",
              "type": "string"
            },
            {
              "description": "the domain name of the user",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the account ID of the user",
              "name": "accountid",
              "type": "string"
            },
            {
              "description": "the user firstname",
              "name": "firstname",
              "type": "string"
            },
            {
              "description": "the account name of the user",
              "name": "account",
              "type": "string"
            },
            {
              "description": "true if user is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "the user email address",
              "name": "email",
              "type": "string"
            },
            {
              "description": "the domain ID of the user",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the user lastname",
              "name": "lastname",
              "type": "string"
            },
            {
              "description": "the user ID",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the account type of the user",
              "name": "accounttype",
              "type": "integer"
            },
            {
              "description": "the api key of the user",
              "name": "apikey",
              "type": "string"
            },
            {
              "description": "the date and time the user account was created",
              "name": "created",
              "type": "date"
            },
            {
              "description": "the user state",
              "name": "state",
              "type": "string"
            },
            {
              "description": "true if user has two factor authentication is mandated",
              "name": "is2famandated",
              "type": "boolean"
            },
            {
              "description": "Base64 string representation of the resource icon",
              "name": "icon",
              "type": "resourceiconresponse"
            },
            {
              "description": "the type of the role",
              "name": "roletype",
              "type": "string"
            },
            {
              "description": "the boolean value representing if the updating target is in caller's child domain",
              "name": "iscallerchilddomain",
              "type": "boolean"
            },
            {
              "description": "the source type of the user in lowercase, such as native, ldap, saml2",
              "name": "usersource",
              "type": "string"
            },
            {
              "description": "the timezone user was created in",
              "name": "timezone",
              "type": "string"
            },
            {
              "description": "the ID of the role",
              "name": "roleid",
              "type": "string"
            },
            {
              "description": "the name of the role",
              "name": "rolename",
              "type": "string"
            },
            {
              "description": "true if user has two factor authentication enabled",
              "name": "is2faenabled",
              "type": "boolean"
            }
          ],
          "type": "list"
        }
      ],
      "since": "4.2.0"
    },
    {
      "description": "Safely removes raw records from cloud_usage table",
      "isasync": false,
      "name": "removeRawUsageRecords",
      "params": [
        {
          "description": "Specify the number of days (greater than zero) to remove records that are older than those number of days from today. For example, specifying 10 would result in removing all the records created before 10 days from today",
          "length": 255,
          "name": "interval",
          "required": true,
          "type": "integer"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {}
      ],
      "since": "4.6.0"
    },
    {
      "description": "Copies an iso from one zone to another.",
      "isasync": true,
      "name": "copyIso",
      "params": [
        {
          "description": "ID of the zone the template is being copied to.",
          "length": 255,
          "name": "destzoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "A list of IDs of the zones that the template needs to be copied to.Specify this list if the template needs to copied to multiple zones in one go. Do not specify destzoneid and destzoneids together, however one of them is required.",
          "length": 255,
          "name": "destzoneids",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "list"
        },
        {
          "description": "Template ID.",
          "length": 255,
          "name": "id",
          "related": "prepareTemplate,copyIso,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "ID of the zone the template is currently hosted on. If not specified and template is cross-zone, then we will sync this template to region wide image store.",
          "length": 255,
          "name": "sourcezoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
      "response": [
        {
          "description": "the ID of the domain to which the template belongs",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the tag of this template",
          "name": "templatetag",
          "type": "string"
        },
        {
          "description": "the template ID of the parent template if present",
          "name": "sourcetemplateid",
          "type": "string"
        },
        {
          "description": "the id of userdata linked to this template",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the size of the template",
          "name": "size",
          "type": "long"
        },
        {
          "description": "the template name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "true if the template is ready to be deployed from, false otherwise.",
          "name": "isready",
          "type": "boolean"
        },
        {
          "description": "true if this template is a public template, false otherwise",
          "name": "ispublic",
          "type": "boolean"
        },
        {
          "description": "the format of the template.",
          "name": "format",
          "type": "imageformat"
        },
        {
          "description": "if root disk template, then ids of the datas disk templates this template owns",
          "name": "childtemplates",
          "type": "set"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the template ID",
          "name": "id",
          "type": "string"
        },
        {
          "description": "true if template is sshkey enabled, false otherwise",
          "name": "sshkeyenabled",
          "type": "boolean"
        },
        {
          "description": "if Datadisk template, then id of the root disk template this template belongs to",
          "name": "parenttemplateid",
          "type": "string"
        },
        {
          "description": "the name of the domain to which the template belongs",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the name of userdata linked to this template",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "the project id of the template",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "true if the ISO is bootable, false otherwise",
          "name": "bootable",
          "type": "boolean"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "true if this template is a featured template, false otherwise",
          "name": "isfeatured",
          "type": "boolean"
        },
        {
          "description": "the date this template was removed",
          "name": "removed",
          "type": "date"
        },
        {
          "description": "the ID of the zone for this template",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the date this template was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "true if the reset password feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "the name of the zone for this template",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the ID of the OS type for this template.",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "Lists the download progress of a template across all secondary storages",
          "name": "downloaddetails",
          "type": "list"
        },
        {
          "description": "the physical size of the template",
          "name": "physicalsize",
          "type": "long"
        },
        {
          "description": "VMware only: additional key/value details tied with deploy-as-is template",
          "name": "deployasisdetails",
          "type": "map"
        },
        {
          "description": "the URL which the template/iso is registered from",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the processor bit size",
          "name": "bits",
          "type": "int"
        },
        {
          "description": "checksum of the template",
          "name": "checksum",
          "type": "string"
        },
        {
          "description": "true if the template is extractable, false otherwise",
          "name": "isextractable",
          "type": "boolean"
        },
        {
          "description": "the account name to which the template belongs",
          "name": "account",
          "type": "string"
        },
        {
          "description": "true if template requires HVM enabled, false otherwise",
          "name": "requireshvm",
          "type": "boolean"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "the template display text",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the name of the OS type for this template.",
          "name": "ostypename",
          "type": "string"
        },
        {},
        {
          "description": "the name of the secondary storage host for the template",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "VMware only: true if template is deployed without orchestrating disks and networks but \"as-is\" defined in the template.",
          "name": "deployasis",
          "type": "boolean"
        },
        {
          "description": "the status of the template",
          "name": "status",
          "type": "string"
        },
        {},
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the project name of the template",
          "name": "project",
          "type": "string"
        },
        {
          "description": "additional key/value details tied with template",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the secondary storage host for the template",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "list of parameters which contains the list of keys or string parameters that are needed to be passed for any variables declared in userdata",
          "name": "userdataparams",
          "type": "string"
        },
        {
          "description": "true if the template is managed across all Zones, false otherwise",
          "name": "crossZones",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the type of the template",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "the account id to which the template belongs",
          "name": "accountid",
          "type": "string"
        },
        {
          "description": "KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage",
          "name": "directdownload",
          "type": "boolean"
        }
      ]
    },
    {
      "description": "Deletes a autoscale vm profile.",
      "isasync": true,
      "name": "deleteAutoScaleVmProfile",
      "params": [
        {
          "description": "the ID of the autoscale profile",
          "length": 255,
          "name": "id",
          "related": "createAutoScaleVmProfile,listAutoScaleVmProfiles,updateAutoScaleVmProfile",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Issues and propagates client certificate on a connected host/agent using configured CA plugin",
      "isasync": true,
      "name": "provisionCertificate",
      "params": [
        {
          "description": "The host/agent uuid to which the certificate has to be provisioned (issued and propagated)",
          "length": 255,
          "name": "hostid",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,listHosts,prepareHostForMaintenance,reconnectHost,updateHost,addBaremetalHost",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Whether to attempt reconnection with host/agent after successful deployment of certificate. When option is not provided, configured global setting is used",
          "length": 255,
          "name": "reconnect",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "Name of the CA service provider, otherwise the default configured provider plugin will be used",
          "length": 255,
          "name": "provider",
          "required": false,
          "type": "string"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.11.0"
    },
    {
      "description": "Lists VM metrics",
      "isasync": false,
      "name": "listVirtualMachinesMetrics",
      "params": [
        {
          "description": "the availability zone ID",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "comma separated list of host details requested, value can be a list of [all, group, nics, stats, secgrp, tmpl, servoff, diskoff, iso, volume, min, affgrp]. If no parameter is passed in, the details will be defaulted to all",
          "length": 255,
          "name": "details",
          "required": false,
          "type": "list"
        },
        {
          "description": "Accumulates the VM metrics data instead of returning only the most recent data collected. The default behavior is set by the global configuration vm.stats.increment.metrics.",
          "length": 255,
          "name": "accumulate",
          "required": false,
          "since": "4.17.0",
          "type": "boolean"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "list by the service offering",
          "length": 255,
          "name": "serviceofferingid",
          "related": "createServiceOffering,updateServiceOffering,listServiceOfferings",
          "required": false,
          "since": "4.4",
          "type": "uuid"
        },
        {
          "description": "flag to list vms created from VNF templates (as known as VNF appliances) or not; true if need to list VNF appliances, false otherwise.",
          "length": 255,
          "name": "isvnf",
          "required": false,
          "since": "4.19.0",
          "type": "boolean"
        },
        {
          "description": "the security group ID",
          "length": 255,
          "name": "securitygroupid",
          "related": "createSecurityGroup,listSecurityGroups,updateSecurityGroup",
          "required": false,
          "since": "4.15",
          "type": "uuid"
        },
        {
          "description": "the ID of AutoScaling VM Group",
          "length": 255,
          "name": "autoscalevmgroupid",
          "related": "createAutoScaleVmGroup,disableAutoScaleVmGroup,enableAutoScaleVmGroup,listAutoScaleVmGroups,updateAutoScaleVmGroup",
          "required": false,
          "since": "4.18.0",
          "type": "uuid"
        },
        {
          "description": "Whether to return the VMs' user data or not. By default, user data will not be returned.",
          "length": 255,
          "name": "userdata",
          "required": false,
          "since": "4.18.0.0",
          "type": "boolean"
        },
        {
          "description": "makes the API's response contains only the resource count",
          "length": 255,
          "name": "retrieveonlyresourcecount",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "flag to display the resource icon for VMs",
          "length": 255,
          "name": "showicon",
          "required": false,
          "since": "4.16.0.0",
          "type": "boolean"
        },
        {
          "description": "the user ID that created the VM and is under the account that owns the VM",
          "length": 255,
          "name": "userid",
          "related": "createUser,disableUser,enableUser,getUser,listUsers,lockUser,updateUser",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the pod ID",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the host ID",
          "length": 255,
          "name": "hostid",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,listHosts,prepareHostForMaintenance,reconnectHost,updateHost,addBaremetalHost",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the target hypervisor for the template",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "list by network type; true if need to list vms using Virtual Network, false otherwise",
          "length": 255,
          "name": "forvirtualnetwork",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list vms by iso",
          "length": 255,
          "name": "isoid",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the virtual machine",
          "length": 255,
          "name": "id",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list vms by affinity group",
          "length": 255,
          "name": "affinitygroupid",
          "related": "createAffinityGroup,listAffinityGroups",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list vms by template",
          "length": 255,
          "name": "templateid",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list by the backup offering",
          "length": 255,
          "name": "backupofferingid",
          "required": false,
          "since": "4.17",
          "type": "uuid"
        },
        {
          "description": "the storage ID where vm's volumes belong to",
          "length": 255,
          "name": "storageid",
          "related": "listVsphereStoragePolicyCompatiblePools,cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,updateStoragePool,syncStoragePool,updateStorageCapabilities",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "displayvm",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "state of the virtual machine. Possible values are: Running, Stopped, Present, Destroyed, Expunged. Present is used for the state equal not destroyed.",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "list by the High Availability offering; true if filtering VMs with HA enabled; false for VMs with HA disabled",
          "length": 255,
          "name": "haenable",
          "required": false,
          "since": "4.15",
          "type": "boolean"
        },
        {
          "description": "the IDs of the virtual machines, mutually exclusive with id",
          "length": 255,
          "name": "ids",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": false,
          "since": "4.4",
          "type": "list"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list vms by ssh keypair name",
          "length": 255,
          "name": "keypair",
          "required": false,
          "type": "string"
        },
        {
          "description": "the group ID",
          "length": 255,
          "name": "groupid",
          "related": "createInstanceGroup,listInstanceGroups,updateInstanceGroup",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "name of the virtual machine (a substring match is made against the parameter value, data for all matching VMs will be returned)",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "list by network id",
          "length": 255,
          "name": "networkid",
          "related": "createNetwork,listNetworks,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the cluster ID",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,listClusters,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain,moveDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list vms by vpc",
          "length": 255,
          "name": "vpcid",
          "related": "createVPC,listVPCs,updateVPC,createVPC,listVPCs,updateVPC,migrateVPC",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        }
      ],
      "related": "listVirtualMachinesMetrics",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the user's ID who deployed the virtual machine",
          "name": "userid",
          "type": "string"
        },
        {
          "description": "network read in MiB",
          "name": "networkread",
          "type": "string"
        },
        {
          "description": "the type of the template for the virtual machine",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
          "name": "displayname",
          "type": "string"
        },
        {
          "description": "device type of the root volume",
          "name": "rootdevicetype",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the ID of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "the date when this virtual machine was updated last time",
          "name": "lastupdated",
          "type": "date"
        },
        {
          "description": "the read (IO) of disk on the VM",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "the name of the virtual machine",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {},
        {
          "description": "the ID of the virtual machine",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the vGPU type used by the virtual machine",
          "name": "vgpu",
          "type": "string"
        },
        {
          "description": "the user's name who deployed the virtual machine",
          "name": "username",
          "type": "string"
        },
        {
          "description": "list of variables and values for the variables declared in userdata",
          "name": "userdatadetails",
          "type": "string"
        },
        {
          "description": "list of affinity groups associated with the virtual machine",
          "name": "affinitygroup",
          "response": [
            {
              "description": "the domain name of the affinity group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the ID of the affinity group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the name of the affinity group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the type of the affinity group",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the domain ID of the affinity group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the project ID of the affinity group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the project name of the affinity group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the account owning the affinity group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the description of the affinity group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "virtual machine IDs associated with this affinity group",
              "name": "virtualmachineIds",
              "type": "list"
            }
          ],
          "type": "set"
        },
        {
          "description": "the state of the virtual machine",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the amount of the vm's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the speed of each vCPU",
          "name": "cpuspeed",
          "type": "integer"
        },
        {
          "description": "the number of vCPUs this virtual machine is using",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "disk write in MiB",
          "name": "diskwrite",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "true if the password rest feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "the write (IO) of disk on the VM",
          "name": "diskiowrite",
          "type": "long"
        },
        {
          "description": "the list of nics associated with vm",
          "name": "nic",
          "response": [
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            }
          ],
          "type": "set"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "the internal memory (KiB) that's free in VM or zero if it can not be calculated",
          "name": "memoryintfreekbs",
          "type": "long"
        },
        {
          "description": "the memory allocated for the virtual machine",
          "name": "memory",
          "type": "integer"
        },
        {
          "description": "an optional field whether to the display the vm to the end user or not.",
          "name": "displayvm",
          "type": "boolean"
        },
        {
          "description": "the virtual network for the service offering",
          "name": "forvirtualnetwork",
          "type": "boolean"
        },
        {
          "description": "the ID of the host for the virtual machine",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the ID of the backup offering of the virtual machine",
          "name": "backupofferingid",
          "type": "string"
        },
        {
          "description": "the password (if exists) of the virtual machine",
          "name": "password",
          "type": "string"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "State of the Service from LB rule",
          "name": "servicestate",
          "type": "string"
        },
        {
          "description": "the VM's primary IP address",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the pool type of the virtual machine",
          "name": "pooltype",
          "type": "string"
        },
        {
          "description": "Vm details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "List of read-only Vm details as comma separated string.",
          "name": "readonlydetails",
          "type": "string"
        },
        {
          "description": "the control state of the host for the virtual machine",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Mode",
          "name": "bootmode",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "the ID of the domain in which the virtual machine exists",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "VNF details",
          "name": "vnfdetails",
          "type": "map"
        },
        {
          "description": "network write in MiB",
          "name": "networkwrite",
          "type": "string"
        },
        {
          "description": "true if high-availability is enabled, false otherwise",
          "name": "haenable",
          "type": "boolean"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "the name of the availability zone for the virtual machine",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicipid",
          "type": "string"
        },
        {
          "description": "the incoming network traffic on the VM in KiB",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "OS name of the vm",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "the memory used by the VM in KiB",
          "name": "memorykbs",
          "type": "long"
        },
        {
          "description": "the group name of the virtual machine",
          "name": "group",
          "type": "string"
        },
        {},
        {
          "description": "the project id of the vm",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "NICs of the VNF appliance",
          "name": "vnfnics",
          "type": "list"
        },
        {
          "description": "the id of userdata used for the VM",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "OS type id of the vm",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "the project name of the vm",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "Os type ID of the virtual machine",
          "name": "guestosid",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Type",
          "name": "boottype",
          "type": "string"
        },
        {
          "description": "device ID of the root volume",
          "name": "rootdeviceid",
          "type": "long"
        },
        {
          "description": "the date when this virtual machine was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the name of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "the total cpu capacity in Ghz",
          "name": "cputotal",
          "type": "string"
        },
        {
          "description": "the total disk iops",
          "name": "diskiopstotal",
          "type": "long"
        },
        {
          "description": "list of security groups associated with the virtual machine",
          "name": "securitygroup",
          "response": [
            {
              "description": "the number of virtualmachines associated with this securitygroup",
              "name": "virtualmachinecount",
              "type": "integer"
            },
            {
              "description": "the list of virtualmachine ids associated with this securitygroup",
              "name": "virtualmachineids",
              "type": "set"
            },
            {
              "description": "the project id of the group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the name of the security group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the description of the security group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                },
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the ID of the security group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the domain name of the security group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the list of ingress rules associated with the security group",
              "name": "ingressrule",
              "response": [
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the project name of the group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the domain ID of the security group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the account owning the security group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the list of egress rules associated with the security group",
              "name": "egressrule",
              "response": [
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                }
              ],
              "type": "set"
            }
          ],
          "type": "set"
        },
        {
          "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
          "name": "instancename",
          "type": "string"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the name of the backup offering of the virtual machine",
          "name": "backupofferingname",
          "type": "string"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "ssh key-pairs",
          "name": "keypairs",
          "type": "string"
        },
        {
          "description": "disk read in MiB",
          "name": "diskread",
          "type": "string"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "the ID of the availability zone for the virtual machine",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the name of userdata used for the VM",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "Name of AutoScale VM group",
          "name": "autoscalevmgroupname",
          "type": "string"
        },
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "the total memory capacity in GiB",
          "name": "memorytotal",
          "type": "string"
        },
        {
          "description": "the name of the domain in which the virtual machine exists",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the account associated with the virtual machine",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the group ID of the virtual machine",
          "name": "groupid",
          "type": "string"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {},
        {
          "description": "the name of the host for the virtual machine",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "Base64 string containing the user data",
          "name": "userdata",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the target memory in VM (KiB)",
          "name": "memorytargetkbs",
          "type": "long"
        },
        {
          "description": "ID of AutoScale VM group",
          "name": "autoscalevmgroupid",
          "type": "string"
        },
        {
          "description": "the outgoing network traffic on the host in KiB",
          "name": "networkkbswrite",
          "type": "long"
        }
      ]
    },
    {
      "description": "Lists hosts.",
      "isasync": false,
      "name": "listHosts",
      "params": [
        {
          "description": "comma separated list of host details requested, value can be a list of [ min, all, capacity, events, stats]",
          "length": 255,
          "name": "details",
          "required": false,
          "type": "list"
        },
        {
          "description": "the state of the host",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list hosts by resource state. Resource state represents current state determined by admin of host, value can be one of [Enabled, Disabled, Unmanaged, PrepareForMaintenance, ErrorInMaintenance, Maintenance, Error]",
          "length": 255,
          "name": "resourcestate",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list hosts for which out-of-band management is enabled",
          "length": 255,
          "name": "outofbandmanagementenabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the Pod ID for the host",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the name of the host",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "hypervisor type of host: XenServer,KVM,VMware,Hyperv,BareMetal,Simulator",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "the id of the host",
          "length": 255,
          "name": "id",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,listHosts,prepareHostForMaintenance,reconnectHost,updateHost,addBaremetalHost",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists hosts existing in particular cluster",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,listClusters,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists hosts in the same cluster as this VM and flag hosts with enough CPU/RAm to host this VM",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "if true, list only hosts dedicated to HA",
          "length": 255,
          "name": "hahost",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the Zone ID for the host",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list hosts by its out-of-band management interface's power state. Its value can be one of [On, Off, Unknown]",
          "length": 255,
          "name": "outofbandmanagementpowerstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the host type",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        }
      ],
      "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,updateHost,addBaremetalHost",
      "response": [
        {
          "description": "the incoming network traffic on the host",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "the IP address of the host",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise",
          "name": "suitableformigration",
          "type": "boolean"
        },
        {},
        {
          "description": "the host version",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the last annotation set on this host by an admin",
          "name": "annotation",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the amount of the host's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the ID of the host",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "Whether the informed tag is a JS interpretable rule or not.",
          "name": "istagarule",
          "type": "boolean"
        },
        {
          "description": "the amount of the host's memory currently used",
          "name": "memoryused",
          "type": "long"
        },
        {
          "description": "the amount of the host's CPU currently allocated after applying the cpu.overprovisioning.factor",
          "name": "cpuallocatedwithoverprovisioning",
          "type": "string"
        },
        {
          "description": "capabilities of the host",
          "name": "capabilities",
          "type": "string"
        },
        {
          "description": "comma-separated list of tags for the host",
          "name": "hosttags",
          "type": "string"
        },
        {
          "description": "the host's currently allocated disk size",
          "name": "disksizeallocated",
          "type": "long"
        },
        {
          "description": "the cluster ID of the host",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "events available for the host",
          "name": "events",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory currently allocated in percentage",
          "name": "memoryallocatedpercentage",
          "type": "string"
        },
        {
          "description": "the cluster type of the cluster that host belongs to",
          "name": "clustertype",
          "type": "string"
        },
        {
          "description": "the resource state of the host",
          "name": "resourcestate",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory after applying the mem.overprovisioning.factor",
          "name": "memorywithoverprovisioning",
          "type": "string"
        },
        {
          "description": "the host out-of-band management information",
          "name": "outofbandmanagement",
          "type": "outofbandmanagementresponse"
        },
        {
          "description": "the memory total of the host, this parameter is deprecated use memorywithoverprovisioning",
          "name": "memorytotal",
          "type": "long"
        },
        {
          "description": "the management server ID of the host",
          "name": "managementserverid",
          "type": "string"
        },
        {
          "description": "GPU cards present in the host",
          "name": "gpugroup",
          "response": [
            {
              "description": "the list of enabled vGPUs",
              "name": "vgpu",
              "response": [
                {
                  "description": "Maximum Y resolution per display",
                  "name": "maxresolutiony",
                  "type": "long"
                },
                {
                  "description": "Maximum vgpu can be created with this vgpu type on the given gpu group",
                  "name": "maxcapacity",
                  "type": "long"
                },
                {
                  "description": "Maximum no. of vgpu per gpu card (pgpu)",
                  "name": "maxvgpuperpgpu",
                  "type": "long"
                },
                {
                  "description": "Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type",
                  "name": "remainingcapacity",
                  "type": "long"
                },
                {
                  "description": "Video RAM for this vGPU type",
                  "name": "videoram",
                  "type": "long"
                },
                {
                  "description": "Maximum X resolution per display",
                  "name": "maxresolutionx",
                  "type": "long"
                },
                {
                  "description": "Model Name of vGPU",
                  "name": "vgputype",
                  "type": "string"
                },
                {
                  "description": "Maximum displays per user",
                  "name": "maxheads",
                  "type": "long"
                }
              ],
              "type": "list"
            },
            {
              "description": "GPU cards present in the host",
              "name": "gpugroupname",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "true if the host supports encryption",
          "name": "encryptionsupported",
          "type": "boolean"
        },
        {
          "description": "true if the host is disconnected. False otherwise.",
          "name": "disconnected",
          "type": "date"
        },
        {
          "description": "the amount of the host's CPU currently allocated in MHz",
          "name": "cpuallocatedvalue",
          "type": "long"
        },
        {
          "description": "the amount of the host's memory currently allocated in bytes",
          "name": "memoryallocatedbytes",
          "type": "long"
        },
        {
          "description": "the name of the host",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the OS category ID of the host",
          "name": "oscategoryid",
          "type": "string"
        },
        {
          "description": "the number of CPU sockets on the host",
          "name": "cpusockets",
          "type": "integer"
        },
        {
          "description": "the outgoing network traffic on the host",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "the date and time the host was removed",
          "name": "removed",
          "type": "date"
        },
        {
          "description": "the date and time the host was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the admin that annotated this host",
          "name": "username",
          "type": "string"
        },
        {
          "description": "the host HA information information",
          "name": "hostha",
          "type": "hostharesponse"
        },
        {
          "description": "the OS category name of the host",
          "name": "oscategoryname",
          "type": "string"
        },
        {
          "description": "the Pod ID of the host",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory currently allocated",
          "name": "memoryallocated",
          "type": "long"
        },
        {
          "description": "the host type",
          "name": "type",
          "type": "type"
        },
        {
          "description": "the cpu average load on the host",
          "name": "cpuloadaverage",
          "type": "double"
        },
        {
          "description": "the last time this host was annotated",
          "name": "lastannotated",
          "type": "date"
        },
        {
          "description": "true if the host has capability to support UEFI boot",
          "name": "ueficapability",
          "type": "boolean"
        },
        {
          "description": "true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise",
          "name": "hasenoughcapacity",
          "type": "boolean"
        },
        {
          "description": "the Pod name of the host",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the CPU speed of the host",
          "name": "cpuspeed",
          "type": "long"
        },
        {
          "description": "the amount of the host's CPU currently allocated in percentage",
          "name": "cpuallocatedpercentage",
          "type": "string"
        },
        {
          "description": "true if local storage is active, false otherwise",
          "name": "islocalstorageactive",
          "type": "boolean"
        },
        {
          "description": "the Zone name of the host",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the hypervisor version",
          "name": "hypervisorversion",
          "type": "string"
        },
        {
          "description": "true if the host is Ha host (dedicated to vms started by HA process; false otherwise",
          "name": "hahost",
          "type": "boolean"
        },
        {
          "description": "Host details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the state of the host",
          "name": "state",
          "type": "status"
        },
        {
          "description": "the Zone ID of the host",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the date and time the host was last pinged",
          "name": "lastpinged",
          "type": "date"
        },
        {
          "description": "the amount of the host's CPU after applying the cpu.overprovisioning.factor",
          "name": "cpuwithoverprovisioning",
          "type": "string"
        },
        {
          "description": "the CPU number of the host",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "the amount of the host's CPU currently allocated",
          "name": "cpuallocated",
          "type": "string"
        },
        {
          "description": "the cluster name of the host",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "the host hypervisor",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the total disk size of the host",
          "name": "disksizetotal",
          "type": "long"
        }
      ]
    },
    {
      "description": "Deletes a storage pool.",
      "isasync": false,
      "name": "deleteStoragePool",
      "params": [
        {
          "description": "Storage pool id",
          "length": 255,
          "name": "id",
          "related": "listVsphereStoragePolicyCompatiblePools,cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,updateStoragePool,syncStoragePool,updateStorageCapabilities",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Force destroy storage pool (force expunge volumes in Destroyed state as a part of pool removal)",
          "length": 255,
          "name": "forced",
          "required": false,
          "type": "boolean"
        }
      ],
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        }
      ]
    },
    {
      "description": "List storage pools compatible with a vSphere storage policy",
      "isasync": false,
      "name": "listVsphereStoragePolicyCompatiblePools",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "ID of the storage policy",
          "length": 255,
          "name": "policyid",
          "related": "importVsphereStoragePolicies,listVsphereStoragePolicies",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "ID of the zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,updateStoragePool,syncStoragePool,updateStorageCapabilities",
      "response": [
        {
          "description": "the Pod ID of the storage pool",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the date and time the storage pool was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the ID of the storage pool",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the storage pool path",
          "name": "path",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "IOPS CloudStack can provision from this storage pool",
          "name": "capacityiops",
          "type": "long"
        },
        {
          "description": "the name of the storage pool",
          "name": "name",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the host's currently allocated disk size",
          "name": "disksizeallocated",
          "type": "long"
        },
        {
          "description": "the storage pool capabilities",
          "name": "storagecapabilities",
          "type": "map"
        },
        {
          "description": "the scope of the storage pool",
          "name": "scope",
          "type": "string"
        },
        {
          "description": "the Zone ID of the storage pool",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the Zone name of the storage pool",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the host's currently used disk size",
          "name": "disksizeused",
          "type": "long"
        },
        {
          "description": "Whether the informed tag is a JS interpretable rule or not.",
          "name": "istagarule",
          "type": "boolean"
        },
        {},
        {
          "description": "the overprovisionfactor for the storage pool",
          "name": "overprovisionfactor",
          "type": "string"
        },
        {
          "description": "total min IOPS currently in use by volumes",
          "name": "allocatediops",
          "type": "long"
        },
        {
          "description": "the total disk size of the storage pool",
          "name": "disksizetotal",
          "type": "long"
        },
        {
          "description": "the hypervisor type of the storage pool",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the state of the storage pool",
          "name": "state",
          "type": "storagepoolstatus"
        },
        {
          "description": "the IP address of the storage pool",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "Storage provider for this pool",
          "name": "provider",
          "type": "string"
        },
        {
          "description": "the name of the cluster for the storage pool",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "the Pod name of the storage pool",
          "name": "podname",
          "type": "string"
        },
        {},
        {
          "description": "true if this pool is suitable to migrate a volume, false otherwise",
          "name": "suitableformigration",
          "type": "boolean"
        },
        {
          "description": "the storage pool type",
          "name": "type",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the tags for the storage pool",
          "name": "tags",
          "type": "string"
        },
        {
          "description": "the ID of the cluster for the storage pool",
          "name": "clusterid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Deletes an existing guest network IPv6 prefix.",
      "isasync": true,
      "name": "deleteGuestNetworkIpv6Prefix",
      "params": [
        {
          "description": "Id of the guest network IPv6 prefix",
          "length": 255,
          "name": "id",
          "related": "createGuestNetworkIpv6Prefix,listGuestNetworkIpv6Prefixes",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {}
      ],
      "since": "4.17.0.0"
    },
    {
      "description": "Updates a storage pool.",
      "isasync": false,
      "name": "updateStoragePool",
      "params": [
        {
          "description": "Change the name of the storage pool",
          "length": 255,
          "name": "name",
          "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,updateStoragePool,syncStoragePool,updateStorageCapabilities",
          "required": false,
          "since": "4.15",
          "type": "string"
        },
        {
          "description": "Whether the informed tag is a JS interpretable rule or not.",
          "length": 255,
          "name": "istagarule",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the details for the storage pool",
          "length": 255,
          "name": "details",
          "required": false,
          "since": "4.19.0",
          "type": "map"
        },
        {
          "description": "comma-separated list of tags for the storage pool",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "list"
        },
        {
          "description": "the Id of the storage pool",
          "length": 255,
          "name": "id",
          "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,updateStoragePool,syncStoragePool,updateStorageCapabilities",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "IOPS CloudStack can provision from this storage pool",
          "length": 255,
          "name": "capacityiops",
          "required": false,
          "type": "long"
        },
        {
          "description": "the URL of the storage pool",
          "length": 255,
          "name": "url",
          "required": false,
          "since": "4.19.0",
          "type": "string"
        },
        {
          "description": "false to disable the pool for allocation of new volumes, true to enable it back.",
          "length": 255,
          "name": "enabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "bytes CloudStack can provision from this storage pool",
          "length": 255,
          "name": "capacitybytes",
          "required": false,
          "type": "long"
        }
      ],
      "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,syncStoragePool,updateStorageCapabilities",
      "response": [
        {
          "description": "the host's currently used disk size",
          "name": "disksizeused",
          "type": "long"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the name of the storage pool",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the name of the cluster for the storage pool",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "the host's currently allocated disk size",
          "name": "disksizeallocated",
          "type": "long"
        },
        {
          "description": "the ID of the cluster for the storage pool",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "the storage pool capabilities",
          "name": "storagecapabilities",
          "type": "map"
        },
        {},
        {
          "description": "total min IOPS currently in use by volumes",
          "name": "allocatediops",
          "type": "long"
        },
        {
          "description": "Whether the informed tag is a JS interpretable rule or not.",
          "name": "istagarule",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if this pool is suitable to migrate a volume, false otherwise",
          "name": "suitableformigration",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the storage pool type",
          "name": "type",
          "type": "string"
        },
        {
          "description": "the state of the storage pool",
          "name": "state",
          "type": "storagepoolstatus"
        },
        {},
        {
          "description": "the IP address of the storage pool",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the ID of the storage pool",
          "name": "id",
          "type": "string"
        },
        {
          "description": "IOPS CloudStack can provision from this storage pool",
          "name": "capacityiops",
          "type": "long"
        },
        {
          "description": "the date and time the storage pool was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the total disk size of the storage pool",
          "name": "disksizetotal",
          "type": "long"
        },
        {
          "description": "the tags for the storage pool",
          "name": "tags",
          "type": "string"
        },
        {
          "description": "the overprovisionfactor for the storage pool",
          "name": "overprovisionfactor",
          "type": "string"
        },
        {
          "description": "the Pod ID of the storage pool",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the scope of the storage pool",
          "name": "scope",
          "type": "string"
        },
        {
          "description": "the storage pool path",
          "name": "path",
          "type": "string"
        },
        {
          "description": "the Pod name of the storage pool",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the hypervisor type of the storage pool",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the Zone name of the storage pool",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "Storage provider for this pool",
          "name": "provider",
          "type": "string"
        },
        {
          "description": "the Zone ID of the storage pool",
          "name": "zoneid",
          "type": "string"
        }
      ],
      "since": "3.0.0"
    },
    {
      "description": "Reboots a system VM.",
      "isasync": true,
      "name": "rebootSystemVm",
      "params": [
        {
          "description": "The ID of the system virtual machine",
          "length": 255,
          "name": "id",
          "related": "destroySystemVm,listSystemVms,migrateSystemVm,rebootSystemVm,startSystemVm,stopSystemVm,changeServiceForSystemVm,scaleSystemVm",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Force reboot the system VM (System VM is Stopped and then Started)",
          "length": 255,
          "name": "forced",
          "required": false,
          "since": "4.16.0",
          "type": "boolean"
        }
      ],
      "related": "destroySystemVm,listSystemVms,migrateSystemVm,startSystemVm,stopSystemVm,changeServiceForSystemVm,scaleSystemVm",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the link local MAC address for the system vm",
          "name": "linklocalmacaddress",
          "type": "string"
        },
        {
          "description": "the template ID for the system VM",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "guest vlan range",
          "name": "guestvlan",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the date and time the system VM was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the public netmask for the system VM",
          "name": "publicnetmask",
          "type": "string"
        },
        {
          "description": "the Zone ID for the system VM",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the Pod name for the system VM",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the link local IP address for the system vm",
          "name": "linklocalip",
          "type": "string"
        },
        {
          "description": "the network domain for the system VM",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the host ID for the system VM",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "public vlan range",
          "name": "publicvlan",
          "type": "list"
        },
        {
          "description": "the last disconnected date of host",
          "name": "disconnected",
          "type": "date"
        },
        {
          "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the public MAC address for the system VM",
          "name": "publicmacaddress",
          "type": "string"
        },
        {
          "description": "the ID of the system VM",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the Pod ID for the system VM",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the first DNS for the system VM",
          "name": "dns1",
          "type": "string"
        },
        {
          "description": "the second DNS for the system VM",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "the link local netmask for the system vm",
          "name": "linklocalnetmask",
          "type": "string"
        },
        {
          "description": "the system VM type",
          "name": "systemvmtype",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the Zone name for the system VM",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the state of the system VM",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the hostname for the system VM",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the name of the system VM",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the systemvm agent version",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the system virtual machine.",
          "name": "serviceofferingid",
          "type": "string"
        },
        {},
        {
          "description": "the control state of the host for the system VM",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the public IP address for the system VM",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the gateway for the system VM",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the private netmask for the system VM",
          "name": "privatenetmask",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the system virtual machine.",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the private MAC address for the system VM",
          "name": "privatemacaddress",
          "type": "string"
        },
        {
          "description": "the agent state of the system VM",
          "name": "agentstate",
          "type": "string"
        },
        {
          "description": "the private IP address for the system VM",
          "name": "privateip",
          "type": "string"
        },
        {
          "description": "the template name for the system VM",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the number of active console sessions for the console proxy system vm",
          "name": "activeviewersessions",
          "type": "integer"
        },
        {}
      ]
    },
    {
      "description": "Lists Tungsten-Fabric tags",
      "isasync": false,
      "name": "listTungstenFabricTag",
      "params": [
        {
          "description": "the uuid of Tungsten-Fabric policy",
          "length": 255,
          "name": "policyuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the uuid of Tungsten-Fabric application policy set",
          "length": 255,
          "name": "applicationpolicysetuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the uuid of Tungsten-Fabric vm",
          "length": 255,
          "name": "vmuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the uuid of Tungsten-Fabric network",
          "length": 255,
          "name": "networkuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the uuid of Tungsten-Fabric tag",
          "length": 255,
          "name": "taguuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the uuid of Tungsten-Fabric nic",
          "length": 255,
          "name": "nicuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "createTungstenFabricTag,applyTungstenFabricTag,removeTungstenFabricTag",
      "response": [
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric tag type uuid",
          "name": "uuid",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "list Tungsten-Fabric network",
          "name": "network",
          "type": "list"
        },
        {
          "description": "list Tungsten-Fabric nic",
          "name": "nic",
          "type": "list"
        },
        {
          "description": "list Tungsten-Fabric vm",
          "name": "vm",
          "type": "list"
        },
        {},
        {
          "description": "list Tungsten-Fabric policy",
          "name": "policy",
          "type": "list"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Tungsten-Fabric tag name",
          "name": "name",
          "type": "string"
        }
      ]
    },
    {
      "description": "Import LDAP users",
      "isasync": false,
      "name": "importLdapUsers",
      "params": [
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "Creates the account under the specified role.",
          "length": 255,
          "name": "roleid",
          "related": "createRole,importRole,listRoles,updateRole",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "details for account used to store specific parameters",
          "length": 255,
          "name": "accountdetails",
          "required": false,
          "type": "map"
        },
        {
          "description": "Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.",
          "length": 255,
          "name": "timezone",
          "required": false,
          "type": "string"
        },
        {
          "description": "Creates the user under the specified account. If no account is specified, the username will be used as the account name.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "Specifies the domain to which the ldap users are to be imported. If no domain is specified, a domain will created using group parameter. If the group is also not specified, a domain name based on the OU information will be created. If no OU hierarchy exists, will be defaulted to ROOT domain",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain,moveDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "Specifies the group name from which the ldap users are to be imported. If no group is specified, all the users will be imported.",
          "length": 255,
          "name": "group",
          "required": false,
          "type": "string"
        },
        {
          "description": "Type of the account.  Specify 0 for user, 1 for root admin, and 2 for domain admin",
          "length": 255,
          "name": "accounttype",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "searchLdap,listLdapUsers",
      "response": [
        {
          "description": "The user's username",
          "name": "username",
          "type": "string"
        },
        {
          "description": "The user's email",
          "name": "email",
          "type": "string"
        },
        {
          "description": "The user's domain",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "The authentication source for this user as known to the system or empty if the user is not yet in cloudstack.",
          "name": "conflictingusersource",
          "type": "string"
        },
        {},
        {
          "description": "The user's firstname",
          "name": "firstname",
          "type": "string"
        },
        {
          "description": "The user's principle",
          "name": "principal",
          "type": "string"
        },
        {},
        {
          "description": "The user's lastname",
          "name": "lastname",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ],
      "since": "4.3.0"
    },
    {
      "description": "Moves a domain and its children to a new parent domain.",
      "isasync": false,
      "name": "moveDomain",
      "params": [
        {
          "description": "The ID of the new parent domain of the domain to be moved.",
          "length": 255,
          "name": "parentdomainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain,moveDomain",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "The ID of the domain to be moved.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain,moveDomain",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
      "response": [
        {
          "description": "the total number of snapshots stored by this domain",
          "name": "snapshottotal",
          "type": "long"
        },
        {
          "description": "the total number of templates which can be created by this domain",
          "name": "templatelimit",
          "type": "string"
        },
        {
          "description": "the state of the domain",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the total number of networks owned by domain",
          "name": "networktotal",
          "type": "long"
        },
        {
          "description": "the total number of vpcs available to be created for this domain",
          "name": "vpcavailable",
          "type": "string"
        },
        {
          "description": "the total memory (in MB) owned by domain",
          "name": "memorytotal",
          "type": "long"
        },
        {
          "description": "the total primary storage space (in GiB) available to be used for this domain",
          "name": "primarystorageavailable",
          "type": "string"
        },
        {
          "description": "the total secondary storage space (in GiB) the domain can own",
          "name": "secondarystoragelimit",
          "type": "string"
        },
        {
          "description": "the level of the domain",
          "name": "level",
          "type": "integer"
        },
        {
          "description": "the total secondary storage space (in GiB) owned by domain",
          "name": "secondarystoragetotal",
          "type": "float"
        },
        {
          "description": "the total number of virtual machines available for this domain to acquire",
          "name": "vmavailable",
          "type": "string"
        },
        {
          "description": "the domain ID of the parent domain",
          "name": "parentdomainid",
          "type": "string"
        },
        {
          "description": "the network domain",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the total number of public ip addresses available for this domain to acquire",
          "name": "ipavailable",
          "type": "string"
        },
        {
          "description": "the total number of snapshots which can be stored by this domain",
          "name": "snapshotlimit",
          "type": "string"
        },
        {
          "description": "the total number of projects being administrated by this domain",
          "name": "projecttotal",
          "type": "long"
        },
        {
          "description": "the total number of public ip addresses allocated for this domain",
          "name": "iptotal",
          "type": "long"
        },
        {
          "description": "the total number of vpcs the domain can own",
          "name": "vpclimit",
          "type": "string"
        },
        {},
        {},
        {
          "description": "the total number of projects available for administration by this domain",
          "name": "projectavailable",
          "type": "string"
        },
        {
          "description": "the total number of cpu cores the domain can own",
          "name": "cpulimit",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the total memory (in MB) the domain can own",
          "name": "memorylimit",
          "type": "string"
        },
        {
          "description": "the total secondary storage space (in GiB) available to be used for this domain",
          "name": "secondarystorageavailable",
          "type": "string"
        },
        {
          "description": "the total primary storage space (in GiB) owned by domain",
          "name": "primarystoragetotal",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines deployed by this domain",
          "name": "vmtotal",
          "type": "long"
        },
        {
          "description": "the total volume which can be used by this domain",
          "name": "volumelimit",
          "type": "string"
        },
        {
          "description": "the total number of public ip addresses this domain can acquire",
          "name": "iplimit",
          "type": "string"
        },
        {
          "description": "the total number of templates available to be created by this domain",
          "name": "templateavailable",
          "type": "string"
        },
        {
          "description": "the date when this domain was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the total primary storage space (in GiB) the domain can own",
          "name": "primarystoragelimit",
          "type": "string"
        },
        {
          "description": "the name of the domain",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the total number of snapshots available for this domain",
          "name": "snapshotavailable",
          "type": "string"
        },
        {
          "description": "the total number of networks available to be created for this domain",
          "name": "networkavailable",
          "type": "string"
        },
        {
          "description": "the ID of the domain",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the total volume being used by this domain",
          "name": "volumetotal",
          "type": "long"
        },
        {
          "description": "the total number of vpcs owned by domain",
          "name": "vpctotal",
          "type": "long"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the total number of cpu cores owned by domain",
          "name": "cputotal",
          "type": "long"
        },
        {
          "description": "the total memory (in MB) available to be created for this domain",
          "name": "memoryavailable",
          "type": "string"
        },
        {
          "description": "whether the domain has one or more sub-domains",
          "name": "haschild",
          "type": "boolean"
        },
        {
          "description": "the total number of projects the domain can own",
          "name": "projectlimit",
          "type": "string"
        },
        {
          "description": "the domain name of the parent domain",
          "name": "parentdomainname",
          "type": "string"
        },
        {
          "description": "the path of the domain",
          "name": "path",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines that can be deployed by this domain",
          "name": "vmlimit",
          "type": "string"
        },
        {
          "description": "the total number of templates which have been created by this domain",
          "name": "templatetotal",
          "type": "long"
        },
        {
          "description": "the total number of cpu cores available to be created for this domain",
          "name": "cpuavailable",
          "type": "string"
        },
        {
          "description": "the total volume available for this domain",
          "name": "volumeavailable",
          "type": "string"
        },
        {
          "description": "details for the domain",
          "name": "domaindetails",
          "type": "map"
        },
        {
          "description": "the total number of networks the domain can own",
          "name": "networklimit",
          "type": "string"
        }
      ],
      "since": "4.19.0.0"
    },
    {
      "description": "Lists all available networks.",
      "isasync": false,
      "name": "listNetworks",
      "params": [
        {
          "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "displaynetwork",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "List networks by VPC",
          "length": 255,
          "name": "vpcid",
          "related": "createVPC,listVPCs,updateVPC,createVPC,listVPCs,updateVPC,migrateVPC",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list networks by physical network id",
          "length": 255,
          "name": "physicalnetworkid",
          "related": "createPhysicalNetwork,listPhysicalNetworks,updatePhysicalNetwork",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list networks by ID",
          "length": 255,
          "name": "id",
          "related": "createNetwork,listNetworks,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "true if network is system, false otherwise",
          "length": 255,
          "name": "issystem",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the ID or VID of the network",
          "length": 255,
          "name": "vlan",
          "required": false,
          "since": "4.17.0",
          "type": "string"
        },
        {
          "description": "makes the API's response contains only the resource count",
          "length": 255,
          "name": "retrieveonlyresourcecount",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the type of the network. Supported values are: isolated, l2, shared and all",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "type of the traffic",
          "length": 255,
          "name": "traffictype",
          "required": false,
          "type": "string"
        },
        {
          "description": "the network belongs to VPC",
          "length": 255,
          "name": "forvpc",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the zone ID of the network",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list networks supporting certain services",
          "length": 255,
          "name": "supportedservices",
          "required": false,
          "type": "list"
        },
        {
          "description": "list networks by ACL (access control list) type. Supported values are account and domain",
          "length": 255,
          "name": "acltype",
          "required": false,
          "type": "string"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "possible values are \"account\", \"domain\", \"accountdomain\",\"shared\", and \"all\". Default value is \"all\".* account : account networks that have been registered for or created by the calling user. * domain : domain networks that have been registered for or created by the calling user. * accountdomain : account and domain networks that have been registered for or created by the calling user. * shared : networks that have been granted to the calling user by another user. * all : all networks (account, domain and shared).",
          "length": 255,
          "name": "networkfilter",
          "required": false,
          "since": "4.17.0",
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "list networks by network offering ID",
          "length": 255,
          "name": "networkofferingid",
          "related": "createNetworkOffering,updateNetworkOffering,listNetworkOfferings",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list networks available for VM deployment",
          "length": 255,
          "name": "canusefordeploy",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "flag to display the resource icon for networks",
          "length": 255,
          "name": "showicon",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list networks by restartRequired",
          "length": 255,
          "name": "restartrequired",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "true if need to list only networks which support specifying IP ranges",
          "length": 255,
          "name": "specifyipranges",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "List networks by associated networks. Only available if create a Shared network.",
          "length": 255,
          "name": "associatednetworkid",
          "related": "createNetwork,listNetworks,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "since": "4.17.0",
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "createNetwork,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
      "response": [
        {
          "description": "the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE",
          "name": "networkcidr",
          "type": "string"
        },
        {
          "description": "the id of the network",
          "name": "id",
          "type": "string"
        },
        {
          "description": "ACL name associated with the VPC network",
          "name": "aclname",
          "type": "string"
        },
        {
          "description": "the domain name of the network owner",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "The external id of the network",
          "name": "externalid",
          "type": "string"
        },
        {
          "description": "the project id of the ipaddress",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {},
        {
          "description": "true if network offering is ip conserve mode enabled",
          "name": "networkofferingconservemode",
          "type": "boolean"
        },
        {
          "description": "if network offering supports vm autoscaling feature",
          "name": "supportsvmautoscaling",
          "type": "boolean"
        },
        {
          "description": "availability of the network offering the network is created from",
          "name": "networkofferingavailability",
          "type": "string"
        },
        {
          "description": "the first IPv6 DNS for the network",
          "name": "ip6dns1",
          "type": "string"
        },
        {
          "description": "the owner of the network",
          "name": "account",
          "type": "string"
        },
        {
          "description": "an optional field, whether to the display the network to the end user or not.",
          "name": "displaynetwork",
          "type": "boolean"
        },
        {
          "description": "the network domain",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the date this network was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "true if users from subdomains can access the domain level network",
          "name": "subdomainaccess",
          "type": "boolean"
        },
        {
          "description": "the name of the zone the network belongs to",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "network offering id the network is created from",
          "name": "networkofferingid",
          "type": "string"
        },
        {
          "description": "the cidr of IPv6 network",
          "name": "ip6cidr",
          "type": "string"
        },
        {
          "description": "The vlan of the network. This parameter is visible to ROOT admins only",
          "name": "vlan",
          "type": "string"
        },
        {
          "description": "the name of the Network associated with this network",
          "name": "associatednetwork",
          "type": "string"
        },
        {
          "description": "Name of the VPC to which this network belongs",
          "name": "vpcname",
          "type": "string"
        },
        {
          "description": "the name of the Network associated with this private gateway",
          "name": "associatednetwork",
          "type": "string"
        },
        {
          "description": "The routes for the network to ease adding route in upstream router",
          "name": "ip6routes",
          "type": "set"
        },
        {
          "description": "true if network is system, false otherwise",
          "name": "issystem",
          "type": "boolean"
        },
        {
          "description": "the traffic type of the network",
          "name": "traffictype",
          "type": "string"
        },
        {
          "description": "ACL Id associated with the VPC network",
          "name": "aclid",
          "type": "string"
        },
        {
          "description": "the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes",
          "name": "reservediprange",
          "type": "string"
        },
        {
          "description": "the project name of the address",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the details of the network",
          "name": "details",
          "type": "map"
        },
        {
          "description": "acl type - access type to the network",
          "name": "acltype",
          "type": "string"
        },
        {
          "description": "the second IPv4 DNS for the network",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "true if network can span multiple zones",
          "name": "strechedl2subnet",
          "type": "boolean"
        },
        {
          "description": "Tungsten-Fabric virtual router the network belongs to",
          "name": "tungstenvirtualrouteruuid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the type of the network",
          "name": "type",
          "type": "string"
        },
        {
          "description": "the ID of the Network associated with this network",
          "name": "associatednetworkid",
          "type": "string"
        },
        {
          "description": "state of the network",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the second IPv6 DNS for the network",
          "name": "ip6dns2",
          "type": "string"
        },
        {
          "description": "related to what other network configuration",
          "name": "related",
          "type": "string"
        },
        {
          "description": "true if guest network default egress policy is allow; false if default egress policy is deny",
          "name": "egressdefaultpolicy",
          "type": "boolean"
        },
        {
          "description": "The internet protocol of network offering",
          "name": "internetprotocol",
          "type": "string"
        },
        {
          "description": "zone id of the network",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "true if network is default, false otherwise",
          "name": "isdefault",
          "type": "boolean"
        },
        {
          "description": "Broadcast domain type of the network",
          "name": "broadcastdomaintype",
          "type": "string"
        },
        {
          "description": "the list of services",
          "name": "service",
          "response": [
            {
              "description": "the list of capabilities",
              "name": "capability",
              "response": [
                {
                  "description": "the capability value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "can this service capability value can be choosable while creatine network offerings",
                  "name": "canchooseservicecapability",
                  "type": "boolean"
                },
                {
                  "description": "the capability name",
                  "name": "name",
                  "type": "string"
                }
              ],
              "type": "list"
            },
            {
              "description": "the service provider name",
              "name": "provider",
              "response": [
                {
                  "description": "true if individual services can be enabled/disabled",
                  "name": "canenableindividualservice",
                  "type": "boolean"
                },
                {
                  "description": "the destination physical network",
                  "name": "destinationphysicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "state of the network provider",
                  "name": "state",
                  "type": "string"
                },
                {
                  "description": "uuid of the network provider",
                  "name": "id",
                  "type": "string"
                },
                {
                  "description": "services for this provider",
                  "name": "servicelist",
                  "type": "list"
                },
                {
                  "description": "the provider name",
                  "name": "name",
                  "type": "string"
                },
                {
                  "description": "the physical network this belongs to",
                  "name": "physicalnetworkid",
                  "type": "string"
                }
              ],
              "type": "list"
            },
            {
              "description": "the service name",
              "name": "name",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the network's netmask",
          "name": "netmask",
          "type": "string"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "list networks that are persistent",
          "name": "ispersistent",
          "type": "boolean"
        },
        {
          "description": "the list of resource tags associated with network",
          "name": "tags",
          "response": [
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "MTU configured on the network VR's public facing interfaces",
          "name": "publicmtu",
          "type": "integer"
        },
        {
          "description": "Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR",
          "name": "cidr",
          "type": "string"
        },
        {
          "description": "name of the network offering the network is created from",
          "name": "networkofferingname",
          "type": "string"
        },
        {
          "description": "the gateway of IPv6 network",
          "name": "ip6gateway",
          "type": "string"
        },
        {
          "description": "the ID of the Network associated with this private gateway",
          "name": "associatednetworkid",
          "type": "string"
        },
        {
          "description": "the first IPv4 DNS for the network",
          "name": "dns1",
          "type": "string"
        },
        {
          "description": "the physical network id",
          "name": "physicalnetworkid",
          "type": "string"
        },
        {
          "description": "If the network has redundant routers enabled",
          "name": "redundantrouter",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "VPC the network belongs to",
          "name": "vpcid",
          "type": "string"
        },
        {},
        {
          "description": "the name of the network",
          "name": "name",
          "type": "string"
        },
        {
          "description": "display text of the network offering the network is created from",
          "name": "networkofferingdisplaytext",
          "type": "string"
        },
        {
          "description": "The routing mode of network offering",
          "name": "ip6routing",
          "type": "string"
        },
        {
          "description": "the domain id of the network owner",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans",
          "name": "zonesnetworkspans",
          "type": "set"
        },
        {
          "description": "the network's gateway",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "MTU configured on the network VR's private interfaces",
          "name": "privatemtu",
          "type": "integer"
        },
        {
          "description": "broadcast uri of the network. This parameter is visible to ROOT admins only",
          "name": "broadcasturi",
          "type": "string"
        },
        {
          "description": "path of the Domain the network belongs to",
          "name": "domainpath",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "true if network supports specifying ip ranges, false otherwise",
          "name": "specifyipranges",
          "type": "boolean"
        },
        {
          "description": "the displaytext of the network",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true network requires restart",
          "name": "restartrequired",
          "type": "boolean"
        },
        {
          "description": "list networks available for vm deployment",
          "name": "canusefordeploy",
          "type": "boolean"
        }
      ]
    },
    {
      "description": "List dedicated zones.",
      "isasync": false,
      "name": "listDedicatedZones",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the ID of the Zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the name of the account associated with the zone. Must be used with domainId.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the domain associated with the zone",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list dedicated zones by affinity group",
          "length": 255,
          "name": "affinitygroupid",
          "related": "createAffinityGroup,listAffinityGroups",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "dedicateZone",
      "response": [
        {
          "description": "the Account Id to which the Zone is dedicated",
          "name": "accountid",
          "type": "string"
        },
        {
          "description": "the Name of the Zone",
          "name": "zonename",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the Zone",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the domain ID to which the Zone is dedicated",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the ID of the dedicated resource",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the Dedication Affinity Group ID of the zone",
          "name": "affinitygroupid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Lists the pools of elastistor",
      "isasync": false,
      "name": "listElastistorPool",
      "params": [
        {
          "description": "the ID of the Pool",
          "length": 255,
          "name": "id",
          "required": false,
          "type": "long"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the name of the storage pool",
          "name": "name",
          "type": "string"
        },
        {
          "description": "available iops of the pool",
          "name": "maxiops",
          "type": "long"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current available space of the pool",
          "name": "size",
          "type": "long"
        },
        {
          "description": "controller of the pool",
          "name": "controllerid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the storage pool",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the state of the storage pool",
          "name": "state",
          "type": "string"
        },
        {
          "description": "default gateway of the pool",
          "name": "gateway",
          "type": "string"
        }
      ]
    },
    {
      "description": "Releases an IP address from the account.",
      "isasync": false,
      "name": "releaseIpAddress",
      "params": [
        {
          "description": "the ID of the public IP address to release",
          "length": 255,
          "name": "id",
          "related": "associateIpAddress,reserveIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {},
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ],
      "since": "4.17"
    },
    {
      "description": "Updates a management network IP range. Only allowed when no IPs are allocated.",
      "isasync": true,
      "name": "updatePodManagementNetworkIpRange",
      "params": [
        {
          "description": "The new ending IP address.",
          "length": 255,
          "name": "newendip",
          "required": false,
          "type": "string"
        },
        {
          "description": "The current starting IP address.",
          "length": 255,
          "name": "currentstartip",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": true,
          "type": "string"
        },
        {
          "description": "The new starting IP address.",
          "length": 255,
          "name": "newstartip",
          "required": false,
          "type": "string"
        },
        {
          "description": "UUID of POD, where the IP range belongs to.",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "The current ending IP address.",
          "length": 255,
          "name": "currentendip",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": true,
          "type": "string"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.16.0.0"
    },
    {
      "description": "list Tungsten-Fabric LB health monitor",
      "isasync": false,
      "name": "listTungstenFabricLBHealthMonitor",
      "params": [
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the ID of lb rule",
          "length": 255,
          "name": "lbruleid",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,listIpv6FirewallRules,updateIpv6FirewallRule",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "updateTungstenFabricLBHealthMonitor",
      "response": [
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the health monitor UUID",
          "name": "uuid",
          "type": "string"
        },
        {
          "description": "the health monitor timeout",
          "name": "timeout",
          "type": "int"
        },
        {
          "description": "the health monitor expected code",
          "name": "expectedcode",
          "type": "string"
        },
        {
          "description": "the LB rule ID",
          "name": "lbruleid",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the health monitor ID",
          "name": "id",
          "type": "long"
        },
        {
          "description": "the health monitor retry",
          "name": "retry",
          "type": "int"
        },
        {
          "description": "the health monitor url path",
          "name": "urlpath",
          "type": "string"
        },
        {},
        {
          "description": "the health monitor http method",
          "name": "httpmethod",
          "type": "string"
        },
        {
          "description": "the health monitor interval",
          "name": "interval",
          "type": "int"
        },
        {},
        {
          "description": "the health monitor type",
          "name": "type",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Updates firewall rule ",
      "isasync": true,
      "name": "updateFirewallRule",
      "params": [
        {
          "description": "the ID of the firewall rule",
          "length": 255,
          "name": "id",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,listIpv6FirewallRules,updateIpv6FirewallRule",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
          "length": 255,
          "name": "customid",
          "required": false,
          "since": "4.4",
          "type": "string"
        },
        {
          "description": "an optional field, whether to the display the rule to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        }
      ],
      "related": "createEgressFirewallRule,createFirewallRule,listEgressFirewallRules,listFirewallRules,updateEgressFirewallRule",
      "response": [
        {
          "description": "the public ip address for the firewall rule",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the cidr list to forward traffic from. Multiple entries are separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {
          "description": "the starting port of firewall rule's port range",
          "name": "startport",
          "type": "integer"
        },
        {
          "description": "the cidr list to forward traffic to. Multiple entries are separated by a single comma character (,).",
          "name": "destcidrlist",
          "type": "string"
        },
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the ID of the firewall rule",
          "name": "id",
          "type": "string"
        },
        {
          "description": "error code for this icmp message",
          "name": "icmpcode",
          "type": "integer"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the list of resource tags associated with the rule",
          "name": "tags",
          "response": [
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "type of the icmp message being sent",
          "name": "icmptype",
          "type": "integer"
        },
        {},
        {
          "description": "the ending port of firewall rule's port range",
          "name": "endport",
          "type": "integer"
        },
        {
          "description": "the traffic type for the firewall rule",
          "name": "traffictype",
          "type": "string"
        },
        {
          "description": "the protocol of the firewall rule",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "is rule for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the public ip address id for the firewall rule",
          "name": "ipaddressid",
          "type": "string"
        },
        {
          "description": "the network id of the firewall rule",
          "name": "networkid",
          "type": "string"
        }
      ],
      "since": "4.4"
    },
    {
      "description": "Return true if the plugin is enabled",
      "isasync": false,
      "name": "quotaIsEnabled",
      "params": [],
      "related": "",
      "response": [
        {},
        {},
        {
          "description": "is quota service enabled",
          "name": "isenabled",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.7.0"
    },
    {
      "description": "Deletes the registered OAuth provider",
      "isasync": false,
      "name": "deleteOauthProvider",
      "params": [
        {
          "description": "id of the OAuth provider to be deleted",
          "length": 255,
          "name": "id",
          "related": "listOauthProvider,verifyOAuthCodeAndGetUser,updateOauthProvider",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Deletes account from the project",
      "isasync": true,
      "name": "deleteAccountFromProject",
      "params": [
        {
          "description": "ID of the project to remove the account from",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "name of the account to be removed from the project",
          "length": 255,
          "name": "account",
          "required": true,
          "type": "string"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "3.0.0"
    },
    {
      "description": "List hypervisors",
      "isasync": false,
      "name": "listHypervisors",
      "params": [
        {
          "description": "the zone id for listing hypervisors.",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "Hypervisor name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {}
      ]
    },
    {
      "description": "Updates the information about Guest OS",
      "isasync": true,
      "name": "updateGuestOs",
      "params": [
        {
          "description": "Unique display name for Guest OS",
          "length": 255,
          "name": "osdisplayname",
          "required": true,
          "type": "string"
        },
        {
          "description": "UUID of the Guest OS",
          "length": 255,
          "name": "id",
          "related": "listOsTypes,addGuestOs,updateGuestOs",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Map of (key/value pairs)",
          "length": 255,
          "name": "details",
          "required": false,
          "type": "map"
        },
        {
          "description": "whether this guest OS is available for end users",
          "length": 255,
          "name": "forDisplay",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "listOsTypes,addGuestOs",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "is the guest OS visible for the users",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the ID of the OS type",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the ID of the OS category",
          "name": "oscategoryid",
          "type": "string"
        },
        {
          "description": "the name of the OS category",
          "name": "oscategoryname",
          "type": "string"
        },
        {
          "description": "the name of the OS type",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the name/description of the OS type",
          "name": "description",
          "type": "string"
        },
        {
          "description": "is the guest OS user defined",
          "name": "isuserdefined",
          "type": "boolean"
        }
      ],
      "since": "4.4.0"
    },
    {
      "description": "Lists all guest vlans",
      "isasync": false,
      "name": "listGuestVlans",
      "params": [
        {
          "description": "list guest vlan by vnet",
          "length": 255,
          "name": "vnet",
          "required": false,
          "type": "string"
        },
        {
          "description": "list guest vlan by id",
          "length": 255,
          "name": "id",
          "required": false,
          "type": "long"
        },
        {
          "description": "list guest vlan by physical network",
          "length": 255,
          "name": "physicalnetworkid",
          "related": "createPhysicalNetwork,listPhysicalNetworks,updatePhysicalNetwork",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list guest vlan by zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "limits search results to allocated guest vlan. false by default.",
          "length": 255,
          "name": "allocatedonly",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the guest VLAN",
          "name": "vlan",
          "type": "string"
        },
        {},
        {
          "description": "the project name of the guest VLAN range",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the zone name of the guest VLAN range",
          "name": "zonename",
          "type": "string"
        },
        {},
        {
          "description": "the account of the guest VLAN range",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the domain ID of the guest VLAN range",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the physical network name of the guest VLAN range",
          "name": "physicalnetworkname",
          "type": "string"
        },
        {
          "description": "the domain name of the guest VLAN range",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the physical network ID of the guest VLAN range",
          "name": "physicalnetworkid",
          "type": "string"
        },
        {
          "description": "the guest VLAN id",
          "name": "id",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the zone ID of the guest VLAN range",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the project id of the guest VLAN range",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the list of networks who use this guest VLAN",
          "name": "network",
          "type": "list"
        },
        {
          "description": "the allocation state of the guest VLAN",
          "name": "allocationstate",
          "type": "string"
        },
        {
          "description": "true if the guest VLAN is dedicated to the account",
          "name": "isdedicated",
          "type": "boolean"
        },
        {
          "description": "date the guest VLAN was taken",
          "name": "taken",
          "type": "date"
        }
      ],
      "since": "4.17.0"
    },
    {
      "description": "Updates resource limits for an account or domain.",
      "isasync": false,
      "name": "updateResourceLimit",
      "params": [
        {
          "description": "Update resource limits for all accounts in specified domain. If used with the account parameter, updates resource limits for a specified account in specified domain.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Update resource limits for project",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Type of resource to update. Values are 0, 1, 2, 3, 4, 6, 7, 8, 9, 10 and 11. 0 - Instance. Number of instances a user can create. 1 - IP. Number of public IP addresses a user can own. 2 - Volume. Number of disk volumes a user can create. 3 - Snapshot. Number of snapshots a user can create. 4 - Template. Number of templates that a user can register/create. 6 - Network. Number of guest network a user can create. 7 - VPC. Number of VPC a user can create. 8 - CPU. Total number of CPU cores a user can use. 9 - Memory. Total Memory (in MB) a user can use. 10 - PrimaryStorage. Total primary storage space (in GiB) a user can use. 11 - SecondaryStorage. Total secondary storage space (in GiB) a user can use. ",
          "length": 255,
          "name": "resourcetype",
          "required": true,
          "type": "integer"
        },
        {
          "description": "Update resource for a specified account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "  Maximum resource limit.",
          "length": 255,
          "name": "max",
          "required": false,
          "type": "long"
        }
      ],
      "related": "listResourceLimits",
      "response": [
        {
          "description": "the project name of the resource limit",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the account of the resource limit",
          "name": "account",
          "type": "string"
        },
        {
          "description": "resource type. Values include 0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11. See the resourceType parameter for more information on these values.",
          "name": "resourcetype",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the domain name of the resource limit",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "resource type name. Values include user_vm, public_ip, volume, snapshot, template, project, network, vpc, cpu, memory, primary_storage, secondary_storage.",
          "name": "resourcetypename",
          "type": "string"
        },
        {
          "description": "the domain ID of the resource limit",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the maximum number of the resource. A -1 means the resource currently has no limit.",
          "name": "max",
          "type": "long"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the project id of the resource limit",
          "name": "projectid",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Deletes a static route",
      "isasync": true,
      "name": "deleteStaticRoute",
      "params": [
        {
          "description": "the ID of the static route",
          "length": 255,
          "name": "id",
          "related": "createStaticRoute,listStaticRoutes",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Lists hosts metrics",
      "isasync": false,
      "name": "listHostsMetrics",
      "params": [
        {
          "description": "the state of the host",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "the Zone ID for the host",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists hosts existing in particular cluster",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,listClusters,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the Pod ID for the host",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list hosts for which out-of-band management is enabled",
          "length": 255,
          "name": "outofbandmanagementenabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "lists hosts in the same cluster as this VM and flag hosts with enough CPU/RAm to host this VM",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the id of the host",
          "length": 255,
          "name": "id",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,updateHost,addBaremetalHost",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "if true, list only hosts dedicated to HA",
          "length": 255,
          "name": "hahost",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "comma separated list of host details requested, value can be a list of [ min, all, capacity, events, stats]",
          "length": 255,
          "name": "details",
          "required": false,
          "type": "list"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the name of the host",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "list hosts by its out-of-band management interface's power state. Its value can be one of [On, Off, Unknown]",
          "length": 255,
          "name": "outofbandmanagementpowerstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "the host type",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list hosts by resource state. Resource state represents current state determined by admin of host, value can be one of [Enabled, Disabled, Unmanaged, PrepareForMaintenance, ErrorInMaintenance, Maintenance, Error]",
          "length": 255,
          "name": "resourcestate",
          "required": false,
          "type": "string"
        },
        {
          "description": "hypervisor type of host: XenServer,KVM,VMware,Hyperv,BareMetal,Simulator",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the number of CPU sockets on the host",
          "name": "cpusockets",
          "type": "integer"
        },
        {
          "description": "the amount of the host's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the total memory allocated in GiB",
          "name": "memoryallocatedgb",
          "type": "string"
        },
        {
          "description": "cpu allocated notification threshold exceeded",
          "name": "cpuallocatedthreshold",
          "type": "boolean"
        },
        {
          "description": "Whether the informed tag is a JS interpretable rule or not.",
          "name": "istagarule",
          "type": "boolean"
        },
        {
          "description": "the amount of the host's memory currently allocated in bytes",
          "name": "memoryallocatedbytes",
          "type": "long"
        },
        {
          "description": "the total memory capacity in GiB",
          "name": "memorytotalgb",
          "type": "string"
        },
        {
          "description": "the host type",
          "name": "type",
          "type": "type"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the host's currently allocated disk size",
          "name": "disksizeallocated",
          "type": "long"
        },
        {},
        {
          "description": "cpu usage notification threshold exceeded",
          "name": "cputhreshold",
          "type": "boolean"
        },
        {
          "description": "true if the host supports encryption",
          "name": "encryptionsupported",
          "type": "boolean"
        },
        {
          "description": "cpu usage disable threshold exceeded",
          "name": "cpudisablethreshold",
          "type": "boolean"
        },
        {
          "description": "true if the host is Ha host (dedicated to vms started by HA process; false otherwise",
          "name": "hahost",
          "type": "boolean"
        },
        {
          "description": "the total cpu allocated in Ghz",
          "name": "cpuallocatedghz",
          "type": "string"
        },
        {
          "description": "network write in GiB",
          "name": "networkwrite",
          "type": "string"
        },
        {},
        {
          "description": "memory allocated disable threshold exceeded",
          "name": "memoryallocateddisablethreshold",
          "type": "boolean"
        },
        {
          "description": "the host version",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the CPU number of the host",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "the amount of the host's memory after applying the mem.overprovisioning.factor",
          "name": "memorywithoverprovisioning",
          "type": "string"
        },
        {
          "description": "the date and time the host was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "memory usage disable threshold exceeded",
          "name": "memorydisablethreshold",
          "type": "boolean"
        },
        {
          "description": "the cluster name of the host",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "capabilities of the host",
          "name": "capabilities",
          "type": "string"
        },
        {
          "description": "the date and time the host was last pinged",
          "name": "lastpinged",
          "type": "date"
        },
        {
          "description": "memory usage notification threshold exceeded",
          "name": "memorythreshold",
          "type": "boolean"
        },
        {
          "description": "memory allocated notification threshold exceeded",
          "name": "memoryallocatedthreshold",
          "type": "boolean"
        },
        {
          "description": "the management server ID of the host",
          "name": "managementserverid",
          "type": "string"
        },
        {
          "description": "the incoming network traffic on the host",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "the amount of the host's memory currently allocated",
          "name": "memoryallocated",
          "type": "long"
        },
        {
          "description": "true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise",
          "name": "suitableformigration",
          "type": "boolean"
        },
        {
          "description": "the total disk size of the host",
          "name": "disksizetotal",
          "type": "long"
        },
        {
          "description": "the host out-of-band management information",
          "name": "outofbandmanagement",
          "type": "outofbandmanagementresponse"
        },
        {
          "description": "true if the host is disconnected. False otherwise.",
          "name": "disconnected",
          "type": "date"
        },
        {
          "description": "comma-separated list of tags for the host",
          "name": "hosttags",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU currently allocated in MHz",
          "name": "cpuallocatedvalue",
          "type": "long"
        },
        {
          "description": "the hypervisor version",
          "name": "hypervisorversion",
          "type": "string"
        },
        {
          "description": "the host hypervisor",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the Zone name of the host",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the state of the host",
          "name": "state",
          "type": "status"
        },
        {
          "description": "the amount of the host's CPU currently allocated in percentage",
          "name": "cpuallocatedpercentage",
          "type": "string"
        },
        {
          "description": "the total memory used in GiB",
          "name": "memoryusedgb",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory currently used",
          "name": "memoryused",
          "type": "long"
        },
        {
          "description": "the total cpu capacity in Ghz",
          "name": "cputotalghz",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory currently allocated in percentage",
          "name": "memoryallocatedpercentage",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the Pod name of the host",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the memory total of the host, this parameter is deprecated use memorywithoverprovisioning",
          "name": "memorytotal",
          "type": "long"
        },
        {
          "description": "the cluster ID of the host",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "Host details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "network read in GiB",
          "name": "networkread",
          "type": "string"
        },
        {
          "description": "the IP address of the host",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU currently allocated after applying the cpu.overprovisioning.factor",
          "name": "cpuallocatedwithoverprovisioning",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU currently allocated",
          "name": "cpuallocated",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU after applying the cpu.overprovisioning.factor",
          "name": "cpuwithoverprovisioning",
          "type": "string"
        },
        {
          "description": "the Pod ID of the host",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the resource state of the host",
          "name": "resourcestate",
          "type": "string"
        },
        {
          "description": "the OS category name of the host",
          "name": "oscategoryname",
          "type": "string"
        },
        {
          "description": "the OS category ID of the host",
          "name": "oscategoryid",
          "type": "string"
        },
        {
          "description": "the cpu average load on the host",
          "name": "cpuloadaverage",
          "type": "double"
        },
        {
          "description": "the outgoing network traffic on the host",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "the host HA information information",
          "name": "hostha",
          "type": "hostharesponse"
        },
        {
          "description": "the date and time the host was removed",
          "name": "removed",
          "type": "date"
        },
        {
          "description": "instances on the host",
          "name": "instances",
          "type": "string"
        },
        {
          "description": "the admin that annotated this host",
          "name": "username",
          "type": "string"
        },
        {
          "description": "true if local storage is active, false otherwise",
          "name": "islocalstorageactive",
          "type": "boolean"
        },
        {
          "description": "true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise",
          "name": "hasenoughcapacity",
          "type": "boolean"
        },
        {
          "description": "the last annotation set on this host by an admin",
          "name": "annotation",
          "type": "string"
        },
        {
          "description": "the last time this host was annotated",
          "name": "lastannotated",
          "type": "date"
        },
        {
          "description": "the ID of the host",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the Zone ID of the host",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the name of the host",
          "name": "name",
          "type": "string"
        },
        {
          "description": "out-of-band management power state",
          "name": "powerstate",
          "type": "powerstate"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the average cpu load the last minute",
          "name": "cpuloadaverage",
          "type": "double"
        },
        {
          "description": "events available for the host",
          "name": "events",
          "type": "string"
        },
        {
          "description": "the total cpu used in Ghz",
          "name": "cpuusedghz",
          "type": "string"
        },
        {
          "description": "GPU cards present in the host",
          "name": "gpugroup",
          "response": [
            {
              "description": "GPU cards present in the host",
              "name": "gpugroupname",
              "type": "string"
            },
            {
              "description": "the list of enabled vGPUs",
              "name": "vgpu",
              "response": [
                {
                  "description": "Maximum no. of vgpu per gpu card (pgpu)",
                  "name": "maxvgpuperpgpu",
                  "type": "long"
                },
                {
                  "description": "Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type",
                  "name": "remainingcapacity",
                  "type": "long"
                },
                {
                  "description": "Maximum displays per user",
                  "name": "maxheads",
                  "type": "long"
                },
                {
                  "description": "Model Name of vGPU",
                  "name": "vgputype",
                  "type": "string"
                },
                {
                  "description": "Maximum X resolution per display",
                  "name": "maxresolutionx",
                  "type": "long"
                },
                {
                  "description": "Video RAM for this vGPU type",
                  "name": "videoram",
                  "type": "long"
                },
                {
                  "description": "Maximum vgpu can be created with this vgpu type on the given gpu group",
                  "name": "maxcapacity",
                  "type": "long"
                },
                {
                  "description": "Maximum Y resolution per display",
                  "name": "maxresolutiony",
                  "type": "long"
                }
              ],
              "type": "list"
            }
          ],
          "type": "list"
        },
        {
          "description": "true if the host has capability to support UEFI boot",
          "name": "ueficapability",
          "type": "boolean"
        },
        {
          "description": "system vm instances on the host",
          "name": "systeminstances",
          "type": "string"
        },
        {
          "description": "the CPU speed of the host",
          "name": "cpuspeed",
          "type": "long"
        },
        {
          "description": "cpu allocated disable threshold exceeded",
          "name": "cpuallocateddisablethreshold",
          "type": "boolean"
        },
        {
          "description": "the cluster type of the cluster that host belongs to",
          "name": "clustertype",
          "type": "string"
        }
      ],
      "since": "4.9.3"
    },
    {
      "description": "get load balancer certificate",
      "isasync": false,
      "name": "getLoadBalancerSslCertificate",
      "params": [
        {
          "description": "the ID of Lb",
          "length": 255,
          "name": "id",
          "related": "getLoadBalancerSslCertificate",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "key",
          "name": "key",
          "type": "string"
        },
        {
          "description": "chain",
          "name": "chain",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "crt",
          "name": "crt",
          "type": "string"
        }
      ]
    },
    {
      "description": "Release the dedication for the pod",
      "isasync": true,
      "name": "releaseDedicatedPod",
      "params": [
        {
          "description": "the ID of the Pod",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Lists affinity groups",
      "isasync": false,
      "name": "listAffinityGroups",
      "params": [
        {
          "description": "lists affinity groups by name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "lists affinity groups by virtual machine ID",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "list the affinity group by the ID provided",
          "length": 255,
          "name": "id",
          "related": "createAffinityGroup,listAffinityGroups",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists affinity groups by type",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "createAffinityGroup",
      "response": [
        {
          "description": "the account owning the affinity group",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the project name of the affinity group",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "virtual machine IDs associated with this affinity group",
          "name": "virtualmachineIds",
          "type": "list"
        },
        {
          "description": "the domain ID of the affinity group",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the name of the affinity group",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the ID of the affinity group",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the type of the affinity group",
          "name": "type",
          "type": "string"
        },
        {},
        {
          "description": "the domain name of the affinity group",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the project ID of the affinity group",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the description of the affinity group",
          "name": "description",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Cancels a triggered shutdown",
      "isasync": false,
      "name": "cancelShutdown",
      "params": [
        {
          "description": "the uuid of the management server",
          "length": 255,
          "name": "managementserverid",
          "related": "listManagementServers",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "prepareForShutdown,readyForShutdown,triggerShutdown",
      "response": [
        {
          "description": "Indicates whether a shutdown has been triggered",
          "name": "shutdowntriggered",
          "type": "boolean"
        },
        {},
        {},
        {
          "description": "The number of jobs in progress",
          "name": "pendingjobscount",
          "type": "long"
        },
        {
          "description": "The id of the management server",
          "name": "managementserverid",
          "type": "long"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Indicates whether CloudStack is ready to shutdown",
          "name": "readyforshutdown",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Register a public key in a keypair under a certain name",
      "isasync": false,
      "name": "registerSSHKeyPair",
      "params": [
        {
          "description": "Public key material of the keypair",
          "length": 5120,
          "name": "publickey",
          "required": true,
          "type": "string"
        },
        {
          "description": "Name of the keypair",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "an optional account for the ssh key. Must be used with domainId.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional project for the ssh key",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "an optional domainId for the ssh key. If the account parameter is used, domainId must also be used.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "listSSHKeyPairs",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the domain id of the keypair owner",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the owner of the keypair",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the domain name of the keypair owner",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the project name of the keypair owner",
          "name": "project",
          "type": "string"
        },
        {
          "description": "ID of the ssh keypair",
          "name": "id",
          "type": "string"
        },
        {
          "description": "Fingerprint of the public key",
          "name": "fingerprint",
          "type": "string"
        },
        {},
        {
          "description": "the project id of the keypair owner",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "Name of the keypair",
          "name": "name",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        }
      ]
    },
    {
      "description": "Destroys a l2tp/ipsec remote access vpn",
      "isasync": true,
      "name": "deleteRemoteAccessVpn",
      "params": [
        {
          "description": "public ip address id of the vpn server",
          "length": 255,
          "name": "publicipid",
          "related": "associateIpAddress,reserveIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Start rolling maintenance",
      "isasync": true,
      "name": "startRollingMaintenance",
      "params": [
        {
          "description": "the IDs of the hosts to start maintenance on",
          "length": 255,
          "name": "hostids",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,updateHost,addBaremetalHost",
          "required": false,
          "type": "list"
        },
        {
          "description": "if rolling mechanism should continue in case of an error",
          "length": 255,
          "name": "forced",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "optional operation timeout (in seconds) that overrides the global timeout setting",
          "length": 255,
          "name": "timeout",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the IDs of the clusters to start maintenance on",
          "length": 255,
          "name": "clusterids",
          "related": "addCluster,listClusters,updateCluster",
          "required": false,
          "type": "list"
        },
        {
          "description": "the IDs of the zones to start maintenance on",
          "length": 255,
          "name": "zoneids",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "list"
        },
        {
          "description": "the command to execute while hosts are on maintenance",
          "length": 255,
          "name": "payload",
          "required": false,
          "type": "string"
        },
        {
          "description": "the IDs of the pods to start maintenance on",
          "length": 255,
          "name": "podids",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "list"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the hosts updated",
          "name": "hostsupdated",
          "response": [
            {
              "description": "the ID of the updated host",
              "name": "hostid",
              "type": "string"
            },
            {
              "description": "output of the maintenance script on the host",
              "name": "output",
              "type": "string"
            },
            {
              "description": "start date of the update on the host",
              "name": "startdate",
              "type": "string"
            },
            {
              "description": "the name of the updated host",
              "name": "hostname",
              "type": "string"
            },
            {
              "description": "end date of the update on the host",
              "name": "enddate",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the hosts skipped",
          "name": "hostsskipped",
          "response": [
            {
              "description": "the name of the skipped host",
              "name": "hostname",
              "type": "string"
            },
            {
              "description": "the ID of the skipped host",
              "name": "hostid",
              "type": "string"
            },
            {
              "description": "the reason to skip the host",
              "name": "reason",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "indicates if the rolling maintenance operation was successful",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "in case of failure, details are displayed",
          "name": "details",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "list Tungsten-Fabric application policy set",
      "isasync": false,
      "name": "listTungstenFabricApplicationPolicySet",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the uuid of Tungsten-Fabric application policy set",
          "length": 255,
          "name": "applicationpolicysetuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createTungstenFabricApplicationPolicySet",
      "response": [
        {
          "description": "Tungsten-Fabric policy name",
          "name": "name",
          "type": "string"
        },
        {},
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric application policy uuid",
          "name": "uuid",
          "type": "string"
        },
        {
          "description": "list Tungsten-Fabric firewall policy",
          "name": "firewallpolicy",
          "type": "list"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "list Tungsten-Fabric tag",
          "name": "tag",
          "type": "list"
        },
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Updates network ACL list",
      "isasync": true,
      "name": "updateNetworkACLList",
      "params": [
        {
          "description": "the ID of the network ACL",
          "length": 255,
          "name": "id",
          "related": "createNetworkACLList,listNetworkACLLists",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Name of the network ACL list",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
          "length": 255,
          "name": "customid",
          "required": false,
          "since": "4.4",
          "type": "string"
        },
        {
          "description": "Description of the network ACL list",
          "length": 255,
          "name": "description",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional field, whether to the display the list to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {}
      ],
      "since": "4.4"
    },
    {
      "description": "Reserve a public IP to an account.",
      "isasync": false,
      "name": "reserveIpAddress",
      "params": [
        {
          "description": "the ID of the domain to reserve with this IP address",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the account to reserve with this IP address",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the project to reserve with this IP address",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "an optional field, whether to the display the IP to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the ID of the public IP address to reserve",
          "length": 255,
          "name": "id",
          "related": "associateIpAddress,reserveIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "associateIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
      "response": [
        {
          "description": "true if this ip is system ip (was allocated as a part of deployVm or createLbRule)",
          "name": "issystem",
          "type": "boolean"
        },
        {
          "description": "the name of the Network associated with the IP address",
          "name": "associatednetworkname",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "virtual machine id the ip address is assigned to",
          "name": "virtualmachineid",
          "type": "string"
        },
        {
          "description": "the project id of the ipaddress",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the ID of the zone the public IP address belongs to",
          "name": "zoneid",
          "type": "string"
        },
        {},
        {
          "description": "the physical network this belongs to",
          "name": "physicalnetworkid",
          "type": "string"
        },
        {
          "description": "the name of the Network where ip belongs to",
          "name": "networkname",
          "type": "string"
        },
        {
          "description": "date the public IP address was acquired",
          "name": "allocated",
          "type": "date"
        },
        {
          "description": "public IP address id",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the project name of the address",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the ID of the Network associated with the IP address",
          "name": "associatednetworkid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the domain the public IP address is associated with",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "virtual machine (dnat) ip address (not null only for static nat Ip)",
          "name": "vmipaddress",
          "type": "string"
        },
        {
          "description": "VPC name the ip belongs to",
          "name": "vpcname",
          "type": "string"
        },
        {
          "description": "true if this ip is for static nat, false otherwise",
          "name": "isstaticnat",
          "type": "boolean"
        },
        {
          "description": "the ID of the Network where ip belongs to",
          "name": "networkid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the virtual network for the IP address",
          "name": "forvirtualnetwork",
          "type": "boolean"
        },
        {
          "description": "whether the ip address has Firewall/PortForwarding/LoadBalancing rules defined",
          "name": "hasrules",
          "type": "boolean"
        },
        {
          "description": "public IP address",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the VLAN associated with the IP address",
          "name": "vlanname",
          "type": "string"
        },
        {
          "description": "is public IP portable across the zones",
          "name": "isportable",
          "type": "boolean"
        },
        {
          "description": "the name of the zone the public IP address belongs to",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the account the public IP address is associated with",
          "name": "account",
          "type": "string"
        },
        {
          "description": "virtual machine display name the ip address is assigned to (not null only for static nat Ip)",
          "name": "virtualmachinedisplayname",
          "type": "string"
        },
        {
          "description": "is public ip for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the list of resource tags associated with ip address",
          "name": "tags",
          "response": [
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {},
        {
          "description": "the ID of the VLAN associated with the IP address. This parameter is visible to ROOT admins only",
          "name": "vlanid",
          "type": "string"
        },
        {
          "description": "virtual machine type the ip address is assigned to",
          "name": "virtualmachinetype",
          "type": "string"
        },
        {
          "description": "virtual machine name the ip address is assigned to",
          "name": "virtualmachinename",
          "type": "string"
        },
        {
          "description": "VPC id the ip belongs to",
          "name": "vpcid",
          "type": "string"
        },
        {
          "description": "purpose of the IP address. In Acton this value is not null for Ips with isSystem=true, and can have either StaticNat or LB value",
          "name": "purpose",
          "type": "string"
        },
        {
          "description": "the domain ID the public IP address is associated with",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "true if the IP address is a source nat address, false otherwise",
          "name": "issourcenat",
          "type": "boolean"
        },
        {
          "description": "State of the ip address. Can be: Allocating, Allocated, Releasing, Reserved and Free",
          "name": "state",
          "type": "string"
        }
      ],
      "since": "4.17"
    },
    {
      "description": "Restore a VM to original template/ISO or new template/ISO",
      "isasync": true,
      "name": "restoreVirtualMachine",
      "params": [
        {
          "description": "Virtual Machine ID",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "an optional template Id to restore vm from the new template. This can be an ISO id in case of restore vm deployed using ISO",
          "length": 255,
          "name": "templateid",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
      "response": [
        {
          "description": "the name of the host for the virtual machine",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Type",
          "name": "boottype",
          "type": "string"
        },
        {
          "description": "the ID of the backup offering of the virtual machine",
          "name": "backupofferingid",
          "type": "string"
        },
        {
          "description": "the name of userdata used for the VM",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the user's name who deployed the virtual machine",
          "name": "username",
          "type": "string"
        },
        {
          "description": "the control state of the host for the virtual machine",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "an optional field whether to the display the vm to the end user or not.",
          "name": "displayvm",
          "type": "boolean"
        },
        {
          "description": "the date when this virtual machine was updated last time",
          "name": "lastupdated",
          "type": "date"
        },
        {
          "description": "list of security groups associated with the virtual machine",
          "name": "securitygroup",
          "response": [
            {
              "description": "the domain name of the security group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the description of the security group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the account owning the security group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the name of the security group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the project id of the group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain ID of the security group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                },
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the number of virtualmachines associated with this securitygroup",
              "name": "virtualmachinecount",
              "type": "integer"
            },
            {
              "description": "the ID of the security group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the list of ingress rules associated with the security group",
              "name": "ingressrule",
              "response": [
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                }
              ],
              "type": "set"
            },
            {
              "description": "the list of egress rules associated with the security group",
              "name": "egressrule",
              "response": [
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the project name of the group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the list of virtualmachine ids associated with this securitygroup",
              "name": "virtualmachineids",
              "type": "set"
            }
          ],
          "type": "set"
        },
        {
          "description": "the target memory in VM (KiB)",
          "name": "memorytargetkbs",
          "type": "long"
        },
        {
          "description": "OS type id of the vm",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "the ID of the virtual machine",
          "name": "id",
          "type": "string"
        },
        {
          "description": "true if the password rest feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the read (IO) of disk on the VM",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "the id of userdata used for the VM",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the vGPU type used by the virtual machine",
          "name": "vgpu",
          "type": "string"
        },
        {},
        {
          "description": "the list of nics associated with vm",
          "name": "nic",
          "response": [
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "Name of AutoScale VM group",
          "name": "autoscalevmgroupname",
          "type": "string"
        },
        {
          "description": "the speed of each vCPU",
          "name": "cpuspeed",
          "type": "integer"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the state of the virtual machine",
          "name": "state",
          "type": "string"
        },
        {},
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicipid",
          "type": "string"
        },
        {},
        {
          "description": "the project name of the vm",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the group name of the virtual machine",
          "name": "group",
          "type": "string"
        },
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "list of affinity groups associated with the virtual machine",
          "name": "affinitygroup",
          "response": [
            {
              "description": "the domain ID of the affinity group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the project ID of the affinity group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "virtual machine IDs associated with this affinity group",
              "name": "virtualmachineIds",
              "type": "list"
            },
            {
              "description": "the project name of the affinity group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the name of the affinity group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the ID of the affinity group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the description of the affinity group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the domain name of the affinity group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the account owning the affinity group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the type of the affinity group",
              "name": "type",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the ID of the availability zone for the virtual machine",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "List of read-only Vm details as comma separated string.",
          "name": "readonlydetails",
          "type": "string"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "Guest vm Boot Mode",
          "name": "bootmode",
          "type": "string"
        },
        {
          "description": "device ID of the root volume",
          "name": "rootdeviceid",
          "type": "long"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the write (IO) of disk on the VM",
          "name": "diskiowrite",
          "type": "long"
        },
        {
          "description": "ssh key-pairs",
          "name": "keypairs",
          "type": "string"
        },
        {
          "description": "NICs of the VNF appliance",
          "name": "vnfnics",
          "type": "list"
        },
        {
          "description": "the user's ID who deployed the virtual machine",
          "name": "userid",
          "type": "string"
        },
        {
          "description": "OS name of the vm",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "true if high-availability is enabled, false otherwise",
          "name": "haenable",
          "type": "boolean"
        },
        {
          "description": "the date when this virtual machine was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "ID of AutoScale VM group",
          "name": "autoscalevmgroupid",
          "type": "string"
        },
        {
          "description": "the ID of the host for the virtual machine",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the outgoing network traffic on the host in KiB",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the internal memory (KiB) that's free in VM or zero if it can not be calculated",
          "name": "memoryintfreekbs",
          "type": "long"
        },
        {
          "description": "State of the Service from LB rule",
          "name": "servicestate",
          "type": "string"
        },
        {
          "description": "the name of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "the incoming network traffic on the VM in KiB",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "the ID of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "VNF details",
          "name": "vnfdetails",
          "type": "map"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the name of the virtual machine",
          "name": "name",
          "type": "string"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "Os type ID of the virtual machine",
          "name": "guestosid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the name of the domain in which the virtual machine exists",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the number of vCPUs this virtual machine is using",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "device type of the root volume",
          "name": "rootdevicetype",
          "type": "string"
        },
        {
          "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
          "name": "displayname",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the memory allocated for the virtual machine",
          "name": "memory",
          "type": "integer"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "Vm details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the ID of the domain in which the virtual machine exists",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the name of the backup offering of the virtual machine",
          "name": "backupofferingname",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the account associated with the virtual machine",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the type of the template for the virtual machine",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "the password (if exists) of the virtual machine",
          "name": "password",
          "type": "string"
        },
        {
          "description": "list of variables and values for the variables declared in userdata",
          "name": "userdatadetails",
          "type": "string"
        },
        {
          "description": "the group ID of the virtual machine",
          "name": "groupid",
          "type": "string"
        },
        {
          "description": "the name of the availability zone for the virtual machine",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the amount of the vm's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the virtual network for the service offering",
          "name": "forvirtualnetwork",
          "type": "boolean"
        },
        {
          "description": "Base64 string containing the user data",
          "name": "userdata",
          "type": "string"
        },
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "the pool type of the virtual machine",
          "name": "pooltype",
          "type": "string"
        },
        {
          "description": "the project id of the vm",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
          "name": "instancename",
          "type": "string"
        },
        {
          "description": "the memory used by the VM in KiB",
          "name": "memorykbs",
          "type": "long"
        }
      ],
      "since": "3.0.0"
    },
    {
      "description": "Delete one or more events.",
      "isasync": false,
      "name": "deleteEvents",
      "params": [
        {
          "description": "the IDs of the events",
          "length": 255,
          "name": "ids",
          "related": "listEvents",
          "required": false,
          "type": "list"
        },
        {
          "description": "end date range to delete events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
          "length": 255,
          "name": "enddate",
          "required": false,
          "type": "date"
        },
        {
          "description": "start date range to delete events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
          "length": 255,
          "name": "startdate",
          "required": false,
          "type": "date"
        },
        {
          "description": "delete by event type",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {}
      ]
    },
    {
      "description": " delete a nicira nvp device",
      "isasync": true,
      "name": "deleteNiciraNvpDevice",
      "params": [
        {
          "description": "Nicira device ID",
          "length": 255,
          "name": "nvpdeviceid",
          "related": "addNiciraNvpDevice,listNiciraNvpDevices",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "List ucs blades",
      "isasync": false,
      "name": "listUcsBlades",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "ucs manager id",
          "length": 255,
          "name": "ucsmanagerid",
          "related": "listUcsManagers,addUcsManager",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "associateUcsProfileToBlade",
      "response": [
        {
          "description": "ucs blade dn",
          "name": "bladedn",
          "type": "string"
        },
        {
          "description": "cloudstack host id this blade associates to",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "ucs manager id",
          "name": "ucsmanagerid",
          "type": "string"
        },
        {
          "description": "associated ucs profile dn",
          "name": "profiledn",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "ucs blade id",
          "name": "id",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Notify provision has been done on a host. This api is for baremetal virtual router service, not for end user",
      "isasync": true,
      "name": "notifyBaremetalProvisionDone",
      "params": [
        {
          "description": "mac of the nic used for provision",
          "length": 255,
          "name": "mac",
          "required": true,
          "type": "object"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        }
      ]
    },
    {
      "description": "Get Volume Snapshot Details",
      "isasync": false,
      "name": "getVolumeSnapshotDetails",
      "params": [
        {
          "description": "CloudStack Snapshot UUID",
          "length": 255,
          "name": "snapshotid",
          "required": true,
          "type": "string"
        }
      ],
      "related": "getVolumeiScsiName",
      "response": [
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Volume iSCSI Name",
          "name": "volumeiScsiName",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Deletes an ISO file.",
      "isasync": true,
      "name": "deleteIso",
      "params": [
        {
          "description": "the ID of the ISO file",
          "length": 255,
          "name": "id",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the ID of the zone of the ISO file. If not specified, the ISO will be deleted from all the zones",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        }
      ]
    },
    {
      "description": "Updates a host.",
      "isasync": false,
      "name": "updateHost",
      "params": [
        {
          "description": "Add an annotation to this host",
          "length": 255,
          "name": "annotation",
          "required": false,
          "since": "4.11",
          "type": "string"
        },
        {
          "description": "list of tags to be added to the host",
          "length": 255,
          "name": "hosttags",
          "required": false,
          "type": "list"
        },
        {
          "description": "Change resource state of host, valid values are [Enable, Disable]. Operation may failed if host in states not allowing Enable/Disable",
          "length": 255,
          "name": "allocationstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "the new uri for the secondary storage: nfs://host/path",
          "length": 255,
          "name": "url",
          "required": false,
          "type": "string"
        },
        {
          "description": "Whether the informed tag is a JS interpretable rule or not.",
          "length": 255,
          "name": "istagarule",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the id of Os category to update the host with",
          "length": 255,
          "name": "oscategoryid",
          "related": "listOsCategories",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Change the name of host",
          "length": 255,
          "name": "name",
          "required": false,
          "since": "4.15",
          "type": "string"
        },
        {
          "description": "the ID of the host to update",
          "length": 255,
          "name": "id",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,updateHost,addBaremetalHost",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,addBaremetalHost",
      "response": [
        {
          "description": "the name of the host",
          "name": "name",
          "type": "string"
        },
        {
          "description": "events available for the host",
          "name": "events",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the outgoing network traffic on the host",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the memory total of the host, this parameter is deprecated use memorywithoverprovisioning",
          "name": "memorytotal",
          "type": "long"
        },
        {
          "description": "true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise",
          "name": "suitableformigration",
          "type": "boolean"
        },
        {
          "description": "the amount of the host's CPU currently allocated in MHz",
          "name": "cpuallocatedvalue",
          "type": "long"
        },
        {
          "description": "the date and time the host was last pinged",
          "name": "lastpinged",
          "type": "date"
        },
        {
          "description": "the total disk size of the host",
          "name": "disksizetotal",
          "type": "long"
        },
        {
          "description": "the cpu average load on the host",
          "name": "cpuloadaverage",
          "type": "double"
        },
        {
          "description": "the admin that annotated this host",
          "name": "username",
          "type": "string"
        },
        {
          "description": "the state of the host",
          "name": "state",
          "type": "status"
        },
        {
          "description": "the OS category name of the host",
          "name": "oscategoryname",
          "type": "string"
        },
        {
          "description": "the incoming network traffic on the host",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "the resource state of the host",
          "name": "resourcestate",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory currently used",
          "name": "memoryused",
          "type": "long"
        },
        {
          "description": "the host's currently allocated disk size",
          "name": "disksizeallocated",
          "type": "long"
        },
        {
          "description": "the host out-of-band management information",
          "name": "outofbandmanagement",
          "type": "outofbandmanagementresponse"
        },
        {
          "description": "true if the host is Ha host (dedicated to vms started by HA process; false otherwise",
          "name": "hahost",
          "type": "boolean"
        },
        {
          "description": "the host HA information information",
          "name": "hostha",
          "type": "hostharesponse"
        },
        {
          "description": "the CPU speed of the host",
          "name": "cpuspeed",
          "type": "long"
        },
        {
          "description": "GPU cards present in the host",
          "name": "gpugroup",
          "response": [
            {
              "description": "the list of enabled vGPUs",
              "name": "vgpu",
              "response": [
                {
                  "description": "Maximum Y resolution per display",
                  "name": "maxresolutiony",
                  "type": "long"
                },
                {
                  "description": "Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type",
                  "name": "remainingcapacity",
                  "type": "long"
                },
                {
                  "description": "Video RAM for this vGPU type",
                  "name": "videoram",
                  "type": "long"
                },
                {
                  "description": "Maximum displays per user",
                  "name": "maxheads",
                  "type": "long"
                },
                {
                  "description": "Model Name of vGPU",
                  "name": "vgputype",
                  "type": "string"
                },
                {
                  "description": "Maximum X resolution per display",
                  "name": "maxresolutionx",
                  "type": "long"
                },
                {
                  "description": "Maximum no. of vgpu per gpu card (pgpu)",
                  "name": "maxvgpuperpgpu",
                  "type": "long"
                },
                {
                  "description": "Maximum vgpu can be created with this vgpu type on the given gpu group",
                  "name": "maxcapacity",
                  "type": "long"
                }
              ],
              "type": "list"
            },
            {
              "description": "GPU cards present in the host",
              "name": "gpugroupname",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "Host details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "comma-separated list of tags for the host",
          "name": "hosttags",
          "type": "string"
        },
        {
          "description": "the Pod ID of the host",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the date and time the host was removed",
          "name": "removed",
          "type": "date"
        },
        {
          "description": "the Zone name of the host",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "capabilities of the host",
          "name": "capabilities",
          "type": "string"
        },
        {
          "description": "the host version",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the number of CPU sockets on the host",
          "name": "cpusockets",
          "type": "integer"
        },
        {
          "description": "the last annotation set on this host by an admin",
          "name": "annotation",
          "type": "string"
        },
        {
          "description": "the hypervisor version",
          "name": "hypervisorversion",
          "type": "string"
        },
        {
          "description": "the host hypervisor",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the last time this host was annotated",
          "name": "lastannotated",
          "type": "date"
        },
        {
          "description": "the cluster type of the cluster that host belongs to",
          "name": "clustertype",
          "type": "string"
        },
        {
          "description": "the Zone ID of the host",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the cluster ID of the host",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU currently allocated in percentage",
          "name": "cpuallocatedpercentage",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory currently allocated",
          "name": "memoryallocated",
          "type": "long"
        },
        {
          "description": "true if the host is disconnected. False otherwise.",
          "name": "disconnected",
          "type": "date"
        },
        {
          "description": "the CPU number of the host",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "true if the host has capability to support UEFI boot",
          "name": "ueficapability",
          "type": "boolean"
        },
        {},
        {
          "description": "true if local storage is active, false otherwise",
          "name": "islocalstorageactive",
          "type": "boolean"
        },
        {
          "description": "the date and time the host was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise",
          "name": "hasenoughcapacity",
          "type": "boolean"
        },
        {},
        {
          "description": "the cluster name of the host",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "true if the host supports encryption",
          "name": "encryptionsupported",
          "type": "boolean"
        },
        {
          "description": "the OS category ID of the host",
          "name": "oscategoryid",
          "type": "string"
        },
        {
          "description": "the Pod name of the host",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the management server ID of the host",
          "name": "managementserverid",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU after applying the cpu.overprovisioning.factor",
          "name": "cpuwithoverprovisioning",
          "type": "string"
        },
        {
          "description": "Whether the informed tag is a JS interpretable rule or not.",
          "name": "istagarule",
          "type": "boolean"
        },
        {
          "description": "the amount of the host's memory currently allocated in percentage",
          "name": "memoryallocatedpercentage",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory currently allocated in bytes",
          "name": "memoryallocatedbytes",
          "type": "long"
        },
        {
          "description": "the IP address of the host",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU currently allocated after applying the cpu.overprovisioning.factor",
          "name": "cpuallocatedwithoverprovisioning",
          "type": "string"
        },
        {
          "description": "the ID of the host",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU currently allocated",
          "name": "cpuallocated",
          "type": "string"
        },
        {
          "description": "the amount of the host's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the amount of the host's memory after applying the mem.overprovisioning.factor",
          "name": "memorywithoverprovisioning",
          "type": "string"
        },
        {
          "description": "the host type",
          "name": "type",
          "type": "type"
        }
      ]
    },
    {
      "description": "Creates a egress firewall rule for a given network ",
      "isasync": true,
      "name": "createEgressFirewallRule",
      "params": [
        {
          "description": "the cidr list to forward traffic to. Multiple entries must be separated by a single comma character (,).",
          "length": 255,
          "name": "destcidrlist",
          "required": false,
          "type": "list"
        },
        {
          "description": "the cidr list to forward traffic from. Multiple entries must be separated by a single comma character (,).",
          "length": 255,
          "name": "cidrlist",
          "required": false,
          "type": "list"
        },
        {
          "description": "an optional field, whether to the display the rule to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "the protocol for the firewall rule. Valid values are TCP/UDP/ICMP.",
          "length": 255,
          "name": "protocol",
          "required": true,
          "type": "string"
        },
        {
          "description": "error code for this icmp message",
          "length": 255,
          "name": "icmpcode",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the starting port of firewall rule",
          "length": 255,
          "name": "startport",
          "required": false,
          "type": "integer"
        },
        {
          "description": "type of firewallrule: system/user",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ending port of firewall rule",
          "length": 255,
          "name": "endport",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the network id of the port forwarding rule",
          "length": 255,
          "name": "networkid",
          "related": "createNetwork,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "type of the icmp message being sent",
          "length": 255,
          "name": "icmptype",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "createFirewallRule,listEgressFirewallRules,listFirewallRules,updateEgressFirewallRule",
      "response": [
        {
          "description": "the starting port of firewall rule's port range",
          "name": "startport",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "error code for this icmp message",
          "name": "icmpcode",
          "type": "integer"
        },
        {
          "description": "is rule for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the public ip address for the firewall rule",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the protocol of the firewall rule",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "the cidr list to forward traffic from. Multiple entries are separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {
          "description": "the traffic type for the firewall rule",
          "name": "traffictype",
          "type": "string"
        },
        {
          "description": "the ending port of firewall rule's port range",
          "name": "endport",
          "type": "integer"
        },
        {
          "description": "the public ip address id for the firewall rule",
          "name": "ipaddressid",
          "type": "string"
        },
        {
          "description": "type of the icmp message being sent",
          "name": "icmptype",
          "type": "integer"
        },
        {
          "description": "the cidr list to forward traffic to. Multiple entries are separated by a single comma character (,).",
          "name": "destcidrlist",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated with the rule",
          "name": "tags",
          "response": [
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {},
        {
          "description": "the ID of the firewall rule",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the network id of the firewall rule",
          "name": "networkid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Lists VPC offerings",
      "isasync": false,
      "name": "listVPCOfferings",
      "params": [
        {
          "description": "true if need to list only default VPC offerings. Default value is false",
          "length": 255,
          "name": "isdefault",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list VPC offerings supporting certain services",
          "length": 255,
          "name": "supportedservices",
          "required": false,
          "type": "list"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "id of zone VPC offering is associated with",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "since": "4.13",
          "type": "uuid"
        },
        {
          "description": "list VPC offerings by name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "list VPC offerings by id",
          "length": 255,
          "name": "id",
          "related": "updateVPCOffering,listVPCOfferings",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list VPC offerings by state",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list VPC offerings by display text",
          "length": 255,
          "name": "displaytext",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list VPC offerings available for VPC creation in specific domain",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "since": "4.18",
          "type": "uuid"
        }
      ],
      "related": "updateVPCOffering",
      "response": [
        {},
        {
          "description": "the domain ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "true if vpc offering is default, false otherwise",
          "name": "isdefault",
          "type": "boolean"
        },
        {
          "description": "the name of the vpc offering",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the zone ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the date this vpc offering was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "an alternate display text of the vpc offering.",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the list of supported services",
          "name": "service",
          "response": [
            {
              "description": "the service name",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the list of capabilities",
              "name": "capability",
              "response": [
                {
                  "description": "can this service capability value can be choosable while creatine network offerings",
                  "name": "canchooseservicecapability",
                  "type": "boolean"
                },
                {
                  "description": "the capability name",
                  "name": "name",
                  "type": "string"
                },
                {
                  "description": "the capability value",
                  "name": "value",
                  "type": "string"
                }
              ],
              "type": "list"
            },
            {
              "description": "the service provider name",
              "name": "provider",
              "response": [
                {
                  "description": "uuid of the network provider",
                  "name": "id",
                  "type": "string"
                },
                {
                  "description": "the provider name",
                  "name": "name",
                  "type": "string"
                },
                {
                  "description": "true if individual services can be enabled/disabled",
                  "name": "canenableindividualservice",
                  "type": "boolean"
                },
                {
                  "description": "state of the network provider",
                  "name": "state",
                  "type": "string"
                },
                {
                  "description": "the physical network this belongs to",
                  "name": "physicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "the destination physical network",
                  "name": "destinationphysicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "services for this provider",
                  "name": "servicelist",
                  "type": "list"
                }
              ],
              "type": "list"
            }
          ],
          "type": "list"
        },
        {
          "description": "the zone name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zone",
          "type": "string"
        },
        {},
        {
          "description": "the id of the vpc offering",
          "name": "id",
          "type": "string"
        },
        {
          "description": " indicated if the offering can support region level vpc",
          "name": "supportsregionLevelvpc",
          "type": "boolean"
        },
        {
          "description": "the domain name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domain",
          "type": "string"
        },
        {
          "description": " indicates if the vpc offering supports distributed router for one-hop forwarding",
          "name": "distributedvpcrouter",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "state of the vpc offering. Can be Disabled/Enabled",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the internet protocol of the vpc offering",
          "name": "internetprotocol",
          "type": "string"
        }
      ]
    },
    {
      "description": "Get the SF volume size including Hypervisor Snapshot Reserve",
      "isasync": false,
      "name": "getSolidFireVolumeSize",
      "params": [
        {
          "description": "Volume UUID",
          "length": 255,
          "name": "volumeid",
          "required": true,
          "type": "string"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "SolidFire Volume Size Including Hypervisor Snapshot Reserve",
          "name": "solidFireVolumeSize",
          "type": "long"
        },
        {},
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Uploads a data disk.",
      "isasync": true,
      "name": "uploadVolume",
      "params": [
        {
          "description": "Image store uuid",
          "length": 255,
          "name": "imagestoreuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the zone the volume is to be hosted on",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the checksum value of this volume. The parameter containing the checksum will be considered a MD5sum if it is not prefixed\n and just a plain ascii/utf8 representation of a hexadecimal string. If it is required to\n use another algorithm the hexadecimal string is to be prefixed with a string of the form,\n \"{<algorithm>}\", not including the double quotes. In this <algorithm> is the exact string\n representing the java supported algorithm, i.e. MD5 or SHA-256. Note that java does not\n contain an algorithm called SHA256 or one called sha-256, only SHA-256.",
          "length": 255,
          "name": "checksum",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional domainId. If the account parameter is used, domainId must also be used. If account is NOT provided then volume will be assigned to the caller account and domain.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Upload volume for the project",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "an optional accountName. Must be used with domainId.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the disk offering. This must be a custom sized offering since during uploadVolume volume size is unknown.",
          "length": 255,
          "name": "diskofferingid",
          "related": "createDiskOffering,updateDiskOffering,listDiskOfferings",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the name of the volume",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "the URL of where the volume is hosted. Possible URL include http:// and https://",
          "length": 2048,
          "name": "url",
          "required": true,
          "type": "string"
        },
        {
          "description": "the format for the volume. Possible values include QCOW2, OVA, and VHD.",
          "length": 255,
          "name": "format",
          "required": true,
          "type": "string"
        }
      ],
      "related": "attachVolume,createVolume,updateVolume,detachVolume,listVolumes,migrateVolume,resizeVolume,destroyVolume,recoverVolume,changeOfferingForVolume,attachVolume,createVolume,detachVolume,migrateVolume,resizeVolume,updateVolume,uploadVolume,listVolumes,destroyVolume,recoverVolume,assignVolume",
      "response": [
        {
          "description": "need quiesce vm or not when taking snapshot",
          "name": "quiescevm",
          "type": "boolean"
        },
        {
          "description": "the write (IO) of disk on the vm",
          "name": "diskiowrite",
          "type": "long"
        },
        {
          "description": "name of the availability zone",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the domain associated with the disk volume",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "type of the virtual machine",
          "name": "vmtype",
          "type": "string"
        },
        {
          "description": "max iops of the disk volume",
          "name": "maxiops",
          "type": "long"
        },
        {
          "description": "the status of the volume",
          "name": "status",
          "type": "string"
        },
        {
          "description": "the path of the volume",
          "name": "path",
          "type": "string"
        },
        {
          "description": "ID of the availability zone",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "cluster name where the volume is allocated",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "display name of the virtual machine",
          "name": "vmdisplayname",
          "type": "string"
        },
        {
          "description": "id of the primary storage hosting the disk volume; returned to admin user only",
          "name": "storageid",
          "type": "string"
        },
        {
          "description": "the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.",
          "name": "deviceid",
          "type": "long"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "state of the virtual machine",
          "name": "vmstate",
          "type": "string"
        },
        {
          "description": "id of the virtual machine",
          "name": "virtualmachineid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "an optional field whether to the display the volume to the end user or not.",
          "name": "displayvolume",
          "type": "boolean"
        },
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "true if the volume is extractable, false otherwise",
          "name": "isextractable",
          "type": "boolean"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the domain associated with the disk volume",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the date the disk volume was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "pod name of the volume",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the project id of the vpn",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "name of the disk offering",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "name of the virtual machine",
          "name": "vmname",
          "type": "string"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "ID of the disk volume",
          "name": "id",
          "type": "string"
        },
        {
          "description": "shared or local storage",
          "name": "storagetype",
          "type": "string"
        },
        {
          "description": "the project name of the vpn",
          "name": "project",
          "type": "string"
        },
        {
          "description": "IO requests write rate of the disk volume per the disk offering",
          "name": "diskIopsWriteRate",
          "type": "long"
        },
        {
          "description": "ID of the snapshot from which this volume was created",
          "name": "snapshotid",
          "type": "string"
        },
        {
          "description": "volume uuid that is given by virtualisation provider (only for VMware)",
          "name": "externaluuid",
          "type": "string"
        },
        {
          "description": "size of the disk volume",
          "name": "size",
          "type": "long"
        },
        {
          "description": "the account associated with the disk volume",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the bytes actually consumed on disk",
          "name": "virtualsize",
          "type": "long"
        },
        {
          "description": "name of the disk volume",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the bytes allocated",
          "name": "physicalsize",
          "type": "long"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "the read (IO) of disk on the vm",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "the display text of the disk offering",
          "name": "diskofferingdisplaytext",
          "type": "string"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "IO requests read rate of the disk volume per the disk offering",
          "name": "diskIopsReadRate",
          "type": "long"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the disk utilization",
          "name": "utilization",
          "type": "string"
        },
        {
          "description": "name of the service offering for root disk",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "name of the primary storage hosting the disk volume",
          "name": "storage",
          "type": "string"
        },
        {
          "description": "min iops of the disk volume",
          "name": "miniops",
          "type": "long"
        },
        {
          "description": "bytes read rate of the disk volume",
          "name": "diskBytesReadRate",
          "type": "long"
        },
        {
          "description": "bytes write rate of the disk volume",
          "name": "diskBytesWriteRate",
          "type": "long"
        },
        {
          "description": "the display text of the service offering for root disk",
          "name": "serviceofferingdisplaytext",
          "type": "string"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "provisioning type used to create volumes.",
          "name": "provisioningtype",
          "type": "string"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "cluster id of the volume",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "pod id of the volume",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "Hypervisor the volume belongs to",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the state of the disk volume",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the boolean state of whether the volume is destroyed or not",
          "name": "destroyed",
          "type": "boolean"
        },
        {
          "description": "type of the disk volume (ROOT or DATADISK)",
          "name": "type",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "ID of the service offering for root disk",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "true if storage snapshot is supported for the volume, false otherwise",
          "name": "supportsstoragesnapshot",
          "type": "boolean"
        },
        {
          "description": "ID of the disk offering",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "the date the volume was attached to a VM instance",
          "name": "attached",
          "type": "date"
        },
        {
          "description": "the chain info of the volume",
          "name": "chaininfo",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Lists security groups",
      "isasync": false,
      "name": "listSecurityGroups",
      "params": [
        {
          "description": "list the security group by the id provided",
          "length": 255,
          "name": "id",
          "related": "createSecurityGroup,listSecurityGroups,updateSecurityGroup",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "lists security groups by name",
          "length": 255,
          "name": "securitygroupname",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "lists security groups by virtual machine id",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createSecurityGroup,updateSecurityGroup",
      "response": [
        {
          "description": "the list of ingress rules associated with the security group",
          "name": "ingressrule",
          "response": [
            {
              "description": "the protocol of the security group rule",
              "name": "protocol",
              "type": "string"
            },
            {
              "description": "the type of the ICMP message response",
              "name": "icmptype",
              "type": "integer"
            },
            {
              "description": "the id of the security group rule",
              "name": "ruleid",
              "type": "string"
            },
            {
              "description": "the ending IP of the security group rule ",
              "name": "endport",
              "type": "integer"
            },
            {
              "description": "the starting IP of the security group rule",
              "name": "startport",
              "type": "integer"
            },
            {
              "description": "account owning the security group rule",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the code for the ICMP message response",
              "name": "icmpcode",
              "type": "integer"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "security group name",
              "name": "securitygroupname",
              "type": "string"
            },
            {
              "description": "the CIDR notation for the base IP address of the security group rule",
              "name": "cidr",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {},
        {
          "description": "the project name of the group",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the name of the security group",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the list of resource tags associated with the rule",
          "name": "tags",
          "response": [
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the description of the security group",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the domain ID of the security group",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the account owning the security group",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the ID of the security group",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the list of egress rules associated with the security group",
          "name": "egressrule",
          "response": [
            {
              "description": "the ending IP of the security group rule ",
              "name": "endport",
              "type": "integer"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                },
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                },
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the id of the security group rule",
              "name": "ruleid",
              "type": "string"
            },
            {
              "description": "the code for the ICMP message response",
              "name": "icmpcode",
              "type": "integer"
            },
            {
              "description": "the protocol of the security group rule",
              "name": "protocol",
              "type": "string"
            },
            {
              "description": "security group name",
              "name": "securitygroupname",
              "type": "string"
            },
            {
              "description": "the CIDR notation for the base IP address of the security group rule",
              "name": "cidr",
              "type": "string"
            },
            {
              "description": "account owning the security group rule",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the starting IP of the security group rule",
              "name": "startport",
              "type": "integer"
            },
            {
              "description": "the type of the ICMP message response",
              "name": "icmptype",
              "type": "integer"
            }
          ],
          "type": "set"
        },
        {
          "description": "the domain name of the security group",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the list of virtualmachine ids associated with this securitygroup",
          "name": "virtualmachineids",
          "type": "set"
        },
        {},
        {
          "description": "the project id of the group",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the number of virtualmachines associated with this securitygroup",
          "name": "virtualmachinecount",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Configures a host's out-of-band management interface",
      "isasync": false,
      "name": "configureOutOfBandManagement",
      "params": [
        {
          "description": "the host management interface IP address",
          "length": 255,
          "name": "address",
          "required": true,
          "type": "string"
        },
        {
          "description": "the host management interface port",
          "length": 255,
          "name": "port",
          "required": true,
          "type": "string"
        },
        {
          "description": "the host management interface user",
          "length": 255,
          "name": "username",
          "required": true,
          "type": "string"
        },
        {
          "description": "the host management interface password",
          "length": 255,
          "name": "password",
          "required": true,
          "type": "string"
        },
        {
          "description": "the host management interface driver, for example: ipmitool",
          "length": 255,
          "name": "driver",
          "required": true,
          "type": "string"
        },
        {
          "description": "the ID of the host",
          "length": 255,
          "name": "hostid",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,addBaremetalHost",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "enableOutOfBandManagementForHost,disableOutOfBandManagementForHost,enableOutOfBandManagementForCluster,disableOutOfBandManagementForCluster,enableOutOfBandManagementForZone,disableOutOfBandManagementForZone,issueOutOfBandManagementPowerAction,changeOutOfBandManagementPassword",
      "response": [
        {
          "description": "the ID of the host",
          "name": "hostid",
          "type": "string"
        },
        {},
        {
          "description": "the out-of-band management interface password",
          "name": "password",
          "type": "string"
        },
        {
          "description": "true if out-of-band management is enabled for the host",
          "name": "enabled",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the out-of-band management driver for the host",
          "name": "driver",
          "type": "string"
        },
        {
          "description": "the out-of-band management interface powerState of the host",
          "name": "powerstate",
          "type": "powerstate"
        },
        {
          "description": "the out-of-band management action (if issued)",
          "name": "action",
          "type": "string"
        },
        {
          "description": "the operation result description",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the out-of-band management interface address",
          "name": "address",
          "type": "string"
        },
        {},
        {
          "description": "the operation result",
          "name": "status",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the out-of-band management interface port",
          "name": "port",
          "type": "string"
        },
        {
          "description": "the out-of-band management interface username",
          "name": "username",
          "type": "string"
        }
      ],
      "since": "4.9.0"
    },
    {
      "description": "List OAuth providers registered",
      "isasync": false,
      "name": "listOauthProvider",
      "params": [
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "Name of the provider",
          "length": 255,
          "name": "provider",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the OAuth provider",
          "length": 255,
          "name": "id",
          "related": "listOauthProvider,verifyOAuthCodeAndGetUser,updateOauthProvider",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "verifyOAuthCodeAndGetUser,updateOauthProvider",
      "response": [
        {
          "description": "Name of the provider",
          "name": "provider",
          "type": "string"
        },
        {
          "description": "Redirect URI registered in the OAuth provider",
          "name": "redirecturi",
          "type": "string"
        },
        {
          "description": "Client ID registered in the OAuth provider",
          "name": "clientid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "ID of the provider",
          "name": "id",
          "type": "string"
        },
        {
          "description": "Whether the OAuth provider is enabled or not",
          "name": "enabled",
          "type": "boolean"
        },
        {
          "description": "Description of the provider registered",
          "name": "description",
          "type": "string"
        },
        {},
        {
          "description": "Name of the provider",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Secret key registered in the OAuth provider",
          "name": "secretkey",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Lists storage tags",
      "isasync": false,
      "name": "listStorageTags",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the name of the storage tag",
          "name": "name",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the storage tag",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the pool ID of the storage tag",
          "name": "poolid",
          "type": "long"
        },
        {}
      ]
    },
    {
      "description": "Delete Service Package",
      "isasync": false,
      "name": "deleteServicePackageOffering",
      "params": [
        {
          "description": "the service offering ID",
          "length": 255,
          "name": "id",
          "related": "registerNetscalerServicePackage,listRegisteredServicePackages",
          "required": true,
          "type": "string"
        }
      ],
      "response": [
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Delete VM Schedule.",
      "isasync": false,
      "name": "deleteVMSchedule",
      "params": [
        {
          "description": "ID of VM schedule",
          "length": 255,
          "name": "id",
          "related": "createVMSchedule,listVMSchedule,updateVMSchedule",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "ID of VM",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "IDs of VM schedule",
          "length": 255,
          "name": "ids",
          "related": "createVMSchedule,listVMSchedule,updateVMSchedule",
          "required": false,
          "type": "list"
        }
      ],
      "response": [
        {},
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "List template visibility and all accounts that have permissions to view this template.",
      "isasync": false,
      "name": "listTemplatePermissions",
      "params": [
        {
          "description": "the template ID",
          "length": 255,
          "name": "id",
          "related": "listIsoPermissions,listTemplatePermissions,listTemplatePermissions,listIsoPermissions",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "listIsoPermissions,listTemplatePermissions,listIsoPermissions",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "true if this template is a public template, false otherwise",
          "name": "ispublic",
          "type": "boolean"
        },
        {
          "description": "the list of projects the template is available for",
          "name": "projectids",
          "type": "list"
        },
        {
          "description": "the ID of the domain to which the template belongs",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the list of accounts the template is available for",
          "name": "account",
          "type": "list"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {},
        {
          "description": "the template ID",
          "name": "id",
          "type": "string"
        }
      ]
    },
    {
      "description": "Lists annotations.",
      "isasync": false,
      "name": "listAnnotations",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the id of the annotation",
          "length": 255,
          "name": "id",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "possible values are \"self\" and \"all\". * self : annotations that have been created by the calling user. * all : all the annotations the calling user can access",
          "length": 255,
          "name": "annotationfilter",
          "required": false,
          "since": "4.16.0",
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the entity type",
          "length": 255,
          "name": "entitytype",
          "required": false,
          "type": "string"
        },
        {
          "description": "optional: the id of the user of the annotation",
          "length": 255,
          "name": "userid",
          "required": false,
          "since": "4.16.0",
          "type": "string"
        },
        {
          "description": "the id of the entity for which to show annotations",
          "length": 255,
          "name": "entityid",
          "required": false,
          "type": "string"
        }
      ],
      "related": "addAnnotation,removeAnnotation,updateAnnotationVisibility",
      "response": [
        {
          "description": "The (uu)id of the user that entered the annotation",
          "name": "userid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the (uu)id of the entity to which this annotation pertains",
          "name": "entityid",
          "type": "string"
        },
        {
          "description": "the type of the annotated entity",
          "name": "entitytype",
          "type": "string"
        },
        {
          "description": "the creation timestamp for this annotation",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the name of the entity to which this annotation pertains",
          "name": "entityname",
          "type": "string"
        },
        {
          "description": "The username of the user that entered the annotation",
          "name": "username",
          "type": "string"
        },
        {},
        {
          "description": "True if the annotation is available for admins only",
          "name": "adminsonly",
          "type": "boolean"
        },
        {
          "description": "the contents of the annotation",
          "name": "annotation",
          "type": "string"
        },
        {
          "description": "the removal timestamp for this annotation",
          "name": "removed",
          "type": "date"
        },
        {},
        {
          "description": "the (uu)id of the annotation",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.11"
    },
    {
      "description": "Destroys a system virtual machine.",
      "isasync": true,
      "name": "destroySystemVm",
      "params": [
        {
          "description": "The ID of the system virtual machine",
          "length": 255,
          "name": "id",
          "related": "destroySystemVm,listSystemVms,migrateSystemVm,startSystemVm,stopSystemVm,changeServiceForSystemVm,scaleSystemVm",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "listSystemVms,migrateSystemVm,startSystemVm,stopSystemVm,changeServiceForSystemVm,scaleSystemVm",
      "response": [
        {
          "description": "the last disconnected date of host",
          "name": "disconnected",
          "type": "date"
        },
        {
          "description": "the Zone ID for the system VM",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the link local IP address for the system vm",
          "name": "linklocalip",
          "type": "string"
        },
        {
          "description": "the hostname for the system VM",
          "name": "hostname",
          "type": "string"
        },
        {},
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the public MAC address for the system VM",
          "name": "publicmacaddress",
          "type": "string"
        },
        {
          "description": "public vlan range",
          "name": "publicvlan",
          "type": "list"
        },
        {
          "description": "the public IP address for the system VM",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the public netmask for the system VM",
          "name": "publicnetmask",
          "type": "string"
        },
        {
          "description": "the name of the system VM",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the private IP address for the system VM",
          "name": "privateip",
          "type": "string"
        },
        {
          "description": "the link local MAC address for the system vm",
          "name": "linklocalmacaddress",
          "type": "string"
        },
        {
          "description": "the state of the system VM",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the private netmask for the system VM",
          "name": "privatenetmask",
          "type": "string"
        },
        {
          "description": "the ID of the system VM",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the gateway for the system VM",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the Pod ID for the system VM",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the system VM type",
          "name": "systemvmtype",
          "type": "string"
        },
        {
          "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the host ID for the system VM",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the network domain for the system VM",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the system virtual machine.",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the template ID for the system VM",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the agent state of the system VM",
          "name": "agentstate",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the Pod name for the system VM",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the template name for the system VM",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the private MAC address for the system VM",
          "name": "privatemacaddress",
          "type": "string"
        },
        {
          "description": "the date and time the system VM was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "guest vlan range",
          "name": "guestvlan",
          "type": "string"
        },
        {
          "description": "the control state of the host for the system VM",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the link local netmask for the system vm",
          "name": "linklocalnetmask",
          "type": "string"
        },
        {
          "description": "the systemvm agent version",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the system virtual machine.",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the Zone name for the system VM",
          "name": "zonename",
          "type": "string"
        },
        {},
        {
          "description": "the second DNS for the system VM",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "the first DNS for the system VM",
          "name": "dns1",
          "type": "string"
        },
        {
          "description": "the number of active console sessions for the console proxy system vm",
          "name": "activeviewersessions",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Adds Swift.",
      "isasync": false,
      "name": "addSwift",
      "params": [
        {
          "description": "the account for swift",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "the URL for swift",
          "length": 255,
          "name": "url",
          "required": true,
          "type": "string"
        },
        {
          "description": "the username for swift",
          "length": 255,
          "name": "username",
          "required": false,
          "type": "string"
        },
        {
          "description": " key for the user for swift",
          "length": 255,
          "name": "key",
          "required": false,
          "type": "string"
        }
      ],
      "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,createSecondaryStagingStore,listSecondaryStagingStores,updateCloudToUseObjectStore",
      "response": [
        {
          "description": "defines if store is read-only",
          "name": "readonly",
          "type": "boolean"
        },
        {
          "description": "the provider name of the image store",
          "name": "providername",
          "type": "string"
        },
        {
          "description": "the host's currently used disk size",
          "name": "disksizeused",
          "type": "long"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the protocol of the image store",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the scope of the image store",
          "name": "scope",
          "type": "scopetype"
        },
        {
          "description": "the total disk size of the host",
          "name": "disksizetotal",
          "type": "long"
        },
        {
          "description": "the ID of the image store",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the url of the image store",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the name of the image store",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the Zone name of the image store",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the Zone ID of the image store",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {}
      ],
      "since": "3.0.0"
    },
    {
      "description": "Archive one or more events.",
      "isasync": false,
      "name": "archiveEvents",
      "params": [
        {
          "description": "end date range to archive events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
          "length": 255,
          "name": "enddate",
          "required": false,
          "type": "date"
        },
        {
          "description": "archive by event type",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        },
        {
          "description": "start date range to archive events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
          "length": 255,
          "name": "startdate",
          "required": false,
          "type": "date"
        },
        {
          "description": "the IDs of the events",
          "length": 255,
          "name": "ids",
          "related": "listEvents",
          "required": false,
          "type": "list"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Deletes a secondary staging store .",
      "isasync": false,
      "name": "deleteSecondaryStagingStore",
      "params": [
        {
          "description": "the staging store ID",
          "length": 255,
          "name": "id",
          "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,createSecondaryStagingStore,listSecondaryStagingStores,updateCloudToUseObjectStore",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.2.0"
    },
    {
      "description": "List registered userdatas",
      "isasync": false,
      "name": "listUserData",
      "params": [
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Userdata name to look for",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the Userdata",
          "length": 255,
          "name": "id",
          "related": "listUserData",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "ID of the ssh keypair",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the owner of the userdata",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "list of parameters which contains the list of keys or string parameters that are needed to be passed for any variables declared in userdata",
          "name": "params",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "Name of the userdata",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the owner id of the userdata",
          "name": "accountid",
          "type": "string"
        },
        {
          "description": "base64 encoded userdata content",
          "name": "userdata",
          "type": "string"
        },
        {
          "description": "the domain id of the userdata owner",
          "name": "domainid",
          "type": "string"
        },
        {},
        {
          "description": "the domain name of the userdata owner",
          "name": "domain",
          "type": "string"
        }
      ],
      "since": "4.18"
    },
    {
      "description": "Updates an internal load balancer",
      "isasync": true,
      "name": "updateLoadBalancer",
      "params": [
        {
          "description": "the ID of the load balancer",
          "length": 255,
          "name": "id",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,listIpv6FirewallRules,updateIpv6FirewallRule",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "an optional field, whether to the display the rule to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
          "length": 255,
          "name": "customid",
          "required": false,
          "since": "4.4",
          "type": "string"
        }
      ],
      "related": "createLoadBalancer,listLoadBalancers",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the project id of the Load Balancer",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "is rule for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "Load Balancer network id",
          "name": "networkid",
          "type": "string"
        },
        {
          "description": "the description of the Load Balancer",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the list of rules associated with the Load Balancer",
          "name": "loadbalancerrule",
          "response": [
            {
              "description": "the state of the load balancer rule",
              "name": "state",
              "type": "string"
            },
            {
              "description": "instance port of the load balancer rule",
              "name": "instanceport",
              "type": "integer"
            },
            {
              "description": "source port of the load balancer rule",
              "name": "sourceport",
              "type": "integer"
            }
          ],
          "type": "list"
        },
        {
          "description": "the project name of the Load Balancer",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the domain ID of the Load Balancer",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the domain of the Load Balancer",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "Load Balancer source ip",
          "name": "sourceipaddress",
          "type": "string"
        },
        {
          "description": "Load Balancer source ip network id",
          "name": "sourceipaddressnetworkid",
          "type": "string"
        },
        {
          "description": "the name of the Load Balancer",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated with the Load Balancer",
          "name": "tags",
          "response": [
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the list of instances associated with the Load Balancer",
          "name": "loadbalancerinstance",
          "response": [
            {
              "description": "the state of the instance",
              "name": "state",
              "type": "string"
            },
            {
              "description": "the instance ID",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the name of the instance",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the ip address of the instance",
              "name": "ipaddress",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the Load Balancer ID",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the load balancer algorithm (source, roundrobin, leastconn)",
          "name": "algorithm",
          "type": "string"
        },
        {
          "description": "the account of the Load Balancer",
          "name": "account",
          "type": "string"
        }
      ],
      "since": "4.4.0"
    },
    {
      "description": "Scale the service offering for a system vm (console proxy or secondary storage). The system vm must be in a \"Stopped\" state for this command to take effect.",
      "isasync": true,
      "name": "scaleSystemVm",
      "params": [
        {
          "description": "The ID of the system vm",
          "length": 255,
          "name": "id",
          "related": "listSystemVms,migrateSystemVm,startSystemVm,stopSystemVm,changeServiceForSystemVm,scaleSystemVm",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "name value pairs of custom parameters for cpuspeed, memory and cpunumber. example details[i].name=value",
          "length": 255,
          "name": "details",
          "required": false,
          "type": "map"
        },
        {
          "description": "the service offering ID to apply to the system vm",
          "length": 255,
          "name": "serviceofferingid",
          "related": "createServiceOffering,updateServiceOffering,listServiceOfferings",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "listSystemVms,migrateSystemVm,startSystemVm,stopSystemVm,changeServiceForSystemVm",
      "response": [
        {
          "description": "the template name for the system VM",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the systemvm agent version",
          "name": "version",
          "type": "string"
        },
        {},
        {
          "description": "the control state of the host for the system VM",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the public netmask for the system VM",
          "name": "publicnetmask",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the private netmask for the system VM",
          "name": "privatenetmask",
          "type": "string"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the link local netmask for the system vm",
          "name": "linklocalnetmask",
          "type": "string"
        },
        {
          "description": "the number of active console sessions for the console proxy system vm",
          "name": "activeviewersessions",
          "type": "integer"
        },
        {
          "description": "the private MAC address for the system VM",
          "name": "privatemacaddress",
          "type": "string"
        },
        {
          "description": "the link local IP address for the system vm",
          "name": "linklocalip",
          "type": "string"
        },
        {
          "description": "the link local MAC address for the system vm",
          "name": "linklocalmacaddress",
          "type": "string"
        },
        {
          "description": "the gateway for the system VM",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the public IP address for the system VM",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the system VM type",
          "name": "systemvmtype",
          "type": "string"
        },
        {
          "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the Pod ID for the system VM",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the date and time the system VM was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the name of the service offering of the system virtual machine.",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the Pod name for the system VM",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the template ID for the system VM",
          "name": "templateid",
          "type": "string"
        },
        {},
        {
          "description": "the Zone name for the system VM",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the public MAC address for the system VM",
          "name": "publicmacaddress",
          "type": "string"
        },
        {
          "description": "the name of the system VM",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the network domain for the system VM",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the first DNS for the system VM",
          "name": "dns1",
          "type": "string"
        },
        {
          "description": "the hostname for the system VM",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the Zone ID for the system VM",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the system VM",
          "name": "id",
          "type": "string"
        },
        {
          "description": "guest vlan range",
          "name": "guestvlan",
          "type": "string"
        },
        {
          "description": "the private IP address for the system VM",
          "name": "privateip",
          "type": "string"
        },
        {
          "description": "the host ID for the system VM",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "public vlan range",
          "name": "publicvlan",
          "type": "list"
        },
        {
          "description": "the last disconnected date of host",
          "name": "disconnected",
          "type": "date"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the state of the system VM",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the system virtual machine.",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the agent state of the system VM",
          "name": "agentstate",
          "type": "string"
        },
        {
          "description": "the second DNS for the system VM",
          "name": "dns2",
          "type": "string"
        }
      ]
    },
    {
      "description": "Lists snapshot policies.",
      "isasync": false,
      "name": "listSnapshotPolicies",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the snapshot policy",
          "length": 255,
          "name": "id",
          "related": "createSnapshotPolicy,updateSnapshotPolicy,listSnapshotPolicies",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the disk volume",
          "length": 255,
          "name": "volumeid",
          "related": "attachVolume,createVolume,updateVolume,detachVolume,listVolumes,migrateVolume,resizeVolume,destroyVolume,recoverVolume,changeOfferingForVolume,attachVolume,createVolume,detachVolume,migrateVolume,resizeVolume,updateVolume,uploadVolume,listVolumes,destroyVolume,recoverVolume,assignVolume",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createSnapshotPolicy,updateSnapshotPolicy",
      "response": [
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "maximum number of snapshots retained",
          "name": "maxsnaps",
          "type": "int"
        },
        {
          "description": "time the snapshot is scheduled to be taken.",
          "name": "schedule",
          "type": "string"
        },
        {
          "description": "The list of zones in which snapshot backup is scheduled",
          "name": "zone",
          "type": "set"
        },
        {
          "description": "the interval type of the snapshot policy",
          "name": "intervaltype",
          "type": "short"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "is this policy for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the time zone of the snapshot policy",
          "name": "timezone",
          "type": "string"
        },
        {
          "description": "the ID of the disk volume",
          "name": "volumeid",
          "type": "string"
        },
        {
          "description": "the ID of the snapshot policy",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            }
          ],
          "type": "set"
        }
      ]
    },
    {
      "description": "Update site to site vpn customer gateway",
      "isasync": true,
      "name": "updateVpnCustomerGateway",
      "params": [
        {
          "description": "IPsec Preshared-Key of the customer gateway. Cannot contain newline or double quotes.",
          "length": 255,
          "name": "ipsecpsk",
          "required": true,
          "type": "string"
        },
        {
          "description": "Lifetime of phase 1 VPN connection to the customer gateway, in seconds",
          "length": 255,
          "name": "ikelifetime",
          "required": false,
          "type": "long"
        },
        {
          "description": "For IKEv2, whether to split multiple right subnet cidrs into multiple connection statements.",
          "length": 255,
          "name": "splitconnections",
          "required": false,
          "since": "4.15.1",
          "type": "boolean"
        },
        {
          "description": "the account associated with the gateway. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "If DPD is enabled for VPN connection",
          "length": 255,
          "name": "dpd",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "Force encapsulation for Nat Traversal",
          "length": 255,
          "name": "forceencap",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "public ip address id of the customer gateway",
          "length": 255,
          "name": "gateway",
          "required": true,
          "type": "string"
        },
        {
          "description": "ESP policy of the customer gateway",
          "length": 255,
          "name": "esppolicy",
          "required": true,
          "type": "string"
        },
        {
          "description": "Which IKE Version to use, one of ike (autoselect), ikev1, or ikev2.Connections marked with 'ike' will use 'ikev2' when initiating, but accept any protocol version when responding. Defaults to ike",
          "length": 255,
          "name": "ikeversion",
          "required": false,
          "since": "4.15.1",
          "type": "string"
        },
        {
          "description": "id of customer gateway",
          "length": 255,
          "name": "id",
          "related": "createVpnCustomerGateway,listVpnCustomerGateways,updateVpnCustomerGateway",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Lifetime of phase 2 VPN connection to the customer gateway, in seconds",
          "length": 255,
          "name": "esplifetime",
          "required": false,
          "type": "long"
        },
        {
          "description": "guest cidr of the customer gateway. Multiple entries must be separated by a single comma character (,).",
          "length": 255,
          "name": "cidrlist",
          "required": true,
          "type": "string"
        },
        {
          "description": "IKE policy of the customer gateway",
          "length": 255,
          "name": "ikepolicy",
          "required": true,
          "type": "string"
        },
        {
          "description": "name of this customer gateway",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "the domain ID associated with the gateway. If used with the account parameter returns the gateway associated with the account for the specified domain.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createVpnCustomerGateway,listVpnCustomerGateways",
      "response": [
        {
          "description": "name of the customer gateway",
          "name": "name",
          "type": "string"
        },
        {
          "description": "public ip address id of the customer gateway",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "Which IKE Version to use, one of ike (autoselect), ikev1, or ikev2. Defaults to ike",
          "name": "ikeversion",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "IPsec policy of customer gateway",
          "name": "esppolicy",
          "type": "string"
        },
        {
          "description": "if Force NAT Encapsulation is enabled for customer gateway",
          "name": "forceencap",
          "type": "boolean"
        },
        {
          "description": "the owner",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the vpn gateway ID",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "Lifetime of IKE SA of customer gateway",
          "name": "ikelifetime",
          "type": "long"
        },
        {
          "description": "guest cidr list of the customer gateway. Multiple entries are separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {
          "description": "the domain name of the owner",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the project id",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "guest ip of the customer gateway",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "IPsec preshared-key of customer gateway",
          "name": "ipsecpsk",
          "type": "string"
        },
        {
          "description": "For IKEv2, whether to split multiple right subnet cidrs into multiple connection statements.",
          "name": "splitconnections",
          "type": "boolean"
        },
        {
          "description": "IKE policy of customer gateway",
          "name": "ikepolicy",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the date and time the host was removed",
          "name": "removed",
          "type": "date"
        },
        {
          "description": "Lifetime of ESP SA of customer gateway",
          "name": "esplifetime",
          "type": "long"
        },
        {
          "description": "the project name",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the domain id of the owner",
          "name": "domainid",
          "type": "string"
        },
        {},
        {
          "description": "if DPD is enabled for customer gateway",
          "name": "dpd",
          "type": "boolean"
        }
      ]
    },
    {
      "description": "Verify the OAuth Code and fetch the corresponding user from provider",
      "isasync": false,
      "name": "verifyOAuthCodeAndGetUser",
      "params": [
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "Code that is provided by OAuth provider (Eg. google, github) after successful login",
          "length": 255,
          "name": "secretcode",
          "required": false,
          "type": "string"
        },
        {
          "description": "Name of the provider",
          "length": 255,
          "name": "provider",
          "required": true,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "updateOauthProvider",
      "response": [
        {
          "description": "ID of the provider",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Redirect URI registered in the OAuth provider",
          "name": "redirecturi",
          "type": "string"
        },
        {
          "description": "Whether the OAuth provider is enabled or not",
          "name": "enabled",
          "type": "boolean"
        },
        {
          "description": "Client ID registered in the OAuth provider",
          "name": "clientid",
          "type": "string"
        },
        {},
        {
          "description": "Name of the provider",
          "name": "provider",
          "type": "string"
        },
        {
          "description": "Description of the provider registered",
          "name": "description",
          "type": "string"
        },
        {
          "description": "Name of the provider",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Secret key registered in the OAuth provider",
          "name": "secretkey",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "apply Tungsten-Fabric tag",
      "isasync": true,
      "name": "applyTungstenFabricTag",
      "params": [
        {
          "description": "the uuid of vms",
          "length": 255,
          "name": "vmuuid",
          "required": false,
          "type": "list"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the uuid of Tungsten-Fabric policy",
          "length": 255,
          "name": "policyuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the uuid of nics",
          "length": 255,
          "name": "nicuuid",
          "required": false,
          "type": "list"
        },
        {
          "description": "the uuid of Tungsten-Fabric application policy set",
          "length": 255,
          "name": "applicationpolicysetuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the uuid of networks",
          "length": 255,
          "name": "networkuuid",
          "required": false,
          "type": "list"
        },
        {
          "description": "the uuid of Tungsten-Fabric tag",
          "length": 255,
          "name": "taguuid",
          "required": true,
          "type": "string"
        }
      ],
      "related": "createTungstenFabricTag,removeTungstenFabricTag",
      "response": [
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "list Tungsten-Fabric vm",
          "name": "vm",
          "type": "list"
        },
        {
          "description": "Tungsten-Fabric tag type uuid",
          "name": "uuid",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric tag name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "list Tungsten-Fabric nic",
          "name": "nic",
          "type": "list"
        },
        {},
        {
          "description": "list Tungsten-Fabric policy",
          "name": "policy",
          "type": "list"
        },
        {
          "description": "list Tungsten-Fabric network",
          "name": "network",
          "type": "list"
        }
      ]
    },
    {
      "description": "Updates object storage pool",
      "isasync": false,
      "name": "updateObjectStoragePool",
      "params": [
        {
          "description": "the name for the object store",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "the url for the object store",
          "length": 255,
          "name": "url",
          "required": false,
          "type": "string"
        },
        {
          "description": "Object Store ID",
          "length": 255,
          "name": "id",
          "related": "addObjectStoragePool,listObjectStoragePools,updateObjectStoragePool",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "addObjectStoragePool,listObjectStoragePools",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the url of the object store",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the object store currently used size",
          "name": "storageused",
          "type": "long"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the object store",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the total size of the object store",
          "name": "storagetotal",
          "type": "long"
        },
        {},
        {
          "description": "the name of the object store",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the provider name of the object store",
          "name": "providername",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "List DRS plans for a clusters",
      "isasync": false,
      "name": "listClusterDrsPlan",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "ID of the drs plan",
          "length": 255,
          "name": "id",
          "related": "listClusterDrsPlan,generateClusterDrsPlan,executeClusterDrsPlan",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "ID of the cluster",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,listClusters,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "generateClusterDrsPlan,executeClusterDrsPlan",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {},
        {
          "description": "Id of the cluster",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "unique ID of the drs plan for cluster",
          "name": "id",
          "type": "string"
        },
        {
          "description": "Start event Id of the DRS Plan",
          "name": "eventid",
          "type": "string"
        },
        {
          "description": "Type of DRS Plan (Automated or Manual))",
          "name": "type",
          "type": "type"
        },
        {
          "description": "Status of DRS Plan",
          "name": "status",
          "type": "status"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "List of migrations",
          "name": "migrations",
          "type": "list"
        },
        {}
      ],
      "since": "4.19.0"
    },
    {
      "description": "This deprecated function used to locks an account. Look for the API DisableAccount instead",
      "isasync": false,
      "name": "lockAccount",
      "params": [
        {
          "description": "Locks the specified account on this domain.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Locks the specified account.",
          "length": 255,
          "name": "account",
          "required": true,
          "type": "string"
        }
      ],
      "related": "createAccount,disableAccount,enableAccount,updateAccount,markDefaultZoneForAccount,listAccounts,listAccounts",
      "response": [
        {
          "description": "the name of the role",
          "name": "rolename",
          "type": "string"
        },
        {},
        {
          "description": "the network domain",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the type of the role (Admin, ResourceAdmin, DomainAdmin, User)",
          "name": "roletype",
          "type": "string"
        },
        {
          "description": "id of the Domain the account belongs to",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the total number of projects the account can own",
          "name": "projectlimit",
          "type": "string"
        },
        {
          "description": "the total number of networks the account can own",
          "name": "networklimit",
          "type": "string"
        },
        {
          "description": "the date when this account was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the total number of vpcs the account can own",
          "name": "vpclimit",
          "type": "string"
        },
        {
          "description": "the id of the account",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the total number of vpcs owned by account",
          "name": "vpctotal",
          "type": "long"
        },
        {
          "description": "the total number of templates which have been created by this account",
          "name": "templatetotal",
          "type": "long"
        },
        {
          "description": "account type (admin, domain-admin, user)",
          "name": "accounttype",
          "type": "integer"
        },
        {
          "description": "name of the Domain the account belongs to",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the total number of snapshots stored by this account",
          "name": "snapshottotal",
          "type": "long"
        },
        {
          "description": "the total number of projects being administrated by this account",
          "name": "projecttotal",
          "type": "long"
        },
        {
          "description": "the total volume available for this account",
          "name": "volumeavailable",
          "type": "string"
        },
        {
          "description": "the total secondary storage space (in GiB) available to be used for this account",
          "name": "secondarystorageavailable",
          "type": "string"
        },
        {
          "description": "the total number of snapshots available for this account",
          "name": "snapshotavailable",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines available for this account to acquire",
          "name": "vmavailable",
          "type": "string"
        },
        {
          "description": "the name of the account",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the total memory (in MB) owned by account",
          "name": "memorytotal",
          "type": "long"
        },
        {
          "description": "the total secondary storage space (in GiB) the account can own",
          "name": "secondarystoragelimit",
          "type": "string"
        },
        {
          "description": "path of the Domain the account belongs to",
          "name": "domainpath",
          "type": "string"
        },
        {
          "description": "the default zone of the account",
          "name": "defaultzoneid",
          "type": "string"
        },
        {
          "description": "the total number of templates available to be created by this account",
          "name": "templateavailable",
          "type": "string"
        },
        {
          "description": "the total number of vpcs available to be created for this account",
          "name": "vpcavailable",
          "type": "string"
        },
        {
          "description": "the total number of cpu cores owned by account",
          "name": "cputotal",
          "type": "long"
        },
        {
          "description": "the total primary storage space (in GiB) the account can own",
          "name": "primarystoragelimit",
          "type": "string"
        },
        {
          "description": "the total primary storage space (in GiB) owned by account",
          "name": "primarystoragetotal",
          "type": "long"
        },
        {
          "description": "the total primary storage space (in GiB) available to be used for this account",
          "name": "primarystorageavailable",
          "type": "string"
        },
        {
          "description": "the state of the account",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the ID of the role",
          "name": "roleid",
          "type": "string"
        },
        {
          "description": "the total number of cpu cores the account can own",
          "name": "cpulimit",
          "type": "string"
        },
        {
          "description": "details for the account",
          "name": "accountdetails",
          "type": "map"
        },
        {
          "description": "the total number of virtual machines deployed by this account",
          "name": "vmtotal",
          "type": "long"
        },
        {
          "description": "the total secondary storage space (in GiB) owned by account",
          "name": "secondarystoragetotal",
          "type": "float"
        },
        {
          "description": "the total number of public ip addresses available for this account to acquire",
          "name": "ipavailable",
          "type": "string"
        },
        {
          "description": "the total number of templates which can be created by this account",
          "name": "templatelimit",
          "type": "string"
        },
        {
          "description": "true if the account requires cleanup",
          "name": "iscleanuprequired",
          "type": "boolean"
        },
        {
          "description": "the total volume which can be used by this account",
          "name": "volumelimit",
          "type": "string"
        },
        {
          "description": "the total number of networks owned by account",
          "name": "networktotal",
          "type": "long"
        },
        {
          "description": "the total number of snapshots which can be stored by this account",
          "name": "snapshotlimit",
          "type": "string"
        },
        {
          "description": "true if account is default, false otherwise",
          "name": "isdefault",
          "type": "boolean"
        },
        {
          "description": "the total number of cpu cores available to be created for this account",
          "name": "cpuavailable",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines that can be deployed by this account",
          "name": "vmlimit",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the total memory (in MB) the account can own",
          "name": "memorylimit",
          "type": "string"
        },
        {
          "description": "the total number of virtual machines running for this account",
          "name": "vmrunning",
          "type": "integer"
        },
        {
          "description": "the total number of networks available to be created for this account",
          "name": "networkavailable",
          "type": "string"
        },
        {
          "description": "the total number of public ip addresses this account can acquire",
          "name": "iplimit",
          "type": "string"
        },
        {
          "description": "the total volume being used by this account",
          "name": "volumetotal",
          "type": "long"
        },
        {
          "description": "the total number of projects available for administration by this account",
          "name": "projectavailable",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "the total number of public ip addresses allocated for this account",
          "name": "iptotal",
          "type": "long"
        },
        {
          "description": "the list of acl groups that account belongs to",
          "name": "groups",
          "type": "list"
        },
        {
          "description": "the total memory (in MB) available to be created for this account",
          "name": "memoryavailable",
          "type": "string"
        },
        {
          "description": "the list of users associated with account",
          "name": "user",
          "response": [
            {
              "description": "true if user is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "the name of the role",
              "name": "rolename",
              "type": "string"
            },
            {
              "description": "the account ID of the user",
              "name": "accountid",
              "type": "string"
            },
            {
              "description": "the date and time the user account was created",
              "name": "created",
              "type": "date"
            },
            {
              "description": "the secret key of the user",
              "name": "secretkey",
              "type": "string"
            },
            {
              "description": "true if user has two factor authentication is mandated",
              "name": "is2famandated",
              "type": "boolean"
            },
            {
              "description": "the type of the role",
              "name": "roletype",
              "type": "string"
            },
            {
              "description": "the domain ID of the user",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "true if user has two factor authentication enabled",
              "name": "is2faenabled",
              "type": "boolean"
            },
            {
              "description": "the user name",
              "name": "username",
              "type": "string"
            },
            {
              "description": "the user state",
              "name": "state",
              "type": "string"
            },
            {
              "description": "the user firstname",
              "name": "firstname",
              "type": "string"
            },
            {
              "description": "the account name of the user",
              "name": "account",
              "type": "string"
            },
            {
              "description": "Base64 string representation of the resource icon",
              "name": "icon",
              "type": "resourceiconresponse"
            },
            {
              "description": "the account type of the user",
              "name": "accounttype",
              "type": "integer"
            },
            {
              "description": "the source type of the user in lowercase, such as native, ldap, saml2",
              "name": "usersource",
              "type": "string"
            },
            {
              "description": "the timezone user was created in",
              "name": "timezone",
              "type": "string"
            },
            {
              "description": "the boolean value representing if the updating target is in caller's child domain",
              "name": "iscallerchilddomain",
              "type": "boolean"
            },
            {
              "description": "the domain name of the user",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the user email address",
              "name": "email",
              "type": "string"
            },
            {
              "description": "the ID of the role",
              "name": "roleid",
              "type": "string"
            },
            {
              "description": "the user lastname",
              "name": "lastname",
              "type": "string"
            },
            {
              "description": "the api key of the user",
              "name": "apikey",
              "type": "string"
            },
            {
              "description": "the user ID",
              "name": "id",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {},
        {
          "description": "the total number of virtual machines stopped for this account",
          "name": "vmstopped",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Stops a router.",
      "isasync": true,
      "name": "stopRouter",
      "params": [
        {
          "description": "the ID of the router",
          "length": 255,
          "name": "id",
          "related": "destroyRouter,listRouters,rebootRouter,startRouter,stopRouter,changeServiceForRouter,stopInternalLoadBalancerVM,startInternalLoadBalancerVM,listInternalLoadBalancerVMs,stopNetScalerVpx",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Force stop the VM (vm is marked as Stopped even when command fails to be send to the backend, otherwise a force poweroff is attempted). To be used if the caller knows the VM is stopped and should be marked as such.",
          "length": 255,
          "name": "forced",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "destroyRouter,listRouters,rebootRouter,startRouter,changeServiceForRouter,stopInternalLoadBalancerVM,startInternalLoadBalancerVM,listInternalLoadBalancerVMs,stopNetScalerVpx",
      "response": [
        {
          "description": "the public IP address for the router",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the hostname for the router",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "VPC the router belongs to",
          "name": "vpcid",
          "type": "string"
        },
        {
          "description": "the project id of the ipaddress",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the name of VPC the router belongs to",
          "name": "vpcname",
          "type": "string"
        },
        {
          "description": "the Pod name for the router",
          "name": "podname",
          "type": "string"
        },
        {},
        {
          "description": "Last executed health check result for the router",
          "name": "healthcheckresults",
          "response": [
            {
              "description": "the date this VPC was created",
              "name": "lastupdated",
              "type": "date"
            },
            {
              "description": "detailed response generated on running health check",
              "name": "details",
              "type": "string"
            },
            {
              "description": "the type of the health check - basic or advanced",
              "name": "checktype",
              "type": "string"
            },
            {
              "description": "result of the health check",
              "name": "success",
              "type": "boolean"
            },
            {
              "description": "the name of the health check on the router",
              "name": "checkname",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "true if any health checks had failed",
          "name": "healthchecksfailed",
          "type": "boolean"
        },
        {
          "description": "the first IPv6 DNS for the router",
          "name": "ip6dns1",
          "type": "string"
        },
        {
          "description": "the ID of the corresponding public network",
          "name": "publicnetworkid",
          "type": "string"
        },
        {
          "description": "the link local MAC address for the router",
          "name": "linklocalmacaddress",
          "type": "string"
        },
        {
          "description": "the ID of the corresponding guest network",
          "name": "guestnetworkid",
          "type": "string"
        },
        {
          "description": "the account associated with the router",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the version of scripts",
          "name": "scriptsversion",
          "type": "string"
        },
        {
          "description": "the project name of the address",
          "name": "project",
          "type": "string"
        },
        {
          "description": "role of the domain router",
          "name": "role",
          "type": "string"
        },
        {
          "description": "the guest MAC address for the router",
          "name": "guestmacaddress",
          "type": "string"
        },
        {
          "description": "the link local netmask for the router",
          "name": "linklocalnetmask",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the host ID for the router",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the first DNS for the router",
          "name": "dns1",
          "type": "string"
        },
        {
          "description": "the link local IP address for the router",
          "name": "linklocalip",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the list of nics associated with the router",
          "name": "nic",
          "response": [
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            }
          ],
          "type": "set"
        },
        {
          "description": "the name of the corresponding guest network",
          "name": "guestnetworkname",
          "type": "string"
        },
        {
          "description": "the template ID for the router",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the state of the router",
          "name": "state",
          "type": "state"
        },
        {
          "description": "the Zone name for the router",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the public MAC address for the router",
          "name": "publicmacaddress",
          "type": "string"
        },
        {
          "description": "the version of template",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the network domain for the router",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the guest netmask for the router",
          "name": "guestnetmask",
          "type": "string"
        },
        {
          "description": "the ID of the corresponding link local network",
          "name": "linklocalnetworkid",
          "type": "string"
        },
        {
          "description": "the control state of the host for the router",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the domain associated with the router",
          "name": "domain",
          "type": "string"
        },
        {},
        {
          "description": "the id of the router",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the state of redundant virtual router",
          "name": "redundantstate",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the name of the router",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the domain ID associated with the router",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the Zone ID for the router",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the Pod ID for the router",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "true if the router template requires upgrader",
          "name": "requiresupgrade",
          "type": "boolean"
        },
        {
          "description": "the gateway for the router",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the second IPv6 DNS for the router",
          "name": "ip6dns2",
          "type": "string"
        },
        {
          "description": "the date and time the router was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the template name for the router",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the version of the code / software in the router",
          "name": "softwareversion",
          "type": "string"
        },
        {
          "description": "the second DNS for the router",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "the public netmask for the router",
          "name": "publicnetmask",
          "type": "string"
        },
        {
          "description": "the guest IP address for the router",
          "name": "guestipaddress",
          "type": "string"
        },
        {
          "description": "if this router is an redundant virtual router",
          "name": "isredundantrouter",
          "type": "boolean"
        }
      ]
    },
    {
      "description": "Lists clusters.",
      "isasync": false,
      "name": "listClusters",
      "params": [
        {
          "description": "lists clusters by cluster type",
          "length": 255,
          "name": "clustertype",
          "required": false,
          "type": "string"
        },
        {
          "description": "lists clusters by the cluster ID",
          "length": 255,
          "name": "id",
          "related": "addCluster,listClusters,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists clusters by Zone ID",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists clusters by the cluster name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "flag to display the capacity of the clusters",
          "length": 255,
          "name": "showcapacities",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "whether this cluster is managed by cloudstack",
          "length": 255,
          "name": "managedstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "lists clusters by hypervisor type",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "lists clusters by Pod ID",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists clusters by allocation state",
          "length": 255,
          "name": "allocationstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "addCluster,updateCluster",
      "response": [
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "Ovm3 VIP to use for pooling and/or clustering",
          "name": "ovm3vip",
          "type": "string"
        },
        {
          "description": "the hypervisor type of the cluster",
          "name": "hypervisortype",
          "type": "string"
        },
        {
          "description": "the capacity of the Cluster",
          "name": "capacity",
          "response": [
            {
              "description": "the Cluster name",
              "name": "clustername",
              "type": "string"
            },
            {
              "description": "the Zone ID",
              "name": "zoneid",
              "type": "string"
            },
            {
              "description": "the Cluster ID",
              "name": "clusterid",
              "type": "string"
            },
            {
              "description": "the capacity name",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the capacity currently in use",
              "name": "capacityused",
              "type": "long"
            },
            {
              "description": "the capacity type",
              "name": "type",
              "type": "short"
            },
            {
              "description": "the percentage of capacity currently in use",
              "name": "percentused",
              "type": "string"
            },
            {
              "description": "the Pod ID",
              "name": "podid",
              "type": "string"
            },
            {
              "description": "the capacity currently in allocated",
              "name": "capacityallocated",
              "type": "long"
            },
            {
              "description": "the total capacity available",
              "name": "capacitytotal",
              "type": "long"
            },
            {
              "description": "the Zone name",
              "name": "zonename",
              "type": "string"
            },
            {
              "description": "the Pod name",
              "name": "podname",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the allocation state of the cluster",
          "name": "allocationstate",
          "type": "string"
        },
        {
          "description": "The cpu overcommit ratio of the cluster",
          "name": "cpuovercommitratio",
          "type": "string"
        },
        {
          "description": "the type of the cluster",
          "name": "clustertype",
          "type": "string"
        },
        {
          "description": "Meta data associated with the zone (key/value pairs)",
          "name": "resourcedetails",
          "type": "map"
        },
        {
          "description": "the cluster name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the Zone ID of the cluster",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the Pod ID of the cluster",
          "name": "podid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "whether this cluster is managed by cloudstack",
          "name": "managedstate",
          "type": "string"
        },
        {
          "description": "the Zone name of the cluster",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "The memory overcommit ratio of the cluster",
          "name": "memoryovercommitratio",
          "type": "string"
        },
        {
          "description": "the cluster ID",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the Pod name of the cluster",
          "name": "podname",
          "type": "string"
        }
      ]
    },
    {
      "description": "Deletes project invitation",
      "isasync": true,
      "name": "deleteProjectInvitation",
      "params": [
        {
          "description": "id of the invitation",
          "length": 255,
          "name": "id",
          "related": "listProjectInvitations",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        }
      ],
      "since": "3.0.0"
    },
    {
      "description": "Lists project invitations and provides detailed information for listed invitations",
      "isasync": false,
      "name": "listProjectInvitations",
      "params": [
        {
          "description": "if true, list only active invitations - having Pending state and ones that are not timed out yet",
          "length": 255,
          "name": "activeonly",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list invitations by state",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "list invitations by id",
          "length": 255,
          "name": "id",
          "related": "listProjectInvitations",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list invitation by user ID",
          "length": 255,
          "name": "userid",
          "related": "createUser,disableUser,enableUser,getUser,listUsers,lockUser,updateUser",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "list by project id",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the name of the project",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the invitation state",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the User ID",
          "name": "userid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the account name of the project's owner",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the domain name where the project belongs to",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the id of the project",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the email the invitation was sent to",
          "name": "email",
          "type": "string"
        },
        {
          "description": "the id of the invitation",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the domain id the project belongs to",
          "name": "domainid",
          "type": "string"
        },
        {},
        {}
      ],
      "since": "3.0.0"
    },
    {
      "description": "create Tungsten-Fabric firewall policy",
      "isasync": true,
      "name": "createTungstenFabricFirewallPolicy",
      "params": [
        {
          "description": "the uuid of Tungsten-Fabric application policy set",
          "length": 255,
          "name": "applicationpolicysetuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the sequence of Tungsten-Fabric firewall policy",
          "length": 255,
          "name": "sequence",
          "required": true,
          "type": "integer"
        },
        {
          "description": "Tungsten-Fabric firewall policy name",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "listTungstenFabricFirewallPolicy",
      "response": [
        {},
        {
          "description": "Tungsten-Fabric firewall policy uuid",
          "name": "uuid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "Tungsten-Fabric firewall policy name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "list Tungsten-Fabric firewall rule",
          "name": "firewallrule",
          "type": "list"
        },
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Lists all egress firewall rules for network ID.",
      "isasync": false,
      "name": "listEgressFirewallRules",
      "params": [
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the network ID for the egress firewall services",
          "length": 255,
          "name": "networkid",
          "related": "createNetwork,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of IP address of the firewall services",
          "length": 255,
          "name": "ipaddressid",
          "related": "associateIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "Lists rule with the specified ID.",
          "length": 255,
          "name": "id",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,listIpv6FirewallRules,updateIpv6FirewallRule",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "createFirewallRule,listFirewallRules,updateEgressFirewallRule",
      "response": [
        {
          "description": "is rule for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the cidr list to forward traffic from. Multiple entries are separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {
          "description": "the ID of the firewall rule",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the public ip address id for the firewall rule",
          "name": "ipaddressid",
          "type": "string"
        },
        {},
        {
          "description": "the list of resource tags associated with the rule",
          "name": "tags",
          "response": [
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the starting port of firewall rule's port range",
          "name": "startport",
          "type": "integer"
        },
        {
          "description": "the network id of the firewall rule",
          "name": "networkid",
          "type": "string"
        },
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the traffic type for the firewall rule",
          "name": "traffictype",
          "type": "string"
        },
        {
          "description": "the ending port of firewall rule's port range",
          "name": "endport",
          "type": "integer"
        },
        {
          "description": "the cidr list to forward traffic to. Multiple entries are separated by a single comma character (,).",
          "name": "destcidrlist",
          "type": "string"
        },
        {
          "description": "type of the icmp message being sent",
          "name": "icmptype",
          "type": "integer"
        },
        {
          "description": "error code for this icmp message",
          "name": "icmpcode",
          "type": "integer"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the protocol of the firewall rule",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "the public ip address for the firewall rule",
          "name": "ipaddress",
          "type": "string"
        }
      ]
    },
    {
      "description": "Updates a region",
      "isasync": false,
      "name": "updateRegion",
      "params": [
        {
          "description": "Id of region to update",
          "length": 255,
          "name": "id",
          "required": true,
          "type": "integer"
        },
        {
          "description": "updates region with this name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "updates region with this end point",
          "length": 255,
          "name": "endpoint",
          "required": false,
          "type": "string"
        }
      ],
      "related": "addRegion,listRegions",
      "response": [
        {},
        {
          "description": "true if security groups support is enabled, false otherwise",
          "name": "portableipserviceenabled",
          "type": "boolean"
        },
        {
          "description": "true if GSLB service is enabled in the region, false otherwise",
          "name": "gslbserviceenabled",
          "type": "boolean"
        },
        {
          "description": "the name of the region",
          "name": "name",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the region",
          "name": "id",
          "type": "integer"
        },
        {
          "description": "the end point of the region",
          "name": "endpoint",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Deletes traffic type of a physical network",
      "isasync": true,
      "name": "deleteTrafficType",
      "params": [
        {
          "description": "traffic type id",
          "length": 255,
          "name": "id",
          "related": "addTrafficType,updateTrafficType",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "3.0.0"
    },
    {
      "description": "Lists clusters metrics",
      "isasync": false,
      "name": "listClustersMetrics",
      "params": [
        {
          "description": "whether this cluster is managed by cloudstack",
          "length": 255,
          "name": "managedstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "lists clusters by the cluster ID",
          "length": 255,
          "name": "id",
          "related": "addCluster,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "lists clusters by cluster type",
          "length": 255,
          "name": "clustertype",
          "required": false,
          "type": "string"
        },
        {
          "description": "lists clusters by Pod ID",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists clusters by hypervisor type",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "flag to display the capacity of the clusters",
          "length": 255,
          "name": "showcapacities",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "lists clusters by the cluster name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "lists clusters by Zone ID",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "lists clusters by allocation state",
          "length": 255,
          "name": "allocationstate",
          "required": false,
          "type": "string"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "memory usage notification threshold exceeded",
          "name": "memorythreshold",
          "type": "boolean"
        },
        {
          "description": "the maximum memory deviation",
          "name": "memorymaxdeviation",
          "type": "string"
        },
        {
          "description": "the Zone ID of the cluster",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the type of the cluster",
          "name": "clustertype",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the total cpu allocated in GiB",
          "name": "memoryallocated",
          "type": "string"
        },
        {
          "description": "the maximum cpu deviation",
          "name": "cpumaxdeviation",
          "type": "string"
        },
        {
          "description": "state of the cluster",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the allocation state of the cluster",
          "name": "allocationstate",
          "type": "string"
        },
        {
          "description": "The cpu overcommit ratio of the cluster",
          "name": "cpuovercommitratio",
          "type": "string"
        },
        {
          "description": "the cluster ID",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the total cpu allocated in Ghz",
          "name": "cpuallocated",
          "type": "string"
        },
        {
          "description": "running / total hosts in the cluster",
          "name": "hosts",
          "type": "string"
        },
        {
          "description": "the Zone name of the cluster",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the hypervisor type of the cluster",
          "name": "hypervisortype",
          "type": "string"
        },
        {
          "description": "the total cpu used in Ghz",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "Ovm3 VIP to use for pooling and/or clustering",
          "name": "ovm3vip",
          "type": "string"
        },
        {
          "description": "memory usage disable threshold exceeded",
          "name": "memorydisablethreshold",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "whether this cluster is managed by cloudstack",
          "name": "managedstate",
          "type": "string"
        },
        {
          "description": "Meta data associated with the zone (key/value pairs)",
          "name": "resourcedetails",
          "type": "map"
        },
        {
          "description": "cpu usage disable threshold exceeded",
          "name": "cpudisablethreshold",
          "type": "boolean"
        },
        {
          "description": "the Pod name of the cluster",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the total cpu capacity in Ghz",
          "name": "cputotal",
          "type": "string"
        },
        {
          "description": "The memory overcommit ratio of the cluster",
          "name": "memoryovercommitratio",
          "type": "string"
        },
        {
          "description": "the Pod ID of the cluster",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "memory allocated disable threshold exceeded",
          "name": "memoryallocateddisablethreshold",
          "type": "boolean"
        },
        {
          "description": "the total cpu used in GiB",
          "name": "memoryused",
          "type": "string"
        },
        {
          "description": "the total cpu capacity in GiB",
          "name": "memorytotal",
          "type": "string"
        },
        {},
        {
          "description": "memory allocated notification threshold exceeded",
          "name": "memoryallocatedthreshold",
          "type": "boolean"
        },
        {},
        {
          "description": "cpu usage notification threshold exceeded",
          "name": "cputhreshold",
          "type": "boolean"
        },
        {
          "description": "cpu allocated disable threshold exceeded",
          "name": "cpuallocateddisablethreshold",
          "type": "boolean"
        },
        {
          "description": "the cluster name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the capacity of the Cluster",
          "name": "capacity",
          "response": [
            {
              "description": "the Pod ID",
              "name": "podid",
              "type": "string"
            },
            {
              "description": "the capacity name",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the Zone name",
              "name": "zonename",
              "type": "string"
            },
            {
              "description": "the Cluster name",
              "name": "clustername",
              "type": "string"
            },
            {
              "description": "the total capacity available",
              "name": "capacitytotal",
              "type": "long"
            },
            {
              "description": "the capacity currently in allocated",
              "name": "capacityallocated",
              "type": "long"
            },
            {
              "description": "the Cluster ID",
              "name": "clusterid",
              "type": "string"
            },
            {
              "description": "the percentage of capacity currently in use",
              "name": "percentused",
              "type": "string"
            },
            {
              "description": "the capacity type",
              "name": "type",
              "type": "short"
            },
            {
              "description": "the capacity currently in use",
              "name": "capacityused",
              "type": "long"
            },
            {
              "description": "the Pod name",
              "name": "podname",
              "type": "string"
            },
            {
              "description": "the Zone ID",
              "name": "zoneid",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "cpu allocated notification threshold exceeded",
          "name": "cpuallocatedthreshold",
          "type": "boolean"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        }
      ],
      "since": "4.9.3"
    },
    {
      "description": "Lists objects at specified path on a storage pool.",
      "isasync": false,
      "name": "listStoragePoolObjects",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "path to list on storage pool",
          "length": 255,
          "name": "path",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "id of the storage pool",
          "length": 255,
          "name": "id",
          "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,syncStoragePool,updateStorageCapabilities",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "listImageStoreObjects",
      "response": [
        {
          "description": "Name of the data store object.",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Size is in Bytes.",
          "name": "size",
          "type": "long"
        },
        {
          "description": "Format of template associated with the data store object.",
          "name": "format",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "Volume ID associated with the data store object.",
          "name": "volumeid",
          "type": "string"
        },
        {},
        {
          "description": "Is it a directory.",
          "name": "isdirectory",
          "type": "boolean"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Snapshot ID associated with the data store object.",
          "name": "snapshotid",
          "type": "string"
        },
        {
          "description": "Last modified date of the file/directory.",
          "name": "lastupdated",
          "type": "date"
        },
        {
          "description": "Template ID associated with the data store object.",
          "name": "templateid",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Lists a project's project role permissions",
      "isasync": false,
      "name": "listProjectRolePermissions",
      "params": [
        {
          "description": "ID of the project role",
          "length": 255,
          "name": "projectroleid",
          "related": "createProjectRole,listProjectRoles,updateProjectRole",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "ID of the project",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "createProjectRolePermission",
      "response": [
        {
          "description": "the ID of the project role to which the role permission belongs",
          "name": "projectroleid",
          "type": "string"
        },
        {},
        {
          "description": "the name of the project role to which the role permission belongs",
          "name": "projectrolename",
          "type": "string"
        },
        {
          "description": "the permission type of the api name or wildcard rule, allow/deny",
          "name": "permission",
          "type": "string"
        },
        {
          "description": "the api name or wildcard rule",
          "name": "rule",
          "type": "string"
        },
        {
          "description": "the ID of the project role permission",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the description of the role permission",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the ID of the project",
          "name": "projectid",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ],
      "since": "4.15.0"
    },
    {
      "description": "Lists all LDAP configurations",
      "isasync": false,
      "name": "listLdapConfigurations",
      "params": [
        {
          "description": "linked domain",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "Hostname",
          "length": 255,
          "name": "hostname",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "If set to true,  and no domainid specified, list all LDAP configurations irrespective of the linked domain",
          "length": 255,
          "name": "listall",
          "required": false,
          "since": "4.13.2",
          "type": "boolean"
        },
        {
          "description": "Port",
          "length": 255,
          "name": "port",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "addLdapConfiguration,deleteLdapConfiguration",
      "response": [
        {
          "description": "name of the host running the ldap server",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "linked domain",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "port the ldap server is running on",
          "name": "port",
          "type": "int"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {}
      ],
      "since": "4.2.0"
    },
    {
      "description": "Lists secondary staging stores.",
      "isasync": false,
      "name": "listSecondaryStagingStores",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the Zone ID for the staging store",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the name of the staging store",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "the staging store provider",
          "length": 255,
          "name": "provider",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the staging store",
          "length": 255,
          "name": "id",
          "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,createSecondaryStagingStore,listSecondaryStagingStores,updateCloudToUseObjectStore",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the staging store protocol",
          "length": 255,
          "name": "protocol",
          "required": false,
          "type": "string"
        }
      ],
      "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,createSecondaryStagingStore,updateCloudToUseObjectStore",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the protocol of the image store",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "defines if store is read-only",
          "name": "readonly",
          "type": "boolean"
        },
        {},
        {
          "description": "the host's currently used disk size",
          "name": "disksizeused",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the image store",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the total disk size of the host",
          "name": "disksizetotal",
          "type": "long"
        },
        {},
        {
          "description": "the name of the image store",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the Zone ID of the image store",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the url of the image store",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the scope of the image store",
          "name": "scope",
          "type": "scopetype"
        },
        {
          "description": "the provider name of the image store",
          "name": "providername",
          "type": "string"
        },
        {
          "description": "the Zone name of the image store",
          "name": "zonename",
          "type": "string"
        }
      ],
      "since": "4.2.0"
    },
    {
      "description": "Creates a l2tp/ipsec remote access vpn",
      "isasync": true,
      "name": "createRemoteAccessVpn",
      "params": [
        {
          "description": "public ip address id of the vpn server",
          "length": 255,
          "name": "publicipid",
          "related": "associateIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "an optional domainId for the VPN. If the account parameter is used, domainId must also be used.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "an optional field, whether to the display the vpn to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitly. Has value true by default",
          "length": 255,
          "name": "openfirewall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the range of ip addresses to allocate to vpn clients. The first ip in the range will be taken by the vpn server",
          "length": 255,
          "name": "iprange",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional account for the VPN. Must be used with domainId.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        }
      ],
      "related": "listRemoteAccessVpns,updateRemoteAccessVpn",
      "response": [
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the range of ips to allocate to the clients",
          "name": "iprange",
          "type": "string"
        },
        {
          "description": "is vpn for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the domain name of the account of the remote access vpn",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the domain id of the account of the remote access vpn",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ipsec preshared key",
          "name": "presharedkey",
          "type": "string"
        },
        {},
        {
          "description": "the public ip address of the vpn server",
          "name": "publicipid",
          "type": "string"
        },
        {
          "description": "the account of the remote access vpn",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the project id of the vpn",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the public ip address of the vpn server",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the id of the remote access vpn",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the project name of the vpn",
          "name": "project",
          "type": "string"
        }
      ]
    },
    {
      "description": "Starts a router.",
      "isasync": true,
      "name": "startRouter",
      "params": [
        {
          "description": "the ID of the router",
          "length": 255,
          "name": "id",
          "related": "destroyRouter,listRouters,rebootRouter,startRouter,changeServiceForRouter,stopInternalLoadBalancerVM,startInternalLoadBalancerVM,listInternalLoadBalancerVMs,stopNetScalerVpx",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "destroyRouter,listRouters,rebootRouter,changeServiceForRouter,stopInternalLoadBalancerVM,startInternalLoadBalancerVM,listInternalLoadBalancerVMs,stopNetScalerVpx",
      "response": [
        {
          "description": "the public MAC address for the router",
          "name": "publicmacaddress",
          "type": "string"
        },
        {
          "description": "the guest IP address for the router",
          "name": "guestipaddress",
          "type": "string"
        },
        {
          "description": "if this router is an redundant virtual router",
          "name": "isredundantrouter",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the version of template",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the name of the router",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the second DNS for the router",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "the list of nics associated with the router",
          "name": "nic",
          "response": [
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "true if any health checks had failed",
          "name": "healthchecksfailed",
          "type": "boolean"
        },
        {
          "description": "the public netmask for the router",
          "name": "publicnetmask",
          "type": "string"
        },
        {
          "description": "the id of the router",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the project id of the ipaddress",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the version of the code / software in the router",
          "name": "softwareversion",
          "type": "string"
        },
        {
          "description": "role of the domain router",
          "name": "role",
          "type": "string"
        },
        {
          "description": "the template ID for the router",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the domain associated with the router",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the domain ID associated with the router",
          "name": "domainid",
          "type": "string"
        },
        {},
        {
          "description": "the Zone ID for the router",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the network domain for the router",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the name of the corresponding guest network",
          "name": "guestnetworkname",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the ID of the corresponding public network",
          "name": "publicnetworkid",
          "type": "string"
        },
        {
          "description": "the Pod name for the router",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "VPC the router belongs to",
          "name": "vpcid",
          "type": "string"
        },
        {
          "description": "the version of scripts",
          "name": "scriptsversion",
          "type": "string"
        },
        {
          "description": "the name of VPC the router belongs to",
          "name": "vpcname",
          "type": "string"
        },
        {
          "description": "the state of redundant virtual router",
          "name": "redundantstate",
          "type": "string"
        },
        {
          "description": "the host ID for the router",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the hostname for the router",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the guest netmask for the router",
          "name": "guestnetmask",
          "type": "string"
        },
        {
          "description": "the template name for the router",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the ID of the corresponding guest network",
          "name": "guestnetworkid",
          "type": "string"
        },
        {
          "description": "Last executed health check result for the router",
          "name": "healthcheckresults",
          "response": [
            {
              "description": "detailed response generated on running health check",
              "name": "details",
              "type": "string"
            },
            {
              "description": "the name of the health check on the router",
              "name": "checkname",
              "type": "string"
            },
            {
              "description": "result of the health check",
              "name": "success",
              "type": "boolean"
            },
            {
              "description": "the date this VPC was created",
              "name": "lastupdated",
              "type": "date"
            },
            {
              "description": "the type of the health check - basic or advanced",
              "name": "checktype",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the first IPv6 DNS for the router",
          "name": "ip6dns1",
          "type": "string"
        },
        {
          "description": "the second IPv6 DNS for the router",
          "name": "ip6dns2",
          "type": "string"
        },
        {
          "description": "the date and time the router was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the corresponding link local network",
          "name": "linklocalnetworkid",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the Zone name for the router",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the first DNS for the router",
          "name": "dns1",
          "type": "string"
        },
        {},
        {
          "description": "true if the router template requires upgrader",
          "name": "requiresupgrade",
          "type": "boolean"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the Pod ID for the router",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the public IP address for the router",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the account associated with the router",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the control state of the host for the router",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the gateway for the router",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the state of the router",
          "name": "state",
          "type": "state"
        },
        {
          "description": "the link local IP address for the router",
          "name": "linklocalip",
          "type": "string"
        },
        {
          "description": "the link local netmask for the router",
          "name": "linklocalnetmask",
          "type": "string"
        },
        {
          "description": "the link local MAC address for the router",
          "name": "linklocalmacaddress",
          "type": "string"
        },
        {
          "description": "the project name of the address",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the guest MAC address for the router",
          "name": "guestmacaddress",
          "type": "string"
        }
      ]
    },
    {
      "description": "(This API is deprecated, use scaleVirtualMachine API)Changes the service offering for a virtual machine. The virtual machine must be in a \"Stopped\" state for this command to take effect.",
      "isasync": false,
      "name": "changeServiceForVirtualMachine",
      "params": [
        {
          "description": "name value pairs of custom parameters for cpuspeed, memory and cpunumber. example details[i].name=value",
          "length": 255,
          "name": "details",
          "required": false,
          "type": "map"
        },
        {
          "description": "New minimum number of IOPS for the custom disk offering",
          "length": 255,
          "name": "miniops",
          "required": false,
          "since": "4.17",
          "type": "long"
        },
        {
          "description": "the service offering ID to apply to the virtual machine",
          "length": 255,
          "name": "serviceofferingid",
          "related": "createServiceOffering,updateServiceOffering,listServiceOfferings",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "New maximum number of IOPS for the custom disk offering",
          "length": 255,
          "name": "maxiops",
          "required": false,
          "since": "4.17",
          "type": "long"
        },
        {
          "description": "Flag for automatic migration of the root volume with new compute offering whenever migration is required to apply the offering",
          "length": 255,
          "name": "automigrate",
          "required": false,
          "since": "4.17",
          "type": "boolean"
        },
        {
          "description": "The ID of the virtual machine",
          "length": 255,
          "name": "id",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Verify OK to Shrink",
          "length": 255,
          "name": "shrinkok",
          "required": false,
          "since": "4.17",
          "type": "boolean"
        }
      ],
      "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
      "response": [
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the amount of the vm's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the date when this virtual machine was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "List of read-only Vm details as comma separated string.",
          "name": "readonlydetails",
          "type": "string"
        },
        {
          "description": "VNF details",
          "name": "vnfdetails",
          "type": "map"
        },
        {},
        {},
        {
          "description": "the id of userdata used for the VM",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the list of nics associated with vm",
          "name": "nic",
          "response": [
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "Base64 string containing the user data",
          "name": "userdata",
          "type": "string"
        },
        {
          "description": "the internal memory (KiB) that's free in VM or zero if it can not be calculated",
          "name": "memoryintfreekbs",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the ID of the domain in which the virtual machine exists",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the virtual network for the service offering",
          "name": "forvirtualnetwork",
          "type": "boolean"
        },
        {
          "description": "the date when this virtual machine was updated last time",
          "name": "lastupdated",
          "type": "date"
        },
        {
          "description": "ssh key-pairs",
          "name": "keypairs",
          "type": "string"
        },
        {
          "description": "the account associated with the virtual machine",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the ID of the availability zone for the virtual machine",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the name of the virtual machine",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the pool type of the virtual machine",
          "name": "pooltype",
          "type": "string"
        },
        {
          "description": "Name of AutoScale VM group",
          "name": "autoscalevmgroupname",
          "type": "string"
        },
        {
          "description": "the ID of the host for the virtual machine",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the ID of the backup offering of the virtual machine",
          "name": "backupofferingid",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "the vGPU type used by the virtual machine",
          "name": "vgpu",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "device type of the root volume",
          "name": "rootdevicetype",
          "type": "string"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the name of the backup offering of the virtual machine",
          "name": "backupofferingname",
          "type": "string"
        },
        {
          "description": "the project name of the vm",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the state of the virtual machine",
          "name": "state",
          "type": "string"
        },
        {
          "description": "NICs of the VNF appliance",
          "name": "vnfnics",
          "type": "list"
        },
        {
          "description": "Os type ID of the virtual machine",
          "name": "guestosid",
          "type": "string"
        },
        {
          "description": "the name of the availability zone for the virtual machine",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "an optional field whether to the display the vm to the end user or not.",
          "name": "displayvm",
          "type": "boolean"
        },
        {
          "description": "the ID of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "device ID of the root volume",
          "name": "rootdeviceid",
          "type": "long"
        },
        {
          "description": "the password (if exists) of the virtual machine",
          "name": "password",
          "type": "string"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "the control state of the host for the virtual machine",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "the group ID of the virtual machine",
          "name": "groupid",
          "type": "string"
        },
        {
          "description": "the memory used by the VM in KiB",
          "name": "memorykbs",
          "type": "long"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the user's ID who deployed the virtual machine",
          "name": "userid",
          "type": "string"
        },
        {
          "description": "the target memory in VM (KiB)",
          "name": "memorytargetkbs",
          "type": "long"
        },
        {},
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "Guest vm Boot Mode",
          "name": "bootmode",
          "type": "string"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "true if the password rest feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "ID of AutoScale VM group",
          "name": "autoscalevmgroupid",
          "type": "string"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Type",
          "name": "boottype",
          "type": "string"
        },
        {
          "description": "list of affinity groups associated with the virtual machine",
          "name": "affinitygroup",
          "response": [
            {
              "description": "the domain name of the affinity group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the project name of the affinity group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the description of the affinity group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the account owning the affinity group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the name of the affinity group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the project ID of the affinity group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the ID of the affinity group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the domain ID of the affinity group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the type of the affinity group",
              "name": "type",
              "type": "string"
            },
            {
              "description": "virtual machine IDs associated with this affinity group",
              "name": "virtualmachineIds",
              "type": "list"
            }
          ],
          "type": "set"
        },
        {
          "description": "the name of the host for the virtual machine",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "the number of vCPUs this virtual machine is using",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "Vm details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "OS type id of the vm",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "the outgoing network traffic on the host in KiB",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "the name of userdata used for the VM",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicipid",
          "type": "string"
        },
        {
          "description": "the user's name who deployed the virtual machine",
          "name": "username",
          "type": "string"
        },
        {
          "description": "OS name of the vm",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "the read (IO) of disk on the VM",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "the project id of the vm",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the memory allocated for the virtual machine",
          "name": "memory",
          "type": "integer"
        },
        {
          "description": "the incoming network traffic on the VM in KiB",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "State of the Service from LB rule",
          "name": "servicestate",
          "type": "string"
        },
        {
          "description": "the ID of the virtual machine",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the speed of each vCPU",
          "name": "cpuspeed",
          "type": "integer"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "true if high-availability is enabled, false otherwise",
          "name": "haenable",
          "type": "boolean"
        },
        {
          "description": "the write (IO) of disk on the VM",
          "name": "diskiowrite",
          "type": "long"
        },
        {
          "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
          "name": "displayname",
          "type": "string"
        },
        {
          "description": "the type of the template for the virtual machine",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "list of security groups associated with the virtual machine",
          "name": "securitygroup",
          "response": [
            {
              "description": "the name of the security group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                },
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the list of egress rules associated with the security group",
              "name": "egressrule",
              "response": [
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the number of virtualmachines associated with this securitygroup",
              "name": "virtualmachinecount",
              "type": "integer"
            },
            {
              "description": "the account owning the security group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the description of the security group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the domain ID of the security group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the list of ingress rules associated with the security group",
              "name": "ingressrule",
              "response": [
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the ID of the security group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the list of virtualmachine ids associated with this securitygroup",
              "name": "virtualmachineids",
              "type": "set"
            },
            {
              "description": "the project name of the group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the domain name of the security group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the project id of the group",
              "name": "projectid",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the name of the domain in which the virtual machine exists",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
          "name": "instancename",
          "type": "string"
        },
        {
          "description": "list of variables and values for the variables declared in userdata",
          "name": "userdatadetails",
          "type": "string"
        },
        {
          "description": "the name of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "the group name of the virtual machine",
          "name": "group",
          "type": "string"
        }
      ]
    },
    {
      "description": "Resets a configuration. The configuration will be set to default value for global setting, and removed from account_details or domain_details for Account/Domain settings",
      "isasync": false,
      "name": "resetConfiguration",
      "params": [
        {
          "description": "the ID of the Zone to reset the parameter value for corresponding zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the Cluster to reset the parameter value for corresponding cluster",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the Storage pool to reset the parameter value for corresponding storage pool",
          "length": 255,
          "name": "storageid",
          "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,syncStoragePool,updateStorageCapabilities",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the Image Store to reset the parameter value for corresponding image store",
          "length": 255,
          "name": "imagestoreid",
          "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,createSecondaryStagingStore,updateCloudToUseObjectStore",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the name of the configuration",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "the ID of the Account to reset the parameter value for corresponding account",
          "length": 255,
          "name": "accountid",
          "related": "createAccount,disableAccount,enableAccount,updateAccount,markDefaultZoneForAccount,listAccounts,listAccounts",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the Domain to reset the parameter value for corresponding domain",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "listConfigurations,updateConfiguration",
      "response": [
        {
          "description": "the value of the configuration",
          "name": "value",
          "type": "string"
        },
        {
          "description": "true if the configuration is dynamic",
          "name": "isdynamic",
          "type": "boolean"
        },
        {
          "description": "the category of the configuration",
          "name": "category",
          "type": "string"
        },
        {
          "description": "the name of the configuration",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the display text of the configuration",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the name of the parent configuration",
          "name": "parent",
          "type": "string"
        },
        {},
        {
          "description": "the possible options of the configuration value",
          "name": "options",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "scope(zone/cluster/pool/account) of the parameter that needs to be updated",
          "name": "scope",
          "type": "string"
        },
        {
          "description": "the component of the configuration",
          "name": "component",
          "type": "string"
        },
        {
          "description": "the description of the configuration",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the type of the configuration value",
          "name": "type",
          "type": "string"
        },
        {
          "description": "the subgroup of the configuration",
          "name": "subgroup",
          "type": "string"
        },
        {},
        {
          "description": "the default value of the configuration",
          "name": "defaultvalue",
          "type": "string"
        },
        {
          "description": "the group of the configuration",
          "name": "group",
          "type": "string"
        },
        {
          "description": "the value of the configuration",
          "name": "id",
          "type": "long"
        }
      ],
      "since": "4.16.0"
    },
    {
      "description": "Lists all available OS mappings for given hypervisor",
      "isasync": false,
      "name": "listGuestOsMapping",
      "params": [
        {
          "description": "list Guest OS mapping by OS display name",
          "length": 255,
          "name": "osdisplayname",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "list Guest OS mapping by OS mapping name with hypervisor",
          "length": 255,
          "name": "osnameforhypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "list Guest OS mapping by hypervisor",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "list mapping by Guest OS Type UUID",
          "length": 255,
          "name": "ostypeid",
          "related": "listOsTypes,addGuestOs",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list mapping by its UUID",
          "length": 255,
          "name": "id",
          "related": "listGuestOsMapping,addGuestOsMapping,updateGuestOsMapping",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list Guest OS mapping by hypervisor version. Must be used with hypervisor parameter",
          "length": 255,
          "name": "hypervisorversion",
          "required": false,
          "type": "string"
        }
      ],
      "related": "addGuestOsMapping,updateGuestOsMapping",
      "response": [
        {
          "description": "the ID of the Guest OS mapping",
          "name": "id",
          "type": "string"
        },
        {
          "description": "hypervisor specific name for the Guest OS",
          "name": "osnameforhypervisor",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the hypervisor",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the ID of the Guest OS type",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "standard display name for the Guest OS",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "version of the hypervisor for mapping",
          "name": "hypervisorversion",
          "type": "string"
        },
        {},
        {
          "description": "is the mapping user defined",
          "name": "isuserdefined",
          "type": "string"
        }
      ],
      "since": "4.4.0"
    },
    {
      "description": "List all public, private, and privileged templates.",
      "isasync": false,
      "name": "listTemplates",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "ID of the storage pool",
          "length": 255,
          "name": "storageid",
          "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,syncStoragePool,updateStorageCapabilities",
          "required": false,
          "since": "4.19",
          "type": "uuid"
        },
        {
          "description": "the template name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "flag to list VNF templates or not; true if need to list VNF templates, false otherwise.",
          "length": 255,
          "name": "isvnf",
          "required": false,
          "since": "4.19.0",
          "type": "boolean"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the hypervisor for which to restrict the search",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "possible values are \"featured\", \"self\", \"selfexecutable\",\"sharedexecutable\",\"executable\", and \"community\". * featured : templates that have been marked as featured and public. * self : templates that have been registered or created by the calling user. * selfexecutable : same as self, but only returns templates that can be used to deploy a new VM. * sharedexecutable : templates ready to be deployed that have been granted to the calling user by another user. * executable : templates that are owned by the calling user, or public templates, that can be used to deploy a VM. * community : templates that have been marked as public but not featured. * all : all templates (only usable by admins).",
          "length": 255,
          "name": "templatefilter",
          "required": true,
          "type": "string"
        },
        {
          "description": "list templates by zoneId",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the IDs of the templates, mutually exclusive with id",
          "length": 255,
          "name": "ids",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "since": "4.9",
          "type": "list"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "ID of the image or image cache store",
          "length": 255,
          "name": "imagestoreid",
          "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,createSecondaryStagingStore,updateCloudToUseObjectStore",
          "required": false,
          "since": "4.19",
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the template ID",
          "length": 255,
          "name": "id",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "comma separated list of template details requested, value can be a list of [ all, min]",
          "length": 255,
          "name": "details",
          "required": false,
          "since": "4.15",
          "type": "list"
        },
        {
          "description": "list datadisk templates by parent template id",
          "length": 255,
          "name": "parenttemplateid",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,listTemplates,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "since": "4.4",
          "type": "uuid"
        },
        {
          "description": "flag to display the resource image for the templates",
          "length": 255,
          "name": "showicon",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the type of the template",
          "length": 255,
          "name": "templatetype",
          "required": false,
          "since": "4.19.0",
          "type": "string"
        },
        {
          "description": "If set to true, list only unique templates across zones",
          "length": 255,
          "name": "showunique",
          "required": false,
          "since": "4.13.2",
          "type": "boolean"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "show removed templates as well",
          "length": 255,
          "name": "showremoved",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
      "response": [
        {
          "description": "the project name of the template",
          "name": "project",
          "type": "string"
        },
        {
          "description": "true if the template is managed across all Zones, false otherwise",
          "name": "crossZones",
          "type": "boolean"
        },
        {
          "description": "true if the template is ready to be deployed from, false otherwise.",
          "name": "isready",
          "type": "boolean"
        },
        {
          "description": "the ID of the OS type for this template.",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "the physical size of the template",
          "name": "physicalsize",
          "type": "long"
        },
        {
          "description": "VMware only: true if template is deployed without orchestrating disks and networks but \"as-is\" defined in the template.",
          "name": "deployasis",
          "type": "boolean"
        },
        {
          "description": "the template display text",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the account id to which the template belongs",
          "name": "accountid",
          "type": "string"
        },
        {},
        {
          "description": "true if the ISO is bootable, false otherwise",
          "name": "bootable",
          "type": "boolean"
        },
        {
          "description": "true if this template is a featured template, false otherwise",
          "name": "isfeatured",
          "type": "boolean"
        },
        {
          "description": "true if this template is a public template, false otherwise",
          "name": "ispublic",
          "type": "boolean"
        },
        {
          "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the template ID",
          "name": "id",
          "type": "string"
        },
        {
          "description": "true if the reset password feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "the ID of the zone for this template",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the template name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the id of userdata linked to this template",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "the account name to which the template belongs",
          "name": "account",
          "type": "string"
        },
        {
          "description": "VMware only: additional key/value details tied with deploy-as-is template",
          "name": "deployasisdetails",
          "type": "map"
        },
        {
          "description": "the ID of the secondary storage host for the template",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "if Datadisk template, then id of the root disk template this template belongs to",
          "name": "parenttemplateid",
          "type": "string"
        },
        {
          "description": "true if template is sshkey enabled, false otherwise",
          "name": "sshkeyenabled",
          "type": "boolean"
        },
        {
          "description": "the project id of the template",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the tag of this template",
          "name": "templatetag",
          "type": "string"
        },
        {
          "description": "additional key/value details tied with template",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the processor bit size",
          "name": "bits",
          "type": "int"
        },
        {
          "description": "true if the template is extractable, false otherwise",
          "name": "isextractable",
          "type": "boolean"
        },
        {
          "description": "the URL which the template/iso is registered from",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the name of userdata linked to this template",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "if root disk template, then ids of the datas disk templates this template owns",
          "name": "childtemplates",
          "type": "set"
        },
        {
          "description": "the name of the OS type for this template.",
          "name": "ostypename",
          "type": "string"
        },
        {
          "description": "the template ID of the parent template if present",
          "name": "sourcetemplateid",
          "type": "string"
        },
        {
          "description": "KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage",
          "name": "directdownload",
          "type": "boolean"
        },
        {
          "description": "the format of the template.",
          "name": "format",
          "type": "imageformat"
        },
        {
          "description": "the size of the template",
          "name": "size",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the type of the template",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "the date this template was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the date this template was removed",
          "name": "removed",
          "type": "date"
        },
        {
          "description": "Lists the download progress of a template across all secondary storages",
          "name": "downloaddetails",
          "type": "list"
        },
        {
          "description": "the name of the zone for this template",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the status of the template",
          "name": "status",
          "type": "string"
        },
        {
          "description": "list of parameters which contains the list of keys or string parameters that are needed to be passed for any variables declared in userdata",
          "name": "userdataparams",
          "type": "string"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the ID of the domain to which the template belongs",
          "name": "domainid",
          "type": "string"
        },
        {},
        {
          "description": "checksum of the template",
          "name": "checksum",
          "type": "string"
        },
        {
          "description": "the name of the domain to which the template belongs",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the name of the secondary storage host for the template",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "true if template requires HVM enabled, false otherwise",
          "name": "requireshvm",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            }
          ],
          "type": "set"
        }
      ]
    },
    {
      "description": "Creates an autoscale policy for a provision or deprovision action, the action is taken when the all the conditions evaluates to true for the specified duration. The policy is in effect once it is attached to a autscale vm group.",
      "isasync": true,
      "name": "createAutoScalePolicy",
      "params": [
        {
          "description": "the duration in which the conditions have to be true before action is taken",
          "length": 255,
          "name": "duration",
          "required": true,
          "type": "integer"
        },
        {
          "description": "the cool down period in which the policy should not be evaluated after the action has been taken",
          "length": 255,
          "name": "quiettime",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the list of IDs of the conditions that are being evaluated on every interval",
          "length": 255,
          "name": "conditionids",
          "related": "createCondition,listConditions",
          "required": true,
          "type": "list"
        },
        {
          "description": "the name of the autoscale policy",
          "length": 255,
          "name": "name",
          "required": false,
          "since": "4.18.0",
          "type": "string"
        },
        {
          "description": "the action to be executed if all the conditions evaluate to true for the specified duration.",
          "length": 255,
          "name": "action",
          "required": true,
          "type": "string"
        }
      ],
      "related": "listAutoScalePolicies,updateAutoScalePolicy",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the autoscale policy ID",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the domain ID of the autoscale policy",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "name of the autoscale policy",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the list of IDs of the conditions that are being evaluated on every interval",
          "name": "conditions",
          "type": "list"
        },
        {
          "description": "the project name of the autoscale policy",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the action to be executed if all the conditions evaluate to true for the specified duration.",
          "name": "action",
          "type": "string"
        },
        {
          "description": "the account owning the autoscale policy",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the project id autoscale policy",
          "name": "projectid",
          "type": "string"
        },
        {},
        {
          "description": "the domain name of the autoscale policy",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the duration for which the conditions have to be true before action is taken",
          "name": "duration",
          "type": "integer"
        },
        {
          "description": "the cool down period for which the policy should not be evaluated after the action has been taken",
          "name": "quiettime",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Removes stratosphere ssp server",
      "isasync": false,
      "name": "deleteStratosphereSsp",
      "params": [
        {
          "description": "the host ID of ssp server",
          "length": 255,
          "name": "hostid",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,addBaremetalHost",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "create Tungsten-Fabric policy",
      "isasync": true,
      "name": "createTungstenFabricPolicy",
      "params": [
        {
          "description": "Tungsten-Fabric policy name",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "listTungstenFabricPolicy,removeTungstenFabricPolicyRule,applyTungstenFabricPolicy,removeTungstenFabricPolicy",
      "response": [
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Tungsten-Fabric policy name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "list Tungsten-Fabric policy network name",
          "name": "network",
          "type": "list"
        },
        {},
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric tag type uuid",
          "name": "uuid",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Lists Usage Server metrics",
      "isasync": false,
      "name": "listUsageServerMetrics",
      "params": [],
      "related": "",
      "response": [
        {},
        {
          "description": "the state of the usage server",
          "name": "state",
          "type": "state"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the name of the active usage server",
          "name": "hostname",
          "type": "string"
        },
        {},
        {
          "description": "the time these statistics were collected",
          "name": "collectiontime",
          "type": "date"
        },
        {
          "description": "the last time this Usage Server checked for jobs",
          "name": "lastheartbeat",
          "type": "date"
        },
        {
          "description": "the last time a usage job successfully completed",
          "name": "lastsuccessfuljob",
          "type": "date"
        }
      ],
      "since": "4.17.0"
    },
    {
      "description": "Creates a bucket in the specified object storage pool. ",
      "isasync": true,
      "name": "createBucket",
      "params": [
        {
          "description": "Enable object locking in bucket",
          "length": 255,
          "name": "objectlocking",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "Enable bucket versioning",
          "length": 255,
          "name": "versioning",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the name of the bucket",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "Enable bucket encryption",
          "length": 255,
          "name": "encryption",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the domain ID associated with the bucket. If used with the account parameter returns the bucket associated with the account for the specified domain.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Id of the Object Storage Pool where bucket is created",
          "length": 255,
          "name": "objectstorageid",
          "related": "addObjectStoragePool,listObjectStoragePools",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Bucket Quota in GB",
          "length": 255,
          "name": "quota",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the project associated with the bucket. Mutually exclusive with account parameter",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the account associated with the bucket. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "The Bucket access policy",
          "length": 255,
          "name": "policy",
          "required": false,
          "type": "string"
        }
      ],
      "related": "listBuckets",
      "response": [
        {
          "description": "the domain associated with the bucket",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "Bucket Encryption",
          "name": "encryption",
          "type": "boolean"
        },
        {
          "description": "the account associated with the Bucket",
          "name": "account",
          "type": "string"
        },
        {
          "description": "Bucket Access Key",
          "name": "accesskey",
          "type": "string"
        },
        {
          "description": "Bucket Access Policy",
          "name": "policy",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the date the Bucket was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "ID of the Bucket",
          "name": "id",
          "type": "string"
        },
        {
          "description": "Object storage provider",
          "name": "provider",
          "type": "string"
        },
        {
          "description": "name of the Bucket",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Bucket Secret Key",
          "name": "usersecretkey",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "Bucket URL",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the project name of the bucket",
          "name": "project",
          "type": "string"
        },
        {
          "description": "Bucket Versioning",
          "name": "versioning",
          "type": "boolean"
        },
        {
          "description": "Name of the object storage hosting the Bucket; returned to admin user only",
          "name": "objectstore",
          "type": "string"
        },
        {},
        {
          "description": "id of the object storage hosting the Bucket; returned to admin user only",
          "name": "objectstorageid",
          "type": "string"
        },
        {},
        {
          "description": "Total size of objects in Bucket",
          "name": "size",
          "type": "long"
        },
        {
          "description": "the project id of the bucket",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the domain associated with the bucket",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "Bucket Object Locking",
          "name": "objectlocking",
          "type": "boolean"
        },
        {
          "description": "Bucket Quota in GB",
          "name": "quota",
          "type": "integer"
        },
        {
          "description": "State of the Bucket",
          "name": "state",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Enables HA for a zone",
      "isasync": true,
      "name": "enableHAForZone",
      "params": [
        {
          "description": "ID of the zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ],
      "since": "4.11"
    },
    {
      "description": "Lists physical networks",
      "isasync": false,
      "name": "listPhysicalNetworks",
      "params": [
        {
          "description": "the Zone ID for the physical network",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list physical network by id",
          "length": 255,
          "name": "id",
          "related": "createPhysicalNetwork,listPhysicalNetworks,updatePhysicalNetwork",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "search by name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "createPhysicalNetwork,updatePhysicalNetwork",
      "response": [
        {
          "description": "the uuid of the physical network",
          "name": "id",
          "type": "string"
        },
        {
          "description": "isolation methods",
          "name": "isolationmethods",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the speed of the physical network",
          "name": "networkspeed",
          "type": "string"
        },
        {
          "description": "zone name of the physical network",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the domain id of the physical network owner",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the vlan of the physical network",
          "name": "vlan",
          "type": "string"
        },
        {
          "description": "zone id of the physical network",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "state of the physical network",
          "name": "state",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "name of the physical network",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Broadcast domain range of the physical network",
          "name": "broadcastdomainrange",
          "type": "string"
        },
        {
          "description": "comma separated tag",
          "name": "tags",
          "type": "string"
        }
      ],
      "since": "3.0.0"
    },
    {
      "description": "Lists all firewall rules for an IP address.",
      "isasync": false,
      "name": "listFirewallRules",
      "params": [
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "list firewall rules for certain network",
          "length": 255,
          "name": "networkid",
          "related": "createNetwork,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "since": "4.3",
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "Lists rule with the specified ID.",
          "length": 255,
          "name": "id",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,listIpv6FirewallRules,updateIpv6FirewallRule",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of IP address of the firewall services",
          "length": 255,
          "name": "ipaddressid",
          "related": "associateIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        }
      ],
      "related": "createFirewallRule,updateEgressFirewallRule",
      "response": [
        {
          "description": "the public ip address for the firewall rule",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the cidr list to forward traffic to. Multiple entries are separated by a single comma character (,).",
          "name": "destcidrlist",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "type of the icmp message being sent",
          "name": "icmptype",
          "type": "integer"
        },
        {
          "description": "the list of resource tags associated with the rule",
          "name": "tags",
          "response": [
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the traffic type for the firewall rule",
          "name": "traffictype",
          "type": "string"
        },
        {
          "description": "the protocol of the firewall rule",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "the public ip address id for the firewall rule",
          "name": "ipaddressid",
          "type": "string"
        },
        {
          "description": "the ending port of firewall rule's port range",
          "name": "endport",
          "type": "integer"
        },
        {
          "description": "the cidr list to forward traffic from. Multiple entries are separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {
          "description": "is rule for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the network id of the firewall rule",
          "name": "networkid",
          "type": "string"
        },
        {},
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the starting port of firewall rule's port range",
          "name": "startport",
          "type": "integer"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the firewall rule",
          "name": "id",
          "type": "string"
        },
        {
          "description": "error code for this icmp message",
          "name": "icmpcode",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Cleanups VM reservations in the database.",
      "isasync": true,
      "name": "cleanVMReservations",
      "params": [],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": " delete a Brocade VCS Switch",
      "isasync": true,
      "name": "deleteBrocadeVcsDevice",
      "params": [
        {
          "description": "Brocade Switch ID",
          "length": 255,
          "name": "vcsdeviceid",
          "related": "addBrocadeVcsDevice,listBrocadeVcsDevices",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Extracts an ISO",
      "isasync": true,
      "name": "extractIso",
      "params": [
        {
          "description": "the ID of the zone where the ISO is originally located",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the ID of the ISO file",
          "length": 255,
          "name": "id",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the URL to which the ISO would be extracted",
          "length": 2048,
          "name": "url",
          "required": false,
          "type": "string"
        },
        {
          "description": "the mode of extraction - HTTP_DOWNLOAD or FTP_UPLOAD",
          "length": 255,
          "name": "mode",
          "required": true,
          "type": "string"
        }
      ],
      "related": "downloadImageStoreObject,extractTemplate,extractVolume",
      "response": [
        {
          "description": "the id of extracted object",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the name of the extracted object",
          "name": "name",
          "type": "string"
        },
        {
          "description": "if mode = upload then url of the uploaded entity. if mode = download the url from which the entity can be downloaded",
          "name": "url",
          "type": "string"
        },
        {},
        {
          "description": "zone ID the object was extracted from",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the time and date the object was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the account id to which the extracted object belongs",
          "name": "accountid",
          "type": "string"
        },
        {},
        {
          "description": "the upload id of extracted object",
          "name": "extractId",
          "type": "string"
        },
        {
          "description": "zone name the object was extracted from",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the mode of extraction - upload or download",
          "name": "extractMode",
          "type": "string"
        },
        {
          "description": "the status of the extraction",
          "name": "status",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "",
          "name": "resultstring",
          "type": "string"
        },
        {
          "description": "type of the storage",
          "name": "storagetype",
          "type": "string"
        },
        {
          "description": "the state of the extracted object",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the percentage of the entity uploaded to the specified location",
          "name": "uploadpercentage",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Lists object storage pools.",
      "isasync": false,
      "name": "listObjectStoragePools",
      "params": [
        {
          "description": "the object store provider",
          "length": 255,
          "name": "provider",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the ID of the storage pool",
          "length": 255,
          "name": "id",
          "related": "addObjectStoragePool,listObjectStoragePools",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the name of the object store",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "addObjectStoragePool",
      "response": [
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the total size of the object store",
          "name": "storagetotal",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the provider name of the object store",
          "name": "providername",
          "type": "string"
        },
        {
          "description": "the url of the object store",
          "name": "url",
          "type": "string"
        },
        {},
        {
          "description": "the ID of the object store",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the name of the object store",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the object store currently used size",
          "name": "storageused",
          "type": "long"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "create secondary staging store.",
      "isasync": false,
      "name": "createSecondaryStagingStore",
      "params": [
        {
          "description": "the URL for the staging store",
          "length": 2048,
          "name": "url",
          "required": true,
          "type": "string"
        },
        {
          "description": "the staging store provider name",
          "length": 255,
          "name": "provider",
          "required": false,
          "type": "string"
        },
        {
          "description": "the scope of the staging store: zone only for now",
          "length": 255,
          "name": "scope",
          "required": false,
          "type": "string"
        },
        {
          "description": "the Zone ID for the staging store",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the details for the staging store",
          "length": 255,
          "name": "details",
          "required": false,
          "type": "map"
        }
      ],
      "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,updateCloudToUseObjectStore",
      "response": [
        {
          "description": "the Zone name of the image store",
          "name": "zonename",
          "type": "string"
        },
        {},
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the total disk size of the host",
          "name": "disksizetotal",
          "type": "long"
        },
        {
          "description": "the scope of the image store",
          "name": "scope",
          "type": "scopetype"
        },
        {
          "description": "the ID of the image store",
          "name": "id",
          "type": "string"
        },
        {
          "description": "defines if store is read-only",
          "name": "readonly",
          "type": "boolean"
        },
        {
          "description": "the url of the image store",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the protocol of the image store",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "the provider name of the image store",
          "name": "providername",
          "type": "string"
        },
        {
          "description": "the host's currently used disk size",
          "name": "disksizeused",
          "type": "long"
        },
        {
          "description": "the Zone ID of the image store",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the name of the image store",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Creates an affinity/anti-affinity group",
      "isasync": true,
      "name": "createAffinityGroup",
      "params": [
        {
          "description": "domainId of the account owning the affinity group",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "create affinity group for project",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "optional description of the affinity group",
          "length": 255,
          "name": "description",
          "required": false,
          "type": "string"
        },
        {
          "description": "Type of the affinity group from the available affinity/anti-affinity group types",
          "length": 255,
          "name": "type",
          "required": true,
          "type": "string"
        },
        {
          "description": "name of the affinity group",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "an account for the affinity group. Must be used with domainId.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the description of the affinity group",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "virtual machine IDs associated with this affinity group",
          "name": "virtualmachineIds",
          "type": "list"
        },
        {
          "description": "the type of the affinity group",
          "name": "type",
          "type": "string"
        },
        {},
        {
          "description": "the domain name of the affinity group",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the project name of the affinity group",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the ID of the affinity group",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the name of the affinity group",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the account owning the affinity group",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the project ID of the affinity group",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the domain ID of the affinity group",
          "name": "domainid",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "Remove a VMware datacenter from a zone.",
      "isasync": false,
      "name": "removeVmwareDc",
      "params": [
        {
          "description": "The id of Zone from which VMware datacenter has to be removed.",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Logs a user into the CloudStack after successful verification of OAuth secret code from the particular provider.A successful login attempt will generate a JSESSIONID cookie value that can be passed in subsequent Query command calls until the \"logout\" command has been issued or the session has expired.",
      "isasync": false,
      "name": "oauthlogin",
      "params": [
        {
          "description": "Code that is provided by OAuth provider (Eg. google, github) after successful login",
          "length": 255,
          "name": "secretcode",
          "required": false,
          "type": "string"
        },
        {
          "description": "Path of the domain that the user belongs to. Example: domain=/com/cloud/internal. If no domain is passed in, the ROOT (/) domain is assumed.",
          "length": 255,
          "name": "domain",
          "required": false,
          "type": "string"
        },
        {
          "description": "Name of the provider",
          "length": 255,
          "name": "provider",
          "required": true,
          "type": "string"
        },
        {
          "description": "The id of the domain that the user belongs to. If both domain and domainId are passed in, \"domainId\" parameter takes precedence.",
          "length": 255,
          "name": "domainId",
          "required": false,
          "type": "long"
        },
        {
          "description": "Email id with which user tried to login using OAuth provider",
          "length": 255,
          "name": "email",
          "required": true,
          "type": "string"
        }
      ],
      "related": "login",
      "response": [
        {
          "description": "the time period before the session has expired",
          "name": "timeout",
          "type": "integer"
        },
        {
          "description": "Is two factor authentication verified",
          "name": "is2faverified",
          "type": "string"
        },
        {
          "description": "last name of the user",
          "name": "lastname",
          "type": "string"
        },
        {
          "description": "Is user registered",
          "name": "registered",
          "type": "string"
        },
        {
          "description": "Domain ID that the user belongs to",
          "name": "domainid",
          "type": "string"
        },
        {},
        {
          "description": "the account name the user belongs to",
          "name": "account",
          "type": "string"
        },
        {
          "description": "Two factor authentication issuer",
          "name": "issuerfor2fa",
          "type": "string"
        },
        {
          "description": "the account type (admin, domain-admin, read-only-admin, user)",
          "name": "type",
          "type": "string"
        },
        {
          "description": "Session key that can be passed in subsequent Query command calls",
          "name": "sessionkey",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Username",
          "name": "username",
          "type": "string"
        },
        {
          "description": "Is two factor authentication enabled",
          "name": "is2faenabled",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "first name of the user",
          "name": "firstname",
          "type": "string"
        },
        {
          "description": "Two factor authentication provider",
          "name": "providerfor2fa",
          "type": "string"
        },
        {
          "description": "user time zoneoffset",
          "name": "timezoneoffset",
          "type": "string"
        },
        {},
        {
          "description": "user time zone",
          "name": "timezone",
          "type": "string"
        },
        {
          "description": "User ID",
          "name": "userid",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Lists all available Internal Load Balancer elements.",
      "isasync": false,
      "name": "listInternalLoadBalancerElements",
      "params": [
        {
          "description": "list internal load balancer elements by network service provider id",
          "length": 255,
          "name": "nspid",
          "related": "addNetworkServiceProvider,listNetworkServiceProviders,updateNetworkServiceProvider,listTrafficTypes",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list internal load balancer elements by enabled state",
          "length": 255,
          "name": "enabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list internal load balancer elements by id",
          "length": 255,
          "name": "id",
          "related": "createInternalLoadBalancerElement,configureInternalLoadBalancerElement,listInternalLoadBalancerElements",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createInternalLoadBalancerElement,configureInternalLoadBalancerElement",
      "response": [
        {
          "description": "the id of the internal load balancer element",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the physical network service provider id of the element",
          "name": "nspid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Enabled/Disabled the element",
          "name": "enabled",
          "type": "boolean"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ],
      "since": "4.2.0"
    },
    {
      "description": "Updates load balancer health check policy",
      "isasync": true,
      "name": "updateLBHealthCheckPolicy",
      "params": [
        {
          "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
          "length": 255,
          "name": "customid",
          "required": false,
          "since": "4.4",
          "type": "string"
        },
        {
          "description": "ID of load balancer health check policy",
          "length": 255,
          "name": "id",
          "related": "createLBHealthCheckPolicy,listLBHealthCheckPolicies,updateLBHealthCheckPolicy",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "an optional field, whether to the display the policy to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        }
      ],
      "related": "createLBHealthCheckPolicy,listLBHealthCheckPolicies",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the domain ID of the HealthCheck policy",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the domain of the HealthCheck policy",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the account of the HealthCheck policy",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the list of healthcheckpolicies",
          "name": "healthcheckpolicy",
          "response": [
            {
              "description": "the LB HealthCheck policy ID",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the pingpath  of the healthcheck policy",
              "name": "pingpath",
              "type": "string"
            },
            {
              "description": "the description of the healthcheck policy",
              "name": "description",
              "type": "string"
            },
            {
              "description": "Number of consecutive health check failures before declaring an instance unhealthy.",
              "name": "unhealthcheckthresshold",
              "type": "int"
            },
            {
              "description": "Number of consecutive health check success before declaring an instance healthy",
              "name": "healthcheckthresshold",
              "type": "int"
            },
            {
              "description": "is policy for display to the regular user",
              "name": "fordisplay",
              "type": "boolean"
            },
            {
              "description": "Time to wait when receiving a response from the health check",
              "name": "responsetime",
              "type": "int"
            },
            {
              "description": "Amount of time between health checks",
              "name": "healthcheckinterval",
              "type": "int"
            },
            {
              "description": "the state of the policy",
              "name": "state",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the LB rule ID",
          "name": "lbruleid",
          "type": "string"
        },
        {},
        {
          "description": "the id of the zone the HealthCheck policy belongs to",
          "name": "zoneid",
          "type": "string"
        }
      ],
      "since": "4.4"
    },
    {
      "description": "Gets the guest OS names in the hypervisor",
      "isasync": true,
      "name": "getHypervisorGuestOsNames",
      "params": [
        {
          "description": "Hypervisor version to get the guest os names (atleast one hypervisor host with the version specified must be available)",
          "length": 255,
          "name": "hypervisorversion",
          "required": true,
          "type": "string"
        },
        {
          "description": "Keyword for guest os name",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "Hypervisor type. One of : VMware, XenServer",
          "length": 255,
          "name": "hypervisor",
          "required": true,
          "type": "string"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "version of the hypervisor for guest os names",
          "name": "hypervisorversion",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the guest OS list of the hypervisor",
          "name": "guestoslist",
          "response": [
            {
              "description": "hypervisor specific name for the Guest OS",
              "name": "osnameforhypervisor",
              "type": "string"
            },
            {
              "description": "standard display name for the Guest OS",
              "name": "osdisplayname",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the hypervisor",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the guest OS count of the hypervisor",
          "name": "guestoscount",
          "type": "integer"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "remove Tungsten-Fabric policy",
      "isasync": true,
      "name": "removeTungstenFabricPolicyRule",
      "params": [
        {
          "description": "the Uuid of Tungsten-Fabric policy",
          "length": 255,
          "name": "policyuuid",
          "required": true,
          "type": "string"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the Uuid of Tungsten-Fabric policy rule",
          "length": 255,
          "name": "ruleuuid",
          "required": true,
          "type": "string"
        }
      ],
      "related": "listTungstenFabricPolicy,applyTungstenFabricPolicy,removeTungstenFabricPolicy",
      "response": [
        {
          "description": "Tungsten-Fabric tag type uuid",
          "name": "uuid",
          "type": "string"
        },
        {},
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {},
        {
          "description": "list Tungsten-Fabric policy network name",
          "name": "network",
          "type": "list"
        },
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Tungsten-Fabric policy name",
          "name": "name",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Create Tungsten-Fabric provider in cloudstack",
      "isasync": false,
      "name": "createTungstenFabricProvider",
      "params": [
        {
          "description": "Tungsten-Fabric provider introspect port",
          "length": 255,
          "name": "tungstenproviderintrospectport",
          "required": false,
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider name",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider hostname",
          "length": 255,
          "name": "tungstenproviderhostname",
          "required": true,
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider gateway",
          "length": 255,
          "name": "tungstengateway",
          "required": true,
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider port",
          "length": 255,
          "name": "tungstenproviderport",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Tungsten-Fabric provider vrouter port",
          "length": 255,
          "name": "tungstenprovidervrouterport",
          "required": false,
          "type": "string"
        }
      ],
      "related": "listTungstenFabricProviders",
      "response": [
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider hostname",
          "name": "tungstenproviderhostname",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Tungsten-Fabric provider name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider gateway",
          "name": "tungstengateway",
          "type": "string"
        },
        {},
        {
          "description": "Tungsten-Fabric provider port",
          "name": "tungstenproviderport",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider introspect port",
          "name": "tungstenproviderintrospectport",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider uuid",
          "name": "tungstenprovideruuid",
          "type": "string"
        },
        {
          "description": "true if security groups support is enabled, false otherwise",
          "name": "securitygroupsenabled",
          "type": "boolean"
        },
        {
          "description": "Tungsten-Fabric provider vrouter port",
          "name": "tungstenprovidervrouterport",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Enables HA cluster-wide",
      "isasync": true,
      "name": "enableHAForCluster",
      "params": [
        {
          "description": "ID of the cluster",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,updateCluster",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ],
      "since": "4.11"
    },
    {
      "description": "Reboots a virtual machine.",
      "isasync": true,
      "name": "rebootVirtualMachine",
      "params": [
        {
          "description": "Force reboot the VM (VM is Stopped and then Started)",
          "length": 255,
          "name": "forced",
          "required": false,
          "since": "4.16.0",
          "type": "boolean"
        },
        {
          "description": "Boot into hardware setup menu or not",
          "length": 255,
          "name": "bootintosetup",
          "required": false,
          "since": "4.15.0.0",
          "type": "boolean"
        },
        {
          "description": "The ID of the virtual machine",
          "length": 255,
          "name": "id",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,rebootVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
      "response": [
        {
          "description": "the number of vCPUs this virtual machine is using",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "device ID of the root volume",
          "name": "rootdeviceid",
          "type": "long"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "the user's ID who deployed the virtual machine",
          "name": "userid",
          "type": "string"
        },
        {
          "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
          "name": "instancename",
          "type": "string"
        },
        {
          "description": "the target memory in VM (KiB)",
          "name": "memorytargetkbs",
          "type": "long"
        },
        {
          "description": "Os type ID of the virtual machine",
          "name": "guestosid",
          "type": "string"
        },
        {
          "description": "State of the Service from LB rule",
          "name": "servicestate",
          "type": "string"
        },
        {
          "description": "the virtual network for the service offering",
          "name": "forvirtualnetwork",
          "type": "boolean"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the date when this virtual machine was updated last time",
          "name": "lastupdated",
          "type": "date"
        },
        {
          "description": "list of affinity groups associated with the virtual machine",
          "name": "affinitygroup",
          "response": [
            {
              "description": "the domain ID of the affinity group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the project name of the affinity group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the ID of the affinity group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the name of the affinity group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the domain name of the affinity group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the account owning the affinity group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the description of the affinity group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the project ID of the affinity group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "virtual machine IDs associated with this affinity group",
              "name": "virtualmachineIds",
              "type": "list"
            },
            {
              "description": "the type of the affinity group",
              "name": "type",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "NICs of the VNF appliance",
          "name": "vnfnics",
          "type": "list"
        },
        {
          "description": "the internal memory (KiB) that's free in VM or zero if it can not be calculated",
          "name": "memoryintfreekbs",
          "type": "long"
        },
        {
          "description": "the id of userdata used for the VM",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "the name of the host for the virtual machine",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "list of security groups associated with the virtual machine",
          "name": "securitygroup",
          "response": [
            {
              "description": "the project name of the group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                },
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the account owning the security group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the list of virtualmachine ids associated with this securitygroup",
              "name": "virtualmachineids",
              "type": "set"
            },
            {
              "description": "the list of egress rules associated with the security group",
              "name": "egressrule",
              "response": [
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the ID of the security group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the description of the security group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the project id of the group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the list of ingress rules associated with the security group",
              "name": "ingressrule",
              "response": [
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                }
              ],
              "type": "set"
            },
            {
              "description": "the number of virtualmachines associated with this securitygroup",
              "name": "virtualmachinecount",
              "type": "integer"
            },
            {
              "description": "the domain name of the security group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the domain ID of the security group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the name of the security group",
              "name": "name",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "OS type id of the vm",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "the name of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "the memory allocated for the virtual machine",
          "name": "memory",
          "type": "integer"
        },
        {
          "description": "the account associated with the virtual machine",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the list of nics associated with vm",
          "name": "nic",
          "response": [
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "true if the password rest feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "Base64 string containing the user data",
          "name": "userdata",
          "type": "string"
        },
        {
          "description": "the ID of the host for the virtual machine",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the project id of the vm",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the speed of each vCPU",
          "name": "cpuspeed",
          "type": "integer"
        },
        {
          "description": "the name of the virtual machine",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "OS name of the vm",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "the amount of the vm's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Mode",
          "name": "bootmode",
          "type": "string"
        },
        {
          "description": "the date when this virtual machine was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the state of the virtual machine",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the ID of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "Name of AutoScale VM group",
          "name": "autoscalevmgroupname",
          "type": "string"
        },
        {
          "description": "the control state of the host for the virtual machine",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
          "name": "displayname",
          "type": "string"
        },
        {},
        {
          "description": "an optional field whether to the display the vm to the end user or not.",
          "name": "displayvm",
          "type": "boolean"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "Vm details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the name of the backup offering of the virtual machine",
          "name": "backupofferingname",
          "type": "string"
        },
        {
          "description": "the vGPU type used by the virtual machine",
          "name": "vgpu",
          "type": "string"
        },
        {},
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicipid",
          "type": "string"
        },
        {
          "description": "VNF details",
          "name": "vnfdetails",
          "type": "map"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the name of userdata used for the VM",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "the name of the availability zone for the virtual machine",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "List of read-only Vm details as comma separated string.",
          "name": "readonlydetails",
          "type": "string"
        },
        {
          "description": "the ID of the virtual machine",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the type of the template for the virtual machine",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "true if high-availability is enabled, false otherwise",
          "name": "haenable",
          "type": "boolean"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Type",
          "name": "boottype",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the group ID of the virtual machine",
          "name": "groupid",
          "type": "string"
        },
        {
          "description": "the ID of the availability zone for the virtual machine",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "ssh key-pairs",
          "name": "keypairs",
          "type": "string"
        },
        {
          "description": "the user's name who deployed the virtual machine",
          "name": "username",
          "type": "string"
        },
        {
          "description": "the read (IO) of disk on the VM",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the project name of the vm",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the write (IO) of disk on the VM",
          "name": "diskiowrite",
          "type": "long"
        },
        {
          "description": "list of variables and values for the variables declared in userdata",
          "name": "userdatadetails",
          "type": "string"
        },
        {},
        {
          "description": "device type of the root volume",
          "name": "rootdevicetype",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "the password (if exists) of the virtual machine",
          "name": "password",
          "type": "string"
        },
        {
          "description": "ID of AutoScale VM group",
          "name": "autoscalevmgroupid",
          "type": "string"
        },
        {
          "description": "the name of the domain in which the virtual machine exists",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the outgoing network traffic on the host in KiB",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "the ID of the backup offering of the virtual machine",
          "name": "backupofferingid",
          "type": "string"
        },
        {
          "description": "the pool type of the virtual machine",
          "name": "pooltype",
          "type": "string"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the incoming network traffic on the VM in KiB",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "the ID of the domain in which the virtual machine exists",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the group name of the virtual machine",
          "name": "group",
          "type": "string"
        },
        {
          "description": "the memory used by the VM in KiB",
          "name": "memorykbs",
          "type": "long"
        }
      ]
    },
    {
      "description": "Add VMs to an ExternalManaged kubernetes cluster. Not applicable for CloudManaged kubernetes clusters.",
      "isasync": false,
      "name": "addVirtualMachinesToKubernetesCluster",
      "params": [
        {
          "description": "the ID of the Kubernetes cluster",
          "length": 255,
          "name": "id",
          "related": "createKubernetesCluster,startKubernetesCluster,listKubernetesClusters,scaleKubernetesCluster,upgradeKubernetesCluster",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Is control node or not? Defaults to false.",
          "length": 255,
          "name": "iscontrolnode",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the IDs of the VMs to add to the cluster",
          "length": 255,
          "name": "virtualmachineids",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": true,
          "type": "list"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {}
      ],
      "since": "4.19.0"
    },
    {
      "description": "Creates a load balancer rule",
      "isasync": true,
      "name": "createLoadBalancerRule",
      "params": [
        {
          "description": "the domain ID associated with the load balancer",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "load balancer algorithm (source, roundrobin, leastconn)",
          "length": 255,
          "name": "algorithm",
          "required": true,
          "type": "string"
        },
        {
          "description": "the public port from where the network traffic will be load balanced from",
          "length": 255,
          "name": "publicport",
          "required": true,
          "type": "integer"
        },
        {
          "description": "if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitly. If not specified 1) defaulted to false when LB rule is being created for VPC guest network 2) in all other cases defaulted to true",
          "length": 255,
          "name": "openfirewall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the CIDR list to allow traffic, all other CIDRs will be blocked. Multiple entries must be separated by a single comma character (,). By default, all CIDRs are allowed.",
          "length": 255,
          "name": "cidrlist",
          "required": false,
          "since": "4.18.0.0",
          "type": "list"
        },
        {
          "description": "The guest network this rule will be created for. Required when public Ip address is not associated with any Guest network yet (VPC case)",
          "length": 255,
          "name": "networkid",
          "related": "createNetwork,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "an optional field, whether to the display the rule to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "The protocol for the LB such as tcp, udp or tcp-proxy.",
          "length": 255,
          "name": "protocol",
          "required": false,
          "type": "string"
        },
        {
          "description": "public IP address ID from where the network traffic will be load balanced from",
          "length": 255,
          "name": "publicipid",
          "related": "associateIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the description of the load balancer rule",
          "length": 4096,
          "name": "description",
          "required": false,
          "type": "string"
        },
        {
          "description": "zone where the load balancer is going to be created. This parameter is required when LB service provider is ElasticLoadBalancerVm",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the private port of the private IP address/virtual machine where the network traffic will be load balanced to",
          "length": 255,
          "name": "privateport",
          "required": true,
          "type": "integer"
        },
        {
          "description": "the account associated with the load balancer. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "name of the load balancer rule",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        }
      ],
      "related": "listLoadBalancerRules,updateLoadBalancerRule",
      "response": [
        {
          "description": "the name of the load balancer",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the id of the guest network the lb rule belongs to",
          "name": "networkid",
          "type": "string"
        },
        {
          "description": "the load balancer algorithm (source, roundrobin, leastconn)",
          "name": "algorithm",
          "type": "string"
        },
        {
          "description": "the private port",
          "name": "privateport",
          "type": "string"
        },
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the CIDR list to allow traffic, all other CIDRs will be blocked. Multiple entries must be separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {},
        {
          "description": "is rule for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the public ip address",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the name of the zone the load balancer rule belongs to",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the protocol of the loadbalanacer rule",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "the description of the load balancer",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the project id of the load balancer",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the domain of the load balancer rule",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the load balancer rule ID",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the public ip address id",
          "name": "publicipid",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated with load balancer",
          "name": "tags",
          "response": [
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the public port",
          "name": "publicport",
          "type": "string"
        },
        {
          "description": "the id of the zone the rule belongs to",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the domain ID of the load balancer rule",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the project name of the load balancer",
          "name": "project",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the account of the load balancer rule",
          "name": "account",
          "type": "string"
        }
      ]
    },
    {
      "description": "list Tungsten-Fabric logical router",
      "isasync": false,
      "name": "listTungstenFabricLogicalRouter",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the uuid of Tungsten-Fabric logical router",
          "length": 255,
          "name": "logicalrouteruuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the uuid of Tungsten-Fabric network",
          "length": 255,
          "name": "networkuuid",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        }
      ],
      "related": "createTungstenFabricLogicalRouter,addTungstenFabricNetworkGatewayToLogicalRouter,removeTungstenFabricNetworkGatewayFromLogicalRouter",
      "response": [
        {},
        {
          "description": "Tungsten-Fabric provider zone id",
          "name": "zoneid",
          "type": "long"
        },
        {
          "description": "Tungsten-Fabric logical router uuid",
          "name": "uuid",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric provider zone name",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "Tungsten-Fabric logical router name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "list Tungsten-Fabric policy network name",
          "name": "network",
          "type": "list"
        }
      ]
    },
    {
      "description": "Import vSphere storage policies",
      "isasync": false,
      "name": "importVsphereStoragePolicies",
      "params": [
        {
          "description": "ID of the zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "listVsphereStoragePolicies",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the Storage Policy",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the description of the Storage Policy",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the identifier of the Storage Policy in vSphere DataCenter",
          "name": "policyid",
          "type": "string"
        },
        {},
        {},
        {
          "description": "the name of the Storage Policy",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the ID of the Zone",
          "name": "zoneid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Adds a guest OS name to hypervisor OS name mapping",
      "isasync": true,
      "name": "addGuestOsMapping",
      "params": [
        {
          "description": "Hypervisor version to create the mapping. Use 'default' for default versions. Please check hypervisor capabilities for correct version",
          "length": 255,
          "name": "hypervisorversion",
          "required": true,
          "type": "string"
        },
        {
          "description": "When set to true, checks for the correct guest os mapping name in the provided hypervisor (supports VMware and XenServer only. At least one hypervisor host with the version specified must be available. Default version will not work.)",
          "length": 255,
          "name": "osmappingcheckenabled",
          "required": false,
          "since": "4.19.0",
          "type": "boolean"
        },
        {
          "description": "Display Name of Guest OS standard type. Either Display Name or UUID must be passed",
          "length": 255,
          "name": "osdisplayname",
          "required": false,
          "type": "string"
        },
        {
          "description": "OS name specific to the hypervisor",
          "length": 255,
          "name": "osnameforhypervisor",
          "required": true,
          "type": "string"
        },
        {
          "description": "UUID of Guest OS type. Either the UUID or Display Name must be passed",
          "length": 255,
          "name": "ostypeid",
          "related": "listOsTypes,addGuestOs",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Forces add user defined guest os mapping, overrides any existing user defined mapping",
          "length": 255,
          "name": "forced",
          "required": false,
          "since": "4.19.0",
          "type": "boolean"
        },
        {
          "description": "Hypervisor type. One of : XenServer, KVM, VMWare",
          "length": 255,
          "name": "hypervisor",
          "required": true,
          "type": "string"
        }
      ],
      "related": "updateGuestOsMapping",
      "response": [
        {
          "description": "is the mapping user defined",
          "name": "isuserdefined",
          "type": "string"
        },
        {
          "description": "hypervisor specific name for the Guest OS",
          "name": "osnameforhypervisor",
          "type": "string"
        },
        {
          "description": "version of the hypervisor for mapping",
          "name": "hypervisorversion",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the Guest OS mapping",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the hypervisor",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "standard display name for the Guest OS",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "the ID of the Guest OS type",
          "name": "ostypeid",
          "type": "string"
        }
      ],
      "since": "4.4.0"
    },
    {
      "description": "Disables out-of-band management for a zone",
      "isasync": true,
      "name": "disableOutOfBandManagementForZone",
      "params": [
        {
          "description": "the ID of the zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "enableOutOfBandManagementForHost,disableOutOfBandManagementForHost,enableOutOfBandManagementForCluster,disableOutOfBandManagementForCluster,enableOutOfBandManagementForZone,issueOutOfBandManagementPowerAction,changeOutOfBandManagementPassword",
      "response": [
        {
          "description": "the ID of the host",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the operation result description",
          "name": "description",
          "type": "string"
        },
        {
          "description": "true if out-of-band management is enabled for the host",
          "name": "enabled",
          "type": "boolean"
        },
        {
          "description": "the out-of-band management interface password",
          "name": "password",
          "type": "string"
        },
        {
          "description": "the out-of-band management action (if issued)",
          "name": "action",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the out-of-band management interface port",
          "name": "port",
          "type": "string"
        },
        {
          "description": "the out-of-band management interface username",
          "name": "username",
          "type": "string"
        },
        {
          "description": "the operation result",
          "name": "status",
          "type": "boolean"
        },
        {
          "description": "the out-of-band management interface powerState of the host",
          "name": "powerstate",
          "type": "powerstate"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the out-of-band management interface address",
          "name": "address",
          "type": "string"
        },
        {
          "description": "the out-of-band management driver for the host",
          "name": "driver",
          "type": "string"
        },
        {},
        {}
      ],
      "since": "4.9.0"
    },
    {
      "description": "List all public, private, and privileged VNF templates.",
      "isasync": false,
      "name": "listVnfTemplates",
      "params": [
        {
          "description": "the hypervisor for which to restrict the search",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "comma separated list of template details requested, value can be a list of [ all, min]",
          "length": 255,
          "name": "details",
          "required": false,
          "since": "4.15",
          "type": "list"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "If set to true, list only unique templates across zones",
          "length": 255,
          "name": "showunique",
          "required": false,
          "since": "4.13.2",
          "type": "boolean"
        },
        {
          "description": "the IDs of the templates, mutually exclusive with id",
          "length": 255,
          "name": "ids",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "since": "4.9",
          "type": "list"
        },
        {
          "description": "flag to display the resource image for the templates",
          "length": 255,
          "name": "showicon",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the type of the template",
          "length": 255,
          "name": "templatetype",
          "required": false,
          "since": "4.19.0",
          "type": "string"
        },
        {
          "description": "list templates by zoneId",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "possible values are \"featured\", \"self\", \"selfexecutable\",\"sharedexecutable\",\"executable\", and \"community\". * featured : templates that have been marked as featured and public. * self : templates that have been registered or created by the calling user. * selfexecutable : same as self, but only returns templates that can be used to deploy a new VM. * sharedexecutable : templates ready to be deployed that have been granted to the calling user by another user. * executable : templates that are owned by the calling user, or public templates, that can be used to deploy a VM. * community : templates that have been marked as public but not featured. * all : all templates (only usable by admins).",
          "length": 255,
          "name": "templatefilter",
          "required": true,
          "type": "string"
        },
        {
          "description": "list datadisk templates by parent template id",
          "length": 255,
          "name": "parenttemplateid",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "since": "4.4",
          "type": "uuid"
        },
        {
          "description": "flag to list VNF templates or not; true if need to list VNF templates, false otherwise.",
          "length": 255,
          "name": "isvnf",
          "required": false,
          "since": "4.19.0",
          "type": "boolean"
        },
        {
          "description": "the template name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "show removed templates as well",
          "length": 255,
          "name": "showremoved",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "the template ID",
          "length": 255,
          "name": "id",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
      "response": [
        {
          "description": "the date this template was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the size of the template",
          "name": "size",
          "type": "long"
        },
        {},
        {
          "description": "the account name to which the template belongs",
          "name": "account",
          "type": "string"
        },
        {
          "description": "true if the template is managed across all Zones, false otherwise",
          "name": "crossZones",
          "type": "boolean"
        },
        {
          "description": "true if template is sshkey enabled, false otherwise",
          "name": "sshkeyenabled",
          "type": "boolean"
        },
        {
          "description": "the URL which the template/iso is registered from",
          "name": "url",
          "type": "string"
        },
        {
          "description": "the id of userdata linked to this template",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "checksum of the template",
          "name": "checksum",
          "type": "string"
        },
        {
          "description": "the template display text",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the processor bit size",
          "name": "bits",
          "type": "int"
        },
        {
          "description": "the date this template was removed",
          "name": "removed",
          "type": "date"
        },
        {
          "description": "the ID of the zone for this template",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the ID of the domain to which the template belongs",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "if root disk template, then ids of the datas disk templates this template owns",
          "name": "childtemplates",
          "type": "set"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the name of the zone for this template",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "true if this template is a public template, false otherwise",
          "name": "ispublic",
          "type": "boolean"
        },
        {
          "description": "the account id to which the template belongs",
          "name": "accountid",
          "type": "string"
        },
        {
          "description": "the physical size of the template",
          "name": "physicalsize",
          "type": "long"
        },
        {
          "description": "Lists the download progress of a template across all secondary storages",
          "name": "downloaddetails",
          "type": "list"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the format of the template.",
          "name": "format",
          "type": "imageformat"
        },
        {
          "description": "true if the reset password feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "the status of the template",
          "name": "status",
          "type": "string"
        },
        {
          "description": "if Datadisk template, then id of the root disk template this template belongs to",
          "name": "parenttemplateid",
          "type": "string"
        },
        {
          "description": "VMware only: additional key/value details tied with deploy-as-is template",
          "name": "deployasisdetails",
          "type": "map"
        },
        {
          "description": "additional key/value details tied with template",
          "name": "details",
          "type": "map"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {},
        {
          "description": "true if the template is extractable, false otherwise",
          "name": "isextractable",
          "type": "boolean"
        },
        {
          "description": "the template ID of the parent template if present",
          "name": "sourcetemplateid",
          "type": "string"
        },
        {
          "description": "the tag of this template",
          "name": "templatetag",
          "type": "string"
        },
        {
          "description": "the name of userdata linked to this template",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "the project id of the template",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the template name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "true if the template is ready to be deployed from, false otherwise.",
          "name": "isready",
          "type": "boolean"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the project name of the template",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the template ID",
          "name": "id",
          "type": "string"
        },
        {
          "description": "true if the ISO is bootable, false otherwise",
          "name": "bootable",
          "type": "boolean"
        },
        {
          "description": "VMware only: true if template is deployed without orchestrating disks and networks but \"as-is\" defined in the template.",
          "name": "deployasis",
          "type": "boolean"
        },
        {
          "description": "the name of the OS type for this template.",
          "name": "ostypename",
          "type": "string"
        },
        {
          "description": "true if template requires HVM enabled, false otherwise",
          "name": "requireshvm",
          "type": "boolean"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the name of the domain to which the template belongs",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "list of parameters which contains the list of keys or string parameters that are needed to be passed for any variables declared in userdata",
          "name": "userdataparams",
          "type": "string"
        },
        {
          "description": "the ID of the OS type for this template.",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage",
          "name": "directdownload",
          "type": "boolean"
        },
        {
          "description": "true if this template is a featured template, false otherwise",
          "name": "isfeatured",
          "type": "boolean"
        },
        {
          "description": "the name of the secondary storage host for the template",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the type of the template",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "the ID of the secondary storage host for the template",
          "name": "hostid",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Creates and automatically starts a VNF appliance based on a service offering, disk offering, and template.",
      "isasync": true,
      "name": "deployVnfAppliance",
      "params": [
        {
          "description": "Enable packed virtqueues or not.",
          "length": 255,
          "name": "nicpackedvirtqueuesenabled",
          "required": false,
          "since": "4.18",
          "type": "boolean"
        },
        {
          "description": "the arbitrary size for the DATADISK volume. Mutually exclusive with diskOfferingId",
          "length": 255,
          "name": "size",
          "required": false,
          "type": "long"
        },
        {
          "description": "IOThreads are dedicated event loop threads for supported disk devices to perform block I/O requests in order to improve scalability especially on an SMP host/guest with many LUNs.",
          "length": 255,
          "name": "iothreadsenabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "comma separated list of security groups names that going to be applied to the virtual machine. Should be passed only when vm is created from a zone with Basic Network support. Mutually exclusive with securitygroupids parameter",
          "length": 255,
          "name": "securitygroupnames",
          "related": "createSecurityGroup,updateSecurityGroup",
          "required": false,
          "type": "list"
        },
        {
          "description": "Deploy vm for the project",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
          "length": 255,
          "name": "customid",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional user generated name for the virtual machine",
          "length": 255,
          "name": "displayname",
          "required": false,
          "type": "string"
        },
        {
          "description": "Controls specific policies on IO",
          "length": 255,
          "name": "iodriverpolicy",
          "required": false,
          "type": "string"
        },
        {
          "description": "ip to network mapping. Can't be specified with networkIds parameter. Example: iptonetworklist[0].ip=10.10.10.11&iptonetworklist[0].ipv6=fc00:1234:5678::abcd&iptonetworklist[0].networkid=uuid&iptonetworklist[0].mac=aa:bb:cc:dd:ee::ff - requests to use ip 10.10.10.11 in network id=uuid",
          "length": 255,
          "name": "iptonetworklist",
          "required": false,
          "type": "map"
        },
        {
          "description": "used to specify the parameters values for the variables in userdata.",
          "length": 255,
          "name": "userdatadetails",
          "required": false,
          "since": "4.18",
          "type": "map"
        },
        {
          "description": "the ipv6 address for default vm's network",
          "length": 255,
          "name": "ip6address",
          "required": false,
          "type": "string"
        },
        {
          "description": "Boot Mode [Legacy] or [Secure] Applicable when Boot Type Selected is UEFI, otherwise Legacy only for BIOS. Not applicable with VMware if the template is marked as deploy-as-is, as we honour what is defined in the template.",
          "length": 255,
          "name": "bootmode",
          "required": false,
          "since": "4.14.0.0",
          "type": "string"
        },
        {
          "description": "an optional group for the virtual machine",
          "length": 255,
          "name": "group",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the template for the virtual machine",
          "length": 255,
          "name": "templateid",
          "related": "prepareTemplate,listIsos,registerIso,updateIso,copyTemplate,createTemplate,registerTemplate,updateTemplate,listTemplates,createTemplate,copyTemplate,registerTemplate,registerIso,copyIso,listIsos,linkUserDataToTemplate,registerVnfTemplate,registerVnfTemplate,listVnfTemplates,updateVnfTemplate,updateVnfTemplate",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "name of the ssh key pair used to login to the virtual machine",
          "length": 255,
          "name": "keypair",
          "required": false,
          "type": "string"
        },
        {
          "description": "true if virtual machine needs to be dynamically scalable",
          "length": 255,
          "name": "dynamicscalingenabled",
          "required": false,
          "since": "4.16",
          "type": "boolean"
        },
        {
          "description": "VMware only: used to specify network mapping of a vApp VMware template registered \"as-is\". Example nicnetworklist[0].ip=Nic-101&nicnetworklist[0].network=uuid",
          "length": 255,
          "name": "nicnetworklist",
          "required": false,
          "since": "4.15",
          "type": "map"
        },
        {
          "description": "datadisk template to disk-offering mapping; an optional parameter used to create additional data disks from datadisk templates; can't be specified with diskOfferingId parameter",
          "length": 255,
          "name": "datadiskofferinglist",
          "required": false,
          "since": "4.11",
          "type": "map"
        },
        {
          "description": "an optional binary data that can be sent to the virtual machine upon a successful deployment. This binary data must be base64 encoded before adding it to the request. Using HTTP GET (via querystring), you can send up to 4KB of data after base64 encoding. Using HTTP POST(via POST body), you can send up to 1MB of data after base64 encoding.",
          "length": 1048576,
          "name": "userdata",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ip address for default vm's network",
          "length": 255,
          "name": "ipaddress",
          "required": false,
          "type": "string"
        },
        {
          "description": "used to specify the vApp properties.",
          "length": 255,
          "name": "properties",
          "required": false,
          "since": "4.15",
          "type": "map"
        },
        {
          "description": "an optional keyboard device type for the virtual machine. valid value can be one of de,de-ch,es,fi,fr,fr-be,fr-ch,is,it,jp,nl-be,no,pt,uk,us",
          "length": 255,
          "name": "keyboard",
          "required": false,
          "type": "string"
        },
        {
          "description": "true if start vm after creating; defaulted to true if not specified",
          "length": 255,
          "name": "startvm",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the hypervisor on which to deploy the virtual machine. The parameter is required and respected only when hypervisor info is not set on the ISO/Template passed to the call",
          "length": 255,
          "name": "hypervisor",
          "required": false,
          "type": "string"
        },
        {
          "description": "used to specify the custom parameters. 'extraconfig' is not allowed to be passed in details",
          "length": 255,
          "name": "details",
          "required": false,
          "since": "4.3",
          "type": "map"
        },
        {
          "description": "names of the ssh key pairs used to login to the virtual machine",
          "length": 255,
          "name": "keypairs",
          "required": false,
          "since": "4.17",
          "type": "list"
        },
        {
          "description": "comma separated list of security groups id that going to be applied to the virtual machine. Should be passed only when vm is created from a zone with Basic Network support. Mutually exclusive with securitygroupnames parameter",
          "length": 255,
          "name": "securitygroupids",
          "related": "createSecurityGroup,updateSecurityGroup",
          "required": false,
          "type": "list"
        },
        {
          "description": "The password of the virtual machine. If null, a random password will be generated for the VM.",
          "length": 255,
          "name": "password",
          "required": false,
          "since": "4.19.0.0",
          "type": "string"
        },
        {
          "description": "if true the image tags (if any) will be copied to the VM, default value is false",
          "length": 255,
          "name": "copyimagetags",
          "required": false,
          "since": "4.13",
          "type": "boolean"
        },
        {
          "description": "comma separated list of affinity groups names that are going to be applied to the virtual machine.Mutually exclusive with affinitygroupids parameter",
          "length": 255,
          "name": "affinitygroupnames",
          "related": "",
          "required": false,
          "type": "list"
        },
        {
          "description": "an optional domainId for the virtual machine. If the account parameter is used, domainId must also be used. If account is NOT provided then virtual machine will be assigned to the caller account and domain.",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "The number of queues for multiqueue NICs.",
          "length": 255,
          "name": "nicmultiqueuenumber",
          "required": false,
          "since": "4.18",
          "type": "integer"
        },
        {
          "description": "host name for the virtual machine",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "Guest VM Boot option either custom[UEFI] or default boot [BIOS]. Not applicable with VMware if the template is marked as deploy-as-is, as we honour what is defined in the template.",
          "length": 255,
          "name": "boottype",
          "required": false,
          "since": "4.14.0.0",
          "type": "string"
        },
        {
          "description": "an optional field, whether to the display the vm to the end user or not.",
          "length": 255,
          "name": "displayvm",
          "required": false,
          "since": "4.2",
          "type": "boolean"
        },
        {
          "description": "the ID of the Userdata",
          "length": 255,
          "name": "userdataid",
          "related": "",
          "required": false,
          "since": "4.18",
          "type": "uuid"
        },
        {
          "description": "the mac address for default vm's network",
          "length": 255,
          "name": "macaddress",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional URL encoded string that can be passed to the virtual machine upon successful deployment",
          "length": 5120,
          "name": "extraconfig",
          "required": false,
          "since": "4.12",
          "type": "string"
        },
        {
          "description": "the ID of the disk offering for the virtual machine. If the template is of ISO format, the diskOfferingId is for the root disk volume. Otherwise this parameter is used to indicate the offering for the data disk volume. If the templateId parameter passed is from a Template object, the diskOfferingId refers to a DATA Disk Volume created. If the templateId parameter passed is from an ISO object, the diskOfferingId refers to a ROOT Disk Volume created.",
          "length": 255,
          "name": "diskofferingid",
          "related": "createDiskOffering,updateDiskOffering,listDiskOfferings",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Optional field to resize root disk on deploy. Value is in GB. Only applies to template-based deployments. Analogous to details[0].rootdisksize, which takes precedence over this parameter if both are provided",
          "length": 255,
          "name": "rootdisksize",
          "required": false,
          "since": "4.4",
          "type": "long"
        },
        {
          "description": "DHCP options which are passed to the VM on start up Example: dhcpoptionsnetworklist[0].dhcp:114=url&dhcpoptionsetworklist[0].networkid=networkid&dhcpoptionsetworklist[0].dhcp:66=www.test.com",
          "length": 255,
          "name": "dhcpoptionsnetworklist",
          "required": false,
          "type": "map"
        },
        {
          "description": "list of network ids used by virtual machine. Can't be specified with ipToNetworkList parameter",
          "length": 255,
          "name": "networkids",
          "related": "createNetwork,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "type": "list"
        },
        {
          "description": "the ID of the disk offering for the virtual machine to be used for root volume instead of the disk offering mapped in service offering.In case of virtual machine deploying from ISO, then the diskofferingid specified for root volume is ignored and uses this override disk offering id",
          "length": 255,
          "name": "overridediskofferingid",
          "related": "createDiskOffering,updateDiskOffering,listDiskOfferings",
          "required": false,
          "since": "4.17",
          "type": "uuid"
        },
        {
          "description": "the ID of the service offering for the virtual machine",
          "length": 255,
          "name": "serviceofferingid",
          "related": "createServiceOffering,updateServiceOffering,listServiceOfferings",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "an optional account for the virtual machine. Must be used with domainId.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "availability zone for the virtual machine",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "destination Host ID to deploy the VM to - parameter available for root admin only",
          "length": 255,
          "name": "hostid",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,addBaremetalHost",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Deployment planner to use for vm allocation. Available to ROOT admin only",
          "length": 255,
          "name": "deploymentplanner",
          "required": false,
          "since": "4.4",
          "type": "string"
        },
        {
          "description": "comma separated list of affinity groups id that are going to be applied to the virtual machine. Mutually exclusive with affinitygroupnames parameter",
          "length": 255,
          "name": "affinitygroupids",
          "related": "",
          "required": false,
          "type": "list"
        },
        {
          "description": "the CIDR list to forward traffic from to the VNF management interface. Multiple entries must be separated by a single comma character (,). The default value is 0.0.0.0/0.",
          "length": 255,
          "name": "vnfcidrlist",
          "required": false,
          "type": "list"
        },
        {
          "description": "Boot into hardware setup or not (ignored if startVm = false, only valid for vmware)",
          "length": 255,
          "name": "bootintosetup",
          "required": false,
          "since": "4.15.0.0",
          "type": "boolean"
        },
        {
          "description": "True by default, security group or network rules (source nat and firewall rules) will be configured for VNF management interfaces. False otherwise. Network rules are configured if management network is an isolated network or shared network with security groups.",
          "length": 255,
          "name": "vnfconfiguremanagement",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,importUnmanagedInstance,importVm",
      "response": [
        {
          "description": "the name of the backup offering of the virtual machine",
          "name": "backupofferingname",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "Vm details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the password (if exists) of the virtual machine",
          "name": "password",
          "type": "string"
        },
        {
          "description": "State of the Service from LB rule",
          "name": "servicestate",
          "type": "string"
        },
        {
          "description": "the type of the template for the virtual machine",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "the number of vCPUs this virtual machine is using",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the id of userdata used for the VM",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the project name of the vm",
          "name": "project",
          "type": "string"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the date when this virtual machine was updated last time",
          "name": "lastupdated",
          "type": "date"
        },
        {
          "description": "device ID of the root volume",
          "name": "rootdeviceid",
          "type": "long"
        },
        {
          "description": "the name of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Mode",
          "name": "bootmode",
          "type": "string"
        },
        {
          "description": "list of variables and values for the variables declared in userdata",
          "name": "userdatadetails",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the ID of the virtual machine",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the pool type of the virtual machine",
          "name": "pooltype",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {},
        {
          "description": "the name of the virtual machine",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the name of the host for the virtual machine",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the user's ID who deployed the virtual machine",
          "name": "userid",
          "type": "string"
        },
        {
          "description": "an optional field whether to the display the vm to the end user or not.",
          "name": "displayvm",
          "type": "boolean"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "the incoming network traffic on the VM in KiB",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "the outgoing network traffic on the host in KiB",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "OS type id of the vm",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "Name of AutoScale VM group",
          "name": "autoscalevmgroupname",
          "type": "string"
        },
        {
          "description": "Base64 string containing the user data",
          "name": "userdata",
          "type": "string"
        },
        {
          "description": "the ID of the availability zone for the virtual machine",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the name of userdata used for the VM",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "the internal memory (KiB) that's free in VM or zero if it can not be calculated",
          "name": "memoryintfreekbs",
          "type": "long"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "List of read-only Vm details as comma separated string.",
          "name": "readonlydetails",
          "type": "string"
        },
        {},
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "true if high-availability is enabled, false otherwise",
          "name": "haenable",
          "type": "boolean"
        },
        {
          "description": "the virtual network for the service offering",
          "name": "forvirtualnetwork",
          "type": "boolean"
        },
        {
          "description": "the ID of the host for the virtual machine",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "the memory used by the VM in KiB",
          "name": "memorykbs",
          "type": "long"
        },
        {
          "description": "the project id of the vm",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the list of nics associated with vm",
          "name": "nic",
          "response": [
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the speed of each vCPU",
          "name": "cpuspeed",
          "type": "integer"
        },
        {
          "description": "NICs of the VNF appliance",
          "name": "vnfnics",
          "type": "list"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the date when this virtual machine was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the amount of the vm's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the memory allocated for the virtual machine",
          "name": "memory",
          "type": "integer"
        },
        {
          "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
          "name": "instancename",
          "type": "string"
        },
        {},
        {
          "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
          "name": "displayname",
          "type": "string"
        },
        {
          "description": "the control state of the host for the virtual machine",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "Os type ID of the virtual machine",
          "name": "guestosid",
          "type": "string"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "VNF details",
          "name": "vnfdetails",
          "type": "map"
        },
        {
          "description": "the vGPU type used by the virtual machine",
          "name": "vgpu",
          "type": "string"
        },
        {
          "description": "the ID of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "the ID of the backup offering of the virtual machine",
          "name": "backupofferingid",
          "type": "string"
        },
        {
          "description": "ssh key-pairs",
          "name": "keypairs",
          "type": "string"
        },
        {
          "description": "the state of the virtual machine",
          "name": "state",
          "type": "string"
        },
        {
          "description": "true if the password rest feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "list of affinity groups associated with the virtual machine",
          "name": "affinitygroup",
          "response": [
            {
              "description": "the ID of the affinity group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the project name of the affinity group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the account owning the affinity group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the project ID of the affinity group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain ID of the affinity group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the name of the affinity group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "virtual machine IDs associated with this affinity group",
              "name": "virtualmachineIds",
              "type": "list"
            },
            {
              "description": "the type of the affinity group",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the description of the affinity group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the domain name of the affinity group",
              "name": "domain",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the name of the availability zone for the virtual machine",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the group ID of the virtual machine",
          "name": "groupid",
          "type": "string"
        },
        {
          "description": "the read (IO) of disk on the VM",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "device type of the root volume",
          "name": "rootdevicetype",
          "type": "string"
        },
        {
          "description": "ID of AutoScale VM group",
          "name": "autoscalevmgroupid",
          "type": "string"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "list of security groups associated with the virtual machine",
          "name": "securitygroup",
          "response": [
            {
              "description": "the list of ingress rules associated with the security group",
              "name": "ingressrule",
              "response": [
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the ID of the security group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the account owning the security group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the domain ID of the security group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the description of the security group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the project id of the group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the list of virtualmachine ids associated with this securitygroup",
              "name": "virtualmachineids",
              "type": "set"
            },
            {
              "description": "the domain name of the security group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the name of the security group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the project name of the group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the number of virtualmachines associated with this securitygroup",
              "name": "virtualmachinecount",
              "type": "integer"
            },
            {
              "description": "the list of egress rules associated with the security group",
              "name": "egressrule",
              "response": [
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                }
              ],
              "type": "set"
            }
          ],
          "type": "set"
        },
        {
          "description": "OS name of the vm",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "the account associated with the virtual machine",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the ID of the domain in which the virtual machine exists",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the write (IO) of disk on the VM",
          "name": "diskiowrite",
          "type": "long"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicipid",
          "type": "string"
        },
        {
          "description": "the user's name who deployed the virtual machine",
          "name": "username",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the target memory in VM (KiB)",
          "name": "memorytargetkbs",
          "type": "long"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "the group name of the virtual machine",
          "name": "group",
          "type": "string"
        },
        {
          "description": "the name of the domain in which the virtual machine exists",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Type",
          "name": "boottype",
          "type": "string"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Updates a network offering.",
      "isasync": false,
      "name": "updateNetworkOffering",
      "params": [
        {
          "description": "the ID of the containing zone(s) as comma separated string, all for all zones offerings",
          "length": 4096,
          "name": "zoneid",
          "required": false,
          "since": "4.13",
          "type": "string"
        },
        {
          "description": "if true keepalive will be turned on in the loadbalancer. At the time of writing this has only an effect on haproxy; the mode http and httpclose options are unset in the haproxy conf file.",
          "length": 255,
          "name": "keepaliveenabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the availability of network offering. The value is Required makes this network offering default for Guest Virtual Networks. Only one network offering can have the value Required ",
          "length": 255,
          "name": "availability",
          "required": false,
          "type": "string"
        },
        {
          "description": "maximum number of concurrent connections supported by the network offering",
          "length": 255,
          "name": "maxconnections",
          "required": false,
          "type": "integer"
        },
        {
          "description": "update state for the network offering",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "the display text of the network offering",
          "length": 255,
          "name": "displaytext",
          "required": false,
          "type": "string"
        },
        {
          "description": "sort key of the network offering, integer",
          "length": 255,
          "name": "sortkey",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the tags for the network offering.",
          "length": 4096,
          "name": "tags",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the containing domain(s) as comma separated string, public for public offerings",
          "length": 255,
          "name": "domainid",
          "required": false,
          "type": "string"
        },
        {
          "description": "the name of the network offering",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "the id of the network offering",
          "length": 255,
          "name": "id",
          "related": "createNetworkOffering,updateNetworkOffering,listNetworkOfferings",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createNetworkOffering,listNetworkOfferings",
      "response": [
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "additional key/value details tied with network offering",
          "name": "details",
          "type": "map"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "state of the network offering. Can be Disabled/Enabled/Inactive",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the tags for the network offering",
          "name": "tags",
          "type": "string"
        },
        {
          "description": "data transfer rate in megabits per second allowed.",
          "name": "networkrate",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the list of supported services",
          "name": "service",
          "response": [
            {
              "description": "the service provider name",
              "name": "provider",
              "response": [
                {
                  "description": "the destination physical network",
                  "name": "destinationphysicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "true if individual services can be enabled/disabled",
                  "name": "canenableindividualservice",
                  "type": "boolean"
                },
                {
                  "description": "state of the network provider",
                  "name": "state",
                  "type": "string"
                },
                {
                  "description": "the provider name",
                  "name": "name",
                  "type": "string"
                },
                {
                  "description": "uuid of the network provider",
                  "name": "id",
                  "type": "string"
                },
                {
                  "description": "the physical network this belongs to",
                  "name": "physicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "services for this provider",
                  "name": "servicelist",
                  "type": "list"
                }
              ],
              "type": "list"
            },
            {
              "description": "the list of capabilities",
              "name": "capability",
              "response": [
                {
                  "description": "the capability value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "can this service capability value can be choosable while creatine network offerings",
                  "name": "canchooseservicecapability",
                  "type": "boolean"
                },
                {
                  "description": "the capability name",
                  "name": "name",
                  "type": "string"
                }
              ],
              "type": "list"
            },
            {
              "description": "the service name",
              "name": "name",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "true if network offering supports persistent networks, false otherwise",
          "name": "ispersistent",
          "type": "boolean"
        },
        {
          "description": "the id of the network offering",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the date this network offering was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "true if network offering supports vlans, false otherwise",
          "name": "specifyvlan",
          "type": "boolean"
        },
        {
          "description": "the domain name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the traffic type for the network offering, supported types are Public, Management, Control, Guest, Vlan or Storage.",
          "name": "traffictype",
          "type": "string"
        },
        {
          "description": "the name of the network offering",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the internet protocol of the network offering",
          "name": "internetprotocol",
          "type": "string"
        },
        {
          "description": "true if network offering supports network that span multiple zones",
          "name": "supportsstrechedl2subnet",
          "type": "boolean"
        },
        {
          "description": "availability of the network offering",
          "name": "availability",
          "type": "string"
        },
        {
          "description": "the zone ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "true if network offering supports specifying ip ranges, false otherwise",
          "name": "specifyipranges",
          "type": "boolean"
        },
        {
          "description": "an alternate display text of the network offering.",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "true if network offering is ip conserve mode enabled",
          "name": "conservemode",
          "type": "boolean"
        },
        {
          "description": "maximum number of concurrents connections to be handled by lb",
          "name": "maxconnections",
          "type": "integer"
        },
        {
          "description": "the domain ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "guest type of the network offering, can be Shared or Isolated",
          "name": "guestiptype",
          "type": "string"
        },
        {
          "description": "true if guest network default egress policy is allow; false if default egress policy is deny",
          "name": "egressdefaultpolicy",
          "type": "boolean"
        },
        {
          "description": "the zone name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zone",
          "type": "string"
        },
        {
          "description": "true if network offering is default, false otherwise",
          "name": "isdefault",
          "type": "boolean"
        },
        {
          "description": "true if network offering supports public access for guest networks",
          "name": "supportspublicaccess",
          "type": "boolean"
        },
        {
          "description": "true if network offering can be used by VPC networks only",
          "name": "forvpc",
          "type": "boolean"
        },
        {
          "description": "the ID of the service offering used by virtual router provider",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "true if network offering can be used by Tungsten-Fabric networks only",
          "name": "fortungsten",
          "type": "boolean"
        }
      ]
    },
    {
      "description": "Stops a system VM.",
      "isasync": true,
      "name": "stopSystemVm",
      "params": [
        {
          "description": "The ID of the system virtual machine",
          "length": 255,
          "name": "id",
          "related": "listSystemVms,migrateSystemVm,startSystemVm,stopSystemVm,changeServiceForSystemVm",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "Force stop the VM (vm is marked as Stopped even when command fails to be send to the backend, otherwise a force poweroff is attempted). To be used if the caller knows the VM is stopped and should be marked as such.",
          "length": 255,
          "name": "forced",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "listSystemVms,migrateSystemVm,startSystemVm,changeServiceForSystemVm",
      "response": [
        {
          "description": "the date and time the system VM was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the number of active console sessions for the console proxy system vm",
          "name": "activeviewersessions",
          "type": "integer"
        },
        {
          "description": "the first DNS for the system VM",
          "name": "dns1",
          "type": "string"
        },
        {},
        {
          "description": "the second DNS for the system VM",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the system virtual machine.",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the host ID for the system VM",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the Zone name for the system VM",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the systemvm agent version",
          "name": "version",
          "type": "string"
        },
        {
          "description": "the public MAC address for the system VM",
          "name": "publicmacaddress",
          "type": "string"
        },
        {
          "description": "the control state of the host for the system VM",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the private IP address for the system VM",
          "name": "privateip",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the last disconnected date of host",
          "name": "disconnected",
          "type": "date"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the agent state of the system VM",
          "name": "agentstate",
          "type": "string"
        },
        {
          "description": "the Pod ID for the system VM",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the link local MAC address for the system vm",
          "name": "linklocalmacaddress",
          "type": "string"
        },
        {
          "description": "the hostname for the system VM",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the link local IP address for the system vm",
          "name": "linklocalip",
          "type": "string"
        },
        {
          "description": "the link local netmask for the system vm",
          "name": "linklocalnetmask",
          "type": "string"
        },
        {
          "description": "the gateway for the system VM",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the Pod name for the system VM",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "guest vlan range",
          "name": "guestvlan",
          "type": "string"
        },
        {
          "description": "the state of the system VM",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the Zone ID for the system VM",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the system VM type",
          "name": "systemvmtype",
          "type": "string"
        },
        {
          "description": "the ID of the system VM",
          "name": "id",
          "type": "string"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {},
        {
          "description": "the name of the system VM",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the public IP address for the system VM",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the template ID for the system VM",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "public vlan range",
          "name": "publicvlan",
          "type": "list"
        },
        {
          "description": "the network domain for the system VM",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the template name for the system VM",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the public netmask for the system VM",
          "name": "publicnetmask",
          "type": "string"
        },
        {
          "description": "the private MAC address for the system VM",
          "name": "privatemacaddress",
          "type": "string"
        },
        {
          "description": "the private netmask for the system VM",
          "name": "privatenetmask",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the system virtual machine.",
          "name": "serviceofferingname",
          "type": "string"
        }
      ]
    },
    {
      "description": "Deletes an egress firewall rule",
      "isasync": true,
      "name": "deleteEgressFirewallRule",
      "params": [
        {
          "description": "the ID of the firewall rule",
          "length": 255,
          "name": "id",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,listIpv6FirewallRules,updateIpv6FirewallRule",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        }
      ]
    },
    {
      "description": "Updates a VPC",
      "isasync": true,
      "name": "updateVPC",
      "params": [
        {
          "description": "the name of the VPC",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "an optional field, whether to the display the vpc to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "the id of the VPC",
          "length": 255,
          "name": "id",
          "related": "createVPC,listVPCs,updateVPC,createVPC,listVPCs,updateVPC,migrateVPC",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "IPV4 address to be assigned to the public interface of the network router. This address must already be acquired for this VPC",
          "length": 255,
          "name": "sourcenatipaddress",
          "required": false,
          "since": "4.19",
          "type": "string"
        },
        {
          "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
          "length": 255,
          "name": "customid",
          "required": false,
          "since": "4.4",
          "type": "string"
        },
        {
          "description": "the display text of the VPC",
          "length": 255,
          "name": "displaytext",
          "required": false,
          "type": "string"
        },
        {
          "description": "MTU to be configured on the network VR's public facing interfaces",
          "length": 255,
          "name": "publicmtu",
          "required": false,
          "since": "4.18.0",
          "type": "integer"
        }
      ],
      "related": "createVPC,listVPCs,createVPC,listVPCs,updateVPC,migrateVPC",
      "response": [
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the owner of the VPC",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the project name of the VPC",
          "name": "project",
          "type": "string"
        },
        {
          "description": "is vpc for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the first IPv4 DNS for the VPC",
          "name": "dns1",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated with the project",
          "name": "tags",
          "response": [
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "true VPC requires restart",
          "name": "restartrequired",
          "type": "boolean"
        },
        {
          "description": "the name of the zone the VPC belongs to",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "state of the VPC. Can be Inactive/Enabled",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the first IPv6 DNS for the VPC",
          "name": "ip6dns1",
          "type": "string"
        },
        {
          "description": "MTU configured on the public interfaces of the VPC VR",
          "name": "publicmtu",
          "type": "integer"
        },
        {},
        {
          "description": "the date this VPC was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the cidr the VPC",
          "name": "cidr",
          "type": "string"
        },
        {
          "description": "The routes for the network to ease adding route in upstream router",
          "name": "ip6routes",
          "type": "set"
        },
        {
          "description": "the second IPv6 DNS for the VPC",
          "name": "ip6dns2",
          "type": "string"
        },
        {
          "description": "vpc offering id the VPC is created from",
          "name": "vpcofferingid",
          "type": "string"
        },
        {
          "description": "the network domain of the VPC",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "is VPC uses distributed router for one hop forwarding and host based network ACL's",
          "name": "distributedvpcrouter",
          "type": "boolean"
        },
        {},
        {
          "description": "the domain name of the owner",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the second IPv4 DNS for the VPC",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "true if VPC is region level",
          "name": "regionlevelvpc",
          "type": "boolean"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "an alternate display text of the VPC.",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the name of the VPC",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the id of the VPC",
          "name": "id",
          "type": "string"
        },
        {
          "description": "zone id of the vpc",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "vpc offering name the VPC is created from",
          "name": "vpcofferingname",
          "type": "string"
        },
        {
          "description": "the list of networks belongign to the VPC",
          "name": "network",
          "type": "list"
        },
        {
          "description": "the list of supported services",
          "name": "service",
          "response": [
            {
              "description": "the list of capabilities",
              "name": "capability",
              "response": [
                {
                  "description": "can this service capability value can be choosable while creatine network offerings",
                  "name": "canchooseservicecapability",
                  "type": "boolean"
                },
                {
                  "description": "the capability value",
                  "name": "value",
                  "type": "string"
                },
                {
                  "description": "the capability name",
                  "name": "name",
                  "type": "string"
                }
              ],
              "type": "list"
            },
            {
              "description": "the service name",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the service provider name",
              "name": "provider",
              "response": [
                {
                  "description": "state of the network provider",
                  "name": "state",
                  "type": "string"
                },
                {
                  "description": "true if individual services can be enabled/disabled",
                  "name": "canenableindividualservice",
                  "type": "boolean"
                },
                {
                  "description": "the destination physical network",
                  "name": "destinationphysicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "services for this provider",
                  "name": "servicelist",
                  "type": "list"
                },
                {
                  "description": "the physical network this belongs to",
                  "name": "physicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "uuid of the network provider",
                  "name": "id",
                  "type": "string"
                },
                {
                  "description": "the provider name",
                  "name": "name",
                  "type": "string"
                }
              ],
              "type": "list"
            }
          ],
          "type": "list"
        },
        {
          "description": "the project id of the VPC",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "if this VPC has redundant router",
          "name": "redundantvpcrouter",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the domain id of the VPC owner",
          "name": "domainid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Changes out-of-band management interface password on the host and updates the interface configuration in CloudStack if the operation succeeds, else reverts the old password",
      "isasync": true,
      "name": "changeOutOfBandManagementPassword",
      "params": [
        {
          "description": "the new host management interface password of maximum length 16, if none is provided a random password would be used",
          "length": 255,
          "name": "password",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the host",
          "length": 255,
          "name": "hostid",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,addBaremetalHost",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "enableOutOfBandManagementForHost,disableOutOfBandManagementForHost,enableOutOfBandManagementForCluster,disableOutOfBandManagementForCluster,enableOutOfBandManagementForZone,issueOutOfBandManagementPowerAction",
      "response": [
        {
          "description": "the operation result description",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the out-of-band management interface port",
          "name": "port",
          "type": "string"
        },
        {
          "description": "the ID of the host",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the operation result",
          "name": "status",
          "type": "boolean"
        },
        {
          "description": "the out-of-band management interface powerState of the host",
          "name": "powerstate",
          "type": "powerstate"
        },
        {},
        {
          "description": "the out-of-band management interface username",
          "name": "username",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the out-of-band management interface address",
          "name": "address",
          "type": "string"
        },
        {
          "description": "true if out-of-band management is enabled for the host",
          "name": "enabled",
          "type": "boolean"
        },
        {
          "description": "the out-of-band management interface password",
          "name": "password",
          "type": "string"
        },
        {},
        {
          "description": "the out-of-band management driver for the host",
          "name": "driver",
          "type": "string"
        },
        {
          "description": "the out-of-band management action (if issued)",
          "name": "action",
          "type": "string"
        }
      ],
      "since": "4.9.0"
    },
    {
      "description": "Lists all IPv6 firewall rules",
      "isasync": false,
      "name": "listIpv6FirewallRules",
      "params": [
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "list ipv6 firewall rules by network ID",
          "length": 255,
          "name": "networkid",
          "related": "createNetwork,updateNetwork,createNetwork,updateNetwork,listNetworks,migrateNetwork,listNetscalerLoadBalancerNetworks,listNiciraNvpDeviceNetworks,listPaloAltoFirewallNetworks,listBrocadeVcsDeviceNetworks",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "Lists ipv6 firewall rule with the specified ID",
          "length": 255,
          "name": "id",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,listIpv6FirewallRules,updateIpv6FirewallRule",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "list ipv6 firewall rules by traffic type - ingress or egress",
          "length": 255,
          "name": "traffictype",
          "required": false,
          "type": "string"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,createIpForwardingRule,listIpForwardingRules,createIpv6FirewallRule,updateIpv6FirewallRule",
      "response": [
        {
          "description": "the ending port of port forwarding rule's private port range",
          "name": "privateendport",
          "type": "string"
        },
        {
          "description": "the vm ip address for the port forwarding rule",
          "name": "vmguestip",
          "type": "string"
        },
        {
          "description": "the id of the guest network the port forwarding rule belongs to",
          "name": "networkid",
          "type": "string"
        },
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the VM name for the port forwarding rule",
          "name": "virtualmachinename",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "is firewall for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the starting port of port forwarding rule's private port range",
          "name": "privateport",
          "type": "string"
        },
        {
          "description": "the ID of the port forwarding rule",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "the VM ID for the port forwarding rule",
          "name": "virtualmachineid",
          "type": "string"
        },
        {
          "description": "the VM display name for the port forwarding rule",
          "name": "virtualmachinedisplayname",
          "type": "string"
        },
        {
          "description": "the public ip address id for the port forwarding rule",
          "name": "ipaddressid",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the cidr list to forward traffic from. Multiple entries are separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {
          "description": "the protocol of the port forwarding rule",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "the public ip address for the port forwarding rule",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the ending port of port forwarding rule's private port range",
          "name": "publicendport",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated with the rule",
          "name": "tags",
          "response": [
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the starting port of port forwarding rule's public port range",
          "name": "publicport",
          "type": "string"
        }
      ]
    },
    {
      "description": "List VM Schedules.",
      "isasync": false,
      "name": "listVMSchedule",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "ID of VM schedule",
          "length": 255,
          "name": "id",
          "related": "createVMSchedule,listVMSchedule,updateVMSchedule",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "ID of the VM for which schedule is to be defined",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "ID of VM schedule",
          "length": 255,
          "name": "enabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "Action taken by schedule",
          "length": 255,
          "name": "action",
          "required": false,
          "type": "string"
        }
      ],
      "related": "createVMSchedule,updateVMSchedule",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "Cron formatted VM schedule",
          "name": "schedule",
          "type": "string"
        },
        {},
        {
          "description": "ID of virtual machine",
          "name": "virtualmachineid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "Action",
          "name": "action",
          "type": "action"
        },
        {
          "description": "Timezone of the schedule",
          "name": "timezone",
          "type": "string"
        },
        {
          "description": "Date after which the schedule becomes inactive",
          "name": "enddate",
          "type": "date"
        },
        {
          "description": "VM schedule is enabled",
          "name": "enabled",
          "type": "boolean"
        },
        {
          "description": "Description of VM schedule",
          "name": "description",
          "type": "string"
        },
        {
          "description": "Date when the schedule was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the ID of VM schedule",
          "name": "id",
          "type": "string"
        },
        {
          "description": "Date from which the schedule is active",
          "name": "startdate",
          "type": "date"
        },
        {}
      ],
      "since": "4.19.0"
    },
    {
      "description": "List resource detail(s)",
      "isasync": false,
      "name": "listResourceDetails",
      "params": [
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list by resource id",
          "length": 255,
          "name": "resourceid",
          "required": false,
          "type": "string"
        },
        {
          "description": "if set to true, only details marked with display=true, are returned. False by default",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.3",
          "type": "boolean"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list by key, value. Needs to be passed only along with key",
          "length": 255,
          "name": "value",
          "required": false,
          "since": "4.4",
          "type": "string"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list by resource type",
          "length": 255,
          "name": "resourcetype",
          "required": true,
          "type": "string"
        },
        {
          "description": "list by key",
          "length": 255,
          "name": "key",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "listTags",
      "response": [
        {},
        {
          "description": "id of the resource",
          "name": "resourceid",
          "type": "string"
        },
        {
          "description": "tag key name",
          "name": "key",
          "type": "string"
        },
        {
          "description": "tag value",
          "name": "value",
          "type": "string"
        },
        {
          "description": "the account associated with the tag",
          "name": "account",
          "type": "string"
        },
        {
          "description": "resource type",
          "name": "resourcetype",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the ID of the domain associated with the tag",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the project id the tag belongs to",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the project name where tag belongs to",
          "name": "project",
          "type": "string"
        },
        {
          "description": "customer associated with the tag",
          "name": "customer",
          "type": "string"
        },
        {
          "description": "the domain associated with the tag",
          "name": "domain",
          "type": "string"
        }
      ],
      "since": "4.2"
    },
    {
      "description": "Attempts to live patch systemVMs - CPVM, SSVM ",
      "isasync": true,
      "name": "patchSystemVm",
      "params": [
        {
          "description": "If true, initiates copy of scripts and restart of the agent, even if the scripts version matches.To be used with ID parameter only",
          "length": 255,
          "name": "forced",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "patches systemVM - CPVM/SSVM with the specified ID",
          "length": 255,
          "name": "id",
          "related": "listSystemVms,migrateSystemVm,startSystemVm,changeServiceForSystemVm",
          "required": false,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {}
      ],
      "since": "4.17.0"
    },
    {
      "description": "Creates a network offering.",
      "isasync": false,
      "name": "createNetworkOffering",
      "params": [
        {
          "description": "Network offering details in key/value pairs. Supported keys are internallbprovider/publiclbprovider with service provider as a value, and promiscuousmode/macaddresschanges/forgedtransmits with true/false as value to accept/reject the security settings if available for a nic/portgroup",
          "length": 255,
          "name": "details",
          "required": false,
          "since": "4.2.0",
          "type": "map"
        },
        {
          "description": "if true keepalive will be turned on in the loadbalancer. At the time of writing this has only an effect on haproxy; the mode http and httpclose options are unset in the haproxy conf file.",
          "length": 255,
          "name": "keepaliveenabled",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "desired service capabilities as part of network offering",
          "length": 255,
          "name": "servicecapabilitylist",
          "required": false,
          "type": "map"
        },
        {
          "description": "true if network offering supports persistent networks; defaulted to false if not specified",
          "length": 255,
          "name": "ispersistent",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the tags for the network offering.",
          "length": 4096,
          "name": "tags",
          "required": false,
          "type": "string"
        },
        {
          "description": "true if guest network default egress policy is allow; false if default egress policy is deny",
          "length": 255,
          "name": "egressdefaultpolicy",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "guest type of the network offering: Shared or Isolated",
          "length": 255,
          "name": "guestiptype",
          "required": true,
          "type": "string"
        },
        {
          "description": "the ID of the containing zone(s), null for public offerings",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "since": "4.13",
          "type": "list"
        },
        {
          "description": "the availability of network offering. The default value is Optional.  Another value is Required, which will make it as the default network offering for new networks ",
          "length": 255,
          "name": "availability",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the containing domain(s), null for public offerings",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "list"
        },
        {
          "description": "true if network offering is meant to be used for VPC, false otherwise.",
          "length": 255,
          "name": "forvpc",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "data transfer rate in megabits per second allowed",
          "length": 255,
          "name": "networkrate",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the display text of the network offering, defaults to the value of 'name'.",
          "length": 255,
          "name": "displaytext",
          "required": false,
          "type": "string"
        },
        {
          "description": "the name of the network offering",
          "length": 255,
          "name": "name",
          "required": true,
          "type": "string"
        },
        {
          "description": "maximum number of concurrent connections supported by the network offering",
          "length": 255,
          "name": "maxconnections",
          "required": false,
          "type": "integer"
        },
        {
          "description": "services supported by the network offering",
          "length": 255,
          "name": "supportedservices",
          "required": false,
          "type": "list"
        },
        {
          "description": "true if network offering is meant to be used for Tungsten-Fabric, false otherwise.",
          "length": 255,
          "name": "fortungsten",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "true if the network offering is IP conserve mode enabled",
          "length": 255,
          "name": "conservemode",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "set to true if the offering is to be enabled during creation. Default is false",
          "length": 255,
          "name": "enable",
          "required": false,
          "since": "4.16",
          "type": "boolean"
        },
        {
          "description": "true if network offering supports vlans",
          "length": 255,
          "name": "specifyvlan",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "provider to service mapping. If not specified, the provider for the service will be mapped to the default provider on the physical network",
          "length": 255,
          "name": "serviceproviderlist",
          "required": false,
          "type": "map"
        },
        {
          "description": "the traffic type for the network offering. Supported type in current release is GUEST only",
          "length": 255,
          "name": "traffictype",
          "required": true,
          "type": "string"
        },
        {
          "description": "the service offering ID used by virtual router provider",
          "length": 255,
          "name": "serviceofferingid",
          "related": "createServiceOffering,updateServiceOffering,listServiceOfferings",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "The internet protocol of network offering. Options are ipv4 and dualstack. Default is ipv4. dualstack will create a network offering that supports both IPv4 and IPv6",
          "length": 255,
          "name": "internetprotocol",
          "required": false,
          "since": "4.17.0",
          "type": "string"
        },
        {
          "description": "true if network offering supports specifying ip ranges; defaulted to false if not specified",
          "length": 255,
          "name": "specifyipranges",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "listNetworkOfferings",
      "response": [
        {
          "description": "true if network offering can be used by VPC networks only",
          "name": "forvpc",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the service offering used by virtual router provider",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the zone name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zone",
          "type": "string"
        },
        {
          "description": "true if network offering supports public access for guest networks",
          "name": "supportspublicaccess",
          "type": "boolean"
        },
        {
          "description": "data transfer rate in megabits per second allowed.",
          "name": "networkrate",
          "type": "integer"
        },
        {
          "description": "true if guest network default egress policy is allow; false if default egress policy is deny",
          "name": "egressdefaultpolicy",
          "type": "boolean"
        },
        {
          "description": "an alternate display text of the network offering.",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the internet protocol of the network offering",
          "name": "internetprotocol",
          "type": "string"
        },
        {
          "description": "state of the network offering. Can be Disabled/Enabled/Inactive",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the domain name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "true if network offering supports specifying ip ranges, false otherwise",
          "name": "specifyipranges",
          "type": "boolean"
        },
        {
          "description": "true if network offering supports network that span multiple zones",
          "name": "supportsstrechedl2subnet",
          "type": "boolean"
        },
        {
          "description": "the name of the network offering",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the list of supported services",
          "name": "service",
          "response": [
            {
              "description": "the service name",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the list of capabilities",
              "name": "capability",
              "response": [
                {
                  "description": "the capability name",
                  "name": "name",
                  "type": "string"
                },
                {
                  "description": "can this service capability value can be choosable while creatine network offerings",
                  "name": "canchooseservicecapability",
                  "type": "boolean"
                },
                {
                  "description": "the capability value",
                  "name": "value",
                  "type": "string"
                }
              ],
              "type": "list"
            },
            {
              "description": "the service provider name",
              "name": "provider",
              "response": [
                {
                  "description": "the physical network this belongs to",
                  "name": "physicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "the provider name",
                  "name": "name",
                  "type": "string"
                },
                {
                  "description": "services for this provider",
                  "name": "servicelist",
                  "type": "list"
                },
                {
                  "description": "state of the network provider",
                  "name": "state",
                  "type": "string"
                },
                {
                  "description": "true if individual services can be enabled/disabled",
                  "name": "canenableindividualservice",
                  "type": "boolean"
                },
                {
                  "description": "the destination physical network",
                  "name": "destinationphysicalnetworkid",
                  "type": "string"
                },
                {
                  "description": "uuid of the network provider",
                  "name": "id",
                  "type": "string"
                }
              ],
              "type": "list"
            }
          ],
          "type": "list"
        },
        {
          "description": "the tags for the network offering",
          "name": "tags",
          "type": "string"
        },
        {},
        {
          "description": "true if network offering supports vlans, false otherwise",
          "name": "specifyvlan",
          "type": "boolean"
        },
        {
          "description": "the domain ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "guest type of the network offering, can be Shared or Isolated",
          "name": "guestiptype",
          "type": "string"
        },
        {
          "description": "true if network offering can be used by Tungsten-Fabric networks only",
          "name": "fortungsten",
          "type": "boolean"
        },
        {
          "description": "the id of the network offering",
          "name": "id",
          "type": "string"
        },
        {
          "description": "additional key/value details tied with network offering",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the traffic type for the network offering, supported types are Public, Management, Control, Guest, Vlan or Storage.",
          "name": "traffictype",
          "type": "string"
        },
        {
          "description": "availability of the network offering",
          "name": "availability",
          "type": "string"
        },
        {
          "description": "maximum number of concurrents connections to be handled by lb",
          "name": "maxconnections",
          "type": "integer"
        },
        {},
        {
          "description": "the date this network offering was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "true if network offering is default, false otherwise",
          "name": "isdefault",
          "type": "boolean"
        },
        {
          "description": "true if network offering supports persistent networks, false otherwise",
          "name": "ispersistent",
          "type": "boolean"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "true if network offering is ip conserve mode enabled",
          "name": "conservemode",
          "type": "boolean"
        },
        {
          "description": "the zone ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zoneid",
          "type": "string"
        }
      ],
      "since": "3.0.0"
    },
    {
      "description": "Dedicate an existing cluster",
      "isasync": true,
      "name": "dedicateCluster",
      "params": [
        {
          "description": "the name of the account which needs dedication. Must be used with domainId.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the containing domain",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the ID of the Cluster",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,updateCluster",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "listDedicatedClusters",
      "response": [
        {
          "description": "the ID of the cluster",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "the domain ID of the cluster",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {},
        {
          "description": "the Account ID of the cluster",
          "name": "accountid",
          "type": "string"
        },
        {
          "description": "the Dedication Affinity Group ID of the cluster",
          "name": "affinitygroupid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the name of the cluster",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "the ID of the dedicated resource",
          "name": "id",
          "type": "string"
        }
      ]
    },
    {
      "description": "Creates an IP forwarding rule",
      "isasync": true,
      "name": "createIpForwardingRule",
      "params": [
        {
          "description": "the end port for the rule",
          "length": 255,
          "name": "endport",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the start port for the rule",
          "length": 255,
          "name": "startport",
          "required": true,
          "type": "integer"
        },
        {
          "description": "the public IP address ID of the forwarding rule, already associated via associateIp",
          "length": 255,
          "name": "ipaddressid",
          "related": "associateIpAddress,listPublicIpAddresses,updateIpAddress,associateIpAddress,listPublicIpAddresses",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the protocol for the rule. Valid values are TCP or UDP.",
          "length": 255,
          "name": "protocol",
          "required": true,
          "type": "string"
        },
        {
          "description": "the CIDR list to forward traffic from. Multiple entries must be separated by a single comma character (,). This parameter is deprecated. Do not use.",
          "length": 255,
          "name": "cidrlist",
          "required": false,
          "type": "list"
        },
        {
          "description": "if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitly. Has value true by default",
          "length": 255,
          "name": "openfirewall",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,listIpForwardingRules,createIpv6FirewallRule,updateIpv6FirewallRule",
      "response": [
        {
          "description": "the ID of the port forwarding rule",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the ending port of port forwarding rule's private port range",
          "name": "privateendport",
          "type": "string"
        },
        {},
        {
          "description": "the vm ip address for the port forwarding rule",
          "name": "vmguestip",
          "type": "string"
        },
        {
          "description": "the VM name for the port forwarding rule",
          "name": "virtualmachinename",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "is firewall for display to the regular user",
          "name": "fordisplay",
          "type": "boolean"
        },
        {
          "description": "the VM ID for the port forwarding rule",
          "name": "virtualmachineid",
          "type": "string"
        },
        {
          "description": "the starting port of port forwarding rule's private port range",
          "name": "privateport",
          "type": "string"
        },
        {
          "description": "the public ip address id for the port forwarding rule",
          "name": "ipaddressid",
          "type": "string"
        },
        {
          "description": "the state of the rule",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the cidr list to forward traffic from. Multiple entries are separated by a single comma character (,).",
          "name": "cidrlist",
          "type": "string"
        },
        {
          "description": "the id of the guest network the port forwarding rule belongs to",
          "name": "networkid",
          "type": "string"
        },
        {
          "description": "the protocol of the port forwarding rule",
          "name": "protocol",
          "type": "string"
        },
        {
          "description": "the ending port of port forwarding rule's private port range",
          "name": "publicendport",
          "type": "string"
        },
        {
          "description": "the starting port of port forwarding rule's public port range",
          "name": "publicport",
          "type": "string"
        },
        {
          "description": "the VM display name for the port forwarding rule",
          "name": "virtualmachinedisplayname",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated with the rule",
          "name": "tags",
          "response": [
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the public ip address for the port forwarding rule",
          "name": "ipaddress",
          "type": "string"
        }
      ]
    },
    {
      "description": "Lists volume metrics",
      "isasync": false,
      "name": "listVolumesMetrics",
      "params": [
        {
          "description": "the ID of the virtual machine",
          "length": 255,
          "name": "virtualmachineid",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVmNicIp,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "state of the volume. Possible values are: Ready, Allocated, Destroy, Expunging, Expunged.",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "list system VMs; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "listsystemvms",
          "required": false,
          "since": "4.18",
          "type": "boolean"
        },
        {
          "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
          "length": 255,
          "name": "displayvolume",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "the cluster id the disk volume belongs to",
          "length": 255,
          "name": "clusterid",
          "related": "addCluster,updateCluster",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list volumes on specified host",
          "length": 255,
          "name": "hostid",
          "related": "addHost,cancelHostMaintenance,cancelHostAsDegraded,declareHostAsDegraded,prepareHostForMaintenance,reconnectHost,addBaremetalHost",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the type of disk volume",
          "length": 255,
          "name": "type",
          "required": false,
          "type": "string"
        },
        {
          "description": "the pod id the disk volume belongs to",
          "length": 255,
          "name": "podid",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the IDs of the volumes, mutually exclusive with id",
          "length": 255,
          "name": "ids",
          "related": "attachVolume,createVolume,updateVolume,detachVolume,listVolumes,migrateVolume,resizeVolume,destroyVolume,recoverVolume,changeOfferingForVolume,attachVolume,createVolume,detachVolume,migrateVolume,resizeVolume,updateVolume,uploadVolume,listVolumes,destroyVolume,recoverVolume,assignVolume",
          "required": false,
          "since": "4.9",
          "type": "list"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the disk volume",
          "length": 255,
          "name": "id",
          "related": "attachVolume,createVolume,updateVolume,detachVolume,listVolumes,migrateVolume,resizeVolume,destroyVolume,recoverVolume,changeOfferingForVolume,attachVolume,createVolume,detachVolume,migrateVolume,resizeVolume,updateVolume,uploadVolume,listVolumes,destroyVolume,recoverVolume,assignVolume",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "the name of the disk volume",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "list volumes by disk offering",
          "length": 255,
          "name": "diskofferingid",
          "related": "createDiskOffering,updateDiskOffering,listDiskOfferings",
          "required": false,
          "since": "4.4",
          "type": "uuid"
        },
        {
          "description": "the ID of the storage pool, available to ROOT admin only",
          "length": 255,
          "name": "storageid",
          "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,syncStoragePool,updateStorageCapabilities",
          "required": false,
          "since": "4.3",
          "type": "string"
        },
        {
          "description": "makes the API's response contains only the resource count",
          "length": 255,
          "name": "retrieveonlyresourcecount",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the ID of the availability zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "ID of the snapshot from which this volume was created",
          "name": "snapshotid",
          "type": "string"
        },
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "pod name of the volume",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.",
          "name": "deviceid",
          "type": "long"
        },
        {
          "description": "the disk utilization",
          "name": "utilization",
          "type": "string"
        },
        {
          "description": "name of the primary storage hosting the disk volume",
          "name": "storage",
          "type": "string"
        },
        {
          "description": "the bytes actually consumed on disk",
          "name": "virtualsize",
          "type": "long"
        },
        {
          "description": "IO requests read rate of the disk volume per the disk offering",
          "name": "diskIopsReadRate",
          "type": "long"
        },
        {
          "description": "id of the virtual machine",
          "name": "virtualmachineid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the total disk iops",
          "name": "diskiopstotal",
          "type": "long"
        },
        {
          "description": "name of the virtual machine",
          "name": "vmname",
          "type": "string"
        },
        {
          "description": "provisioning type used to create volumes.",
          "name": "provisioningtype",
          "type": "string"
        },
        {
          "description": "name of the disk volume",
          "name": "name",
          "type": "string"
        },
        {
          "description": "cluster name where the volume is allocated",
          "name": "clustername",
          "type": "string"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "max iops of the disk volume",
          "name": "maxiops",
          "type": "long"
        },
        {
          "description": "bytes read rate of the disk volume",
          "name": "diskBytesReadRate",
          "type": "long"
        },
        {
          "description": "an optional field whether to the display the volume to the end user or not.",
          "name": "displayvolume",
          "type": "boolean"
        },
        {
          "description": "display name of the virtual machine",
          "name": "vmdisplayname",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "IO requests write rate of the disk volume per the disk offering",
          "name": "diskIopsWriteRate",
          "type": "long"
        },
        {
          "description": "volume uuid that is given by virtualisation provider (only for VMware)",
          "name": "externaluuid",
          "type": "string"
        },
        {
          "description": "the ID of the domain associated with the disk volume",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "size of the disk volume",
          "name": "size",
          "type": "long"
        },
        {
          "description": "the write (IO) of disk on the vm",
          "name": "diskiowrite",
          "type": "long"
        },
        {},
        {
          "description": "ID of the disk volume",
          "name": "id",
          "type": "string"
        },
        {
          "description": "ID of the disk offering",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "the chain info of the volume",
          "name": "chaininfo",
          "type": "string"
        },
        {
          "description": "the read (IO) of disk on the vm",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "the project id of the vpn",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the project name of the vpn",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "need quiesce vm or not when taking snapshot",
          "name": "quiescevm",
          "type": "boolean"
        },
        {
          "description": "name of the disk offering",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "id of the primary storage hosting the disk volume; returned to admin user only",
          "name": "storageid",
          "type": "string"
        },
        {
          "description": "type of the virtual machine",
          "name": "vmtype",
          "type": "string"
        },
        {
          "description": "shared or local storage",
          "name": "storagetype",
          "type": "string"
        },
        {
          "description": "the status of the volume",
          "name": "status",
          "type": "string"
        },
        {
          "description": "disk size in GiB",
          "name": "sizegb",
          "type": "string"
        },
        {
          "description": "state of the virtual machine",
          "name": "vmstate",
          "type": "string"
        },
        {
          "description": "the date the volume was attached to a VM instance",
          "name": "attached",
          "type": "date"
        },
        {
          "description": "the bytes allocated",
          "name": "physicalsize",
          "type": "long"
        },
        {
          "description": "bytes write rate of the disk volume",
          "name": "diskBytesWriteRate",
          "type": "long"
        },
        {
          "description": "name of the service offering for root disk",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "true if storage snapshot is supported for the volume, false otherwise",
          "name": "supportsstoragesnapshot",
          "type": "boolean"
        },
        {
          "description": "the domain associated with the disk volume",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the date the disk volume was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the boolean state of whether the volume is destroyed or not",
          "name": "destroyed",
          "type": "boolean"
        },
        {
          "description": "cluster id of the volume",
          "name": "clusterid",
          "type": "string"
        },
        {
          "description": "ID of the service offering for root disk",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "the path of the volume",
          "name": "path",
          "type": "string"
        },
        {
          "description": "the account associated with the disk volume",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "the state of the disk volume",
          "name": "state",
          "type": "string"
        },
        {
          "description": "Hypervisor the volume belongs to",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the display text of the disk offering",
          "name": "diskofferingdisplaytext",
          "type": "string"
        },
        {
          "description": "name of the availability zone",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "pod id of the volume",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "true if the volume is extractable, false otherwise",
          "name": "isextractable",
          "type": "boolean"
        },
        {
          "description": "the display text of the service offering for root disk",
          "name": "serviceofferingdisplaytext",
          "type": "string"
        },
        {
          "description": "min iops of the disk volume",
          "name": "miniops",
          "type": "long"
        },
        {},
        {
          "description": "ID of the availability zone",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "type of the disk volume (ROOT or DATADISK)",
          "name": "type",
          "type": "string"
        }
      ],
      "since": "4.9.3"
    },
    {
      "description": "Lists the network Interfaces of elastistor",
      "isasync": false,
      "name": "listElastistorInterface",
      "params": [
        {
          "description": "controller id",
          "length": 255,
          "name": "controllerid",
          "required": false,
          "type": "string"
        }
      ],
      "related": "listElastistorVolume",
      "response": [
        {
          "description": "deduplication",
          "name": "deduplication",
          "type": "string"
        },
        {
          "description": "graceallowed",
          "name": "graceallowed",
          "type": "string"
        },
        {
          "description": "compression",
          "name": "compression",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {},
        {
          "description": "synchronization",
          "name": "sync",
          "type": "string"
        },
        {
          "description": "the id of the volume",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the name of the volume",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Lists all possible details and their options for a resource type such as a VM or a template",
      "isasync": false,
      "name": "listDetailOptions",
      "params": [
        {
          "description": "the resource type such as UserVm, Template etc.",
          "length": 255,
          "name": "resourcetype",
          "required": true,
          "type": "string"
        },
        {
          "description": "the UUID of the resource (optional)",
          "length": 255,
          "name": "resourceid",
          "required": false,
          "type": "string"
        }
      ],
      "related": "",
      "response": [
        {},
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "Map of all possible details and their possible list of values",
          "name": "details",
          "type": "map"
        }
      ],
      "since": "4.13"
    },
    {
      "description": "Lists SSL certificates",
      "isasync": false,
      "name": "listSslCerts",
      "params": [
        {
          "description": "ID of SSL certificate",
          "length": 255,
          "name": "certid",
          "related": "uploadSslCert,listSslCerts",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Load balancer rule ID",
          "length": 255,
          "name": "lbruleid",
          "related": "createPortForwardingRule,listPortForwardingRules,updatePortForwardingRule,listIpForwardingRules,createIpv6FirewallRule,updateIpv6FirewallRule",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Account ID",
          "length": 255,
          "name": "accountid",
          "related": "createAccount,disableAccount,enableAccount,updateAccount,markDefaultZoneForAccount,listAccounts,listAccounts",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "Project that owns the SSL certificate",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        }
      ],
      "related": "uploadSslCert",
      "response": [
        {
          "description": "certificate fingerprint",
          "name": "fingerprint",
          "type": "string"
        },
        {
          "description": "account for the certificate",
          "name": "account",
          "type": "string"
        },
        {
          "description": "List of loabalancers this certificate is bound to",
          "name": "loadbalancerrulelist",
          "type": "list"
        },
        {},
        {
          "description": "certificate chain",
          "name": "certchain",
          "type": "string"
        },
        {},
        {
          "description": "name",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the project name of the certificate",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the domain name of the network owner",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "SSL certificate ID",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the project id of the certificate",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the domain id of the network owner",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "certificate",
          "name": "certificate",
          "type": "string"
        }
      ]
    },
    {
      "description": "List private gateways",
      "isasync": false,
      "name": "listPrivateGateways",
      "params": [
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list private gateway by id",
          "length": 255,
          "name": "id",
          "related": "createPrivateGateway,listPrivateGateways,createPrivateGateway,listPrivateGateways",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list gateways by state",
          "length": 255,
          "name": "state",
          "required": false,
          "type": "string"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "list gateways by ip address",
          "length": 255,
          "name": "ipaddress",
          "required": false,
          "type": "string"
        },
        {
          "description": "list gateways by vlan",
          "length": 255,
          "name": "vlan",
          "required": false,
          "type": "string"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list gateways by vpc",
          "length": 255,
          "name": "vpcid",
          "related": "createVPC,listVPCs,createVPC,listVPCs,updateVPC,migrateVPC",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "createPrivateGateway,createPrivateGateway,listPrivateGateways",
      "response": [
        {},
        {
          "description": "ACL Id set for private gateway",
          "name": "aclid",
          "type": "string"
        },
        {},
        {
          "description": "State of the gateway, can be Creating, Ready, Deleting",
          "name": "state",
          "type": "string"
        },
        {
          "description": "zone id of the private gateway",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the gateway",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "ACL name set for private gateway",
          "name": "aclname",
          "type": "string"
        },
        {
          "description": "the private gateway's ip address",
          "name": "ipaddress",
          "type": "string"
        },
        {
          "description": "the name of the Network associated with this private gateway",
          "name": "associatednetwork",
          "type": "string"
        },
        {
          "description": "VPC name the private gateway belongs to",
          "name": "vpcname",
          "type": "string"
        },
        {
          "description": "the ID of the Network associated with this private gateway",
          "name": "associatednetworkid",
          "type": "string"
        },
        {
          "description": "the private gateway's netmask",
          "name": "netmask",
          "type": "string"
        },
        {
          "description": "Source Nat enable status",
          "name": "sourcenatsupported",
          "type": "boolean"
        },
        {
          "description": "the physical network id",
          "name": "physicalnetworkid",
          "type": "string"
        },
        {
          "description": "the name of the zone the private gateway belongs to",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the account associated with the private gateway",
          "name": "account",
          "type": "string"
        },
        {
          "description": "VPC id the private gateway belongs to",
          "name": "vpcid",
          "type": "string"
        },
        {
          "description": "the project id of the private gateway",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the domain associated with the private gateway",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the id of the private gateway",
          "name": "id",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the network implementation uri for the private gateway",
          "name": "vlan",
          "type": "string"
        },
        {
          "description": "the project name of the private gateway",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the ID of the domain associated with the private gateway",
          "name": "domainid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Update the default Ip of a VM Nic",
      "isasync": true,
      "name": "updateVmNicIp",
      "params": [
        {
          "description": "Secondary IP Address",
          "length": 255,
          "name": "ipaddress",
          "required": false,
          "type": "string"
        },
        {
          "description": "the ID of the nic to which you want to assign private IP",
          "length": 255,
          "name": "nicid",
          "related": "listNics",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,importUnmanagedInstance,importVm",
      "response": [
        {
          "description": "the list of nics associated with vm",
          "name": "nic",
          "response": [
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "List of read-only Vm details as comma separated string.",
          "name": "readonlydetails",
          "type": "string"
        },
        {
          "description": "OS name of the vm",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "the group ID of the virtual machine",
          "name": "groupid",
          "type": "string"
        },
        {
          "description": "the name of the host for the virtual machine",
          "name": "hostname",
          "type": "string"
        },
        {
          "description": "the read (IO) of disk on the VM",
          "name": "diskioread",
          "type": "long"
        },
        {
          "description": "the speed of each vCPU",
          "name": "cpuspeed",
          "type": "integer"
        },
        {
          "description": "the VM's disk write in KiB",
          "name": "diskkbswrite",
          "type": "long"
        },
        {
          "description": "ssh key-pairs",
          "name": "keypairs",
          "type": "string"
        },
        {
          "description": "Base64 string representation of the resource icon",
          "name": "icon",
          "type": "resourceiconresponse"
        },
        {
          "description": "the userdata override policy with the userdata provided while deploying VM",
          "name": "userdatapolicy",
          "type": "string"
        },
        {
          "description": "the project name of the vm",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the type of the template for the virtual machine",
          "name": "templatetype",
          "type": "string"
        },
        {
          "description": "NICs of the VNF appliance",
          "name": "vnfnics",
          "type": "list"
        },
        {},
        {
          "description": "the user's name who deployed the virtual machine",
          "name": "username",
          "type": "string"
        },
        {
          "description": "device ID of the root volume",
          "name": "rootdeviceid",
          "type": "long"
        },
        {
          "description": "the incoming network traffic on the VM in KiB",
          "name": "networkkbsread",
          "type": "long"
        },
        {
          "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
          "name": "instancename",
          "type": "string"
        },
        {
          "description": "the ID of the host for the virtual machine",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the backup offering of the virtual machine",
          "name": "backupofferingid",
          "type": "string"
        },
        {
          "description": "the name of the ISO attached to the virtual machine",
          "name": "isoname",
          "type": "string"
        },
        {
          "description": "the name of userdata used for the VM",
          "name": "userdataname",
          "type": "string"
        },
        {
          "description": "the user's ID who deployed the virtual machine",
          "name": "userid",
          "type": "string"
        },
        {
          "description": " an alternate display text of the template for the virtual machine",
          "name": "templatedisplaytext",
          "type": "string"
        },
        {
          "description": "the name of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingname",
          "type": "string"
        },
        {
          "description": "list of security groups associated with the virtual machine",
          "name": "securitygroup",
          "response": [
            {
              "description": "the description of the security group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the ID of the security group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the project name of the group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the project id of the group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain ID of the security group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the list of egress rules associated with the security group",
              "name": "egressrule",
              "response": [
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the list of virtualmachine ids associated with this securitygroup",
              "name": "virtualmachineids",
              "type": "set"
            },
            {
              "description": "the list of resource tags associated with the rule",
              "name": "tags",
              "response": [
                {
                  "description": "resource type",
                  "name": "resourcetype",
                  "type": "string"
                },
                {
                  "description": "the domain associated with the tag",
                  "name": "domain",
                  "type": "string"
                },
                {
                  "description": "the ID of the domain associated with the tag",
                  "name": "domainid",
                  "type": "string"
                },
                {
                  "description": "the account associated with the tag",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "tag key name",
                  "name": "key",
                  "type": "string"
                },
                {
                  "description": "the project name where tag belongs to",
                  "name": "project",
                  "type": "string"
                },
                {
                  "description": "id of the resource",
                  "name": "resourceid",
                  "type": "string"
                },
                {
                  "description": "customer associated with the tag",
                  "name": "customer",
                  "type": "string"
                },
                {
                  "description": "the project id the tag belongs to",
                  "name": "projectid",
                  "type": "string"
                },
                {
                  "description": "tag value",
                  "name": "value",
                  "type": "string"
                }
              ],
              "type": "set"
            },
            {
              "description": "the domain name of the security group",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "the list of ingress rules associated with the security group",
              "name": "ingressrule",
              "response": [
                {
                  "description": "the ending IP of the security group rule ",
                  "name": "endport",
                  "type": "integer"
                },
                {
                  "description": "the list of resource tags associated with the rule",
                  "name": "tags",
                  "response": [
                    {
                      "description": "id of the resource",
                      "name": "resourceid",
                      "type": "string"
                    },
                    {
                      "description": "the ID of the domain associated with the tag",
                      "name": "domainid",
                      "type": "string"
                    },
                    {
                      "description": "the project name where tag belongs to",
                      "name": "project",
                      "type": "string"
                    },
                    {
                      "description": "tag value",
                      "name": "value",
                      "type": "string"
                    },
                    {
                      "description": "the project id the tag belongs to",
                      "name": "projectid",
                      "type": "string"
                    },
                    {
                      "description": "customer associated with the tag",
                      "name": "customer",
                      "type": "string"
                    },
                    {
                      "description": "tag key name",
                      "name": "key",
                      "type": "string"
                    },
                    {
                      "description": "resource type",
                      "name": "resourcetype",
                      "type": "string"
                    },
                    {
                      "description": "the domain associated with the tag",
                      "name": "domain",
                      "type": "string"
                    },
                    {
                      "description": "the account associated with the tag",
                      "name": "account",
                      "type": "string"
                    }
                  ],
                  "type": "set"
                },
                {
                  "description": "the id of the security group rule",
                  "name": "ruleid",
                  "type": "string"
                },
                {
                  "description": "the CIDR notation for the base IP address of the security group rule",
                  "name": "cidr",
                  "type": "string"
                },
                {
                  "description": "the code for the ICMP message response",
                  "name": "icmpcode",
                  "type": "integer"
                },
                {
                  "description": "the type of the ICMP message response",
                  "name": "icmptype",
                  "type": "integer"
                },
                {
                  "description": "security group name",
                  "name": "securitygroupname",
                  "type": "string"
                },
                {
                  "description": "the protocol of the security group rule",
                  "name": "protocol",
                  "type": "string"
                },
                {
                  "description": "account owning the security group rule",
                  "name": "account",
                  "type": "string"
                },
                {
                  "description": "the starting IP of the security group rule",
                  "name": "startport",
                  "type": "integer"
                }
              ],
              "type": "set"
            },
            {
              "description": "the name of the security group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the number of virtualmachines associated with this securitygroup",
              "name": "virtualmachinecount",
              "type": "integer"
            },
            {
              "description": "the account owning the security group",
              "name": "account",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the memory allocated for the virtual machine",
          "name": "memory",
          "type": "integer"
        },
        {
          "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
          "name": "displayname",
          "type": "string"
        },
        {
          "description": "the name of the virtual machine",
          "name": "name",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Type",
          "name": "boottype",
          "type": "string"
        },
        {
          "description": "the number of vCPUs this virtual machine is using",
          "name": "cpunumber",
          "type": "integer"
        },
        {
          "description": "the ID of the domain in which the virtual machine exists",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the virtual network for the service offering",
          "name": "forvirtualnetwork",
          "type": "boolean"
        },
        {
          "description": "the amount of the vm's CPU currently used",
          "name": "cpuused",
          "type": "string"
        },
        {
          "description": "the ID of the virtual machine",
          "name": "id",
          "type": "string"
        },
        {
          "description": "device type of the root volume",
          "name": "rootdevicetype",
          "type": "string"
        },
        {},
        {
          "description": "OS type id of the vm",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "the date when this virtual machine was updated last time",
          "name": "lastupdated",
          "type": "date"
        },
        {
          "description": "the VM's disk read in KiB",
          "name": "diskkbsread",
          "type": "long"
        },
        {
          "description": "the total number of network traffic bytes received",
          "name": "receivedbytes",
          "type": "long"
        },
        {
          "description": "Os type ID of the virtual machine",
          "name": "guestosid",
          "type": "string"
        },
        {
          "description": "an optional field whether to the display the vm to the end user or not.",
          "name": "displayvm",
          "type": "boolean"
        },
        {
          "description": "VNF details",
          "name": "vnfdetails",
          "type": "map"
        },
        {
          "description": "the target memory in VM (KiB)",
          "name": "memorytargetkbs",
          "type": "long"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "list of affinity groups associated with the virtual machine",
          "name": "affinitygroup",
          "response": [
            {
              "description": "the account owning the affinity group",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the type of the affinity group",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the name of the affinity group",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the ID of the affinity group",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the project name of the affinity group",
              "name": "project",
              "type": "string"
            },
            {
              "description": "virtual machine IDs associated with this affinity group",
              "name": "virtualmachineIds",
              "type": "list"
            },
            {
              "description": "the description of the affinity group",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the domain ID of the affinity group",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the project ID of the affinity group",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the domain name of the affinity group",
              "name": "domain",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the ID of the disk offering of the virtual machine. This parameter should not be used for retrieving disk offering details of DATA volumes. Use listVolumes API instead",
          "name": "diskofferingid",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "Guest vm Boot Mode",
          "name": "bootmode",
          "type": "string"
        },
        {
          "description": "the state of the virtual machine",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the vGPU type used by the virtual machine",
          "name": "vgpu",
          "type": "string"
        },
        {
          "description": "the pool type of the virtual machine",
          "name": "pooltype",
          "type": "string"
        },
        {
          "description": "Base64 string containing the user data",
          "name": "userdata",
          "type": "string"
        },
        {
          "description": "the name of the availability zone for the virtual machine",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the name of the domain in which the virtual machine exists",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "an alternate display text of the ISO attached to the virtual machine",
          "name": "isodisplaytext",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the ID of the ISO attached to the virtual machine",
          "name": "isoid",
          "type": "string"
        },
        {
          "description": "list of variables and values for the variables declared in userdata",
          "name": "userdatadetails",
          "type": "string"
        },
        {
          "description": "true if the password rest feature is enabled, false otherwise",
          "name": "passwordenabled",
          "type": "boolean"
        },
        {
          "description": "the name of the template for the virtual machine",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "Vm details in key/value pairs.",
          "name": "details",
          "type": "map"
        },
        {
          "description": "the total number of network traffic bytes sent",
          "name": "sentbytes",
          "type": "long"
        },
        {
          "description": "the control state of the host for the virtual machine",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the write (IO) of disk on the VM",
          "name": "diskiowrite",
          "type": "long"
        },
        {
          "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
          "name": "isdynamicallyscalable",
          "type": "boolean"
        },
        {
          "description": "the password (if exists) of the virtual machine",
          "name": "password",
          "type": "string"
        },
        {
          "description": "ID of AutoScale VM group",
          "name": "autoscalevmgroupid",
          "type": "string"
        },
        {
          "description": "the date when this virtual machine was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the memory used by the VM in KiB",
          "name": "memorykbs",
          "type": "long"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the outgoing network traffic on the host in KiB",
          "name": "networkkbswrite",
          "type": "long"
        },
        {
          "description": "public IP address id associated with vm via Static nat rule",
          "name": "publicipid",
          "type": "string"
        },
        {
          "description": "the id of userdata used for the VM",
          "name": "userdataid",
          "type": "string"
        },
        {
          "description": "the project id of the vm",
          "name": "projectid",
          "type": "string"
        },
        {},
        {
          "description": "Name of AutoScale VM group",
          "name": "autoscalevmgroupname",
          "type": "string"
        },
        {
          "description": "the internal memory (KiB) that's free in VM or zero if it can not be calculated",
          "name": "memoryintfreekbs",
          "type": "long"
        },
        {
          "description": "the group name of the virtual machine",
          "name": "group",
          "type": "string"
        },
        {
          "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the ID of the availability zone for the virtual machine",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the account associated with the virtual machine",
          "name": "account",
          "type": "string"
        },
        {
          "description": "true if high-availability is enabled, false otherwise",
          "name": "haenable",
          "type": "boolean"
        },
        {
          "description": "the name of the backup offering of the virtual machine",
          "name": "backupofferingname",
          "type": "string"
        },
        {
          "description": "State of the Service from LB rule",
          "name": "servicestate",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            }
          ],
          "type": "set"
        }
      ]
    },
    {
      "description": "Updates load balancer stickiness policy",
      "isasync": true,
      "name": "updateLBStickinessPolicy",
      "params": [
        {
          "description": "id of lb stickiness policy",
          "length": 255,
          "name": "id",
          "related": "createLBStickinessPolicy,listLBStickinessPolicies,updateLBStickinessPolicy",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "an optional field, whether to the display the policy to the end user or not",
          "length": 255,
          "name": "fordisplay",
          "required": false,
          "since": "4.4",
          "type": "boolean"
        },
        {
          "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
          "length": 255,
          "name": "customid",
          "required": false,
          "since": "4.4",
          "type": "string"
        }
      ],
      "related": "createLBStickinessPolicy,listLBStickinessPolicies",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the description of the Stickiness policy",
          "name": "description",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the domain ID of the Stickiness policy",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the id of the zone the Stickiness policy belongs to",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the account of the Stickiness policy",
          "name": "account",
          "type": "string"
        },
        {
          "description": "the name of the Stickiness policy",
          "name": "name",
          "type": "string"
        },
        {},
        {
          "description": "the state of the policy",
          "name": "state",
          "type": "string"
        },
        {
          "description": "the list of stickinesspolicies",
          "name": "stickinesspolicy",
          "response": [
            {
              "description": "is policy for display to the regular user",
              "name": "fordisplay",
              "type": "boolean"
            },
            {
              "description": "the description of the Stickiness policy",
              "name": "description",
              "type": "string"
            },
            {
              "description": "the state of the policy",
              "name": "state",
              "type": "string"
            },
            {
              "description": "the name of the Stickiness policy",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the method name of the Stickiness policy",
              "name": "methodname",
              "type": "string"
            },
            {
              "description": "the LB Stickiness policy ID",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the params of the policy",
              "name": "params",
              "type": "map"
            }
          ],
          "type": "list"
        },
        {
          "description": "the domain of the Stickiness policy",
          "name": "domain",
          "type": "string"
        },
        {},
        {
          "description": "the LB rule ID",
          "name": "lbruleid",
          "type": "string"
        }
      ],
      "since": "4.4"
    },
    {
      "description": "Lists all Pods.",
      "isasync": false,
      "name": "listPods",
      "params": [
        {
          "description": "list Pods by Zone ID",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list pods by allocation state",
          "length": 255,
          "name": "allocationstate",
          "required": false,
          "type": "string"
        },
        {
          "description": "list Pods by name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "list Pods by ID",
          "length": 255,
          "name": "id",
          "related": "listPods,updatePod,createManagementNetworkIpRange",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "flag to display the capacity of the pods",
          "length": 255,
          "name": "showcapacities",
          "required": false,
          "type": "boolean"
        }
      ],
      "related": "updatePod,createManagementNetworkIpRange",
      "response": [
        {
          "description": "the IP ranges for the Pod",
          "name": "ipranges",
          "response": [
            {
              "description": "indicates Vlan ID for the range",
              "name": "vlanid",
              "type": "string"
            },
            {
              "description": "the gateway for the range",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the ending IP for the range",
              "name": "endip",
              "type": "string"
            },
            {
              "description": "the starting IP for the range",
              "name": "startip",
              "type": "string"
            },
            {
              "description": "the CIDR for the range",
              "name": "cidr",
              "type": "string"
            },
            {
              "description": "indicates if range is dedicated for CPVM and SSVM",
              "name": "forsystemvms",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "the capacity of the Pod",
          "name": "capacity",
          "response": [
            {
              "description": "the capacity name",
              "name": "name",
              "type": "string"
            },
            {
              "description": "the Zone ID",
              "name": "zoneid",
              "type": "string"
            },
            {
              "description": "the total capacity available",
              "name": "capacitytotal",
              "type": "long"
            },
            {
              "description": "the Pod name",
              "name": "podname",
              "type": "string"
            },
            {
              "description": "the capacity currently in use",
              "name": "capacityused",
              "type": "long"
            },
            {
              "description": "the Cluster name",
              "name": "clustername",
              "type": "string"
            },
            {
              "description": "the Zone name",
              "name": "zonename",
              "type": "string"
            },
            {
              "description": "the Pod ID",
              "name": "podid",
              "type": "string"
            },
            {
              "description": "the capacity currently in allocated",
              "name": "capacityallocated",
              "type": "long"
            },
            {
              "description": "the percentage of capacity currently in use",
              "name": "percentused",
              "type": "string"
            },
            {
              "description": "the capacity type",
              "name": "type",
              "type": "short"
            },
            {
              "description": "the Cluster ID",
              "name": "clusterid",
              "type": "string"
            }
          ],
          "type": "list"
        },
        {
          "description": "indicates Vlan ID for the range. This parameter is deprecated, please use 'vlanid' from ipranges parameter.",
          "name": "vlanid",
          "type": "list"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the gateway of the Pod",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the starting IP for the Pod. This parameter is deprecated, please use 'startip' from ipranges parameter.",
          "name": "startip",
          "type": "list"
        },
        {
          "description": "the name of the Pod",
          "name": "name",
          "type": "string"
        },
        {},
        {},
        {
          "description": "the Zone ID of the Pod",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "indicates if range is dedicated for CPVM and SSVM. This parameter is deprecated, please use 'forsystemvms' from ipranges parameter.",
          "name": "forsystemvms",
          "type": "list"
        },
        {
          "description": "the ending IP for the Pod. This parameter is deprecated, please use 'endip' from ipranges parameter.",
          "name": "endip",
          "type": "list"
        },
        {
          "description": "the ID of the Pod",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the Zone name of the Pod",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the netmask of the Pod",
          "name": "netmask",
          "type": "string"
        },
        {
          "description": "the allocation state of the Pod",
          "name": "allocationstate",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        }
      ]
    },
    {
      "description": "Starts an existing internal lb vm.",
      "isasync": true,
      "name": "startInternalLoadBalancerVM",
      "params": [
        {
          "description": "the ID of the internal lb vm",
          "length": 255,
          "name": "id",
          "related": "destroyRouter,listRouters,rebootRouter,changeServiceForRouter,stopInternalLoadBalancerVM,startInternalLoadBalancerVM,listInternalLoadBalancerVMs,stopNetScalerVpx",
          "required": true,
          "type": "uuid"
        }
      ],
      "related": "destroyRouter,listRouters,rebootRouter,changeServiceForRouter,stopInternalLoadBalancerVM,listInternalLoadBalancerVMs,stopNetScalerVpx",
      "response": [
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the name of the router",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the domain ID associated with the router",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "the first DNS for the router",
          "name": "dns1",
          "type": "string"
        },
        {
          "description": "the date and time the router was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the ID of the corresponding link local network",
          "name": "linklocalnetworkid",
          "type": "string"
        },
        {
          "description": "the Zone ID for the router",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "the state of the router",
          "name": "state",
          "type": "state"
        },
        {
          "description": "true if the router template requires upgrader",
          "name": "requiresupgrade",
          "type": "boolean"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the second DNS for the router",
          "name": "dns2",
          "type": "string"
        },
        {
          "description": "the first IPv6 DNS for the router",
          "name": "ip6dns1",
          "type": "string"
        },
        {
          "description": "the hypervisor on which the template runs",
          "name": "hypervisor",
          "type": "string"
        },
        {
          "description": "the ID of the service offering of the virtual machine",
          "name": "serviceofferingid",
          "type": "string"
        },
        {
          "description": "true if any health checks had failed",
          "name": "healthchecksfailed",
          "type": "boolean"
        },
        {
          "description": "if this router is an redundant virtual router",
          "name": "isredundantrouter",
          "type": "boolean"
        },
        {
          "description": "role of the domain router",
          "name": "role",
          "type": "string"
        },
        {
          "description": "the Pod ID for the router",
          "name": "podid",
          "type": "string"
        },
        {
          "description": "the name of VPC the router belongs to",
          "name": "vpcname",
          "type": "string"
        },
        {
          "description": "the project name of the address",
          "name": "project",
          "type": "string"
        },
        {
          "description": "the control state of the host for the router",
          "name": "hostcontrolstate",
          "type": "string"
        },
        {
          "description": "the Zone name for the router",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the template ID for the router",
          "name": "templateid",
          "type": "string"
        },
        {
          "description": "the link local netmask for the router",
          "name": "linklocalnetmask",
          "type": "string"
        },
        {
          "description": "the list of nics associated with the router",
          "name": "nic",
          "response": [
            {
              "description": "ID of the VLAN/VNI if available",
              "name": "vlanid",
              "type": "integer"
            },
            {
              "description": "the gateway of IPv6 network",
              "name": "ip6gateway",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN if available",
              "name": "isolatedpvlan",
              "type": "integer"
            },
            {
              "description": "Id of the vm to which the nic belongs",
              "name": "virtualmachineid",
              "type": "string"
            },
            {
              "description": "name of the vpc to which the nic belongs",
              "name": "vpcname",
              "type": "string"
            },
            {
              "description": "the ID of the nic",
              "name": "id",
              "type": "string"
            },
            {
              "description": "the type of the nic",
              "name": "type",
              "type": "string"
            },
            {
              "description": "the isolation uri of the nic",
              "name": "isolationuri",
              "type": "string"
            },
            {
              "description": "IP addresses associated with NIC found for unmanaged VM",
              "name": "ipaddresses",
              "type": "list"
            },
            {
              "description": "Type of adapter if available",
              "name": "adaptertype",
              "type": "string"
            },
            {
              "description": "device id for the network when plugged into the virtual machine",
              "name": "deviceid",
              "type": "string"
            },
            {
              "description": "public IP address id associated with this nic via Static nat rule",
              "name": "publicipid",
              "type": "string"
            },
            {
              "description": "Id of the NSX Logical Switch (if NSX based), null otherwise",
              "name": "nsxlogicalswitch",
              "type": "string"
            },
            {
              "description": "the Secondary ipv4 addr of nic",
              "name": "secondaryip",
              "type": "list"
            },
            {
              "description": "the name of the corresponding network",
              "name": "networkname",
              "type": "string"
            },
            {
              "description": "the cidr of IPv6 network",
              "name": "ip6cidr",
              "type": "string"
            },
            {
              "description": "the ip address of the nic",
              "name": "ipaddress",
              "type": "string"
            },
            {
              "description": "the gateway of the nic",
              "name": "gateway",
              "type": "string"
            },
            {
              "description": "the extra dhcp options on the nic",
              "name": "extradhcpoption",
              "type": "list"
            },
            {
              "description": "Id of the NSX Logical Switch Port (if NSX based), null otherwise",
              "name": "nsxlogicalswitchport",
              "type": "string"
            },
            {
              "description": "MTU configured on the NIC",
              "name": "mtu",
              "type": "integer"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "macaddress",
              "type": "string"
            },
            {
              "description": "the ID of the corresponding network",
              "name": "networkid",
              "type": "string"
            },
            {
              "description": "true if nic is default, false otherwise",
              "name": "isdefault",
              "type": "boolean"
            },
            {
              "description": "the traffic type of the nic",
              "name": "traffictype",
              "type": "string"
            },
            {
              "description": "the isolated private VLAN type if available",
              "name": "isolatedpvlantype",
              "type": "string"
            },
            {
              "description": "the broadcast uri of the nic",
              "name": "broadcasturi",
              "type": "string"
            },
            {
              "description": "the netmask of the nic",
              "name": "netmask",
              "type": "string"
            },
            {
              "description": "public IP address associated with this nic via Static nat rule",
              "name": "publicip",
              "type": "string"
            },
            {
              "description": "Id of the vpc to which the nic belongs",
              "name": "vpcid",
              "type": "string"
            },
            {
              "description": "the IPv6 address of network",
              "name": "ip6address",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "the version of template",
          "name": "version",
          "type": "string"
        },
        {},
        {
          "description": "the template name for the router",
          "name": "templatename",
          "type": "string"
        },
        {
          "description": "the project id of the ipaddress",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the version of the code / software in the router",
          "name": "softwareversion",
          "type": "string"
        },
        {
          "description": "the ID of the corresponding public network",
          "name": "publicnetworkid",
          "type": "string"
        },
        {
          "description": "the state of redundant virtual router",
          "name": "redundantstate",
          "type": "string"
        },
        {
          "description": "the id of the router",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the domain associated with the router",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the Pod name for the router",
          "name": "podname",
          "type": "string"
        },
        {
          "description": "the public IP address for the router",
          "name": "publicip",
          "type": "string"
        },
        {
          "description": "the network domain for the router",
          "name": "networkdomain",
          "type": "string"
        },
        {
          "description": "the public netmask for the router",
          "name": "publicnetmask",
          "type": "string"
        },
        {
          "description": "the version of scripts",
          "name": "scriptsversion",
          "type": "string"
        },
        {
          "description": "the second IPv6 DNS for the router",
          "name": "ip6dns2",
          "type": "string"
        },
        {
          "description": "the link local IP address for the router",
          "name": "linklocalip",
          "type": "string"
        },
        {
          "description": "Last executed health check result for the router",
          "name": "healthcheckresults",
          "response": [
            {
              "description": "the name of the health check on the router",
              "name": "checkname",
              "type": "string"
            },
            {
              "description": "the type of the health check - basic or advanced",
              "name": "checktype",
              "type": "string"
            },
            {
              "description": "the date this VPC was created",
              "name": "lastupdated",
              "type": "date"
            },
            {
              "description": "detailed response generated on running health check",
              "name": "details",
              "type": "string"
            },
            {
              "description": "result of the health check",
              "name": "success",
              "type": "boolean"
            }
          ],
          "type": "list"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the ID of the corresponding guest network",
          "name": "guestnetworkid",
          "type": "string"
        },
        {
          "description": "the name of the corresponding guest network",
          "name": "guestnetworkname",
          "type": "string"
        },
        {
          "description": "the guest netmask for the router",
          "name": "guestnetmask",
          "type": "string"
        },
        {
          "description": "the name of the service offering of the virtual machine",
          "name": "serviceofferingname",
          "type": "string"
        },
        {
          "description": "the link local MAC address for the router",
          "name": "linklocalmacaddress",
          "type": "string"
        },
        {
          "description": "VPC the router belongs to",
          "name": "vpcid",
          "type": "string"
        },
        {
          "description": "the gateway for the router",
          "name": "gateway",
          "type": "string"
        },
        {
          "description": "the guest IP address for the router",
          "name": "guestipaddress",
          "type": "string"
        },
        {
          "description": "the guest MAC address for the router",
          "name": "guestmacaddress",
          "type": "string"
        },
        {
          "description": "the public MAC address for the router",
          "name": "publicmacaddress",
          "type": "string"
        },
        {
          "description": "the account associated with the router",
          "name": "account",
          "type": "string"
        },
        {},
        {
          "description": "the host ID for the router",
          "name": "hostid",
          "type": "string"
        },
        {
          "description": "the hostname for the router",
          "name": "hostname",
          "type": "string"
        }
      ]
    },
    {
      "description": "Updates a disk offering.",
      "isasync": false,
      "name": "updateDiskOffering",
      "params": [
        {
          "description": "comma-separated list of tags for the disk offering, tags should match with existing storage pool tags",
          "length": 255,
          "name": "tags",
          "required": false,
          "since": "4.15",
          "type": "string"
        },
        {
          "description": "burst bytes read rate of the disk offering",
          "length": 255,
          "name": "bytesreadratemax",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "an optional field, whether to display the offering to the end user or not.",
          "length": 255,
          "name": "displayoffering",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "the ID of the containing zone(s) as comma separated string, all for all zones offerings",
          "length": 255,
          "name": "zoneid",
          "required": false,
          "since": "4.13",
          "type": "string"
        },
        {
          "description": "length (in seconds) of the burst",
          "length": 255,
          "name": "iopswriteratemaxlength",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "burst requests read rate of the disk offering",
          "length": 255,
          "name": "iopsreadratemax",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "updates name of the disk offering with this value",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        },
        {
          "description": "burst bytes write rate of the disk offering",
          "length": 255,
          "name": "byteswriteratemax",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "burst io requests write rate of the disk offering",
          "length": 255,
          "name": "iopswriteratemax",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "length (in seconds) of the burst",
          "length": 255,
          "name": "iopsreadratemaxlength",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "length (in seconds) of the burst",
          "length": 255,
          "name": "bytesreadratemaxlength",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "bytes write rate of the disk offering",
          "length": 255,
          "name": "byteswriterate",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "sort key of the disk offering, integer",
          "length": 255,
          "name": "sortkey",
          "required": false,
          "type": "integer"
        },
        {
          "description": "bytes read rate of the disk offering",
          "length": 255,
          "name": "bytesreadrate",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "ID of the disk offering",
          "length": 255,
          "name": "id",
          "related": "createDiskOffering,updateDiskOffering,listDiskOfferings",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the ID of the containing domain(s) as comma separated string, public for public offerings",
          "length": 4096,
          "name": "domainid",
          "required": false,
          "since": "4.13",
          "type": "string"
        },
        {
          "description": "the cache mode to use for this disk offering",
          "length": 255,
          "name": "cachemode",
          "required": false,
          "since": "4.15",
          "type": "string"
        },
        {
          "description": "io requests read rate of the disk offering",
          "length": 255,
          "name": "iopsreadrate",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "updates alternate display text of the disk offering with this value",
          "length": 4096,
          "name": "displaytext",
          "required": false,
          "type": "string"
        },
        {
          "description": "io requests write rate of the disk offering",
          "length": 255,
          "name": "iopswriterate",
          "required": false,
          "since": "4.15",
          "type": "long"
        },
        {
          "description": "length (in seconds) of the burst",
          "length": 255,
          "name": "byteswriteratemaxlength",
          "required": false,
          "since": "4.15",
          "type": "long"
        }
      ],
      "related": "createDiskOffering,listDiskOfferings",
      "response": [
        {
          "description": "the date this disk offering was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "the cache mode to use for this disk offering. none, writeback or writethrough",
          "name": "cacheMode",
          "type": "string"
        },
        {
          "description": "bytes write rate of the disk offering",
          "name": "diskBytesWriteRate",
          "type": "long"
        },
        {
          "description": "provisioning type used to create volumes. Valid values are thin, sparse, fat.",
          "name": "provisioningtype",
          "type": "string"
        },
        {
          "description": "bytes read rate of the disk offering",
          "name": "diskBytesReadRate",
          "type": "long"
        },
        {
          "description": "Whether disks using this offering will be encrypted on primary storage",
          "name": "encrypt",
          "type": "boolean"
        },
        {
          "description": "length (in seconds) of the burst",
          "name": "diskIopsWriteRateMaxLength",
          "type": "long"
        },
        {},
        {
          "description": "an alternate display text of the disk offering.",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "length (in seconds) of the burst",
          "name": "diskBytesWriteRateMaxLength",
          "type": "long"
        },
        {
          "description": "burst io requests write rate of the disk offering",
          "name": "diskIopsWriteRateMax",
          "type": "long"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "Hypervisor snapshot reserve space as a percent of a volume (for managed storage using Xen or VMware)",
          "name": "hypervisorsnapshotreserve",
          "type": "integer"
        },
        {
          "description": "io requests read rate of the disk offering",
          "name": "diskIopsReadRate",
          "type": "long"
        },
        {
          "description": "burst bytes write rate of the disk offering",
          "name": "diskBytesWriteRateMax",
          "type": "long"
        },
        {
          "description": "length (in seconds) of the burst",
          "name": "diskBytesReadRateMaxLength",
          "type": "long"
        },
        {
          "description": "length (in second) of the burst",
          "name": "diskIopsReadRateMaxLength",
          "type": "long"
        },
        {
          "description": "the zone name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zone",
          "type": "string"
        },
        {
          "description": "true if disk offering uses custom iops, false otherwise",
          "name": "iscustomizediops",
          "type": "boolean"
        },
        {
          "description": "the zone ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "whether to display the offering to the end user or not.",
          "name": "displayoffering",
          "type": "boolean"
        },
        {
          "description": "the domain ID(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "To allow or disallow the resize operation on the disks created from this disk offering, if the flag is true then resize is not allowed",
          "name": "disksizestrictness",
          "type": "boolean"
        },
        {
          "description": "the min iops of the disk offering",
          "name": "miniops",
          "type": "long"
        },
        {
          "description": "the storage type for this disk offering",
          "name": "storagetype",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the domain name(s) this disk offering belongs to. Ignore this information as it is not currently applicable.",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "the vsphere storage policy tagged to the disk offering in case of VMware",
          "name": "vspherestoragepolicy",
          "type": "string"
        },
        {
          "description": "additional key/value details tied with this disk offering",
          "name": "details",
          "type": "map"
        },
        {
          "description": "true if disk offering uses custom size, false otherwise",
          "name": "iscustomized",
          "type": "boolean"
        },
        {
          "description": "io requests write rate of the disk offering",
          "name": "diskIopsWriteRate",
          "type": "long"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "burst bytes read rate of the disk offering",
          "name": "diskBytesReadRateMax",
          "type": "long"
        },
        {
          "description": "burst io requests read rate of the disk offering",
          "name": "diskIopsReadRateMax",
          "type": "long"
        },
        {},
        {
          "description": "unique ID of the disk offering",
          "name": "id",
          "type": "string"
        },
        {
          "description": "the size of the disk offering in GB",
          "name": "disksize",
          "type": "long"
        },
        {
          "description": "the name of the disk offering",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the max iops of the disk offering",
          "name": "maxiops",
          "type": "long"
        },
        {
          "description": "the tags for the disk offering",
          "name": "tags",
          "type": "string"
        }
      ]
    },
    {
      "description": "delete Tungsten-Fabric address group",
      "isasync": true,
      "name": "deleteTungstenFabricAddressGroup",
      "params": [
        {
          "description": "the uuid of Tungsten-Fabric address group",
          "length": 255,
          "name": "addressgroupuuid",
          "required": true,
          "type": "string"
        },
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {}
      ]
    },
    {
      "description": "Stops a running CloudManaged Kubernetes cluster",
      "isasync": true,
      "name": "stopKubernetesCluster",
      "params": [
        {
          "description": "the ID of the Kubernetes cluster",
          "length": 255,
          "name": "id",
          "related": "createKubernetesCluster,startKubernetesCluster,listKubernetesClusters,scaleKubernetesCluster,upgradeKubernetesCluster",
          "required": true,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        }
      ]
    },
    {
      "description": "Remove VMs from an ExternalManaged kubernetes cluster. Not applicable for CloudManaged kubernetes clusters.",
      "isasync": false,
      "name": "removeVirtualMachinesFromKubernetesCluster",
      "params": [
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "the IDs of the VMs to remove from the cluster",
          "length": 255,
          "name": "virtualmachineids",
          "related": "assignVirtualMachine,migrateVirtualMachine,migrateVirtualMachineWithVolume,recoverVirtualMachine,attachIso,detachIso,addNicToVirtualMachine,deployVirtualMachine,destroyVirtualMachine,listVirtualMachines,scaleVirtualMachine,removeNicFromVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,resetUserDataForVirtualMachine,startVirtualMachine,stopVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,revertToVMSnapshot,updateVMAffinityGroup,attachIso,detachIso,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,updateDefaultNicForVirtualMachine,deployVirtualMachine,destroyVirtualMachine,rebootVirtualMachine,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,startVirtualMachine,stopVirtualMachine,updateVirtualMachine,changeServiceForVirtualMachine,revertToVMSnapshot,listVirtualMachines,deployVnfAppliance,importUnmanagedInstance,importVm",
          "required": true,
          "type": "list"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "the ID of the Kubernetes cluster",
          "length": 255,
          "name": "id",
          "related": "createKubernetesCluster,startKubernetesCluster,listKubernetesClusters,scaleKubernetesCluster,upgradeKubernetesCluster",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        }
      ],
      "related": "",
      "response": [
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "the id of the Kubernetes cluster",
          "name": "id",
          "type": "string"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        }
      ],
      "since": "4.19.0"
    },
    {
      "description": "Adds account to a project",
      "isasync": true,
      "name": "addAccountToProject",
      "params": [
        {
          "description": "email to which invitation to the project is going to be sent",
          "length": 255,
          "name": "email",
          "required": false,
          "type": "string"
        },
        {
          "description": "Project role type to be assigned to the user - Admin/Regular; default: Regular",
          "length": 255,
          "name": "roletype",
          "required": false,
          "type": "string"
        },
        {
          "description": "name of the account to be added to the project",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "ID of the project to add the account to",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "ID of the project role",
          "length": 255,
          "name": "projectroleid",
          "related": "createProjectRole,listProjectRoles,updateProjectRole",
          "required": false,
          "type": "uuid"
        }
      ],
      "response": [
        {},
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {}
      ],
      "since": "3.0.0"
    },
    {
      "description": "Lists all available snapshots for the account.",
      "isasync": false,
      "name": "listSnapshots",
      "params": [
        {
          "description": "the ID of the disk volume",
          "length": 255,
          "name": "volumeid",
          "related": "attachVolume,createVolume,updateVolume,detachVolume,listVolumes,migrateVolume,resizeVolume,destroyVolume,recoverVolume,changeOfferingForVolume,attachVolume,createVolume,detachVolume,migrateVolume,resizeVolume,updateVolume,uploadVolume,listVolumes,destroyVolume,recoverVolume,assignVolume",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "the IDs of the snapshots, mutually exclusive with id",
          "length": 255,
          "name": "ids",
          "related": "createSnapshot,createSnapshotFromVMSnapshot,copySnapshot,archiveSnapshot,listSnapshots,revertSnapshot,listSnapshots",
          "required": false,
          "since": "4.9",
          "type": "list"
        },
        {
          "description": "lists snapshot by snapshot ID",
          "length": 255,
          "name": "id",
          "related": "createSnapshot,createSnapshotFromVMSnapshot,copySnapshot,archiveSnapshot,listSnapshots,revertSnapshot,listSnapshots",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false. Resources dedicated to a project are listed only if using the projectid parameter.",
          "length": 255,
          "name": "listall",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "list objects by project; if projectid=-1 lists All VMs",
          "length": 255,
          "name": "projectid",
          "related": "listProjectAccounts,activateProject,createProject,listProjects,suspendProject,updateProject",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "List by keyword",
          "length": 255,
          "name": "keyword",
          "required": false,
          "type": "string"
        },
        {
          "description": "list only resources belonging to the domain specified",
          "length": 255,
          "name": "domainid",
          "related": "createDomain,listDomainChildren,listDomains,listDomains,updateDomain",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "list snapshots by zone id",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": false,
          "type": "uuid"
        },
        {
          "description": "If set to false, list templates across zones and their storages",
          "length": 255,
          "name": "showunique",
          "required": false,
          "since": "4.19.0",
          "type": "boolean"
        },
        {
          "description": "list resources by account. Must be used with the domainId parameter.",
          "length": 255,
          "name": "account",
          "required": false,
          "type": "string"
        },
        {
          "description": "List resources by tags (key/value pairs)",
          "length": 255,
          "name": "tags",
          "required": false,
          "type": "map"
        },
        {
          "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
          "length": 255,
          "name": "isrecursive",
          "required": false,
          "type": "boolean"
        },
        {
          "description": "ID of the storage pool",
          "length": 255,
          "name": "storageid",
          "related": "cancelStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration,enableStorageMaintenance,syncStoragePool,updateStorageCapabilities",
          "required": false,
          "since": "4.19",
          "type": "uuid"
        },
        {
          "description": "",
          "length": 255,
          "name": "pagesize",
          "required": false,
          "type": "integer"
        },
        {
          "description": "",
          "length": 255,
          "name": "page",
          "required": false,
          "type": "integer"
        },
        {
          "description": "valid values are MANUAL or RECURRING.",
          "length": 255,
          "name": "snapshottype",
          "required": false,
          "type": "string"
        },
        {
          "description": "valid values are HOURLY, DAILY, WEEKLY, and MONTHLY.",
          "length": 255,
          "name": "intervaltype",
          "required": false,
          "type": "string"
        },
        {
          "description": "list snapshots by location type. Used only when showunique=false. Valid location types: 'primary', 'secondary'. Default is empty",
          "length": 255,
          "name": "locationtype",
          "required": false,
          "since": "4.19.0",
          "type": "string"
        },
        {
          "description": "ID of the image or image cache store",
          "length": 255,
          "name": "imagestoreid",
          "related": "addSecondaryStorage,listSwifts,updateImageStore,addImageStore,addImageStoreS3,listImageStores,updateCloudToUseObjectStore",
          "required": false,
          "since": "4.19",
          "type": "uuid"
        },
        {
          "description": "lists snapshot by snapshot name",
          "length": 255,
          "name": "name",
          "required": false,
          "type": "string"
        }
      ],
      "related": "createSnapshot,createSnapshotFromVMSnapshot,copySnapshot,archiveSnapshot,revertSnapshot,listSnapshots",
      "response": [
        {
          "description": "the state of the snapshot. BackedUp means that snapshot is ready to be used; Creating - the snapshot is being allocated on the primary storage; BackingUp - the snapshot is being backed up on secondary storage",
          "name": "state",
          "type": "state"
        },
        {
          "description": "type of the datastore for the snapshot entry",
          "name": "datastoretype",
          "type": "string"
        },
        {
          "description": "download progress of a snapshot",
          "name": "downloaddetails",
          "type": "map"
        },
        {
          "description": "the domain ID of the snapshot's account",
          "name": "domainid",
          "type": "string"
        },
        {
          "description": "name of the disk volume",
          "name": "volumename",
          "type": "string"
        },
        {
          "description": "ID of the datastore for the snapshot entry",
          "name": "datastoreid",
          "type": "string"
        },
        {
          "description": "id of the availability zone",
          "name": "zoneid",
          "type": "string"
        },
        {
          "description": "ID of the snapshot",
          "name": "id",
          "type": "string"
        },
        {
          "description": "type of the disk volume",
          "name": "volumetype",
          "type": "string"
        },
        {
          "description": "name of the datastore for the snapshot entry",
          "name": "datastorename",
          "type": "string"
        },
        {
          "description": "the UUID of the latest async job acting on this object",
          "name": "jobid",
          "type": "string"
        },
        {
          "description": "valid location types are primary and secondary.",
          "name": "locationtype",
          "type": "string"
        },
        {
          "description": "valid types are hourly, daily, weekly, monthy, template, and none.",
          "name": "intervaltype",
          "type": "string"
        },
        {
          "description": "  the date the snapshot was created",
          "name": "created",
          "type": "date"
        },
        {
          "description": "display name of the os on volume",
          "name": "osdisplayname",
          "type": "string"
        },
        {
          "description": "the current status of the latest async job acting on this object",
          "name": "jobstatus",
          "type": "integer"
        },
        {
          "description": "the domain name of the snapshot's account",
          "name": "domain",
          "type": "string"
        },
        {
          "description": "virtual size of backedup snapshot on image store",
          "name": "virtualsize",
          "type": "long"
        },
        {},
        {
          "description": "the list of resource tags associated",
          "name": "tags",
          "response": [
            {
              "description": "tag key name",
              "name": "key",
              "type": "string"
            },
            {
              "description": "id of the resource",
              "name": "resourceid",
              "type": "string"
            },
            {
              "description": "the account associated with the tag",
              "name": "account",
              "type": "string"
            },
            {
              "description": "the project id the tag belongs to",
              "name": "projectid",
              "type": "string"
            },
            {
              "description": "the project name where tag belongs to",
              "name": "project",
              "type": "string"
            },
            {
              "description": "tag value",
              "name": "value",
              "type": "string"
            },
            {
              "description": "the ID of the domain associated with the tag",
              "name": "domainid",
              "type": "string"
            },
            {
              "description": "the domain associated with the tag",
              "name": "domain",
              "type": "string"
            },
            {
              "description": "customer associated with the tag",
              "name": "customer",
              "type": "string"
            },
            {
              "description": "resource type",
              "name": "resourcetype",
              "type": "string"
            }
          ],
          "type": "set"
        },
        {
          "description": "ID of the disk volume",
          "name": "volumeid",
          "type": "string"
        },
        {
          "description": "name of the snapshot",
          "name": "name",
          "type": "string"
        },
        {
          "description": "the project name of the snapshot",
          "name": "project",
          "type": "string"
        },
        {
          "description": "indicates whether the underlying storage supports reverting the volume to this snapshot",
          "name": "revertable",
          "type": "boolean"
        },
        {
          "description": "the project id of the snapshot",
          "name": "projectid",
          "type": "string"
        },
        {
          "description": "the type of the snapshot",
          "name": "snapshottype",
          "type": "string"
        },
        {
          "description": "state of the snapshot on the datastore",
          "name": "datastorestate",
          "type": "string"
        },
        {
          "description": "physical size of backedup snapshot on image store",
          "name": "physicalsize",
          "type": "long"
        },
        {
          "description": "id of the os on volume",
          "name": "ostypeid",
          "type": "string"
        },
        {
          "description": "true if the entity/resource has annotations",
          "name": "hasannotations",
          "type": "boolean"
        },
        {
          "description": "the account associated with the snapshot",
          "name": "account",
          "type": "string"
        },
        {
          "description": "name of the availability zone",
          "name": "zonename",
          "type": "string"
        },
        {
          "description": "the status of the template",
          "name": "status",
          "type": "string"
        },
        {}
      ]
    },
    {
      "description": "delete Tungsten-Fabric logical router",
      "isasync": true,
      "name": "deleteTungstenFabricLogicalRouter",
      "params": [
        {
          "description": "the ID of zone",
          "length": 255,
          "name": "zoneid",
          "related": "createZone,updateZone,listZones,listZones",
          "required": true,
          "type": "uuid"
        },
        {
          "description": "the uuid of Tungsten-Fabric logical router",
          "length": 255,
          "name": "logicalrouteruuid",
          "required": true,
          "type": "string"
        }
      ],
      "response": [
        {
          "description": "any text associated with the success or failure",
          "name": "displaytext",
          "type": "string"
        },
        {},
        {
          "description": "true if operation is executed successfully",
          "name": "success",
          "type": "boolean"
        },
        {
          "description": "the current