module.exports = {
  coverageDirectory: './coverage',
  modulePaths: ['<rootDir>/desktop/node_modules'],
  modulePathIgnorePatterns: ['<rootDir>/.tsOut'],
  transformIgnorePatterns: [
    'node_modules/(?!universalify|fs-extra|react-native|react-redux|react-gateway|@storybook|@react-navigation)',
  ],
  setupFiles: ['<rootDir>/node_modules/react-native/jest/setup.js', '<rootDir>/test/setupFiles-rn.js'],
  setupFilesAfterEnv: ['<rootDir>/test/setupTestFrameworkScriptFile-rn.js'],
  snapshotSerializers: ['<rootDir>/.storybook-rn/smaller-rn-serializer'],
  testPathIgnorePatterns: ['/node_modules/', '<rootDir>/.tsOut/'],
  testMatch: ['**/__rntests__/Storyshots-rn.js'],
  preset: 'react-native',
  rootDir: '..',
  timers: 'fake',
  moduleNameMapper: require('../mocks').jestReplacements,
  moduleFileExtensions: [
    'js',
    'json',
    'ts',
    'tsx',
    'jsx',
    'node',
    'native.js',
    'native.tsx',
    'ios.tsx',
    'android.tsx',
  ],
  transform: {
    '^.+\\.(js|ts|tsx)$': ['babel-jest', {configFile: './babel.config.js'}],
  },
  roots: ['.'],
  globals: {
    __DEV__: true,
    __STORYBOOK__: true,
    __STORYSHOT__: true,
  },
  verbose: true,
}
