#!/usr/bin/env bash

set -e -u -o pipefail # Fail on error

dir=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
cd "$dir"

rm -rf osxfuse macfuse

version=${VERSION:?"Need to set VERSION for Fuse"}
if [ "$version" = "4.0.5" ]; then
  tar -xjf /Volumes/Keybase/team/keybase.builds.macos/macfuse/macfuse-4.0.5-src.tbz
  mv macfuse-4.0.5-src macfuse
else
  branch="osxfuse-$version"
  # Checkout
  git clone --recursive -b "$branch" git://github.com/osxfuse/osxfuse.git osxfuse
fi

# Patch macfuse to turn it into kbfuse
./patch.sh

# Compile
rm -rf /tmp/kbfuse*
cd macfuse
# If you get an error compiling you might have to run `brew link gettext --force` (see https://github.com/osxfuse/osxfuse/issues/149).
# build for 10.11 and 10.14, and have osxfuse builder symlink other versions.
./build.sh -v 5 -t filesystembundle -- -s 11.0 -d 10.14 --kext="10.14,10.14,19" --kext="10.15->10.14" --kext="11,11.0,20" --kext="10.16->11"

cd $dir
rm -rf kbfuse.bundle
ditto /tmp/kbfuse/filesystembundle/kbfuse.fs kbfuse.bundle

# Backup the filesystembundle directory in case we need debug symbols later
cd /tmp/kbfuse/filesystembundle
tar zcvpf $dir/fsbundle.tgz  .

# Sign the kext
cd $dir
codesign --verbose --timestamp --options runtime --sign "Developer ID Application: Keybase, Inc." kbfuse.bundle/Contents/Extensions/11/kbfuse.kext
codesign --verbose --timestamp --options runtime --sign "Developer ID Application: Keybase, Inc." kbfuse.bundle/Contents/Extensions/10.14/kbfuse.kext
codesign --verbose --timestamp --options runtime --sign "Developer ID Application: Keybase, Inc." kbfuse.bundle/Contents/Resources/mount_kbfuse
codesign --verbose --timestamp --options runtime --sign "Developer ID Application: Keybase, Inc." kbfuse.bundle/Contents/Resources/load_kbfuse
codesign --verbose --force --deep --timestamp --options runtime --sign "Developer ID Application: Keybase, Inc." kbfuse.bundle

# Verify
codesign --verbose --verify kbfuse.bundle/Contents/Extensions/10.14/kbfuse.kext
codesign --verbose --verify kbfuse.bundle/Contents/Extensions/11/kbfuse.kext
codesign --verbose --verify kbfuse.bundle/Contents/Resources/mount_kbfuse
codesign --verbose --verify kbfuse.bundle/Contents/Resources/load_kbfuse
codesign --verbose --verify kbfuse.bundle
