// Auto-generated by avdl-compiler v1.3.25 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/stellar1/local.avdl

package stellar1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type WalletAccountLocal struct {
	AccountID          AccountID `codec:"accountID" json:"accountID"`
	IsDefault          bool      `codec:"isDefault" json:"isDefault"`
	Name               string    `codec:"name" json:"name"`
	BalanceDescription string    `codec:"balanceDescription" json:"balanceDescription"`
	Seqno              string    `codec:"seqno" json:"seqno"`
}

func (o WalletAccountLocal) DeepCopy() WalletAccountLocal {
	return WalletAccountLocal{
		AccountID:          o.AccountID.DeepCopy(),
		IsDefault:          o.IsDefault,
		Name:               o.Name,
		BalanceDescription: o.BalanceDescription,
		Seqno:              o.Seqno,
	}
}

type AccountAssetLocal struct {
	Name                   string           `codec:"name" json:"name"`
	AssetCode              string           `codec:"assetCode" json:"assetCode"`
	IssuerName             string           `codec:"issuerName" json:"issuerName"`
	IssuerAccountID        string           `codec:"issuerAccountID" json:"issuerAccountID"`
	BalanceTotal           string           `codec:"balanceTotal" json:"balanceTotal"`
	BalanceAvailableToSend string           `codec:"balanceAvailableToSend" json:"balanceAvailableToSend"`
	WorthCurrency          string           `codec:"worthCurrency" json:"worthCurrency"`
	Worth                  string           `codec:"worth" json:"worth"`
	AvailableToSendWorth   string           `codec:"availableToSendWorth" json:"availableToSendWorth"`
	Reserves               []AccountReserve `codec:"reserves" json:"reserves"`
}

func (o AccountAssetLocal) DeepCopy() AccountAssetLocal {
	return AccountAssetLocal{
		Name:                   o.Name,
		AssetCode:              o.AssetCode,
		IssuerName:             o.IssuerName,
		IssuerAccountID:        o.IssuerAccountID,
		BalanceTotal:           o.BalanceTotal,
		BalanceAvailableToSend: o.BalanceAvailableToSend,
		WorthCurrency:          o.WorthCurrency,
		Worth:                  o.Worth,
		AvailableToSendWorth:   o.AvailableToSendWorth,
		Reserves: (func(x []AccountReserve) []AccountReserve {
			if x == nil {
				return nil
			}
			ret := make([]AccountReserve, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Reserves),
	}
}

type BalanceDelta int

const (
	BalanceDelta_NONE     BalanceDelta = 0
	BalanceDelta_INCREASE BalanceDelta = 1
	BalanceDelta_DECREASE BalanceDelta = 2
)

func (o BalanceDelta) DeepCopy() BalanceDelta { return o }

var BalanceDeltaMap = map[string]BalanceDelta{
	"NONE":     0,
	"INCREASE": 1,
	"DECREASE": 2,
}

var BalanceDeltaRevMap = map[BalanceDelta]string{
	0: "NONE",
	1: "INCREASE",
	2: "DECREASE",
}

func (e BalanceDelta) String() string {
	if v, ok := BalanceDeltaRevMap[e]; ok {
		return v
	}
	return ""
}

type PaymentStatus int

const (
	PaymentStatus_NONE      PaymentStatus = 0
	PaymentStatus_PENDING   PaymentStatus = 1
	PaymentStatus_CLAIMABLE PaymentStatus = 2
	PaymentStatus_COMPLETED PaymentStatus = 3
	PaymentStatus_ERROR     PaymentStatus = 4
	PaymentStatus_UNKNOWN   PaymentStatus = 5
)

func (o PaymentStatus) DeepCopy() PaymentStatus { return o }

var PaymentStatusMap = map[string]PaymentStatus{
	"NONE":      0,
	"PENDING":   1,
	"CLAIMABLE": 2,
	"COMPLETED": 3,
	"ERROR":     4,
	"UNKNOWN":   5,
}

var PaymentStatusRevMap = map[PaymentStatus]string{
	0: "NONE",
	1: "PENDING",
	2: "CLAIMABLE",
	3: "COMPLETED",
	4: "ERROR",
	5: "UNKNOWN",
}

func (e PaymentStatus) String() string {
	if v, ok := PaymentStatusRevMap[e]; ok {
		return v
	}
	return ""
}

type ParticipantType int

const (
	ParticipantType_NONE       ParticipantType = 0
	ParticipantType_KEYBASE    ParticipantType = 1
	ParticipantType_STELLAR    ParticipantType = 2
	ParticipantType_SBS        ParticipantType = 3
	ParticipantType_OWNACCOUNT ParticipantType = 4
)

func (o ParticipantType) DeepCopy() ParticipantType { return o }

var ParticipantTypeMap = map[string]ParticipantType{
	"NONE":       0,
	"KEYBASE":    1,
	"STELLAR":    2,
	"SBS":        3,
	"OWNACCOUNT": 4,
}

var ParticipantTypeRevMap = map[ParticipantType]string{
	0: "NONE",
	1: "KEYBASE",
	2: "STELLAR",
	3: "SBS",
	4: "OWNACCOUNT",
}

func (e ParticipantType) String() string {
	if v, ok := ParticipantTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type PaymentLocal struct {
	Id                   PaymentID       `codec:"id" json:"id"`
	Time                 TimeMs          `codec:"time" json:"time"`
	StatusSimplified     PaymentStatus   `codec:"statusSimplified" json:"statusSimplified"`
	StatusDescription    string          `codec:"statusDescription" json:"statusDescription"`
	StatusDetail         string          `codec:"statusDetail" json:"statusDetail"`
	ShowCancel           bool            `codec:"showCancel" json:"showCancel"`
	AmountDescription    string          `codec:"amountDescription" json:"amountDescription"`
	Delta                BalanceDelta    `codec:"delta" json:"delta"`
	Worth                string          `codec:"worth" json:"worth"`
	WorthCurrency        string          `codec:"worthCurrency" json:"worthCurrency"`
	CurrentWorth         string          `codec:"currentWorth" json:"currentWorth"`
	CurrentWorthCurrency string          `codec:"currentWorthCurrency" json:"currentWorthCurrency"`
	FromType             ParticipantType `codec:"fromType" json:"fromType"`
	ToType               ParticipantType `codec:"toType" json:"toType"`
	FromAccountID        AccountID       `codec:"fromAccountID" json:"fromAccountID"`
	FromAccountName      string          `codec:"fromAccountName" json:"fromAccountName"`
	FromUsername         string          `codec:"fromUsername" json:"fromUsername"`
	ToAccountID          *AccountID      `codec:"toAccountID,omitempty" json:"toAccountID,omitempty"`
	ToAccountName        string          `codec:"toAccountName" json:"toAccountName"`
	ToUsername           string          `codec:"toUsername" json:"toUsername"`
	ToAssertion          string          `codec:"toAssertion" json:"toAssertion"`
	Note                 string          `codec:"note" json:"note"`
	NoteErr              string          `codec:"noteErr" json:"noteErr"`
	Unread               bool            `codec:"unread" json:"unread"`
}

func (o PaymentLocal) DeepCopy() PaymentLocal {
	return PaymentLocal{
		Id:                   o.Id.DeepCopy(),
		Time:                 o.Time.DeepCopy(),
		StatusSimplified:     o.StatusSimplified.DeepCopy(),
		StatusDescription:    o.StatusDescription,
		StatusDetail:         o.StatusDetail,
		ShowCancel:           o.ShowCancel,
		AmountDescription:    o.AmountDescription,
		Delta:                o.Delta.DeepCopy(),
		Worth:                o.Worth,
		WorthCurrency:        o.WorthCurrency,
		CurrentWorth:         o.CurrentWorth,
		CurrentWorthCurrency: o.CurrentWorthCurrency,
		FromType:             o.FromType.DeepCopy(),
		ToType:               o.ToType.DeepCopy(),
		FromAccountID:        o.FromAccountID.DeepCopy(),
		FromAccountName:      o.FromAccountName,
		FromUsername:         o.FromUsername,
		ToAccountID: (func(x *AccountID) *AccountID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.ToAccountID),
		ToAccountName: o.ToAccountName,
		ToUsername:    o.ToUsername,
		ToAssertion:   o.ToAssertion,
		Note:          o.Note,
		NoteErr:       o.NoteErr,
		Unread:        o.Unread,
	}
}

type PaymentOrErrorLocal struct {
	Payment *PaymentLocal `codec:"payment,omitempty" json:"payment,omitempty"`
	Err     *string       `codec:"err,omitempty" json:"err,omitempty"`
}

func (o PaymentOrErrorLocal) DeepCopy() PaymentOrErrorLocal {
	return PaymentOrErrorLocal{
		Payment: (func(x *PaymentLocal) *PaymentLocal {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Payment),
		Err: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Err),
	}
}

type PaymentsPageLocal struct {
	Payments     []PaymentOrErrorLocal `codec:"payments" json:"payments"`
	Cursor       *PageCursor           `codec:"cursor,omitempty" json:"cursor,omitempty"`
	OldestUnread *PaymentID            `codec:"oldestUnread,omitempty" json:"oldestUnread,omitempty"`
}

func (o PaymentsPageLocal) DeepCopy() PaymentsPageLocal {
	return PaymentsPageLocal{
		Payments: (func(x []PaymentOrErrorLocal) []PaymentOrErrorLocal {
			if x == nil {
				return nil
			}
			ret := make([]PaymentOrErrorLocal, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Payments),
		Cursor: (func(x *PageCursor) *PageCursor {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Cursor),
		OldestUnread: (func(x *PaymentID) *PaymentID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OldestUnread),
	}
}

type PaymentDetailsLocal struct {
	Id                   PaymentID       `codec:"id" json:"id"`
	TxID                 TransactionID   `codec:"txID" json:"txID"`
	Time                 TimeMs          `codec:"time" json:"time"`
	StatusSimplified     PaymentStatus   `codec:"statusSimplified" json:"statusSimplified"`
	StatusDescription    string          `codec:"statusDescription" json:"statusDescription"`
	StatusDetail         string          `codec:"statusDetail" json:"statusDetail"`
	ShowCancel           bool            `codec:"showCancel" json:"showCancel"`
	AmountDescription    string          `codec:"amountDescription" json:"amountDescription"`
	Delta                BalanceDelta    `codec:"delta" json:"delta"`
	Worth                string          `codec:"worth" json:"worth"`
	WorthCurrency        string          `codec:"worthCurrency" json:"worthCurrency"`
	CurrentWorth         string          `codec:"currentWorth" json:"currentWorth"`
	CurrentWorthCurrency string          `codec:"currentWorthCurrency" json:"currentWorthCurrency"`
	FromType             ParticipantType `codec:"fromType" json:"fromType"`
	ToType               ParticipantType `codec:"toType" json:"toType"`
	FromAccountID        AccountID       `codec:"fromAccountID" json:"fromAccountID"`
	FromAccountName      string          `codec:"fromAccountName" json:"fromAccountName"`
	FromUsername         string          `codec:"fromUsername" json:"fromUsername"`
	ToAccountID          *AccountID      `codec:"toAccountID,omitempty" json:"toAccountID,omitempty"`
	ToAccountName        string          `codec:"toAccountName" json:"toAccountName"`
	ToUsername           string          `codec:"toUsername" json:"toUsername"`
	ToAssertion          string          `codec:"toAssertion" json:"toAssertion"`
	Note                 string          `codec:"note" json:"note"`
	NoteErr              string          `codec:"noteErr" json:"noteErr"`
	PublicNote           string          `codec:"publicNote" json:"publicNote"`
	PublicNoteType       string          `codec:"publicNoteType" json:"publicNoteType"`
}

func (o PaymentDetailsLocal) DeepCopy() PaymentDetailsLocal {
	return PaymentDetailsLocal{
		Id:                   o.Id.DeepCopy(),
		TxID:                 o.TxID.DeepCopy(),
		Time:                 o.Time.DeepCopy(),
		StatusSimplified:     o.StatusSimplified.DeepCopy(),
		StatusDescription:    o.StatusDescription,
		StatusDetail:         o.StatusDetail,
		ShowCancel:           o.ShowCancel,
		AmountDescription:    o.AmountDescription,
		Delta:                o.Delta.DeepCopy(),
		Worth:                o.Worth,
		WorthCurrency:        o.WorthCurrency,
		CurrentWorth:         o.CurrentWorth,
		CurrentWorthCurrency: o.CurrentWorthCurrency,
		FromType:             o.FromType.DeepCopy(),
		ToType:               o.ToType.DeepCopy(),
		FromAccountID:        o.FromAccountID.DeepCopy(),
		FromAccountName:      o.FromAccountName,
		FromUsername:         o.FromUsername,
		ToAccountID: (func(x *AccountID) *AccountID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.ToAccountID),
		ToAccountName:  o.ToAccountName,
		ToUsername:     o.ToUsername,
		ToAssertion:    o.ToAssertion,
		Note:           o.Note,
		NoteErr:        o.NoteErr,
		PublicNote:     o.PublicNote,
		PublicNoteType: o.PublicNoteType,
	}
}

type CurrencyLocal struct {
	Description string              `codec:"description" json:"description"`
	Code        OutsideCurrencyCode `codec:"code" json:"code"`
	Symbol      string              `codec:"symbol" json:"symbol"`
	Name        string              `codec:"name" json:"name"`
}

func (o CurrencyLocal) DeepCopy() CurrencyLocal {
	return CurrencyLocal{
		Description: o.Description,
		Code:        o.Code.DeepCopy(),
		Symbol:      o.Symbol,
		Name:        o.Name,
	}
}

type WalletSettings struct {
	AcceptedDisclaimer bool `codec:"acceptedDisclaimer" json:"acceptedDisclaimer"`
}

func (o WalletSettings) DeepCopy() WalletSettings {
	return WalletSettings{
		AcceptedDisclaimer: o.AcceptedDisclaimer,
	}
}

type SendAssetChoiceLocal struct {
	Asset   Asset  `codec:"asset" json:"asset"`
	Enabled bool   `codec:"enabled" json:"enabled"`
	Left    string `codec:"left" json:"left"`
	Right   string `codec:"right" json:"right"`
	Subtext string `codec:"subtext" json:"subtext"`
}

func (o SendAssetChoiceLocal) DeepCopy() SendAssetChoiceLocal {
	return SendAssetChoiceLocal{
		Asset:   o.Asset.DeepCopy(),
		Enabled: o.Enabled,
		Left:    o.Left,
		Right:   o.Right,
		Subtext: o.Subtext,
	}
}

type BuildPaymentResLocal struct {
	ReadyToSend      bool              `codec:"readyToSend" json:"readyToSend"`
	From             AccountID         `codec:"from" json:"from"`
	ToErrMsg         string            `codec:"toErrMsg" json:"toErrMsg"`
	ToUsername       string            `codec:"toUsername" json:"toUsername"`
	AmountErrMsg     string            `codec:"amountErrMsg" json:"amountErrMsg"`
	SecretNoteErrMsg string            `codec:"secretNoteErrMsg" json:"secretNoteErrMsg"`
	PublicMemoErrMsg string            `codec:"publicMemoErrMsg" json:"publicMemoErrMsg"`
	WorthDescription string            `codec:"worthDescription" json:"worthDescription"`
	WorthInfo        string            `codec:"worthInfo" json:"worthInfo"`
	Banners          []SendBannerLocal `codec:"banners" json:"banners"`
}

func (o BuildPaymentResLocal) DeepCopy() BuildPaymentResLocal {
	return BuildPaymentResLocal{
		ReadyToSend:      o.ReadyToSend,
		From:             o.From.DeepCopy(),
		ToErrMsg:         o.ToErrMsg,
		ToUsername:       o.ToUsername,
		AmountErrMsg:     o.AmountErrMsg,
		SecretNoteErrMsg: o.SecretNoteErrMsg,
		PublicMemoErrMsg: o.PublicMemoErrMsg,
		WorthDescription: o.WorthDescription,
		WorthInfo:        o.WorthInfo,
		Banners: (func(x []SendBannerLocal) []SendBannerLocal {
			if x == nil {
				return nil
			}
			ret := make([]SendBannerLocal, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Banners),
	}
}

type SendBannerLocal struct {
	Level         string `codec:"level" json:"level"`
	Message       string `codec:"message" json:"message"`
	ProofsChanged bool   `codec:"proofsChanged" json:"proofsChanged"`
}

func (o SendBannerLocal) DeepCopy() SendBannerLocal {
	return SendBannerLocal{
		Level:         o.Level,
		Message:       o.Message,
		ProofsChanged: o.ProofsChanged,
	}
}

type SendPaymentResLocal struct {
	KbTxID  KeybaseTransactionID `codec:"kbTxID" json:"kbTxID"`
	Pending bool                 `codec:"pending" json:"pending"`
}

func (o SendPaymentResLocal) DeepCopy() SendPaymentResLocal {
	return SendPaymentResLocal{
		KbTxID:  o.KbTxID.DeepCopy(),
		Pending: o.Pending,
	}
}

type RequestDetailsLocal struct {
	Id                KeybaseRequestID     `codec:"id" json:"id"`
	FromAssertion     string               `codec:"fromAssertion" json:"fromAssertion"`
	FromCurrentUser   bool                 `codec:"fromCurrentUser" json:"fromCurrentUser"`
	ToUserType        ParticipantType      `codec:"toUserType" json:"toUserType"`
	ToAssertion       string               `codec:"toAssertion" json:"toAssertion"`
	Amount            string               `codec:"amount" json:"amount"`
	Asset             *Asset               `codec:"asset,omitempty" json:"asset,omitempty"`
	Currency          *OutsideCurrencyCode `codec:"currency,omitempty" json:"currency,omitempty"`
	AmountDescription string               `codec:"amountDescription" json:"amountDescription"`
	Status            RequestStatus        `codec:"status" json:"status"`
}

func (o RequestDetailsLocal) DeepCopy() RequestDetailsLocal {
	return RequestDetailsLocal{
		Id:              o.Id.DeepCopy(),
		FromAssertion:   o.FromAssertion,
		FromCurrentUser: o.FromCurrentUser,
		ToUserType:      o.ToUserType.DeepCopy(),
		ToAssertion:     o.ToAssertion,
		Amount:          o.Amount,
		Asset: (func(x *Asset) *Asset {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Asset),
		Currency: (func(x *OutsideCurrencyCode) *OutsideCurrencyCode {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Currency),
		AmountDescription: o.AmountDescription,
		Status:            o.Status.DeepCopy(),
	}
}

type SendResultCLILocal struct {
	KbTxID KeybaseTransactionID `codec:"kbTxID" json:"kbTxID"`
	TxID   TransactionID        `codec:"txID" json:"txID"`
}

func (o SendResultCLILocal) DeepCopy() SendResultCLILocal {
	return SendResultCLILocal{
		KbTxID: o.KbTxID.DeepCopy(),
		TxID:   o.TxID.DeepCopy(),
	}
}

type PaymentOrErrorCLILocal struct {
	Payment *PaymentCLILocal `codec:"payment,omitempty" json:"payment,omitempty"`
	Err     *string          `codec:"err,omitempty" json:"err,omitempty"`
}

func (o PaymentOrErrorCLILocal) DeepCopy() PaymentOrErrorCLILocal {
	return PaymentOrErrorCLILocal{
		Payment: (func(x *PaymentCLILocal) *PaymentCLILocal {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Payment),
		Err: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Err),
	}
}

type PaymentCLILocal struct {
	TxID            TransactionID `codec:"txID" json:"txID"`
	Time            TimeMs        `codec:"time" json:"time"`
	Status          string        `codec:"status" json:"status"`
	StatusDetail    string        `codec:"statusDetail" json:"statusDetail"`
	Amount          string        `codec:"amount" json:"amount"`
	Asset           Asset         `codec:"asset" json:"asset"`
	DisplayAmount   *string       `codec:"displayAmount,omitempty" json:"displayAmount,omitempty"`
	DisplayCurrency *string       `codec:"displayCurrency,omitempty" json:"displayCurrency,omitempty"`
	FromStellar     AccountID     `codec:"fromStellar" json:"fromStellar"`
	ToStellar       *AccountID    `codec:"toStellar,omitempty" json:"toStellar,omitempty"`
	FromUsername    *string       `codec:"fromUsername,omitempty" json:"fromUsername,omitempty"`
	ToUsername      *string       `codec:"toUsername,omitempty" json:"toUsername,omitempty"`
	ToAssertion     *string       `codec:"toAssertion,omitempty" json:"toAssertion,omitempty"`
	Note            string        `codec:"note" json:"note"`
	NoteErr         string        `codec:"noteErr" json:"noteErr"`
}

func (o PaymentCLILocal) DeepCopy() PaymentCLILocal {
	return PaymentCLILocal{
		TxID:         o.TxID.DeepCopy(),
		Time:         o.Time.DeepCopy(),
		Status:       o.Status,
		StatusDetail: o.StatusDetail,
		Amount:       o.Amount,
		Asset:        o.Asset.DeepCopy(),
		DisplayAmount: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.DisplayAmount),
		DisplayCurrency: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.DisplayCurrency),
		FromStellar: o.FromStellar.DeepCopy(),
		ToStellar: (func(x *AccountID) *AccountID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.ToStellar),
		FromUsername: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.FromUsername),
		ToUsername: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.ToUsername),
		ToAssertion: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.ToAssertion),
		Note:    o.Note,
		NoteErr: o.NoteErr,
	}
}

type OwnAccountCLILocal struct {
	AccountID    AccountID            `codec:"accountID" json:"accountID"`
	IsPrimary    bool                 `codec:"isPrimary" json:"isPrimary"`
	Name         string               `codec:"name" json:"name"`
	Balance      []Balance            `codec:"balance" json:"balance"`
	ExchangeRate *OutsideExchangeRate `codec:"exchangeRate,omitempty" json:"exchangeRate,omitempty"`
}

func (o OwnAccountCLILocal) DeepCopy() OwnAccountCLILocal {
	return OwnAccountCLILocal{
		AccountID: o.AccountID.DeepCopy(),
		IsPrimary: o.IsPrimary,
		Name:      o.Name,
		Balance: (func(x []Balance) []Balance {
			if x == nil {
				return nil
			}
			ret := make([]Balance, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Balance),
		ExchangeRate: (func(x *OutsideExchangeRate) *OutsideExchangeRate {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.ExchangeRate),
	}
}

type LookupResultCLILocal struct {
	AccountID AccountID `codec:"accountID" json:"accountID"`
	Username  *string   `codec:"username,omitempty" json:"username,omitempty"`
}

func (o LookupResultCLILocal) DeepCopy() LookupResultCLILocal {
	return LookupResultCLILocal{
		AccountID: o.AccountID.DeepCopy(),
		Username: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Username),
	}
}

type GetWalletAccountsLocalArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type GetWalletAccountLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type GetAccountAssetsLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type GetPaymentsLocalArg struct {
	SessionID int         `codec:"sessionID" json:"sessionID"`
	AccountID AccountID   `codec:"accountID" json:"accountID"`
	Cursor    *PageCursor `codec:"cursor,omitempty" json:"cursor,omitempty"`
}

type GetPendingPaymentsLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type MarkAsReadLocalArg struct {
	SessionID    int       `codec:"sessionID" json:"sessionID"`
	AccountID    AccountID `codec:"accountID" json:"accountID"`
	MostRecentID PaymentID `codec:"mostRecentID" json:"mostRecentID"`
}

type GetPaymentDetailsLocalArg struct {
	SessionID int        `codec:"sessionID" json:"sessionID"`
	AccountID *AccountID `codec:"accountID,omitempty" json:"accountID,omitempty"`
	Id        PaymentID  `codec:"id" json:"id"`
}

type GetDisplayCurrenciesLocalArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type ValidateAccountIDLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type ValidateSecretKeyLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	SecretKey SecretKey `codec:"secretKey" json:"secretKey"`
}

type ValidateAccountNameLocalArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Name      string `codec:"name" json:"name"`
}

type ChangeWalletAccountNameLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
	NewName   string    `codec:"newName" json:"newName"`
}

type SetWalletAccountAsDefaultLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type DeleteWalletAccountLocalArg struct {
	SessionID        int       `codec:"sessionID" json:"sessionID"`
	AccountID        AccountID `codec:"accountID" json:"accountID"`
	UserAcknowledged string    `codec:"userAcknowledged" json:"userAcknowledged"`
}

type LinkNewWalletAccountLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	SecretKey SecretKey `codec:"secretKey" json:"secretKey"`
	Name      string    `codec:"name" json:"name"`
}

type CreateWalletAccountLocalArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Name      string `codec:"name" json:"name"`
}

type ChangeDisplayCurrencyLocalArg struct {
	SessionID int                 `codec:"sessionID" json:"sessionID"`
	AccountID AccountID           `codec:"accountID" json:"accountID"`
	Currency  OutsideCurrencyCode `codec:"currency" json:"currency"`
}

type GetDisplayCurrencyLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type GetWalletSettingsLocalArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type SetAcceptedDisclaimerLocalArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type GetWalletAccountPublicKeyLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type GetWalletAccountSecretKeyLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type GetSendAssetChoicesLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	From      AccountID `codec:"from" json:"from"`
	To        string    `codec:"to" json:"to"`
}

type BuildPaymentLocalArg struct {
	SessionID          int                  `codec:"sessionID" json:"sessionID"`
	From               AccountID            `codec:"from" json:"from"`
	FromPrimaryAccount bool                 `codec:"fromPrimaryAccount" json:"fromPrimaryAccount"`
	FromSeqno          string               `codec:"fromSeqno" json:"fromSeqno"`
	To                 string               `codec:"to" json:"to"`
	ToIsAccountID      bool                 `codec:"toIsAccountID" json:"toIsAccountID"`
	Amount             string               `codec:"amount" json:"amount"`
	Currency           *OutsideCurrencyCode `codec:"currency,omitempty" json:"currency,omitempty"`
	Asset              *Asset               `codec:"asset,omitempty" json:"asset,omitempty"`
	SecretNote         string               `codec:"secretNote" json:"secretNote"`
	PublicMemo         string               `codec:"publicMemo" json:"publicMemo"`
}

type SendPaymentLocalArg struct {
	SessionID     int                  `codec:"sessionID" json:"sessionID"`
	From          AccountID            `codec:"from" json:"from"`
	FromSeqno     string               `codec:"fromSeqno" json:"fromSeqno"`
	To            string               `codec:"to" json:"to"`
	ToIsAccountID bool                 `codec:"toIsAccountID" json:"toIsAccountID"`
	Amount        string               `codec:"amount" json:"amount"`
	Asset         Asset                `codec:"asset" json:"asset"`
	WorthAmount   string               `codec:"worthAmount" json:"worthAmount"`
	WorthCurrency *OutsideCurrencyCode `codec:"worthCurrency,omitempty" json:"worthCurrency,omitempty"`
	SecretNote    string               `codec:"secretNote" json:"secretNote"`
	PublicMemo    string               `codec:"publicMemo" json:"publicMemo"`
	QuickReturn   bool                 `codec:"quickReturn" json:"quickReturn"`
}

type GetRequestDetailsLocalArg struct {
	SessionID int              `codec:"sessionID" json:"sessionID"`
	ReqID     KeybaseRequestID `codec:"reqID" json:"reqID"`
}

type CancelRequestLocalArg struct {
	SessionID int              `codec:"sessionID" json:"sessionID"`
	ReqID     KeybaseRequestID `codec:"reqID" json:"reqID"`
}

type MakeRequestLocalArg struct {
	SessionID int                  `codec:"sessionID" json:"sessionID"`
	Recipient string               `codec:"recipient" json:"recipient"`
	Asset     *Asset               `codec:"asset,omitempty" json:"asset,omitempty"`
	Currency  *OutsideCurrencyCode `codec:"currency,omitempty" json:"currency,omitempty"`
	Amount    string               `codec:"amount" json:"amount"`
	Note      string               `codec:"note" json:"note"`
}

type SetAccountMobileOnlyLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type IsAccountMobileOnlyLocalArg struct {
	SessionID int       `codec:"sessionID" json:"sessionID"`
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type BalancesLocalArg struct {
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type SendCLILocalArg struct {
	Recipient       string    `codec:"recipient" json:"recipient"`
	Amount          string    `codec:"amount" json:"amount"`
	Asset           Asset     `codec:"asset" json:"asset"`
	Note            string    `codec:"note" json:"note"`
	DisplayAmount   string    `codec:"displayAmount" json:"displayAmount"`
	DisplayCurrency string    `codec:"displayCurrency" json:"displayCurrency"`
	ForceRelay      bool      `codec:"forceRelay" json:"forceRelay"`
	PublicNote      string    `codec:"publicNote" json:"publicNote"`
	FromAccountID   AccountID `codec:"fromAccountID" json:"fromAccountID"`
}

type ClaimCLILocalArg struct {
	TxID string     `codec:"txID" json:"txID"`
	Into *AccountID `codec:"into,omitempty" json:"into,omitempty"`
}

type RecentPaymentsCLILocalArg struct {
	AccountID *AccountID `codec:"accountID,omitempty" json:"accountID,omitempty"`
}

type PaymentDetailCLILocalArg struct {
	TxID string `codec:"txID" json:"txID"`
}

type WalletInitLocalArg struct {
}

type WalletDumpLocalArg struct {
}

type WalletGetAccountsCLILocalArg struct {
}

type OwnAccountLocalArg struct {
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type ImportSecretKeyLocalArg struct {
	SecretKey   SecretKey `codec:"secretKey" json:"secretKey"`
	MakePrimary bool      `codec:"makePrimary" json:"makePrimary"`
	Name        string    `codec:"name" json:"name"`
}

type ExportSecretKeyLocalArg struct {
	AccountID AccountID `codec:"accountID" json:"accountID"`
}

type SetDisplayCurrencyArg struct {
	AccountID AccountID `codec:"accountID" json:"accountID"`
	Currency  string    `codec:"currency" json:"currency"`
}

type ExchangeRateLocalArg struct {
	Currency OutsideCurrencyCode `codec:"currency" json:"currency"`
}

type GetAvailableLocalCurrenciesArg struct {
}

type FormatLocalCurrencyStringArg struct {
	Amount string              `codec:"amount" json:"amount"`
	Code   OutsideCurrencyCode `codec:"code" json:"code"`
}

type MakeRequestCLILocalArg struct {
	Recipient string               `codec:"recipient" json:"recipient"`
	Asset     *Asset               `codec:"asset,omitempty" json:"asset,omitempty"`
	Currency  *OutsideCurrencyCode `codec:"currency,omitempty" json:"currency,omitempty"`
	Amount    string               `codec:"amount" json:"amount"`
	Note      string               `codec:"note" json:"note"`
}

type LookupCLILocalArg struct {
	Name string `codec:"name" json:"name"`
}

type LocalInterface interface {
	GetWalletAccountsLocal(context.Context, int) ([]WalletAccountLocal, error)
	GetWalletAccountLocal(context.Context, GetWalletAccountLocalArg) (WalletAccountLocal, error)
	GetAccountAssetsLocal(context.Context, GetAccountAssetsLocalArg) ([]AccountAssetLocal, error)
	GetPaymentsLocal(context.Context, GetPaymentsLocalArg) (PaymentsPageLocal, error)
	GetPendingPaymentsLocal(context.Context, GetPendingPaymentsLocalArg) ([]PaymentOrErrorLocal, error)
	MarkAsReadLocal(context.Context, MarkAsReadLocalArg) error
	GetPaymentDetailsLocal(context.Context, GetPaymentDetailsLocalArg) (PaymentDetailsLocal, error)
	GetDisplayCurrenciesLocal(context.Context, int) ([]CurrencyLocal, error)
	ValidateAccountIDLocal(context.Context, ValidateAccountIDLocalArg) error
	ValidateSecretKeyLocal(context.Context, ValidateSecretKeyLocalArg) error
	ValidateAccountNameLocal(context.Context, ValidateAccountNameLocalArg) error
	ChangeWalletAccountNameLocal(context.Context, ChangeWalletAccountNameLocalArg) error
	SetWalletAccountAsDefaultLocal(context.Context, SetWalletAccountAsDefaultLocalArg) error
	DeleteWalletAccountLocal(context.Context, DeleteWalletAccountLocalArg) error
	LinkNewWalletAccountLocal(context.Context, LinkNewWalletAccountLocalArg) (AccountID, error)
	CreateWalletAccountLocal(context.Context, CreateWalletAccountLocalArg) (AccountID, error)
	ChangeDisplayCurrencyLocal(context.Context, ChangeDisplayCurrencyLocalArg) error
	GetDisplayCurrencyLocal(context.Context, GetDisplayCurrencyLocalArg) (CurrencyLocal, error)
	GetWalletSettingsLocal(context.Context, int) (WalletSettings, error)
	SetAcceptedDisclaimerLocal(context.Context, int) error
	GetWalletAccountPublicKeyLocal(context.Context, GetWalletAccountPublicKeyLocalArg) (string, error)
	GetWalletAccountSecretKeyLocal(context.Context, GetWalletAccountSecretKeyLocalArg) (SecretKey, error)
	GetSendAssetChoicesLocal(context.Context, GetSendAssetChoicesLocalArg) ([]SendAssetChoiceLocal, error)
	BuildPaymentLocal(context.Context, BuildPaymentLocalArg) (BuildPaymentResLocal, error)
	SendPaymentLocal(context.Context, SendPaymentLocalArg) (SendPaymentResLocal, error)
	GetRequestDetailsLocal(context.Context, GetRequestDetailsLocalArg) (RequestDetailsLocal, error)
	CancelRequestLocal(context.Context, CancelRequestLocalArg) error
	MakeRequestLocal(context.Context, MakeRequestLocalArg) (KeybaseRequestID, error)
	SetAccountMobileOnlyLocal(context.Context, SetAccountMobileOnlyLocalArg) error
	IsAccountMobileOnlyLocal(context.Context, IsAccountMobileOnlyLocalArg) (bool, error)
	BalancesLocal(context.Context, AccountID) ([]Balance, error)
	SendCLILocal(context.Context, SendCLILocalArg) (SendResultCLILocal, error)
	ClaimCLILocal(context.Context, ClaimCLILocalArg) (RelayClaimResult, error)
	RecentPaymentsCLILocal(context.Context, *AccountID) ([]PaymentOrErrorCLILocal, error)
	PaymentDetailCLILocal(context.Context, string) (PaymentCLILocal, error)
	WalletInitLocal(context.Context) error
	WalletDumpLocal(context.Context) (Bundle, error)
	WalletGetAccountsCLILocal(context.Context) ([]OwnAccountCLILocal, error)
	OwnAccountLocal(context.Context, AccountID) (bool, error)
	ImportSecretKeyLocal(context.Context, ImportSecretKeyLocalArg) error
	ExportSecretKeyLocal(context.Context, AccountID) (SecretKey, error)
	SetDisplayCurrency(context.Context, SetDisplayCurrencyArg) error
	ExchangeRateLocal(context.Context, OutsideCurrencyCode) (OutsideExchangeRate, error)
	GetAvailableLocalCurrencies(context.Context) (map[OutsideCurrencyCode]OutsideCurrencyDefinition, error)
	FormatLocalCurrencyString(context.Context, FormatLocalCurrencyStringArg) (string, error)
	MakeRequestCLILocal(context.Context, MakeRequestCLILocalArg) (KeybaseRequestID, error)
	LookupCLILocal(context.Context, string) (LookupResultCLILocal, error)
}

func LocalProtocol(i LocalInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "stellar.1.local",
		Methods: map[string]rpc.ServeHandlerDescription{
			"getWalletAccountsLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetWalletAccountsLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetWalletAccountsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetWalletAccountsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetWalletAccountsLocal(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getWalletAccountLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetWalletAccountLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetWalletAccountLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetWalletAccountLocalArg)(nil), args)
						return
					}
					ret, err = i.GetWalletAccountLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getAccountAssetsLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetAccountAssetsLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetAccountAssetsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetAccountAssetsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetAccountAssetsLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getPaymentsLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetPaymentsLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetPaymentsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetPaymentsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetPaymentsLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getPendingPaymentsLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetPendingPaymentsLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetPendingPaymentsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetPendingPaymentsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetPendingPaymentsLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"markAsReadLocal": {
				MakeArg: func() interface{} {
					var ret [1]MarkAsReadLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]MarkAsReadLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]MarkAsReadLocalArg)(nil), args)
						return
					}
					err = i.MarkAsReadLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getPaymentDetailsLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetPaymentDetailsLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetPaymentDetailsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetPaymentDetailsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetPaymentDetailsLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getDisplayCurrenciesLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetDisplayCurrenciesLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetDisplayCurrenciesLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetDisplayCurrenciesLocalArg)(nil), args)
						return
					}
					ret, err = i.GetDisplayCurrenciesLocal(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"validateAccountIDLocal": {
				MakeArg: func() interface{} {
					var ret [1]ValidateAccountIDLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ValidateAccountIDLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ValidateAccountIDLocalArg)(nil), args)
						return
					}
					err = i.ValidateAccountIDLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"validateSecretKeyLocal": {
				MakeArg: func() interface{} {
					var ret [1]ValidateSecretKeyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ValidateSecretKeyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ValidateSecretKeyLocalArg)(nil), args)
						return
					}
					err = i.ValidateSecretKeyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"validateAccountNameLocal": {
				MakeArg: func() interface{} {
					var ret [1]ValidateAccountNameLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ValidateAccountNameLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ValidateAccountNameLocalArg)(nil), args)
						return
					}
					err = i.ValidateAccountNameLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"changeWalletAccountNameLocal": {
				MakeArg: func() interface{} {
					var ret [1]ChangeWalletAccountNameLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ChangeWalletAccountNameLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ChangeWalletAccountNameLocalArg)(nil), args)
						return
					}
					err = i.ChangeWalletAccountNameLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setWalletAccountAsDefaultLocal": {
				MakeArg: func() interface{} {
					var ret [1]SetWalletAccountAsDefaultLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetWalletAccountAsDefaultLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetWalletAccountAsDefaultLocalArg)(nil), args)
						return
					}
					err = i.SetWalletAccountAsDefaultLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"deleteWalletAccountLocal": {
				MakeArg: func() interface{} {
					var ret [1]DeleteWalletAccountLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]DeleteWalletAccountLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]DeleteWalletAccountLocalArg)(nil), args)
						return
					}
					err = i.DeleteWalletAccountLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"linkNewWalletAccountLocal": {
				MakeArg: func() interface{} {
					var ret [1]LinkNewWalletAccountLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LinkNewWalletAccountLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LinkNewWalletAccountLocalArg)(nil), args)
						return
					}
					ret, err = i.LinkNewWalletAccountLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"createWalletAccountLocal": {
				MakeArg: func() interface{} {
					var ret [1]CreateWalletAccountLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]CreateWalletAccountLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]CreateWalletAccountLocalArg)(nil), args)
						return
					}
					ret, err = i.CreateWalletAccountLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"changeDisplayCurrencyLocal": {
				MakeArg: func() interface{} {
					var ret [1]ChangeDisplayCurrencyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ChangeDisplayCurrencyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ChangeDisplayCurrencyLocalArg)(nil), args)
						return
					}
					err = i.ChangeDisplayCurrencyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getDisplayCurrencyLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetDisplayCurrencyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetDisplayCurrencyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetDisplayCurrencyLocalArg)(nil), args)
						return
					}
					ret, err = i.GetDisplayCurrencyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getWalletSettingsLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetWalletSettingsLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetWalletSettingsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetWalletSettingsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetWalletSettingsLocal(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setAcceptedDisclaimerLocal": {
				MakeArg: func() interface{} {
					var ret [1]SetAcceptedDisclaimerLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetAcceptedDisclaimerLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetAcceptedDisclaimerLocalArg)(nil), args)
						return
					}
					err = i.SetAcceptedDisclaimerLocal(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getWalletAccountPublicKeyLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetWalletAccountPublicKeyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetWalletAccountPublicKeyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetWalletAccountPublicKeyLocalArg)(nil), args)
						return
					}
					ret, err = i.GetWalletAccountPublicKeyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getWalletAccountSecretKeyLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetWalletAccountSecretKeyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetWalletAccountSecretKeyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetWalletAccountSecretKeyLocalArg)(nil), args)
						return
					}
					ret, err = i.GetWalletAccountSecretKeyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getSendAssetChoicesLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetSendAssetChoicesLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetSendAssetChoicesLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetSendAssetChoicesLocalArg)(nil), args)
						return
					}
					ret, err = i.GetSendAssetChoicesLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"buildPaymentLocal": {
				MakeArg: func() interface{} {
					var ret [1]BuildPaymentLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]BuildPaymentLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]BuildPaymentLocalArg)(nil), args)
						return
					}
					ret, err = i.BuildPaymentLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"sendPaymentLocal": {
				MakeArg: func() interface{} {
					var ret [1]SendPaymentLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SendPaymentLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SendPaymentLocalArg)(nil), args)
						return
					}
					ret, err = i.SendPaymentLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getRequestDetailsLocal": {
				MakeArg: func() interface{} {
					var ret [1]GetRequestDetailsLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetRequestDetailsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetRequestDetailsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetRequestDetailsLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"cancelRequestLocal": {
				MakeArg: func() interface{} {
					var ret [1]CancelRequestLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]CancelRequestLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]CancelRequestLocalArg)(nil), args)
						return
					}
					err = i.CancelRequestLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"makeRequestLocal": {
				MakeArg: func() interface{} {
					var ret [1]MakeRequestLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]MakeRequestLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]MakeRequestLocalArg)(nil), args)
						return
					}
					ret, err = i.MakeRequestLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setAccountMobileOnlyLocal": {
				MakeArg: func() interface{} {
					var ret [1]SetAccountMobileOnlyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetAccountMobileOnlyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetAccountMobileOnlyLocalArg)(nil), args)
						return
					}
					err = i.SetAccountMobileOnlyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"isAccountMobileOnlyLocal": {
				MakeArg: func() interface{} {
					var ret [1]IsAccountMobileOnlyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]IsAccountMobileOnlyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]IsAccountMobileOnlyLocalArg)(nil), args)
						return
					}
					ret, err = i.IsAccountMobileOnlyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"balancesLocal": {
				MakeArg: func() interface{} {
					var ret [1]BalancesLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]BalancesLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]BalancesLocalArg)(nil), args)
						return
					}
					ret, err = i.BalancesLocal(ctx, typedArgs[0].AccountID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"sendCLILocal": {
				MakeArg: func() interface{} {
					var ret [1]SendCLILocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SendCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SendCLILocalArg)(nil), args)
						return
					}
					ret, err = i.SendCLILocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"claimCLILocal": {
				MakeArg: func() interface{} {
					var ret [1]ClaimCLILocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ClaimCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ClaimCLILocalArg)(nil), args)
						return
					}
					ret, err = i.ClaimCLILocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"recentPaymentsCLILocal": {
				MakeArg: func() interface{} {
					var ret [1]RecentPaymentsCLILocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]RecentPaymentsCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]RecentPaymentsCLILocalArg)(nil), args)
						return
					}
					ret, err = i.RecentPaymentsCLILocal(ctx, typedArgs[0].AccountID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"paymentDetailCLILocal": {
				MakeArg: func() interface{} {
					var ret [1]PaymentDetailCLILocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]PaymentDetailCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]PaymentDetailCLILocalArg)(nil), args)
						return
					}
					ret, err = i.PaymentDetailCLILocal(ctx, typedArgs[0].TxID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"walletInitLocal": {
				MakeArg: func() interface{} {
					var ret [1]WalletInitLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					err = i.WalletInitLocal(ctx)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"walletDumpLocal": {
				MakeArg: func() interface{} {
					var ret [1]WalletDumpLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					ret, err = i.WalletDumpLocal(ctx)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"walletGetAccountsCLILocal": {
				MakeArg: func() interface{} {
					var ret [1]WalletGetAccountsCLILocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					ret, err = i.WalletGetAccountsCLILocal(ctx)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"ownAccountLocal": {
				MakeArg: func() interface{} {
					var ret [1]OwnAccountLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]OwnAccountLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]OwnAccountLocalArg)(nil), args)
						return
					}
					ret, err = i.OwnAccountLocal(ctx, typedArgs[0].AccountID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"importSecretKeyLocal": {
				MakeArg: func() interface{} {
					var ret [1]ImportSecretKeyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ImportSecretKeyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ImportSecretKeyLocalArg)(nil), args)
						return
					}
					err = i.ImportSecretKeyLocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"exportSecretKeyLocal": {
				MakeArg: func() interface{} {
					var ret [1]ExportSecretKeyLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ExportSecretKeyLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ExportSecretKeyLocalArg)(nil), args)
						return
					}
					ret, err = i.ExportSecretKeyLocal(ctx, typedArgs[0].AccountID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setDisplayCurrency": {
				MakeArg: func() interface{} {
					var ret [1]SetDisplayCurrencyArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetDisplayCurrencyArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetDisplayCurrencyArg)(nil), args)
						return
					}
					err = i.SetDisplayCurrency(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"exchangeRateLocal": {
				MakeArg: func() interface{} {
					var ret [1]ExchangeRateLocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ExchangeRateLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ExchangeRateLocalArg)(nil), args)
						return
					}
					ret, err = i.ExchangeRateLocal(ctx, typedArgs[0].Currency)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getAvailableLocalCurrencies": {
				MakeArg: func() interface{} {
					var ret [1]GetAvailableLocalCurrenciesArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					ret, err = i.GetAvailableLocalCurrencies(ctx)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"formatLocalCurrencyString": {
				MakeArg: func() interface{} {
					var ret [1]FormatLocalCurrencyStringArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]FormatLocalCurrencyStringArg)
					if !ok {
						err = rpc.NewTypeError((*[1]FormatLocalCurrencyStringArg)(nil), args)
						return
					}
					ret, err = i.FormatLocalCurrencyString(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"makeRequestCLILocal": {
				MakeArg: func() interface{} {
					var ret [1]MakeRequestCLILocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]MakeRequestCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]MakeRequestCLILocalArg)(nil), args)
						return
					}
					ret, err = i.MakeRequestCLILocal(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"lookupCLILocal": {
				MakeArg: func() interface{} {
					var ret [1]LookupCLILocalArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LookupCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LookupCLILocalArg)(nil), args)
						return
					}
					ret, err = i.LookupCLILocal(ctx, typedArgs[0].Name)
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type LocalClient struct {
	Cli rpc.GenericClient
}

func (c LocalClient) GetWalletAccountsLocal(ctx context.Context, sessionID int) (res []WalletAccountLocal, err error) {
	__arg := GetWalletAccountsLocalArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "stellar.1.local.getWalletAccountsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetWalletAccountLocal(ctx context.Context, __arg GetWalletAccountLocalArg) (res WalletAccountLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getWalletAccountLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetAccountAssetsLocal(ctx context.Context, __arg GetAccountAssetsLocalArg) (res []AccountAssetLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getAccountAssetsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetPaymentsLocal(ctx context.Context, __arg GetPaymentsLocalArg) (res PaymentsPageLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getPaymentsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetPendingPaymentsLocal(ctx context.Context, __arg GetPendingPaymentsLocalArg) (res []PaymentOrErrorLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getPendingPaymentsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) MarkAsReadLocal(ctx context.Context, __arg MarkAsReadLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.markAsReadLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) GetPaymentDetailsLocal(ctx context.Context, __arg GetPaymentDetailsLocalArg) (res PaymentDetailsLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getPaymentDetailsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetDisplayCurrenciesLocal(ctx context.Context, sessionID int) (res []CurrencyLocal, err error) {
	__arg := GetDisplayCurrenciesLocalArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "stellar.1.local.getDisplayCurrenciesLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) ValidateAccountIDLocal(ctx context.Context, __arg ValidateAccountIDLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.validateAccountIDLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) ValidateSecretKeyLocal(ctx context.Context, __arg ValidateSecretKeyLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.validateSecretKeyLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) ValidateAccountNameLocal(ctx context.Context, __arg ValidateAccountNameLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.validateAccountNameLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) ChangeWalletAccountNameLocal(ctx context.Context, __arg ChangeWalletAccountNameLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.changeWalletAccountNameLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) SetWalletAccountAsDefaultLocal(ctx context.Context, __arg SetWalletAccountAsDefaultLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.setWalletAccountAsDefaultLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) DeleteWalletAccountLocal(ctx context.Context, __arg DeleteWalletAccountLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.deleteWalletAccountLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) LinkNewWalletAccountLocal(ctx context.Context, __arg LinkNewWalletAccountLocalArg) (res AccountID, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.linkNewWalletAccountLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) CreateWalletAccountLocal(ctx context.Context, __arg CreateWalletAccountLocalArg) (res AccountID, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.createWalletAccountLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) ChangeDisplayCurrencyLocal(ctx context.Context, __arg ChangeDisplayCurrencyLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.changeDisplayCurrencyLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) GetDisplayCurrencyLocal(ctx context.Context, __arg GetDisplayCurrencyLocalArg) (res CurrencyLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getDisplayCurrencyLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetWalletSettingsLocal(ctx context.Context, sessionID int) (res WalletSettings, err error) {
	__arg := GetWalletSettingsLocalArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "stellar.1.local.getWalletSettingsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SetAcceptedDisclaimerLocal(ctx context.Context, sessionID int) (err error) {
	__arg := SetAcceptedDisclaimerLocalArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "stellar.1.local.setAcceptedDisclaimerLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) GetWalletAccountPublicKeyLocal(ctx context.Context, __arg GetWalletAccountPublicKeyLocalArg) (res string, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getWalletAccountPublicKeyLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetWalletAccountSecretKeyLocal(ctx context.Context, __arg GetWalletAccountSecretKeyLocalArg) (res SecretKey, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getWalletAccountSecretKeyLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetSendAssetChoicesLocal(ctx context.Context, __arg GetSendAssetChoicesLocalArg) (res []SendAssetChoiceLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getSendAssetChoicesLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) BuildPaymentLocal(ctx context.Context, __arg BuildPaymentLocalArg) (res BuildPaymentResLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.buildPaymentLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SendPaymentLocal(ctx context.Context, __arg SendPaymentLocalArg) (res SendPaymentResLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.sendPaymentLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetRequestDetailsLocal(ctx context.Context, __arg GetRequestDetailsLocalArg) (res RequestDetailsLocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getRequestDetailsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) CancelRequestLocal(ctx context.Context, __arg CancelRequestLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.cancelRequestLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) MakeRequestLocal(ctx context.Context, __arg MakeRequestLocalArg) (res KeybaseRequestID, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.makeRequestLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SetAccountMobileOnlyLocal(ctx context.Context, __arg SetAccountMobileOnlyLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.setAccountMobileOnlyLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) IsAccountMobileOnlyLocal(ctx context.Context, __arg IsAccountMobileOnlyLocalArg) (res bool, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.isAccountMobileOnlyLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) BalancesLocal(ctx context.Context, accountID AccountID) (res []Balance, err error) {
	__arg := BalancesLocalArg{AccountID: accountID}
	err = c.Cli.Call(ctx, "stellar.1.local.balancesLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SendCLILocal(ctx context.Context, __arg SendCLILocalArg) (res SendResultCLILocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.sendCLILocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) ClaimCLILocal(ctx context.Context, __arg ClaimCLILocalArg) (res RelayClaimResult, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.claimCLILocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) RecentPaymentsCLILocal(ctx context.Context, accountID *AccountID) (res []PaymentOrErrorCLILocal, err error) {
	__arg := RecentPaymentsCLILocalArg{AccountID: accountID}
	err = c.Cli.Call(ctx, "stellar.1.local.recentPaymentsCLILocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PaymentDetailCLILocal(ctx context.Context, txID string) (res PaymentCLILocal, err error) {
	__arg := PaymentDetailCLILocalArg{TxID: txID}
	err = c.Cli.Call(ctx, "stellar.1.local.paymentDetailCLILocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) WalletInitLocal(ctx context.Context) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.walletInitLocal", []interface{}{WalletInitLocalArg{}}, nil)
	return
}

func (c LocalClient) WalletDumpLocal(ctx context.Context) (res Bundle, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.walletDumpLocal", []interface{}{WalletDumpLocalArg{}}, &res)
	return
}

func (c LocalClient) WalletGetAccountsCLILocal(ctx context.Context) (res []OwnAccountCLILocal, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.walletGetAccountsCLILocal", []interface{}{WalletGetAccountsCLILocalArg{}}, &res)
	return
}

func (c LocalClient) OwnAccountLocal(ctx context.Context, accountID AccountID) (res bool, err error) {
	__arg := OwnAccountLocalArg{AccountID: accountID}
	err = c.Cli.Call(ctx, "stellar.1.local.ownAccountLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) ImportSecretKeyLocal(ctx context.Context, __arg ImportSecretKeyLocalArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.importSecretKeyLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) ExportSecretKeyLocal(ctx context.Context, accountID AccountID) (res SecretKey, err error) {
	__arg := ExportSecretKeyLocalArg{AccountID: accountID}
	err = c.Cli.Call(ctx, "stellar.1.local.exportSecretKeyLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SetDisplayCurrency(ctx context.Context, __arg SetDisplayCurrencyArg) (err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.setDisplayCurrency", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) ExchangeRateLocal(ctx context.Context, currency OutsideCurrencyCode) (res OutsideExchangeRate, err error) {
	__arg := ExchangeRateLocalArg{Currency: currency}
	err = c.Cli.Call(ctx, "stellar.1.local.exchangeRateLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetAvailableLocalCurrencies(ctx context.Context) (res map[OutsideCurrencyCode]OutsideCurrencyDefinition, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.getAvailableLocalCurrencies", []interface{}{GetAvailableLocalCurrenciesArg{}}, &res)
	return
}

func (c LocalClient) FormatLocalCurrencyString(ctx context.Context, __arg FormatLocalCurrencyStringArg) (res string, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.formatLocalCurrencyString", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) MakeRequestCLILocal(ctx context.Context, __arg MakeRequestCLILocalArg) (res KeybaseRequestID, err error) {
	err = c.Cli.Call(ctx, "stellar.1.local.makeRequestCLILocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) LookupCLILocal(ctx context.Context, name string) (res LookupResultCLILocal, err error) {
	__arg := LookupCLILocalArg{Name: name}
	err = c.Cli.Call(ctx, "stellar.1.local.lookupCLILocal", []interface{}{__arg}, &res)
	return
}
