// Auto-generated by avdl-compiler v1.3.25 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/user.avdl

package keybase1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type Tracker struct {
	Tracker UID  `codec:"tracker" json:"tracker"`
	Status  int  `codec:"status" json:"status"`
	MTime   Time `codec:"mTime" json:"mTime"`
}

func (o Tracker) DeepCopy() Tracker {
	return Tracker{
		Tracker: o.Tracker.DeepCopy(),
		Status:  o.Status,
		MTime:   o.MTime.DeepCopy(),
	}
}

type TrackProof struct {
	ProofType string `codec:"proofType" json:"proofType"`
	ProofName string `codec:"proofName" json:"proofName"`
	IdString  string `codec:"idString" json:"idString"`
}

func (o TrackProof) DeepCopy() TrackProof {
	return TrackProof{
		ProofType: o.ProofType,
		ProofName: o.ProofName,
		IdString:  o.IdString,
	}
}

type WebProof struct {
	Hostname  string   `codec:"hostname" json:"hostname"`
	Protocols []string `codec:"protocols" json:"protocols"`
}

func (o WebProof) DeepCopy() WebProof {
	return WebProof{
		Hostname: o.Hostname,
		Protocols: (func(x []string) []string {
			if x == nil {
				return nil
			}
			ret := make([]string, len(x))
			for i, v := range x {
				vCopy := v
				ret[i] = vCopy
			}
			return ret
		})(o.Protocols),
	}
}

type Proofs struct {
	Social     []TrackProof `codec:"social" json:"social"`
	Web        []WebProof   `codec:"web" json:"web"`
	PublicKeys []PublicKey  `codec:"publicKeys" json:"publicKeys"`
}

func (o Proofs) DeepCopy() Proofs {
	return Proofs{
		Social: (func(x []TrackProof) []TrackProof {
			if x == nil {
				return nil
			}
			ret := make([]TrackProof, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Social),
		Web: (func(x []WebProof) []WebProof {
			if x == nil {
				return nil
			}
			ret := make([]WebProof, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Web),
		PublicKeys: (func(x []PublicKey) []PublicKey {
			if x == nil {
				return nil
			}
			ret := make([]PublicKey, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.PublicKeys),
	}
}

type UserSummary struct {
	Uid          UID    `codec:"uid" json:"uid"`
	Username     string `codec:"username" json:"username"`
	Thumbnail    string `codec:"thumbnail" json:"thumbnail"`
	IdVersion    int    `codec:"idVersion" json:"idVersion"`
	FullName     string `codec:"fullName" json:"fullName"`
	Bio          string `codec:"bio" json:"bio"`
	Proofs       Proofs `codec:"proofs" json:"proofs"`
	SigIDDisplay string `codec:"sigIDDisplay" json:"sigIDDisplay"`
	TrackTime    Time   `codec:"trackTime" json:"trackTime"`
}

func (o UserSummary) DeepCopy() UserSummary {
	return UserSummary{
		Uid:          o.Uid.DeepCopy(),
		Username:     o.Username,
		Thumbnail:    o.Thumbnail,
		IdVersion:    o.IdVersion,
		FullName:     o.FullName,
		Bio:          o.Bio,
		Proofs:       o.Proofs.DeepCopy(),
		SigIDDisplay: o.SigIDDisplay,
		TrackTime:    o.TrackTime.DeepCopy(),
	}
}

type Email struct {
	Email      string `codec:"email" json:"email"`
	IsVerified bool   `codec:"isVerified" json:"isVerified"`
}

func (o Email) DeepCopy() Email {
	return Email{
		Email:      o.Email,
		IsVerified: o.IsVerified,
	}
}

type UserSettings struct {
	Emails []Email `codec:"emails" json:"emails"`
}

func (o UserSettings) DeepCopy() UserSettings {
	return UserSettings{
		Emails: (func(x []Email) []Email {
			if x == nil {
				return nil
			}
			ret := make([]Email, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Emails),
	}
}

type SearchComponent struct {
	Key   string  `codec:"key" json:"key"`
	Value string  `codec:"value" json:"value"`
	Score float64 `codec:"score" json:"score"`
}

func (o SearchComponent) DeepCopy() SearchComponent {
	return SearchComponent{
		Key:   o.Key,
		Value: o.Value,
		Score: o.Score,
	}
}

type SearchResult struct {
	Uid        UID               `codec:"uid" json:"uid"`
	Username   string            `codec:"username" json:"username"`
	Components []SearchComponent `codec:"components" json:"components"`
	Score      float64           `codec:"score" json:"score"`
}

func (o SearchResult) DeepCopy() SearchResult {
	return SearchResult{
		Uid:      o.Uid.DeepCopy(),
		Username: o.Username,
		Components: (func(x []SearchComponent) []SearchComponent {
			if x == nil {
				return nil
			}
			ret := make([]SearchComponent, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Components),
		Score: o.Score,
	}
}

type UserSummary2 struct {
	Uid        UID    `codec:"uid" json:"uid"`
	Username   string `codec:"username" json:"username"`
	Thumbnail  string `codec:"thumbnail" json:"thumbnail"`
	FullName   string `codec:"fullName" json:"fullName"`
	IsFollower bool   `codec:"isFollower" json:"isFollower"`
	IsFollowee bool   `codec:"isFollowee" json:"isFollowee"`
}

func (o UserSummary2) DeepCopy() UserSummary2 {
	return UserSummary2{
		Uid:        o.Uid.DeepCopy(),
		Username:   o.Username,
		Thumbnail:  o.Thumbnail,
		FullName:   o.FullName,
		IsFollower: o.IsFollower,
		IsFollowee: o.IsFollowee,
	}
}

type UserSummary2Set struct {
	Users   []UserSummary2 `codec:"users" json:"users"`
	Time    Time           `codec:"time" json:"time"`
	Version int            `codec:"version" json:"version"`
}

func (o UserSummary2Set) DeepCopy() UserSummary2Set {
	return UserSummary2Set{
		Users: (func(x []UserSummary2) []UserSummary2 {
			if x == nil {
				return nil
			}
			ret := make([]UserSummary2, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Users),
		Time:    o.Time.DeepCopy(),
		Version: o.Version,
	}
}

type InterestingPerson struct {
	Uid      UID    `codec:"uid" json:"uid"`
	Username string `codec:"username" json:"username"`
}

func (o InterestingPerson) DeepCopy() InterestingPerson {
	return InterestingPerson{
		Uid:      o.Uid.DeepCopy(),
		Username: o.Username,
	}
}

type NextMerkleRootRes struct {
	Res *MerkleRootV2 `codec:"res,omitempty" json:"res,omitempty"`
}

func (o NextMerkleRootRes) DeepCopy() NextMerkleRootRes {
	return NextMerkleRootRes{
		Res: (func(x *MerkleRootV2) *MerkleRootV2 {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Res),
	}
}

type ListTrackersArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
	Uid       UID `codec:"uid" json:"uid"`
}

type ListTrackersByNameArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Username  string `codec:"username" json:"username"`
}

type ListTrackersSelfArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type LoadUncheckedUserSummariesArg struct {
	SessionID int   `codec:"sessionID" json:"sessionID"`
	Uids      []UID `codec:"uids" json:"uids"`
}

type LoadUserArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
	Uid       UID `codec:"uid" json:"uid"`
}

type LoadUserByNameArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Username  string `codec:"username" json:"username"`
}

type LoadUserPlusKeysArg struct {
	SessionID  int `codec:"sessionID" json:"sessionID"`
	Uid        UID `codec:"uid" json:"uid"`
	PollForKID KID `codec:"pollForKID" json:"pollForKID"`
}

type LoadUserPlusKeysV2Arg struct {
	SessionID  int `codec:"sessionID" json:"sessionID"`
	Uid        UID `codec:"uid" json:"uid"`
	PollForKID KID `codec:"pollForKID" json:"pollForKID"`
}

type LoadPublicKeysArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
	Uid       UID `codec:"uid" json:"uid"`
}

type LoadMyPublicKeysArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type LoadMySettingsArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type ListTrackingArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Filter    string `codec:"filter" json:"filter"`
	Assertion string `codec:"assertion" json:"assertion"`
}

type ListTrackingJSONArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Filter    string `codec:"filter" json:"filter"`
	Verbose   bool   `codec:"verbose" json:"verbose"`
	Assertion string `codec:"assertion" json:"assertion"`
}

type SearchArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Query     string `codec:"query" json:"query"`
}

type LoadAllPublicKeysUnverifiedArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
	Uid       UID `codec:"uid" json:"uid"`
}

type ListTrackers2Arg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	Assertion string `codec:"assertion" json:"assertion"`
	Reverse   bool   `codec:"reverse" json:"reverse"`
}

type ProfileEditArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	FullName  string `codec:"fullName" json:"fullName"`
	Location  string `codec:"location" json:"location"`
	Bio       string `codec:"bio" json:"bio"`
}

type InterestingPeopleArg struct {
	MaxUsers int `codec:"maxUsers" json:"maxUsers"`
}

type MeUserVersionArg struct {
	SessionID int  `codec:"sessionID" json:"sessionID"`
	ForcePoll bool `codec:"forcePoll" json:"forcePoll"`
}

type GetUPAKArg struct {
	Uid UID `codec:"uid" json:"uid"`
}

type UploadUserAvatarArg struct {
	Filename string         `codec:"filename" json:"filename"`
	Crop     *ImageCropRect `codec:"crop,omitempty" json:"crop,omitempty"`
}

type FindNextMerkleRootAfterRevokeArg struct {
	Uid  UID              `codec:"uid" json:"uid"`
	Kid  KID              `codec:"kid" json:"kid"`
	Loc  SigChainLocation `codec:"loc" json:"loc"`
	Prev MerkleRootV2     `codec:"prev" json:"prev"`
}

type FindNextMerkleRootAfterResetArg struct {
	Uid        UID             `codec:"uid" json:"uid"`
	ResetSeqno Seqno           `codec:"resetSeqno" json:"resetSeqno"`
	Prev       ResetMerkleRoot `codec:"prev" json:"prev"`
}

type UserInterface interface {
	ListTrackers(context.Context, ListTrackersArg) ([]Tracker, error)
	ListTrackersByName(context.Context, ListTrackersByNameArg) ([]Tracker, error)
	ListTrackersSelf(context.Context, int) ([]Tracker, error)
	// Load user summaries for the supplied uids.
	// They are "unchecked" in that the client is not verifying the info from the server.
	// If len(uids) > 500, the first 500 will be returned.
	LoadUncheckedUserSummaries(context.Context, LoadUncheckedUserSummariesArg) ([]UserSummary, error)
	// Load a user from the server.
	LoadUser(context.Context, LoadUserArg) (User, error)
	LoadUserByName(context.Context, LoadUserByNameArg) (User, error)
	// Load a user + device keys from the server.
	LoadUserPlusKeys(context.Context, LoadUserPlusKeysArg) (UserPlusKeys, error)
	LoadUserPlusKeysV2(context.Context, LoadUserPlusKeysV2Arg) (UserPlusKeysV2AllIncarnations, error)
	// Load public keys for a user.
	LoadPublicKeys(context.Context, LoadPublicKeysArg) ([]PublicKey, error)
	// Load my public keys (for logged in user).
	LoadMyPublicKeys(context.Context, int) ([]PublicKey, error)
	// Load user settings (for logged in user).
	LoadMySettings(context.Context, int) (UserSettings, error)
	// The list-tracking functions get verified data from the tracking statements
	// in the user's sigchain.
	//
	// If assertion is empty, it will use the current logged in user.
	ListTracking(context.Context, ListTrackingArg) ([]UserSummary, error)
	ListTrackingJSON(context.Context, ListTrackingJSONArg) (string, error)
	// Search for users who match a given query.
	Search(context.Context, SearchArg) ([]SearchResult, error)
	// Load all the user's public keys (even those in reset key families)
	// from the server with no verification
	LoadAllPublicKeysUnverified(context.Context, LoadAllPublicKeysUnverifiedArg) ([]PublicKey, error)
	ListTrackers2(context.Context, ListTrackers2Arg) (UserSummary2Set, error)
	ProfileEdit(context.Context, ProfileEditArg) error
	InterestingPeople(context.Context, int) ([]InterestingPerson, error)
	MeUserVersion(context.Context, MeUserVersionArg) (UserVersion, error)
	// getUPAK returns a UPAK. Used mainly for debugging.
	GetUPAK(context.Context, UID) (UPAKVersioned, error)
	UploadUserAvatar(context.Context, UploadUserAvatarArg) error
	// FindNextMerkleRootAfterRevoke finds the first Merkle Root that contains the UID/KID
	// revocation at the given SigChainLocataion. The MerkleRootV2 prev is a hint as to where
	// we'll start our search. Usually it's the next one, but not always
	FindNextMerkleRootAfterRevoke(context.Context, FindNextMerkleRootAfterRevokeArg) (NextMerkleRootRes, error)
	// FindNextMerkleRootAfterReset finds the first Merkle root that contains the UID reset
	// at resetSeqno. You should pass it prev, which was the last known Merkle root at the time of
	// the reset. Usually, we'll just turn up the next Merkle root, but not always.
	FindNextMerkleRootAfterReset(context.Context, FindNextMerkleRootAfterResetArg) (NextMerkleRootRes, error)
}

func UserProtocol(i UserInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.user",
		Methods: map[string]rpc.ServeHandlerDescription{
			"listTrackers": {
				MakeArg: func() interface{} {
					var ret [1]ListTrackersArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ListTrackersArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ListTrackersArg)(nil), args)
						return
					}
					ret, err = i.ListTrackers(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"listTrackersByName": {
				MakeArg: func() interface{} {
					var ret [1]ListTrackersByNameArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ListTrackersByNameArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ListTrackersByNameArg)(nil), args)
						return
					}
					ret, err = i.ListTrackersByName(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"listTrackersSelf": {
				MakeArg: func() interface{} {
					var ret [1]ListTrackersSelfArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ListTrackersSelfArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ListTrackersSelfArg)(nil), args)
						return
					}
					ret, err = i.ListTrackersSelf(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadUncheckedUserSummaries": {
				MakeArg: func() interface{} {
					var ret [1]LoadUncheckedUserSummariesArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadUncheckedUserSummariesArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadUncheckedUserSummariesArg)(nil), args)
						return
					}
					ret, err = i.LoadUncheckedUserSummaries(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadUser": {
				MakeArg: func() interface{} {
					var ret [1]LoadUserArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadUserArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadUserArg)(nil), args)
						return
					}
					ret, err = i.LoadUser(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadUserByName": {
				MakeArg: func() interface{} {
					var ret [1]LoadUserByNameArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadUserByNameArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadUserByNameArg)(nil), args)
						return
					}
					ret, err = i.LoadUserByName(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadUserPlusKeys": {
				MakeArg: func() interface{} {
					var ret [1]LoadUserPlusKeysArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadUserPlusKeysArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadUserPlusKeysArg)(nil), args)
						return
					}
					ret, err = i.LoadUserPlusKeys(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadUserPlusKeysV2": {
				MakeArg: func() interface{} {
					var ret [1]LoadUserPlusKeysV2Arg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadUserPlusKeysV2Arg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadUserPlusKeysV2Arg)(nil), args)
						return
					}
					ret, err = i.LoadUserPlusKeysV2(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadPublicKeys": {
				MakeArg: func() interface{} {
					var ret [1]LoadPublicKeysArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadPublicKeysArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadPublicKeysArg)(nil), args)
						return
					}
					ret, err = i.LoadPublicKeys(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadMyPublicKeys": {
				MakeArg: func() interface{} {
					var ret [1]LoadMyPublicKeysArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadMyPublicKeysArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadMyPublicKeysArg)(nil), args)
						return
					}
					ret, err = i.LoadMyPublicKeys(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadMySettings": {
				MakeArg: func() interface{} {
					var ret [1]LoadMySettingsArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadMySettingsArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadMySettingsArg)(nil), args)
						return
					}
					ret, err = i.LoadMySettings(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"listTracking": {
				MakeArg: func() interface{} {
					var ret [1]ListTrackingArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ListTrackingArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ListTrackingArg)(nil), args)
						return
					}
					ret, err = i.ListTracking(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"listTrackingJSON": {
				MakeArg: func() interface{} {
					var ret [1]ListTrackingJSONArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ListTrackingJSONArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ListTrackingJSONArg)(nil), args)
						return
					}
					ret, err = i.ListTrackingJSON(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"search": {
				MakeArg: func() interface{} {
					var ret [1]SearchArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SearchArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SearchArg)(nil), args)
						return
					}
					ret, err = i.Search(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"loadAllPublicKeysUnverified": {
				MakeArg: func() interface{} {
					var ret [1]LoadAllPublicKeysUnverifiedArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LoadAllPublicKeysUnverifiedArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LoadAllPublicKeysUnverifiedArg)(nil), args)
						return
					}
					ret, err = i.LoadAllPublicKeysUnverified(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"listTrackers2": {
				MakeArg: func() interface{} {
					var ret [1]ListTrackers2Arg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ListTrackers2Arg)
					if !ok {
						err = rpc.NewTypeError((*[1]ListTrackers2Arg)(nil), args)
						return
					}
					ret, err = i.ListTrackers2(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"profileEdit": {
				MakeArg: func() interface{} {
					var ret [1]ProfileEditArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ProfileEditArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ProfileEditArg)(nil), args)
						return
					}
					err = i.ProfileEdit(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"interestingPeople": {
				MakeArg: func() interface{} {
					var ret [1]InterestingPeopleArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]InterestingPeopleArg)
					if !ok {
						err = rpc.NewTypeError((*[1]InterestingPeopleArg)(nil), args)
						return
					}
					ret, err = i.InterestingPeople(ctx, typedArgs[0].MaxUsers)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"meUserVersion": {
				MakeArg: func() interface{} {
					var ret [1]MeUserVersionArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]MeUserVersionArg)
					if !ok {
						err = rpc.NewTypeError((*[1]MeUserVersionArg)(nil), args)
						return
					}
					ret, err = i.MeUserVersion(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getUPAK": {
				MakeArg: func() interface{} {
					var ret [1]GetUPAKArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetUPAKArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetUPAKArg)(nil), args)
						return
					}
					ret, err = i.GetUPAK(ctx, typedArgs[0].Uid)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"uploadUserAvatar": {
				MakeArg: func() interface{} {
					var ret [1]UploadUserAvatarArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]UploadUserAvatarArg)
					if !ok {
						err = rpc.NewTypeError((*[1]UploadUserAvatarArg)(nil), args)
						return
					}
					err = i.UploadUserAvatar(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"findNextMerkleRootAfterRevoke": {
				MakeArg: func() interface{} {
					var ret [1]FindNextMerkleRootAfterRevokeArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]FindNextMerkleRootAfterRevokeArg)
					if !ok {
						err = rpc.NewTypeError((*[1]FindNextMerkleRootAfterRevokeArg)(nil), args)
						return
					}
					ret, err = i.FindNextMerkleRootAfterRevoke(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"findNextMerkleRootAfterReset": {
				MakeArg: func() interface{} {
					var ret [1]FindNextMerkleRootAfterResetArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]FindNextMerkleRootAfterResetArg)
					if !ok {
						err = rpc.NewTypeError((*[1]FindNextMerkleRootAfterResetArg)(nil), args)
						return
					}
					ret, err = i.FindNextMerkleRootAfterReset(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type UserClient struct {
	Cli rpc.GenericClient
}

func (c UserClient) ListTrackers(ctx context.Context, __arg ListTrackersArg) (res []Tracker, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.listTrackers", []interface{}{__arg}, &res)
	return
}

func (c UserClient) ListTrackersByName(ctx context.Context, __arg ListTrackersByNameArg) (res []Tracker, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.listTrackersByName", []interface{}{__arg}, &res)
	return
}

func (c UserClient) ListTrackersSelf(ctx context.Context, sessionID int) (res []Tracker, err error) {
	__arg := ListTrackersSelfArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.user.listTrackersSelf", []interface{}{__arg}, &res)
	return
}

// Load user summaries for the supplied uids.
// They are "unchecked" in that the client is not verifying the info from the server.
// If len(uids) > 500, the first 500 will be returned.
func (c UserClient) LoadUncheckedUserSummaries(ctx context.Context, __arg LoadUncheckedUserSummariesArg) (res []UserSummary, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.loadUncheckedUserSummaries", []interface{}{__arg}, &res)
	return
}

// Load a user from the server.
func (c UserClient) LoadUser(ctx context.Context, __arg LoadUserArg) (res User, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.loadUser", []interface{}{__arg}, &res)
	return
}

func (c UserClient) LoadUserByName(ctx context.Context, __arg LoadUserByNameArg) (res User, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.loadUserByName", []interface{}{__arg}, &res)
	return
}

// Load a user + device keys from the server.
func (c UserClient) LoadUserPlusKeys(ctx context.Context, __arg LoadUserPlusKeysArg) (res UserPlusKeys, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.loadUserPlusKeys", []interface{}{__arg}, &res)
	return
}

func (c UserClient) LoadUserPlusKeysV2(ctx context.Context, __arg LoadUserPlusKeysV2Arg) (res UserPlusKeysV2AllIncarnations, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.loadUserPlusKeysV2", []interface{}{__arg}, &res)
	return
}

// Load public keys for a user.
func (c UserClient) LoadPublicKeys(ctx context.Context, __arg LoadPublicKeysArg) (res []PublicKey, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.loadPublicKeys", []interface{}{__arg}, &res)
	return
}

// Load my public keys (for logged in user).
func (c UserClient) LoadMyPublicKeys(ctx context.Context, sessionID int) (res []PublicKey, err error) {
	__arg := LoadMyPublicKeysArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.user.loadMyPublicKeys", []interface{}{__arg}, &res)
	return
}

// Load user settings (for logged in user).
func (c UserClient) LoadMySettings(ctx context.Context, sessionID int) (res UserSettings, err error) {
	__arg := LoadMySettingsArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.user.loadMySettings", []interface{}{__arg}, &res)
	return
}

// The list-tracking functions get verified data from the tracking statements
// in the user's sigchain.
//
// If assertion is empty, it will use the current logged in user.
func (c UserClient) ListTracking(ctx context.Context, __arg ListTrackingArg) (res []UserSummary, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.listTracking", []interface{}{__arg}, &res)
	return
}

func (c UserClient) ListTrackingJSON(ctx context.Context, __arg ListTrackingJSONArg) (res string, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.listTrackingJSON", []interface{}{__arg}, &res)
	return
}

// Search for users who match a given query.
func (c UserClient) Search(ctx context.Context, __arg SearchArg) (res []SearchResult, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.search", []interface{}{__arg}, &res)
	return
}

// Load all the user's public keys (even those in reset key families)
// from the server with no verification
func (c UserClient) LoadAllPublicKeysUnverified(ctx context.Context, __arg LoadAllPublicKeysUnverifiedArg) (res []PublicKey, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.loadAllPublicKeysUnverified", []interface{}{__arg}, &res)
	return
}

func (c UserClient) ListTrackers2(ctx context.Context, __arg ListTrackers2Arg) (res UserSummary2Set, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.listTrackers2", []interface{}{__arg}, &res)
	return
}

func (c UserClient) ProfileEdit(ctx context.Context, __arg ProfileEditArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.profileEdit", []interface{}{__arg}, nil)
	return
}

func (c UserClient) InterestingPeople(ctx context.Context, maxUsers int) (res []InterestingPerson, err error) {
	__arg := InterestingPeopleArg{MaxUsers: maxUsers}
	err = c.Cli.Call(ctx, "keybase.1.user.interestingPeople", []interface{}{__arg}, &res)
	return
}

func (c UserClient) MeUserVersion(ctx context.Context, __arg MeUserVersionArg) (res UserVersion, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.meUserVersion", []interface{}{__arg}, &res)
	return
}

// getUPAK returns a UPAK. Used mainly for debugging.
func (c UserClient) GetUPAK(ctx context.Context, uid UID) (res UPAKVersioned, err error) {
	__arg := GetUPAKArg{Uid: uid}
	err = c.Cli.Call(ctx, "keybase.1.user.getUPAK", []interface{}{__arg}, &res)
	return
}

func (c UserClient) UploadUserAvatar(ctx context.Context, __arg UploadUserAvatarArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.uploadUserAvatar", []interface{}{__arg}, nil)
	return
}

// FindNextMerkleRootAfterRevoke finds the first Merkle Root that contains the UID/KID
// revocation at the given SigChainLocataion. The MerkleRootV2 prev is a hint as to where
// we'll start our search. Usually it's the next one, but not always
func (c UserClient) FindNextMerkleRootAfterRevoke(ctx context.Context, __arg FindNextMerkleRootAfterRevokeArg) (res NextMerkleRootRes, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.findNextMerkleRootAfterRevoke", []interface{}{__arg}, &res)
	return
}

// FindNextMerkleRootAfterReset finds the first Merkle root that contains the UID reset
// at resetSeqno. You should pass it prev, which was the last known Merkle root at the time of
// the reset. Usually, we'll just turn up the next Merkle root, but not always.
func (c UserClient) FindNextMerkleRootAfterReset(ctx context.Context, __arg FindNextMerkleRootAfterResetArg) (res NextMerkleRootRes, err error) {
	err = c.Cli.Call(ctx, "keybase.1.user.findNextMerkleRootAfterReset", []interface{}{__arg}, &res)
	return
}
