// Auto-generated by avdl-compiler v1.3.25 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/account.avdl

package keybase1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type HasServerKeysRes struct {
	HasServerKeys bool `codec:"hasServerKeys" json:"hasServerKeys"`
}

func (o HasServerKeysRes) DeepCopy() HasServerKeysRes {
	return HasServerKeysRes{
		HasServerKeys: o.HasServerKeys,
	}
}

type LockdownHistory struct {
	Status       bool     `codec:"status" json:"status"`
	CreationTime Time     `codec:"creationTime" json:"ctime"`
	DeviceID     DeviceID `codec:"deviceID" json:"device_id"`
	DeviceName   string   `codec:"deviceName" json:"deviceName"`
}

func (o LockdownHistory) DeepCopy() LockdownHistory {
	return LockdownHistory{
		Status:       o.Status,
		CreationTime: o.CreationTime.DeepCopy(),
		DeviceID:     o.DeviceID.DeepCopy(),
		DeviceName:   o.DeviceName,
	}
}

type GetLockdownResponse struct {
	History []LockdownHistory `codec:"history" json:"history"`
	Status  bool              `codec:"status" json:"status"`
}

func (o GetLockdownResponse) DeepCopy() GetLockdownResponse {
	return GetLockdownResponse{
		History: (func(x []LockdownHistory) []LockdownHistory {
			if x == nil {
				return nil
			}
			ret := make([]LockdownHistory, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.History),
		Status: o.Status,
	}
}

type PassphraseChangeArg struct {
	SessionID     int    `codec:"sessionID" json:"sessionID"`
	OldPassphrase string `codec:"oldPassphrase" json:"oldPassphrase"`
	Passphrase    string `codec:"passphrase" json:"passphrase"`
	Force         bool   `codec:"force" json:"force"`
}

type PassphrasePromptArg struct {
	SessionID int         `codec:"sessionID" json:"sessionID"`
	GuiArg    GUIEntryArg `codec:"guiArg" json:"guiArg"`
}

type EmailChangeArg struct {
	SessionID int    `codec:"sessionID" json:"sessionID"`
	NewEmail  string `codec:"newEmail" json:"newEmail"`
}

type HasServerKeysArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type ResetAccountArg struct {
	SessionID  int    `codec:"sessionID" json:"sessionID"`
	Passphrase string `codec:"passphrase" json:"passphrase"`
}

type GetLockdownModeArg struct {
	SessionID int `codec:"sessionID" json:"sessionID"`
}

type SetLockdownModeArg struct {
	SessionID int  `codec:"sessionID" json:"sessionID"`
	Enabled   bool `codec:"enabled" json:"enabled"`
}

type AccountInterface interface {
	// Change the passphrase from old to new. If old isn't set, and force is false,
	// then prompt at the UI for it. If old isn't set and force is true, then we'll
	// try to force a passphrase change.
	PassphraseChange(context.Context, PassphraseChangeArg) error
	PassphrasePrompt(context.Context, PassphrasePromptArg) (GetPassphraseRes, error)
	// * change email to the new given email by signing a statement.
	EmailChange(context.Context, EmailChangeArg) error
	// * Whether the logged-in user has uploaded private keys
	// * Will error if not logged in.
	HasServerKeys(context.Context, int) (HasServerKeysRes, error)
	// resetAccount resets the user's account; it's meant only for devel and tests.
	// passphrase is optional and will be prompted for if not supplied.
	ResetAccount(context.Context, ResetAccountArg) error
	GetLockdownMode(context.Context, int) (GetLockdownResponse, error)
	SetLockdownMode(context.Context, SetLockdownModeArg) error
}

func AccountProtocol(i AccountInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.account",
		Methods: map[string]rpc.ServeHandlerDescription{
			"passphraseChange": {
				MakeArg: func() interface{} {
					var ret [1]PassphraseChangeArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]PassphraseChangeArg)
					if !ok {
						err = rpc.NewTypeError((*[1]PassphraseChangeArg)(nil), args)
						return
					}
					err = i.PassphraseChange(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"passphrasePrompt": {
				MakeArg: func() interface{} {
					var ret [1]PassphrasePromptArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]PassphrasePromptArg)
					if !ok {
						err = rpc.NewTypeError((*[1]PassphrasePromptArg)(nil), args)
						return
					}
					ret, err = i.PassphrasePrompt(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"emailChange": {
				MakeArg: func() interface{} {
					var ret [1]EmailChangeArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]EmailChangeArg)
					if !ok {
						err = rpc.NewTypeError((*[1]EmailChangeArg)(nil), args)
						return
					}
					err = i.EmailChange(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"hasServerKeys": {
				MakeArg: func() interface{} {
					var ret [1]HasServerKeysArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]HasServerKeysArg)
					if !ok {
						err = rpc.NewTypeError((*[1]HasServerKeysArg)(nil), args)
						return
					}
					ret, err = i.HasServerKeys(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"resetAccount": {
				MakeArg: func() interface{} {
					var ret [1]ResetAccountArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]ResetAccountArg)
					if !ok {
						err = rpc.NewTypeError((*[1]ResetAccountArg)(nil), args)
						return
					}
					err = i.ResetAccount(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getLockdownMode": {
				MakeArg: func() interface{} {
					var ret [1]GetLockdownModeArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetLockdownModeArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetLockdownModeArg)(nil), args)
						return
					}
					ret, err = i.GetLockdownMode(ctx, typedArgs[0].SessionID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setLockdownMode": {
				MakeArg: func() interface{} {
					var ret [1]SetLockdownModeArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetLockdownModeArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetLockdownModeArg)(nil), args)
						return
					}
					err = i.SetLockdownMode(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type AccountClient struct {
	Cli rpc.GenericClient
}

// Change the passphrase from old to new. If old isn't set, and force is false,
// then prompt at the UI for it. If old isn't set and force is true, then we'll
// try to force a passphrase change.
func (c AccountClient) PassphraseChange(ctx context.Context, __arg PassphraseChangeArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.account.passphraseChange", []interface{}{__arg}, nil)
	return
}

func (c AccountClient) PassphrasePrompt(ctx context.Context, __arg PassphrasePromptArg) (res GetPassphraseRes, err error) {
	err = c.Cli.Call(ctx, "keybase.1.account.passphrasePrompt", []interface{}{__arg}, &res)
	return
}

// * change email to the new given email by signing a statement.
func (c AccountClient) EmailChange(ctx context.Context, __arg EmailChangeArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.account.emailChange", []interface{}{__arg}, nil)
	return
}

// * Whether the logged-in user has uploaded private keys
// * Will error if not logged in.
func (c AccountClient) HasServerKeys(ctx context.Context, sessionID int) (res HasServerKeysRes, err error) {
	__arg := HasServerKeysArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.account.hasServerKeys", []interface{}{__arg}, &res)
	return
}

// resetAccount resets the user's account; it's meant only for devel and tests.
// passphrase is optional and will be prompted for if not supplied.
func (c AccountClient) ResetAccount(ctx context.Context, __arg ResetAccountArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.account.resetAccount", []interface{}{__arg}, nil)
	return
}

func (c AccountClient) GetLockdownMode(ctx context.Context, sessionID int) (res GetLockdownResponse, err error) {
	__arg := GetLockdownModeArg{SessionID: sessionID}
	err = c.Cli.Call(ctx, "keybase.1.account.getLockdownMode", []interface{}{__arg}, &res)
	return
}

func (c AccountClient) SetLockdownMode(ctx context.Context, __arg SetLockdownModeArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.account.setLockdownMode", []interface{}{__arg}, nil)
	return
}
