package testserver

import (
	"testing"

	"github.com/gorilla/mux"
)

var hubRoutes = []route{
	{"/api/plugins/{owner}/{id}", handleHubPlugin},
	{"/api/plugins/{owner}/{id}/versions/{version}", handleHubPluginVersion},
	{"/api/plugins/{owner}/{id}/versions/{version}/{archive}", handleHubPluginArchive},
}

func NewHubRouter(t *testing.T) *mux.Router {
	router := mux.NewRouter()
	router.Use(defaultHeaderMiddleware)

	for _, route := range hubRoutes {
		router.HandleFunc(route.path, route.handler(t))
	}

	return router
}
