package actions

import (
	"fmt"

	"github.com/MakeNowJust/heredoc"
	"github.com/cli/cli/pkg/cmdutil"
	"github.com/cli/cli/pkg/iostreams"
	"github.com/spf13/cobra"
)

func NewCmdActions(f *cmdutil.Factory) *cobra.Command {
	cs := f.IOStreams.ColorScheme()

	cmd := &cobra.Command{
		Use:   "actions",
		Short: "Learn about working with GitHub actions",
		Long:  actionsExplainer(cs),
		Run: func(cmd *cobra.Command, args []string) {
			fmt.Fprintln(f.IOStreams.Out, actionsExplainer(cs))
		},
		Annotations: map[string]string{
			"IsActions": "true",
		},
	}

	cmdutil.DisableAuthCheck(cmd)

	return cmd
}

func actionsExplainer(cs *iostreams.ColorScheme) string {
	header := cs.Bold("Welcome to GitHub Actions on the command line.")
	runHeader := cs.Bold("Interacting with workflow runs")
	workflowHeader := cs.Bold("Interacting with workflow files")

	return heredoc.Docf(`
			%s

			GitHub CLI integrates with Actions to help you manage runs and workflows.

			%s  
			gh run list:      List recent workflow runs  
			gh run view:      View details for a workflow run or one of its jobs  
			gh run watch:     Watch a workflow run while it executes  
			gh run rerun:     Rerun a failed workflow run  
			gh run download:  Download artifacts generated by runs

			To see more help, run 'gh help run <subcommand>'

			%s  
			gh workflow list:     List all the workflow files in your repository  
			gh workflow view:     View details for a workflow file  
			gh workflow enable:   Enable a workflow file  
			gh workflow disable:  Disable a workflow file  
			gh workflow run:      Trigger a workflow_dispatch run for a workflow file

			To see more help, run 'gh help workflow <subcommand>'

			For more in depth help including examples, see online documentation at:
			<https://docs.github.com/en/actions/guides/managing-github-actions-with-github-cli>
		`, header, runHeader, workflowHeader)
}
