/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by injection-gen. DO NOT EDIT.

package client

import (
	context "context"
	json "encoding/json"
	errors "errors"
	fmt "fmt"

	v1alpha1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1alpha1"
	v1beta1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1"
	versioned "github.com/tektoncd/triggers/pkg/client/clientset/versioned"
	typedtriggersv1alpha1 "github.com/tektoncd/triggers/pkg/client/clientset/versioned/typed/triggers/v1alpha1"
	typedtriggersv1beta1 "github.com/tektoncd/triggers/pkg/client/clientset/versioned/typed/triggers/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	unstructured "k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	runtime "k8s.io/apimachinery/pkg/runtime"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	discovery "k8s.io/client-go/discovery"
	dynamic "k8s.io/client-go/dynamic"
	rest "k8s.io/client-go/rest"
	injection "knative.dev/pkg/injection"
	dynamicclient "knative.dev/pkg/injection/clients/dynamicclient"
	logging "knative.dev/pkg/logging"
)

func init() {
	injection.Default.RegisterClient(withClientFromConfig)
	injection.Default.RegisterClientFetcher(func(ctx context.Context) interface{} {
		return Get(ctx)
	})
	injection.Dynamic.RegisterDynamicClient(withClientFromDynamic)
}

// Key is used as the key for associating information with a context.Context.
type Key struct{}

func withClientFromConfig(ctx context.Context, cfg *rest.Config) context.Context {
	return context.WithValue(ctx, Key{}, versioned.NewForConfigOrDie(cfg))
}

func withClientFromDynamic(ctx context.Context) context.Context {
	return context.WithValue(ctx, Key{}, &wrapClient{dyn: dynamicclient.Get(ctx)})
}

// Get extracts the versioned.Interface client from the context.
func Get(ctx context.Context) versioned.Interface {
	untyped := ctx.Value(Key{})
	if untyped == nil {
		if injection.GetConfig(ctx) == nil {
			logging.FromContext(ctx).Panic(
				"Unable to fetch github.com/tektoncd/triggers/pkg/client/clientset/versioned.Interface from context. This context is not the application context (which is typically given to constructors via sharedmain).")
		} else {
			logging.FromContext(ctx).Panic(
				"Unable to fetch github.com/tektoncd/triggers/pkg/client/clientset/versioned.Interface from context.")
		}
	}
	return untyped.(versioned.Interface)
}

type wrapClient struct {
	dyn dynamic.Interface
}

var _ versioned.Interface = (*wrapClient)(nil)

func (w *wrapClient) Discovery() discovery.DiscoveryInterface {
	panic("Discovery called on dynamic client!")
}

func convert(from interface{}, to runtime.Object) error {
	bs, err := json.Marshal(from)
	if err != nil {
		return fmt.Errorf("Marshal() = %w", err)
	}
	if err := json.Unmarshal(bs, to); err != nil {
		return fmt.Errorf("Unmarshal() = %w", err)
	}
	return nil
}

// TriggersV1alpha1 retrieves the TriggersV1alpha1Client
func (w *wrapClient) TriggersV1alpha1() typedtriggersv1alpha1.TriggersV1alpha1Interface {
	return &wrapTriggersV1alpha1{
		dyn: w.dyn,
	}
}

type wrapTriggersV1alpha1 struct {
	dyn dynamic.Interface
}

func (w *wrapTriggersV1alpha1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapTriggersV1alpha1) ClusterInterceptors() typedtriggersv1alpha1.ClusterInterceptorInterface {
	return &wrapTriggersV1alpha1ClusterInterceptorImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1alpha1",
			Resource: "clusterinterceptors",
		}),
	}
}

type wrapTriggersV1alpha1ClusterInterceptorImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedtriggersv1alpha1.ClusterInterceptorInterface = (*wrapTriggersV1alpha1ClusterInterceptorImpl)(nil)

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) Create(ctx context.Context, in *v1alpha1.ClusterInterceptor, opts v1.CreateOptions) (*v1alpha1.ClusterInterceptor, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "ClusterInterceptor",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterInterceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterInterceptor, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterInterceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterInterceptorList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterInterceptorList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterInterceptor, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterInterceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) Update(ctx context.Context, in *v1alpha1.ClusterInterceptor, opts v1.UpdateOptions) (*v1alpha1.ClusterInterceptor, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "ClusterInterceptor",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterInterceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) UpdateStatus(ctx context.Context, in *v1alpha1.ClusterInterceptor, opts v1.UpdateOptions) (*v1alpha1.ClusterInterceptor, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "ClusterInterceptor",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterInterceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterInterceptorImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1alpha1) ClusterTriggerBindings() typedtriggersv1alpha1.ClusterTriggerBindingInterface {
	return &wrapTriggersV1alpha1ClusterTriggerBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1alpha1",
			Resource: "clustertriggerbindings",
		}),
	}
}

type wrapTriggersV1alpha1ClusterTriggerBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedtriggersv1alpha1.ClusterTriggerBindingInterface = (*wrapTriggersV1alpha1ClusterTriggerBindingImpl)(nil)

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) Create(ctx context.Context, in *v1alpha1.ClusterTriggerBinding, opts v1.CreateOptions) (*v1alpha1.ClusterTriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "ClusterTriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterTriggerBinding, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterTriggerBindingList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterTriggerBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterTriggerBinding, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) Update(ctx context.Context, in *v1alpha1.ClusterTriggerBinding, opts v1.UpdateOptions) (*v1alpha1.ClusterTriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "ClusterTriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) UpdateStatus(ctx context.Context, in *v1alpha1.ClusterTriggerBinding, opts v1.UpdateOptions) (*v1alpha1.ClusterTriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "ClusterTriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1ClusterTriggerBindingImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1alpha1) EventListeners(namespace string) typedtriggersv1alpha1.EventListenerInterface {
	return &wrapTriggersV1alpha1EventListenerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1alpha1",
			Resource: "eventlisteners",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1alpha1EventListenerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1alpha1.EventListenerInterface = (*wrapTriggersV1alpha1EventListenerImpl)(nil)

func (w *wrapTriggersV1alpha1EventListenerImpl) Create(ctx context.Context, in *v1alpha1.EventListener, opts v1.CreateOptions) (*v1alpha1.EventListener, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "EventListener",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1EventListenerImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1alpha1EventListenerImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1alpha1EventListenerImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.EventListener, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1EventListenerImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.EventListenerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.EventListenerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1EventListenerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.EventListener, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1EventListenerImpl) Update(ctx context.Context, in *v1alpha1.EventListener, opts v1.UpdateOptions) (*v1alpha1.EventListener, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "EventListener",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1EventListenerImpl) UpdateStatus(ctx context.Context, in *v1alpha1.EventListener, opts v1.UpdateOptions) (*v1alpha1.EventListener, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "EventListener",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1EventListenerImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1alpha1) Interceptors(namespace string) typedtriggersv1alpha1.InterceptorInterface {
	return &wrapTriggersV1alpha1InterceptorImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1alpha1",
			Resource: "interceptors",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1alpha1InterceptorImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1alpha1.InterceptorInterface = (*wrapTriggersV1alpha1InterceptorImpl)(nil)

func (w *wrapTriggersV1alpha1InterceptorImpl) Create(ctx context.Context, in *v1alpha1.Interceptor, opts v1.CreateOptions) (*v1alpha1.Interceptor, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "Interceptor",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Interceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1InterceptorImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1alpha1InterceptorImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1alpha1InterceptorImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.Interceptor, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Interceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1InterceptorImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.InterceptorList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.InterceptorList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1InterceptorImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Interceptor, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Interceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1InterceptorImpl) Update(ctx context.Context, in *v1alpha1.Interceptor, opts v1.UpdateOptions) (*v1alpha1.Interceptor, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "Interceptor",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Interceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1InterceptorImpl) UpdateStatus(ctx context.Context, in *v1alpha1.Interceptor, opts v1.UpdateOptions) (*v1alpha1.Interceptor, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "Interceptor",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Interceptor{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1InterceptorImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1alpha1) Triggers(namespace string) typedtriggersv1alpha1.TriggerInterface {
	return &wrapTriggersV1alpha1TriggerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1alpha1",
			Resource: "triggers",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1alpha1TriggerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1alpha1.TriggerInterface = (*wrapTriggersV1alpha1TriggerImpl)(nil)

func (w *wrapTriggersV1alpha1TriggerImpl) Create(ctx context.Context, in *v1alpha1.Trigger, opts v1.CreateOptions) (*v1alpha1.Trigger, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "Trigger",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1alpha1TriggerImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1alpha1TriggerImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.Trigger, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TriggerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Trigger, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerImpl) Update(ctx context.Context, in *v1alpha1.Trigger, opts v1.UpdateOptions) (*v1alpha1.Trigger, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "Trigger",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerImpl) UpdateStatus(ctx context.Context, in *v1alpha1.Trigger, opts v1.UpdateOptions) (*v1alpha1.Trigger, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "Trigger",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1alpha1) TriggerBindings(namespace string) typedtriggersv1alpha1.TriggerBindingInterface {
	return &wrapTriggersV1alpha1TriggerBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1alpha1",
			Resource: "triggerbindings",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1alpha1TriggerBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1alpha1.TriggerBindingInterface = (*wrapTriggersV1alpha1TriggerBindingImpl)(nil)

func (w *wrapTriggersV1alpha1TriggerBindingImpl) Create(ctx context.Context, in *v1alpha1.TriggerBinding, opts v1.CreateOptions) (*v1alpha1.TriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "TriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.TriggerBinding, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TriggerBindingList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TriggerBinding, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) Update(ctx context.Context, in *v1alpha1.TriggerBinding, opts v1.UpdateOptions) (*v1alpha1.TriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "TriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) UpdateStatus(ctx context.Context, in *v1alpha1.TriggerBinding, opts v1.UpdateOptions) (*v1alpha1.TriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "TriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerBindingImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1alpha1) TriggerTemplates(namespace string) typedtriggersv1alpha1.TriggerTemplateInterface {
	return &wrapTriggersV1alpha1TriggerTemplateImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1alpha1",
			Resource: "triggertemplates",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1alpha1TriggerTemplateImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1alpha1.TriggerTemplateInterface = (*wrapTriggersV1alpha1TriggerTemplateImpl)(nil)

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) Create(ctx context.Context, in *v1alpha1.TriggerTemplate, opts v1.CreateOptions) (*v1alpha1.TriggerTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "TriggerTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.TriggerTemplate, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TriggerTemplateList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerTemplateList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TriggerTemplate, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) Update(ctx context.Context, in *v1alpha1.TriggerTemplate, opts v1.UpdateOptions) (*v1alpha1.TriggerTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "TriggerTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) UpdateStatus(ctx context.Context, in *v1alpha1.TriggerTemplate, opts v1.UpdateOptions) (*v1alpha1.TriggerTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1alpha1",
		Kind:    "TriggerTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1alpha1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1alpha1TriggerTemplateImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

// TriggersV1beta1 retrieves the TriggersV1beta1Client
func (w *wrapClient) TriggersV1beta1() typedtriggersv1beta1.TriggersV1beta1Interface {
	return &wrapTriggersV1beta1{
		dyn: w.dyn,
	}
}

type wrapTriggersV1beta1 struct {
	dyn dynamic.Interface
}

func (w *wrapTriggersV1beta1) RESTClient() rest.Interface {
	panic("RESTClient called on dynamic client!")
}

func (w *wrapTriggersV1beta1) ClusterTriggerBindings() typedtriggersv1beta1.ClusterTriggerBindingInterface {
	return &wrapTriggersV1beta1ClusterTriggerBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1beta1",
			Resource: "clustertriggerbindings",
		}),
	}
}

type wrapTriggersV1beta1ClusterTriggerBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface
}

var _ typedtriggersv1beta1.ClusterTriggerBindingInterface = (*wrapTriggersV1beta1ClusterTriggerBindingImpl)(nil)

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) Create(ctx context.Context, in *v1beta1.ClusterTriggerBinding, opts v1.CreateOptions) (*v1beta1.ClusterTriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "ClusterTriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Delete(ctx, name, opts)
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.ClusterTriggerBinding, error) {
	uo, err := w.dyn.Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ClusterTriggerBindingList, error) {
	uo, err := w.dyn.List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterTriggerBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ClusterTriggerBinding, err error) {
	uo, err := w.dyn.Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) Update(ctx context.Context, in *v1beta1.ClusterTriggerBinding, opts v1.UpdateOptions) (*v1beta1.ClusterTriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "ClusterTriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) UpdateStatus(ctx context.Context, in *v1beta1.ClusterTriggerBinding, opts v1.UpdateOptions) (*v1beta1.ClusterTriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "ClusterTriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.ClusterTriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1ClusterTriggerBindingImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1beta1) EventListeners(namespace string) typedtriggersv1beta1.EventListenerInterface {
	return &wrapTriggersV1beta1EventListenerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1beta1",
			Resource: "eventlisteners",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1beta1EventListenerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1beta1.EventListenerInterface = (*wrapTriggersV1beta1EventListenerImpl)(nil)

func (w *wrapTriggersV1beta1EventListenerImpl) Create(ctx context.Context, in *v1beta1.EventListener, opts v1.CreateOptions) (*v1beta1.EventListener, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "EventListener",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1EventListenerImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1beta1EventListenerImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1beta1EventListenerImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.EventListener, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1EventListenerImpl) List(ctx context.Context, opts v1.ListOptions) (*v1beta1.EventListenerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.EventListenerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1EventListenerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.EventListener, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1EventListenerImpl) Update(ctx context.Context, in *v1beta1.EventListener, opts v1.UpdateOptions) (*v1beta1.EventListener, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "EventListener",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1EventListenerImpl) UpdateStatus(ctx context.Context, in *v1beta1.EventListener, opts v1.UpdateOptions) (*v1beta1.EventListener, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "EventListener",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.EventListener{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1EventListenerImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1beta1) Triggers(namespace string) typedtriggersv1beta1.TriggerInterface {
	return &wrapTriggersV1beta1TriggerImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1beta1",
			Resource: "triggers",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1beta1TriggerImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1beta1.TriggerInterface = (*wrapTriggersV1beta1TriggerImpl)(nil)

func (w *wrapTriggersV1beta1TriggerImpl) Create(ctx context.Context, in *v1beta1.Trigger, opts v1.CreateOptions) (*v1beta1.Trigger, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "Trigger",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1beta1TriggerImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1beta1TriggerImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.Trigger, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerImpl) List(ctx context.Context, opts v1.ListOptions) (*v1beta1.TriggerList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Trigger, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerImpl) Update(ctx context.Context, in *v1beta1.Trigger, opts v1.UpdateOptions) (*v1beta1.Trigger, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "Trigger",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerImpl) UpdateStatus(ctx context.Context, in *v1beta1.Trigger, opts v1.UpdateOptions) (*v1beta1.Trigger, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "Trigger",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.Trigger{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1beta1) TriggerBindings(namespace string) typedtriggersv1beta1.TriggerBindingInterface {
	return &wrapTriggersV1beta1TriggerBindingImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1beta1",
			Resource: "triggerbindings",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1beta1TriggerBindingImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1beta1.TriggerBindingInterface = (*wrapTriggersV1beta1TriggerBindingImpl)(nil)

func (w *wrapTriggersV1beta1TriggerBindingImpl) Create(ctx context.Context, in *v1beta1.TriggerBinding, opts v1.CreateOptions) (*v1beta1.TriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "TriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.TriggerBinding, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) List(ctx context.Context, opts v1.ListOptions) (*v1beta1.TriggerBindingList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerBindingList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.TriggerBinding, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) Update(ctx context.Context, in *v1beta1.TriggerBinding, opts v1.UpdateOptions) (*v1beta1.TriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "TriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) UpdateStatus(ctx context.Context, in *v1beta1.TriggerBinding, opts v1.UpdateOptions) (*v1beta1.TriggerBinding, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "TriggerBinding",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerBinding{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerBindingImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}

func (w *wrapTriggersV1beta1) TriggerTemplates(namespace string) typedtriggersv1beta1.TriggerTemplateInterface {
	return &wrapTriggersV1beta1TriggerTemplateImpl{
		dyn: w.dyn.Resource(schema.GroupVersionResource{
			Group:    "triggers.tekton.dev",
			Version:  "v1beta1",
			Resource: "triggertemplates",
		}),

		namespace: namespace,
	}
}

type wrapTriggersV1beta1TriggerTemplateImpl struct {
	dyn dynamic.NamespaceableResourceInterface

	namespace string
}

var _ typedtriggersv1beta1.TriggerTemplateInterface = (*wrapTriggersV1beta1TriggerTemplateImpl)(nil)

func (w *wrapTriggersV1beta1TriggerTemplateImpl) Create(ctx context.Context, in *v1beta1.TriggerTemplate, opts v1.CreateOptions) (*v1beta1.TriggerTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "TriggerTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Create(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return w.dyn.Namespace(w.namespace).Delete(ctx, name, opts)
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	return w.dyn.Namespace(w.namespace).DeleteCollection(ctx, opts, listOpts)
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.TriggerTemplate, error) {
	uo, err := w.dyn.Namespace(w.namespace).Get(ctx, name, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) List(ctx context.Context, opts v1.ListOptions) (*v1beta1.TriggerTemplateList, error) {
	uo, err := w.dyn.Namespace(w.namespace).List(ctx, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerTemplateList{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.TriggerTemplate, err error) {
	uo, err := w.dyn.Namespace(w.namespace).Patch(ctx, name, pt, data, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) Update(ctx context.Context, in *v1beta1.TriggerTemplate, opts v1.UpdateOptions) (*v1beta1.TriggerTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "TriggerTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).Update(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) UpdateStatus(ctx context.Context, in *v1beta1.TriggerTemplate, opts v1.UpdateOptions) (*v1beta1.TriggerTemplate, error) {
	in.SetGroupVersionKind(schema.GroupVersionKind{
		Group:   "triggers.tekton.dev",
		Version: "v1beta1",
		Kind:    "TriggerTemplate",
	})
	uo := &unstructured.Unstructured{}
	if err := convert(in, uo); err != nil {
		return nil, err
	}
	uo, err := w.dyn.Namespace(w.namespace).UpdateStatus(ctx, uo, opts)
	if err != nil {
		return nil, err
	}
	out := &v1beta1.TriggerTemplate{}
	if err := convert(uo, out); err != nil {
		return nil, err
	}
	return out, nil
}

func (w *wrapTriggersV1beta1TriggerTemplateImpl) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return nil, errors.New("NYI: Watch")
}
